#!/bin/sh
#
# Copyright (C) 2019 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#

#
# File: prepare-debugfs-and-gpu-environment
#
# Description: script prepare debugfs and
# GPU environment for VTune(TM) Amplifier XE.
#
# Version: 1.0
#
default_user=
debugfs_group="vtune"
set_user=0
scripts="prepare-gpu-hardware-metrics.sh prepare-debugfs.sh"
command=""
dir=`dirname $0`
install=""
# help
print_usage_and_exit()
{
    err=${1:-0}
    echo ""
    echo "Usage: $0 [ option ]"
    echo ""
    echo "    -u | --user <user>"
    echo "      Specifies the user of the environment to be configured."
    echo ""
    echo "    -g | --group <group>"
    echo "      Specifies the group other than '$debugfs_group' to access debugFS."
    echo ""
    echo "    -i | --install"
    echo "      Configures the autoload debugfs boot script and then installs it to the"
    echo "      appropriate system directory and sets "
    echo "      /proc/sys/dev/i915/perf_stream_paranoid=0 permanently."
    echo ""
    echo "This script configures debugFS and makes GPU hardware metrics available."
    echo ""
    exit $err
}

# help.
if [ $# -eq 1 ] ; then
    case "$1" in
        -h | --help)
            print_usage_and_exit 0
        ;;
    esac
fi

# parse the options
while [ $# -gt 0 ] ; do
    case "$1" in
        -u | --user)
            default_user="$2"
            set_user=1
            shift
        ;;
        -g | --group)
            debugfs_group="$2"
            shift
        ;;
        -i | --install)
            install="--install"
            ;;
        *)
            echo ""
            echo "ERROR: unrecognized option $1"
            print_usage_and_exit 3
        ;;
    esac
    shift
done

if [ ${set_user} -eq 0 ] ; then
    echo "Enter the user name that requires permissions:"
    while read answers && [ -z "$answers" ];
    do
        echo "ERROR: "
        echo "The user name cannot be empty."
    done
default_user=${answers}
fi

if [ -z ${install} ] ; then
    echo "Are you configurig environment"
    echo "(t)emporarily or (p)ermanently?"
    while read answers && ( [ "t" != "$answers" ] && [ "p" != "$answers" ])
    do 
        echo "ERROR input ${answers} "
        echo "Enter 'p' to mount permanently or 't' to mount temporarily." 
    done
    if [ "$answers" = "p" ] ; then
        install="--install"
        echo 'Selected: permanently.'
    fi
    if [ "$answers" = "t" ] ; then
        echo 'Selected: temporarily.'
    fi
fi


for i in ${scripts} ; do
    case "$i" in
        "prepare-gpu-hardware-metrics.sh")
            command="${command} /bin/sh  ${dir}/${i} -u ${default_user} ${install} && "
        ;;
        "prepare-debugfs.sh")
            command="${command} /bin/sh  ${dir}/${i} --user ${default_user} ${install} -g ${debugfs_group} && "
        ;;
        *)
            command="${command} /bin/sh  ${dir}/${i} && "
        ;;
    esac
done

command=${command%???}

if [ -z "${BUSYBOX_SHELL}" ] ; then
    if [ "root" != "${USER}" ] ; then
        if [ ! -w /dev ] ; then
            echo "NOTE:  super-user or \"root\" privileges are required in order to continue."
            echo "Please enter \"root\" "
            exec su -c  "${command}"
            echo ""
            exit 0
        fi
    fi
fi
exec su -c "${command}"