!===============================================================================
! Copyright (C) 2003 Intel Corporation
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!  Content:
!    viRngUniformBits64  Example Program Text
!*******************************************************************************

      include 'mkl_vsl.f90'
      include "errcheck.inc"

      program MKL_VSL_TEST

      USE MKL_VSL_TYPE
      USE MKL_VSL

      integer(kind=4) i,nn
      integer n
      integer(kind=4) errcode

      integer(kind=8) r(1000)
      integer brng,method,seed

      TYPE (VSL_STREAM_STATE) :: stream

      EXTERNAL :: CheckVslError

      n=1000
      nn=10

      brng=VSL_BRNG_MCG59
      method=VSL_RNG_METHOD_UNIFORMBITS64_STD
      seed=1

!     ***** Initialize *****
      errcode=vslnewstream( stream, brng,  seed )
      call CheckVslError(errcode)

!     ***** Call RNG *****
      errcode=virnguniformbits64( method, stream, n, r )
      call CheckVslError(errcode)

!     ***** Printing results *****
      print *,"Sample of viRngUniformBits64."
      print *,"---------------------------"
      print *,""
      print *,"Results (first 10 of 1000):"
      print *,"---------------------------"
      do i=1,nn
        print 10,r(i)
      end do

!     ***** Deinitialize *****
      errcode=vsldeletestream( stream )
      call CheckVslError(errcode)

10    format(I20)
12    format(A,F5.2,A,F5.2,A,F5.2,A,F5.2,A)

      end
