from apm_helpers.decorator import cached_cls_row_prop,cached_by_params
_mem_object_struct={'allocation_id':{'def_val':'0'},'size':{'def_val':0,'formatter':lambda x:int(x or 0)},'allocation_type':{'def_val':'heap'},'address':{'def_val':'0','formatter':lambda x:hex(int(x or 0))},'source_location':{'def_val':'unknown'},'transfer_direction':{'def_val':'unknown'}}
def _process_mem_object(obj):
 def_formatter=lambda x:x
 struct=_mem_object_struct
 keys={key for key in obj}
 keys.update(struct.keys())
 obj={k:struct.get(k,{}).get('formatter',def_formatter)(obj[k]if k in obj else struct[k]['def_val'])for k in keys}
 return obj
_region_specific_keys=['transfer_direction','access_order']
class MemObjectsStorage:
 def __init__(self):
  self._objects={}
 def add(self,obj):
  key=obj['allocation_id']
  if not key in self._objects:
   self._objects[key]={k:v for k,v in obj.items()if k not in _region_specific_keys}
  return key
 def values(self):
  return self._objects
class MemoryObjectsManager:
 def __init__(self):
  self._storage=MemObjectsStorage()
 def get_processed_objects(self):
  return self._storage.values()
 @cached_cls_row_prop
 def process_objects(self,row):
  res=[]
  for obj in row.memory_objects:
   res_obj=_process_mem_object(obj)
   self._storage.add(res_obj)
   res.append(res_obj)
  getKey=lambda obj:(obj['allocation_id'],)+tuple(obj.get(key,'')for key in _region_specific_keys)
  return sorted(res,key=getKey)
def get_memory_objects_info(row,mem_objects_mgr,config):
 if not row or not mem_objects_mgr:
  return None
 cfg=config['ui_settings'].get('memory_objects',None)
 if not cfg:
  return None
 info=cfg['info_in_loop']
 keys=info['mem_obj_data_keys']
 data_separator=info['mem_obj_data_separator']
 mem_obj_separator=info['mem_obj_separator']
 pattern=data_separator.join('%({})s'.format(key)for key in keys)
 return mem_obj_separator.join(pattern%obj for obj in mem_objects_mgr.process_objects(row))
