#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to perform various actions regarding the markup of
# loops.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)

# Access the entries in the bottomup table and markup loops.
rows = list(data.bottomup)
print("Number of hotspots: {}".format(len(rows)))
# Number of selected loops is join of all selected loops
print("Number of selected loops: {}\n".format(project.mark_up_len))

if len(rows) > 2:

    print("Select first two loops...")
    project.mark_up_select(rows[:2])
    print("Number of Selected Loops: {}\n".format(project.mark_up_len))

    print("Remove one loop from the selection...")
    project.mark_up_remove(rows[:1])
    print("Number of Selected Loops: {}\n".format(project.mark_up_len))

    print("Append two loops to the selection...")
    project.mark_up_append(rows[:1])
    project.mark_up_append(rows[2:3])
    print("Number of Selected Loops: {}\n".format(project.mark_up_len))

    print("Clear the selection...")
    project.mark_up_clear()
    print("Number of selected loops: {}".format(project.mark_up_len))

    print("Select for flops only")
    project.mark_up_select_for_target(rows, advisor.SelectionTarget.FLOPS)
    print("Number of selected loops: {}".format(project.mark_up_len))

    print("Clear the selection")
    project.mark_up_clear()
    print("Number of selected loops: {}".format(project.mark_up_len))

    # Separate markup. Possible selections:
    # discpythonapi.CollectingFeature.TRIPCOUNTS
    # discpythonapi.CollectingFeature.FLOPS
    # discpythonapi.CollectingFeature.CACHESIM
    # discpythonapi.CollectingFeature.DATA_TRANSFER
    # discpythonapi.CollectingFeature.Map
    # discpythonapi.CollectingFeature.DEPENDENCY
    # discpythonapi.CollectingFeature.PROJECTION
    # discpythonapi.CollectingFeature.ALL
    print("Select for flops and cachesim only")
    project.mark_up_select_for_target(rows, advisor.SelectionTarget.FLOPS | advisor.SelectionTarget.CACHESIM)
    print("Number of selected loops: {}".format(project.mark_up_len))
