/*
 * Copyright (C) 2015 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

/* eslint-disable strict */
'use strict';

window.intel = {software: { analyzers : { }}}

angular.module('htmlui', [
    'authentication',
    'ui',
    'admin-dashboard',
    'extension-ui',
    'saas-ui',
    'result',
    'jsdiagram',
    'diagrampane',
    'summary',
    'filterbar',
    'gridpanes',
    'timelinepane',
    'collectionpane',
    'sourcepane',
    'errorpane',
    'externalpane',
    'welcomepane',
    'styleCheatSheet',
    'error-handling',
    'ngRoute',
    'ngSanitize' // This service is needed for safe HTML-templates binding. Do not remove it!!!
])
    .config(($locationProvider, $httpProvider, $qProvider) => {
        $locationProvider.html5Mode(true);
        // When requests are loaded, they will schedule a deferred 'apply' on the next tick, giving
        // time for subsequent requests in a roughly ~10ms window to load and share the same
        // digest cycle
        $httpProvider.useApplyAsync(true);
        // Correct cancelled requests handling: we decided to switch from 499 HTTP status code to
        // 202, cause 499 code provide great amount of errors in browser console. Since the 202 code
        // is a successful code, we need to manually reject the http promise response, so that our
        // components can handle that situation properly
        $httpProvider.interceptors.push(() => ({
            'response': response => {
                if (response.status === 202) {
                    return Promise.reject(response);
                } else {
                    return response;
                }
            },
            'request': config => {
                // Don't modify headers in case of requests to software.intel.com to allow CORS
                if (config.url && config.url.includes('software.intel.com')) return config;

                return config;
            }
        }));

        // Handle 401 'Unauthorized' response
        $httpProvider.interceptors.push($location => ({
            responseError: response => {
                const { data } = response;
                // Received 401 (Authentication required) response.
                // If passphrase is not yet configured on the server -
                //            redirect to 'Set passphrase' page.
                // Passphrase is configured - redirect to login page.
                if (response.status === 401 &&
                    data.type === 'passphrase') {
                    if (data.isPassphraseConfigured) {
                        $location.path('/login/passphrase');
                    } else {
                        $location.path('/set/passphrase');
                    }
                    return response;
                }
                // Too many attempts
                if (response.status === 429) {
                    $location.path('/login/failure');
                }

                return Promise.reject(response);
            }
        }));

        function getCookie(name) {
            const matches = document.cookie.match(new RegExp('(?:^|; )' + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + '=([^;]*)'));
            return matches ? decodeURIComponent(matches[1]) : undefined;
        }

        // TODO: handle rejected $q promises in all panes correctly
        // Since update of AngularJS version to 1.6.9 we've started to receive notifications about
        // rejected $q promises. Most of them are related to cancelled requests. Possibly, we'll
        // clean up our components, but for now, we just disabled those errors
        $qProvider.errorOnUnhandledRejections(false);

        _.templateSettings.interpolate = /\[%=([\s\S]+?)%\]/g;

        if (window.el)
        {
            document.addEventListener('keydown', event => {
                if ((event.metaKey || event.ctrlKey) &&
                    event.shiftKey &&
                    event.keyCode === 90 /* Z */) {
                    window.el.toggleDevTools();
                }
            });

            window.onerror = window.el.logError;
        }

        window.d3_main = window.d3;
    });
