/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\n\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/MavenVersionSupportUtil;", "", "<init>", "()V", "MAVEN_2_PLUGIN_ID", "", "getExtensionFor", "Lorg/jetbrains/idea/maven/MavenVersionAwareSupportExtension;", "distribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "isMaven2PluginInstalled", "", "isMaven2PluginInstalled$annotations", "()Z", "isMaven2PluginDisabled", "isMaven2PluginDisabled$annotations", "isMaven2Used", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenVersionSupportUtil {
    @NotNull
    public static final MavenVersionSupportUtil INSTANCE = new MavenVersionSupportUtil();
    @NotNull
    public static final String MAVEN_2_PLUGIN_ID = "org.jetbrains.idea.maven.maven2-support";

    private MavenVersionSupportUtil() {
    }

    @Nullable
    public final MavenVersionAwareSupportExtension getExtensionFor(@NotNull MavenDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        return (MavenVersionAwareSupportExtension)MavenVersionAwareSupportExtension.Companion.getMAVEN_VERSION_SUPPORT().findFirstSafe(arg_0 -> MavenVersionSupportUtil.getExtensionFor$lambda$1(arg_0 -> MavenVersionSupportUtil.getExtensionFor$lambda$0(distribution, arg_0), arg_0));
    }

    public static final boolean isMaven2PluginInstalled() {
        return PluginManager.isPluginInstalled((PluginId)PluginId.Companion.getId(MAVEN_2_PLUGIN_ID));
    }

    @JvmStatic
    public static /* synthetic */ void isMaven2PluginInstalled$annotations() {
    }

    public static final boolean isMaven2PluginDisabled() {
        return MavenVersionSupportUtil.isMaven2PluginInstalled() && PluginManagerCore.isDisabled((PluginId)PluginId.Companion.getId(MAVEN_2_PLUGIN_ID));
    }

    @JvmStatic
    public static /* synthetic */ void isMaven2PluginDisabled$annotations() {
    }

    public final boolean isMaven2Used(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String version = MavenDistributionsCache.getInstance(project).getSettingsDistribution().getVersion();
        if (version == null) {
            return false;
        }
        return StringUtil.compareVersionNumbers((String)version, (String)"3") < 0;
    }

    private static final boolean getExtensionFor$lambda$0(MavenDistribution $distribution, MavenVersionAwareSupportExtension e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        File file2 = $distribution.getMavenHome().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return e.isSupportedByExtension(file2);
    }

    private static final boolean getExtensionFor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

