/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.AbstractTrie;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.MathUtils;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int MAX_CAPACITY = 65534;
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int capacity) {
        super(true);
        if (capacity > 65534) {
            throw new IllegalArgumentException("Capacity " + capacity + " > " + 65534);
        }
        this._value = new Object[capacity + 1];
        this._rowIndex = new char[(capacity + 1) * 32];
        this._key = new String[capacity + 1];
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._rowIndex, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String s2, V v) {
        int t2 = 0;
        int limit = s2.length();
        if (limit > 65534) {
            return false;
        }
        for (int k = 0; k < limit; ++k) {
            char c = s2.charAt(k);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                if ((t2 = this._rowIndex[idx]) != 0) continue;
                this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
                if (this._rows == this._value.length) {
                    return false;
                }
                this._rowIndex[idx] = this._rows;
                t2 = this._rowIndex[idx];
                continue;
            }
            if (c > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (t2 >= this._bigIndex.length) {
                return false;
            }
            char[] big = this._bigIndex[t2];
            if (big == null) {
                this._bigIndex[t2] = new char[128];
                big = this._bigIndex[t2];
            }
            if ((t2 = big[c]) != 0) continue;
            this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
            if (this._rows == this._value.length) {
                return false;
            }
            big[c] = this._rows;
            t2 = big[c];
        }
        if (t2 >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[t2] = v == null ? null : s2;
        this._value[t2] = v;
        return true;
    }

    @Override
    public V get(String s2, int offset, int len) {
        int t2 = 0;
        for (int i = 0; i < len; ++i) {
            char[] big;
            char c = s2.charAt(offset + i);
            if (c > '\u007f') {
                return null;
            }
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                if ((t2 = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
            if (big == null) {
                return null;
            }
            t2 = big[c & 0x7F];
            if (t2 != 0) continue;
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        int t2 = 0;
        for (int i = 0; i < len; ++i) {
            char[] big;
            byte c = b.get(offset + i);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                if ((t2 = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
            if (big == null) {
                return null;
            }
            t2 = big[c];
            if (t2 != 0) continue;
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V getBest(byte[] b, int offset, int len) {
        return this.getBest(0, b, offset, len);
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest(0, b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest(0, b, offset, len);
    }

    @Override
    public V getBest(String s2, int offset, int len) {
        return this.getBest(0, s2, offset, len);
    }

    private V getBest(int t2, String s2, int offset, int len) {
        int pos = offset;
        for (int i = 0; i < len; ++i) {
            int nt;
            char c;
            int index;
            if ((index = __lookup[(c = s2.charAt(pos++)) & 0x7F]) >= 0) {
                int idx = t2 * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) {
                    break;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
                if (big == null || (nt = big[c]) == 0) break;
            }
            if (this._key[t2] != null) {
                V best = this.getBest(nt, s2, offset + i + 1, len - i - 1);
                if (best != null) {
                    return best;
                }
                return this._value[t2];
            }
            t2 = nt;
        }
        return this._value[t2];
    }

    private V getBest(int t2, byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            int nt;
            byte c = b[offset + i];
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) {
                    break;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
                if (big == null || (nt = big[c]) == 0) break;
            }
            if (this._key[t2] != null) {
                V best = this.getBest(nt, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            t2 = nt;
        }
        return this._value[t2];
    }

    private V getBest(int t2, ByteBuffer b, int offset, int len) {
        int pos = b.position() + offset;
        for (int i = 0; i < len; ++i) {
            int nt;
            byte c;
            int index;
            if (pos >= b.limit()) {
                return null;
            }
            if ((index = __lookup[(c = b.get(pos++)) & 0x7F]) >= 0) {
                int idx = t2 * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) {
                    break;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
                if (big == null || (nt = big[c]) == 0) break;
                t2 = nt;
            }
            if (this._key[t2] != null) {
                V best = this.getBest(nt, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            t2 = nt;
        }
        return this._value[t2];
    }

    public String toString() {
        int rows = this._rows;
        if (rows == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        int c = 123;
        for (int i = 0; i <= rows; ++i) {
            String key = this._key[i];
            if (key == null) continue;
            buf.append((char)c).append(key).append('=').append(this._value[i]);
            c = 44;
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (String k : this._key) {
            if (k == null) continue;
            keys.add(k);
        }
        return keys;
    }

    @Override
    public boolean isFull() {
        return this._rows >= this._key.length;
    }
}

