/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import sun.awt.AWTAutoShutdown;
import sun.awt.AWTSecurityManager;
import sun.awt.MostRecentKeyValue;
import sun.awt.SunToolkit;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

public final class AppContext {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.AppContext");
    public static final Object EVENT_QUEUE_KEY = new StringBuffer("EventQueue");
    public static final Object EVENT_QUEUE_LOCK_KEY = new StringBuilder("EventQueue.Lock");
    public static final Object EVENT_QUEUE_COND_KEY = new StringBuilder("EventQueue.Condition");
    private static final Map<ThreadGroup, AppContext> threadGroup2appContext = Collections.synchronizedMap(new IdentityHashMap());
    private static volatile AppContext mainAppContext = null;
    private static final Object getAppContextLock = new GetAppContextLock();
    private final Map<Object, Object> table = new HashMap<Object, Object>();
    private final ThreadGroup threadGroup;
    private PropertyChangeSupport changeSupport = null;
    public static final String DISPOSED_PROPERTY_NAME = "disposed";
    public static final String GUI_DISPOSED = "guidisposed";
    private volatile State state = State.VALID;
    private static final AtomicInteger numAppContexts = new AtomicInteger(0);
    private final ClassLoader contextClassLoader;
    private static final ThreadLocal<AppContext> threadAppContext = new ThreadLocal();
    private long DISPOSAL_TIMEOUT = 5000L;
    private long THREAD_INTERRUPT_TIMEOUT = 1000L;
    private MostRecentKeyValue mostRecentKeyValue = null;
    private MostRecentKeyValue shadowMostRecentKeyValue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<AppContext> getAppContexts() {
        Map<ThreadGroup, AppContext> map = threadGroup2appContext;
        synchronized (map) {
            return new HashSet<AppContext>(threadGroup2appContext.values());
        }
    }

    public boolean isDisposed() {
        return this.state == State.DISPOSED;
    }

    AppContext(ThreadGroup threadGroup) {
        numAppContexts.incrementAndGet();
        this.threadGroup = threadGroup;
        threadGroup2appContext.put(threadGroup, this);
        this.contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        ReentrantLock reentrantLock = new ReentrantLock();
        this.put(EVENT_QUEUE_LOCK_KEY, reentrantLock);
        Condition condition = reentrantLock.newCondition();
        this.put(EVENT_QUEUE_COND_KEY, condition);
    }

    private static final void initMainAppContext() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                ThreadGroup threadGroup2 = threadGroup.getParent();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                mainAppContext = SunToolkit.createNewAppContext(threadGroup);
                return null;
            }
        });
    }

    public static final AppContext getAppContext() {
        if (numAppContexts.get() == 1 && mainAppContext != null) {
            return mainAppContext;
        }
        AppContext appContext = threadAppContext.get();
        if (null == appContext) {
            appContext = AccessController.doPrivileged(new PrivilegedAction<AppContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public AppContext run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                    Object object = getAppContextLock;
                    synchronized (object) {
                        if (numAppContexts.get() == 0) {
                            if (System.getProperty("javaplugin.version") == null && System.getProperty("javawebstart.version") == null) {
                                AppContext.initMainAppContext();
                            } else if (System.getProperty("javafx.version") != null && threadGroup2.getParent() != null) {
                                SunToolkit.createNewAppContext();
                            }
                        }
                    }
                    object = (AppContext)threadGroup2appContext.get(threadGroup2);
                    while (object == null) {
                        if ((threadGroup2 = threadGroup2.getParent()) == null) {
                            ThreadGroup threadGroup3;
                            SecurityManager securityManager = System.getSecurityManager();
                            if (securityManager != null && (threadGroup3 = securityManager.getThreadGroup()) != null) {
                                return (AppContext)threadGroup2appContext.get(threadGroup3);
                            }
                            return null;
                        }
                        object = (AppContext)threadGroup2appContext.get(threadGroup2);
                    }
                    for (ThreadGroup threadGroup4 = threadGroup; threadGroup4 != threadGroup2; threadGroup4 = threadGroup4.getParent()) {
                        threadGroup2appContext.put(threadGroup4, object);
                    }
                    threadAppContext.set(object);
                    return object;
                }
            });
        }
        return appContext;
    }

    public static final boolean isMainContext(AppContext appContext) {
        return appContext != null && appContext == mainAppContext;
    }

    private static final AppContext getExecutionAppContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager instanceof AWTSecurityManager) {
            AWTSecurityManager aWTSecurityManager = (AWTSecurityManager)securityManager;
            AppContext appContext = aWTSecurityManager.getAppContext();
            return appContext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws IllegalThreadStateException {
        Object object;
        if (this.threadGroup.parentOf(Thread.currentThread().getThreadGroup())) {
            throw new IllegalThreadStateException("Current Thread is contained within AppContext to be disposed.");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.state != State.VALID) {
                return;
            }
            this.state = State.BEING_DISPOSED;
        }
        object2 = this.changeSupport;
        if (object2 != null) {
            ((PropertyChangeSupport)object2).firePropertyChange(DISPOSED_PROPERTY_NAME, false, true);
        }
        final Object object3 = new Object();
        Runnable runnable = new Runnable((PropertyChangeSupport)object2, object3){
            final /* synthetic */ PropertyChangeSupport val$changeSupport;
            final /* synthetic */ Object val$notificationLock;
            {
                this.val$changeSupport = propertyChangeSupport;
                this.val$notificationLock = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Window[] windowArray;
                for (Window window : windowArray = Window.getOwnerlessWindows()) {
                    try {
                        window.dispose();
                    }
                    catch (Throwable throwable) {
                        log.finer("exception occurred while disposing app context", throwable);
                    }
                }
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        if (!GraphicsEnvironment.isHeadless() && SystemTray.isSupported()) {
                            TrayIcon[] trayIconArray;
                            SystemTray systemTray = SystemTray.getSystemTray();
                            for (TrayIcon trayIcon : trayIconArray = systemTray.getTrayIcons()) {
                                systemTray.remove(trayIcon);
                            }
                        }
                        return null;
                    }
                });
                if (this.val$changeSupport != null) {
                    this.val$changeSupport.firePropertyChange(AppContext.GUI_DISPOSED, false, true);
                }
                Object object = this.val$notificationLock;
                synchronized (object) {
                    this.val$notificationLock.notifyAll();
                }
            }
        };
        Object object4 = object3;
        synchronized (object4) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object3.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = object3;
                synchronized (object) {
                    object3.notifyAll();
                }
            }
        };
        object4 = object3;
        synchronized (object4) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object3.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object4 = this;
        synchronized (object4) {
            this.state = State.DISPOSED;
        }
        this.threadGroup.interrupt();
        long l = System.currentTimeMillis();
        long l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadGroup.stop();
        l = System.currentTimeMillis();
        l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = this.threadGroup.activeGroupCount();
        if (n > 0) {
            object = new ThreadGroup[n];
            n = this.threadGroup.enumerate((ThreadGroup[])object);
            for (int i = 0; i < n; ++i) {
                threadGroup2appContext.remove(object[i]);
            }
        }
        threadGroup2appContext.remove(this.threadGroup);
        threadAppContext.set(null);
        try {
            this.threadGroup.destroy();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        object = this.table;
        synchronized (object) {
            this.table.clear();
        }
        numAppContexts.decrementAndGet();
        this.mostRecentKeyValue = null;
    }

    static void stopEventDispatchThreads() {
        for (AppContext appContext : AppContext.getAppContexts()) {
            if (appContext.isDisposed()) continue;
            PostShutdownEventRunnable postShutdownEventRunnable = new PostShutdownEventRunnable(appContext);
            if (appContext != AppContext.getAppContext()) {
                CreateThreadAction createThreadAction = new CreateThreadAction(appContext, postShutdownEventRunnable);
                Thread thread = AccessController.doPrivileged(createThreadAction);
                thread.start();
                continue;
            }
            postShutdownEventRunnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Map<Object, Object> map = this.table;
        synchronized (map) {
            MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
            if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
                return mostRecentKeyValue.value;
            }
            Object object2 = this.table.get(object);
            if (this.mostRecentKeyValue == null) {
                this.mostRecentKeyValue = new MostRecentKeyValue(object, object2);
                this.shadowMostRecentKeyValue = new MostRecentKeyValue(object, object2);
            } else {
                MostRecentKeyValue mostRecentKeyValue2 = this.mostRecentKeyValue;
                this.shadowMostRecentKeyValue.setPair(object, object2);
                this.mostRecentKeyValue = this.shadowMostRecentKeyValue;
                this.shadowMostRecentKeyValue = mostRecentKeyValue2;
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Map<Object, Object> map = this.table;
        synchronized (map) {
            MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
            if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
                mostRecentKeyValue.value = object2;
            }
            return this.table.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        Map<Object, Object> map = this.table;
        synchronized (map) {
            MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
            if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
                mostRecentKeyValue.value = null;
            }
            return this.table.remove(object);
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public String toString() {
        return this.getClass().getName() + "[threadGroup=" + this.threadGroup.getName() + "]";
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    public static <T> T getSoftReferenceValue(Object object, Supplier<T> supplier) {
        Object t;
        AppContext appContext = AppContext.getAppContext();
        SoftReference softReference = (SoftReference)appContext.get(object);
        if (softReference != null && (t = softReference.get()) != null) {
            return t;
        }
        t = supplier.get();
        softReference = new SoftReference(t);
        appContext.put(object, softReference);
        return t;
    }

    static {
        SharedSecrets.setJavaAWTAccess(new JavaAWTAccess(){

            private boolean hasRootThreadGroup(final AppContext appContext) {
                return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return appContext.threadGroup.getParent() == null;
                    }
                });
            }

            @Override
            public Object getAppletContext() {
                if (numAppContexts.get() == 0) {
                    return null;
                }
                AppContext appContext = AppContext.getExecutionAppContext();
                if (numAppContexts.get() > 0) {
                    appContext = appContext != null ? appContext : AppContext.getAppContext();
                }
                boolean bl = appContext == null || mainAppContext == appContext || mainAppContext == null && this.hasRootThreadGroup(appContext);
                return bl ? null : appContext;
            }
        });
    }

    static final class CreateThreadAction
    implements PrivilegedAction<Thread> {
        private final AppContext appContext;
        private final Runnable runnable;

        public CreateThreadAction(AppContext appContext, Runnable runnable) {
            this.appContext = appContext;
            this.runnable = runnable;
        }

        @Override
        public Thread run() {
            Thread thread = new Thread(this.appContext.getThreadGroup(), this.runnable);
            thread.setContextClassLoader(this.appContext.getContextClassLoader());
            thread.setPriority(6);
            thread.setDaemon(true);
            return thread;
        }
    }

    static final class PostShutdownEventRunnable
    implements Runnable {
        private final AppContext appContext;

        public PostShutdownEventRunnable(AppContext appContext) {
            this.appContext = appContext;
        }

        @Override
        public void run() {
            EventQueue eventQueue = (EventQueue)this.appContext.get(EVENT_QUEUE_KEY);
            if (eventQueue != null) {
                eventQueue.postEvent(AWTAutoShutdown.getShutdownEvent());
            }
        }
    }

    private static enum State {
        VALID,
        BEING_DISPOSED,
        DISPOSED;

    }

    private static class GetAppContextLock {
        private GetAppContextLock() {
        }
    }
}

