/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.table.Table;

public class HheaTable
implements Table {
    private int version;
    private short ascender;
    private short descender;
    private short lineGap;
    private short advanceWidthMax;
    private short minLeftSideBearing;
    private short minRightSideBearing;
    private short xMaxExtent;
    private short caretSlopeRise;
    private short caretSlopeRun;
    private short metricDataFormat;
    private int numberOfHMetrics;

    public HheaTable(DataInput dataInput) throws IOException {
        this.version = dataInput.readInt();
        this.ascender = dataInput.readShort();
        this.descender = dataInput.readShort();
        this.lineGap = dataInput.readShort();
        this.advanceWidthMax = dataInput.readShort();
        this.minLeftSideBearing = dataInput.readShort();
        this.minRightSideBearing = dataInput.readShort();
        this.xMaxExtent = dataInput.readShort();
        this.caretSlopeRise = dataInput.readShort();
        this.caretSlopeRun = dataInput.readShort();
        for (int i = 0; i < 5; ++i) {
            dataInput.readShort();
        }
        this.metricDataFormat = dataInput.readShort();
        this.numberOfHMetrics = dataInput.readUnsignedShort();
    }

    public short getAdvanceWidthMax() {
        return this.advanceWidthMax;
    }

    public short getAscender() {
        return this.ascender;
    }

    public short getCaretSlopeRise() {
        return this.caretSlopeRise;
    }

    public short getCaretSlopeRun() {
        return this.caretSlopeRun;
    }

    public short getDescender() {
        return this.descender;
    }

    public short getLineGap() {
        return this.lineGap;
    }

    public short getMetricDataFormat() {
        return this.metricDataFormat;
    }

    public short getMinLeftSideBearing() {
        return this.minLeftSideBearing;
    }

    public short getMinRightSideBearing() {
        return this.minRightSideBearing;
    }

    public int getNumberOfHMetrics() {
        return this.numberOfHMetrics;
    }

    public short getXMaxExtent() {
        return this.xMaxExtent;
    }

    public String toString() {
        return "'hhea' Table - Horizontal Header\n--------------------------------\n        'hhea' version:       " + Fixed.floatValue(this.version) + "\n        yAscender:            " + this.ascender + "\n        yDescender:           " + this.descender + "\n        yLineGap:             " + this.lineGap + "\n        advanceWidthMax:      " + this.advanceWidthMax + "\n        minLeftSideBearing:   " + this.minLeftSideBearing + "\n        minRightSideBearing:  " + this.minRightSideBearing + "\n        xMaxExtent:           " + this.xMaxExtent + "\n        horizCaretSlopeNum:   " + this.caretSlopeRise + "\n        horizCaretSlopeDenom: " + this.caretSlopeRun + "\n        reserved0:            0\n        reserved1:            0\n        reserved2:            0\n        reserved3:            0\n        reserved4:            0\n        metricDataFormat:     " + this.metricDataFormat + "\n        numOf_LongHorMetrics: " + this.numberOfHMetrics;
    }
}

