/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.gephi.statistics.plugin.GraphDensity;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.GraphDensityPanel;
import org.openide.util.NbBundle;

public class GraphDensityUI
implements StatisticsUI {
    private GraphDensityPanel panel;
    private GraphDensity graphDensity;

    public JPanel getSettingsPanel() {
        this.panel = new GraphDensityPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.graphDensity = (GraphDensity)statistics;
        if (this.panel != null) {
            this.panel.setDirected(this.graphDensity.getDirected());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.graphDensity.setDirected(this.panel.isDirected());
        }
        this.graphDensity = null;
        this.panel = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return GraphDensity.class;
    }

    public String getValue() {
        DecimalFormat df = new DecimalFormat("###.###");
        return df.format(this.graphDensity.getDensity());
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"GraphDensityUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_NETWORK_OVERVIEW;
    }

    public int getPosition() {
        return 200;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"GraphDensityUI.shortDescription");
    }
}

