/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class DecoratedIcon
implements Icon {
    private final Icon orig;
    private final Icon decoration;
    private final DecorationController decorationController;

    public DecoratedIcon(Icon orig, Icon decoration) {
        this.orig = orig;
        this.decoration = decoration;
        this.decorationController = null;
    }

    public DecoratedIcon(Icon orig, Icon decoration, DecorationController decorationController) {
        this.orig = orig;
        this.decoration = decoration;
        this.decorationController = decorationController;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.orig.paintIcon(c, g, x, y);
        if (this.decorationController == null || this.decorationController.isDecorated()) {
            this.decoration.paintIcon(c, g, x + this.orig.getIconWidth() - this.decoration.getIconWidth(), y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.orig.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.orig.getIconHeight();
    }

    public static interface DecorationController {
        public boolean isDecorated();
    }
}

