(self.webpackChunk=self.webpackChunk||[]).push([[524],{274:e=>{e.exports=' <h4>Target a specific ISA instead of using the xHost option</h4> <div class="text"> <div class="promo"> Although static analysis presumes the loop may benefit from <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a> instructions available with the AVX2 or higher ISA, no FMA instructions executed for this loop. To fix: Instead of using the <samp class="codeph">xHost</samp> compiler option, which limits optimization opportunities by the host ISA, use the following compiler options: <ul> <li> <samp class="codeph">xCORE-AVX2</samp> to compile for machines with and without AVX2 support </li> <li> <samp class="codeph">axCORE-AVX2</samp> to compile for machines with AVX2 support only </li> <li> <samp class="codeph">xCOMMON-AVX512</samp> to compile for machines with AVX-512 support only </li> <li> <samp class="codeph">axCOMMON-AVX512</samp> to compile for machines with and without AVX-512 support </li> </ul> Note: the compiler options may vary depending on the CPU microarchitecture. </div> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /QxCORE-AVX2 or /QaxCORE-AVX2 </td> <td> -xCORE-AVX2 or -axCORE-AVX2 </td> </tr> <tr> <td> /QxCOMMON-AVX512 or /QaxCOMMON-AVX512 </td> <td> -xCOMMON-AVX512 or -axCOMMON-AVX512 </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-2D881A91-C5D7-4DDD-84B1-FB9D0D597F4D.html"> ax, Qax</a>; <a href="docs:C++/17/index.htm#GUID-09734487-1819-4C1E-B314-2497F2B64C45.html"> x, Qx</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html"> Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/architecture-and-technology/avx-512-solution-brief.html"> Compiling for the Intel&reg; Xeon Phi™ processor x200 and the Intel&reg; AVX-512 ISA</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},355:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>c});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"button no_report"},[t("a",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.buttonTooltip,expression:"buttonTooltip"}],staticClass:"dot icon",class:[e.buttonIcon,{available:e.buttonAvailable}],on:{click:function(t){return e.makeSnapshot()}}})])};o._withStripped=!0;var n=i(75337),s=i(32095),r=i(78281),a=i(51069);const l={mixins:[r.A,a.A],inject:["api"],data:()=>({isOpened:!1}),computed:{...(0,n.mapGetters)("header",["getButton"]),...(0,n.mapGetters)("workflow",["isButtonAvailable"]),button(){return this.getButton("snapshot")},buttonAvailable(){return this.isButtonAvailable({cmd:s.CommandType.ctRunCollection,analysisTypes:{}})}},methods:{makeSnapshot(){this.api.header.send("snapshot")}}},c=(0,i(98822).A)(l,o,[],!1,null,"c39c6136",null).exports},407:e=>{e.exports=' <h4>Force vectorized remainder</h4> <div class="text"> <div class="promo"> The compiler did not vectorize the <span data-glossary-id="remainder_loop">remainder loop</span>, even though doing so could improve performance. To fix: Force vectorization using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">#pragma vector vecremainder</samp>. <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n// Force the compiler to vectorize the remainder loop\n#pragma vector vecremainder\nfor (i=0; i&lt;n; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void add_floats(float *a, float *b, float *c, float *d, float *e, int n)\n{\n    int i;\n    // Force the compiler to vectorize the remainder loop\n    #pragma vector vecremainder\n    for (i=0; i&lt;n; i++)\n    {\n        a[i] = a[i] + b[i] + c[i] + d[i] + e[i];\n    }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-2B528C72-29B4-4DBC-8B91-EE4D1A03A850.html">vector</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},953:(e,t)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const i={props:{data:Object}};t.A=i},1033:(e,t,i)=>{"use strict";i.d(t,{A:()=>r}),i(69212),i(45361);var o=i(77106);const n=JSON.parse('{"alignment_of_code":"Placement of a contiguous code section (loop or function) in memory such that the address of the first byte is divisible by a power of two. Such a code section is called n-byte aligned.","alignment_of_data":"Placement of contiguous data (such as a variable or C/C++ struct/class) in memory such that the address is divisible by a power of two. You may achieve better performance if data is aligned, at least, to its size.","atomic":"Indivisible instruction performing read, modify and write for a memory value with guarantee that this value will not be changed by other GPU thread","call_count":"The number of times a loop is invoked.","cpu_front_end":"A part of CPU core that reads instructions from memory, decodes them, and sends them to the execution core (back-end). Under certain circumstances, the front-end may process too few instructions per clock cycle, which results in under-utilization of the back-end.","directive":"A programming language construct that specifies how a compiler should process input. Same as a C/C++ pragma.","filling":"Moving a variable from main memory to a register. Using variables in registers instead of main memory results in better performance.","FMA":"Fused multiply-add instructions that improve the performance and accuracy of floating-point computations. Sample syntax: A = +A * B + C. These instructions are faster because the computation is not performed in steps, and more accurate because intermediate results are treated as infinite precision, with rounding done on store.","ICC":"Command line for invoking the Intel&reg; C Compiler on the Linux* platform. Often used as a shorthand for referring to the compiler.","ICL":"Command line for invoking the Intel&reg; C/C++ Compiler on the Microsoft Windows* platform. Often used as a shorthand for referring to the compiler.","ICPC":"Command line for invoking the Intel&reg; C++ Compiler on the Linux* platform. Often used as a shorthand for referring to the compiler.","IFORT":"Command line for invoking the Intel&reg; Fortran Compiler on the Windows* and Linux* platforms. Often used as a shorthand for referring to the compiler.","loop_body":"A vectorized loop (usually) compiler-generated from a source loop. Same as kernel loop.","peeled_loop":"A small, (usually) compiler-generated loop created to align the memory accesses inside the loop body and maximize its efficiency. The compiler peels off any initial iterations containing misaligned accesses, which leaves the remaining iterations’ memory accesses optimally aligned. A peeled loop always has a trip count smaller than the vector length.","register_pressure":"When the optimal number of registers is unavailable for variable allocation. High register pressure may result in spilling.","remainder_loop":"A (usually) compiler-generated loop created to clean up any remaining iterations that do not fit within the scope of the loop body. The compiler typically generates remainder loops when the source loop trip count is not a multiple of the vector length.","SIMD":"Single-instruction-multiple-data. A processor instruction that performs the same operation on multiple pieces of data (such as elements of an array).","source_loop":"A developer-written loop as it appears in source code.","spilling":"Moving a variable from a register to main memory. A spilled variable must be loaded in and out of main memory for every read/write operation, resulting in poorer performance.","trip_count":"The number of times the body of a loop will execute. Same as iteration count (and sometimes referred to as loop count in Intel compiler documentation).","unroll":"Optimize a loop by duplicating its body, thus reducing the branching overhead and the number of loop iterations that must execute. A complete unroll fully duplicates the loop body such that no repetition is required. A partial unroll of size n duplicates the body n times and reduces the number of iterations to 1/n of the original iteration count.","vector_length":"Number of elements that can be processed in the same operation. Ideal vector length = vector register width in bits / data type size in bits.","vector_register_width":"The number of bits in the processor vector registers. Intel&reg; Streaming SIMD Extensions 2 (Intel&reg; SSE2) instructions operate on 128-bit registers; Intel&reg; Advanced Vector Extensions (Intel&reg; AVX) instructions operate on 256-bit registers; Intel&reg; Many Integrated Core Instructions (Intel&reg; MIC Instructions) operate on 512-bit registers.","vectorize":"Generate code that takes advantage of processor vectorization hardware, usually by executing SIMD instructions.","GRF":"General Register File is a set of available GPU registers. The GRF is the fastest memory on GPU.","SLM":"Shared Local Memory is a memory region shared between work items in a work group.","SIMD_gpu":"Number of work items processed together as one SIMD vector on an execution unit (EU) thread or in a subgroup.","subgroup":"Group of work items processed together as one SIMD vector on a execution unit (EU) thread.","cache_line_utilization":"Part of global memory traffic effectively used by execution units.<br> Calculated as a ratio of global memory traffic between execution units and cache data port to the observed cache traffic between a data port and the caches, in cache-line granularity transactions. Low value indicates that an inefficient or not GPU-friendly memory access pattern is present in a GPU kernel.","fixed_array":"Array with size known at compile time."}');var s=i(40838);function r(e){e&&(0,o.qsa)("[data-glossary-id]",e).forEach((function(e){const t=n[e.dataset.glossaryId];t&&(0,s.A)(e,t)}))}},1067:(e,t,i)=>{"use strict";i.r(t),i.d(t,{CPU:()=>o,GPU:()=>n,TYPES:()=>s});const o="cpu",n="gpu",s=[o,n]},1520:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>o});const o="data:image/png;base64,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"},1607:(e,t,i)=>{var o={"./issues/gpu/disclaimer.html":26925,"./issues/gpu/issue_gpu_branch_divergence.html":97451,"./issues/gpu/issue_gpu_grf_spills.html":87715,"./issues/gpu/issue_gpu_inefficient_data_transfer.html":68895,"./issues/gpu/issue_gpu_insufficient_parallel_work.html":66327,"./issues/gpu/issue_gpu_not_enough_data_locality.html":20743,"./issues/gpu/issue_grf_usage.html":42072,"./issues/gpu/issue_inefficient_atomic.html":98287,"./issues/gpu/issue_private_memory.html":65238,"./issues/issue_assumed_dependency.html":22196,"./issues/issue_cdi.html":64978,"./issues/issue_check_access_patterns.html":61143,"./issues/issue_div.html":8175,"./issues/issue_excessive_caching.html":71673,"./issues/issue_fma.html":31124,"./issues/issue_gather_scatter.html":62728,"./issues/issue_indirect_call.html":86487,"./issues/issue_inefficient_map.html":58435,"./issues/issue_libm_function.html":80907,"./issues/issue_loop_misalignment.html":38311,"./issues/issue_need_for_simd.html":4144,"./issues/issue_openmp_functions.html":56409,"./issues/issue_peel_remainder.html":50860,"./issues/issue_potential_vectorizability.html":34839,"./issues/issue_proven_dependency.html":24808,"./issues/issue_reciprocals.html":69633,"./issues/issue_register_pressure.html":76906,"./issues/issue_serialized_user_function.html":44819,"./issues/issue_stl_algorithms.html":54694,"./issues/issue_system_functions.html":37537,"./issues/issue_type_conversions.html":39668,"./issues/issue_user_functions_prevent_vectorization.html":10120,"./issues/issue_vector_function_attr.html":36632,"./issues/offload/issue_inefficient_data_transfer.html":61525,"./issues/offload/issue_insufficient_parallel_work.html":95029,"./issues/offload/issue_offload.html":2651,"./issues/roofline_guidance/issue_irm_roofline_guidance.html":35418,"./issues/roofline_guidance/issue_roofline_guidance.html":9903,"./recs/cpp/rec_add_ivdep_c.html":42642,"./recs/cpp/rec_add_ivdep_c_test.html":41633,"./recs/cpp/rec_add_processor_specification_c.html":25484,"./recs/cpp/rec_align_loop_c.html":48768,"./recs/cpp/rec_assumed_dependency_enable_vec_c.html":88787,"./recs/cpp/rec_assumed_dependency_reduction_c.html":84376,"./recs/cpp/rec_assumed_dependency_run_correctness_c.html":7958,"./recs/cpp/rec_assumed_dependency_vectorlen_c.html":12291,"./recs/cpp/rec_check_access_patterns_run_map_c.html":85054,"./recs/cpp/rec_div_c.html":24137,"./recs/cpp/rec_enable_autovectorization_c.html":42188,"./recs/cpp/rec_explore_vectorization_c.html":49279,"./recs/cpp/rec_indirect_call_branch_prediction_c.html":50370,"./recs/cpp/rec_indirect_call_move_c.html":83309,"./recs/cpp/rec_indirect_call_proxy_c.html":71534,"./recs/cpp/rec_indirect_call_simd_c.html":3461,"./recs/cpp/rec_inefficient_map_exchange_outer_c.html":14977,"./recs/cpp/rec_inefficient_map_missing_outer_loop_data_c.html":47058,"./recs/cpp/rec_inefficient_map_sdlt_c.html":88455,"./recs/cpp/rec_inefficient_map_soa_c.html":18367,"./recs/cpp/rec_libm_function_enable_inlining_c.html":67052,"./recs/cpp/rec_libm_function_precise_c.html":85667,"./recs/cpp/rec_libm_function_strict_c.html":60997,"./recs/cpp/rec_libmvec_new_glibc_c.html":27157,"./recs/cpp/rec_libsvml_gcc_c.html":8781,"./recs/cpp/rec_openmp_functions_move_c.html":41279,"./recs/cpp/rec_openmp_lock_remove_c.html":3726,"./recs/cpp/rec_registers_pressure_reduce_factor_c.html":67863,"./recs/cpp/rec_registers_pressure_split_loop_c.html":53188,"./recs/cpp/rec_sqrt_c.html":56990,"./recs/cpp/rec_system_functions_move_c.html":58383,"./recs/cpp/rec_type_conversions_non_native_c.html":70182,"./recs/cpp/rec_type_conversions_smallest_c.html":61124,"./recs/cpp/rec_use_nts_c.html":52141,"./recs/fma/rec_fma_enforce_vec_c.html":96251,"./recs/fma/rec_fma_enforce_vec_f.html":37672,"./recs/fma/rec_fma_excplicity_enable_c.html":36732,"./recs/fma/rec_fma_excplicity_enable_f.html":53271,"./recs/fma/rec_fma_target_avx2_isa_c.html":48615,"./recs/fma/rec_fma_target_avx2_isa_f.html":12652,"./recs/fma/rec_fma_target_specific_isa_c.html":274,"./recs/fma/rec_fma_target_specific_isa_f.html":91453,"./recs/fortran/rec_add_ivdep_f.html":15430,"./recs/fortran/rec_add_linear_ref_f.html":93429,"./recs/fortran/rec_add_processor_specification_f.html":1968,"./recs/fortran/rec_align_loop_f.html":77594,"./recs/fortran/rec_assumed_dependency_enable_vec_f.html":20291,"./recs/fortran/rec_assumed_dependency_reduction_f.html":14694,"./recs/fortran/rec_assumed_dependency_run_correctness_f.html":85580,"./recs/fortran/rec_assumed_dependency_vectorlen_f.html":70505,"./recs/fortran/rec_check_access_patterns_run_map_f.html":45710,"./recs/fortran/rec_div_f.html":44481,"./recs/fortran/rec_enable_autovectorization_f.html":69226,"./recs/fortran/rec_explore_vectorization_f.html":80971,"./recs/fortran/rec_indirect_call_branch_prediction_f.html":77586,"./recs/fortran/rec_indirect_call_move_f.html":50139,"./recs/fortran/rec_inefficient_map_contiguous_f.html":46406,"./recs/fortran/rec_inefficient_map_exchange_outer_f.html":81835,"./recs/fortran/rec_inefficient_map_missing_outer_loop_data_f.html":13390,"./recs/fortran/rec_inefficient_map_soa_f.html":31531,"./recs/fortran/rec_libm_function_enable_inlining_f.html":9744,"./recs/fortran/rec_libm_function_precise_f.html":30443,"./recs/fortran/rec_libm_function_strict_f.html":52863,"./recs/fortran/rec_libmvec_new_glibc_f.html":81373,"./recs/fortran/rec_libsvml_gcc_f.html":61913,"./recs/fortran/rec_openmp_functions_move_f.html":18863,"./recs/fortran/rec_openmp_lock_remove_f.html":88028,"./recs/fortran/rec_registers_pressure_reduce_factor_f.html":92385,"./recs/fortran/rec_registers_pressure_split_loop_f.html":48520,"./recs/fortran/rec_sqrt_f.html":87460,"./recs/fortran/rec_system_functions_move_f.html":69915,"./recs/fortran/rec_type_conversions_non_native_f.html":92386,"./recs/fortran/rec_type_conversions_smallest_f.html":23364,"./recs/fortran/rec_use_nts_f.html":11329,"./recs/gather_scatter_info/rec_gather_scatter_info_c.html":63275,"./recs/gather_scatter_info/rec_gather_scatter_info_f.html":97496,"./recs/gpu/dpcpp_disclaimer.html":33705,"./recs/gpu/rec_gpu_add_more_parallel_work_c_dpcpp.html":14487,"./recs/gpu/rec_gpu_add_more_parallel_work_c_omp_target.html":33172,"./recs/gpu/rec_gpu_add_more_parallel_work_f_omp_target.html":60469,"./recs/gpu/rec_gpu_apply_data_reuse_c_dpcpp.html":98274,"./recs/gpu/rec_gpu_apply_data_reuse_c_omp_target.html":30115,"./recs/gpu/rec_gpu_apply_data_reuse_f_omp_target.html":30290,"./recs/gpu/rec_gpu_cas_atomic_c_dpcpp.html":97407,"./recs/gpu/rec_gpu_combine_region_instances.html":25733,"./recs/gpu/rec_gpu_dataset_tile_share_data_c_dpcpp.html":54420,"./recs/gpu/rec_gpu_dataset_tile_share_data_slm_c_dpcpp.html":19065,"./recs/gpu/rec_gpu_dataset_tile_share_data_slm_c_omp_target.html":87094,"./recs/gpu/rec_gpu_dataset_tile_share_data_slm_f_omp_target.html":46591,"./recs/gpu/rec_gpu_reduce_simd_width_c_dpcpp.html":98495,"./recs/gpu/rec_gpu_reduce_simd_width_c_omp_target.html":81212,"./recs/gpu/rec_gpu_reduce_simd_width_f_omp_target.html":9661,"./recs/gpu/rec_gpu_reduce_spills_c_dpcpp.html":9418,"./recs/gpu/rec_gpu_reduce_spills_c_omp_target.html":57163,"./recs/gpu/rec_gpu_reduce_spills_f_omp_target.html":49466,"./recs/gpu/rec_kernel_complex_structure_c_dpcpp.html":38103,"./recs/gpu/rec_kernel_complex_structure_c_omp_target.html":77044,"./recs/gpu/rec_kernel_complex_structure_f_omp_target.html":11285,"./recs/gpu/rec_private_memory_c_dpcpp.html":54668,"./recs/gpu/rec_private_memory_c_omp_target.html":70077,"./recs/gpu/rec_private_memory_f_omp_target.html":25276,"./recs/need_for_simd/rec_need_for_simd_complex_loop_vectorization_c.html":14963,"./recs/need_for_simd/rec_need_for_simd_complex_loop_vectorization_f.html":95072,"./recs/need_for_simd/rec_need_for_simd_outer_vectorization_inner_not_vectorized_c.html":84410,"./recs/need_for_simd/rec_need_for_simd_outer_vectorization_inner_not_vectorized_f.html":54149,"./recs/need_for_simd/rec_need_for_simd_outer_vectorization_instead_of_inner_c.html":28293,"./recs/need_for_simd/rec_need_for_simd_outer_vectorization_instead_of_inner_f.html":57114,"./recs/need_for_simd/rec_need_for_simd_run_correctness_c.html":27543,"./recs/need_for_simd/rec_need_for_simd_run_correctness_f.html":10780,"./recs/need_for_simd/rec_need_for_simd_run_map_c.html":59400,"./recs/need_for_simd/rec_need_for_simd_run_map_f.html":1627,"./recs/need_for_simd/rec_need_for_simd_run_trip_count_c.html":76503,"./recs/need_for_simd/rec_need_for_simd_run_trip_count_f.html":76092,"./recs/offload/rec_apply_data_reuse_c.html":49802,"./recs/offload/rec_apply_data_reuse_f.html":2037,"./recs/offload/rec_offload_add_more_parallel_work.html":5339,"./recs/offload/rec_offload_combine_region_instances.html":88065,"./recs/offload/rec_offload_reduction_c.html":3661,"./recs/offload/rec_offload_reduction_f.html":41602,"./recs/offload/rec_offload_trivial_c.html":40169,"./recs/offload/rec_offload_trivial_f.html":26326,"./recs/peel_remainder/rec_peel_remainder_align_c.html":73397,"./recs/peel_remainder/rec_peel_remainder_align_f.html":3658,"./recs/peel_remainder/rec_peel_remainder_auto_simd_modifier_c.html":26157,"./recs/peel_remainder/rec_peel_remainder_auto_simd_modifier_f.html":64098,"./recs/peel_remainder/rec_peel_remainder_disable_dynamic_align_c.html":55504,"./recs/peel_remainder/rec_peel_remainder_disable_dynamic_align_f.html":47843,"./recs/peel_remainder/rec_peel_remainder_force_scalar_remainder_c.html":63382,"./recs/peel_remainder/rec_peel_remainder_force_scalar_remainder_f.html":81673,"./recs/peel_remainder/rec_peel_remainder_force_vectorized_remainder_c.html":407,"./recs/peel_remainder/rec_peel_remainder_force_vectorized_remainder_f.html":83996,"./recs/peel_remainder/rec_peel_remainder_loop_count_c.html":44604,"./recs/peel_remainder/rec_peel_remainder_loop_count_f.html":94871,"./recs/peel_remainder/rec_peel_remainder_omp_simd_modifier_c.html":18268,"./recs/peel_remainder/rec_peel_remainder_omp_simd_modifier_f.html":35031,"./recs/peel_remainder/rec_peel_remainder_padding_c.html":82493,"./recs/peel_remainder/rec_peel_remainder_padding_f.html":29618,"./recs/peel_remainder/rec_peel_remainder_run_trip_count_c.html":91759,"./recs/peel_remainder/rec_peel_remainder_run_trip_count_f.html":45620,"./recs/peel_remainder/rec_peel_remainder_unroll_prevents_c.html":20686,"./recs/peel_remainder/rec_peel_remainder_unroll_prevents_f.html":58849,"./recs/peel_remainder/rec_peel_remainder_vectorlength_c.html":25757,"./recs/peel_remainder/rec_peel_remainder_vectorlength_f.html":30130,"./recs/roofline_guidance/rec_roofline_guidance_collect_all_memory_levels.html":95812,"./recs/roofline_guidance/rec_roofline_guidance_collect_callstacks.html":96146,"./recs/roofline_guidance/rec_roofline_guidance_compute_bound.html":60116,"./recs/roofline_guidance/rec_roofline_guidance_confirm_inefficient_map.html":12186,"./recs/roofline_guidance/rec_roofline_guidance_memory_bound.html":90064,"./recs/roofline_guidance/rec_roofline_guidance_mostly_compute_bound.html":33765,"./recs/roofline_guidance/rec_roofline_guidance_mostly_memory_bound.html":24911,"./recs/sqrtdiv/rec_sqrtdiv_enforce_vec_c.html":17727,"./recs/sqrtdiv/rec_sqrtdiv_enforce_vec_f.html":39844,"./recs/sqrtdiv/rec_sqrtdiv_target_avx512_isa_c.html":80001,"./recs/sqrtdiv/rec_sqrtdiv_target_avx512_isa_f.html":58190,"./recs/sqrtdiv/rec_sqrtdiv_target_avx512mic_isa_c.html":24674,"./recs/sqrtdiv/rec_sqrtdiv_target_avx512mic_isa_f.html":24429,"./recs/sqrtdiv/rec_sqrtdiv_tune_precision_c.html":20759,"./recs/sqrtdiv/rec_sqrtdiv_tune_precision_f.html":87996,"./recs/stl_algorithms/rec_use_parallel_stl_any_of.html":55777,"./recs/stl_algorithms/rec_use_parallel_stl_copy_if.html":69514,"./recs/stl_algorithms/rec_use_parallel_stl_for_each.html":52074,"./recs/stl_algorithms/rec_use_parallel_stl_sort.html":81691,"./recs/user_function/serialized_call_info/rec_serialized_user_function_enable_inlining_c.html":8956,"./recs/user_function/serialized_call_info/rec_serialized_user_function_enable_inlining_f.html":75575,"./recs/user_function/serialized_call_info/rec_serialized_user_function_try_simd_c.html":89807,"./recs/user_function/serialized_call_info/rec_serialized_user_function_try_simd_f.html":26036,"./recs/user_function/user_call_prevents_info/rec_user_function_prevent_vectorization_enable_inlining_c.html":47693,"./recs/user_function/user_call_prevents_info/rec_user_function_prevent_vectorization_enable_inlining_f.html":24482,"./recs/user_function/user_call_prevents_info/rec_user_function_prevent_vectorization_try_simd_c.html":95208,"./recs/user_function/user_call_prevents_info/rec_user_function_prevent_vectorization_try_simd_f.html":30331,"./recs/user_function/user_call_prevents_info/rec_user_function_prevent_vectorization_try_simd_f1.html":9688};function n(e){var t=s(e);return i(t)}function s(e){if(!i.o(o,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return o[e]}n.keys=function(){return Object.keys(o)},n.resolve=s,e.exports=n,n.id=1607},1627:e=>{e.exports=' <h4>Check memory access patterns for outer loop</h4> <div class="text promo"> <div id="no_map_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a> to check for memory issues. </div> <span id="actions" style="display:none">To ensure that outer loop has optimal memory access patterns run a <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a>.</span> </div>'},1715:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(85815),n=i(6263),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"1339b8e9",null).exports},1792:()=>{window.rec_check_access_patterns_run_map_f=function(e,t){if(!e)return;const i=e.querySelector("#no_map_disclaimer"),o=e.querySelector("#actions");i&&o&&(i.Visible(t.no_map_disclaimer),o.Visible(!t.no_map_disclaimer))},window.rec_inefficient_map_exchange_outer_f=function(e,t){if(!e)return;const i=e.querySelector("#no_map_disclaimer"),o=e.querySelector("#actions");i&&o&&(i.Visible(t.no_map_disclaimer),o.Visible(!t.no_map_disclaimer))},window.rec_assumed_dependency_run_correctness_f=function(e,t){if(!e)return;const i=e.querySelector("#no_dependency_disclaimer"),o=e.querySelector("#actions");i&&o&&(i.Visible(t.no_dependency_disclaimer),o.Visible(!t.no_dependency_disclaimer))}},1843:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return e.buttonsVisible?t("div",{staticClass:"message-buttons"},e._l(e.orderedButtons,(function(i){return t("button",{key:i.id,attrs:{value:i.id},on:{click:e.onButtonClick}},[e._v("\n    "+e._s(i.text)+"\n  ")])})),0):e._e()};o._withStripped=!0;const n={props:{buttons:{type:Array,required:!0}},computed:{buttonsVisible(){return this.buttons&&this.buttons.length},orderedButtons(){const e=[...this.buttons];return e.sort(((e,t)=>e.id-t.id)),e}},methods:{onButtonClick(e){this.$emit("button-click",e.target.value)}}},s=(0,i(98822).A)(n,o,[],!1,null,"1df8c7c1",null).exports},1919:(e,t,i)=>{"use strict";i.d(t,{A:()=>Y}),i(36094),i(69212),i(45361),i(21602),i(60426);var o=i(66275),n=i(61262),s=i(59743);const r=new s.gi("idvc2_grid_expanded_column"),a=new s.gi("idvc2_grid_collapsed_column"),l="data-cell-tooltip";let c;function d(e){n.default.ScrolledHolder.call(this),this.ready4OverlayScrolling=!1,this.scrollBody=document.createElement("div"),this.scrollBody.className="idvc2_grid_vertical_scroll",this.scrolledCoef=1,this.scrollSize=document.createElement("div"),this.scrollSize.className="idvc2_grid_scroll_size",this.scrollBody.appendChild(this.scrollSize),e.appendChild(this.scrollBody),this.scrollBody.onscroll=p.bind(this),this.scrollBody.onmouseleave=()=>{this.relatedGridBody&&(this.relatedGridBody.areaMouseOut(),delete this.relatedGridBody)}}function p(){this.scrollBody.offsetParent&&this.setScrollTop(this.getScrollTop(),!0)}d.prototype=Object.create(n.default.ScrolledHolder.prototype);const u=1e7;d.prototype.setScrollInfo=function(e,t,i){const o=this.scrollBody.scrollTop,n=this.scrollBody.getBoundingClientRect().height;n<=0||(e<=u?(this.scrolledCoef=t/n,this.scrollSize.style.height=this.fromArea(e)+"px"):(this.scrolledCoef=(e-t)/(u-n),this.scrollSize.style.height=u+"px"),this.scrollBody.scrollTop=void 0!==i?this.fromArea(i):o)},d.prototype.toArea=function(e){return Math.round(e*this.scrolledCoef)},d.prototype.fromArea=function(e){return Math.round(e/this.scrolledCoef)},d.prototype.setScrollTop=function(e,t){this.syncScrollTop(e),t||this._setScrollVal(e)},d.prototype.getScrollTop=function(){return this.toArea(this.scrollBody.scrollTop)},d.prototype.hide=function(){return this.scrollBody.style.display="none"},d.prototype.show=function(){return this.scrollBody.style.display="block"},d.prototype.isVisible=function(){return"none"!==this.scrollBody.style.display},d.prototype.showOverlay=function(){if(this.ready4OverlayScrolling)return this.scrollBody.style.visibility="visible"},d.prototype.hideOverlay=function(){if(this.ready4OverlayScrolling)return this.scrollBody.style.visibility="hidden"},d.prototype._setScrollVal=function(e){this.endProcessTimeout&&clearTimeout(this.endProcessTimeout),this.scrollBody.onscroll=null,this.scrollBody.scrollTop=this.fromArea(e),this.endProcessTimeout=setTimeout(function(){this.scrollBody.onscroll=p.bind(this),delete this.endProcessTimeout}.bind(this),50)};var h={collapsed:"+",expanded:"-",simple:" "};function m(e){e.stopPropagation(),e.preventDefault()}function f(e,t,i){this.dataIndex=t,this.area=document.createElement("div"),this.area.columnObj=this,this.header=document.createElement("div"),this.scrollArea=document.createElement("div"),this.footer=document.createElement("div"),this.header.className="idvc2_grid_header_section",this.scrollArea.className="idvc2_grid_column_scrolled",this.footer.className="idvc2_grid_footer_section",this.footer.onmousedown=m,this.footer.onmouseup=m,this.footer.onmousemove=m,this.setState(i),this.area.appendChild(this.scrollArea),this.area.appendChild(this.footer),this.area.appendChild(this.header),e.appendChild(this.area)}function v(e,t){const i=e&&e.getParent();if(i){let e=0;const o=i[Symbol.iterator](0,t);let n=o.next();for(;n.value&&!n.done;)n.value.isVisible()&&e++,n=o.next();return e>1}return!1}function g(e,t){return!!e&&(void 0===t&&(t=function(e){let t=!1;const i=e&&e.getParent();if(i)for(let e=0,o=i.getChildrenCount();e<o;e++)if(D(i.getChild(e))){t=!0;break}return t}(e)),t?!!e&&(!k(e)||v(e,h.expanded))&&(!D(e)||v(e,h.collapsed)):v(e))}f.prototype.setState=function(e){if(e){var t;e===h.simple||this.expandCollapse||(this.expandCollapse=document.createElement("span"),this.header.appendChild(this.expandCollapse),this.expandCollapse.onmousedown=function(e){e.stopPropagation()},this.expandCollapse.onmouseup=this.expandCollapse.onmousedown,this.expandCollapse.onclick=function(e){e.stopPropagation();var t=!1;if(this.beforeExpandColumn&&this.beforeExpandColumn(this,{cancel:function(){t=!0}}),!t){var i=this.visItem;if(i){var o=i.getState();o=o===h.expanded?h.collapsed:h.expanded,this.setState(o)}this.onExpandColumn&&this.onExpandColumn(this)}}.bind(this)),e===h.simple&&this.expandCollapse&&(this.header.removeChild(this.expandCollapse),delete this.expandCollapse),this.expandCollapse&&(t="idvc2_grid_expand_collapse_column",t+=e===h.expanded?` ${r.get()}`:` ${a.get()}`,this.expandCollapse.className=t);var i=this.visItem;i&&i.setState(e),t="idvc2_grid_column",i&&!i.isLeaf()&&(t+=" idvc2_grid_inactive_column"),this.area.className=t,this.resetLayout()}},f.prototype.getState=function(){var e=h.simple;return this.visItem&&(e=this.visItem.getState()),e},f.prototype.isLeaf=function(){var e=!0;return this.visItem&&(e=this.visItem.isLeaf()),e},f.prototype.hide=function(){if(this.canBeHidden()){var e=this.visItem;e&&e.setVisible(!1)}},f.prototype.canBeHidden=function(e){const{visItem:t}=this;return g(t,e)},f.prototype.resetLayout=function(){this._columnLayout&&this.setLayout(this._columnLayout)};var _=[["scrollArea","cells"],["header","header"],["area","column"],["footer","footer"]];function y(e){return e||!!this.visItem&&this.visItem.ignoreHeaderForAutoSize()}function b(e,t,i,o,s,r){let a=!1;if(!e)return a;var l=function(e,t,i,o,n){var s,r="idvc2_grid_cell";return n&&n.getCellStyle&&(s=n.getCellStyle(e,t,r,i,o)),s||(s=e?t:r),s}(o,s,t,i,r);return"string"==typeof l?e.className=l:"object"==typeof l&&(l.className&&(e.className=l.className,delete l.className),l.updateData&&(x(e,t,i,o,r),a=!0,delete l.updateData),n.default.applyObjectProperties(e,l)),a}function w(e,t){if(e)if("string"==typeof(t=t||""))e.isDirty&&(e.style.cssText=null,delete e.isDirty),e.innerHTML=t;else if(n.default.isHTMLNode(t))n.default.removeAllChildren(e),e.appendChild(t),e.isDirty=!0;else if("object"==typeof t){const{classNames:i}=t;delete t.classNames,n.default.applyObjectProperties(e,t),e.isDirty=!!t.style,Array.isArray(i)&&(i.forEach((t=>e.classList.add(t))),t.classNames=i)}}function x(e,t,i,o,n){if(e&&n){var s=n.getCell(t,i,o);"function"==typeof s?(s(e,t,i,o,w),e.isDirty=!0):w(e,s)}}function C(e,t,i,o,n,s){e&&(b(e,t,i,o,n,s)||x(e,t,i,o,s))}function A(e){var t;if(e&&!e.isLeaf())for(let i of e)i.isVisible()&&(t=i);return t}function S(e){var t;if(e&&!e.isLeaf())for(let i of e)if(i.isVisible()){t=i;break}return t}function T(e,t){this.onDblClick=o.A.create(),this.onContextMenu=o.A.create(),this.onChangeCurrentRow=o.A.create(),this.onFitHeaderHeight=o.A.create(),this.beforeExpandColumn=o.A.create(),this.onExpandColumn=o.A.create(),this.onChangeColumnWidth=o.A.create(),this.onShowTooltip=o.A.create(),this.onSetFocus=o.A.create(),this.onLostFocus=o.A.create(),this.onRowMouseEnter=o.A.create(),this.onRowMouseLeave=o.A.create(),this.area=document.createElement("div"),this.area.className="idvc2_grid_body",void 0!==t&&this.area.setAttribute("tabindex",t),this.connectedBody=null,e.appendChild(this.area),this.columns=[],this.inActiveColumns=[],this.dataModel=null,this.scrolling=null,this._expandLastColumn=!0,this.fitCentralColumnAsync=n.default.createAsyncCall(this.fitCentralColumnWidth,this,100),this.currentChangeAsync=n.default.createAsyncCall(function(e,t){this.onChangeCurrentRow.raise(e,t)}.bind(this),this,50),this.S=n.default.createSequence(),this._sizes={},this.area.refreshSize=function(e){if(this._needRefreshView)delete this._needRefreshView,this.refreshView();else{if(e&&!e.width)return;this.fitCentralColumnHeader(),this.fitLastColumn(),this.refreshRowsContent()}return!0}.bind(this);var i=this;this._viewport=function(){var e=0,t=0,o=0,s=-1;const r="idvc2_grid_cell idvc2_grid_selected_row",a="idvc2_grid_hovered_row";function l(){return i.getVisibleColumnsRange()||{first:0,last:i.columns.length-1}}function c(e){const t=l();for(let o=t.first;o<=t.last;o++){let t=i.columns[o];t&&e(t,o)}}var d=function(){return e},p=function(){return t},u=function(e){return e>=d()&&e<=p()};function h(){const t=w(),{count:i,bottomOverlap:o,rowCount:n}=t;if(!i)return;let s=e+i;return o&&s--,n<=s&&(s=n-1),{index:s,...t}}var m=function(){if(i.columns.length){var e=h();void 0!==e&&(t=e.index)}},f=function(e){return e-d()},v=function(){return i.getRowsAreaHeight()};function g(e){return i.getRowHeight(e)}function _(e,t,o){return i.getRowsHeight(e,t,o)}function y(e){if(i.columns.length&&u(e)){const t=f(e);if(t>=0&&t<i.getRowBufferSize())return t}return-1}function b(e,t){const o=y(e);o>=0&&c((function(n){n.updateRowStyle(e,o,t,i.dataModel)}))}function w(e,t,o){if(!i.getRowBufferSize())return{count:0};void 0===o&&(o=d()),e=e||v(),void 0===t&&(t=A());let n=0;e+=t;const s=i.dataModel.getRowCount();for(;e>0;)if(e-=g(o+n)||20,n++,s<n){n=s,e=0;break}return n<0&&(n=0),{count:n,rowCount:s,topRow:o,bottomOverlap:e<0?Math.round(-e):0,topOverlap:t}}const x=function(e){if(!e||!e.rowCount)return 0;const{count:t,rowCount:i,bottomOverlap:o,topRow:n}=e;let s=t;return!o&&n+t<i&&s++,s},C=function(e,t,i){return x(w(e,t,i))};function A(){var e=0;let t;return(t=i.getFirstColumn())&&(e=t.getScrollTop()),e}return{clear:function(){e=0,t=0,o=0,s=-1},setScrollTop:function(s){s<0&&(s=0);var r,a,l=v(),d=function(e,t){var i=_(0,e-1)-t;return i<0&&(i=0),i}(i.dataModel.getRowCount(),l);if(s>d&&(s=d),(s=Math.round(s))!==this.getScrollTop()){o=s,(0,n.hideCurrentTooltip)();var p=i.getRowBufferSize();if(p&&l){var u=(a=s,i.getRowIndexByHeight(a,0,undefined)),h=Math.round(s-_(0,u-1));h<0&&(h=0);var m=-1,f=u-e,g=C(l,h,u),y=u+g-1;if(i.dataModel.getRowCount()<=y&&(y=i.dataModel.getRowCount()-1),p<g&&-f>0){var b=g-p;r=b,c((function(e){e.addRowsTop(r)})),e=u,t=y,b===-f?this.regetRows(e,-f):this.regetRows(e)}else{var w=t;this.fitRowsCount(g),t=y,!f&&w<t&&this.regetRows(w+1,t-w),e=u,Math.abs(f)<p/2?f>0?(m=w,t===i.dataModel.getRowCount()-1&&m--,function(e){c((function(t){t.moveRows4ScrollBottom(e)}))}(f),f=void 0):f<0&&(m=u,function(e){c((function(t){t.moveRows4ScrollTop(e)}))}(f=-f)):(m=e,f=void 0),m>=0&&this.regetRows(m,f)}this.setColumnsScrollTop(h)}}},getScrollTop:function(){return o},getTopRow:d,getBottomRow:p,setColumnsScrollTop:function(e){this.columnsScrollTop=void 0,c((function(t){t.setScrollTop(e)}));var t=this.getColumnsScrollTop();this.columnsScrollTop=t,o+=t-e},getColumnsScrollTop:function(){return void 0===this.columnsScrollTop&&(this.columnsScrollTop=A()),this.columnsScrollTop},updateCurrentRow:function(e){s=e},setCurrentRow:function(e,t){var i=r;b(t),s=e,b(e,i)},hoverRow:function(e){!function(e,t){const i=y(e);i>=0&&c((function(e){e.addRowStyle(i,t)}))}(e,a)},outRow:function(e){!function(e,t){const i=y(e);i>=0&&c((function(e){e.remRowStyle(i,t)}))}(e,a)},getCurrentRow:function(){return s},getSelectionStyle:function(){return r},insertRows:function(o,n){o<=this.getCurrentRow()&&(s+=n);var r=i.getRowBufferSize(!0);C()<=r?o<=t&&o+n>=e&&(o<e&&o+n>=e&&(n-=e-o,o=e),function(e,t){var i=f(e);c((function(e){e.moveRows4Insert(i,t)}))}(o,n),this.regetRows(o),m()):this.createRows(o,n,!0)},createRows:function(e,t,o,n){if(i.dataModel){var s,r,a;if(n=n||function(){return!0},void 0===e?e=d():e<=p()&&(s=f(e)),void 0===t&&(t=i.dataModel.getRowCount()),o){const e=l();r=e.from,a=e.last-e.from+1}var c=v()+this.getColumnsScrollTop();i.S.do(function(){i.S.forEach(i.columns,function(o,r){o&&n(o,r)&&o.createRows(c,e,t,s,this.getCurrentRow(),this.getSelectionStyle(),i.dataModel,g)}.bind(this),M,r,a)}.bind(this)).do_(m)}},regetRows:function(e,t){if(i.dataModel){(void 0===e||e<d())&&(e=d());var o=p()+1;void 0!==t&&e+t<o&&(o=e+t-1),o>=i.dataModel.getRowCount()&&(o=i.dataModel.getRowCount()-1);var n=f(e);c(function(t){t.regetRows(e,o,n,this.getCurrentRow(),this.getSelectionStyle(),i.dataModel)}.bind(this))}},removeRows:function(t,o){if(i.dataModel&&(i.getCurrentRow()>=t&&i.getCurrentRow()<t+o&&i.setCurrentRow(t-1),t<this.getCurrentRow()&&(s-=o),t<e&&t+o>=e&&(o-=e-t,t=e),u(t)&&i.columns.length>0)){var n=function(t,o){var n=0,s=i.getRowBufferSize(!0),r=f(t);r+o>=s&&(o=s-r);var a=o-(e+s-i.dataModel.getRowCount());return c((function(e){n=e.moveRows4Remove(r,o,a)})),n}(t,o);m(),n>0&&this.regetRows(t),this.refreshSize()}},updateRow:function(e){if(u(e)&&i.dataModel){var t=f(e);c(function(o){o.updateRow(e,t,this.getCurrentRow(),this.getSelectionStyle(),i.dataModel)}.bind(this))}},updateColumn:function(e){var t=i.getColumnByDataIndex(e);i.dataModel&&t&&t.updateColumn(d(),p(),this.getCurrentRow(),this.getSelectionStyle(),i.dataModel)},updateCell:function(e,t){if(u(e)){var o=i.getColumnByDataIndex(t);if(i.dataModel&&o){var n=f(e);o.updateRow(e,n,this.getCurrentRow(),this.getSelectionStyle(),i.dataModel)}}},refreshSize:function(){var e=h();if(void 0===e)return;const o=e.index;if(o>=t){const s=x(e)-i.getRowBufferSize(!0),r=o===t?o+1:o;s>0&&(n=s,c((function(e){e.addRowsBottom(n)})),this.regetRows(r,s))}var n;t=o},getRowTop:function(t){return _(e,t-1)},calcExpand:function(e,t){var i=o;if(t&&u(e)){var n=v();_(e+1,e+t)>=n?i=_(0,e-1):e+t>p()&&(i=_(0,e+t)-n)}return i},fitRowsCount:function(e){e=e||C(),c((function(t){t.fitRowsCount(e)})),m()},refreshRowsContent:function(e){const t=(e,t)=>{for(let o=e;o<=t;o++){let e=i.columns[o];if(e.clearRows(),e.createRows(l,s,p,void 0,this.getCurrentRow(),this.getSelectionStyle(),i.dataModel,g),void 0!==i.hoveredRow){const t=y(i.hoveredRow);t>=0&&e.addRowStyle(t,a)}}},o=(e,t)=>{for(let o=e;o<=t;o++)i.columns[o].setScrollTop(r)},n=(e,t)=>{for(let o=e;o<=t;o++)i.columns[o].clearRows()};e=e||{first:0,last:i.columns.length-1};const s=d(),r=this.getColumnsScrollTop(),l=v()+r,c=i.getVisibleColumnsRange();if(!c)return;const p=i.dataModel.getRowCount();c.first>e.last||c.last<e.first?(e.last>=0&&n(e.first,e.last),t(c.first,c.last),o(c.first,c.last)):(e.first!==c.first&&(e.first>c.first?(t(c.first,e.first-1),o(c.first,e.first-1)):n(e.first,c.first-1)),e.last!==c.last&&(e.last<c.last?(t(e.last+1,c.last),o(e.last+1,c.last)):n(c.last+1,e.last)))},getVisibleRowCount:function(e,t,i){return w(e,t,i).count}}}();var s=function(e,t,i){i.classList.remove("idvc2_grid_tooltip_ellipsis"),i.offsetWidth>.8*window.innerWidth&&(i.style.setProperty("height","auto","important"),i.style.setProperty("line-height","normal","important"),i.style.width=Math.floor(.8*window.innerWidth)+"px");var o=window.getComputedStyle(i,null),n=parseInt(o.getPropertyValue("margin-left"),10),s=e;s<0?s=0:s+n+i.offsetWidth+6>document.documentElement.clientWidth+window.scrollX&&(s=document.documentElement.clientWidth+window.scrollX-i.offsetWidth-n-6);var r=parseInt(o.getPropertyValue("margin-top"),10),a=t;a<0&&(a=0),a+i.offsetHeight+r+2>document.documentElement.clientHeight+window.scrollY&&(a=document.documentElement.clientHeight+window.scrollY-i.offsetHeight-r-2)<3&&(a=0,i.style.height=document.documentElement.clientHeight-2*(parseInt(o.getPropertyValue("padding-top"),10)+2)+"px",i.classList.add("idvc2_grid_tooltip_ellipsis")),i.style.left=s+"px",i.style.top=a+"px"},r={elem:null,tooltip:null,timer:void 0},a=function(){r.tooltip&&document.body.removeChild(r.tooltip),r.timer&&(window.clearTimeout(r.timer),r.timer=void 0),r.attrs&&delete r.attrs,r.tooltip=null,r.elem=null,(0,n.clearCurrentTooltipHideProc)()};function d(){const e=r.elem&&r.elem.offsetParent;return e||a(),e}var p=function(e){if(!r.elem)return;const t=e&&"right"===e.textAlign,o=e&&"width"===e.textAlign,a=!t&&!o;let l=r.elem.innerHTML,p=0,u=0;if(i.dataModel&&i.dataModel.getCellLayout){const e=i.dataModel.getCellLayout(l);if(e){const{text:t,margin:i,start:o}=e;l=t,p=i,o>4&&(u=o-4,p+=u)}}if(!l.length)return;if(!d())return;const m=n.default.getElementPos(r.elem);if(m.x+=p,m.x>h.x)return;let f=m.width-p;const v=window.innerWidth+window.scrollX;m.x+f>v&&(f=v-m.x),m.x<0&&(f+=m.x,m.x=0);const g=n.default.getElementPos(i.area);m.x+f>g.x+g.width&&(f=g.x+g.width-m.x),g.x>m.x&&(f-=g.x-m.x);const _=document.createElement("div");_.className=r.elem.className+" idvc2_grid_popup",_.innerHTML=l;const y=window.getComputedStyle(r.elem,null);if(n.default.copyAppearance(_,y,c),u){const e=parseInt(y.paddingLeft);_.style.paddingLeft=e-u+"px"}_.style.lineHeight=y.lineHeight,_.style.height=y.height,document.body.appendChild(_);const b=_.offsetWidth,w=b-1>f,x=g.x>m.x,C=g.x+g.width<m.x+m.width;if(w||a&&x||t&&C||o&&(x||C)){const e=5;if(a)x&&m.x+b-e<g.x&&(m.x=g.x-b+e);else if(t){const t=m.x+m.width-b;if(C){const i=g.x+g.width;m.x=t+e>i?i-e:t}else m.x=t}else if(o&&m.width>b){const e=getComputedStyle(_),t=m.width-parseFloat(e.paddingLeft)-parseFloat(e.paddingRight)-1;_.style.width=t+"px"}s(m.x,m.y,_),r.tooltip=_}else document.body.removeChild(_)},u=function(){var e=r.attrs;if(e&&e.text&&d()){var t={completed:!1};if(i.onShowTooltip.raise(e.x,e.y,e.text,e.row,e.col,r.elem,t),!t.completed){var o=document.createElement("div");o.className="idvc2_grid_popup idvc2_grid_tooltip",o.innerHTML=e.text,n.default.setFont(o,function(e){var t=null;if(e)t=window.getComputedStyle(e,null);else{var i=document.createElement("button");i.style.position="absolute",i.style.left="0",i.style.top="0",document.body.appendChild(i),t=window.getComputedStyle(i,null),document.body.removeChild(i)}return t}(i.area)),document.body.appendChild(o),s(e.x,e.y,o),r.tooltip=o}}};this.area.onmouseover=e=>{const{row:t}=this.hitTest(e);this.hoveredRow!==t&&(void 0!==this.hoveredRow&&this.rowMouseOut(this.hoveredRow),-1!==t?(this.rowMouseOver(t),this.hoveredRow=t):this.hoveredRow=void 0)},this.area.addEventListener("mouseenter",(()=>{this.areaMouseOver()}),!0),this.area.onmouseleave=e=>{e.relatedTarget!==this.scrolling.scrollBody&&e.relatedTarget!==this.scrolling.scrollSize?this.areaMouseOut():this.scrolling.relatedGridBody=this,void 0!==this.hoveredRow&&this.rowMouseOut(this.hoveredRow),this.hoveredRow=void 0},this.area.onmouseout=a;var h={x:-1,y:-1},m={x:-1,columnIndex:-1,columnObj:void 0,isStarted:!1,isScrolling:!1,scrollingInterval:void 0,areaPos:void 0,scrollingInfo:{scrollingDelta:0},oldClassName:"",clear:function(){this.x=-1,this.columnIndex=-1,this.columnObj=void 0,this.isStarted=!1,this.isScrolling=!1,this.oldClassName="",this.scrollingInterval&&(clearInterval(this.scrollingInterval),this.scrollingInterval=void 0),this.areaPos=void 0,this.columns&&delete this.columns,this.maxX&&delete this.maxX,this.oldClientHeight&&delete this.oldClientHeight}};this.area.onmousemove=function(e){function t(t,i,o,n){r.elem=n,r.attrs={x:e.pageX,y:e.pageY,row:i,col:o,text:t},r.timer=window.setTimeout(u,350)}if((e=e||event).pageX===h.x&&e.pageY===h.y)return;h.x=e.pageX,h.y=e.pageY,a();let o=!1;if(!e.ctrlKey&&!e.shiftKey&&i.columns.length>0&&m.columnIndex<0){var s=i.hitTest(e),c=s.row;if(-1===c){if(s.columnObj){var d=s.columnObj,f=n.default.getElementPos(d.area);!d.isLastColumn()&&i.isResizable(d.dataIndex)&&e.pageX-f.x>f.width-8?d.header.style.cursor="ew-resize":(d.header.style.cursor="default",i.dataModel.getColumnDescription&&(o=!0,t(i.dataModel.getColumnDescription(d.dataIndex),c,s.columnObj.dataIndex,d.header)))}}else if(c>=0){let n=e.target;if(n){let e=n.getAttribute(l),a=function(e,t){let i=null;for(1;e;){if(t(e)){i=e;break}e=e.parentElement}return i}(n,(e=>e.classList&&e.classList.contains("idvc2_grid_cell")));!e&&i.dataModel.getCellTooltip&&s.columnObj&&(e=i.dataModel.getCellTooltip(c,s.columnObj.dataIndex)),e?(o=!0,t(e,c,s.columnObj.dataIndex,a)):a&&(o=!0,r.elem=a,r.timer=window.setTimeout(p.bind(this,s.columnObj.getLayout()),250))}}}o&&(0,n.setCurrentTooltipHideProc)(a)};var f=function(e){if(m.columnIndex>=0&&m.columnObj){var t=e.pageX-m.x;if(m.isStarted){e.preventDefault();var o=i.columns[m.columnIndex];if(o){var s=o.getColumnWidth();if(t=e.pageX-m.x,(m.maxX&&m.maxX>=e.pageX||!m.maxX)&&s+t>=30){let o={gridAreaChanged:!1};i.setColumnWidth(m.columnIndex,Math.round(s+t),!1,o),i.refreshRowsContent(),m.x=e.pageX,o.gridAreaChanged&&(m.areaPos=n.default.getElementPos(i.area))}}var r=function(e,t){var i=e-(t.x+t.width);return i>50?i=50:i<0&&(i=0),i}(e.pageX,m.areaPos);m.scrollingInfo.scrollingDelta=r,!m.isScrolling&&r>0?(m.isScrolling=!0,m.scrollingInterval=setInterval((function(e){var t=e.scrollingDelta;i.area.scrollLeft+=t,m.x-=t,n.default.dispatchMouseEvent({x:m.x+t},"mousemove",window)}),100,m.scrollingInfo)):m.isScrolling&&!r&&(m.isScrolling=!1,clearInterval(m.scrollingInterval),m.scrollingInterval=void 0)}else if(Math.abs(t)>5&&(m.isStarted=!0,m.areaPos=n.default.getElementPos(i.area),(g=document.createElement("div")).className="idvc2_grid_global_cursor",document.body.appendChild(g),i.isColumnResizingConstrainedByGridWidth())){var a=n.default.getElementPos(i.area);m.maxX=a.x+a.width-20}}},v=function(){return!1},g=null,_=function(){m.columnObj&&(m.columnObj.header.className=m.oldClassName);var e=m.isStarted;g&&(document.body.removeChild(g),g=null),window.removeEventListener("mousemove",f,!0),window.removeEventListener("mouseup",_,!0),window.removeEventListener("selectstart",v,!1),e&&(m.oldClientHeight!==i.area.clientHeight&&i.refreshLayout({height:!0}),i.raiseColumnChanges(!1)),m.clear()},y=function(e,t){t=t||i.columns;var o=i.getColumnByPageX(e,t),n=o.columnIndex;if(n>=0){var s=t[n];o.x>s.getColumnWidth()/2&&n++}else n=t.length;return n};function b(e){var t=-1;if(!e)return t;var i=e.getParent();if(i)for(let o=0,n=i.getChildrenCount();o<n;o++){let n=i.getChild(o);if(n&&n.isVisible()&&n===e){t=o;break}}return t}var w=function(e){if(e=e||window.event,m.columnObj&&(m.columnObj.header.className=m.oldClassName),g&&(i.area.removeChild(g.header),document.body.removeChild(g.pointer),g=null),m.isStarted)if(i.columnsVisModel){let t=-1,o=!1,n=m.columns[y(e.pageX,m.columns)];n||(n=m.columns[m.columns.length-1],o=!0),n&&(t=b(n.visItem),o&&t++),t>=0&&(m.columnObj.visItem.getParent().moveChild(m.columnIndex,t),i.refreshColumns())}else i.moveColumn(m.columnIndex,y(e.pageX),!0);else i.clickColumnHeader(m.columnObj);m.clear(),window.removeEventListener("mousemove",x,!0),window.removeEventListener("mouseup",w,!0),window.removeEventListener("selectstart",v,!1)},x=function(e){if(e=e||window.event,m.columnObj){if(e.preventDefault(),!i.isMovable(m.columnObj.dataIndex))return;var t=e.pageX-m.x;if(m.isStarted){var o=parseInt(g.header.style.left,10);g.header.style.left=o+t+"px",m.x=e.pageX;var s,r=m.columns||i.columns,a=y(e.pageX,m.columns),l=0;a>=r.length?l=(s=r[r.length-1]).area.offsetLeft+s.area.offsetWidth-i.area.scrollLeft:a>=0&&(l=(s=r[a]).area.offsetLeft-i.area.scrollLeft),l<0&&(l=0),g.pointer.style.left=g.left+l-g.pointer.offsetWidth/2+"px";var c=function(){var e=0;return g&&g.header&&(g.header.offsetLeft+g.header.offsetWidth>i.area.scrollLeft+i.area.clientWidth?(e=g.header.offsetLeft+g.header.offsetWidth-i.area.scrollLeft-i.area.clientWidth,(e=Math.min(e,m.wholeWidth-i.area.scrollLeft-i.area.clientWidth))<0&&(e=0)):g.header.offsetLeft<i.area.scrollLeft&&i.area.scrollLeft>0&&(e=i.area.scrollLeft-g.header.offsetLeft,e=-(e=Math.min(e,i.area.scrollLeft)))),e};if(!g.isScrolling&&0!==c()){g.isScrolling=!0;var d=setInterval((function(){var e=c();0!==e?(i.area.scrollLeft+=e,o=parseInt(g.header.style.left,10),g.header.style.left=o+e+"px",n.default.dispatchMouseEvent({x:m.x},"mousemove",window)):(clearInterval(d),g&&(g.isScrolling=!1))}),200)}}else if(Math.abs(t)>5){let e=m.columnObj.visItem;if(e){m.columnIndex=b(e);var p=e.getParent();m.columns=[];for(let e of p)e&&e.isVisible()&&m.columns.push(e.column);if(m.columns.length<=1)return void delete m.columns}m.isStarted=!0;var u=n.default.getElementPos(i.area),h=function(e){function t(e,t,i){if(!e||!e.area.offsetParent)return{section:void 0,left:0,top:0,width:0,height:0};var o=document.createElement("div");o.className="idvc2_grid_header_section idvc2_grid_header_section_moving",o.innerHTML=e.header.innerHTML;var n=e.area;o.style.left=t+"px",o.style.top=i+"px",o.style.width=n.offsetWidth+"px";var s=e.getHeaderHeight();return o.style.height=s+"px",{section:o,left:n.offsetLeft,top:n.offsetTop,width:n.offsetWidth,height:s}}if(!e)return{section:void 0,left:0,top:0,height:0};var i=document.createElement("div");i.className="idvc2_grid_header_section_moving_container";var o=t(e,0,0);return e.visItem&&(o.childSections=[],o.bottom=o.top+o.height,function e(i,o,n,s){if(i)for(let l of i){var r=void 0;if(l&&l.column&&l.isVisible()){r=t(l.column,n,s);var a=o.top+s+r.height;o.bottom<a&&(o.bottom=a),r.section&&o.childSections.push(r.section)}r&&(e(l,o,n,s+r.height),n+=r.width)}}(e.visItem,o,0,o.height),o.height=o.bottom-o.top),i.style.left=o.left+"px",i.style.top=o.top+"px",i.style.height=o.height+"px",i.style.width=o.width+"px",i.appendChild(o.section),o.childSections&&o.childSections.forEach(i.appendChild.bind(i)),{section:i,left:o.left,top:o.top,height:o.height}}(m.columnObj);i.area.appendChild(h.section);var f=document.createElement("div");f.className="idvc2_grid_arrow_up",f.style.top=u.y+h.top+h.height+"px",f.style.left=u.x+h.left-f.offsetWidth/2+"px",document.body.appendChild(f),g={header:h.section,pointer:f,left:u.x}}}};function C(e){return{isFooter:-2===e,isHeader:-1===e,isRow:e>=0}}this.area.addEventListener("mousedown",(function(e){if(e=e||event,i.columns.length>0){var t=i.hitTest(e),o=t.row;if(-1===o){if(t.columnObj&&0===e.button&&!e.ctrlKey&&!e.shiftKey){m.x=e.pageX;var n=t.columnObj;if(m.columnObj=n,m.columnIndex=i.columns.indexOf(n),m.oldClassName=n.header.className,e.preventDefault(),"ew-resize"===n.header.style.cursor){if(n.header.className+=" idvc2_grid_header_section_hover",m.isStarted=!1,m.columnIndex<0){var s=n.getLastChild();s&&(m.columnIndex=i.columns.indexOf(s))}m.oldClientHeight=i.area.clientHeight,window.addEventListener("mousemove",f,!0),window.addEventListener("mouseup",_,!0),window.addEventListener("selectstart",v,!1)}else i.columns.length>0&&(m.isStarted=!1,m.wholeWidth=i.area.scrollWidth,i.isSortable(n.dataIndex)&&(n.header.className+=" idvc2_grid_header_section_active"),i.columns.length>1&&window.addEventListener("mousemove",x,!0),window.addEventListener("mouseup",w,!0),window.addEventListener("selectstart",v,!1))}}else if(o>=0){if(0!==e.button&&i.isRowSelected(o))return;i.setCurrentRow(o,!1,{ctrl:e.ctrlKey,alt:e.altKey,shift:e.shiftKey,toggle:e.ctrlKey,isMouse:!0}),i.rowVisible(o)}}}),!1),this.area.addEventListener("wheel",function(e){const t=n.default.getWheelCoef(),i=e.deltaY/t;if(e.shiftKey)this.area.scrollLeft+=i*this.area.offsetWidth*.1,e.stopPropagation(),e.preventDefault();else{const t=1e-4;if(Math.abs(i)>t){const t=this.getScrollTop()+i*this.getRowHeight(0);this.setScrollTop(t),e.stopPropagation(),e.preventDefault()}}}.bind(this),!1),this.area.ondblclick=function(e){if(!(e=e||event).ctrlKey&&!e.shiftKey&&i.columns.length>0){var t=i.hitTest(e),o=t.row,n=t.columnObj;n&&-1===o&&"ew-resize"===n.header.style.cursor?(n=n.getLastChild(),i.fitColumnOptimalWidth(i.columns.indexOf(n),n.getMaxAutoSizeWidth()),i.raiseColumnChanges(!1),i.refreshRowsContent()):i.onDblClick.raise(o,n?n.dataIndex:-1,C(o))}},this.area.oncontextmenu=function(e){if(!(e=e||event).ctrlKey&&!e.shiftKey&&i.columns.length>0){var t=i.hitTest(e),o=t.row,n=t.columnObj,s={stopPropagation:!0};i.onContextMenu.raise(o,n?n.dataIndex:-1,s,C(o),e.pageX,e.pageY,e),i.onContextMenu._subscribers.length&&s.stopPropagation&&e.stopPropagation()}},this.area.onselectstart=function(){return!1},this.area.onkeydown=function(e){var t={ctrl:e.ctrlKey,alt:e.altKey,shift:e.shiftKey,toggle:32===e.keyCode};33===e.keyCode?(i.currentPgUp(t),e.preventDefault()):34===e.keyCode?(i.currentPgDown(t),e.preventDefault()):35===e.keyCode?(i.currentEnd(t),e.preventDefault()):36===e.keyCode?(i.currentHome(t),e.preventDefault()):38===e.keyCode?(i.currentUp(t),e.preventDefault()):40===e.keyCode?(i.currentDown(t),e.preventDefault()):13===e.keyCode?i.getCurrentRow()>=0&&i.onDblClick.raise(i.getCurrentRow()):32===e.keyCode?i.setCurrentRow(i.getCurrentRow(),!1,t):65===e.keyCode&&(e.ctrlKey||e.metaKey)&&(t.all=!0,i.setCurrentRow(i.getCurrentRow(),!1,t),e.preventDefault())},this.area.onfocus=function(){this.processSetFocus(!0)}.bind(this),this.area.onblur=function(){i.processLostFocus(!0)},this.refreshRowsContentCall=n.default.createAsyncCall(this.refreshRowsContent,this,50),this.area.onscroll=function(){this.fitCentralColumnHeader(),this.refreshRowsContentCall.call(),"moz"===n.default.Consts.engine&&(this.hoverEnableAsync||(this.hoverEnableAsync=n.default.createAsyncCall(n.default.enableHover,void 0,250)),n.default.disableHover(this.area),this.hoverEnableAsync.call(this.area)),(0,n.hideCurrentTooltip)()}.bind(this)}function I(e){var t;if(e){var i=e.parentElement;i&&((t=i.columnObj)||(t=I(i)))}return t}function P(e,t){if(this.dataModel&&e){var i={state:t||e.getState(),width:300,height:e.getHeaderHeight()||this.headerLevelHeight,levelHeight:this.headerLevelHeight};e.setCaption(this.dataModel.getColumnCaption(e.dataIndex,i))}}f.prototype.setLayout=function(e){function t(e){e&&this._columnLayout&&_.forEach(function(t){e(this[t[0]],this._columnLayout[t[1]])}.bind(this))}this._columnLayout&&(t.call(this,(function(e,t){t&&Object.getOwnPropertyNames(t).forEach((function(i){"className"!==i?e.style[i]="":e.classList.remove(t.className)}))})),this._columnLayout.width&&(this.area.style.width=""),this._columnLayout.captionAlign&&(this.header.style.textAlign=""),this._columnLayout.textAlign&&(this.scrollArea.style.textAlign="",this.footer.style.textAlign="")),e?(this._columnLayout=e,t.call(this,(function(e,t){t&&Object.getOwnPropertyNames(t).forEach((function(i){"className"!==i?e.style[i]=t[i]:e.classList.add(t.className)}))})),e.width&&(this.area.style.width=e.width),e.captionAlign&&(this.header.style.textAlign=e.captionAlign),e.textAlign&&(this.scrollArea.style.textAlign=e.textAlign,this.footer.style.textAlign=e.textAlign)):this._columnLayout&&delete this._columnLayout},f.prototype.getLayout=function(){return this._columnLayout},f.prototype.setCaption=function(e){this.header.innerHTML=e,this.expandCollapse&&this.header.appendChild(this.expandCollapse)},f.prototype.setSortable=function(e){e?n.default.removeClass(this.header,"idvc2_grid_notsortable"):n.default.addClass(this.header,"idvc2_grid_notsortable")},f.prototype.setScrollTop=function(e){this.enableScrolling(),this._savedScrollTop=e,this.scrollArea.scrollTop=e,this.disableScrolling()},f.prototype.enableScrolling=function(){this.scrollArea.onscroll=null},f.prototype.disableScrolling=function(){this.scrollArea.onscroll=()=>{this.scrollArea.scrollTo(0,this._savedScrollTop)}},f.prototype.getScrollTop=function(){return Math.round(this.scrollArea.scrollTop)},f.prototype.getColumnWidth=function(){return this._columnWidth||this.area.offsetWidth},f.prototype.setTop=function(e){this._columnTop=e,this.area.style.top=e+"px"},f.prototype.getTop=function(){return this._columnTop||0},f.prototype.setHeaderHeight=function(e){this._columnHeaderHeight=e;var t=this.header;t.style.boxSizing="border-box",t.style.height=e+"px"},f.prototype.getHeaderHeight=function(){return this._columnHeaderHeight||(this._columnHeaderHeight=this.header.getBoundingClientRect().height),this._columnHeaderHeight},f.prototype.getRowBufferSize=function(){return this.scrollArea.children.length},f.prototype.prepare4OptimalWidth=function(e){var t=n.default.Consts.browserPrefix+"max-content";this.scrollArea.style.width=t,(e=y.call(this,e))||(this.header.style.width=t),this._prepared4OptimalWidth=!0},f.prototype.cleanUp4OptimalWidth=function(e){(e=y.call(this,e))||(this.header.style.width=null),this.scrollArea.style.width=null,this._prepared4OptimalWidth&&delete this._prepared4OptimalWidth},f.prototype.getOptimalWidth=function(e,t){if(this._columnOptimalWidth)return this._columnOptimalWidth;e=e||n.default.em2px(1.25,this.area),t=y.call(this,t);var i=0;return this._prepared4OptimalWidth||(this.prepare4OptimalWidth(t),delete this._prepared4OptimalWidth),t||(i=this.header.offsetWidth),i=Math.max(this.scrollArea.offsetWidth,i),this._prepared4OptimalWidth||this.cleanUp4OptimalWidth(t),this._columnOptimalWidth=Math.round(i+e),this._columnOptimalWidth},f.prototype.clearRows=function(){n.default.removeAllChildren(this.scrollArea)},f.prototype.setLastColumnStyle=function(){var e=this.area.style;e.minWidth=e.width,e.width="auto",e.right="0"},f.prototype.isLastColumn=function(){return"auto"===this.area.style.width},f.prototype.clearLastColumnStyle=function(){if(this.isLastColumn()){var e=this.area.style;e.width=e.minWidth,e.minWidth="20px",e.right="auto"}},f.prototype.getCell=function(e){return this.scrollArea.children[e]},f.prototype.getRowsViewHeight=function(){return this.scrollArea.offsetHeight},f.prototype.getRowsViewStart=function(){return this._scrollAreaTop||this.scrollArea.offsetTop},f.prototype.getRowHeight=function(e){e=e||0;var t=this.getCell(e);return t?t.getBoundingClientRect().height:1},f.prototype.updateRowStyle=function(e,t,i,o){var n=void 0!==i;i=i||"";var s=this.getCell(t);s&&b(s,e,this.dataIndex,n,i,o)},f.prototype.addRowStyle=function(e,t){if(!t)return;const i=this.getCell(e);i&&i.classList.add(t)},f.prototype.remRowStyle=function(e,t){if(!t)return;const i=this.getCell(e);i&&i.classList.remove(t)},f.prototype.moveRows4Insert=function(e,t){var i=this.scrollArea,o=i.children.length-1;if(!(o<0))for(var n=0;n<t;n++){var s=i.removeChild(i.children[o]);s.className="idvc2_grid_cell",i.insertBefore(s,i.children[e])}},f.prototype.moveRows4Remove=function(e,t,i){for(var o=0,n=this.scrollArea,s=0;s<t;s++){var r=n.removeChild(n.children[e]);s<i&&(n.appendChild(r),o++)}return o},f.prototype.moveRows4ScrollBottom=function(e){for(var t=this.scrollArea,i=0;i<e;i++){var o=t.removeChild(t.children[0]);t.appendChild(o)}},f.prototype.moveRows4ScrollTop=function(e){var t=this.scrollArea,i=t.children.length-1;if(!(i<0))for(var o=0;o<e;o++){var n=t.removeChild(t.children[i]);t.insertBefore(n,t.children[0])}},f.prototype.addRowsTop=function(e){for(var t=this.scrollArea,i=0;i<e;i++){var o=document.createElement("div");t.insertBefore(o,t.children[0])}},f.prototype.addRowsBottom=function(e){for(var t=this.scrollArea,i=0;i<e;i++){var o=document.createElement("div");t.appendChild(o)}},f.prototype.fitChildrenCount=function(e){for(var t=this.scrollArea,i=t.children.length-e,o=0;o<i;o++)t.removeChild(t.lastChild)},f.prototype.fitRowsCount=function(e){var t=this.getRowBufferSize();e>t?this.addRowsBottom(e-t):e<t&&this.fitChildrenCount(e)},f.prototype.createRows=function(e,t,i,o,n,s,r,a){if(this._columnOptimalWidth&&delete this._columnOptimalWidth,r){var l=null;void 0!==o&&(l=this.getCell(o));var c=this.scrollArea.children.length,d=r.getRowCount();c+i>d&&(i=d-c);for(var p=Math.min(t+i,d),u=t;u<p;u++){var h=document.createElement("div");if(C(h,u,this.dataIndex,u===n,s,r),l?this.scrollArea.insertBefore(h,l):this.scrollArea.appendChild(h),(e-=a(u))<0)break}}},f.prototype.updateFooter=function(e){e&&e.getFooter&&(this.footer.innerHTML=e.getFooter(this.dataIndex))},f.prototype.regetRows=function(e,t,i,o,n,s){if(this._columnOptimalWidth&&delete this._columnOptimalWidth,s)for(var r=i,a=e;a<=t;a++,r++)C(this.getCell(r),a,this.dataIndex,a===o,n,s)},f.prototype.updateRow=function(e,t,i,o,n){this._columnOptimalWidth&&delete this._columnOptimalWidth,n&&C(this.getCell(t),e,this.dataIndex,e===i,o,n)},f.prototype.updateLayout=function(e,t){t=t||{state:this.getState(),isLeaf:this.isLeaf()};let i=null;e&&e.getColumnLayout&&(i=e.getColumnLayout(this.dataIndex,t)),this.setLayout(i)},f.prototype.updateColumn=function(e,t,i,o,n){this.updateLayout(n),n&&(this.regetRows(e,t,0,i,o,n),this.updateFooter(n))},f.prototype.setWidth=function(e,t,i){this._columnWidth=e;var o=e+"px";this.isLastColumn()?this.area.style.minWidth=o:this.area.style.width=o;var n=this.visItem;n&&n.isLeaf()?(t?this.scrollArea.children.length&&(n.isOptimalWidth=!0):n.isOptimalWidth&&delete n.isOptimalWidth,n.setAutoSize(t),n.setWidth(o)):n||(t?this.scrollArea.children.length&&(this.isOptimalWidth=!0):this.isOptimalWidth&&delete this.isOptimalWidth),i||this.fitParent()},f.prototype.setIsOptimalWidth=function(){if(this.scrollArea.children.length){var e=this.visItem;e&&e.isLeaf()?e.isOptimalWidth=!0:e||(this.isOptimalWidth=!0)}},f.prototype.setMaxAutoSizeWidth=function(e){"number"==typeof e?this._maxWidth=e:delete this._maxWidth},f.prototype.getMaxAutoSizeWidth=function(){var e=this._maxWidth;if(!e&&this.visItem){var t=this.visItem.getMaxAutoSizeWidth();"string"==typeof t?e=t.endsWith("em")?n.default.em2px(parseInt(t),this.scrollArea):parseInt(t):"number"==typeof t&&(e=t),e&&this.setMaxAutoSizeWidth(e)}return e},f.prototype.setScrollAreaTop=function(e){this.scrollArea.style.top=e+"px",this._scrollAreaTop=e},f.prototype.setLeft=function(e,t){this.area.style.left=e+"px",this._columnLeft=e,t||this.fitParent()},f.prototype.getLeft=function(){return void 0!==this._columnLeft?this._columnLeft:this.area.offsetLeft},f.prototype.move=function(e){var t=this.getLeft();this.setLeft(t+e)},f.prototype.getParentColumn=function(){var e;if(this.visItem){var t=this.visItem.getParent();t&&(e=t.column)}return e},f.prototype.getLastChild=function(){var e=this,t=this.visItem;if(t&&!t.isLeaf()){var i=A(t);i&&(e=i.column.getLastChild())}return e},f.prototype.getFirstChild=function(){var e=this,t=this.visItem;if(t&&!t.isLeaf()){var i=S(t);i&&(e=i.column.getFirstChild())}return e},f.prototype.fitParent=function(){var e=this.visItem;if(e){var t=e.getParent();if(t){var i=t.column;if(i){if(S(t)===e){var o=this.getLeft(),n=i.getLeft();i.move(o-n)}if(A(t)===e){var s=this.getLeft()+this.getColumnWidth(),r=i.getColumnWidth(),a=s-(i.getLeft()+r);i.setWidth(r+a),this.isLastColumn()&&!i.isLastColumn()&&i.setLastColumnStyle()}}}}},T.prototype.hitTest=function(e){var t=-1,i=I(e.target);if(i&&this.getRowsAreaHeight()){var o=n.default.getElementPos(i.scrollArea);if(o.height||o.width){var s=e.pageY-o.y;if(s>o.height)t=-2;else if(s>0){var r=function(e){for(var t=null;e;){if(e.className.indexOf&&e.className.indexOf("cell",0)>=0)t=e;else if(t)break;e=e.parentElement}return t}(e.target);if(r){t=0;for(var a=r;a=a.previousSibling;)t++;t+=this._viewport.getTopRow()}else t=-3}}else t=-1}else i||(t=-3);return{row:t,columnObj:i}},T.prototype.getColumnByPageX=function(e,t){var i,o=-1,s=(t=t||this.columns).length;if(s)for(var r=e-n.default.getElementPos(this.area).x+this.area.scrollLeft-t[0].getLeft(),a=0;a<s;a++)if((r-=t[a].getColumnWidth())<=0){o=a,i=t[a],r=t[a].getColumnWidth()+r;break}return{columnIndex:o,x:r,columnObj:i}},T.prototype._isActive=function(){return this.columns.length>0},T.prototype._updateScrollTop=function(e){e!==this.getScrollTop()&&(this._viewport.setScrollTop(e),this.isCentralColumn()&&this.fitCentralColumnAsync.call())},T.prototype._endScroll=function(){this._isWaitingForDataUpdate||this.rowsScrollWaiter&&(this.rowsScrollWaiter.resolve(!0),delete this.rowsScrollWaiter)},T.prototype._updateVisibleScrollTop=function(e){this._viewport.setColumnsScrollTop(e)},T.prototype._getScrollState=function(){return{visibleScrollTop:this._viewport.getColumnsScrollTop(),topIndex:this._viewport.getTopRow()}},T.prototype.setScrollTop=function(e){if(e!==this.getScrollTop()){const t=new Promise((e=>{this.rowsScrollWaiter={resolve:e}}));return this.scrolling.setScrollTop(e),t}return Promise.resolve(!1)},T.prototype.getScrollTop=function(){return this._viewport.getScrollTop()},T.prototype.clearView=function(){this.setScrollTop(0),n.default.removeAllChildren(this.area),this.columns.length=0,this.inActiveColumns.length=0,this._viewport.clear()},T.prototype.clearRows=function(e){this.setScrollTop(0);for(var t=0,i=this.columns.length;t<i;t++)this.columns[t].clearRows();this._viewport.clear(),void 0===e?this._viewport.updateCurrentRow(-1):this._viewport.updateCurrentRow(e)},T.prototype.refreshRowsContent=function(){const e=this.visibleColumnsRange;this.visibleColumnsRange=void 0,this._viewport.refreshRowsContent(e),this.columnsScrollWaiter&&(this.columnsScrollWaiter.resolve(!0),delete this.columnsScrollWaiter)},T.prototype.getFirstColumn=function(){if(this.columns&&this.columns.length)return this.visibleColumnsRange?this.columns[this.visibleColumnsRange.first]:this.columns[0]},T.prototype.refreshDataModel=function(){this.dataModel&&void 0!==this.dataModel.setElement&&this.dataModel.setElement(this)},T.prototype.refreshRows=function(e,t){void 0!==t&&this.dataModel&&this.dataModel.getRowCount()===t?(this._viewport.regetRows(),this.setCurrentRow(e)):(this.clearRows(e),this._viewport.createRows(void 0,void 0,!0)),this.refreshDataModel()},T.prototype.refreshView=function(){n.default.removeAllChildren(this.area),this.visibleColumnsRange=void 0,this.columns.length=0,this.inActiveColumns.length=0,this.updateView()},T.prototype.refreshColumns=function(){var e=this.area.scrollLeft,t=this._viewport.getColumnsScrollTop();e&&(this.area.scrollLeft=0),this.S.do_(this.refreshView.bind(this)).do_(function(){this.area.scrollLeft=e,this.scrolling.updateVisibleScrollTop(t),this.raiseColumnChanges(!0)}.bind(this))},T.prototype.raiseColumnChanges=function(e){this.columnsVisModel&&this.columnsVisModel.onChange&&this.columnsVisModel.onChange.raise(e)},T.prototype.processExpandColumn=function(e){this.refreshColumns(),this.onExpandColumn.raise(e.dataIndex,e.visItem.getState())},T.prototype.processBeforeExpandColumn=function(e,t){this.beforeExpandColumn.raise(e,t)},T.prototype.refreshScroll=function(){this.onRefreshScroll&&this.onRefreshScroll()},T.prototype.updateView=function(){if(this.area.offsetParent){var e={count:0};this._sizes={},this.dataModel&&this.S.do_(this.insertColumns.bind(this)).do_(function(){this.refreshDataModel(),this.updateFooter(),this.isCentralColumn()?(this._viewport.createRows(),e.count=1):this.applyColumnAutoSize(void 0,e)}.bind(this)).do_(function(){e.count?this.visibleColumnsRange=void 0:this.visibleColumnsRange={first:-1,last:-1},this.refreshRowsContent()}.bind(this)).do_(function(){this._viewport.refreshSize(),this.refreshScroll(),this.isCentralColumn()&&this.fitCentralColumnAsync.call()}.bind(this))}else this._needRefreshView=!0},T.prototype.insertColumns=function(){var e=0,t=!1;function i(e,i,o){if(!t){var n=new f(this.area,e,i);return this.isSortable(e)||n.setSortable(!1),n.updateLayout(this.dataModel,{state:i,isLeaf:o}),o?this.columns.push(n):this.inActiveColumns.push(n),n}}var o={headerBottom:0,scrollTop:0,levelHeight:0};function n(i,o,s,r,a,l,c){s=s||function(){},r=r||function(){},a=a||function(){},l=l||function(){},c=c||0;var d=0,p=function(){var e=!1;return this.S.canceled()&&(t=!0,this.S.end(),e=!0),e}.bind(this);return function(t,i){if(!p()){for(var c=i[Symbol.iterator](t),u=c.next();u.value&&!u.done;){if(p())return;var h=u.value;if(h&&h.isVisible()&&(d+=s.call(this,h,o)||0,e++,!h.isLeaf())){var m=n.call(this,h,o+1,s,r,a,l);r.call(this,h,m)}if(u=c.next(),0===o&&e>=M&&!u.done){if(a.call(this),e=0,this.S.nextStep(n.bind(this,i,0,s,r,a,l,u.index)),p())return;break}}0===o&&u.done&&(l.call(this),this.S.end())}}.call(this,c,i),d}function s(t){e=0,n.call(this,t,0,(function(e){var t=e.isLeaf(),o=e.getState(),n=i.call(this,e.getDataIndex(),o,t);if(n.visItem=e,e.column=n,n.setState(o),n.onExpandColumn=this.processExpandColumn.bind(this),n.beforeExpandColumn=this.processBeforeExpandColumn.bind(this),t){var s=e.getWidth();s&&(n.area.style.width=s)}}))}function r(t){e=0,n.call(this,t,0,(function(e){P.call(this,e.column,e.getState())}))}function a(t){e=0;var i=new Map;n.call(this,t,0,(function(e,t){var n=0;0===t?i.clear():n=i.get(t-1);var s=e.column,r={},a=s.header.getBoundingClientRect();r.headerPosTop=a.top,r.headerPosHeight=a.height,o.levelHeight||(o.levelHeight=a.height,this.headerLevelHeight=o.levelHeight);var l=s.getRowsViewStart();if(r.scrollTopDelta=this.keepScrollAreaOffset?l-a.height:0,e.getHeight){var c=e.getHeight();c>1&&(r.headerPosHeight=c*o.levelHeight,r.customHeaderPosHeight=r.headerPosHeight)}n+=r.headerPosHeight,i.set(t,n),o.headerBottom<n&&(o.headerBottom=n,o.scrollTop=o.headerBottom+r.scrollTopDelta),e.isLeaf()&&(r.columnWidth=s.getColumnWidth()),e.calculatedPos=r}))}function l(t){e=0;var i=new Map,s=0;n.call(this,t,0,(function(e,t){var o=0;0===t?i.clear():o=i.get(t);var n=e.column,r=e.calculatedPos;i.set(t+1,o+r.headerPosHeight),n.setTop(o),n.setLeft(s,!0),e.calculatedPos.customHeaderPosHeight&&n.setHeaderHeight(r.customHeaderPosHeight);var a=0;return r.columnWidth&&(a=r.columnWidth,s+=r.columnWidth),delete e.calculatedPos,a}),(function(e,t){e.column.area.style.width=t+"px"}),(function(){this.fitHeaderHeight(o)}),(function(){this.fitHeaderHeight(o)}))}if(this.dataModel){var c=this.dataModel.getColumnCount();this.S.do_(function(){if(this.columnsVisModel)this.S.do(s.bind(this,this.columnsVisModel)).do(a.bind(this,this.columnsVisModel)).do(l.bind(this,this.columnsVisModel)).do(r.bind(this,this.columnsVisModel));else{var e;for(let t=0;t<c;t++){let o=t;this.dataModel.getDataIndex&&(o=this.dataModel.getDataIndex(o));let n=i.call(this,o,h.simple,!0);e||(e=n.getHeaderHeight(),this.headerLevelHeight=e),n.setHeaderHeight(e)}this.fitColumns();for(let e=0,t=this.columns.length;e<t;e++)P.call(this,this.columns[e],h.simple)}}.bind(this)).do_(function(){var e=this.columns.length;e>=1&&this.isLastColumnExpanded()&&this.columns[e-1].setLastColumnStyle()}.bind(this))}},T.prototype.fitColumns=function(){if(!this.columnsVisModel){var e=this.columns.length;if(e){var t,i=0;this.keepScrollAreaOffset||(t=this.columns[0].getHeaderHeight());var o=[];o.length=e;for(var n=0;n<e;n++)o[n]=this.columns[n].getColumnWidth();for(n=0;n<e;n++){var s=this.columns[n];s.setLeft(i),i+=o[n],void 0!==t&&s.setScrollAreaTop(t)}}}};var M=2e3;function E(e,t){this._parent=n.default.getDomElement(e),this._parent.classList.add("idvc2_grid_content"),this.gridBody=new T(this._parent,t),this._vertScroll=new d(this._parent),this.gridBody.scrolling=this._vertScroll,this._vertScroll.addScrolled(this.gridBody),this.gridBody.onRefreshScroll=this.recalcScroll.bind(this),this.gridBody.area.idvcGridObject=this,this.onUpdateViewComplete=o.A.create(),this._parent.refreshSize=function(e){e&&!e.height||(this.gridBody._sizes={},this.gridBody._viewport.refreshSize(),this.recalcScroll(),this.gridBody.isCentralColumn()&&this.gridBody.fitCentralColumnAsync.call())}.bind(this)}function L(e,t,i){function o(e){return e&&(t(e)||L(e,t,i))}if(!e)return!1;if(t=t||function(){},i){for(let t=0,i=e.getChildrenCount();t<i;t++)if(o(e.getChild(t)))return!0}else for(const t of e)if(o(t))return!0;return!1}function R(e){return"number"==typeof e?e+"px":e}function D(e){return e&&0!==e.getFixed()}function k(e){return e&&e.getFixed()>=0}function O(){let e=!1;const t=function t(i,o,n,s,r,a){var l,c=[],d=R(n),p=s,u=!0,m=!1,f=!1,v=0,g=0,_=0,y=void 0;function b(e,t){return t.getDataIndex()===e}return{getParent:function(){return o},getChildrenCount:function(){return c.length},getChild:function(e){return c[e]},getChildByDataIndex:function(e){return c.find(b.bind(this,e))},addChild:function(e,i,o,n,s){var r=t(e,this,i,o=o||h.expanded,n,s);return c.push(r),n||g++,r},remChild:function(e){var t=c.findIndex(b.bind(this,e));t>=0&&c.splice(t,1)},getDataIndex:function(){return i},getWidth:function(){return d||""},setWidth:function(e){return d=R(e),this},getMaxAutoSizeWidth:function(){return l},setMaxAutoSizeWidth:function(e){return l=e,this},getState:function(){if(!g)return h.simple;if(e){if(void 0===y){y=!0;for(let e=0,t=this.getChildrenCount();e<t;e++){const t=this.getChild(e);if(t&&t.isVisible()&&k(t)&&!D(t)){y=!1;break}}}if(y)return h.simple}return p},setState:function(t){return e&&t===h.simple&&y||(p=t),this},setVisible:function(e){if(e!==u){let i=this.isVisible();u=e;var t=this.getParent();t&&i!==this.isVisible()&&t._onChangeChildVisibility(this)}return this},isVisible:function(){return u&&!r},setFixed:function(t){if(!v&&t!==v){v=t,D(this)&&(e=!0);var i=this.getParent();i&&i._onChangeChildFixity(this)}return this},getFixed:function(){return v},setAutoSize:function(e){return m=e,this},isAutoSize:function(){return m},ignoreHeaderForAutoSize:function(e){return void 0!==e&&(f=!!e),f},moveChild:function(e,t){var i=c.splice(e,1)[0];i&&(t>e&&t--,c.splice(t,0,i))},isLeaf:function(){let e=!0;return e=p===h.collapsed?!_:!g,e},isFilteredOut:()=>!!r,getId:()=>a||0,[Symbol.iterator]:function(e,t){let i,o=e||0;function n(e){const t=function(t){let i;do{i=t>=0&&t<c.length?c[t++]:void 0}while(i&&!e(i));return i?t-1:-1}(o);return o=t+1,{value:t>=0?c[t]:void 0,done:t<0,index:t}}return i=(t=t||p)!==h.collapsed?n.bind(this,k):n.bind(this,D),{next:i}},_onChangeChildVisibility:function(e){e.isVisible()?(k(e)&&g++,D(e)&&_++):(k(e)&&g--,D(e)&&_--),y=void 0},_onChangeChildFixity:function(e){e.isVisible()&&(k(e)||g--,D(e)&&_++),y=void 0}}}(-1,void 0,void 0,h.expanded);return Object.defineProperty(t,"isLoaded",{value:!0,writable:!1,enumerable:!0}),Object.defineProperty(t,"hasFixedItems",{get:function(){return e},enumerable:!0}),t.onChange=o.A.create(),t}function N(e){var t={dataIndex:e.getDataIndex()};if(e.isVisible()||(t.visible=!1),!e.isAutoSize()){var i=e.getWidth();i&&(t.width=i)}var o=e.getState();o===h.collapsed&&(t.state=o);const n=e.getFixed();n&&(t.fixed=n),e.isFilteredOut()&&(t.filteredOut=!0);const s=e.getMaxAutoSizeWidth();s&&(t.maxWidth=s);var r=e.getId();r&&(t.id=r);var a=e.getChildrenCount();if(a){t.children=[];for(let i=0;i<a;i++)t.children.push(N(e.getChild(i)))}return t}function z(e,t){var i,o,n=e.addChild(t.dataIndex,"number"==typeof(i=t.width)&&i>0?i+"px":i,t.state,t.filteredOut,t.id);t.fixed&&n.setFixed("boolean"==typeof(o=t.fixed)?o?1:0:o),!1===t.visible&&n.setVisible(!1),t.maxWidth&&n.setMaxAutoSizeWidth(t.maxWidth),t.children&&t.children.forEach((function(e){z(n,e)}))}function B(e,t){if(e){e.getDataIndex()>=0&&t(e);for(let i of e)B(i,t)}}function V(e,t,i){if(void 0!==e[t]){let o=e[t];return o>i&&(o=i),o}return i}function G(e,t){let i=e[t]||0;return i<0&&(i=0),i}async function F(e,t,i){if(!t||!e)return;const o=(i=i||{}).firstColumnIndex||0;function n(e){return e.getVisibleColumnsRange()||{first:0,last:e.columns.length-1}}function s(t,i,n){const s=t.getCell(i,n);return s&&e(s,i,o+n)}let{gridBody:r}=t;if(!r)return;const a=r.columns.length;if(!a)return;const l=G(i,"startColumn"),c=V(i,"endColumn",a-1);if(l>=a||c<0||l>c)return;const d=r.dataModel.getRowCount();if(!d)return;let p=G(i,"startRow"),u=V(i,"endRow",d-1);if(p>u)return;const h=r.getRowsRange();if(p>h.last||u<h.first)return;h.first>p&&(p=h.first),h.last<u&&(u=h.last);const m=r.columns[l].dataIndex;await r.columnToVisible(m);let f=l-1;do{const e=n(r);if(e.first>f+1)throw"Invalid dumped columns range";for(let t=f+1,i=Math.min(e.last,c);t<=i;t++){for(let e=p;e<=u;e++)s(r,e,t);f=t}if(f<c){const e=r.columns[f+1].dataIndex;await r.columnToVisible(e)}}while(f<c);return u}async function U(e,t,i,o){if(o=o||{},!t||!i||!e)return;const n=i.dataModel.getRowCount();if(!n)return;const s=G(o,"startRow"),r=V(o,"endRow",n-1);if(s>r)return;await i.rowVisibleTop(s);let a=s-1;do{if(o.startRow=a+1,a=await e(t,o),void 0===a)break;if(!await i.rowVisibleTop(a+1))break}while(a<r);return a}async function H(e,t,i){return U(F.bind(this,e),t,t.gridBody,i)}async function j(e,t,i,o){i=i||(e=>e.innerText),o=o||H;let n=[];if(!e)return n;let s=-1;return await o(((e,t)=>{s<0&&(s=t);const o=t-s;if(n.length<=o){const e=n.length;n.length=o+1,n.fill([],e)}n[t-s].push(i(e))}),e,t),n}T.prototype.applyColumnAutoSize=function(e,t){function i(e){if(!e)return!1;var t=e.visItem;return t?(t.isAutoSize()||!parseInt(t.getWidth()))&&!t.isOptimalWidth:!e.isOptimalWidth}e=e||this.columns,t=t||{count:0};var o=0,n=!1,s=[];s.length=e.length;var r=[];r.length=e.length,o=0,this.S.do_((()=>{this._viewport.createRows(void 0,void 0,!1,(e=>!!i(e)&&(t.count++,!0)))})).do((()=>{this.S.forEach(e,((e,t)=>{i(e)&&(e.prepare4OptimalWidth(),r[t]=!0)}),M)})).do((()=>{this.S.forEach(e,((e,t)=>{if(e)if(!i(e)||this.dataModel&&this.dataModel.beforeColumnAutoSize&&!this.dataModel.beforeColumnAutoSize(e.dataIndex))s[t]=-e.getColumnWidth();else{var o=e.getOptimalWidth();o=Math.ceil(Math.min(o,e.getMaxAutoSizeWidth()||o)),s[t]=o}}),M)})).do((()=>{this.S.forEach(e,((e,t)=>{e&&r[t]&&e.cleanUp4OptimalWidth()}),M)})).do((()=>{this.S.forEach(e,((e,t)=>{if(e){e.setLeft(o,!0);var i=s[t];i>0&&(e.setWidth(i,!0,!0),n=!0),o+=Math.abs(i)}}),M)})).do((()=>{this.S.forEach(e,(e=>{e&&e.fitParent()}),M)})).do_((()=>{const e=this.columns.length;if(t.count&&t.count<e){for(let t=0;t<e;t++)this.columns[t].clearRows();t.count=0}n&&(this._sizes={})}))},T.prototype.fitHeaderHeight=function(e,t){if(this._sizes={},this.columns.length){if(e){this._sizes.headerBottom=e.headerBottom;for(var i=0,o=this.columns.length;i<o;i++){var n=this.columns[i],s=n.getTop();n.setHeaderHeight(e.headerBottom-s),n.setScrollAreaTop(e.scrollTop-s)}e.levelHeight&&!this.headerLevelHeight&&(this.headerLevelHeight=e.levelHeight)}this.isCentralColumn()&&this.updateColumnCaption(0),t||this.onFitHeaderHeight.raise(e,!0)}},T.prototype.fitExpand=function(e,t){if(t){var i=this._viewport.calcExpand(e,t);this.setScrollTop(i)}},T.prototype.getColumnByDataIndex=function(e,t){var i=this.columns[e];function o(t){return t.dataIndex===e&&(i=t,!0)}return i&&i.dataIndex===e||(i=null,this.columns.some(o),!i&&t&&this.inActiveColumns.some(o)),i},T.prototype.updateCells=function(e){e.length||this._viewport.regetRows(),e.forEach(function(e){e&&(void 0===e.col?this._viewport.updateRow(e.row):void 0===e.row?this._viewport.updateColumn(e.col):-1===e.row?this.updateColumnCaption(e.col):this._viewport.updateCell(e.row,e.col))}.bind(this))},T.prototype.updateColumnCaption=function(e){var t=this.getColumnByDataIndex(e,!0);t&&P.call(this,t)},T.prototype.getSelectionStyle=function(){return"idvc2_grid_cell idvc2_grid_selected_row"},T.prototype.rowMouseOver=function(e,t){this._viewport.hoverRow(e),t?this.hoveredRow=e:(this.onRowMouseEnter.raise(e),this.connectedBody&&this.connectedBody.rowMouseOver(e,!0,this))},T.prototype.rowMouseOut=function(e,t){this._viewport.outRow(e),t?this.hoveredRow=void 0:(this.onRowMouseLeave.raise(e),this.connectedBody&&this.connectedBody.rowMouseOut(e,!0,this))},T.prototype.setMouseOver=function(e,t){this.mouseIsOver=e,!t&&this.connectedBody&&this.connectedBody.setMouseOver(e,!0,this)},T.prototype.areaMouseOver=function(){this.setMouseOver(!0),this.scrolling&&this.scrolling.showOverlay(),this._overlayScrolling&&(this.area.style.overflowX="overlay")},T.prototype.areaMouseOut=function(){this.setMouseOver(!1),this._overlayScrolling&&(this.area.style.overflowX="hidden"),this.scrolling&&this.scrolling.hideOverlay()},T.prototype.setCurrentRow=function(e,t,i){if(!isNaN(e)){var o=function(e){var t=!1,i=this.getCurrentRow();return i!==e&&(this._viewport.setCurrentRow(e,i),t=!0),t}.bind(this);this.dataModel&&this.dataModel.setCurrentRow&&(o=function(e,i){var o=!1;return this._viewport.updateCurrentRow(e),t||(o=this.dataModel.setCurrentRow(e,i)),o}.bind(this)),o(e,i)&&!t&&(this.currentChangeAsync.call(e,i),this.connectedBody&&this.connectedBody.setCurrentRow(e,!0,i,this))}},T.prototype.getCurrentRow=function(){return this.dataModel&&this.dataModel.getCurrentRow?this.dataModel.getCurrentRow():this._viewport.getCurrentRow()},T.prototype.isRowSelected=function(e){return this.dataModel&&this.dataModel.isRowSelected?this.dataModel.isRowSelected(e):this._viewport.getCurrentRow()===e},T.prototype.processSetFocus=function(e){this.area.classList.add("idvc2_grid_focused"),this.connectedBody&&e&&this.connectedBody.processSetFocus(!1,this),e&&this.onSetFocus.raise()},T.prototype.processLostFocus=function(e){this.area.classList.remove("idvc2_grid_focused"),this.connectedBody&&e&&this.connectedBody.processLostFocus(!1,this),e&&this.onLostFocus.raise()},T.prototype.getVisibleColumnsRange=function(){if(this.visibleColumnsRange)return this.visibleColumnsRange;var e=-1,t=-1;const i=this.columns.length;if(i){const o=window.screen.width,n=this.area.offsetWidth;let s=this.area.scrollLeft+n/2-1.5*o;s<0&&(s=0);const r=s+3*o;let a=0;for(let t=0;t<i;t++)if(a+=this.columns[t].getColumnWidth(),a>s){e=t;break}if(e<0&&(e=0),a>=r)t=e;else{for(let o=e+1;o<i;o++)if(a+=this.columns[o].getColumnWidth(),a>=r){t=o;break}t<0&&(t=i-1)}this.visibleColumnsRange={first:e,last:t}}return this.visibleColumnsRange},T.prototype.getRowsRange=function(){return{first:this._viewport.getTopRow(),last:this._viewport.getBottomRow()}},T.prototype.getVisibleRowsRange=function(){var e=this._viewport.getTopRow();Math.round(this._viewport.getColumnsScrollTop())>0&&e++;var t=this._viewport.getBottomRow();return Math.round(this.getScrollTop()+this.getRowsAreaHeight())<Math.round(this.getRowsHeight(0,t))&&t--,{first:e,last:t}},T.prototype.isRowVisible=function(e){var t=this.getVisibleRowsRange();return e>=t.first&&e<=t.last},T.prototype.getRowPos=function(e){var t=0,i=this.getVisibleRowsRange();return e<i.first?t=-1:e>i.last&&(t=1),t},T.prototype.currentToVisibleTop=function(){return this.rowVisibleTop(this.getCurrentRow())},T.prototype.currentToVisibleBottom=function(){return this.rowVisibleBottom(this.getCurrentRow())},T.prototype.currentToVisibleCenter=function(e){return this.rowVisibleCenter(this.getCurrentRow(),e)},T.prototype.rowVisibleTop=function(e){var t=this.getRowsHeight(0,e-1);return t<0&&(t=0),this.setScrollTop(t)},T.prototype.rowVisibleBottom=function(e){var t=this.getRowsAreaHeight(),i=this.getRowsHeight(0,e)-t;return this.setScrollTop(i)},T.prototype.rowVisibleCenter=function(e,t){if(t||!this.isRowVisible(e)){var i=this.getRowsAreaHeight(),o=this.getRowsHeight(0,e)-i/2;return this.setScrollTop(o)}},T.prototype.columnToVisible=function(e,t){var i=this.getColumnByDataIndex(e,!0);if(!i)return Promise.resolve(!1);i=i.getFirstChild();var o=0,s=0;this.columns.some((function(e){return e!==i?(o+=e.getColumnWidth(),!1):(s=o+e.getColumnWidth(),!0)}));var r=function(e,t){if(!e||!e.useScrollLeft)return e;var i=e.contentWidth||0,o=e.left;return o&&i&&i>t&&(i-o>=t?e.left=0:(e.left-=i-t,e.left<0&&(e.left=0))),e}(function(e){var t={left:(e=e||{}).left||0,width:e.width||0,useScrollLeft:e.useScrollLeft||!1,contentWidth:e.contentWidth||0},i=n.default.em2px(.5,this.area);return e.left&&(t.left-=i,t.left<0&&(t.left=0)),e.left&&(i+=e.left-t.left),t.width&&(t.width+=i),t}.call(this,t),s-o),a=r.left,l=a+r.width;l&&(s=Math.min(s,o+l));const c=new Promise((e=>{this.columnsScrollWaiter={resolve:e}}));return!function(e,t){var i=this.area,o=i.scrollLeft,n=i.clientWidth,s=o;return t>s+n&&(s=t-n),e<s&&(s=e),s!==o&&(this.area.scrollLeft=s,!0)}.call(this,o+a,s)&&this.columnsScrollWaiter&&(this.columnsScrollWaiter.resolve(!0),delete this.columnsScrollWaiter),c},T.prototype.columnToExpanded=function(e){let t=!1,{columnsVisModel:i}=this;if(i){let o;for(function e(t,i){if(!t)return!1;let o=!1;if(t.getDataIndex()>=0&&(o=i(t)),!o)for(let n=0,s=t.getChildrenCount();n<s&&(o=e(t.getChild(n),i),!o);n++);return o}(i,(t=>t.getDataIndex()===e&&(o=t,!0)));o;)o=o.getParent(),o&&o.getState()===h.collapsed&&(o.setState(h.expanded),t=!0)}return t?this.S.wait().then((()=>this.S.wait(this.refreshColumns.bind(this)))):Promise.resolve(!0)},T.prototype.currentRowVisible=function(){return this.rowVisible(this.getCurrentRow())},T.prototype.rowVisible=function(e){var t=this.getRowPos(e);return t<0?this.rowVisibleTop(e):t>0?this.rowVisibleBottom(e):Promise.resolve(!1)},T.prototype.currentUp=function(e){var t=this.getCurrentRow()-1;t>=0&&(this.setCurrentRow(t,!1,e),this.rowVisible(t))},T.prototype.currentDown=function(e){var t=this.getCurrentRow()+1;this.dataModel&&t<=this.dataModel.getRowCount()-1&&(this.setCurrentRow(t,!1,e),this.rowVisible(t))},T.prototype.getPageRowCount=function(){return this._viewport.getVisibleRowCount()},T.prototype.currentPgUp=function(e){if(this.getCurrentRow()>0){var t=this.getCurrentRow()-this.getPageRowCount();t<0&&(t=0),this.setCurrentRow(t,!1,e),this.rowVisible(t)}},T.prototype.currentPgDown=function(e){if(this.dataModel&&this.getCurrentRow()<this.dataModel.getRowCount()-1){var t=this.getCurrentRow()+this.getPageRowCount();t>=this.dataModel.getRowCount()&&(t=this.dataModel.getRowCount()-1),this.setCurrentRow(t,!1,e),this.rowVisible(t)}},T.prototype.currentHome=function(e){this.getCurrentRow()>0&&(this.setCurrentRow(0,!1,e),this.rowVisibleTop(0))},T.prototype.currentEnd=function(e){var t=this.dataModel.getRowCount()-1;this.dataModel&&this.getCurrentRow()<t&&(this.setCurrentRow(t,!1,e),this.rowVisibleBottom(t))},T.prototype.getCell=function(e,t){if(this.getRowBufferSize())return e-=this._viewport.getTopRow(),this.columns[t].getCell(e)},T.prototype.getVisibleRowHeight=function(e){if(this.getRowBufferSize()){let t;if(void 0!==e&&(e-=this._viewport.getTopRow()),t=this.getFirstColumn())return t.getRowHeight(e)}return 1},T.prototype.getRowHeight=function(){if(void 0!==this._sizes.rowHeight)return this._sizes.rowHeight;let e;return(e=this.getFirstColumn())?(this._sizes.rowHeight=e.getRowHeight(0),this._sizes.rowHeight):1},T.prototype.getRowsHeight=function(e,t,i){return e=void 0===e?0:e,((t=void 0===t?this.dataModel&&this.dataModel.getRowCount()||0:t)-e+1)*(i||this.getRowHeight(0))},T.prototype.getRowIndexByHeight=function(e,t,i){return(i=i||this.getRowHeight(0))>0?t+Math.floor(e/i+.05):0},T.prototype.getRowTop=function(e){return this._viewport.getRowTop(e)},T.prototype.getViewHeight=function(){return this.columns.length?this.getRowsAreaHeight():1},T.prototype.getRowBufferSize=function(e){let t=e?T.prototype.getFirstColumn.call(this):this.getFirstColumn();return t?t.getRowBufferSize():0},T.prototype.getHeaderHeight=function(){return this.columns.length>0?this.columns[0].getHeaderHeight():0},T.prototype.getRowsAreaStart=function(){if(this.columns.length>0){var e=n.default.getElementPos(this.columns[0].scrollArea),t=n.default.getElementPos(this.area);return e.y-t.y}return 0},T.prototype.getRowsAreaHeight=function(){if(void 0!==this._sizes.rowsAreaHeight)return this._sizes.rowsAreaHeight;let e;if(e=this.getFirstColumn()){var t=e.getRowsViewHeight();return t>0&&(this._sizes.rowsAreaHeight=t),t}return 0},T.prototype.setColumnWidth=function(e,t,i,o){if(!(this.onSetColumnWidth&&this.onSetColumnWidth(e,t)||t<20)){var n=this.columns[e];if(n){var s=n.getColumnWidth();if(t!==s){n.setWidth(t,i),this._sizes={};for(var r=(t=n.getColumnWidth())-s,a=e+1,l=this.columns.length;a<l;a++)this.columns[a].move(r);this.onChangeColumnWidth.raise(e,t,o)}else i&&n.setIsOptimalWidth()}}},T.prototype.getColumnWidth=function(e){var t=this.columns[e];return t?t.getColumnWidth():0},T.prototype.getColumnOptimalWidth=function(e){var t=this.columns[e];return t?t.getOptimalWidth():0},T.prototype.fitColumnOptimalWidth=function(e,t){var i=this.columns[e];if(i){var o=i.getOptimalWidth();t&&o>t&&(o=t),this.setColumnWidth(e,o,!0)}},T.prototype.isCentralColumn=function(){return 1===this.columns.length&&this.columns[0].isLastColumn()},T.prototype.fitCentralColumnWidth=function(){if(this.isCentralColumn()){const e=this.columns[0],t=e.getOptimalWidth(1,!0);e.setWidth(t),this._sizes={},this.fitCentralColumnHeader()}},T.prototype.fitLastColumn=function(){var e=this.columns;this.isLastColumnExpanded()&&e.length&&e[e.length-1].fitParent()},T.prototype.isSortable=function(e){return!this.dataModel||!this.dataModel.isColumnSortable||this.dataModel.isColumnSortable(e)},T.prototype.isMovable=function(e){return!this.dataModel||!this.dataModel.isColumnMovable||this.dataModel.isColumnMovable(e)},T.prototype.isResizable=function(e){return!this.dataModel||!this.dataModel.isColumnResizable||this.dataModel.isColumnResizable(e)},T.prototype.clickColumnHeader=function(e){this.dataModel&&this.dataModel.onSortColumn&&e&&this.isSortable(e.dataIndex)&&this.dataModel.onSortColumn(e.dataIndex,this.getCurrentRow())&&this.currentToVisibleCenter()},T.prototype.moveColumn=function(e,t,i){var o=e===this.columns.length-1||t>=this.columns.length;if(!(e===t||this.columns.length<2||e<t&&e===this.columns.length-1)&&(t>this.columns.length?t=this.columns.length:t<0&&(t=0),e<t&&t--,e!==t)){var n=this.columns[e];if(n){o&&this.isLastColumnExpanded()&&this.columns[this.columns.length-1].clearLastColumnStyle();for(var s=n.getColumnWidth(),r=e>t?s:-s,a=e>t?-1:1,l=0,c=e+a;c!==t+a;c+=a)l+=this.columns[c].getColumnWidth();l=e>t?-l:l;var d=this,p=function(){for(var i=e+a;i!==t+a;i+=a)d.columns[i].setLeft(d.columns[i].getLeft()+r,!0);d.columns[e].setLeft(d.columns[e].getLeft()+l,!0),d.columns.splice(e,1),d.columns.splice(t,0,n),o&&d.isLastColumnExpanded()&&d.columns[d.columns.length-1].setLastColumnStyle()};if(i)var u=0,h=Math.floor(r/9),m=Math.floor(l/9),f=setInterval((function(){for(var i=e+a;i!==t+a;i+=a)d.columns[i].setLeft(d.columns[i].getLeft()+h,!0);d.columns[e].setLeft(d.columns[e].getLeft()+m,!0),r-=h,l-=m,8==++u&&(clearInterval(f),p())}),10);else p()}}},T.prototype.getColumnsInfo=function(){return this.columns.map((function(e){return{index:e.dataIndex,width:e.area.style.width}}))},T.prototype.updateFooter=function(){for(var e=0,t=this.columns.length;e<t;e++)this.columns[e].updateFooter(this.dataModel)},T.prototype.fitCentralColumnHeader=function(){var e=this.area;if(this.isCentralColumn()){var t=this.columns[0],i=parseInt(t.header.style.paddingLeft),o=parseInt(t.header.style.paddingRight);if(!(e.scrollWidth<=e.clientWidth&&i===o)){t.header.style.paddingLeft="0px",t.footer.style.paddingLeft="0px",t.header.style.paddingRight="0px",t.footer.style.paddingRight="0px";var n=4+e.scrollLeft+"px",s=e.scrollWidth-e.scrollLeft-e.clientWidth;s<0&&(s=0);var r=4+s+"px";t.header.style.paddingLeft=n,t.footer.style.paddingLeft=n,t.header.style.paddingRight=r,t.footer.style.paddingRight=r}}},T.prototype.expandLastColumn=function(e){this._expandLastColumn=e},T.prototype.isLastColumnExpanded=function(){return this._expandLastColumn},T.prototype.refreshLayout=function(e){e=e||{width:!0,height:!0};var t=this.area.idvcGridObject._parent;n.default.refreshSize(t,e)},T.prototype.setColumnResizingConstrainedByGridWidth=function(e){e?this._isColumnResizingConstrainedByGridWidth=!0:delete this._isColumnResizingConstrainedByGridWidth},T.prototype.isColumnResizingConstrainedByGridWidth=function(){return!!this._isColumnResizingConstrainedByGridWidth},T.prototype.hideTooltip=function(){this.area.onmouseout&&this.area.onmouseout()},T.prototype.setOverlayScrolling=function(e){this._overlayScrolling=e},T.prototype.waitForDataUpdate=function(e){e?this._isWaitingForDataUpdate=!0:(delete this._isWaitingForDataUpdate,this._endScroll())},E.prototype.destroy=function(){this._parent.classList.remove("idvc2_grid_content"),this.setDataModel(void 0,void 0),delete this.gridBody.area.idvcGridObject},E.prototype.updateView=function(){this.gridBody.S.cancel().do_(this.gridBody.updateView.bind(this.gridBody)).do_(function(){this.onUpdateViewComplete.raise()}.bind(this))},E.prototype.processDataChanges=function(e){var t=!0;e&&void 0!==e.count&&void 0!==e.start?(e.count>0?this.gridBody._viewport.insertRows(e.start,e.count):this.gridBody._viewport.removeRows(e.start,-e.count),this.recalcScroll()):Array.isArray(e)?(this.gridBody.updateCells(e),t=!1):!e||void 0===e.currentRow&&void 0===e.rowCount?!e||void 0===e.regetStart&&void 0===e.regetCount?(this.gridBody.clearView(),this.updateView()):(e.rowCountChanged&&this.gridBody._viewport.fitRowsCount(),this.gridBody._viewport.regetRows(e.regetStart,e.regetCount),e.rowCountChanged&&this.recalcScroll()):(this.gridBody.refreshRows(e.currentRow,e.rowCount),this.recalcScroll()),t&&this.gridBody.isCentralColumn()&&this.gridBody.fitCentralColumnAsync.call()},E.prototype.recalcScroll=function(){const e=()=>{t.style.visibility="hidden",this.gridBody.area.style.right="",i=!0,this._vertScroll.ready4OverlayScrolling=!1};var t=this._vertScroll.scrollBody,i=!1,o=this.gridBody.dataModel?this.gridBody.dataModel.getRowCount():0;if(o){if(this.gridBody.getRowBufferSize()){var s=this.gridBody.getRowsHeight(0,o-1),r=this.gridBody.getRowsAreaHeight();if(s>r){if(void 0===t.style||void 0===t.style.display||"none"!==t.style.display){t.style.visibility="visible",t.style.width="2em";var a=t.offsetWidth-t.clientWidth;a<=1&&(a=16);var l=this.gridBody.area.offsetHeight-this.gridBody.area.clientHeight;l<0&&(l=0),"webkit"===n.default.Consts.engine&&a++,t.style.width=a+"px",this._vertScroll.ready4OverlayScrolling=this._overlayScrolling,this._overlayScrolling?this.gridBody.mouseIsOver||(t.style.visibility="hidden"):(this.gridBody.area.style.right=a+"px",t.style.bottom=l+"px"),this._vertScroll.setScrollInfo(s,r),i=!0}}else e()}}else e();i&&this.gridBody.fitLastColumn()},E.prototype.setDataModel=function(e,t){var i=this.gridBody.dataModel;i&&(i.setElement&&i.setElement(null),this.gridBody.clearView(),i.changed.unsubscribe(this,this.processDataChanges)),this.gridBody.dataModel=e,this.gridBody.columnsVisModel=t,function(e,t){["getRowHeight","getRowsHeight","getRowIndexByHeight","getFirstColumn"].forEach((function(i){t&&t[i]?e[i]=t[i].bind(t):e.hasOwnProperty(i)&&delete e[i]}))}(this.gridBody,e),e&&(e.changed.subscribe(this,this.processDataChanges),this.gridBody.refreshDataModel(),this.updateView())},E.prototype.refresh=function(){var e=this.gridBody.dataModel,t=this.gridBody.columnsVisModel;this.setDataModel(void 0,void 0),this.setDataModel(e,t)},E.prototype.setCurrentRow=function(e){this.gridBody.setCurrentRow(e)},E.prototype.getCurrentRow=function(){return this.gridBody.getCurrentRow()},E.prototype.hideVertScroll=function(){this._vertScroll.hide(),this.gridBody.area.style.right=""},E.prototype.showVertScroll=function(){this._vertScroll.show(),this.gridBody.area.style.right=""},E.prototype.isVertScrollVisible=function(){return this._vertScroll.isVisible()},E.prototype.setHorzScrollType=function(e){this.gridBody.area.style.overflowX=e},E.prototype.hideHeader=function(){n.default.addClass(this.gridBody.area,"idvc2_grid_hidden_header")},E.prototype.showFooter=function(){n.default.addClass(this.gridBody.area,"idvc2_grid_visible_footer"),n.default.refreshSize(this._parent,{height:!0})},E.prototype.hideFooter=function(){n.default.removeClass(this.gridBody.area,"idvc2_grid_visible_footer"),n.default.refreshSize(this._parent,{height:!0})},E.prototype.updateFooter=function(){this.gridBody.updateFooter()},E.prototype.getColumnByDataIndex=function(e,t){return this.gridBody.getColumnByDataIndex(e,t)},E.prototype.getCell=function(e,t){const{gridBody:i}=this;if(i.getRowBufferSize()){const o=i.getColumnByDataIndex(t);if(o)return e-=this.gridBody._viewport.getTopRow(),o.getCell(e)}},E.prototype.hideColumn=function(e){var t=this.getColumnByDataIndex(e,!0);t&&(t.hide(),this.gridBody.refreshColumns())},E.prototype.canColumnBeHidden=function(e){var t=this.getColumnByDataIndex(e,!0);return!!t&&t.canBeHidden()},E.prototype.expandLastColumn=function(){this.gridBody.expandLastColumn()},E.prototype.hideTooltip=function(){this.gridBody.hideTooltip()},E.prototype.setOverlayScrolling=function(e){this._overlayScrolling=e,this.gridBody.setOverlayScrolling(e),this.setHorzScrollType(e?"hidden":"scroll")},E.prototype.showAllColumns=function(){const{columnsVisModel:e}=this.gridBody;L(e,(e=>{e&&!e.isVisible()&&e.setVisible(!0)}),e.hasFixedItems),this.gridBody.refreshColumns()},E.prototype.getInvisibleColumnsCount=function(){const{columnsVisModel:e}=this.gridBody;let t=0;return L(e,(e=>{e&&!e.isVisible()&&t++}),e.hasFixedItems),t},E.prototype.hasInvisibleColumns=function(){const{columnsVisModel:e}=this.gridBody;return L(this.gridBody.columnsVisModel,(e=>e&&!e.isVisible()),e.hasFixedItems)},E.prototype.getColumnsInfo=function(){return this.gridBody.getColumnsInfo()},E.prototype.columnToVisible=function(e,t){return this.gridBody.columnToVisible(e,t)},E.prototype.getRowCount=function(){var e=this.gridBody.dataModel;return e&&e.getRowCount?e.getRowCount():0},E.prototype.rowVisibleCenter=function(e){return this.gridBody.rowVisibleCenter(e)},E.prototype.rowToVisible=function(e){return this.gridBody.rowVisible(e)},E.prototype.currentRowToVisible=function(){return this.gridBody.currentRowVisible()},E.prototype.isRowVisible=function(e){return this.gridBody.isRowVisible(e)},E.prototype.setNoHierarchy=function(){return this.gridBody.area.classList.add("idvc2_grid_no_hierarchy")},E.prototype.enumCells=async function(e,t){return H(e,this,t)},E.prototype.dumpCells=async function(e,t,i){return j(this,e,t,i)};const Y={create:function(e,t){return new E(e,t)},setCellTooltipDefStyles:function(e){c=e},CellTooltipAttr:l,loadCSS:function(){n.default.appendCSS(requirejs.toUrl("./grid_styles.css"))},HeaderItemState:h,createHeaderVisModel:O,createColumnConfigurator:function(e,t,i){let o=!1;var s=t.gridBody.dataModel,r=i||t.gridBody.columnsVisModel;return n.default.buildHierarchy(e,(function(e){function t(e){const t=e.match(/<span class="idvc2_grid_header_section_text"[^<>]*>([^<>]+)<\/span>/);return t&&t[1]}const i=e&&e.visItem||r,n=[];for(let e=0,r=i.getChildrenCount();e<r;e++){const r=i.getChild(e);D(r)&&(o=!0);const a=t(s.getColumnCaption(r.getDataIndex(),{})),l=r.getChildrenCount(),c=r.isVisible()?" checked":"";a&&!r.isFilteredOut()&&n.push({visItem:r,hasChildren:l>0,expanded:l>0,html:`<label><input type="checkbox"${c}>${a}</label>`})}return{children:n}}),(function(e,t){e.expand.innerHTML=t.html,e.expand.classList.add("idvc2_grid_column_configurator_item"),e.expand.children[0].children[0].idvcGridVisItem=t.visItem}),(function(e,t,i){var o=i.tagName.toLowerCase();return"input"===o||"label"===o})).addEventListener("change",(function(e){var i=e.target.checked,n=e.target.idvcGridVisItem;if(n){if(!i&&!g(n,o))return void(e.target.checked=!0);n.setVisible(i),t.gridBody.refreshColumns()}})),{update(){const t=e.getElementsByTagName("input");[].forEach.call(t,(e=>{const{idvcGridVisItem:t}=e;t&&(e.checked=t.isVisible())}))}}},saveHeaderVisModel:function(e){var t={children:[]};for(let i=0,o=e.getChildrenCount();i<o;i++)t.children.push(N(e.getChild(i)));return t},loadHeaderVisModel:function(e){var t=O();return e.children&&e.children.forEach((function(e){z(t,e)})),t},mergeSavedHeaderVisModels:function(e,t){let i=(e,t)=>(e.id||0)-(t.id||0);function o(e){var t=[];return function e(i){i&&(i.id&&t.push(i),i.children&&i.children.forEach(e))}(e),t.sort(i),t}e.children.length&&"string"==typeof e.children[0].id&&(i=(e,t)=>e.id.localeCompare(t.id)),e&&t&&(function(e,t){function i(e,t,i){e[i]!==t[i]&&(t[i]?e[i]=t[i]:delete e[i])}const o=["filteredOut","maxWidth","fixed"];if(e.length!==t.length)return!1;var n=!0;for(let s=0,r=e.length;s<r;s++){let r=e[s],a=t[s];if(r.id!==a.id){n=!1;break}o.forEach(i.bind(this,r,a))}return n}(o(e),o(t))||(e.children=t.children))},enumHeaderVisModel:B,getVisibleColumnsDataIndexes:function(e){var t=[];if(e){let i=e.gridBody.columnsVisModel;i?B(i,(e=>{e.isLeaf()&&t.push(e.getDataIndex())})):t=e.gridBody.columns.map((e=>e.dataIndex))}return t},dumpUtils:{enumCellsInRowsRange:F,enumAllCells:H,enumRowsRanges:U,getRangeStartValue:G,getRangeEndValue:V},dumpCells:j}},1968:e=>{e.exports=' <h4>Target a specific processor type(s)</h4> <div class="text"> <p> <span class="promo"> The default instruction set architecture (ISA) for SIMD-enabled functions is inefficient for your host processor because it could result in extra memory operations between registers. To fix: </span> Add one of the following to tell the compiler to generate an extended set of vector functions. </p> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> PROCESSOR(cpuid) to !$OMP DECLARE SIMD </td> <td> PROCESSOR(cpuid) to !$OMP DECLARE SIMD </td> </tr> <tr> <td> /Qvecabi:cmdtarget Note: Vector variants are created for targets specified for targets specified by compiler options /Qx or /Qax </td> <td> -vecabi=cmdtarget Note: Vector variants are created for targets specified for targets specified by compiler options -x or -ax </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-A9B9396B-3984-4DAA-887E-F5493F12B255.html">DECLARE SIMD</a>, <a href="docs:Fortran/17/index.htm#GUID-257120B1-7058-42C3-A1E3-6BFEC3CA7B76.html">PROCESSOR Clause</a> <a href="docs:Fortran/17/index.htm#GUID-0DCAAB47-773D-4308-93CC-A56ED90B1F51.html">vecabi, Qvecabi</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},2037:e=>{e.exports=' <h4>Apply data reuse</h4> <div class="text"> <div class="promo"> <p>Apply the <b>data reuse</b> technique.</p> <p> With this technique, two sequential kernels can share data without additional data transfer. This can improve data transfer efficiency. For variables used by multiple target constructs, use the <samp class="codeph">target enter data</samp> and <samp class="codeph">target exit data</samp> directives to minimize data transfers between host and target devices. </p> </div> <br> <p> The estimated <b>default</b> data transfer without data reuse for this kernel is %data_transfer_total_no_reuse% (the data transferred from the target device is %data_transfer_read_no_reuse%, the data transferred to the target device is %data_transfer_write_no_reuse%). </p> <br> <p> The estimated data transfer <b>with data reuse applied</b> is %data_transfer_total% (the data transferred from the target device is %data_transfer_read%, the data transferred to the target device is %data_transfer_write%). </p> <br> <p> With the data reuse applied, you may get the data transfer gain (speedup): %data_reuse_speed_up_percents%. </p> <br> Place the data reuse directives as follows: <ul> <li> Place the <samp class="codeph">target enter data</samp> directive before the first <samp class="codeph">target</samp> directive to transfer data from host to target device. </li> <li> Place the <samp class="codeph">target exit data</samp> directive after the last <samp class="codeph">target</samp> directive to transfer data from target to host device. </li> </ul> See the <a href="https://www.openmp.org/spec-html/5.1/openmpsu66.html">OpenMP* specification</a> for more details. <p class="expander">Example of data reuse organization:</p> <pre class="essential"><code class="fortran" data-source="\nsubroutine matmult(N, mA, mB, mC) \n...\n    !$omp target teams distribute parallel do collapse(2) map(to: mA, mB) map(from: mC) \n...\nend \n...\n    !$omp target enter data map(to: A, B, C) map(alloc: C1) \n    call matmult(N, A, B, C1) \n    call matmult(N, C1, C, D) \n    !$omp target exit data map(delete: C1)  \n...\n"></code></pre> <pre class="expansion"><code class="fortran" data-source="\nsubroutine matmult(N, mA, mB, mC) \n\n    integer(kind = 4), intent (in)    :: N\n    real   (kind = 4), intent (inout) :: mA(N,N), mB(N,N), mC(N,N)\n    real   (kind = 4)                 :: cvalue\n\n    !$omp target teams distribute parallel do collapse(2) map(to: mA, mB) map(from: mC) \n    do j = 1, N\n        do i = 1, N\n            cvalue = 0\n            do k = 1, N\n                cvalue = cvalue + mA(i, k) * mB(k, j)\n            enddo\n            mC(i, j) = cvalue\n        enddo\n    enddo\n\nend \n\n\nsubroutine matmult3(N, A, B, C, D)\n\n    integer(kind = 4), intent (in)    :: N\n    real   (kind = 4), intent (inout) :: A(N,N), B(N,N), C(N,N), D(N,N)\n    real   (kind = 4), allocatable    :: C1(:,:)\n\n    allocate( C1(1:N, 1:N) )\n\n    !$omp target enter data map(to: A, B, C) map(alloc: C1) \n    call matmult(N, A, B, C1) \n    call matmult(N, C1, C, D) \n    !$omp target exit data map(delete: C1)  \n    \n    deallocate(C1)\n\nend\n"></code></pre> </div> '},2305:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(35044),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},2439:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,e.metrics?t("div",e._l(e.metrics,(function(i){return t("div",{key:i.id,staticClass:"metric-group"},[e._v("\n    "+e._s(i.caption)+"\n    "),i.explanation?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:i.explanation,expression:"metric.explanation"}],staticClass:"icon help-circle"}):e._e(),e._v(" "),e._l(i.bars,(function(i){return t("bar-metric",e._b({key:i.id},"bar-metric",i,!1))}))],2)})),0):e._e()},n=[];o._withStripped=!0},2651:e=>{e.exports=' <h4>Possible offloading</h4> <div class="essential"> Based on the <b>Offload Modeling</b> results, this code region is potentially profitable to offload. </div> '},2793:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(e,t){return e("div",{staticClass:"toggle"},[t._t("left"),t._v(" "),e("label",{staticClass:"switch"},[e("input",t._g(t._b({attrs:{type:"checkbox"}},"input",t.data.attrs,!1),t.listeners)),t._v(" "),e("span",{staticClass:"slider"})]),t._v(" "),t._t("right")],2)};o._withStripped=!0;const n=(0,i(98822).A)({},o,[],!0,null,"5dd1e567",null).exports},2798:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"collapsed-list"},e._l(e.panels,(function(i){return t("panel-header",{key:e.getSlotIndex(i),attrs:{view:e.view,tabs:i.tabs,collapsed:!0},on:{expanded:function(t){e.onPanelExpanded(e.getSlotIndex(i))},closed:function(t){e.onPanelClosed(e.getSlotIndex(i))}}})})),1)},n=[];o._withStripped=!0},3093:(e,t,i)=>{var o={"./roofline-float-compbound-s.png":12880,"./roofline-float-compbound-v.png":97917,"./roofline-float-membound-s.png":86678,"./roofline-float-membound-v.png":10011,"./roofline-float-mixbound-s.png":73513,"./roofline-float-mixbound-v.png":75716,"./roofline-int-compbound-s.png":35993,"./roofline-int-compbound-v.png":93652,"./roofline-int-membound-s.png":86557,"./roofline-int-membound-v.png":1520,"./roofline-int-mixbound-s.png":78482,"./roofline-int-mixbound-v.png":47455};function n(e){var t=s(e);return i(t)}function s(e){if(!i.o(o,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return o[e]}n.keys=function(){return Object.keys(o)},n.resolve=s,e.exports=n,n.id=3093},3377:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"metric-list",class:{"highlight-important":e.highlightImportant&&e.hasImportantMetrics}},e._l(e.metricList,(function(i){return t("div",{key:i.id,staticClass:"metric-item",class:{important:i.is_important}},[t("metric-item",{attrs:{metric:i,enableHovering:e.enableHovering,enableLegend:e.enableLegend},on:{"metric-hover":e.onMetricHover}})],1)})),0)};o._withStripped=!0,i(69212),i(60426);const n={props:{metrics:{type:Array,required:!0},selectedMetric:Object,enableHovering:Boolean,enableLegend:Boolean,highlightImportant:Boolean},data(){return{metricList:[...this.metrics]}},watch:{selectedMetric:function({index:e,hover:t}){const i={...this.metricList[e],hover:t};this.$set(this.metricList,e,i)},metrics:function(e){this.metricList=[...e]}},computed:{hasImportantMetrics(){return this.metrics.some((e=>e.is_important))}},methods:{onMetricHover(e){this.$emit("metric-hover",e)}}},s=(0,i(98822).A)(n,o,[],!1,null,"52b5ff63",null).exports},3390:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(){var e=this,t=e._self._c;return t("div",[t("top-gpu-metrics-header"),e._v(" "),t("layout-panel-template",e._l(["gpu","cpu"],(function(e){return t("top-gpu-metrics-card",{key:e,attrs:{type:e}})})),1)],1)};o._withStripped=!0;const n=(0,i(98822).A)({},o,[],!1,null,null,null).exports},3461:e=>{e.exports=' <h4>Vectorize call(s) to virtual method</h4> <div class="text"> <div class="promo"> Force vectorization of the <span data-glossary-id="source_loop">source loop</span> using SIMD instructions and/or generate vector variants of the function(s) using a <span data-glossary-id="directive">directive</span>: <table> <tr> <th> Target </th> <th> Directive </th> </tr> <tr> <td> Source loop </td> <td> #pragma omp simd </td> </tr> <tr> <td> Inner function definition or declaration </td> <td> #pragma omp declare simd </td> </tr> </table> <p class="expander">Example (original code)</p> <pre class="essential"><code class="cpp">struct A {\n    virtual double foo(double x) { return x+1; }\n};\n...</code></pre> <pre class="expansion"><code class="cpp">struct A {\n    virtual double foo(double x) { return x+1; }\n};\n\nstruct B : public A {\n    double foo(double x) override { return x-1; }\n};\n\n ...\n\nA* obj = new B();\n\ndouble sum = 0.0;\n#pragma omp simd reduction(+:sum)\nfor (int k = 0; k &lt; N; ++k) {\n    <b>// indirect call to virtual method</b>\n    <b>sum += obj->foo(a[k]);</b>\n}\n...</code></pre> </div> <p class="expander">Example (revised code)</p> <pre class="expansion"><code class="cpp">struct A {\n    <b>#pragma omp declare simd</b>\n    virtual double foo(double x) { return x+1; }\n};\n ...</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <i>omp simd</i>, <i>omp declare simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html">OpenMP* Pragmas Summary</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},3658:e=>{e.exports=' <h4>Align data</h4> <div class="text"> <p class="promo"> One of the memory accesses in the <span data-glossary-id="source_loop">source loop</span> does not start at an optimally aligned address boundary. To fix: Align the data and tell the compiler the data is aligned. To align data, use <samp class="codeph">__declspec(align())</samp>. To tell the compiler the data is aligned, use <samp class="codeph">__assume_aligned()</samp> before the source loop. </p> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/data-alignment-to-assist-vectorization.html">Data Alignment to Assist Vectorization</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},3661:e=>{e.exports=' <h4>Potential reduction detected</h4> <div class="text promo"> Potential reduction is detected in this code region. When rewriting the code with a target framework, implement the reduction pattern for this region. <p class="expander">Example of the reduction pattern in Data Parallel C++ (DPC++):</p> <pre class="essential"><code class="cpp" data-source="\n...\n    nd_range<1> workRange{range<1>{globalRange}, range<1>{localRange}}; \n...\n        cgh.parallel_for<class kernel_br>(workRange, reduction(sumAcc, (dataType)0, ext::oneapi::plus<dataType>()),  \n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\n    buffer<dataType, 1> dataBuffer(data, globalRange);\n    buffer<dataType, 1> sumBuffer(&sum, 1);\n\n    nd_range<1> workRange{range<1>{globalRange}, range<1>{localRange}}; \n    q.submit([&](handler &cgh)\n    {\n        auto dataAcc = dataBuffer.get_access<access::mode::read>(cgh);\n        auto sumAcc = accessor<dataType, 0, access::mode::read_write, access::target::global_buffer>(sumBuffer, cgh);\n        cgh.parallel_for<class kernel_br>(workRange, reduction(sumAcc, (dataType)0, ext::oneapi::plus<dataType>()),  \n            [=](nd_item<1> it, auto& sum)\n            {\n                int i = it.get_global_id(0);\n                sum.combine(dataAcc[i]); // universal operator of combination for any reduction\n            });\n    }).wait();\n"></code></pre> <b>Important:</b> When using a local range in the DPC++, make sure the number of data items (<b>globalRange</b>) is a multiple of the local range size (<b>localRange</b>). If required, align the number of data items with the local range size. <p class="expander">Example of reduction on OpenMP:</p> <pre class="essential"><code class="cpp" data-source="\n...\n    #pragma omp target parallel for map(to: data[0:globalRange]) reduction(+ : sum) \n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\n    float sum = 0.0f;\n    #pragma omp target parallel for map(to: data[0:globalRange]) reduction(+ : sum) \n    for (int i = 0; i < globalRange; ++i)\n        sum += data[i];\n"></code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://github.com/intel/llvm/blob/sycl/sycl/doc/extensions/Reduction/Reduction.md"> Reduction (draft specification)</a> </li> <li> <a href="https://github.com/Apress/data-parallel-CPP/tree/main/samples/Ch14_common_parallel_patterns"> Reduction samples</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/oneapi/optimization-guide-gpu/current/reduction.html"> Reduction (developer\'s guide)</a> </li> </ul> </div> '},3726:e=>{e.exports=' <h4>Remove OpenMP lock functions</h4> <div class="text"> <div class="promo"> Locking objects slows loop execution. To fix: Rewrite the code without OpenMP lock functions. <p class="expander">Example (original code)</p> <pre class="essential"><code class="cpp">int A[n];\nlist&lt;int&gt; L;\nomp_lock_t lock_obj;\n...\nomp_set_lock(&amp;(lock_obj));\nL.insert(L.begin(), A[i]);\nomp_unset_lock(&amp;(lock_obj));\n...</code></pre> <div class="expansion"> Allocating separate arrays for each thread and then merging them after a parallel recommendation may improve speed (but consume more memory). <pre><code class="cpp">int A[n];\nlist&lt;int&gt; L;\n...\nomp_lock_t lock_obj;\nomp_init_lock(&amp;lock_obj);\n#pragma omp parallel for shared(L, A, lock_obj) default(none)\nfor (int i = 0; i &lt; n; ++i)\n{\n    // A[i] calculation\n    ...\n    if (A[i]&lt;1.0)\n    {\n        omp_set_lock(&amp;(lock_obj));\n        L.insert(L.begin(), A[i]);\n        omp_unset_lock(&amp;(lock_obj));\n    }\n}\nomp_destroy_lock(&amp;lock_obj);</code></pre> </div> </div> <p class="expander">Example (revised code)</p> <pre class="essential"><code class="cpp">int A[n];\nlist&lt;int&gt; L;\nomp_set_num_threads(nthreads_all);\n...\nvector&lt;list&lt;int&gt;&gt; L_by_thread(nthreads_all); // separate list for each thread\n...\nL_by_thread[k].insert(L_by_thread[k].begin(), A[i]);\n...</code></pre> <pre class="expansion"><code class="cpp">int A[n];\nlist&lt;int&gt; L;\nomp_set_num_threads(nthreads_all);\n...\nvector&lt;list&lt;int&gt;&gt; L_by_thread(nthreads_all); // separate list for each thread\n#pragma omp parallel shared(L, L_by_thread, A) default(none)\n{\n    int k = omp_get_thread_num();\n    #pragma omp for nowait\n    for (int i = 0; i &lt; n; ++i)\n    {\n        // A[i] calculation\n        ...\n        if (A[i]&lt;1.0)\n        {\n            L_by_thread[k].insert(L_by_thread[k].begin(), A[i]);\n        }\n   }\n}\n\n// merge data into single list\nfor (int k = 0; k &lt; L_by_thread.size(); k++)\n{\n  L.splice(L.end(), L_by_thread[k]);\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-C4F1EB9B-55AE-4F8B-8237-53E09A936BF2.html">Calling Functions on the CPU to Modify the Coprocessor\'s Execution Environment</a>; <i>Lock Routines recommendation</i> in <a href="docs:C++/17/index.htm#GUID-D3FC1F0B-DD99-4176-B9B5-56EEE72E81A7.html">OpenMP Run-time Library Routines</a>; <i>omp for</i>, <i>omp parallel recommendations</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html">OpenMP* Pragmas Summary</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},3861:(e,t,i)=>{"use strict";i.d(t,{Vd:()=>s,pE:()=>o,q8:()=>n});const o=150,n=300,s=2e3},4144:e=>{e.exports=' <h4>Opportunity for outer loop vectorization</h4> <div class="disclaimer">This an early version of \'outer loop vectorization\' issue and will be enhanced with more information over time.</div> <div class="essential"> This is outer (non-innermost) loop. Normally outer loops are not targeted by auto-vectorization. Outer loop vectorization is also possible and sometimes more profitable, but requires explicit vectorization using OpenMP* API. </div> '},4438:()=>{function e(e,t){if(!e)return;const i=e.querySelector("#no_dependency_disclaimer");i&&i.Visible(t.no_dependency_disclaimer)}window.rec_fma_enforce_vec_c=e,window.rec_fma_enforce_vec_f=e},5065:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(39959)),s={setSwitchViewChangeReason(e,{eventName:t,value:i}){n.default.set(e.switchViewChangeReason,t,i)},setCollectionRunning(e,{eventName:t,value:i}){n.default.set(e.collectionRunning,t,i)},setEventLog(e,{eventName:t,data:i}){n.default.set(e.eventLog,t,i)},setEventLogMessageCount(e,{eventName:t,count:i}){n.default.set(e.eventLogMessageCount,t,i)},setCollectorOutput(e,{eventName:t,data:i}){n.default.set(e.collectorOutput,t,Object.freeze(i))},setApplicationOutput(e,{eventName:t,data:i}){n.default.set(e.applicationOutput,t,Object.freeze(i))},setApplicationOutputLength(e,{eventName:t,length:i}){n.default.set(e.applicationOutputLength,t,i)},setEventField(e,{event:t,field:i,value:o}){n.default.set(t,i,o)},setTopSliderHeight(e,t){n.default.set(e.topSlider,"height",t)},setOutputHeight(e,t){n.default.set(e.topSlider,"outputHeight",t)},setEventLogContentHeight(e,t){n.default.set(e.topSlider,"eventLogContentHeight",t)},setRecommendationsContainerHeight(e,t){n.default.set(e.topSlider,"recommendationsContainerHeight",t)},setTopSliderCondition(e,t){n.default.set(e.topSlider,"condition",t)},setTopSliderPrevCondition(e,t){n.default.set(e.topSlider,"prevCondition",t)},setRecommendationsPinned(e,t){n.default.set(e.topSlider,"isRecommendationsPinned",t)},setRecommendationsVisible(e,t){n.default.set(e.topSlider,"isRecommendationsVisible",t)},setEventLogVisible(e,t){n.default.set(e.topSlider,"isEventLogVisible",t)},setAppOutputVisible(e,t){n.default.set(e.topSlider,"isAppOutputVisible",t)},setCollectorOutputVisible(e,t){n.default.set(e.topSlider,"isCollectorOutputVisible",t)},setAutoShowRecommendations(e,t){n.default.set(e.topSlider,"isAutoShowRecommendations",t)}};t.default=s},5246:(e,t)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const i={props:{data:Object},methods:{tooltipProcessor(e,t){return this.data.tooltips[t]}}};t.A=i},5306:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this;return(0,e._self._c)("button",e._g(e._b({class:e.$props},"button",e.$attrs,!1),e.$listeners),[e._t("default")],2)};o._withStripped=!0;const n={props:{quiet:Boolean}},s=(0,i(98822).A)(n,o,[],!1,null,"2c64ccac",null).exports},5339:e=>{e.exports=' <h4>Add more parallel work</h4> <div class="text promo"> Add more parallel work to this region. For example, use a larger dataset or collapse nested loop iteration space. <div id="run_performance_modeling_disclaimer" class="disclaimer"> <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/run-offload-modeling-perspective.html">Run Performance Modeling</a> with <samp class="codeph"> <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/threads.html"> --threads=&lt;threads-num&gt;</a></samp> flag, where <samp class="codeph">&lt;threads-num&gt;</samp> is the size of the increased iteration space. Use this flag to estimate how increased iteration space impacts potential performance. </div> By default, the flag is applied to all modeled regions. Use the <samp class="codeph"> <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/select.html"> --select=&lt;loops&gt;</a></samp> flag to select specific loops to model. </div> '},5664:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(e,t){return e("transition",{attrs:{name:"slide"}},[t._t("default")],2)};o._withStripped=!0;const n=(0,i(98822).A)({},o,[],!0,null,"1313937d",null).exports},5805:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>B});var o=function(){var e=this,t=e._self._c;return t("nav",{directives:[{name:"show",rawName:"v-show",value:e.issues.length>0,expression:"issues.length > 0"}],ref:"wrapper",staticClass:"nav"},[t("header",{domProps:{innerHTML:e._s(e.$t("toc"))}}),e._v(" "),t("ul",{staticClass:"issue"},e._l(e.issues,(function(i){return i.header?t("li",{key:i.id},[t("a",{staticClass:"item issue",attrs:{href:`#${i.id}`},domProps:{innerHTML:e._s(i.header)}}),e._v(" "),t("ul",{staticClass:"rec"},e._l(i.recommendations,(function(i){return i.header?t("li",{key:i.id},[t("a",{staticClass:"item",attrs:{href:`#${i.id}`},domProps:{innerHTML:e._s(i.header)}})]):e._e()})),0)]):e._e()})),0)])};o._withStripped=!0;var n=i(17807),s=(i(36094),i(69212),i(45361),i(27725)),r=i.n(s);i(21602);const a={ease:[.25,.1,.25,1],linear:[0,0,1,1],"ease-in":[.42,0,1,1],"ease-out":[0,0,.58,1],"ease-in-out":[.42,0,.58,1]};let l=!1;try{let e=Object.defineProperty({},"passive",{get:function(){l=!0}});window.addEventListener("test",null,e)}catch(e){}const c={$:e=>"string"!=typeof e?e:document.querySelector(e),on(e,t,i,o={passive:!1}){t instanceof Array||(t=[t]);for(let n=0;n<t.length;n++)e.addEventListener(t[n],i,!!l&&o)},off(e,t,i){t instanceof Array||(t=[t]);for(let o=0;o<t.length;o++)e.removeEventListener(t[o],i)},cumulativeOffset(e){let t=0,i=0;do{t+=e.offsetTop||0,i+=e.offsetLeft||0,e=e.offsetParent}while(e);return{top:t,left:i}},cubicBezierArrayFrom:e=>Array.isArray(e)?e:"string"==typeof e?a[e]?a[e]:e.split(",").map((e=>+e)):a.ease};let d={container:"body",itemSelector:".scroll-item",activeClass:"active",el:null,duration:600,easing:"ease",scrollX:!1,scrollY:!0,offset:0,onScrollOffsetX:void 0,onScrollOffsetY:void 0,alwaysTrack:!1,cancelable:!0,stopPropagation:!0,onStart:null,onDone:null,onCancel:null,onActiveItem:null,anchor:!0,hash:null,clickToScroll:!0,clickedNavItem:null,navItems:[]};const p=e=>d=Object.assign({},d,e);function u(e){return d}const h=e=>function(e){let t={};for(let i in e){let o=m(e[i]);t[i]={type:o,default:o===Array||o===Object?()=>e[i]:e[i]}}return t}(e||d);function m(e){switch(t=e,Object.prototype.toString.call(t).slice(8,-1)){case"Object":return Object;case"Array":return Array;case"String":return String;case"Number":return Number;case"Boolean":return Boolean;case"RegExp":return RegExp;default:return null}var t}const f=["mousedown","wheel","DOMMouseScroll","mousewheel","keyup","touchmove"],v=(()=>{let e,t,i,o,n,s,a,l,d,p,h,m,v,g,_,y,b,w,x,C,A,S,T,I,P,M,E,L,R,D,k=e=>{s&&(M=e,P=!0)};function O(e){if(P)return N();L||(L=e),R=e-L,D=Math.min(R/i,1),D=E(D),z(t,A+I*D,x+T*D),R<i?window.AFRequestID=window.requestAnimationFrame(O):N()}function N(){P||z(t,S,C),L=!1,_&&function(e){e&&(window.history.pushState?window.history.pushState(null,null,e):window.location.hash=e)}(g),b&&!w&&B(v,y),P&&d&&d(M),l&&l(),c.off(t,f,k),setTimeout((()=>{c.on(t,"scroll",w,{passive:!0})}),100)}function z(e,t,i){h&&(e.scrollTop=t),p&&(e.scrollLeft=i),"body"===e.tagName.toLowerCase()&&(h&&(document.documentElement.scrollTop=t),p&&(document.documentElement.scrollLeft=i))}function B(e,t){t.forEach((e=>{e.classList.remove(m)})),e&&e.classList.add(m)}return function(L,R,D={}){if("object"==typeof R?D=R:"number"==typeof R&&(D.duration=R),e=c.$(L),!e)return console.warn(`[navscroll-js]: Trying to scroll to element "${L}" that is not on the page. Make sure it is set in the DOM.`);const N=u();if(t=c.$(D.container||N.container),!t)return console.warn(`[navscroll-js]: Scrolling container "${D.container||N.container}" is not present on the page.`);i=D.duration||N.duration,o=D.easing||N.easing,n=D.offset||N.offset,s="cancelable"in D?!1!==D.cancelable:N.cancelable,a=D.onStart||N.onStart,l=D.onDone||N.onDone,d=D.onCancel||N.onCancel,p=void 0===D.scrollX?N.scrollX:D.scrollX,h=void 0===D.scrollY?N.scrollY:D.scrollY,m=void 0===D.activeClass?N.activeClass:D.activeClass,v=D.clickedNavItem||N.clickedNavItem,g=v?v.hash||v.dataset.href:D.hash||N.hash,_=void 0===D.anchor?N.anchor:D.anchor,y=D.navItems||N.navItems,b=void 0===D.alwaysTrack?N.alwaysTrack:D.alwaysTrack,w="function"==typeof D.trackingFn?D.trackingFn:N.trackingFn;let z=c.cumulativeOffset(e);return A=function(e){let t=e.scrollTop;return"body"===e.tagName.toLowerCase()&&(t=t||document.documentElement.scrollTop),t}(t),S=z.top-t.offsetTop-n,x=function(e){let t=e.scrollLeft;return"body"===e.tagName.toLowerCase()&&(t=t||document.documentElement.scrollLeft),t}(t),C=z.left-t.offsetLeft-n,P=!1,I=S-A,T=C-x,o=c.cubicBezierArrayFrom(o),E=r().apply(r(),o),I&&T||(i=0),a&&a(g),b||(c.off(t,"scroll",w),window.cancelAnimationFrame(window.AFRequestID),B(v,y)),c.on(t,f,k,{passive:!0}),window.requestAnimationFrame(O),()=>{M=null,P=!0}}})();let g,_,y,b,w=[],x=[];const C={scrollTo:v,onScroll:M,initObserver:I,unbindObserver:L,setDefaults:p,getDefaults:u,bindings:w,utils:c,navigationWrapper:y,navigationItems:x,navItemsClassName:g,getVueComponentProps:h,bind(e,t){A(e,t)},update(e,t){A(e,t)},unbind(e){T(e)},props:h(),template:'\n    <nav class="navscroll-js">\n      <slot></slot>\n    </nav>\n  ',mounted(){S(this.$el,this.$props,!0)},updated(){S(c.$(this.$el),this.$props,!0)},beforeDestroy(){T(this.$el)}};function A(e,t){t.el||t.element||e.hash||e.dataset.href;const i=Object.assign({},t.value);i.isWrapper=!!t.arg,i.isWrapper&&(i.itemSelector=`.${t.arg}`),S(e,i,i.isWrapper)}function S(e,t,i){const o=u();t.isWrapper=i,i?I(e,t.itemSelector,t):(R(e).binding=t,(void 0===t.clickToScroll?t.clickToScroll:o.clickToScroll)?c.on(e,"click",P):c.off(e,"click",P))}function T(e){let t=R(e).binding;u(),t.isWrapper?L(t):E(e)}function I(e,t,i){let o;const n=u();if(y=c.$(e),g=t||n.itemSelector,!y)return;if(o=R(y).binding=Object.assign({},R(y).binding,i,{isWrapper:!0}),!function(e){const t=u();let i=c.$(e.container||t.container);return i?(R(i).binding=e,c.on(i,"scroll",M,{passive:!0}),!0):console.warn(`[navscroll-js]: Could not attach scroll handler to the container "${e.container||t.container}" because it was not found. Make sure it is in the DOM and then call \`initObserver(wrapper, itemSelector, options)\` yourself with options.container properly set.`)}(o))return;const s=window.MutationObserver||window.WebKitMutationObserver;function r(e){y&&(x.forEach((e=>E(e))),x=[].slice.call(y.querySelectorAll(g)),(void 0===o.clickToScroll?n.clickToScroll:o.clickToScroll)?x.forEach((e=>{let t=o.el||o.element||e.hash||e.dataset.href;R(e).binding=Object.assign({},o,{el:t}),c.on(e,"click",P)})):x.forEach((e=>{c.off(e,"click",P)})),M())}_=new s(r),_.observe(y,{childList:!0,subtree:!0}),r()}function P(e){e.preventDefault();const t=R(this).binding||{},i=u(),o=e.currentTarget;if((void 0===t.stopPropagation?i.stopPropagation:t.stopPropagation)&&e.stopPropagation(),"string"==typeof t)return v(t,{clickedNavItem:o,navItems:x});t.clickedNavItem=o,t.navItems=x,t.trackingFn=M,v(t.el||t.element,t)}function M(e){let t;const i=u(),o=R(y).binding;let n=c.$(o.container||i.container),s=o.onScrollOffsetY||2*Math.round((window.innerHeight||document.documentElement.clientHeight)/3),r=o.onScrollOffsetX||2*Math.round((window.innerWidth||document.documentElement.clientWidth)/3),a=void 0===o.activeClass?i.activeClass:o.activeClass,l=void 0===o.scrollX?i.scrollX:o.scrollX,d=void 0===o.scrollY?i.scrollY:o.scrollY;if(n){if(x.forEach((e=>{e.classList.remove(a);const i=e.hash?e.hash.substr(1):e.dataset.href,o=document.getElementById(i);if(!o)return;let p=c.cumulativeOffset(o);d&&n.scrollTop>=p.top-s&&(t=e),l&&n.scrollLeft>=p.left-r&&(t=e)})),t!==b){let e=o.onActiveItem||i.onActiveItem;e&&e(b,t),b=t}t&&t.classList.add(a)}}function E(e){D(e),c.off(e,"click",P)}function L(e){x.forEach((e=>{E(e)})),x=[],g=void 0,D(y),y=void 0,_&&(_.disconnect(),_=void 0),function(e){const t=u();let i=c.$(e.container||t.container);i&&(D(i),c.off(i,"scroll",M))}(e)}function R(e){let t=function(e){for(let t=0;t<w.length;++t)if(w[t].el===e)return w[t]}(e);return t||(w.push(t={el:e,binding:{}}),t)}function D(e){for(let t=0;t<w.length;++t)if(w[t].el===e)return w.splice(t,1),!0;return!1}const k=function(e,t){t&&p(t),e.directive("navscroll",C),e.component("navscroll",C),e.prototype.$scrollTo=C.scrollTo};C.install=k,"undefined"!=typeof window&&window.Vue&&(window.NavScroll=C,Vue.use(k));const O=C;var N=i(57143);n.Ay.use(O);const z={props:{issues:{type:Array,required:!0},target:{type:String,required:!0}},data(){return{resizeObserver:new N.default(this.updateObserver)}},methods:{updateObserver(){const{wrapper:e}=this.$refs,{target:t}=this;if(e&&document.getElementById(t)){const{top:i}=e.getBoundingClientRect();this.navscrollOptions={container:"#"+t,activeClass:"active",itemSelector:".item",onScrollOffsetY:i+5,offset:i-5,duration:800,alwaysTrack:!1,easing:".5,0,.35,1",onStart:this.onStartEvent},O.unbindObserver(this.navscrollOptions),O.initObserver(e,".item",this.navscrollOptions)}},onStartEvent(e){e&&this.$bus.$emit("rec-"+e)},onHeaderClicked(e){this.$scrollTo(e,this.navscrollOptions)}},mounted(){this.$bus.$on("rec-header-clicked",this.onHeaderClicked),this.resizeObserver.observe(this.$el)},beforeDestroy(){this.$bus.$off("rec-header-clicked",this.onHeaderClicked),this.resizeObserver.disconnect()}},B=(0,i(98822).A)(z,o,[],!1,null,"7efae6c4",null).exports},5957:(e,t,i)=>{"use strict";i.d(t,{O:()=>r}),i(69212),i(43827),i(21602);var o=i(61262),n=i(86480),s=i(18323);function r(e,t,i,r,a,l,c,d,p,u,h){e=e||[];const m={row:t,column:i,rowId:h,gridPane:a,...c},{copySelection:f,copyCell:v,exportCSV:g,expandAllSubrows:_,hideColumn:y,showAllColumns:b,showColumnSettings:w}=r,x=s.A.getMessage("grid_choose_columns");let C=0;const A=[{caption:s.A.getMessage("copy_selection_caption")+"\t"+("mac"===o.default.Consts.os?"⌘C":"Ctrl + C"),command:f},{caption:s.A.getMessage("copy_cell_caption"),disabled:t<0,command:v.bind(void 0,t,i)},{caption:"-",noReport:!0},{caption:s.A.getMessage("export_to_csv"),command:g,noReport:!0},{caption:"-"},{caption:s.A.getMessage("grid_hide_column"),disabled:()=>!a.grid.canColumnBeHidden(i),command:y.bind(void 0,i)},{caption:s.A.getMessage("grid_show_all_columns"),disabled:()=>!a.grid.hasInvisibleColumns(),command:b},{caption:x,command:w.bind(void 0,x)},{caption:"-"},{caption:s.A.getMessage("grid_expand_all_subrows"),disabled:t<0,command:_.bind(void 0,t)}];if(e.length>0){const t=e.every((e=>e.noReport));A.unshift({caption:"-",noReport:t})}const S=e.concat(A).map((e=>e.command?(C+=1,{id:C,...e}):e));l.stopPropagation=!0,n.A.show(S,d,p,u,m)}},6013:function(e,t,i){"use strict";i(27468),i(69212),i(43468),i(32204);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(57721)),s=o(i(85038)),r=i(77106),a="fdMeasuredTime",l="fdEstTotalTimeOnTarget",c=["fdTimeByCompute","fdTimeByDRAMBW","fdTimeByL1BW","fdTimeByL3BW","fdTimeByLLCBW","fdTimeBySLMBW","fdTimeByHBMBW","fdTimeByAtomic","fdTimeByGDDR6BW"],d=["fdLoadLatency","fdAtomicLatency","fdDataTransferTax","fdKernelLaunchTax"],p=["fdTotalTimeMPI","fdTotalTimeOMP","fdTotalTimeTBB","fdTotalTimeDAAL","fdTotalTimeDPCPP","fdTotalTimeOCL","fdTotalTimeSystem"];function u(e){return(0,r.getMarkerColor)({marker:e})}const h={fdTimeByCompute:u("compute"),fdTimeByDRAMBW:u("memory"),fdTimeByL1BW:u("l1"),fdTimeByL3BW:u("l3"),fdTimeByLLCBW:u("llc"),fdTimeBySLMBW:u("slm"),fdTimeByHBMBW:u("hbm"),fdTimeByAtomic:u("atomic"),fdTimeByGDDR6BW:u("memory"),fdDataTransferTax:u("data_transfer"),fdKernelLaunchTax:u("invoke_tax"),fdLoadLatency:u("load"),fdAtomicLatency:u("atomic"),fdTotalTimeMPI:u("cpu_time"),fdTotalTimeOMP:u("cpu_time"),fdTotalTimeTBB:u("cpu_time"),fdTotalTimeDAAL:u("cpu_time"),fdTotalTimeDPCPP:u("cpu_time"),fdTotalTimeOCL:u("cpu_time"),fdTotalTimeSystem:u("cpu_time")},m={inject:["api"],mixins:[n.default],data:()=>({metrics:{},rowId:""}),created(){this.colors=s.default},computed:{isNoData(){return!Object.values(this.metrics).length},loopIcon(){return this.metrics.isLoop?"icon loop":void 0},regionType(){return this.getMetric("fdRegionType")},regionTypeIcon(){const{value:e}=this.regionType;try{const{deps:t}=JSON.parse(e);if(!t)return;return"P"===t?"icon arrow-mass-right":"icon arrow-mass-deny-right"}catch{return}},loopName(){return this.getMetric("fdFunctionName")},measuredTime(){return{...this.getMetric(a),title:this.$t("acc_regions_measured_time")}},efficiency(){const e=this.measuredTime,t=this.estimatedTime,i=Math.max(this.getRawValue(e),this.getRawValue(t))||1;return[{id:a,title:this.$t("acc_regions_efficiency_cpu"),formattedValue:e.value,tooltip:e.tooltip,values:[this.getRawValue(e)/i],colors:[u("cpu_time")]},{id:l,title:this.$t("acc_regions_efficiency_gpu"),formattedValue:t.value,tooltip:t.tooltip,values:[this.getRawValue(t)/i],colors:[u("time_after_acc")]}]},boundedBy(){const e=this.getMetric("fdOffloadBoundedBy");return e&&e.value&&e.value.indexOf(",")>-1&&(e.value=e.value.split(",")[0]),e},boundedByMetrics(){const e=e=>{const t=this.getMetric(e),i=t.title,o=t.tooltip,n=this.getRawValue(t)/a,s=t.value;if(i)return{id:e,title:i,tooltip:o,formattedValue:s,values:[n],colors:[h[e]]}},t=e=>e.reduce(((e,t)=>e+this.getRawValue(this.getMetric(t))),0),i=c.reduce(((e,t)=>Math.max(e,this.getRawValue(this.getMetric(t)))),0),o=t(d),n=t(p),s=this.getRawValue(this.estimatedTime),a=Math.max(s,i+o+n);let l=a-(i+o);const m=i/a,f=c.map((t=>{const i=e(t);return i&&(i.valueMax=m),i}));let v=l>0?m:1-o/a,g=1-l/a;const _=d.map((t=>{const i=e(t);return i&&(i.valueMin=v,i.valueMax=g,v+=i.values[0]),i}));let y=[];n>0&&(y=p.map((t=>{const i=e(t);if(i){const e=i.values[0];if(e>0)return i.valueMin=g,g+=e,l-=e*a,i}})));let b=[];if(l>1e-4){let e=l,t="s";e<1&&(e*=1e3,t="ms"),b=[{id:"REST",title:this.$t("acc_regions_non_accelerable_time"),formattedValue:(0,r.formatNumber)({value:e,postfix:t,digits:1,type:"f"}),tooltip:this.$t("acc_regions_non_accelerable_time_descr"),valueMin:g,values:[l/a],colors:[u("cpu_time")]}]}let w=[];const x=[...f,..._,...y,...b].filter((e=>!!e));if(x.length){const e=JSON.parse(JSON.stringify(this.efficiency[1]));e.title=this.$t("acc_regions_estimated_time"),e.values=[1],w=[e]}return[...x,...w]},estimatedTime(){return{...this.getMetric(l),title:this.$t("acc_regions_estimated_time")}},speedUp(){return this.getMetric("fdSpeedUp")},whyNotOffloaded(){const{value:e=""}=this.getMetric("fdIsOffloaded")||{};return"no"===e.toLowerCase()?this.getMetric("fdWhyNotOffloaded"):void 0}},methods:{getMetric(e,t={}){return this.metrics[e]||t},getRawValue:e=>e&&e.rawValue||0,async onSelectionChanged({rowId:e}){e&&(this.rowId=this.getCurrentRowId(e),this.metrics=await this.api.offload.acceleratedRegions.get("details",{request:"getRowData",params:{rowId:this.rowId}})||{})}}};t.default=m},6195:(e,t,i)=>{"use strict";i.r(t),i.d(t,{CAN_COLLAPSE:()=>n.CAN_COLLAPSE,CAN_DOCK:()=>n.CAN_DOCK,CAN_HRESIZE:()=>n.CAN_HRESIZE,CAN_MOVE:()=>n.CAN_MOVE,CAN_RESIZE:()=>n.CAN_RESIZE,CAN_SWAP:()=>n.CAN_SWAP,CAN_VRESIZE:()=>n.CAN_VRESIZE,CLOSE_BY_CROSS_BUTTON:()=>n.CLOSE_BY_CROSS_BUTTON,DIRECTION_COLUMN:()=>n.DIRECTION_COLUMN,DIRECTION_HORIZONTAL:()=>n.DIRECTION_HORIZONTAL,DIRECTION_ROW:()=>n.DIRECTION_ROW,DIRECTION_VERTICAL:()=>n.DIRECTION_VERTICAL,HIDE_BY_CROSS_BUTTON:()=>n.HIDE_BY_CROSS_BUTTON,Layout:()=>o.default,STATE_ACTIVE:()=>n.STATE_ACTIVE,STATE_COLLAPSED:()=>n.STATE_COLLAPSED,STATE_HIDDEN:()=>n.STATE_HIDDEN,STATE_NORMAL:()=>n.STATE_NORMAL,TYPE_PANEL:()=>n.TYPE_PANEL});var o=i(20544),n=i(60970)},6263:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(19158),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},6276:function(e,t,i){"use strict";i(36094),i(27468),i(69212),i(43468),i(38333),i(21602),i(32204);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(85038)),s=o(i(25405)),r=i(77106),a=i(1067),l={getOpsAndBandwidthData:e=>t=>{const{roofs:i=[],metrics:o=[]}=e.opsAndBandwidth.data[t]||{};return o.map((e=>{const{value:t,formattedValue:o}=i.find((t=>t.id===e.roofId))||{},s=e.isDominatingOps?n.default.intel.accent.red:n.default.dark.L8;return{...e,maxValue:t,formattedMaxValue:o||e.postfix,color:s}}))},getDominatingOps:e=>t=>{const{metrics:i=[]}=e.opsAndBandwidth.data[t]||{};return i.find((e=>e.isDominatingOps))},getInstructionMixData:e=>t=>{const{instructionMix:i}=e.opsAndBandwidth.data[t]||{};return i},getTopHotspotsData:e=>t=>{const{columns:i={},rows:o=[]}=e.topHotspots.data[t]||{},l=Object.entries(i).filter((([e])=>!["globalSize","localSize","active","stalled","idle"].includes(e))).map((([e,i])=>{const{postfix:o,maxValue:s,title:l,tooltip:c}=i;let d,p;return o?d=t=>(0,r.formatNumber)({value:t[e]||0,type:"f",digits:2,postfix:o}):s?(d=t=>(0,r.formatNumber)({value:t[e]||0,type:"f",digits:3}),p=t===a.GPU?n.default.intel.primary.blue:n.default.dark.L8):d=t=>t[e],{id:e,title:l,getValue:d,tooltip:c,color:p,maxValue:s}})),{globalSize:c,localSize:d,active:p,stalled:u,idle:h}=i;return c&&d&&l.push({id:"mergedSize",title:`${c.title}/${d.title}`,getValue:e=>`${e.globalSize||0}/${e.localSize||0}`,tooltip:c.tooltip&&d.tooltip?`<b>${c.title}</b>: ${c.tooltip}<br/>\n               <b>${d.title}</b>: ${d.tooltip}`:void 0}),p&&u&&h&&l.push({id:"mergedState",title:`${p.title}/${u.title}/${h.title}, ${p.postfix}`,getValue:e=>{const t=(0,r.formatNumber)({value:100*e.active,type:"f",digits:1}),i=(0,r.formatNumber)({value:100*e.stalled,type:"f",digits:1}),o=(0,r.formatNumber)({value:100*e.idle,type:"f",digits:1});return{value:`${t}/${i}/${o}`,values:[t,i,o],colors:[s.default.active,s.default.stalled,s.default.idle]}},tooltip:p.tooltip&&u.tooltip&&h.tooltip?`<b>${p.title}</b>: ${p.tooltip}<br/>\n               <b>${u.title}</b>: ${u.tooltip}<br/>\n               <b>${h.title}</b>: ${h.tooltip}`:void 0,maxValue:100}),{columns:l,rows:o.map((e=>l.map((t=>t.getValue(e))))),rowIds:o.map((e=>e.rowId))}},getCpuPerformanceCharData:e=>e.performanceChar.data[a.CPU]||{},getGpuPerformanceCharData:e=>e.performanceChar.data[a.GPU]||[],getPlatformInformationData:e=>{const t=e.platformInformation.data[a.GPU]||{};return Object.entries(t).map((([e,t])=>({title:e,children:t.map((({formatted_value:e,...t})=>({formattedValue:e,...t})))})))},getCpuPlatformInformationData:e=>e.platformInformation.data[a.CPU]||{},getProgramMetricsHeaderData:e=>{const t=e.programMetrics.data.cpu||{},i=e.programMetrics.data.gpu||[],o=t.elapsedTime,n=o.value,r={...t.cpuTime,maxValue:n,color:s.default.cpu_time},a={...i.find((e=>"gpuDataTransferTime"===e.id)),maxValue:n,color:s.default.data_transfer};return[o,{...i.find((e=>"gpuTime"===e.id)),maxValue:n,color:s.default.gpu_time},a,r]},getCpuProgramMetricsData:e=>{const t=e.programMetrics.data.cpu||{};return{main:(()=>{const e=[];for(const i of["cpuThreads"]){const o=t[i];o&&e.push(o)}return e})(),additional:t}},getCpuProgramMetricsAdditionalData:(e,t)=>{const i=t.getCpuProgramMetricsData.additional;for(const e in i)i[e].formattedValue=(0,r.formatNumber)(i[e]);const{title:o}=t.getDominatingOps(a.CPU)||{};return[{...i.gflops,isDominatingOps:i.gflops.title===o,children:[{...i.gflops_count},{...i.floatAI}]},{...i.gintops,isDominatingOps:i.gintops.title===o,children:[{...i.gintops_count},{...i.intAI}]}]},getGpuProgramMetricsData:e=>{const t=e.programMetrics.data.gpu||[];return{main:t.filter((e=>["tileUtilization","fpuUtilization","euThreadOccupancy","euIpcRate"].includes(e.id))),additional:t}},getGpuProgramMetricsAdditionalData:(e,t)=>{const i=t.getGpuProgramMetricsData.additional.reduce(((e,t)=>Object.assign(e,{[t.id]:{...t}})),{}),o=t.getOpsAndBandwidthData(a.GPU),n=e=>{const{maxValue:t,color:n}=o.find((t=>t.id===e))||{};return{...i[e],maxValue:t,color:n}};return[{...n("gflops"),children:[{...i.opFloat},{...i.aiFloat}]},{...n("gintops"),children:[{...i.opInt},{...i.aiInt}]},{...n("gtigpu"),children:[{...i.gtigputraffic}]},{...n("hbmgpu"),children:[{...i.hbmgputraffic}]},{...n("dramgpu"),children:[{...i.dramgputraffic}]}]},getGpuHeaderMetricsData:(e,t)=>{const{isProgramMetricsAvailable:i,getGpuProgramMetricsData:o}=t;return i?o.main:[]},getCollectionInformationData:e=>e.collectionInformation.data||{},getImpactsSummaryData:(e,t)=>null,getDataLoadedStatus:(e,t,i,o)=>{const{getDataLoadedStatus:n}=o;return n("/gpu")},getDataLoadedHash:(e,t)=>{const{getDataLoadedStatus:i}=t,{hash:o}=i||{};return o},canRequestData:(e,t)=>{const{getDataLoadedStatus:i}=t,{data:o}=i||{},{state:n}=o||{};return!!i&&"no data"!==n},isImpactsSummaryAvailable:(e,t)=>!1,isOpsAndBandwidthAvailable:(e,t)=>{const{getOpsAndBandwidthData:i}=t,o=i(a.CPU);return i(a.GPU).length>0||o.length>0},isTopHotspotsAvailable:(e,t)=>{const{getTopHotspotsData:i}=t,o=i(a.CPU),n=i(a.GPU);return n.rows&&n.rows.length>0||o.rows&&o.rows.length>0},isPerformanceCharAvailable:(e,t)=>{const{getGpuPerformanceCharData:i,getCpuPerformanceCharData:o}=t;return i.length>0||Object.keys(o).length>0},isPlatformInformationAvailable:(e,t)=>{const{getPlatformInformationData:i,getCpuPlatformInformationData:o}=t;return i.length>0||Object.keys(o).length>0},isProgramMetricsAvailable:(e,t)=>{const{getGpuProgramMetricsData:i,getCpuProgramMetricsData:o}=t;return i.main.length>0||i.additional.length>0||o.main.length>0||Object.keys(o.additional).length>0},isCollectionInfoAvailable:(e,t)=>{const{getCollectionInformationData:i}=t;return Object.keys(i).length>0}};t.default=l},7835:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>u});var o=function(){var e=this,t=e._self._c;return e.isAvailable?t("section",{staticClass:"modeling-pane",class:{disabled:e.$store.direct.getters.workflow.isReadOnly}},[e.isRemodelAvailable?t("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("remodeling_tooltip"),expression:"$t('remodeling_tooltip')"}],on:{click:e.runRemodel}},[t("i",{staticClass:"icon play"})]):t("button",{class:{disabled:!e.canSaveConfig},on:{click:e.saveConfig}},[t("i",{staticClass:"icon download"}),e._v(" "+e._s(e.$t("save_config"))+"\n  ")]),e._v(" "),e.targetDeviceKnob?t("dropdown",{attrs:{knob:e.targetDeviceKnob,"enum-style":"s-target","highlight-changes":"",light:""},on:{onKnobChanged:e.onDeviceChanged}}):e._e(),e._v(" "),t("div",{staticClass:"buttons"},[e.isRemodelAvailable?t("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("save_config"),expression:"$t('save_config')"}],attrs:{disabled:!e.canSaveConfig},on:{click:e.saveConfig}},[t("i",{staticClass:"icon download"})]):e._e(),e._v(" "),t("button",{attrs:{disabled:!e.canResetToModeled},on:{click:e.resetToModeled}},[e._v("\n      "+e._s(e.$t("reset_to_modeled"))+"\n    ")]),e._v(" "),t("button",{attrs:{disabled:!e.canSetToDefault},on:{click:e.setToDefault}},[e._v("\n      "+e._s(e.$t("set_to_default"))+"\n    ")])]),e._v(" "),t("h3",[t("i",{staticClass:"icon chevron-small-right light",on:{click:t=>(e.$el.style.maxHeight=e.$el.style.maxHeight?"":"initial",t.target.classList.toggle("on"))}}),e._v("\n    "+e._s(e.$t("hardware_params"))),t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("hardware_params_tooltip"),expression:"$t('hardware_params_tooltip')"}],staticClass:"icon help-circle light"})]),e._v(" "),e._l(e.valuesParams,(function({value:i,initialValue:o},n){return e.get(n)?t("slider",{key:n,attrs:{label:e.get(n).title||n,tooltip:e.get(n).tooltip||e.$t("user_model_param"),"log-scale":!!e.get(n).log,min:e.get(n).min,max:e.get(n).max,value:i,"initial-value":o,"ref-value":e.targetDeviceValues[n],"ref-value-tooltip":e.$t("set_to_default"),edges:e.edges(n)},on:{change:t=>e.updateValue(n,t)}},[t("span",{style:e.getValueStyle(n)},[e._v(e._s(e.getValue(n)))])]):e._e()})),e._v(" "),t("transition",{attrs:{name:"slide"}},[e.commandLine?t("div",{staticClass:"notice"},[t("i",{directives:[{name:"show",rawName:"v-show",value:e.notice,expression:"notice"}],staticClass:"icon information-circle"}),e._v(" "),t("div",[t("div",{directives:[{name:"show",rawName:"v-show",value:e.notice,expression:"notice"}],staticClass:"notice",domProps:{innerHTML:e._s(e.$t("cmd_line_notice"))}}),e._v(" "),t("div",{staticClass:"cmdline"},[t("input",{ref:"input",attrs:{type:"text",readonly:""},domProps:{value:e.commandLine}}),e._v(" "),t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("cmd_line_copy"),expression:"$t('cmd_line_copy')"}],staticClass:"icon",class:e.copyIcon,on:{click:e.copyCmdLine}})])]),e._v(" "),t("i",{directives:[{name:"show",rawName:"v-show",value:e.notice,expression:"notice"}],staticClass:"icon cross",on:{click:function(t){e.notice=!e.notice}}})]):e._e()])],2):e._e()};o._withStripped=!0,i(83038),i(88984),i(2449),i(66824),i(37271),i(16124),i(29590),i(69212),i(43468),i(38333),i(45361),i(21602),i(60426);var n=i(83230),s=i(77106),r=i(85038),a=i(8933),l=i(33202),c=i(99046),d=i(84620);const p={data:()=>({notice:!0,copyIcon:"copy",commandLine:"",targetDeviceValues:{},valuesParams:{}}),computed:{isRemodelAvailable(){return this.baseline.GPU&&!(0,a.P)()},baseline(){return this.$store.direct.getters.workflow.baselineDeviceValue},resultValuesModelParams(){return this.$store.direct.state.offload.modelingPane.data.resultValuesModelParams},resultTargetDevice(){return this.$store.direct.state.offload.modelingPane.data.resultTargetDevice},isAvailable(){return this.$store.direct.getters.offload.isModelingPaneAvailable},modelParams(){return this.$store.direct.state.offload.modelingPane.data.modelParams},targetDeviceKnob(){var e,t,i;const{targetDeviceKnob:o}=this.$store.direct.state.offload.modelingPane.data;if(!(0,s.has)(o))return;const n=(null===(e=this.targetDeviceValues)||void 0===e?void 0:e.device_name)||(null===(t=o.items.find((({value:e})=>{o.value})))||void 0===t?void 0:t.displayValue)||"",r=(null===(i=this.resultValuesModelParams)||void 0===i?void 0:i.device_name)||this.resultTargetDevice||"";return{...o,name:this.$t("target_device"),description:this.$t("target_device_tooltip",n,r)}},canSaveConfig(){return this.targetDeviceKnob.value!==this.resultTargetDevice||Object.values(this.valuesParams).some((({value:e,initialValue:t})=>t>=0&&e!==t))},canSetToDefault(){const{valuesParams:e,targetDeviceValues:t}=this;return Object.keys(e).some((i=>!!(0,s.valid)(t[i])&&e[i].value!==t[i]))},canResetToModeled(){return Object.values(this.valuesParams).some((({value:e,initialValue:t})=>t>=0&&e!==t))}},watch:{resultValuesModelParams:{handler:"valuesParamsFill",immediate:!0},async isAvailable(e){e&&await this.fetchTargetDevice(this.targetDeviceKnob)}},methods:{get(e){return this.modelParams[e]},valuesParamsFill(e){const t={};Object.keys(e).forEach((i=>t[i]={initialValue:e[i],value:e[i]})),this.valuesParams=t},setToDefault(){const{valuesParams:e,targetDeviceValues:t}=this;Object.keys(e).forEach((i=>{(0,s.valid)(t[i])&&(e[i].value=t[i])}))},async resetToModeled(){this.targetDeviceKnob.value=this.resultTargetDevice,await this.onDeviceChanged(this.targetDeviceKnob);const{valuesParams:e}=this;Object.keys(e).filter((t=>e[t].initialValue>=0)).forEach((t=>e[t].value=e[t].initialValue))},getValueStyle(e){const{value:t}=this.valuesParams[e],{min:i,max:o}=this.modelParams[e]||{};return(0,s.valid)(i)&&(0,s.valid)(o)?t<i?{color:r.light.watermark}:t>o?{color:r.brand.rust.default}:{}:{color:r.light.L8,fontWeight:600}},getValue(e,t="OFF",i="∞"){var o;const{value:n}=this.valuesParams[e];if(!(0,s.isNumeric)(n))return n;const{units:r={},step:a,min:l,max:c}=this.modelParams[e]||{};if(n<l)return t;if(n>c)return i;const d=Object.entries(r).sort(((e,t)=>e[1]-t[1])),p=d.map((e=>e[0])),u=d.map((e=>e[1])),h=(0,s.lower_bound)(u,n),m=-1===h?1:u[h],f=-1===h?"":p[h];return`${(0,s.roundTo)(n/m,(0,s.getPrecision)(a))} ${f}${(null===(o=this.modelParams[e])||void 0===o?void 0:o.postfix)||""}`},updateValue(e,t){const{min:i,max:o,step:n}=this.modelParams[e]||{},s=this.targetDeviceValues[e];if(!(t+1e-7<i)&&!(t-1e-7>o)&&t!==s&&n>0&&t>1){const e=t<n?Math.min(1,t):n;t=Math.round(t/e)*e}this.valuesParams[e].value=t},edges(e){const{min_na:t,max_na:i}=this.modelParams[e]||{};return[t,i].map(s.valid)},async fetchTargetDevice(e){var t;if(!e)return;this.targetDeviceValues=await n.default.get("modelingPane","targetDeviceValues",e.value)||{};const{targetDeviceValues:i,modelParams:o}=this,r=new Set(Object.keys(this.valuesParams));Object.keys(i||{}).map((e=>{var t,n;if(i[e]=(0,s.parseValue)(i[e],null===(t=o[e])||void 0===t?void 0:t.postfix,null===(n=o[e])||void 0===n?void 0:n.units),!r.has(e)){const t=i[e];this.valuesParams[e]={value:t,initialValue:-1}}}));const a=new Set(Object.keys(i)),l={};if(a.size>0&&i.device_id===(null===(t=this.valuesParams)||void 0===t||null===(t=t.device_id)||void 0===t?void 0:t.initialValue)){const e=["Tiles_per_process","Stacks_per_process"].find((e=>r.has(e)));void 0!==e&&a.add(e)}return Object.keys(this.modelParams).filter((e=>0===a.size?r.has(e):a.has(e))).forEach((e=>l[e]=this.valuesParams[e])),this.valuesParams=l,e},async onDeviceChanged(e){this.valuesParamsFill(this.resultValuesModelParams);const t=await this.fetchTargetDevice(e),{valuesParams:i,targetDeviceValues:o}=this;Object.keys(i).map((e=>{(0,s.valid)(o[e])?i[e].value=o[e]:i[e].value=i[e].initialValue})),this.$store.direct.commit.offload.setModelingTargetDeviceKnob({targetDeviceKnob:t})},getConfig(){const e={device_id:this.targetDeviceKnob.value};return Object.keys(this.valuesParams).forEach((t=>{const{min_na:i=0,max_na:o=0}=this.modelParams[t],n=this.getValue(t,i,o);e[t]=(0,s.isNumeric)(n)?parseFloat(n):n.toString().trim()})),Object.entries(e).map((([e,t])=>`${e} = ${JSON.stringify(t)}`)).join("\n")},async saveConfig(){const e=this.getConfig();let t,i;(0,a.P)()?(i=(0,c.U1)(),t=await(0,s.saveAs)(e,"config.toml")):(i=await n.default.workflow.getProject(),t=await n.default.get("modelingPane","saveConfiguration",e));const{projectPath:o}=i,{gpu_profiling:r}=(0,c.QB)(i).projection;this.commandLine=function(e,t,i,o="./path/to/project"){return t?`advisor -c=projection --custom-config=${(0,s.safePathWrap)(t)} --config=${e} ${i.join(" ")} --project-dir=${(0,s.safePathWrap)(o)}`:""}(this.targetDeviceKnob.value,t,[r&&"--gpu"].filter(Boolean),o),await(0,s.sleep)(1300);const{input:l}=this.$refs;if(l){const e=this.commandLine.indexOf(t);l.focus(),l.setSelectionRange(e,e+t.length),l.scrollLeft=0}},runRemodel(){const e=this.targetDeviceKnob.value,t=this.getConfig();this.$store.direct.dispatch.workflow.onRunCollection({analysisTypes:[d.ActivityType.atProjection]}),n.default.workflow.send("run-remodel",{config_toml:t,device_id:e})},async copyCmdLine(){(0,a.P)()?navigator.clipboard.writeText(this.commandLine):await(0,l.mi)("copy-to-clipboard",this.commandLine),this.copyIcon="check solid",await(0,s.sleep)(3e3),this.copyIcon="copy"}},async mounted(){await this.fetchTargetDevice(this.targetDeviceKnob)}},u=(0,i(98822).A)(p,o,[],!1,null,"f3be86ca",null).exports},7958:e=>{e.exports=' <h4>Confirm dependency is real</h4> <div class="text promo"> <div id="no_dependency_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a> to identify real data dependencies. </div> There is no confirmation that a real (proven) dependency is present in the loop. <span id="actions" style="display:none"> To confirm: Run a <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a>.</span> </div>'},8175:e=>{e.exports=' <h4>Unoptimized floating point operation processing possible</h4> <div class="essential"> Improve performance by enabling approximate operations instructions. </div>'},8185:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"metric"},[t("div",{staticClass:"value"},[e._v(e._s(e.value))]),e._v(" "),t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.metric.tooltip,expression:"metric.tooltip"}],staticClass:"title"},[e._v("\n    "+e._s(e.metric.title||e.$t(e.metric.id))+"\n    "),e.metric.tooltip?t("i",{staticClass:"icon help-circle"}):e._e()])])};o._withStripped=!0;var n=i(77106);const s={props:{metric:{type:Object,required:!0}},computed:{value(){const{formattedValue:e}=this.metric;return e||(0,n.formatNumber)(this.metric)||this.$t("no_data")}}},r=(0,i(98822).A)(s,o,[],!1,null,"0b35d0ed",null).exports},8546:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=i(75337),s=o(i(61262)),r=i(32035),a=i(38235),l={props:{eventName:{type:String,required:!0}},data:()=>({contentHeightObserver:void 0,resizeProcessor:void 0,resizeInfo:{},contentHeight:void 0}),mounted(){this.contentHeightObserver=new ResizeObserver(this.onObserveContentHeight),this.contentHeightObserver.observe(this.$refs.content),this.resizeProcessor=s.default.createResizeProcess(this.$el,{accepted(e){const t=e.classList.contains("idvc2_splitter_vert_splitter");if(t){const{resizeInfo:t}=this;t.splitter=e,e.classList.add("idvc2_grid_splitter_hover"),t.prevSibling=e.previousElementSibling,t.nextSibling=e.nextElementSibling,t.nextInitialHeight=s.default.getElementPos(t.nextSibling).height,t.prevInitialHeight=s.default.getElementPos(t.prevSibling).height}return t},getDelta:(e,t,i)=>e.y-i.y,getCursor:()=>"ns-resize",onProcess(e){const{prevSibling:t,prevInitialHeight:i,nextInitialHeight:o}=this.resizeInfo,n=a.MIN_SPLITTER_SIZE;let s=i+e;s<n&&(s=n,e=n-i);let r=o-e;r<n&&(r=n,s=i+(e=o-n)),t.style["flex-basis"]=`${s}px`,this.$store.direct.dispatch.log.setOutputHeight(r)},onEnd(){this.resizeInfo.splitter.classList.remove("idvc2_grid_splitter_hover"),this.resizeInfo={}}},this)},beforeDestroy(){this.contentHeightObserver.unobserve(this.$refs.content),this.resizeProcessor&&this.resizeProcessor.destroy()},computed:{...(0,n.mapGetters)("log",["getCollectorOutput","getApplicationOutput","getOutputHeight"]),isCollectionRunning(){return this.$store.direct.getters.log.isCollectionRunning(this.eventName)},events(){return this.$store.direct.getters.log.getEventsByType(this.eventName,a.EVENT_TYPE_EVENT)},collectorOutput(){return this.getCollectorOutput(this.eventName)},applicationOutput(){return this.getApplicationOutput(this.eventName)},hasApplicationOutput(){return this.$store.direct.getters.log.hasApplicationOutput(this.eventName)},hasCollectorOutput(){return this.$store.direct.getters.log.hasCollectorOutput(this.eventName)},hasAnyOutput(){return this.hasApplicationOutput||this.hasCollectorOutput},hasBothOutputs(){return this.hasApplicationOutput&&this.hasCollectorOutput},outputStyle(){return{"flex-basis":`${this.getOutputHeight||a.DEFAULT_OUTPUT_HEIGHT}px`}}},methods:{onObserveContentHeight(e){const[t]=e,{contentRect:i}=t,{height:o}=i,n=Math.ceil(o);this.contentHeight!==n&&(this.$store.direct.dispatch.log.setEventLogContentHeight(n),this.contentHeight=n)},onCloseAppOutput(){this.$store.direct.dispatch.log.toggleAppOutputVisible(!1)},onCloseCollectorOutput(){this.$store.direct.dispatch.log.toggleCollectorOutputVisible(!1)}},watch:{events(){const{content:e}=this.$refs;e&&(0,r.scrollToEnd)(this,e.$el)}}};t.default=l},8686:(e,t,i)=>{var o={"./bar-metric.vue":25443,"./code-analytics/code-optimizations-block.vue":50918,"./code-analytics/efficiency-summary-block.vue":45666,"./code-analytics/flops-summary-block.vue":74141,"./code-analytics/func-summary-block.vue":24887,"./code-analytics/instr-mix-block.vue":16169,"./code-analytics/loop-summary-block.vue":53102,"./code-analytics/memory-metrics-block.vue":38340,"./code-analytics/memory-summary-block.vue":74264,"./code-analytics/roofline-guidance-block.vue":78300,"./code-analytics/traits-summary-block.vue":44316,"./code-analytics/trip-count-summary-block.vue":17653,"./collection-log/collection-output.vue":37653,"./collection-log/event-log.vue":92227,"./collection-log/message-box.vue":65348,"./collection-log/message-buttons.vue":1843,"./collection-log/message-image.vue":79200,"./collection-log/message-text-item.vue":38965,"./collection-log/message-text.vue":67368,"./collection-log/output-log.vue":9432,"./data-loading.vue":20095,"./data-transfer-hints/code-snippet.vue":41975,"./data-transfer-hints/data-transfer-hint.vue":39699,"./data-transfer-hints/dpcpp-usm-usage.vue":12101,"./data-transfer-hints/omp-map-usage.vue":98933,"./data-transfer/data-transfer-block.vue":85744,"./data-transfer/sections/analytics-section.vue":46757,"./data-transfer/sections/compute-tasks-section.vue":17036,"./data-transfer/sections/data-and-tax-section.vue":61716,"./data-transfer/sections/data-transfer-hints-section.vue":10042,"./data-transfer/sections/offloaded-objects-section.vue":54469,"./details-section.vue":32466,"./details/gpu-details-block.vue":10361,"./details/offload-details-block.vue":87408,"./details/sections/conclusions-section.vue":30521,"./details/sections/header-section.vue":59029,"./details/sections/instruction-mix-details-section/instruction-mix-details-filter.vue":56799,"./details/sections/instruction-mix-details-section/instruction-mix-details-section.vue":33014,"./details/sections/instruction-mix-details-section/instruction-mix-details-table.vue":51941,"./details/sections/instruction-mix-section.vue":99042,"./details/sections/memory-metrics-section.vue":27714,"./details/sections/performance-char-section.vue":33352,"./details/sections/summary-metric-group.vue":40773,"./details/sections/summary-metric.vue":23806,"./details/sections/summary-section.vue":22818,"./disabled-overlay.vue":13631,"./filters-block/filters-block.vue":92573,"./gpu-summary/collection-information-block.vue":91581,"./gpu-summary/flops-list.vue":66393,"./gpu-summary/impacts-summary-block.vue":25215,"./gpu-summary/layout-panel-card.vue":40941,"./gpu-summary/layout-panel-group.vue":29993,"./gpu-summary/legend-metric.vue":34800,"./gpu-summary/metric-item-box.vue":83534,"./gpu-summary/ops-and-bandwidth-block.vue":78373,"./gpu-summary/ops-and-bandwidth-card.vue":92264,"./gpu-summary/performance-characterization-block.vue":84190,"./gpu-summary/performance-characterization-cpu-card.vue":24953,"./gpu-summary/performance-characterization-gpu-card.vue":42933,"./gpu-summary/platform-information-block.vue":28973,"./gpu-summary/top-gpu-metrics-block.vue":3390,"./gpu-summary/top-gpu-metrics-card.vue":60984,"./gpu-summary/top-gpu-metrics-header.vue":97301,"./gpu-summary/top-hotspots-block.vue":86442,"./gpu-summary/top-hotspots-card.vue":63814,"./grid-controls/idvc-grid.vue":92104,"./grid-controls/idvc-source-view.vue":68201,"./header-panel/add-panel.vue":18964,"./header-panel/buttons/button-add.vue":37490,"./header-panel/buttons/button-event-log.vue":11959,"./header-panel/buttons/button-filter.vue":11435,"./header-panel/buttons/button-html-report.vue":75110,"./header-panel/buttons/button-offload-filter.vue":34049,"./header-panel/buttons/button-recommendations.vue":67418,"./header-panel/buttons/button-route.vue":65879,"./header-panel/buttons/button-snapshot.vue":355,"./header-panel/buttons/button-source-layout.vue":14926,"./header-panel/header-metric-block.vue":90793,"./header-panel/header-metric.vue":8185,"./header-panel/header-panel.vue":30241,"./header-panel/navigation-dropdown.vue":16257,"./header-panel/navigation.vue":22217,"./idvc-bar-chart.vue":74880,"./idvc-pie-chart.vue":49473,"./idvc-splitter.vue":28819,"./layout-panel-template.vue":49602,"./layout/bottom-splitter.vue":75829,"./layout/collapsed-list.vue":42248,"./layout/header-tab.vue":67185,"./layout/layout-container.vue":20544,"./layout/layout-guide.vue":21673,"./layout/layout-panel.vue":34919,"./layout/layout-placeholder.vue":54995,"./layout/layout-splitter.vue":14624,"./layout/panel-draggable.vue":42128,"./layout/panel-header.vue":51382,"./modeling-direction-block/direction-svg.vue":39708,"./modeling-direction-block/modeling-direction-block.vue":61250,"./no-data.vue":91452,"./offload-summary/characterization-metrics-block.vue":93153,"./offload-summary/metric-item-box.vue":48706,"./offload-summary/metric-item.vue":37445,"./offload-summary/metric-list-donut-chart.vue":98692,"./offload-summary/metric-list.vue":3377,"./offload-summary/metrics-bar-chart.vue":31608,"./offload-summary/metrics-donut-chart.vue":75441,"./offload-summary/program-metrics-block.vue":45656,"./offload-summary/region-time-chart.vue":96287,"./offload-summary/table-view.vue":8977,"./offload-summary/top-non-offloaded-block.vue":43823,"./offload-summary/top-offload-metrics-block.vue":29427,"./offload-summary/top-offloaded-block.vue":20236,"./option-selector.vue":15968,"./perspective-selector/perspective-button.vue":22207,"./perspective-selector/perspective-selector-footer.vue":81089,"./perspective-selector/perspective-selector-header.vue":59991,"./perspective-selector/perspective-selector-pane.vue":33823,"./recommendation-pane/ideas-list-item.vue":41280,"./recommendation-pane/ideas-list.vue":86466,"./recommendation-pane/issues-list-item.vue":74232,"./recommendation-pane/issues-list-nav.vue":5805,"./recommendation-pane/issues-list.vue":9834,"./recommendation-pane/rec-attributes.vue":39299,"./recommendation-pane/rec-headline.vue":91565,"./recommendation-pane/rec-main-footer.vue":46481,"./recommendation-pane/rec-main-header.vue":98969,"./recommendation-pane/recommendation-pane.vue":83699,"./roofline.vue":73990,"./scrollable-container.vue":35144,"./simple-bar-chart.vue":40187,"./slide-transition.vue":5664,"./slider.vue":54043,"./spark-button.vue":5306,"./toggle-switch.vue":2793,"./top-slider/top-slider-featured-events.vue":43399,"./top-slider/top-slider-header.vue":30712,"./top-slider/top-slider-list-item.vue":1715,"./top-slider/top-slider-list.vue":31156,"./top-slider/top-slider-meter.vue":10511,"./top-slider/top-slider-recommendations.vue":31623,"./top-slider/top-slider-splitter.vue":39907,"./top-slider/top-slider.vue":68546,"./tree-list/tree-list-node.vue":46339,"./tree-list/tree-list.vue":38649,"./vertical-toolbar/vertical-toolbar-button.vue":84733,"./vertical-toolbar/vertical-toolbar.vue":51730,"./welcome-page/welcome-actions.vue":15885,"./welcome-page/welcome-page.vue":29397,"./with-no-data.vue":88327,"./workflow/accuracy.vue":71746,"./workflow/analysis-status-icon.vue":87898,"./workflow/analysis.vue":49452,"./workflow/baseline-device-panel.vue":93411,"./workflow/knobs/action-button.vue":48956,"./workflow/knobs/checkbox.vue":73267,"./workflow/knobs/dropdown.vue":27730,"./workflow/knobs/input-number.vue":84597,"./workflow/knobs/unknown.vue":40535,"./workflow/main-run-panel.vue":8880,"./workflow/modeling-pane.vue":7835,"./workflow/overhead-indicator.vue":75835,"./workflow/perspective-selector.vue":84383,"./workflow/perspective.vue":33103,"./workflow/remodel-run-panel.vue":64917,"./workflow/run-panel.vue":78052,"./workflow/target-panel.vue":97157,"./workflow/workflow-button.vue":71697,"./workflow/workflow.vue":50677};function n(e){var t=s(e);return i(t)}function s(e){if(!i.o(o,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return o[e]}n.keys=function(){return Object.keys(o)},n.resolve=s,e.exports=n,n.id=8686},8781:e=>{e.exports=' <h4>Use the Intel short vector math library for vector intrinsics</h4> <div class="text"> <div class="promo">Your application calls scalar instead of vectorized versions of math functions. To fix: Do all of the following: <ul> <li> Use the <samp class="codeph">-mveclibabi=svml</samp> compiler option to specify the Intel short vector math library ABI type for vector instrinsics. </li> <li> Use the <samp class="codeph">-ftree-vectorize</samp> and <samp class="codeph">-funsafe-math-optimizations</samp> compiler options to enable vector math functions. </li> <li> Use the <samp class="codeph">-L/path/to/intel/lib</samp> and <samp class="codeph">-lsvml</samp> compiler options to specify an SVML ABI-compatible library at link time. </li> </ul> <p class="expander">Example</p> <pre class="essential"><code class="bash">gcc program.c -O2 -ftree-vectorize -funsafe-math-optimizations -mveclibabi=svml -L/opt/intel/lib/intel64 -lm -lsvml -Wl,-rpath=/opt/intel/lib/intel64</code></pre> <div class="expansion"> <pre><code class="bash">gcc program.c -O2 -ftree-vectorize -funsafe-math-optimizations -mveclibabi=svml -L/opt/intel/lib/intel64 -lm -lsvml -Wl,-rpath=/opt/intel/lib/intel64</code></pre> <pre><code class="cpp">#include "math.h"\n#include "stdio.h"\n#define N 100000\n\nint main()\n{\n    double angles[N], results[N];\n    int i;\n    srand(86456);\n\n    for (i = 0; i &lt; N; i++)\n    {\n        angles[i] = rand();\n    }\n\n    // the loop will be auto-vectorized\n    for (i = 0; i &lt; N; i++)\n    {\n        results[i] = cos(angles[i]);\n    }\n\n   return 0;\n}</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://gcc.gnu.org/onlinedocs/gcc-4.5.3/gcc/i386-and-x86_002d64-Options.html">GCC options</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},8880:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>h});var o=function(){var e=this,t=e._self._c;return t("section",{staticClass:"main-run-panel"},[t("div",{staticClass:"workflow-commands"},[t("run-panel",{attrs:{commands:e.commands,analysisTypes:e.analysisTypes}})],1)])};o._withStripped=!0;var n=i(75337),s=i(32095),r=i(77106),a=i(3861),l=i(83230),c=i(18977);const d={created(){c.A.workflow.runBatchMode((e=>{const{analysisTypes:t}=this;return t&&t.length?(this.$store.direct.dispatch.workflow.onRunCollection({analysisTypes:t}),l.default.workflow.executeCommand(s.CommandType.ctRunCollection,t),t):"Error: No selected analyses on workflow"}))}};var p=i(84620);const u={mixins:[d,{created(){c.A.workflow.executeCommand((e=>{const{cmdName:t}=e,i=s.CommandType[t];if(void 0===i)return"Error: No command found";let o=this.analysisTypes||[];const{analysisName:n}=e;if(n){const e=p.ActivityType[n];if(void 0===e)return"Error: Analysis name incorrect";o=[e]}return 0===o.length?"Error: No analysis found":(i!==s.CommandType.ctRunCollection&&i!==s.CommandType.ctStartPausedCollection||this.$store.direct.dispatch.workflow.onRunCollection({analysisTypes:o}),l.default.workflow.executeCommand(i,o),o)}))}},{created(){c.A.workflow.getBatchModeState((e=>({visible:this.$store.direct.getters.workflow.isButtonVisible({cmd:s.CommandType.ctRunCollection,analysisTypes:[]}),active:this.$store.direct.getters.workflow.isButtonAvailable({cmd:s.CommandType.ctRunCollection,analysisTypes:[]})})))}}],props:{commands:{type:Array,validator:e=>Array.isArray(e)},analysisTypes:{type:Array,validator:e=>Array.isArray(e)}},computed:{...(0,n.mapGetters)("workflow",["isSaving"])},methods:{...(0,n.mapActions)("workflow",["onRunCollection"]),async runMRUAnalysis(){for(this.onRunCollection({analysisTypes:this.analysisTypes});this.isSaving;)await(0,r.sleep)(a.pE);await l.default.workflow.executeCommand(s.CommandType.ctRunCollection,this.analysisTypes)}},created(){l.default.workflow.onRunMRUAnalysis(this.runMRUAnalysis)},destroyed(){l.default.workflow.offRunMRUAnalysis(this.runMRUAnalysis)}},h=(0,i(98822).A)(u,o,[],!1,null,"52e8b976",null).exports},8933:(e,t,i)=>{"use strict";i.d(t,{P:()=>o});const o=function(){let e;return function(){return void 0===e&&(e=document.body.classList.contains("report")),e}}()},8956:e=>{e.exports=' <h4>Enable inline expansion</h4> <div class="text"> <p class="promo"> Inlining of user-defined functions is disabled by compiler option. To fix: When using the <samp class="codeph">Ob</samp> or <samp class="codeph">inline-level</samp> compiler option to control inline expansion, replace the <samp class="codeph">0</samp> argument with the <samp class="codeph">1</samp> argument to enable inlining when an <samp class="codeph">inline</samp> keyword or attribute is specified or the <samp class="codeph">2</samp> argument to enable inlining of any function at compiler discretion. </p> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td><p><samp class="codeph">/Ob1</samp> or <samp class="codeph">/Ob2</samp></p></td> <td><p><samp class="codeph">-inline-level=1</samp> or <samp class="codeph">-inline-level=2</samp></p></td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-53B736C9-3A0A-4CC0-931B-1A1EDF7BF668.htm">inline-level, Ob</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},8977:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return e.isAvailable?t("div",{staticClass:"table",style:e.columnsTemplateStyle},[e._l(e.cols,(function({title:i,tooltip:o},n){return t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:o,expression:"tooltip"}],key:n,class:e.headerClass,style:e.getCellStyle(0,n)},[t("label",{staticClass:"caption",domProps:{innerHTML:e._s(i)}}),e._v(" "),o?t("i",{staticClass:"icon help-circle"}):e._e()])})),e._v(" "),t("div",{staticClass:"row-line",style:e.getRowLineStyle(0)}),e._v(" "),e._l(e.rows,(function(i,o){return[e._l(e.cols,(function(n,s){return t("div",{key:o+"-"+s,class:e.getCellClass(s),style:e.getCellStyle(o+1,s)},[e._t(n.id,(function(){return[e._v("\n        "+e._s(e.value(i,n))+"\n      ")]}),{row:i,column:n,value:i[n.id]})],2)})),e._v(" "),t("div",{key:"line"+o,staticClass:"row-line",style:e.getRowLineStyle(o+1)})]}))],2):t("no-data")};o._withStripped=!0,i(27468),i(69212),i(32204);var n=i(77106);const s={props:{columns:{type:[Array,Object],required:!0},rows:{type:Array,required:!0},singleLineHeader:{type:Boolean,default:!1}},computed:{cols(){return Array.isArray(this.columns)?this.columns:Object.values(this.columns)},isAvailable(){return this.cols.length>0&&this.rows.length>0},columnsTemplateStyle(){return this.cols.reduce(((e,t)=>e+`${t.width||"auto"} `),"grid-template-columns: ")},headerClass(){return"cell header"+(this.singleLineHeader?" single-line":"")}},methods:{formatNumber:n.formatNumber,value(e,t){const i={value:e[t.id],formattedValue:e[`${t.id}_formatted`],...t};return i.formattedValue||(0,n.formatNumber)(i)},getCellStyle:(e,t)=>`grid-row: ${2*e+1}; grid-column: ${t+1}`,getCellClass(e){const t=this.cols[e]||{};return`cell ${t.align?t.align:""}`},getRowLineStyle(e){return`grid-row: ${2*e+2}; grid-column: 1 / ${this.cols.length+1}`}}},r=(0,i(98822).A)(s,o,[],!1,null,"a4f75dca",null).exports},9007:(e,t,i)=>{"use strict";i.d(t,{A:()=>d}),i(36094),i(69212),i(45361);var o=i(61262),n=i(49463),s=i(87011),r=i(90895);function a(e){(e=o.default.getDomElement(e)).classList.add("idvc2_chart_top"),this.labels=[],this.values=[],this.centralPart=n.A.createCentralPart(e,!0),this.centralPart.body.style.top="0",this.centralPart.body.style.minWidth="1px",this.labelsAxis=n.A.createVertAxis(e,!0),this.labelsAxis.onformat=e=>this.labels[e]||"",this.labelsAxis.noValuePosCheck=!0,this.valuesAxis=n.A.createVertAxis(e,!0),this.valuesAxis.onformat=e=>this.values[e]||"",this.valuesAxis.body.classList.add("values_axis"),this.valuesAxis.noValuePosCheck=!0,this.index=0}function l(e){this.parent=o.default.getDomElement(e),this.parent.style.overflowY="auto",this.memItems=[],this.parent.refreshSize=function(){if(this._itemsData){let e=this._itemsData;delete this._itemsData,this.setData(e)}}.bind(this)}function c(e,t){this.caption=o.default.createElement("","roofline_memory_item_caption","",e);var i=o.default.createElement("","roofline_memory_item_body","",e);this.chart=new a(i),this.body=i,this.update(t)}a.prototype.setViewbox=function(e,t){this.centralPart.setViewbox(0,-.7,t,e-1- -.7),this.labelsAxis.setCentralPart(this.centralPart),this.valuesAxis.setCentralPart(this.centralPart)},a.prototype.addBar=function(e,t,i,o,n){this.labels.push(t);let s=n||Math.round(e).toString();this.values.push(s+o),function(e,t,i,o){e&&e.addRect(0,t-.3,i,.6).setStyle(`vector-effect: non-scaling-stroke; stroke: white; fill: ${o};`)}(this.centralPart.graphicsRoot,this.index,e,i),this.labelsAxis.addValue(this.index),this.valuesAxis.addValue(this.index),this.index++},a.prototype.clear=function(){this.index=0,this.centralPart.clear(),this.labelsAxis.clear(),this.valuesAxis.clear(),this.labels=[],this.values=[]},c.prototype.update=function(e){if(!e)return;let t=`<span>${e.caption}</span>`;e.explanation?t+=`<span class="idvc2_roofline_explanation_symbol" data-tooltip="${e.explanation}">?</span>`:t+="<span> </span>",this.caption.innerHTML=t;var i=e.metrics;if(Array.isArray(i)){this.chart.clear(),this.chart.centralPart.body.style.right="",this.chart.valuesAxis.body.style.width="",this.body.style.height=1.5*i.length+"em",this.chart.setViewbox(i.length,100),i.forEach(function(t){void 0!==t.val&&this.chart.addBar(t.val,r.A.getLoopMemoryLevel(t.label),t.color||"silver",e.measure||"",t.caption)}.bind(this));const t=this.chart.valuesAxis.getOptimalWidth(5)+"px";this.chart.centralPart.body.style.right=t,this.chart.valuesAxis.body.style.width=t,this.chart.valuesAxis.recreate()}},c.prototype.clear=function(){this.caption.innerHTML="",this.chart.clear(),this.body.style.height="1em"},c.prototype.delete=function(){this.clear(),this.caption.remove(),this.body.remove(),this.caption=this.body=void 0},l.prototype.setData=function(e){this.parent.offsetParent?Array.isArray(e)?(function(e){Array.isArray(e)&&e.forEach((function(e){e&&Array.isArray(e.metrics)&&e.metrics.forEach((function(e){e.color=s.A.getIntegratedRooflineColor(r.A.getLoopMemoryLevel(e.label))}))}))}(e),e.length<this.memItems.length&&(this.memItems.forEach((function(e){e.delete()})),this.memItems=[]),e.forEach(function(e,t){var i=this.memItems[t];i?i.update(e):this.memItems.push(new c(this.parent,e))}.bind(this))):this.clear():this._itemsData=e},l.prototype.clear=function(){this.memItems.forEach((function(e){e.clear()}))};const d={create:function(e){return new l(e)}}},9418:e=>{e.exports=' <h4>Reduce spills</h4> <div class="text"> <div class="promo"> %dpcpp_disclaimer% Reduce spills using the following techniques: make small distance between defining and using variables, avoid loop unrolling, recompute cheap-to-compute values, choose smaller data types. </div> <br> <ul> <li><b>Make the distance between loading a value to a variable and using the variable as short as possible.</b></li> <p> The compiler schedules instructions and optimizes the distances, but in some cases, moving a variable closer to define/use site may help the compiler to perform a better optimization. </p> <br> <li><b>Avoid excessive loop unrolling.</b></li> <p> Loop unrolling may improve performance, but temporary variables introduced by unrolling may increase pressure on register allocation and cause register <span data-glossary-id="spilling">spilling</span>. The directive <samp class="codeph">#pragma unroll</samp> (full unrolling) or <samp class="codeph">#pragma unroll N</samp> (where N is the <b>loop factor</b>, the number of loop body copies to generate) regulates loop unrolling. </p> <br> <p>Consider reducing the unroll factor or disable unrolling.</p> <p class="expander">Example of loop unrolling:</p> <pre class="essential"><code class="cpp" data-source="\n#pragma unroll N\n   "></code></pre> <pre class="expansion"><code class="cpp" data-source="\n#pragma unroll 1\nfor (j = 0; j < NNB; j++)\n{\n   ...\n}\n"></code></pre> <p> Even if you do not use the directive <samp class="codeph">#pragma unroll</samp>, the compiler might still enable the unrolling. Consider using <samp class="codeph">#pragma unroll 1</samp> to disable unrolling. </p> <br> <li><b>Recompute cheap-to-compute values on demand.</b></li> <p> Recompute cheap-to-compute values on demand. Otherwise, the values stay in registers for a long time and increase register pressure. </p> <br> <li><b>Avoid using big private arrays or large private structure.</b></li> <p> Big arrays may be promoted to <span data-glossary-id="GRF">GRF</span> increasing the register pressure or to an extended private memory region increasing the memory traffic. To improve performance, consider decreasing the size of the arrays to fit into <span data-glossary-id="GRF">GRF</span> or promoting such arrays to <span data-glossary-id="SLM">SLM</span>. </p> <br> <li><b>Choose smaller data types.</b></li> <p> Smaller data types occupy less space in <span data-glossary-id="GRF">GRF</span>. Use smaller data types to decrease the register pressure: </p><ul> <li><b>short/int</b> instead of <b>long</b></li> <li><b>float</b> instead of <b>double</b></li> </ul> <p></p> <br> </ul> </div> '},9432:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"log-content"},[t("div",{staticClass:"output-caption"},[e._v("\n    "+e._s(e.caption)+"\n    "),t("spark-button",{staticClass:"close",attrs:{quiet:""},on:{click:function(t){return e.$emit("close")}}},[t("i",{staticClass:"icon cross"})])],1),e._v(" "),e.gridRequestId?t("idvc-grid",{attrs:{"request-id":e.gridRequestId,"selection-id":e.gridSelectionId,"row-count":e.gridRowCount,cellPainters:e.logPainters,"no-hierarchy":e.gridNoHierarchy,"no-set-current-row":"","simple-grid":"","hide-header":"","expand-last-column":""}}):t("collection-output",{staticClass:"output-content",attrs:{items:e.arrayItems}})],1)};o._withStripped=!0;var n=i(68819);const s={paint(e){if(!e)return"";let t="";const i=0===e.indexOf("Warning: ")?(e=e.substring(9),"alert-triangle"):0===e.indexOf("Error: ")?(e=e.substring(9),"cross-circle"):0===e.indexOf("Fatal error: ")?(e=e.substring(13),"cross-circle"):"";return i&&(t=n.A.span("",{clsName:`icon ${i}`})),t+e}},r={props:{caption:{type:String,required:!0},items:{type:[Array,Object],required:!0}},data:()=>({logPainters:{log:s}}),computed:{arrayItems(){const{items:e}=this;return Array.isArray(e)&&e||[]},gridRequestId(){const{items:e}=this;return!Array.isArray(e)&&`${e.perspective}/log/${e.name}`||""},gridSelectionId(){return`${this.gridRequestId}/selection`||""},gridRowCount(){const{items:e}=this;return!Array.isArray(e)&&e.count||0},gridNoHierarchy(){const{items:e}=this;return!Array.isArray(e)&&e.isRuntime||!1}}},a=(0,i(98822).A)(r,o,[],!1,null,"1706462f",null).exports},9661:e=>{e.exports=' <h4>Reduce SIMD width</h4> <div class="text"> <div class="promo"> Current SIMD width is %gpu_current_row_simd_width%. Reduce SIMD width to %gpu_recommended_simd_width% to decrease <span id="simd_divergence_impact">SIMD divergence impact on vector instruction</span> <span id="spills_impact">spill impact on kernel</span> performance. </div> <span id="num_threads_text"> <b>Note: </b>As a result, the number of threads scheduled on an execution unit in parallel might grow, which improves performance. Current number of parallel threads is %parallel_threads% (%parallel_threads_per_eu% per EU). </span> <div class="promo"> <ul><li> With <a href="https://www.intel.com/content/www/us/en/develop/documentation/get-started-with-cpp-fortran-compiler-openmp/top.html">OpenMP* Offload programming model</a>, you can specify the preferred SIMD width with the <samp class="codeph">simdlen(&lt;SIMD_width&gt;)</samp> clause. </li></ul> </div> <ul><li style="list-style-type:none"> See the <a href="https://www.openmp.org/spec-html/5.1/openmpsu49.html">OpenMP* specification</a> for more details. </li></ul> <div class="promo"><ul><li style="list-style-type:none"> <p class="expander">Example of simdlen clause from OpenMP:</p> <pre class="essential"><code class="fortran" data-source="\n...\n        !$omp simd simdlen(16) !=SIMD_width  \n        do j = 1, SIMD_width                 \n...\n"></code></pre> <pre class="expansion"><code class="fortran" data-source="\n    vectorizedSize = N / SIMD_width\n    !$omp target parallel do map(to: arg1, arg2) map(from: sum)\n    do i = 1, vectorizedSize\n        !$omp simd simdlen(16) !=SIMD_width  \n        do j = 1, SIMD_width                 \n            curIndex = (i-1) * SIMD_width + j\n            sum(curIndex) = arg1(curIndex) + arg2(curIndex)\n        enddo\n    enddo\n"></code></pre> </li></ul></div> </div> '},9688:e=>{e.exports=' <h4>Convert to Fortran SIMD-enabled functions</h4> <div class="text"> <div class="promo"> Passing an array/array recommendation to an <samp class="codeph">ELEMENTAL</samp> function/subroutine is creating a dependency that prevents vectorization. To fix: <ul> <li> Enforce vectorization of the <span data-glossary-id="source_loop">source loop</span> using SIMD instructions and/or create a SIMD version of the function(s) using a <span data-glossary-id="directive">directive</span>: <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Target </th> <th> Directive </th> </tr> </thead> <tbody> <tr> <td> Source loop </td> <td> !$OMP SIMD </td> </tr> <tr> <td> Inner function definition or declaration </td> <td> !$OMP DECLARE SIMD </td> </tr> </tbody> </table> </li> <li> Call from a <samp class="codeph">DO</samp> loop. </li> </ul> <p class="expander">Example (original code)</p> <pre class="essential"><code class="fortran">elemental subroutine callee(t,q,r)\n    ...\nend subroutine callee\n...\ndo k = 1,nlev\n    call callee(a(:,k), b(:,k), c(:,k))\n...</code></pre> <pre class="expansion"><code class="fortran">elemental subroutine callee(t,q,r)\n    real, intent(in) :: t, q\n    real, intent(out) :: r\n    r = t + q\nend subroutine callee\n...\ndo k = 1,nlev\n    call callee(a(:,k), b(:,k), c(:,k))\nend do\n... </code></pre> </div> <p class="expander">Example (revised code)</p> <pre class="essential"><code class="fortran">subroutine callee(t,q,r)\n    !$OMP DECLARE SIMD(callee)\n    ...\nend subroutine callee\n...\ndo k = 1,nlev\n    !$OMP SIMD\n    do i = 1,n\n        call callee(a(i,k), b(i,k), c(i,k))\n...\n</code></pre> <pre class="expansion"><code class="fortran">subroutine callee(t,q,r)\n    !$OMP DECLARE SIMD(callee)\n    real, intent(in) :: t, q\n    real, intent(out) :: r\n    r = t + q\nend subroutine callee\n...\ndo k = 1,nlev\n    !$OMP SIMD\n    do i = 1,n\n        call callee(a(i,k), b(i,k), c(i,k))\n    end do\nend do\n... </code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-A9B9396B-3984-4DAA-887E-F5493F12B255.htm">DECLARE SIMD</a>, <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.htm">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/explicit-vector-programming-in-fortran.html">Explicit Vector Programming in Fortran</a>, <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},9744:e=>{e.exports=' <h4>Enable inline expansion</h4> <div class="text"> <p class="promo"> Inlining is disabled by compiler option. To fix: When using the <samp class="codeph">Ob</samp> or <samp class="codeph">inline-level</samp> compiler option to control inline expansion, replace the <samp class="codeph">0</samp> argument with the <samp class="codeph">1</samp> argument to enable inlining when an <samp class="codeph">inline</samp> keyword or attribute is specified or the <samp class="codeph">2</samp> argument to enable inlining of any function at compiler discretion. </p> <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /Ob1 or /Ob2 </td> <td> -inline-level=1 or -inline-level=2 </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-53B736C9-3A0A-4CC0-931B-1A1EDF7BF668.html">inline-level, Ob</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},9834:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return e.issues.length>0?t("section",{staticClass:"issues"},[e._t("top"),e._v(" "),t("section",e._l(e.issues,(function(e){return t("issues-list-item",{key:e.id,attrs:{issue:e,id:e.id}},[t("ideas-list",{attrs:{ideas:e.recommendations}})],1)})),1),e._v(" "),e._t("bottom")],2):e._m(0)};o._withStripped=!0;const n={props:{issues:{type:Array,required:!0}}},s=(0,i(98822).A)(n,o,[function(){var e=this,t=e._self._c;return t("div",{staticClass:"no_data_message"},[t("i",{staticClass:"icon document-text-strikethrough light"}),e._v(" "),t("div",{domProps:{innerHTML:e._s(e.$t("no_recs"))}})])}],!1,null,"191cb33e",null).exports},9903:e=>{e.exports=' <h4>Roofline conclusions</h4> <div class="essential"> Conclusions, with optimization recommendations, are sorted by relevance. <div id="roofline" class="padding"> <img id="plot_img"/> <span id="code_analytics_link"> You can switch to the Code Analytics tab to see a more detailed Roofline plot </span> </div> </div> '},10011:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>o});const o="data:image/png;base64,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"},10042:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",[e._l(e.data,(function(i){return[t("data-transfer-hint",{key:i,scopedSlots:e._u([{key:"title",fn:function(){return[e._v("\n        "+e._s(e.$t(i+"-title"))+"\n      ")]},proxy:!0}],null,!0)},[e._v(" "),t(i,{tag:"component",attrs:{slot:"content"},slot:"content"})],1)]}))],2)};o._withStripped=!0;var n=i(21807);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,null,null).exports},10120:e=>{e.exports=' <h4>User function call(s) present</h4> <div class="essential"> User-defined functions in the <span data-glossary-id="loop_body">loop body</span> are preventing the compiler from vectorizing the loop. </div>'},10361:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(74961),n=i(64413),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"fec56c0a",null).exports},10511:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>c});var o=function(){var e=this._self._c;return e("div",{staticClass:"meter"},[e("div",{staticClass:"progress",style:{width:this.progress}},[e("span")])])};o._withStripped=!0,i(27468),i(69212),i(43468),i(21602),i(32204);var n=i(83230),s=i(75337),r=i(84620),a=i(65196);const l={props:{eventName:{type:String,required:!0}},data:()=>({analysisProgress:[]}),async created(){const e=this.$store.state.activePerspectiveId,t=r.ProductMode.id2name[e],{analysisTypes:i}=await n.default.workflow.getPerspectiveDetails(e,t);this.analysisProgress=i.filter((({checked:e})=>e)).map((({id:e})=>({id:e,progress:0}))),this.updateAnalysisProgress()},computed:{...(0,s.mapGetters)("workflow",["getAnalysisStatus"]),progress(){return this.analysisProgress.reduce(((e,{progress:t},i)=>t>0?Math.max(e,i+t):e),0)/this.analysisProgress.length*100+"%"},isFinalization(){return this.$store.direct.getters.log.isCollectionFinalizing(this.eventName)}},methods:{updateAnalysisProgress(){const e=this.getAnalysisStatus;this.analysisProgress=this.analysisProgress.map((({id:t,progress:i})=>{const o=e[t];return 0===i&&o===a.Ze?{id:t,progress:.5}:i>0&&i<1&&o===a.Ze&&this.isFinalization?{id:t,progress:.9}:i>0&&o!==a.Ze?{id:t,progress:1}:{id:t,progress:i}}))}},watch:{getAnalysisStatus(){this.updateAnalysisProgress()},isFinalization(){this.updateAnalysisProgress()}}},c=(0,i(98822).A)(l,o,[],!1,null,"0238bb5a",null).exports},10780:e=>{e.exports=' <h4>Check dependencies for outer loop</h4> <div class="text promo"> <div id="no_dependency_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a> to identify real data dependencies. </div> It is not safe to force vectorization without knowing that there are no dependencies. <b>Disable inner vectorization before check Dependency.</b> <span id="actions" style="display:none">To check: Run a <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a>.</span> </div>'},11285:e=>{e.exports=' <h4>Avoid big arguments and/or complex structures in kernel arguments</h4> <div class="text promo"> The <a href="https://www.intel.com/content/www/us/en/develop/documentation/oneapi-programming-guide/top/oneapi-programming-model/c-fortran-with-openmp-offload-prog-model.html"> OpenMP* Offload Programming Model</a> uses indirect kernel arguments capture (for variables of simple types used in the kernel\'s code) and the <a href="https://www.openmp.org/spec-html/5.0/openmpsu109.html">map clause</a>. <br><br> Consider reducing kernel arguments number or size. </div> <div class="text"> <br> <ul> <li> <b>Consider using reduced data types for kernel arguments or reducing the number of arguments.</b> <br> Consider replacing kernel argument types with similar types with a reduced width: <ul> <li><b>real(kind = 8)</b> &#8680; <b>real(kind = 4)</b></li> <li><b>integer(kind = 8)</b> &#8680; <b>integer(kind = 4)</b></li> </ul> </li> </ul> </div> '},11329:e=>{e.exports=' <h4>Enable non-temporal store</h4> <div class="text"> <p> Enable non-temporal store using <samp class="codeph">!DIR$ vector nontemporal</samp>. The nontemporal clause directs the compiler to use non-temporal (that is, streaming) stores, optionally takes a comma-separated list of variables. </p><p> Streaming stores may cause significant performance improvements over non-streaming stores for large numbers on certain processors. However, the misuse of streaming stores can significantly degrade performance. </p> <div class="promo"> <p class="expander">Example</p> <pre class="expansion"><code class="fortran">!DIR$ vector nontemporal\ndo i=1,N\n  arr1(i) = 0\nend do</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-967D7284-0E6D-4B02-B679-4DEE93D96E49.html">VECTOR and NOVECTOR</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},11397:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return t("layout-panel-card",{class:e.type,style:e.flex,attrs:{type:e.type,top:""}},[t("div",{staticClass:"top-metrics-data"},[t("div",{staticClass:"metrics"},e._l(e.row1,(function(e){return t("metric-item-box",{key:e.id,attrs:{metric:e,compact:""}})})),1),e._v(" "),t("div",{staticClass:"metrics"},e._l(e.row2,(function(e){return t("metric-item-box",{key:e.id,attrs:{compact:"",metric:e}})})),1)])])},n=[];o._withStripped=!0},11435:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"button"},[t("a",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.buttonTooltip,expression:"buttonTooltip"}],staticClass:"dot icon",class:[e.buttonIcon,{selected:e.isOpened},{available:e.buttonAvailable}],on:{click:function(t){return e.toggleFilter()}}})])};o._withStripped=!0;var n=i(75337);const s={mixins:[i(78281).A],props:{buttonAvailable:{type:Boolean,default:()=>!0}},data:()=>({isOpened:!1}),computed:{...(0,n.mapGetters)("header",["getButton"]),button(){return this.getButton("filter")}},methods:{toggleFilter(){this.isOpened=!this.isOpened,this.$store.direct.commit.updateFilterActivated(!this.$store.state.filterActivated)}}},r=(0,i(98822).A)(s,o,[],!1,null,"38fbc046",null).exports},11959:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>l});var o=function(){var e=this,t=e._self._c;return e.hasMessageCount?t("div",{staticClass:"button no_report"},[t("a",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.buttonTooltip,expression:"buttonTooltip"}],staticClass:"dot icon",class:[e.buttonIcon,{selected:e.isEventLogVisible},{available:e.buttonAvailable}],on:{click:function(t){return e.onClick()}}})]):e._e()};o._withStripped=!0;var n=i(75337),s=i(78281),r=i(51069);const a={mixins:[s.A,r.A],props:{buttonAvailable:{type:Boolean,default:()=>!0},eventName:{type:String,required:!0}},data:()=>({isOpened:!1}),computed:{...(0,n.mapGetters)("header",["getButton"]),...(0,n.mapGetters)("log",["isEventLogVisible"]),button(){return this.getButton("eventLog")},hasMessageCount(){return this.$store.direct.getters.log.hasMessageCount(this.eventName)}},methods:{onClick(){this.$store.direct.dispatch.log.toggleEventLogVisible()}}},l=(0,i(98822).A)(a,o,[],!1,null,"b023b498",null).exports},12100:function(e,t,i){"use strict";i(69212),i(45361);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(39959)),s={assignLayoutState(e,t){Object.keys(t).forEach((i=>n.default.set(e,i,t[i])))},setLayoutState(e,{view:t,...i}){n.default.set(e,t,i)},setSize(e,{element:t,size:i}){n.default.set(t,"size",i)},setAnimation(e,{element:t,animation:i}){n.default.set(t,"animation",i)},setCaption(e,{element:t,caption:i}){n.default.set(t,"caption",i)},setCapturedPanel(e,{panel:t,captureType:i}){n.default.set(t,"captureType",i)},addGuide(e,{view:t,index:i,guide:o}){e[t].guides.splice(i,0,o)},removeGuide(e,{view:t,index:i,guide:o}){if("number"==typeof i)e[t].guides.splice(i,1);else{const i=e[t].guides.findIndex((e=>e===o));i>=0&&e[t].guides.splice(i,1)}},addPanel(e,{guide:t,index:i,panel:o}){t.panels.splice(i,0,o)},removePanel(e,{guide:t,index:i,panel:o}){if("number"==typeof i)t.panels.splice(i,1);else{const e=t.panels.findIndex((e=>e===o));e>=0&&t.panels.splice(e,1)}},removePlaceholder(e,{view:t,guide:i,index:o}){t?e[t].guides.splice(o,1):i&&i.panels.splice(o,1)},addTab(e,{panel:t,index:i,tab:o}){var n;null===(n=t.tabs)||void 0===n||n.splice(i,0,o)},removeTab(e,{panel:t,index:i,tab:o}){if("number"==typeof i){var n;null===(n=t.tabs)||void 0===n||n.splice(i,1)}else{var s;const e=t.tabs.findIndex((e=>e===o));e>=0&&(null===(s=t.tabs)||void 0===s||s.splice(e,1))}},swapPanels(e,{guideFrom:t,guideTo:i,panelFrom:o,panelTo:s}){const r={...s,size:o.size},a={...o,size:s.size},l=t.panels.findIndex((e=>e===o)),c=i.panels.findIndex((e=>e===s));n.default.set(t.panels,l,r),n.default.set(i.panels,c,a)},setPanelState(e,{panel:t,panelState:i}){n.default.set(t,"panelState",i)},setTabState(e,{tab:t,tabState:i}){n.default.set(t,"tabState",i)},setTabCompact(e,{tab:t,compact:i}){n.default.set(t,"compact",i)}};t.default=s},12101:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("article",[t("div",[e._v("Unified Shared Memory (USM) provides capabilities for implicitly or\n    explicitly sharing data between a host platform and target devices:")]),e._v(" "),e._m(0),e._v(" "),t("code-snippet",{attrs:{source:e.example}}),e._v(" "),e._m(1)],1)};o._withStripped=!0;const n={computed:{example:()=>"\nint *a = sycl::malloc_shared<int>(size, q);\nint *b = sycl::malloc_shared<int>(size, q);\ninit(a, size); init(b, size); \nauto e = q.parallel_for(range<1>{size}, [=](item<1> i) {\n    b[i] = a[i];\n});\nsycl::free(a, q);\nsycl::free(b, q);\n".trim()}},s=(0,i(98822).A)(n,o,[function(){var e=this,t=e._self._c;return t("ul",[t("li",[e._v("For explicit sharing, use\n      "),t("code",[e._v("malloc_device")]),e._v(".\n    ")]),e._v(" "),t("li",[e._v("For implicit sharing, use\n      "),t("code",[e._v("malloc_shared")]),e._v(".\n    ")])])},function(){var e=this,t=e._self._c;return t("div",[e._v("\n    For details, see\n    "),e._v(" "),t("a",{attrs:{href:"https://www.intel.com/content/www/us/en/develop/documentation/oneapi-gpu-optimization-guide/top/memory/usm-buffer.html"}},[e._v("\n      oneAPI GPU Optimization Guide.\n    ")])])}],!1,null,"6bc08f08",null).exports},12168:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=i(18977);const n={created(){o.A.offload.onButtonClickReanalyze((e=>{const{value:t}=e,i=t;this.onButtonClick(i)}))}}},12186:e=>{e.exports=' <h4>Confirm inefficient memory access patterns</h4> <div class="text"> <div class="promo"> <span id="roofline_guidance"> Current traffic distribution between memory levels indicates possible inefficient memory access patterns present. Run a <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a> to confirm.<br/> </span> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> Data transferred between L1 and L2 cache levels (in cache lines) exceed CARM traffic between CPU registers and Memory subsystem (in bytes).<br/>This can be due to inefficient memory access pattern and cache line utilization. In this case, you only access a single element from a full cache line stored in L1.<br/> <img id="bad_traffic_img"/> </li> <li> <a href="docs:../help/index.htm#GUID-62A94516-242C-4B0C-9B4F-2ED08F61B146.html">Memory-Level Roofline</a> </li> </ul> </div>'},12291:e=>{e.exports=' <h4>Resolve dependency</h4> <div class="text"> <div class="promo"> The Dependencies analysis shows there is a real (proven) dependency in the loop. To fix: Do one of the following: <ul> <li> If there is an anti-dependency, enable vectorization using the <span data-glossary-id="directive">directive</span> <samp class="codeph">#pragma omp simd safelen(length)</samp> , where <samp class="codeph">length</samp> is smaller than the distance between dependent iterations in anti-dependency. <p class="expander">Example</p> <pre class="essential"><code class="cpp">#pragma omp simd safelen(4)\n...</code></pre> <pre class="expansion"><code class="cpp">#pragma omp simd safelen(4)\nfor (i = 0; i &lt; n - 4; i += 4)\n{\n    a[i + 4] = a[i] * c;\n}</code></pre> </li> <li> If there is a reduction pattern dependency in the loop, enable vectorization using the directive <samp class="codeph">#pragma omp simd reduction(operator:list)</samp>. <p class="expander">Example</p> <pre class="essential"><code class="cpp">#pragma omp simd reduction(+:sumx)\n...</code></pre> <pre class="expansion"><code class="cpp">#pragma omp simd reduction(+:sumx)\nfor (k = 0;k &lt; size2; k++)\n{\n    sumx += x[k]*b[k];\n}</code></pre> </li> <li> Rewrite the code to remove the dependency. Use programming techniques such as variable privatization. </li> </ul> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <i>omp simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html"> OpenMP* Pragmas Summary</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html"> Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},12652:e=>{e.exports=' <h4>Target the AVX2 ISA</h4> <div class="text"> <div class="promo"> Although static analysis presumes the loop may benefit from <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a> instructions available with the AVX2 or higher ISA, no FMA instructions executed for this loop. To fix: Use the following compiler options: <ul> <li> <samp class="codeph">xCORE-AVX2</samp> to compile for machines with and without AVX2 support </li> <li> <samp class="codeph">axCORE-AVX2</samp> to compile for machines with AVX2 support only </li> <li> <samp class="codeph">xCOMMON-AVX512</samp> to compile for machines with AVX-512 support only </li> <li> <samp class="codeph">axCOMMON-AVX512</samp> to compile for machines with and without AVX-512 support </li> </ul> Note: the compiler options may vary depending on the CPU microarchitecture. </div> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /QxCORE-AVX2 or /QaxCORE-AVX2 </td> <td> -xCORE-AVX2 or -axCORE-AVX2 </td> </tr> <tr> <td> /QxCOMMON-AVX512 or /QaxCOMMON-AVX512 </td> <td> -xCOMMON-AVX512 or -axCOMMON-AVX512 </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-2D881A91-C5D7-4DDD-84B1-FB9D0D597F4D.html">ax, Qax</a>; <a href="docs:Fortran/17/index.htm#GUID-09734487-1819-4C1E-B314-2497F2B64C45.html">x, Qx</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/overview.html">Intel&reg; Fortran Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/architecture-and-technology/avx-512-solution-brief.html">Compiling for the Intel&reg; Xeon Phi™ processor x200 and the Intel&reg; AVX-512 ISA</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},12715:(e,t,i)=>{"use strict";i.d(t,{A:()=>D}),i(36094),i(69212),i(45361),i(22783);var o=i(66275),n=i(61262),s=i(49463),r=i(23949),a={set:"set",add:"add",remove:"remove"};function l(e){return!!(e&&e.el&&e.el.el&&e.el.el.ownerSVGElement)}function c(e,t,i,o,n,s){var r=e.tr.L2P(t,i);this.el=this.init(e.getLoopsLayer(),r,o,n,s),this.x=t,this.y=i,this.el.el.roofLinePoint=this}function d(e,t,i,o,n,s){c.call(this,e,t,i,o,n,s)}function p(e,t,i,o,n,s){c.call(this,e,t,i,o,n,s)}function u(e){return Math.round(e*Math.sqrt(Math.PI)/2)}function h(e,t,i,o,n,s){c.call(this,e,t,i,o,n,s)}function m(e,t,i){function o(e,t,i,o,n,s){h.call(this,e,t,i,o,n,s)}return o.prototype=Object.create(h.prototype),o.fillPatternPostfixName=i,o.createFillPattern=function(e,t,i,n,s){h.createFillPattern.call(o,e,t,i,n,s)},o.prototype.getFillPatternPostfix=function(){return o.fillPattermPostfix?o.fillPattermPostfix:""},o.getPoints=t,o.prototype.getPoints=e,o}c.prototype.show=function(){return this.el.show(),this},c.prototype.hide=function(){return this.el.hide(),this},c.prototype.isHidden=function(){return this.el.isHidden()},c.prototype.front=function(){return this.el.front(),this},c.prototype.addClass=function(e){return this.el.addClass(e),this},c.prototype.remClass=function(e){return this.el.remClass(e),this},c.prototype.setFillColor=function(e){return e?this.el.setAttr("style","fill:"+e+" !important"):this.el.remAttr("style"),this},c.prototype.setStrokeColor=function(e){return e?this.el.setAttr("style","stroke:"+e+" !important"):this.el.remAttr("style"),this},c.prototype.setPatternId=function(e){return this.el.setStyle("stroke:darkgray; fill:"+this.el.localUrl(e+this.getFillPatternPostfix())),this},d.prototype=Object.create(c.prototype),d.createFillPattern=function(e,t,i,o,n){d.fillPattermPostfix||(d.fillPattermPostfix="-cl");var s=i/t/2;e.createPattern(n+d.fillPattermPostfix).useParentContentCoords().setWidth("100%").setHeight("100%").createCircle().setCX(".5").setCY(".5").setR(".5").setAttr("fill","white").getParent().createCircle().setCX(".5").setCY(".5").setR(s).setAttr("fill",o).setAttr("stroke","black").setAttr("stroke-width","0.05")},d.prototype.getFillPatternPostfix=function(){return d.fillPattermPostfix?d.fillPattermPostfix:""},d.prototype.init=function(e,t,i,o,n){return e.createCircle(n).setClass(o).activate().setCX(t.x).setCY(t.y).setR(i)},d.prototype.move=function(e,t){return this.el.setCX(e).setCY(t),this},d.prototype.setR=function(e){return this.el.setR(e),this},d.prototype.getR=function(){return parseFloat(this.el.getR())},d.prototype.getX=function(){return parseFloat(this.el.getCX())},d.prototype.getY=function(){return parseFloat(this.el.getCY())},d.prototype.calcLineEndPoint=function(e,t){var i=this.getX(),o=this.getY(),n=this.getR(),s=0,r=0,a=Math.sqrt(Math.pow(i-e,2)+Math.pow(o-t,2));return a>0&&(s=(t-o)/a,r=(e-i)/a),{x:i+n*r,y:o+n*s}},p.prototype=Object.create(c.prototype),p.createFillPattern=function(e,t,i,o,n){p.fillPattermPostfix||(p.fillPattermPostfix="-sr");var s=i/t,r=s/2;e.createPattern(n+p.fillPattermPostfix).useParentContentCoords().setWidth("100%").setHeight("100%").createRect().setX("0").setY("0").setWidth("1").setHeight("1").setAttr("fill","white").getParent().createRect().setX(.5-r).setY(.5-r).setWidth(s).setHeight(s).setAttr("fill",o).setAttr("stroke","black").setAttr("stroke-width","0.05")},p.prototype.getFillPatternPostfix=function(){return p.fillPattermPostfix?p.fillPattermPostfix:""},p.prototype.init=function(e,t,i,o,n){var s=u(i);return this.delta=s,this.r=i,e.createRect(n).setClass(o).activate().setX(t.x-s).setY(t.y-s).setWidth(2*s).setHeight(2*s)},p.prototype.move=function(e,t){return this.el.setX(e-this.delta).setY(t-this.delta),this},p.prototype.setR=function(e){var t=this.getX(),i=this.getY(),o=u(e);return this.delta=o,this.r=e,this.el.setX(t-o).setY(i-o).setWidth(2*o).setHeight(2*o),this},p.prototype.getR=function(){return this.r},p.prototype.getX=function(){return parseFloat(this.el.getX())+this.delta},p.prototype.getY=function(){return parseFloat(this.el.getY())+this.delta},p.prototype.calcLineEndPoint=function(e,t){var i=e,o=t,n=this.getX(),s=this.getY(),r=this.delta,a=0,l=n-e,c=s-t;return l&&(a=c/l),Math.abs(l)+Math.abs(c)>0&&(0===l||0===c||l===c?(o=s-Math.sign(c)*r,i=n-Math.sign(l)*r):a>1||a<-1?i=((o=s-Math.sign(c)*r)-t)/a+e:o=((i=n-Math.sign(l)*r)-e)*a+t),{x:i,y:o}},h.prototype=Object.create(c.prototype),h.createFillPattern=function(e,t,i,o,n){this.fillPattermPostfix||(this.fillPattermPostfix=this.fillPatternPostfixName);var s=this.getPoints(1),r=this.getPoints(i/t);e.createPattern(n+this.fillPattermPostfix).useParentContentCoords().setWidth("100%").setHeight("100%").createPolygon().setPoints(s).setAttr("fill","white").getParent().createPolygon().setPoints(r).setAttr("fill",o).setAttr("stroke","black").setAttr("stroke-width","0.05")},h.prototype.init=function(e,t,i,o,n){var s=this.getPoints(t.x,t.y,i);return this.r=i,this.xP=t.x,this.yP=t.y,e.createPolygon(n).setClass(o).activate().setPoints(s)},h.prototype.move=function(e,t){this.xP=e,this.yP=t;var i=this.getPoints(e,t,this.r);return this.el.setPoints(i),this},h.prototype.setR=function(e){var t=this.getX(),i=this.getY();this.r=e;var o=this.getPoints(t,i,e);return this.el.setPoints(o),this},h.prototype.getR=function(){return this.r},h.prototype.getX=function(){return this.xP},h.prototype.getY=function(){return this.yP},h.prototype.calcLineEndPoint=function(e,t){function i(e,t,i,o,n,s,r,a){function l(e,t,i){var o=1e-4;return e<Math.min(t,i)-o||e>Math.max(t,i)+o}var c,d,p,u,h,m,f;return e!==i&&(h=(o-t)/(i-e)),t!==o&&(u=(i-e)/(o-t)),n!==r&&(f=(a-s)/(r-n)),s!==a&&(m=(r-n)/(a-s)),e===i?(d=e,n!==r&&(p=f*d+a-f*r)):n===r&&(d=n,e!==i&&(p=h*d+o-h*i)),void 0===d&&void 0===p&&(t===o?(p=t,s!==a&&(d=m*p+r-m*a)):s===a&&(p=s,t!==o&&(d=u*p+i-u*o))),void 0===d&&void 0===p&&(d=(a-o+h*i-f*r)/(h-f),p=(r-i+u*o-m*a)/(u-m)),void 0!==d&&void 0!==p&&(l(d,e,i)||l(d,n,r)||l(p,t,o)||l(p,s,a))&&(d=p=void 0),void 0!==d&&void 0!==p&&(c={x:d,y:p}),c}var o;if(e===this.xP&&t===this.yP)o={x:e,y:t};else for(var n=this.el.getPoints(),s=0,r=n.length;s<r;s++){var a=s+1;a>=r&&(a=0);var l=n[s][0],c=n[s][1],d=n[a][0],p=n[a][1];if(o=i(e,t,this.xP,this.yP,l,c,d,p))break}return o||(o={x:this.xP,y:this.yP}),o};var f=m((function(e,t,i){var o=2*i*Math.sqrt(Math.PI)/Math.pow(3,1/4),n=o*Math.sqrt(3)/6;return[[e-o/2,t+n],[e,t-2*n],[e+o/2,t+n]]}),(function(e){var t=.667;return[[.5-e/2,t+e/3],[.5,t-2*e/3],[.5+e/2,t+e/3]]}),"-tr"),v=m((function(e,t,i){var o=1.618,n=i*Math.sqrt(Math.PI/o*2);return[[e-n/2,t],[e,t-o*n/2],[e+n/2,t],[e,t+o*n/2]]}),(function(e){var t=.5,i=.5;return[[t-(e/=2),i],[t,i-e],[t+e,i],[t,i+e]]}),"-dm");function g(e,t,i,o,n,s){d.call(this,e,t,i,o,n,s)}function _(e){return"dominant-baseline:"+(e<0?"text-before-edge;":"text-after-edge;")}function y(e){return e<0?"text-anchor: end; ":""}function b(e,t,i,o,n){var s=e.getRoofsTextLayer().createText(t).setClass("idvc2_chart_roofline_text").setX(0).setY(0).setStyle(y(i)+_(o)).deactivate();return n&&s.addSpan("?").addClass("idvc2_chart_roofline_explanation").setAttr("dy","-10").activate(),{svgText:s,alongOffset:i,acrossOffset:o}}function w(e,t,i){return!(!e||!e.svgText||e.alongOffset===t&&e.acrossOffset===i||(e.svgText.setStyle(y(t)+_(i)),e.alongOffset=t,e.acrossOffset=i,0))}function x(e,t){var i,o,n,s;return Array.isArray(e)?1===e.length?i=e[0]:2===e.length?(n=e[0],i=e[1]):3===e.length?(i=e[0],s=e[1],o=e[2]):e.length>=4&&(n=e[0],i=e[1],s=e[2],o=e[3]):i=e,void 0===o&&(o=i),void 0===s&&(s=t.getMaxIntens()),void 0===n&&(n=t.getMinIntens()),{startX:n,startY:i,endX:s,endY:o}}function C(e,t,i,o,n){var s,r,a,l;t=t||"idvc2_roofline_line";var c=x(e,o.tr);a=c.startX,s=c.startY,l=c.endX,r=c.endY;var d=P(n?o.getBackgroundLayer():o.getRoofsLayer(),o.tr,a,s,l,r,t,i);this.el=d,this.startX=a,this.startY=s,this.endX=l,this.endY=r,this.roofline=o,d.el.roof=this}g.prototype=Object.create(d.prototype),g.prototype.init=function(e,t,i,o,n){var s=d.prototype.init.call(this,e,t,i,o,n);s.addClass("total_point");const r=i+4;return this.halfMarkerSize=r,this.horzLine=e.addLine(t.x-r,t.y,t.x+r,t.y,M),this.vertLine=e.addLine(t.x,t.y-r,t.x,t.y+r,M),s},g.prototype.move=function(e,t){return d.prototype.move.call(this,e,t),this.horzLine.setX1(e-this.halfMarkerSize).setX2(e+this.halfMarkerSize).setY1(t).setY2(t),this.vertLine.setX1(e).setX2(e).setY1(t-this.halfMarkerSize).setY2(t+this.halfMarkerSize),this},g.prototype.front=function(){return d.prototype.front.call(this),this.horzLine.front(),this.vertLine.front(),this},C.prototype.setBeginText=function(e,t,i,o){return t=t||10,i=i||1,this.startText&&this.startText.svgText&&this.startText.svgText.remove(),this.startText=b(this.roofline,e,t,i,o),I(this.roofline,this.startText,this.startX,this.startY,this.endX,this.endY),this.startText.svgText.el.parentRoof=this.el,this},C.prototype.updateBeginOffsets=function(e,t){e=e||10,t=t||1,w(this.startText,e,t)&&I(this.roofline,this.startText,this.startX,this.startY,this.endX,this.endY)},C.prototype.setEndText=function(e,t,i,o){return t=t||-10,i=i||1,this.endText&&this.endText.svgText&&this.endText.svgText.remove(),this.endText=b(this.roofline,e,t,i,o),I(this.roofline,this.endText,this.startX,this.startY,this.endX,this.endY),this.endText.svgText.el.parentRoof=this.el,this},C.prototype.updateEndOffsets=function(e,t){e=e||-10,t=t||1,w(this.endText,e,t)&&I(this.roofline,this.endText,this.startX,this.startY,this.endX,this.endY)},C.prototype.show=function(){this.el.show(),this.startText&&this.startText.svgText.show(),this.endText&&this.endText.svgText.show()},C.prototype.hide=function(){this.el.hide(),this.startText&&this.startText.svgText.hide(),this.endText&&this.endText.svgText.hide()},C.prototype.isHidden=function(){return this.el.isHidden()},C.prototype.remove=function(){this.el.remove(),this.startText&&this.startText.svgText.remove(),this.endText&&this.endText.svgText.remove(),R.call(this.roofline,this)},C.prototype.change=function(e){var t,i,o,n,s=x(e,this.roofline.tr);return o=s.startX,t=s.startY,n=s.endX,i=s.endY,this.startX=o,this.startY=t,this.endX=n,this.endY=i,this.update(),this},C.prototype.update=function(){var e=this.roofline.tr.L2P(this.startX,this.startY),t=this.roofline.tr.L2P(this.endX,this.endY);this.el.setX1(e.x).setY1(e.y).setX2(t.x).setY2(t.y),I(this.roofline,this.startText,this.startX,this.startY,this.endX,this.endY),I(this.roofline,this.endText,this.startX,this.startY,this.endX,this.endY)};const A="idvc2_roofline_point_selected",S="idvc2_roofline_point_current";function T(e,t,i){this._parent=n.default.getDomElement(e),n.default.removeAllChildren(this._parent),this.onDblClick=o.A.create(),this.onContextMenu=o.A.create(),this.onSelectionChanged=o.A.create(),this.onCurrentPointChanged=o.A.create(),this.beforeResize=o.A.create(),this.onResize=o.A.create(),this.centralPart=s.A.createCentralPart(e,i),this.vertAxis=s.A.createVertAxis(e,i),this.horzAxis=s.A.createHorzAxis(e,i),this._centerMarkers=[],Object.defineProperty(this,"centerMarkers",{get:function(){return this._centerMarkers}}),this._selectedPoints=[],Object.defineProperty(this,"selectedPoint",{get:function(){return this._selectedPoints[0]},set:function(e){if(l(e)){var t=this._selectedPoints[0];t!==e||this._selectedPoints.length>1?(this._selectedPoints.forEach((function(e){e.el.el.classList.remove(A)})),this._selectedPoints.length=0,this._selectedPoints.push(e),(t=this._selectedPoints[0]).el.el.classList.add(A),this.setPointFront(t),this.onSelectionChanged.raise(t,a.set)):this.allowReselectCurrentPoint&&this.onSelectionChanged.raise(t,a.set)}}}),Object.defineProperty(this,"selectedPoints",{get:function(){return this._selectedPoints}}),this._currentPoint,Object.defineProperty(this,"currentPoint",{get:function(){return this._currentPoint},set:function(e){e&&!l(e)||this._currentPoint!==e&&(this._currentPoint&&this._currentPoint.el.el.classList.remove(S),this._currentPoint=e,this._currentPoint&&(this._currentPoint.el.el.classList.add(S),this.setPointFront(this._currentPoint)),this.onCurrentPointChanged.raise(this._currentPoint))}}),this.points=[],this.roofs=[],void 0!==t&&this._parent.setAttribute("tabindex",t),this.centralPart.body.refreshSize=function(e){return e&&e.movingZoomFrame||this.tr&&this.tr._clear(),this.beforeResize.raise(this.tr),this.points.forEach(function(e){var t=this.tr.L2P(e.x,e.y);e.move(t.x,t.y)}.bind(this)),this.roofs.forEach((function(e){e.update()})),this.gridLines&&this.addGridLines(),this._centerMarkers.forEach(function(e){e.move(this.tr)}.bind(this)),this.onResize.raise(this.tr),!0}.bind(this),this.centralPart.body.addEventListener("mousedown",function(e){0===(e=e||event).button&&e.target&&e.target.roofLinePoint&&(e.ctrlKey?this.addSelectedPoint(e.target.roofLinePoint):this.selectedPoint=e.target.roofLinePoint,this.currentPoint=e.target.roofLinePoint)}.bind(this),!1),this.centralPart.ondblclick=function(e,t){this.onDblClick.raise(e,t)}.bind(this),this.windowResizeListener=n.default.addWindowResizeListener(this._parent)}function I(e,t,i,o,n,s){if(t){var r=t.svgText.el,a=t.alongOffset,l=function(e){var t=e.ownerSVGElement,i=e.scaleIndependentXForm=t.createSVGTransform();return e.transform.baseVal.clear(),e.transform.baseVal.appendItem(i),i}(r),c=e.tr,d=c.L2P(i,o),p=c.L2P(n,s),u=p.x-d.x,h=d.y-p.y,m=Math.atan2(h,u),f=a>=0?d:p,v=function(t){return e._CTM||(e._CTM=t.getCTM()),e._CTM}(r);v&&l.setMatrix(v.inverse().translate(f.x+a*Math.cos(m)-t.acrossOffset*Math.sin(m),f.y-a*Math.sin(m)-t.acrossOffset*Math.cos(m)).rotate(-m/(2*Math.PI)*360))}}function P(e,t,i,o,n,s,r,a,l){var c=t.L2P(i,o),d=t.L2P(n,s);return e.createLine(a,l).setClass(r).setX1(c.x).setY1(c.y).setX2(d.x).setY2(d.y)}T.prototype.createDefaultLayers=function(){var e=this.centralPart.graphicsRoot;this.backgroundLayer=e.createG("BackgroundLayer"),this.loopsLayer=e.createG("LoopsLayer"),this.roofsLayer=e.createG("RoofsLayer"),this.roofsTextLayer=e.createG("RoofsTextLayer"),this.foregroundLayer=e.createG("ForegroundLayer")},T.prototype.getBackgroundLayer=function(){return this.backgroundLayer||this.createDefaultLayers(),this.backgroundLayer},T.prototype.getLoopsLayer=function(){return this.loopsLayer||this.createDefaultLayers(),this.loopsLayer},T.prototype.getRoofsLayer=function(){return this.roofsLayer||this.createDefaultLayers(),this.roofsLayer},T.prototype.getRoofsTextLayer=function(){return this.roofsTextLayer||this.createDefaultLayers(),this.roofsTextLayer},T.prototype.getForegroundLayer=function(){return this.foregroundLayer||this.createDefaultLayers(),this.foregroundLayer},T.prototype.destroy=function(){this.windowResizeListener.remove(),delete this.windowResizeListener},T.prototype.addSelectedPoint=function(e){if(l(e))if(e.el.el.classList.toggle(A),e.el.el.classList.contains(A))this._selectedPoints.push(e),this.onSelectionChanged.raise(e,a.add);else{var t=this._selectedPoints.indexOf(e);t>=0&&this._selectedPoints.splice(t,1),this.onSelectionChanged.raise(e,a.remove)}},T.prototype.selectPoints=function(e,t,i,o){this.clearSelectedPoints();var n=!0,s=!0;this.points.forEach(function(r){r.x>e&&r.x<i&&r.y>t&&r.y<o&&(this.addSelectedPoint(r),s=!1,r===this.currentPoint&&(n=!1))}.bind(this)),s&&this.onSelectionChanged.raise(void 0,a.remove),n&&(this.currentPoint=this._selectedPoints[0])},T.prototype.isPointSelected=function(e){return e&&e.el.el.classList.contains(A)},T.prototype.clearSelectedPoints=function(){this._selectedPoints.forEach((function(e){e.el.el.classList.remove(A)})),this._selectedPoints.length=0},T.prototype.clear=function(){this.points=[],this.roofs=[],this._selectedPoints=[],this._currentPoint=void 0,delete this.backgroundLayer,delete this.loopsLayer,delete this.roofsLayer,delete this.roofsTextLayer,delete this.foregroundLayer,delete this.gridLines,delete this.centerMarker,this.centralPart.clear(),this.horzAxis.clear(),this.vertAxis.clear(),this._centerMarkers=[]},T.prototype.clearRoofs=function(){this.roofs.forEach((function(e){e&&e.remove()})),this.roofs=[]},T.prototype.setViewbox=function(e,t,i,o,s,r){function a(e){return Math.round(e)}s=s||100,r=r||100;var l={};this.tr&&(l=this.tr._sizes),this.tr={_getClientWidth:function(){return Math.max(this._getBoundingWidth(),s)},_getClientHeight:function(){return Math.max(this._getBoundingHeight(),r)},canvas:this.centralPart.getCanvas(),body:this.centralPart.body,_sizes:{},getMinIntens:function(){return e},getMaxIntens:function(){return i},getMinPerf:function(){return t},getMaxPerf:function(){return o},getMinX:function(){return this.L2PX(e)},getMaxX:function(){return this.L2PX(i)},getMinY:function(){return this.L2PY(t)},getMaxY:function(){return this.L2PY(o)},getCanvas:function(){return this.canvas},getTop:function(){return 0},getHeight:function(){return this._getBoundingHeight()},getWidth:function(){return this._getBoundingWidth()},L2P:function(e,t){return{x:this.L2PX(e),y:this.L2PY(t)}},L2PX:function(t){return a((t-e)*this._getClientWidth()/(i-e))},L2PY:function(e){return a(this._getClientHeight()*(1-(e-t)/(o-t)))},P2L:function(e,t){return{x:this.P2LX(e),y:this.P2LY(t)}},P2LX:function(t){return e+t*(i-e)/this._getClientWidth()},P2LY:function(e){return t+(o-t)*(1-e/this._getClientHeight())},screenP2L:function(e,t){return{x:this.screenP2LX(e),y:this.screenP2LY(t)}},screenP2LX:function(e){return e-=n.default.getElementPos(this.body).x,this.P2LX(e)},screenP2LY:function(e){return e-=n.default.getElementPos(this.body).y,this.P2LY(e)},_clear:function(){this._sizes={}},_getBoundingWidth:function(){return this._sizes.width||(this._sizes.width=this.body.getBoundingClientRect().width),this._sizes.width},_getBoundingHeight:function(){return this._sizes.height||(this._sizes.height=this.body.getBoundingClientRect().height),this._sizes.height}},this.tr._sizes=l,this.vertAxis.setCentralPart(this.tr),this.horzAxis.setCentralPart(this.tr),this.centralPart.tr=this.tr},T.prototype.addPoint=function(e,t,i,o,n,s){var r=new(s=s||d)(this,e,t,i=i||8,o=o||"idvc2_roofline_point",n);return this.points.push(r),r},T.prototype.setPointFront=function(e){e&&e.front()};const M="idvc2_chart_roofline_center_marker",E="active";function L(e,t,i,o,n){this.x=e,this.y=t,this.pos=i,n=n||1;var s=Math.ceil(39*n/2);this.halfMarkerSize=s,this.horzLine=o.addLine(i.x-s,i.y,i.x+s,i.y,M),this.vertLine=o.addLine(i.x,i.y-s,i.x,i.y+s,M)}function R(e){var t=this.roofs.indexOf(e);t>=0&&this.roofs.splice(t,1)}L.prototype.move=function(e){var t;e?(t=e.L2P(this.x,this.y),this.pos=t):t=this.pos,this.horzLine.setX1(t.x-this.halfMarkerSize).setX2(t.x+this.halfMarkerSize).setY1(t.y).setY2(t.y),this.vertLine.setX1(t.x).setX2(t.x).setY1(t.y-this.halfMarkerSize).setY2(t.y+this.halfMarkerSize)},L.prototype.remove=function(){this.horzLine.remove(),this.vertLine.remove()},L.prototype.front=function(){this.horzLine.front(),this.vertLine.front()},L.prototype.activate=function(){function e(e){e.addClass(E)}var t=this.horzLine.getCanvas();if(t){var i=t.getBoundingRect();this.horzLine.setX1(0).setX2(i.width),this.vertLine.setY1(0).setY2(i.height),e(this.horzLine),e(this.vertLine)}},L.prototype.deactivate=function(){function e(e){e.remClass(E)}this.move(),e(this.horzLine),e(this.vertLine)},T.prototype.setCenterMarker=function(e,t,i,o){return this._removeCenterMarkers(),this.centerMarker=this.addCenterMarker(e,t,i,o),this.centerMarker},T.prototype.addCenterMarker=function(e,t,i,o){var n=this._createCenterMarker(e,t,i,o);return this._centerMarkers.push(n),n},T.prototype._createCenterMarker=function(e,t,i,o){i=i||1;var n=new(o=o||L)(e,t,this.tr.L2P(e,t),this.getForegroundLayer(),i);return n.front(),n},T.prototype._removeCenterMarkers=function(){this._centerMarkers.forEach((function(e){e.remove()})),this._centerMarkers=[]},T.prototype.addRoof=function(e,t,i,o){var n=new C(e,t,i,this,!!o);return this.roofs.push(n),n},T.prototype.addGridLines=function(e){function t(t){if(!t)return e;var i=t.representation;return i&&i.getGridLineClassName&&i.getGridLineClassName()||e}function i(e){return e&&e.representation&&!(e.representation.noGridLine&&e.representation.noGridLine())}e=e||"idvc2_roofline_grid_line";var o=function(e){if(i(e)){var o=e.value,n=o,s=this.tr.getMaxIntens(),r=this.tr.getMinIntens();this.gridLines.push(P(this.getBackgroundLayer(),this.tr,r,o,s,n,t(e),void 0,!0))}}.bind(this),n=function(e){if(i(e)){var o=e.value,n=o,s=this.tr.getMaxPerf(),r=this.tr.getMinPerf();this.gridLines.push(P(this.getBackgroundLayer(),this.tr,o,r,n,s,t(e),void 0,!0))}}.bind(this);this.gridLines&&this.gridLines.forEach((function(e){e.remove()})),this.gridLines=[],this.vertAxis.values.forEach(o),this.vertAxis.intermValues&&this.vertAxis.intermValues.values.forEach(o),this.horzAxis.values.forEach(n),this.horzAxis.intermValues&&this.horzAxis.intermValues.values.forEach(n)},T.prototype.getLastGridLine=function(){if(this.gridLines)return this.gridLines[0]},T.prototype.getElementById=function(e){return this._parent.querySelector(`#${e}`)},T.prototype.fitVertAxis=function(e){e=e||0;const t=this.vertAxis.getOptimalWidth(e)+"px";return this.centralPart.body.style.left=t,this.horzAxis.body.style.left=t,this.vertAxis.body.style.width=t,this.horzAxis.recreate(),this.vertAxis.recreate(),this.vertAxis.layoutValues(),this.horzAxis.layoutValues(),n.default.refreshSize(this._parent),t};const D={create:function(e,t,i){return new T(e,t,i)},SelectionOperations:a,BasePoint:c,CirclePoint:d,SquarePoint:p,TrianglePoint:f,DiamondPoint:v,TotalPoint:g,createPolygonPoint:m,getPointIcon:function(e,t){if(e){if(t=t||"Gainsboro",e.icon||(e.icon={}),!e.icon[t]){var i=r.A.create(void 0,!0).setViewSize(0,0,20,20);new e({tr:{L2P:function(e,t){return{x:e,y:t}}},getLoopsLayer:function(){return i}},10,11,7).remClass("idvc2_active"),e.icon[t]="url('data:image/svg+xml;base64,"+btoa('<svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 20 20" stroke="black" fill="'+t+'">'+i.el.innerHTML+"</svg>")+"')"}return e.icon[t]}},getPointConstructor:function(e){if(e)return this[e=(e=e.toLowerCase())[0].toUpperCase()+e.slice(1)+"Point"]}}},12880:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>o});const o="data:image/png;base64,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"},13390:e=>{e.exports=' <h4>Check memory access patterns for the outer loop</h4> <div class="text promo"> This loop has inefficient memory access patterns. <span id="actions" style="display:none"> To fix: Run a <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a> on the outer loop. </span> If the memory access patterns are more efficient for the outer loop, reorder the loops if possible. </div> '},13631:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(e,t){return t.props.disabled?e("div",{staticClass:"disabled-overlay"}):t._e()};o._withStripped=!0;const n={props:{disabled:{type:Boolean}}},s=(0,i(98822).A)(n,o,[],!0,null,"1494f581",null).exports},14224:(e,t)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const i={props:{data:Object},methods:{setAxisLabelWidth(e){this.$refs.axisLabel.style.left=e,this.$refs.axisLabel.style.width=`calc(100% - ${e})`}}};t.A=i},14400:(e,t,i)=>{"use strict";i.d(t,{_:()=>o});const o="custom"},14487:e=>{e.exports=' <h4>Add more parallel work</h4> <div class="text"> <div class="promo"> Add more parallel work to this region. For example, use a larger dataset. </div> </div> '},14624:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"layout-splitter",class:[e.direction,e.active,e.debug],on:{pointerdown:e.onPointerDown,pointermove:e.onPointerMove,pointerup:e.onPointerUp,lostpointercapture:e.onLostPointerCapture}})};o._withStripped=!0;var n=i(84547);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"bdb5410c",null).exports},14694:e=>{e.exports=' <h4>Compute SIMD lanes individually</h4> <div class="text"> <div class="promo"> The Dependencies analysis shows there is a reduction pattern dependency in the loop. Enable vectorization using the <span data-glossary-id="directive">directive</span> <samp class="codeph">!$OMP SIMD REDUCTION(operator:list)</samp>. <p class="expander">Example</p> <pre class="essential"><code class="fortran">!$OMP SIMD REDUCTION(+:SUMX)\n...</code></pre> <pre class="expansion"><code class="fortran">!$OMP SIMD REDUCTION(+:SUMX)\ndo k = 1, size2\n    sumx = sumx + x(k) * b(k)\nenddo</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},14926:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"buttons"},[t("div",{staticClass:"button"},[t("a",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("source-view-layout-top-down"),expression:"$t('source-view-layout-top-down')"}],staticClass:"icon dot layout-horizontal available",class:{selected:e.direction===e.DIRECTION_COLUMN},on:{click:function(t){return e.$emit("directionChanged",e.DIRECTION_COLUMN)}}})]),e._v(" "),t("div",{staticClass:"button"},[t("a",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("source-view-layout-left-right"),expression:"$t('source-view-layout-left-right')"}],staticClass:"icon dot layout-vertical available",class:{selected:e.direction===e.DIRECTION_ROW},on:{click:function(t){return e.$emit("directionChanged",e.DIRECTION_ROW)}}})])])};o._withStripped=!0;var n=i(60970);const s={props:{direction:{type:String,default:n.DIRECTION_ROW}},data:()=>({DIRECTION_ROW:n.DIRECTION_ROW,DIRECTION_COLUMN:n.DIRECTION_COLUMN})},r=(0,i(98822).A)(s,o,[],!1,null,"09b5c91a",null).exports},14963:e=>{e.exports=' <h4>Consider outer loop vectorization</h4> <div class="text"> <div class="promo"> The compiler did not vectorize the loop as the code exceeds the compilers complexity criteria. You might get higher performance if you enforce the loop vectorization. Use a <span data-glossary-id="directive">directive</span> right before your loop block in the source code. </div> <table> <tr> <th> <span data-glossary-id="ICL">ICL</span>/<span data-glossary-id="ICC">ICC</span>/<span data-glossary-id="ICPC">ICPC</span> Directive </th> </tr> <tr> <td> #pragma omp simd </td> </tr> </table> <p id="disclaimer"> Given issue is only about opportunity to vectorize outer loop, to prove profitability you need perform deeper dive analysis (MAP, Trip Counts, Dependencies) </p> <p class="expander">Read More</p> <ul class="expansion"> <li> <i>omp simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html">OpenMP* Pragmas Summary</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/outer-loop-vectorization.html">Outer Loop Vectorization</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},14977:e=>{e.exports=' <h4>Reorder loops</h4> <div class="text"> <div class="text promo"> This loop has less efficient memory access patterns than a nearby outer loop. To fix: Reorder the loops if possible. <p class="expander">Example (original code)</p> <pre class="essential"><code class="cpp">…\nfor (int j = 0; j &lt; N; j++)\n    for (int k = 0; k &lt; N; k++)\n        c[i][j] = c[i][j] + a[i][k] * b[k][j];\n…</code></pre> <pre class="expansion"><code class="cpp">\nvoid matmul(float *a[], float *b[], float *c[], int N) {\n    for (int i = 0; i &lt; N; i++)\n        for (int j = 0; j &lt; N; j++)\n            for (int k = 0; k &lt; N; k++)\n                c[i][j] = c[i][j] + a[i][k] * b[k][j];\n}\n    </code></pre> <p class="expander">Example (revised code)</p> <pre class="essential"><code class="cpp">…\nfor (int k = 0; k &lt; N; k++)\n    for (int j = 0; j &lt; N; j++)\n        c[i][j] = c[i][j] + a[i][k] * b[k][j];\n…</code></pre> <pre class="expansion"><code class="cpp">\nvoid matmul(float *a[], float *b[], float *c[], int N) {\n    for (int i = 0; i &lt; N; i++)\n        for (int k = 0; k &lt; N; k++)\n            for (int j = 0; j &lt; N; j++)\n                c[i][j] = c[i][j] + a[i][k] * b[k][j];\n}\n    </code></pre> </div> Interchanging is not always possible because of dependencies, which can lead to different results. </div> '},15430:e=>{e.exports=' <h4>Enforce the compiler to ignore assumed vector dependencies</h4> <div class="text"> <div class="promo"> No real dependencies were detected, so there is no need for conflict-detection instructions. To fix: Tell the compiler it is safe to vectorize using a <span data-glossary-id="directive">directive</span> <samp class="codeph">!DIR$ IVDEP</samp>. Note: This fix may be unsafe in other scenarios; use with care to avoid incorrect results. <p class="expander">Example</p> <pre class="expansion"><code class="fortran">!DIR$ IVDEP\ndo i = 1, N\n    a(index(i)) = b(i) * c\nenddo</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-7E982960-B603-4781-BEBC-E8EFA9208DB3.html">IVDEP</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},15885:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"buttons-control"},[t("div",{staticClass:"current"},[e._v("\n    "+e._s(e.currentProjectTitle)+"\n    "),e.isCurrentProject?t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.currentProject.path,expression:"currentProject.path"}],staticClass:"current-name"},[e._v("\n      "+e._s(e.currentProject.name)+"\n    ")]):e._e()]),e._v(" "),t("div",{staticClass:"action-section"},e._l(e.actionButtons,(function(i){return t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.getButtonTooltip(i),expression:"getButtonTooltip(button)"}],key:i.id,staticClass:"action",class:{hidden:!i.active},on:{click:function(t){return e.onButtonClick(i.id)}}},[t("i",{staticClass:"icon",class:i.icon}),e._v("\n      "+e._s(e.$t(i.title))+"\n    ")])})),0),e._v(" "),e.isMruProjects?t("div",{staticClass:"recent-section"},[t("div",{staticClass:"recent"},[e._v("\n      "+e._s(e.$t("resent_project_title"))+"\n    ")]),e._v(" "),t("div",{staticClass:"projects"},e._l(e.mruProjects,(function(i){return t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:i.path,expression:"proj.path"}],key:i.id,staticClass:"project",on:{click:function(t){return e.onProjectClick(i)}}},[t("i",{staticClass:"icon spinner-bg"}),e._v(" "),t("span",{staticClass:"project-name"},[e._v("\n          "+e._s(i.name)+"\n        ")])])})),0)]):e._e()])};o._withStripped=!0;const n={computed:{...(0,i(75337).mapGetters)("welcome",["actionButtons","mruProjects","isMruProjects","currentProject","isCurrentProject"]),currentProjectTitle(){const e=this.$t("current_project_title"),t=this.$t("project_title");return this.isCurrentProject?e:t}},methods:{onButtonClick(e){this.$store.direct.dispatch.welcome.setActionButtonId({id:e})},onProjectClick(e){this.$store.direct.dispatch.welcome.loadRecentProject({path:e.path})},getButtonTooltip(e){return e.hasOwnProperty("tooltip")&&""!==e.tooltip?this.$t(e.tooltip):""}}},s=(0,i(98822).A)(n,o,[],!1,null,"6c2a88ab",null).exports},15968:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"option-selector"},e._l(e.options,(function(i){return t("label",{key:i.id,class:{selected:i.id===e.current},on:{click:function(t){return e.processClick(i.id)}}},[e._v("\n    "+e._s(i.caption)+"\n  ")])})),0)};o._withStripped=!0,i(69212),i(60426);const n={data:()=>({current:""}),props:{options:{type:Array,required:!0}},methods:{processClick(e){this.current!==e&&(this.current=e,this.$emit("change",e))}},watch:{options(){this.current="",this.options.some((e=>!!e.value&&(this.current=e.id,!0)))}}},s=(0,i(98822).A)(n,o,[],!1,null,"23afa8fc",null).exports},16169:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>d});var o=function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"instr_mix"}},[t("div",{staticClass:"content"},[t("span",{attrs:{name:"title"}},[e._v(e._s(e.$t("instr-mix"))+"\n      "),t("i",{attrs:{"data-tooltip":"Instruction Mix data is based on static analysis\n      of your application's assembly code.<br/><br/>\n      To collect instruction mix data dynamically while the application executes,<br/>\n      enable the FLOPS analysis in Project Properties and run the Trip Counts analysis.<br/>\n      You will find the results in the Survey report."}})]),e._v(" "),t("div",{attrs:{id:"instr_mix_summary"}}),e._v(" "),t("div",{staticClass:"expander"}),e._v(" "),e._m(0)])])};o._withStripped=!0,i(36094),i(69212),i(45361);const n="idvc2_hierarchy_caption",s="idvc2_hierarchy_expanded",r={},a={staticInstructionMix:{summary:[{displayName:"Memory",value:30},{displayName:"Compute",value:5},{displayName:"Mixed <a>?</a>",description:"Compute With Memory Operands",value:6},{displayName:"Other",value:18},{displayName:"Used registers",value:16},{displayName:"Basic blocks",value:232}],details:[{displayName:"Memory",value:51,number:30,expanded:!1,children:[{displayName:"Vector",value:20,number:13,expanded:!1,children:[{displayName:"SSE",value:5,number:3},{displayName:"AVX",value:10,number:7},{displayName:"AVX2",value:5,number:3}]},{displayName:"Scalar",value:31,number:23,expanded:!1,children:[{displayName:"x86",value:6,number:8},{displayName:"x87",value:25,number:15}]}]},{displayName:"Compute",value:9,number:5,expanded:!1,children:[{displayName:"Vector",value:7,number:4},{displayName:"Scalar",value:2,number:1}]},{displayName:"Mixed <a>?</a>",description:"Compute With Memory Operands",value:9,number:6,expanded:!1},{displayName:"Other",value:31,number:18,expanded:!1}]},dynamicInstructionMix:{summary:[{displayName:"Memory",value:"119640000"},{displayName:"Compute",value:"24960000"},{displayName:"Mixed<a>?</a>",description:"Compute With Memory Operands",value:"1"},{displayName:"Other",value:"90000000"},{displayName:"Number of Vector Registers",value:"1; 5"}],details:[{displayName:"Memory",value:51,number:11964e4,numberPerIteration:23.6443,expanded:!1,children:[{displayName:"Vector",value:42,number:9958e4,numberPerIteration:19.6798,expanded:!1,children:[{displayName:"SSE",value:42,number:9958e4}]},{displayName:"Scalar",value:9,number:2006e4,numberPerIteration:3.96443,expanded:!1,children:[{displayName:"SSE",value:9,number:1992e4},{displayName:"x86",value:0,number:14e4}]}]},{displayName:"Compute",value:11,number:2496e4,numberPerIteration:4.93281,expanded:!1,children:[{displayName:"Vector",value:9,number:1992e4,numberPerIteration:3.93676,expanded:!1,children:[{displayName:"SSE",value:9,number:1992e4}]},{displayName:"Scalar",value:2,number:504e4,numberPerIteration:.996047,expanded:!1,children:[{displayName:"x86",value:2,number:504e4}]}]},{displayName:"Mixed<a>?</a>",description:"Compute With Memory Operands",value:1,number:1,numberPerIteration:.001,expanded:!1},{displayName:"Other",value:38,number:9e7,numberPerIteration:17.7866,expanded:!1}]}},l={props:{compact:Boolean},mounted(){const{renderDetails:e}=this;e(a)},methods:{renderDetails(e){const t="dynamicInstructionMix"in e,i=[];"staticInstructionMix"in e&&i.push({displayName:'<div class="instr_mix_header">Static Instruction Mix Summary<a>?</a></div>',description:"Instruction Mix data is based on static analysis of your application's assembly code.\n            <br/>\n            Consider using Static Instruction Mix for inner-most loops. For outer loops and complex loop-nests\n            use Dynamic Instruction Mix.\n            <br/><br/>\n            To collect Dynamic Instruction Mix data while the application executes,<br/>enable the FLOPS\n            analysis in Project Properties and run the Trip Counts analysis.",expanded:!t,children:e.staticInstructionMix.details}),t&&i.push({displayName:'<div class="instr_mix_header">Dynamic Instruction Mix Summary<a>?</a></div>',description:"Dynamic Instruction Mix data is based on dynamic analysis of your application's\n            assembly code.\n            This metric corresponds to inclusive total count of instructions.<br/>Metric format:\n            (XXXX – Total count of instructions, YYYY – average count of instructions per iteration).\n            <br/>\n            Warning: Currently Dynamic Instruction Mix doesn’t reflect instructions inside of non-inlined\n            function calls.",expanded:!0,children:e.dynamicInstructionMix.details}),this.renderTextHierarchy(i,"instr_mix_details_text",(function(e){return-1!=e.displayName.indexOf("<a>?</a>")?"<span>"+e.displayName.replace("<a>?</a>",'<i data-tooltip="'+e.description+'"></i></span>'):e.displayName}),(function(e){let t=e.value>=1?e.value:"< 1";const i=e.displayName.replace("<a>?</a>","");t='<span data-tooltip="Percentage of '+i+' Instructions">'+t+"</span>";const o='<span data-tooltip="Number of '+i+' Instructions">'+e.number+"</span>";let n=parseFloat(parseFloat(e.numberPerIteration).toFixed(2));return n=n>=.01?n:"< 0.01",t+"% ("+o+("numberPerIteration"in e?', <span data-tooltip="Number of '+i+' Instructions per Iteration">'+n+"</span>)":")")}),null,!1)},clearContent(e){for(;null!==e.firstChild;)e.removeChild(e.firstChild);this.removeHierarchyEventsProcessing(e);const t=document.getElementsByClassName("idvc2_popup");for(;t.length>0;)t[0].parentNode.removeChild(t[0])},renderTextHierarchy(e,t,i,o,n,r){const a=document.getElementById(t);null!==a&&(this.clearContent(a),i=i||function(e){return e.displayName},o=o||function(e){return parseFloat(e.value).toFixed(2)+"%"},n=n||function(e){return e.value+"%"},r=void 0===r||r,this.buildHierarchy(a,e,(function(e,t){if(!e||!e.expand||!t)return;const a=e.expand;!r&&t.expanded&&a.classList.add(s),t.className&&a.classList.add(t.className);const l=document.createElement("div");l.className="idvc2_hierarchy_item";const c=document.createElement("div");c.className="idvc2_hierarchy_title",c.innerHTML=i(t);const d="value"in t,p=document.createElement("div");if(d){p.className="idvc2_hierarchy_value";const e=document.createElement("div");e.className="idvc2_hierarchy_value_text",e.innerHTML=o(t);const i=document.createElement("div");i.className="idvc2_hierarchy_value_bar_container";const s=document.createElement("div");s.className="idvc2_hierarchy_value_bar",s.style.width=n(t),i.appendChild(s),p.appendChild(e),p.appendChild(i)}l.appendChild(c),d&&l.appendChild(p),a.appendChild(l)})),this.addHierarchyEventsProcessing(a))},removeHierarchyEventsProcessing(e){if(e in r){const t=r[e];for(let i=t.length;i--;){const o=t[i];e.removeEventListener("click",o,!1)}}},addHierarchyEventsProcessing(e,t,i){t=t||function(){return!1},i=i||function(){},(e=e||document)in r||(r[e]=[]);const o=function(e){let o=(e=e||window.event).target;for(;o&&o.classList&&!o.classList.contains(n);)o=o.parentNode;o&&o.classList&&o.classList.contains(n)&&!t(o,o.classList.contains(s))&&(o.classList.toggle(s),i(o),$invoke("sectionChanged"))};r[e].push(o),e.addEventListener("click",o,!1)},addHierarchyHTML(e,t){const i=document.createElement("div");let o,s,r;return t?(i.className=n,s=document.createElement("div"),s.className="idvc2_hierarchy_container",s.appendChild(i),o=document.createElement("div"),o.className="idvc2_hierarchy_body",s.appendChild(o),r=s):(i.className="idvc2_hierarchy_leaf",r=i),e.appendChild(r),{expand:i,body:o,container:s}},buildHierarchyLevel(e,t,i){if(!e||!t)return;const o=t.children;Array.isArray(o)&&o.forEach((function(o){const n=this.addHierarchyHTML(e,o.children&&o.children.length);i(n,o,t),this.buildHierarchyLevel(n.body,o,i)}),this)},buildHierarchy(e,t,i){i=i||function(e,t){if(!e||!e.expand||!t)return;const i=e.expand;t.displayName&&(i.innerHTML=t.displayName),t.expanded&&i.classList.add(s),t.className&&i.classList.add(t.className)},Array.isArray(t)&&(t={children:t,value:100}),this.buildHierarchyLevel(e,t,i)},getElementPos(e){const t=e.getBoundingClientRect(),i=document.documentElement,o=window.pageYOffset||i.scrollTop,n=window.pageXOffset||i.scrollLeft,s=t.top+o-i.clientTop;return{x:t.left+n-i.clientLeft,y:s}},setFont(e,t){e&&t&&(e.style.fontFamily=t.fontFamily,e.style.fontSize=t.fontSize,e.style.fontStyle=t.fontStyle,e.style.fontWeight=t.fontWeight,e.style.fontVariant=t.fontVariant)},setBorser(e,t){if(e&&t){const i=["Width","Color","Style"];["Left","Top","Right","Bottom"].forEach((function(o){i.forEach((function(i){const n="border"+o+i;e.style[n]=t[n]}))}))}}}},c=l,d=(0,i(98822).A)(c,o,[function(){var e=this._self._c;return e("div",{staticClass:"expansion"},[e("div",{staticClass:"idvc2_area_hierarchy",attrs:{id:"instr_mix_details_area"}})])}],!1,null,null,null).exports},16257:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"dropdown"},[t("div",{staticClass:"value",class:e.valueClass},[t("router-link",{attrs:{to:{name:e.value}}},[e._v("\n      "+e._s(e.$t(e.value))+"\n    ")]),e._v(" "),t("span",{staticClass:"expander",on:{click:function(t){e.isExpanded=!e.isExpanded}}},[t("i",{class:e.isExpanded?"icon caret-up":"icon caret-down"})])],1),e._v(" "),e.isExpanded?t("div",{staticClass:"list"},e._l(e.list,(function(i){return t("div",{key:i,staticClass:"list-item",on:{click:function(t){e.isExpanded=!1}}},[t("router-link",{attrs:{to:{name:i}}},[e._v("\n        "+e._s(e.$t(i))+"\n      ")])],1)})),0):e._e(),e._v(" "),e.isExpanded?t("div",{staticClass:"outside",on:{click:function(t){e.isExpanded=!1}}}):e._e()])};o._withStripped=!0;const n={props:{value:String,list:Array},data:()=>({isExpanded:!1}),computed:{valueClass(){return this.$route.name===this.value?"active":void 0}}},s=(0,i(98822).A)(n,o,[],!1,null,"1a6738aa",null).exports},17036:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",e._l(e.data,(function(i,o){return t("div",{key:o},[e._v("\n    "+e._s(i)+"\n  ")])})),0)};o._withStripped=!0;var n=i(71388);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,null,null).exports},17143:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(44372),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},17653:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"trip_count_summary"}},[t("div",{staticClass:"content"},[t("div",{directives:[{name:"show",rawName:"v-show",value:e.compact,expression:"compact"}],staticClass:"essential"},[e._m(0),e._v(" "),e._m(1),e._v(" "),t("span",{attrs:{name:"title"}})]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.compact,expression:"!compact"}],staticClass:"expansion"},[t("div",{attrs:{name:"title"}},[e._v("Trip Counts")]),e._v(" "),t("span",{staticClass:"formula"},[e._v("Intel® Advisor calculates approximate value of the source (scalar)\n        loop trip counts according to the following formula:")]),e._v(" "),t("table",{staticClass:"formula"},[t("tr",{attrs:{valign:"top"}},[e._m(2),e._v(" "),t("td",{attrs:{align:"left"}},[t("sector",{attrs:{sign:"parenthesis"}},[t("sector",{attrs:{factor:"uf"}},[e._v("UF * ")]),e._v("(\n            ")],1),e._v(" "),t("span",{attrs:{summand:"peel"}},[t("sector",{attrs:{factor:"uf_peel"}},[e._v("UF"),t("sub",[e._v("peel")]),e._v(" * ")]),e._v("TC"),t("sub",[e._v("peel")])],1),e._v(" "),t("span",{attrs:{summand:"body"}},[t("sector",{attrs:{factor:"uf_body"}},[e._v("UF"),t("sub",[e._v("body")]),e._v(" * ")]),e._v("VL"),t("sub",[e._v("body")]),e._v(" * TC"),t("sub",[e._v("body")])],1),e._v(" "),t("span",{attrs:{summand:"scalar_remainder"}},[t("sector",{attrs:{factor:"uf_scalar_remainder"}},[e._v("UF"),t("sub",[e._v("scalar remainder")]),e._v(" * ")]),e._v("\n              TC"),t("sub",[e._v("scalar remainder")])],1),e._v(" "),t("span",{attrs:{summand:"vector_remainder"}},[t("sector",{attrs:{factor:"uf_vector_remainder"}},[e._v("UF"),t("sub",[e._v("vector remainder")]),e._v(" * ")]),e._v("\n              VL"),t("sub",[e._v("vector remainder")]),e._v(" * TC"),t("sub",[e._v("vector remainder")])],1),e._v(" "),t("sector",{attrs:{sign:"parenthesis"}},[e._v(")")])],1)]),e._v(" "),t("tr",{attrs:{valign:"top"}},[e._m(3),e._v(" "),t("td",{attrs:{align:"left"}},[t("sector",{attrs:{sign:"parenthesis"}},[t("sector",{attrs:{factor:"uf"}},[t("i",{attrs:{data:"trip_count_unroll_factor"}}),e._v(" * ")]),e._v("(\n            ")],1),e._v(" "),t("span",{attrs:{summand:"peel"}},[t("sector",{attrs:{factor:"uf_peel"}},[t("i",{attrs:{data:"trip_count_peel_unroll_factor"}}),e._v(" *\n              ")]),e._v(" "),t("i",{attrs:{data:"trip_count_peel_avg"}})],1),e._v(" "),t("span",{attrs:{summand:"body"}},[t("sector",{attrs:{factor:"uf_body"}},[t("i",{attrs:{data:"trip_count_body_unroll_factor"}}),e._v(" *\n              ")]),e._v(" "),t("i",{attrs:{data:"trip_count_body_vector_length"}}),e._v(" *\n              "),t("i",{attrs:{data:"trip_count_body_avg"}})],1),e._v(" "),t("span",{attrs:{summand:"scalar_remainder"}},[t("sector",{attrs:{factor:"uf_scalar_remainder"}},[t("i",{attrs:{data:"trip_count_scalar_remainder_unroll_factor"}}),e._v(" *\n              ")]),e._v(" "),t("i",{attrs:{data:"trip_count_scalar_remainder_avg"}})],1),e._v(" "),t("span",{attrs:{summand:"vector_remainder"}},[t("sector",{attrs:{factor:"uf_vector_remainder"}},[t("i",{attrs:{data:"trip_count_vector_remainder_unroll_factor"}}),e._v(" *\n              ")]),e._v(" "),t("i",{attrs:{data:"trip_count_vector_remainder_vector_length"}}),e._v(" *\n              "),t("i",{attrs:{data:"trip_count_vector_remainder_avg"}})],1),e._v(" "),t("sector",{attrs:{sign:"parenthesis"}},[e._v(")")])],1)])]),e._v(" "),e._m(4),e._v(" "),t("span",{staticClass:"where"},[e._v("Where:")]),e._v(" "),t("table",{staticClass:"where"},[t("tr",{attrs:{summand:"peel"}},[t("td",[t("sector",{attrs:{factor:"uf_peel"}},[e._v("UF"),t("sub",[e._v("peel")])])],1),e._v(" "),t("td",[t("sector",{attrs:{factor:"uf_peel"}},[e._v("\n              Unroll factor of scalar peel of loop, equals to\n              "),t("b",{attrs:{data:"trip_count_peel_unroll_factor"}}),e._v(".\n            ")])],1)]),e._v(" "),t("tr",{attrs:{summand:"body"}},[t("td",[t("sector",{attrs:{factor:"uf_body"}},[e._v("UF"),t("sub",[e._v("body")])])],1),e._v(" "),t("td",[t("sector",{attrs:{factor:"uf_body"}},[e._v("\n              Unroll factor of vectorized loop body, equals to\n              "),t("b",{attrs:{data:"trip_count_body_unroll_factor"}}),e._v(".\n            ")])],1)]),e._v(" "),t("tr",{attrs:{summand:"scalar_remainder"}},[t("td",[t("sector",{attrs:{factor:"uf_scalar_remainder"}},[e._v("UF"),t("sub",[e._v("scalar remainder")])])],1),e._v(" "),t("td",[t("sector",{attrs:{factor:"uf_scalar_remainder"}},[e._v("\n              Unroll factor of scalar remainder, equals to\n              "),t("b",{attrs:{data:"trip_count_scalar_remainder_unroll_factor"}}),e._v(".\n            ")])],1)]),e._v(" "),t("tr",{attrs:{summand:"vector_remainder"}},[t("td",[t("sector",{attrs:{factor:"uf_vector_remainder"}},[e._v("UF"),t("sub",[e._v("vector remainder")])])],1),e._v(" "),t("td",[t("sector",{attrs:{factor:"uf_vector_remainder"}},[e._v("\n              Unroll factor of vector remainder, equals to\n              "),t("b",{attrs:{data:"trip_count_vector_remainder_unroll_factor"}}),e._v(".\n            ")])],1)]),e._v(" "),e._m(5),e._v(" "),e._m(6),e._v(" "),e._m(7),e._v(" "),e._m(8),e._v(" "),e._m(9),e._v(" "),e._m(10)]),e._v(" "),e._m(11)])])])};o._withStripped=!0,i(69212),i(45361);const n={tripCountPeel:{unrollFactor:1,tripCountMinimum:1,tripCountAverage:1,tripCountMaximum:1},tripCountBody:{unrollFactor:2,tripCountMinimum:5,tripCountAverage:5,tripCountMaximum:61,vectorLength:8},tripCountScalarRemainder:{unrollFactor:1,tripCountMinimum:3,tripCountAverage:3,tripCountMaximum:3},tripCountVectorRemainder:{unrollFactor:1,tripCountMinimum:1,tripCountAverage:1,tripCountMaximum:1,vectorLength:8},avg:"5; 7",min:"5; 7",max:"61; 7",callCount:"1100000; 1100000",iterationDuration:"<0.0001s",formula:!0},s={props:{compact:Boolean},mounted(){const{$el:e,setup:t,setupEx:i,fillSummand:o,calculateSourceTripCounts:s}=this;t("*[data=trip_count_calls]",n.callCount),t("*[data=trip_count_dur]",n.iterationDuration,!0);let r=0;if(n.formula){qs("#value_plain_list").classList.remove("noformula");let t="",a=!1;const l={tripCountPeel:"peel",tripCountBody:"body",tripCountScalarRemainder:"scalar_remainder",tripCountVectorRemainder:"vector_remainder"};for(const i in l){const c=n[i];o(e,l[i],c),void 0!==c&&(r+=s(c),0==t.length?t=c.unrollFactor:a=t===c.unrollFactor)}if(a&&"1"!=t)for(const t in l)void 0!==n[t]&&qsa("*[factor=uf_"+l[t]+"]",qs("table.formula",e)).forEach((e=>e&&e.Visible(!1)));qsa("*[sign=parenthesis]",e).forEach((e=>e&&e.Visible(a&&"1"!=t))),i("*[data=trip_count_unroll_factor]",t,a&&"1"!=t)}else qs("#value_plain_list").classList.add("noformula"),t("*[data=trip_count_max]",n.max),t("*[data=trip_count_avg]",n.avg),t("*[data=trip_count_min]",n.min);qsa(".formula").forEach((e=>e&&e.Visible(n.formula))),qsa(".where").forEach((e=>e&&e.Visible(n.formula))),qsa(".noformula").forEach((e=>e&&e.Visible(!n.formula))),i("*[data=trip_count]",n.avg,!n.formula),i("*[data=trip_count_source]",r.toString(),n.formula)},methods:{setup(e,t,i){qsa(e).forEach((e=>{e.innerHTML=t,i&&e.parentElement.Visible(t)}))},setupEx(e,t,i){this.setup(e,i?t:"",!0)},fillSummand(e,t,i){const{setup:o,setupEx:n}=this,s="*[summand="+t+"]",r="*[data=trip_count_"+t+"_unroll_factor]",a="*[data=trip_count_"+t+"_min]",l="*[data=trip_count_"+t+"_avg]",c="*[data=trip_count_"+t+"_max]",d="*[data=trip_count_"+t+"_vector_length]",p="#trip_count_"+t+"_min_to_max",u="*[factor=uf_"+t+"]",h=void 0===i;if(qsa(s,qs("table.formula",e)).forEach((e=>function(e,t){if(e&&("none"===e.style.display&&t||"none"!==e.style.display&&!t)){const i=document.createElement(t?"span":"hiddenspan");i.innerHTML=e.innerHTML,i.setAttribute("summand",e.getAttribute("summand")),e.parentNode.replaceChild(i,e),i.Visible(t)}}(e,!h))),qsa(s,qs("table.where",e)).forEach((e=>e&&e.Visible(!h))),!h){const t=void 0!==i.tripCountAverage,s=void 0!==i.tripCountMinimum,h=void 0!==i.tripCountMaximum,m=void 0!==i.vectorLength,f=void 0!==i.unrollFactor,v=i.tripCountMinimum===i.tripCountMaximum;t&&o(l,i.tripCountAverage),s&&n(a,i.tripCountMinimum,!v),h&&n(c,i.tripCountMaximum,!v),s&&h&&qs(p).Visible(!v),m&&o(d,i.vectorLength),f&&(n(r,i.unrollFactor,"1"!=i.unrollFactor),qsa(u,qs("table.formula",e)).forEach((e=>e.Visible("1"!=i.unrollFactor))),qsa(u,qs("table.where",e)).forEach((e=>e.Visible("1"!=i.unrollFactor))))}},calculateSourceTripCounts(e){if(void 0===e)return 0;const t=void 0!==e.vectorLength;return Number(e.unrollFactor)*(t?Number(e.vectorLength):1)*Number(e.tripCountAverage)}}},r=s,a=(0,i(98822).A)(r,o,[function(){var e=this._self._c;return e("div",{attrs:{name:"title"}},[this._v("\n        Source Trip Counts:\n        "),e("span",{attrs:{data:"trip_count_source"}})])},function(){var e=this,t=e._self._c;return t("div",{attrs:{name:"title"}},[e._v("\n        Average Trip Counts: "),t("i",{attrs:{"data-tooltip":"Number of Times Loop Body Executes"}}),e._v(" "),t("span",{attrs:{data:"trip_count"}})])},function(){var e=this,t=e._self._c;return t("td",{attrs:{align:"right"}},[t("span",[e._v("TC"),t("sub",[e._v("source")]),e._v(" "),t("b",[e._v("=")])])])},function(){var e=this._self._c;return e("td",{attrs:{align:"right"}},[e("span",[e("i",{attrs:{data:"trip_count_source"}}),this._v(" = ")])])},function(){var e=this,t=e._self._c;return t("span",{staticClass:"formula"},[t("div",{staticClass:"note"},[t("span",{staticClass:"caption"},[e._v("NOTE:")]),e._v("\n          TC"),t("sub",[e._v("source")]),e._v(" value might be imprecise as its measurement is based on\n          average trip counts value.\n        ")])])},function(){var e=this,t=e._self._c;return t("tr",{attrs:{summand:"body"}},[t("td",[e._v("VL"),t("sub",[e._v("body")])]),e._v(" "),t("td",[e._v("\n            Vector length of loop body, equals to\n            "),t("b",{attrs:{data:"trip_count_body_vector_length"}}),e._v(".\n          ")])])},function(){var e=this,t=e._self._c;return t("tr",{attrs:{summand:"vector_remainder"}},[t("td",[e._v("VL"),t("sub",[e._v("vector remainder")])]),e._v(" "),t("td",[e._v("\n            Vector length of vector remainder, equals to\n            "),t("b",{attrs:{data:"trip_count_vector_remainder_vector_length"}}),e._v(".\n          ")])])},function(){var e=this,t=e._self._c;return t("tr",{attrs:{summand:"peel"}},[t("td",[e._v("TC"),t("sub",[e._v("peel")])]),e._v(" "),t("td",[e._v("\n            Trip count of scalar peel of loop, equals to "),t("b",{attrs:{data:"trip_count_peel_avg"}}),e._v(".\n            "),t("span",{attrs:{id:"trip_count_peel_min_to_max"}},[e._v("\n              This is average value with measured range of values from minimal\n              ("),t("b",{attrs:{data:"trip_count_peel_min"}}),e._v(") to maximum\n              ("),t("b",{attrs:{data:"trip_count_peel_max"}}),e._v(").\n            ")])])])},function(){var e=this,t=e._self._c;return t("tr",{attrs:{summand:"body"}},[t("td",[e._v("TC"),t("sub",[e._v("body")])]),e._v(" "),t("td",[e._v("\n            Trip count of vectorized body part, equals to "),t("b",{attrs:{data:"trip_count_body_avg"}}),e._v(".\n            "),t("span",{attrs:{id:"trip_count_body_min_to_max"}},[e._v("\n              This is average value with measured range of values from minimal\n              ("),t("b",{attrs:{data:"trip_count_body_min"}}),e._v(") to maximum\n              ("),t("b",{attrs:{data:"trip_count_body_max"}}),e._v(").\n            ")])])])},function(){var e=this,t=e._self._c;return t("tr",{attrs:{summand:"scalar_remainder"}},[t("td",[e._v("TC"),t("sub",[e._v("scalar remainder")])]),e._v(" "),t("td",[e._v("\n            Trip count of remainder of the loop, scalar part, equals to\n            "),t("b",{attrs:{data:"trip_count_scalar_remainder_avg"}}),e._v(".\n            "),t("span",{attrs:{id:"trip_count_scalar_remainder_min_to_max"}},[e._v("\n              This is average value with measured range of values from minimal\n              ("),t("b",{attrs:{data:"trip_count_scalar_remainder_min"}}),e._v(") to maximum\n              ("),t("b",{attrs:{data:"trip_count_scalar_remainder_max"}}),e._v(").\n            ")])])])},function(){var e=this,t=e._self._c;return t("tr",{attrs:{summand:"vector_remainder"}},[t("td",[e._v("TC"),t("sub",[e._v("vector remainder")])]),e._v(" "),t("td",[e._v("\n            Trip count of remainder of the loop, vector part, equlas to\n            "),t("b",{attrs:{data:"trip_count_vector_remainder_avg"}}),e._v(".\n            "),t("span",{attrs:{id:"trip_count_vector_remainder_min_to_max"}},[e._v("\n              This is average value with measured range of values from minimal\n              ("),t("b",{attrs:{data:"trip_count_vector_remainder_min"}}),e._v(") to maximum\n              ("),t("b",{attrs:{data:"trip_count_vector_remainder_max"}}),e._v(").\n            ")])])])},function(){var e=this,t=e._self._c;return t("table",{attrs:{id:"value_plain_list"}},[t("tr",{staticClass:"noformula"},[t("td",[e._v("Maximum: "),t("i",{attrs:{"data-tooltip":"Loop Trip Count Maximum"}})]),e._v(" "),t("td",{attrs:{data:"trip_count_max"}})]),e._v(" "),t("tr",{staticClass:"noformula"},[t("td",[e._v("Average: "),t("i",{attrs:{"data-tooltip":"Loop Trip Count Average"}})]),e._v(" "),t("td",{attrs:{data:"trip_count_avg"}})]),e._v(" "),t("tr",{staticClass:"noformula"},[t("td",[e._v("Minimum: "),t("i",{attrs:{"data-tooltip":"Loop Trip Count Minimum"}})]),e._v(" "),t("td",{attrs:{data:"trip_count_min"}})]),e._v(" "),t("tr",[t("td",[e._v("Call Count: "),t("i",{attrs:{"data-tooltip":"Number of Times Loop Is Invoked"}})]),e._v(" "),t("td",{attrs:{data:"trip_count_calls"}})]),e._v(" "),t("tr",[t("td",[e._v("Iteration Duration: "),t("i",{attrs:{"data-tooltip":"Average Loop Iteration Time"}})]),e._v(" "),t("td",{attrs:{data:"trip_count_dur"}})])])}],!1,null,null,null).exports},17727:e=>{e.exports=' <h4>Force vectorization if possible</h4> <div class="text"> <div class="promo"> <div id="no_dependency_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a> to identify real data dependencies. </div> The loop contains SQRT/DIV instructions (so vectorization could be beneficial), but is not vectorized. To fix, review: <ul> <li>Corresponding compiler diagnostic to check if vectorization enforcement is possible and profitable</li> <li>The Dependencies analysis to distinguish between compiler-assumed dependencies and real dependencies</li> </ul> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> '},18268:e=>{e.exports=' <h4>Change the chunk size</h4> <div class="text"> <div class="promo"> The loop is threaded and vectorized using the <samp class="codeph">#pragma omp parallel for simd</samp> directive, which parallelizes the loop with both threads and SIMD instructions. Specifically, the directive divides loop iterations into chunks (subsets) and distributes the chunks among threads, then chunk iterations execute concurrently using SIMD instructions. In this case, the chunk size (number of iterations per chunk) is not a multiple of <span data-glossary-id="vector_length">vector length</span>. To fix: Add a <samp class="codeph">schedule (simd: [kind])</samp> modifier to the <samp class="codeph">#pragma omp parallel for simd</samp> directive. <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n// Guarantee a multiple of <span data-glossary-id="vector_length">vector length</span>.\n#pragma omp parallel for simd schedule(simd: static)\nfor (int i = 0; i &lt; n; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void f(int a[], int b[], int[c])\n{\n    // Guarantee a multiple of <span data-glossary-id="vector_length">vector length</span>.\n    #pragma omp parallel for simd schedule(simd: static)\n    for (int i = 0; i &lt; n; i++)\n    {\n        a[i] = b[i] + c[i];\n    }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="http://www.openmp.org/mp-documents/openmp-4.5.pdf">OpenMP Application Programming Interface</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},18323:(e,t,i)=>{"use strict";i.d(t,{A:()=>C}),i(36094),i(69212),i(45361);var o=i(61262),n=i(33202);const s="i18n",r=s+":";var a=new Map,l=new Map,c=new Map;function d(e,t){u(l,e,t)}function p(e,t){u(c,e,t)}function u(e,t,i){var o=e.get(t);o?o.push(i):(o=[i],e.set(t,o))}function h(e,t,i,o){e=e||[],o=o||document.body,t=t||function(){},i=i||function(){};var n=o.childNodes;n&&[].forEach.call(n,(function(o){if("svg"!==o.nodeName)switch(o.nodeType){case 1:e.forEach((function(e){t(o,e)})),h(e,t,i,o);break;case 3:i(o)}}))}var m=/%(\w+)%/;function f(e){var t=m.exec(e);if(t&&t.length>1)return t[1]}function v(e,t){var i=f(e.getAttribute(t));if(i){var o=a.get(i);o?y(e,t,o):d(i,y.bind(window,e,t))}}function g(e){var t=f(e.nodeValue);if(t){var i=a.get(t);i?b(e,i):d(t,b.bind(window,e))}}function _(){}function y(e,t,i){e.setAttribute(t,i)}function b(e,t){e.nodeValue=t}function w(){var e=r;l.forEach((function(t,i){e+=i+",",t.forEach((e=>p(i,e)))})),l.clear(),n.Ay.sendNotification(e)}function x(e){return a.get(e)||""}n.Ay.addConsumer(s,{process:function(e){e&&(Array.isArray(e)||(e=[e]),e.forEach((function(e){if(e&&e.id){var t=c.get(e.id);t&&(t.forEach((t=>t(e.message))),c.delete(e.id)),a.set(e.id,e.message)}})))}});const C={processElement:function(e,t){h(e,v,g,t=o.default.getDomElement(t)||document.body),w()},processIds:function(e){Array.isArray(e)&&(e.forEach((function(e){a.get(e)||d(e,_)})),w())},processId:function(e,t){var i=a.get(e);i?t(i):(p(e,t),n.Ay.sendNotification(r+e))},addMessage:function(e,t){a.set(e,t)},getMessage:x,hasMessage:e=>a.has(e),getMessagEx:async function(e){var t=x(e);if(!t){const i=await n.Ay.getResponse(r+e);Array.isArray(i)?i.length&&(t=i[0].message):t=i.message,t&&a.set(e,t)}return t}}},18367:e=>{e.exports=' <h4>Use SoA instead of AoS</h4> <div class="text"> <p class="promo"> An array is the most common type of data structure containing a contiguous collection of data items that can be accessed by an ordinal index. You can organize this data as an array of structures (AoS) or as a structure of arrays (SoA). While AoS organization is excellent for encapsulation, it can hinder effective vector processing. To fix: Rewrite code to organize data using SoA instead of AoS. </p> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-D284C1EE-BFA4-4EA3-BB67-4A3E5D50199F.html">Programming Guidelines for Vectorization</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/memory-layout-transformations.html">Case study: Comparing Arrays of Structures and Structures of Arrays Data Layouts for a Compute-Intensive Loop</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},18863:e=>{e.exports=' <h4>Move OpenMP call(s) outside the loop body</h4> <div class="text"> <div class="promo"> OpenMP calls prevent automatic vectorization when the compiler cannot move the calls outside the <span data-glossary-id="loop_body">loop body</span>, such as when OpenMP calls are not invariant. To fix: <ol> <li> Split the OpenMP parallel loop <span data-glossary-id="directive">directive</span> into two <span data-glossary-id="directive">directives</span>. <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Target </th> <th> Directive </th> </tr> </thead> <tbody> <tr> <td> Outer </td> <td> !$OMP PARALLEL [clause[[,] clause] ... ] </td> </tr> <tr> <td> Inner </td> <td> !$OMP DO [clause[[,] clause] ... ] </td> </tr> </tbody> </table> </li> <li> Move the OpenMP calls outside the loop when possible. </li> </ol> <p class="expander">Example (original code)</p> <pre class="expansion"><code class="fortran">!$OMP PARALLEL DO PRIVATE(tid, nthreads)\ndo k = 1, N\n    tid = omp_get_thread_num() ! this call inside loop prevents vectorization\n    nthreads = omp_get_num_threads() ! this call inside loop prevents vectorization\n    ...\nenddo</code></pre> </div> <p class="expander">Example (revised code)</p> <pre class="expansion"><code class="fortran">!$OMP PARALLEL PRIVATE(tid, nthreads)\n! Move OpenMP calls here\ntid = omp_get_thread_num()\nnthreads = omp_get_num_threads()\n\n!$OMP DO NOWAIT\ndo k = 1, N\n    ...\nenddo\n!$OMP END PARALLEL</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-A19889BB-C9FB-4BC6-AAF4-AA1F0BB23553.html">NOWAIT Clause</a>, <a href="docs:Fortran/17/index.htm#GUID-78ADDAF1-85FA-4A64-9A05-4FEB80FB01CE.html">PARALLEL SECTIONS</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},18964:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"dropdown"},[t("div",{ref:"menu",staticClass:"menu",style:e.menuStyle},[e._l(e.hiddenPanels,(function(i){return t("div",{key:i.slotIndex,staticClass:"item",domProps:{innerHTML:e._s(i.caption)},on:{click:function(t){return e.onSelectPanel(i.slotIndex)}}})})),e._v(" "),e._l(e.hiddenTabs,(function(i){return t("div",{key:i.slotIndex,staticClass:"item",domProps:{innerHTML:e._s(i.caption)},on:{click:function(t){return e.onSelectTab(i.slotIndex)}}})}))],2)])};o._withStripped=!0,i(69212),i(43468),i(38333),i(21602);var n=i(75337),s=i(60970);const r={data:e=>({menuStyle:{}}),computed:{...(0,n.mapGetters)("layout",["getHiddenPanels","getHiddenTabs"]),hiddenPanels(){const e=this.$route.name;return this.getHiddenPanels(e).map((e=>e.tabs.find((e=>e.tabState===s.STATE_ACTIVE)))).filter(Boolean)},hiddenTabs(){const e=this.$route.name;return this.getHiddenTabs(e)}},methods:{updateMenuStyle(){const e=this.$refs.menu.clientWidth;this.menuWidth!==e&&(this.menuWidth=e,this.menuStyle={transform:`translateX(${-e}px)`})},onSelectPanel(e){const t=this.$route.name;this.$store.direct.dispatch.layout.restorePanel({view:t,slotIndex:e})},onSelectTab(e){const t=this.$route.name;this.$store.direct.dispatch.layout.restoreTab({view:t,slotIndex:e})}},mounted(){this.updateMenuStyle()},updated(){this.updateMenuStyle()}},a=(0,i(98822).A)(r,o,[],!1,null,"57a84a0b",null).exports},18977:(e,t,i)=>{"use strict";i.d(t,{A:()=>s});var o=i(33202);function n(e,t){(0,o.KE)(e,{process:async i=>{const n=await t(i);void 0!==n&&(0,o._Y)(e,n)}})}const s={toolbar:{pressButton(e){n("test/toolbar/press-button",e)},getButtonState(e){n("test/toolbar/get-button-state",e)}},offload:{getSummaryHTML(e){n("test/offload/get-summary-html",e)},getSourceHTML(e){n("test/offload/get-source-html",e)},clickAcceleratedRegions(e){n("test/offload/accelerated-regions-click",e)},getGridHTML(e){n("test/offload/get-grid-html",e)},dumpGrid(e){n("test/offload/get-grid-extended-data",e)},expandGridColumns(e){n("test/offload/expand-grid-columns",e)},getGridColumnNames(e){n("test/offload/grid-get-column-names",e)},onButtonClickReanalyze(e){n("test/offload/on-button-click-reanalyze",e)},onButtonOffloadClick(e){n("test/offload/button-offload-click",e)},summaryTabClick(e){n("test/offload/summary-click",e)},sourceTabClick(e){n("test/offload/source-click",e)},logsTabClick(e){n("test/offload/logs-click",e)},loopSelection(e){n("test/offload/offload-loop-selection",e)},drillDownClick(e){n("test/offload/drill-down-click",e)},baselineSelectorClickGPU(e){n("test/offload/baseline-device-click-gpu",e)},setRemodelingConfiguration(e){n("test/offload/remodeling-set-configuration",e)},saveRemodelingConfiguration(e){n("test/offload/remodeling-save-configuration",e)}},gpu_roofline:{getGPUSummaryHTML(e){n("test/gpu/get-summary-html",e)},clickGPUSummary(e){n("test/gpu/gpu-summary-click",e)},clickGPUMainView(e){n("test/gpu/gpu-main-view-click",e)},loopSelection(e){n("test/gpu/gpu-loop-selection",e)},sourceTabClick(e){n("test/gpu/source-click",e)},logsTabClick(e){n("test/gpu/logs-click",e)},drillDownClick(e){n("test/gpu/drill-down-click",e)},mlrEnterDumbbell(e){n("test/gpu/mlr-enter-dumbbell",e)},mlrGetDumbbellHTML(e){n("test/gpu/mlr-get-dumbbell-html",e)},mlrOpenMemMetricsPanel(e){n("test/gpu/mlr-open-mem-metrics-panel",e)},mlrGetMemMetricsHTML(e){n("test/gpu/mlr-get-mem-metrics-html",e)}},perspective_selector:{buttonDblClick(e){n("test/perspective/button-double-click",e)}},snapshot:{buttonSnapshotClick(e){n("test/snapshot/button-snapshot-click",e)}},welcome:{getHTML(e){n("test/welcome/get-html",e)},pressButton(e){n("test/welcome/press-button",e)}},workflow:{runBatchMode(e){n("test/workflow/run-batch-mode",e)},getBatchModeState(e){n("test/workflow/get-batch-mode-state",e)},executeCommand(e){n("test/workflow/execute-command",e)},setOption(e){n("test/workflow/set-option",e)},setAccuracyMode(e){n("test/accuracy/set-mode",e)}},layout:{activateTab(e){n("test/layout/activate-tab",e)},hidePanel(e){n("test/layout/hide-panel",e)}}}},19052:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,e.values.length?t("div",{staticClass:"metric"},[t("div",{staticClass:"data",class:{compact:e.compact}},[e.title?t("span",{attrs:{name:"title"}},[t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.tooltip,expression:"tooltip"}],class:{clickable:e.clickable},on:{click:e.onTitleClick}},[e._v("\n        "+e._s(e.title)+"\n      ")])]):e._e(),e._v(" "),e.compact?t("simple-bar-chart",{attrs:{values:e.values,colors:e.colors,"value-min":e.valueMin,"value-max":e.valueMax,"min-width":e.minWidth}}):e._e(),e._v(" "),e.formattedValue?t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.valueTooltip,expression:"valueTooltip"}],attrs:{name:"value"},domProps:{innerHTML:e._s(e.formattedValue)}}):e._e(),e._v(" "),!e.compact&&e.percentValue?t("span",{attrs:{name:"percent"}},[e._v(e._s(e.percentValue))]):e._e()],1),e._v(" "),e.compact?e._e():t("simple-bar-chart",{attrs:{values:e.values,colors:e.colors,"value-min":e.valueMin,"value-max":e.valueMax,"min-width":e.minWidth}})],1):e._e()},n=[];o._withStripped=!0},19065:e=>{e.exports=' <h4>Implement a tiling technique in a Shared Local Memory and reuse data between work items in one work group</h4> <div class="text"> <div class="promo"> <span data-glossary-id="SLM">Shared Local Memory (SLM)</span> is more efficient than global memory and can be used to share data between work items in one work group. To improve data locality: <ul> <li> Divide a big dataset into small tiles or arrays of elements. </li> <li> Explicitly load each tile or array to the <span data-glossary-id="SLM">SLM</span> and reuse it between work items in one work group. </li> <li> Load the result to the global memory. </li> </ul> Currently, local size, or work-group size, is %local_work_size% work items, and SLM allocation should not exceed %max_slm_per_wg% per work group. In <a href="https://www.intel.com/content/www/us/en/docs/oneapi/programming-guide/current/data-parallelism-in-c-using-sycl.html">Data Parallel C++ (DPC++)</a> with Level Zero API, you can use <samp class="codeph">accessor</samp> class specialized with <samp class="codeph">access::target::local</samp>. See <a href="https://www.khronos.org/registry/SYCL/specs/sycl-2020/html/sycl-2020.html#_accessor_specialization_with_targetlocal">documentation</a> for more details. <p class="expander">Explanation</p> <p class="expansion"> To find the amount of data that a work group can effectively use, you need to know the maximum <span data-glossary-id="SLM">SLM</span> allocation size available for it. SLM is a memory shared between execution units (EU) running on the same sub-slice of an Intel® Graphics Processor. Each sub-slice of the current GPU hardware has %eu_count_per_ss% EUs and %gpu_slm_size_per_ss% of SLM. Each EU can start %thread_slots_per_eu% hardware threads. In theory, up to %thread_slots_per_ss% EU threads can run in parallel on one sub-slice. <br> <br> Thread occupancy of the current kernel is %thread_occupancy%. <span id="low_thread_occupancy"> It means a smaller number of threads runs in parallel than is available on the current GPU. </span> High SLM allocation can be the reason of reduced number of parallel threads and decreased thread occupancy. One hardware thread should not allocate more than %max_slm_per_thread% so that high SLM allocation does not increase thread occupancy. <br> <br> Currently, local size, or work-group size, is %local_work_size% work items. The number of work items that are processed together as a SIMD vector on one EU thread is %gpu_current_row_simd_width%. To run one work group, %threads_per_wg% EU threads are required. As a result, %parallel_wq_per_ss% work groups can run in parallel and SLM allocation should not exceed %max_slm_per_wg% per work group. <br> <br> <b>Note: </b> SLM is a program-driven memory, and synchronizing data between work items is a developer’s responsibility. A work group barrier may be a good way to organize work when local memory is shared between work items. For example, put a barrier after allocating a tile in the SLM and before releasing it, because other work items could use this data in parallel. In <a href="https://www.intel.com/content/www/us/en/docs/oneapi/programming-guide/current/data-parallelism-in-c-using-sycl.html">Data Parallel C++ (DPC++)</a> with Level Zero API, you can use <samp class="codeph">nd_item<dimensions>::barrier</dimensions></samp> with <samp class="codeph">access::fence_space::local_space</samp> as parameter. See <a href="https://intel.github.io/llvm-docs/doxygen/classcl_1_1sycl_1_1nd__item.html#a25470d2b92e6e8df3d83709969ff876b">documentation</a> for more details. </p> <p class="expander">Example of the matrix multiplication algorithm, which loads a sub-matrix, operates on it, and shares data between work items: </p> <pre class="essential"><code class="cpp" data-source="\n...\naccessor<unsigned int, 2, access::mode::read_write, access::target::local> tileA{tileRange, cgh};\naccessor<unsigned int, 2, access::mode::read_write, access::target::local> tileB{tileRange, cgh};\n\ncgh.parallel_for<class kernel1>(nd_range<2>(matrixRange, tileRange), [=](nd_item<2> item)\n...\ntileA[row][col] = ra[globalRow][tiledCol];\ntileB[row][col] = rb[tiledRow][globalCol];\nitem.barrier(cl::sycl::access::fence_space::local_space);\n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\n    buffer<unsigned int, 2> bufA(&(a[0][0]), range<2>(N, N));\n    buffer<unsigned int, 2> bufB(&(b[0][0]), range<2>(N, N));\n    buffer<unsigned int, 2> bufC(&(c[0][0]), range<2>(N, N));\n\n    constexpr size_t TILE_SIZE = 16;\n    constexpr size_t TILE_COUNT = N / TILE_SIZE;\n    range<2> matrixRange{N, N};\n    range<2> tileRange{TILE_SIZE, TILE_SIZE};\n\n    q.submit([&](handler &cgh)\n    {\n        auto ra = bufA.get_access<access::mode::read>(cgh);\n        auto rb = bufB.get_access<access::mode::read>(cgh);\n        auto rc = bufC.get_access<access::mode::read_write>(cgh);\n\n        // Define accessors for shared data with access::target::local template parameter\n        accessor<unsigned int, 2, access::mode::read_write, access::target::local> tileA{tileRange, cgh};\n        accessor<unsigned int, 2, access::mode::read_write, access::target::local> tileB{tileRange, cgh};\n\n        cgh.parallel_for<class kernel1>(nd_range<2>(matrixRange, tileRange), [=](nd_item<2> item)\n        {\n            int k;\n            const int row = item.get_local_id(0);\n            const int col = item.get_local_id(1);\n            const int globalRow = TILE_SIZE * item.get_group(0) + row;\n            const int globalCol = TILE_SIZE * item.get_group(1) + col;\n            unsigned int sum=0;\n            for (int t = 0; t < TILE_COUNT; t++)\n            {\n                const int tiledRow = TILE_SIZE * t + row;\n                const int tiledCol = TILE_SIZE * t + col;\n\n                // Load tile A and tile B from global memory to shared memory\n                tileA[row][col] = ra[globalRow][tiledCol];\n                tileB[row][col] = rb[tiledRow][globalCol];\n\n                // Put a barrier to make sure all work items have loaded shared data\n                item.barrier(access::fence_space::local_space);\n                for (k = 0; k < TILE_SIZE; k++)\n                {\n                    // Use tiles loaded to shared memory\n                    sum += tileA[row][k] * tileB[k][col];\n                }\n                // Put a barrier to make sure all work items have completed computation using shared data\n                item.barrier(access::fence_space::local_space);\n            }\n            rc[globalRow][globalCol] = sum;\n        });\n    }).wait();"></code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/develop/documentation/oneapi-gpu-optimization-guide/top/kernels/slm.html"> oneAPI GPU Optimization Guide</a> </li> <li> <a href="https://www.khronos.org/registry/SYCL/specs/sycl-2020/html/sycl-2020.html#_accessor_specialization_with_targetlocal"> Accessor specialization with target::local</a> </li> <li> <a href="https://intel.github.io/llvm-docs/doxygen/classcl_1_1sycl_1_1nd__item.html#a25470d2b92e6e8df3d83709969ff876b"> Barrier</a> </li> </ul> </div> '},19158:function(e,t,i){"use strict";i(21602);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(12168)),s=o(i(83230)),r=i(38235),a=["information-circle","check-circle","alert-triangle","cross-circle",["information-circle","gray"],["check-circle","gray"],["alert-triangle","gray"],["cross-circle","gray"]],l={props:{eventName:{type:String,required:!0},id:String,type:String,eventType:Number,hidden:[Boolean,Number],title:String,text:String,icon:String,imageType:Number,animation:[Boolean,Number],textItems:{type:Array,default:()=>[]},buttons:{type:Array,default:()=>[]},optionCaption:String,optionState:Boolean,min:{type:Number,default:0},max:{type:Number,default:100},val:Number,isCollapsed:Boolean},mixins:[n.default],computed:{eventClass(){return this.eventType===r.EVENT_TYPE_EVENT?"event":"reco"},iconClass(){const{icon:e,eventType:t,imageType:i,animation:o}=this;if(e)return e;if(t===r.EVENT_TYPE_EVENT){if(o)return"circle-third spin";{const e=a[i]||"none";return Array.isArray(e)?e.join(" "):e}}return t===r.EVENT_TYPE_RECOMMENDATION?"megaphone":"none"},message(){const e=this.text||this.textItems.map((e=>{const{briefText:t,fullText:i,isBrief:o}=e;return void 0===o||o?t:i})).join("<br />");return this.isCollapsed?"":e},progressMax(){return this.max-this.min},progressValue(){return this.val||this.min},orderedButtons(){const e=[...this.buttons];return e.sort(((e,t)=>e.id-t.id)),e},isProgressVisible(){return"gaugeBox"===this.type},isCheckboxVisible(){return!!this.optionCaption&&this.optionCaption!==this.$t("do_not_show_this_message_again")},canHide(){return this.optionCaption===this.$t("do_not_show_this_message_again")},canCollapse(){const{textItems:e,buttons:t,isCheckboxVisible:i}=this;return e.length>0&&0===t.length&&!i},collapseIcon(){return this.isCollapsed?"icon chevron-down":"icon chevron-up"}},methods:{getEvent(e,t){const i={messageBoxId:this.id,type:this.type,notification:e};return t&&(i.data=t),i},onHide(){this.onChangeOption({target:{checked:!0}})},onCollapse(){const{id:e,eventName:t}=this;this.$store.direct.dispatch.log.setEventField({id:e,eventName:t,field:"isCollapsed",value:!this.isCollapsed})},onChangeOption(e){s.default.send(this.eventName,this.getEvent("optionChanged",{state:e.target.checked}))},onButtonClick(e){const t="gaugeBox"===this.type?this.getEvent("gaugeCanceled"):this.getEvent("buttonPressed",{id:e});s.default.send(this.eventName,t)},onLinkClick(e){s.default.send(this.eventName,this.getEvent("linkClicked",{linkText:e}))}}};t.default=l},20095:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(e,t){return e("div",t._b({},"div",t.data.attrs,!1),[e("i",{staticClass:"icon circle-third spin"})])};o._withStripped=!0;const n=(0,i(98822).A)({},o,[],!0,null,"23a36b7d",null).exports},20236:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("table-view",{staticClass:"content",attrs:{columns:e.gridColumns,rows:e.getTopOffloadedData.rows||[],"single-line-header":""},scopedSlots:e._u([{key:"location",fn:function({row:i,value:o}){return[t("router-link",{attrs:{to:{name:"offload:accelerated-regions"}},nativeOn:{click:function(t){return e.onDrillDown(i)}}},[e._v("\n      "+e._s(o)+"\n    ")])]}},{key:"execution_time",fn:function({row:i}){return[e.timesAvailable(i)?t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.getTimeRegionToolTip(i,e.speedUp,e.allColumns),expression:"getTimeRegionToolTip(row, speedUp, allColumns)"}],staticClass:"speedup-metrics"},[t("region-time-chart",{staticClass:"bar",attrs:{row:i,"bars-height":"2.667em","bar-width":.14,allColumns:e.allColumns,timeKeys:e.speedUp}}),e._v(" "),t("metric-item",{staticClass:"time-metric orig",attrs:{metric:e.getOffloadElapsedTime(i)}}),e._v(" "),t("metric-item",{staticClass:"time-metric accel",attrs:{metric:e.getEstimatedAccelTime(i)}})],1):e._e()]}},{key:"offload_bounded_by",fn:function({row:i,column:o}){return[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.getTimeRegionToolTip(i,e.boundedBy,e.allColumns),expression:"getTimeRegionToolTip(row, boundedBy, allColumns)"}],staticClass:"bound-by-metrics"},[t("region-time-chart",{staticClass:"bar",attrs:{row:i,"bars-height":e.getHeightByNumberOfBars(i),"bar-width":.85,allColumns:e.allColumns,timeKeys:e.getBoundedByKeysSorted(i)}}),e._v(" "),t("div",{staticClass:"info-after"},[e._v(e._s(e.getColumnInfo(i,o.id,e.allColumns)))])],1)]}}])})};o._withStripped=!0,i(36094);var n=i(75337);const s={inject:["api"],mixins:[i(27477).p],created(){this.updateBoundedBy()},computed:{...(0,n.mapGetters)("offload",["getTopOffloadedData"]),allColumns(){return{execution_time:{id:"execution_time",title:this.$t("execution_time"),tooltip:this.$t("execution_time_tooltip")},...this.getTopOffloadedData.columns}},gridColumns(){return this.updateGridColumns([{id:"location",width:"minmax(13rem, 1fr)"},{id:"execution_time",width:"max-content"},{id:"speed_up",width:"max-content"},{id:"offload_bounded_by",width:"minmax(13rem, 19%)"},{id:"data_transferred_total",width:"max-content",align:"right"}])}},data:()=>({boundedBy:{acceleratedBreakdown:[],taxes:[]},speedUp:{original:"offload_elapsed_time",totalAccelerated:"total_time_on_accel"}}),methods:{getEstimatedAccelTime(e){const t=this.speedUp.totalAccelerated||"total_time_on_accel";return this.getTopRegionColumn(e,t,this.allColumns)},getOffloadElapsedTime(e){return this.getTopRegionColumn(e,this.speedUp.original,this.allColumns)},updateBoundedBy(){if(!this.boundedBy.taxes.length||!this.boundedBy.acceleratedBreakdown.length)for(const e in this.allColumns)e.startsWith("offload_taxes_")||e.startsWith("latencies_")?this.boundedBy.taxes.push(e):e.startsWith("throughput_")&&this.boundedBy.acceleratedBreakdown.push(e)},timesAvailable(e){return void 0!==this.getOffloadElapsedTime(e).value||void 0!==this.getEstimatedAccelTime(e).value}}},r=(0,i(98822).A)(s,o,[],!1,null,"49731a4f",null).exports},20291:e=>{e.exports=' <h4>Enable vectorization</h4> <div class="text"> <p class="promo"> The Dependencies analysis shows there is no real dependency in the loop for the given workload. Tell the compiler it is safe to vectorize using the <samp class="codeph">restrict</samp> keyword or a <span data-glossary-id="directive">directive</span>: </p> <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Directive </th> <th> Outcome </th> </tr> </thead> <tbody> <tr> <td> !$OMP SIMD </td> <td> Ignores all dependencies in the loop </td> </tr> <tr> <td> !DIR$ IVDEP </td> <td> Ignores only vector dependencies (which is safest) </td> </tr> </tbody> </table> <div class="promo"> <p class="expander">Example</p> <pre class="essential"><code class="cpp">!DIR$ IVDEP\n...</code></pre> <pre class="expansion"><code class="fortran">!DIR$ IVDEP\ndo i = 1, N-4, 4\n    a(i+4) = b(i) * c\nenddo</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-7E982960-B603-4781-BEBC-E8EFA9208DB3.html">IVDEP</a>, <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},20544:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=i(91832),n={};for(const e in o)"default"!==e&&(n[e]=()=>o[e]);i.d(t,n);const s=(0,i(98822).A)(o.default,void 0,void 0,!1,null,"5fbfb571",null).exports},20686:e=>{e.exports=' <h4>Disable unrolling</h4> <div class="text"> <div class="promo"> The <span data-glossary-id="trip_count">trip count</span> <span id="peel_remainder"> %trip_count% after loop unrolling is too small compared to the <span data-glossary-id="vector_length">vector length</span> %vl% </span>. To fix: Prevent loop <span data-glossary-id="unroll">unrolling</span> or decrease the unroll factor using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">#pragma nounroll</samp> or <samp class="codeph">#pragma unroll</samp>. <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n// Disable automatic loop unrolling using\n#pragma nounroll\nfor (int i = 1; i &lt; 100; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void nounroll(int a[], int b[], int c[], int d[])\n{\n    // Disable automatic loop unrolling using\n    #pragma nounroll\n    for (int i = 1; i &lt; 100; i++)\n    {\n        b[i] = a[i] + 1;\n        d[i] = c[i] + 1;\n    }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li><a href="docs:C++/17/index.htm#GUID-30B36136-E399-4D7A-9BF8-06D96B8536E9.html">unroll/nounroll</a></li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},20743:e=>{e.exports=' <h4>No data locality</h4> <div class="essential"> %disclaimer% %kernel_bounded_by% Data is read from a slower memory as the GPU kernel processes more data than fits into GRF and GPU caches. This causes performance decrease. The <span data-glossary-id="cache_line_utilization">cache line utilization</span> is %cache_line_util%, which is good enough. It means an ineffective memory access pattern is not the main reason of frequent memory requests. In general, using previously cached data multiple times may improve performance. </div>'},20759:e=>{e.exports=' <h4> Enable the use of approximate reciprocal instructions by fine-tuning precision and floating-point model compiler options </h4> <div class="text"> <div class="promo"> Static analysis presumes the loop may benefit from using approximate reciprocal instructions, but the precision and floating-point model settings may prevent the compiler from using these instructions. To fix: Fine-tune your usage of the following compiler options: </div> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> <th> Comment </th> </tr> </thead> <tbody> <tr> <td>/fp</td> <td>-fp-model</td> <td><p><samp class="codeph">-fp-model=precise</samp> prevents the use of approximate reciprocal instructions.</p></td> </tr> <tr> <td>/Qimf-precision</td> <td>-fimf-precision</td> <td><p>Consider using <samp class="codeph">-fimf-precision=medium</samp> or <samp class="codeph">-fimf-precision=low</samp>.</p></td> </tr> <tr> <td>/Qimf-accuracy-bits</td> <td>-fimf-accuracy-bits</td> <td>Consider decreasing this setting.</td> </tr> <tr> <td>/Qimf-max-error</td> <td>-fimf-max-error</td> <td><p>Consider increasing this setting. <br/> There is a similar option: <samp class="codeph">-fimf-absolute-error</samp>. Avoid using both options at the same time or tune them together.</p></td> </tr> <tr> <td>/Qimf-absolute-error</td> <td>-fimf-absolute-error</td> <td><p>Consider using <samp class="codeph">-fimf-max-error</samp> instead and set <samp class="codeph">-fimf-absolute-error=0</samp> (default) or increase this setting together with <samp class="codeph">-fimf-max-error</samp>.</p></td> </tr> <tr> <td>/Qimf-domain-exclusion</td> <td>-fimf-domain-exclusion</td> <td>Consider increasing this setting. More excluded classes enable more optimized code. USE WITH CAUTION. This option may cause incorrect behavior if your calculations involve excluded domains.</td> </tr> <tr> <td>/Qimf-arch-consistency</td> <td>-fimf-arch-consistency</td> <td><p><samp class="codeph">-fimf-arch-consistency=true</samp> may prevent the use of approximate reciprocal instructions.</p></td> </tr> <tr> <td>/Qprec-div</td> <td>-prec-div</td> <td><p><samp class="codeph">-prec-div</samp> prevents the use of approximate reciprocal instructions.</p></td> </tr> <tr> <td>/Qprec-sqrt</td> <td>-prec-sqrt</td> <td><p><samp class="codeph">-prec-sqrt</samp> prevents the use of approximate reciprocal instructions.</p></td> </tr>  </tbody></table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/floating-point-operations.html">Floating-Point Operations</a> and <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/floating-point-options.html">Floating-Point Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html"> Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},21154:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(99129),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},21255:function(e,t,i){"use strict";i(21602);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(25405)),s={props:{data:Object},computed:{metrics(){const{metrics:e}=this.data||{};if(e)return e.map((({caption:e,explanation:t,measure:i,metrics:o})=>({id:e,caption:e,explanation:t,bars:Object.entries(o).map((([e,t])=>{const o=e.toLowerCase(),{caption:s,label:r,val:a}=t;return{id:o,title:r,values:[a/100],colors:[n.default[o]],formattedValue:s+i}}))})))}}};t.default=s},21397:(e,t,i)=>{function o(e,t){if(!e)return;e.querySelectorAll("#is_vectorized").forEach((function(e){e.Visible(t.is_vectorized)}));const i=e.querySelector("#is_scalar");i&&i.Visible(!t.is_vectorized)}function n(e,{limiting_mem_level:t,limiting_roof:i}){if(!e)return;let o=!1;e.querySelectorAll("[id*=bounded_by_]",e).forEach((function(e){const i=!!t&&e.id===`bounded_by_${t.toLowerCase()}`;e.Visible(i),o=o||i}));const n=e.querySelector("#below_dram");n&&n.Visible(!o&&3==i);const s=e.querySelector("#below_shared_cache");s&&s.Visible(!o&&2==i);const r=e.querySelector("#below_private_cache");r&&r.Visible(!o&&1==i);const a=e.querySelector("#dram_is_bottleneck");a&&a.Visible(3==i)}function s(e,t){if(!e)return;const i=e.querySelector("#inefficient_map");i&&i.Visible(t.inefficient_map)}function r(e,t){o(e,t),function(e,t){if(!e)return;const i=e.querySelector("#fma_dominates");i&&i.Visible(t.is_fma_dominated);const o=e.querySelector("#add_dominates");o&&o.Visible(!t.is_fma_dominated)}(e,t),function(e,t){if(!e)return;const i=e.querySelector("#isa_issue");if(i){const e=/%c_isa%/g,o='<code class="hljs-title">'+t.current_isa+"</code>";i.innerHTML=i.innerHTML.replace(e,o);const n=/%b_isa%/g,s='<code class="hljs-title">'+t.best_isa+"</code>";i.innerHTML=i.innerHTML.replace(n,s),i.Visible(t.current_isa&&t.best_isa)}}(e,t),function(e,t){if(!e)return;const i=e.querySelector("#has_traits");if(i){const e=/%traits%/g,o='<code class="hljs-title">'+t.traits+"</code>";i.innerHTML=i.innerHTML.replace(e,o),i.Visible(t.traits)}}(e,t),s(e,t)}function a(e,t){o(e,t),n(e,t),function(e,t){if(!e)return;const i=e.querySelector("#scalar_mem_instructions");i&&i.Visible(t.scalar_mem_instructions)}(e,t),s(e,t),p(e,t),d(e,t)}i(69212),i(45361);const l={};var c;function d(e,t){if(!e||!t)return;const i=e.querySelector("#bad_traffic_img");if(i){const e=function({ops_type:e}){if(!e)return null;const t=`roofline-${e}-bad-map.png`;return l[t]?l[t].default:void 0}(t);e&&(i.src=e),i.Visible(!!e)}}function p(e,t){if(!e)return;const i=e.querySelector("#more_ineff_map_info");i&&i.Visible(!t.more_ineff_map_info);const o=e.querySelector("#bad_traffic_impact");o&&o.Visible(t.bad_traffic_impact)}(c=i(45150)).keys().forEach((e=>l[e.split("/").pop()]=c(e))),window.rec_roofline_guidance_compute_bound=r,window.rec_roofline_guidance_mostly_compute_bound=function(e,t){r(e,t),n(e,t),p(e,t),d(e,t)},window.rec_roofline_guidance_mostly_memory_bound=a,window.rec_roofline_guidance_memory_bound=function(e,t){if(a(e,t),!e)return;const i=e.querySelector("#low_vector_efficiency");i&&i.Visible(t.low_vector_efficiency)},window.rec_roofline_guidance_confirm_inefficient_map=function(e,t){d(e,t)}},21673:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=i(55489),n={};for(const e in o)"default"!==e&&(n[e]=()=>o[e]);i.d(t,n);const s=(0,i(98822).A)(o.default,void 0,void 0,!1,null,"9510d0da",null).exports},21807:(e,t)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const i={props:{data:Array}};t.A=i},22088:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(91009),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},22196:e=>{e.exports=' <h4>Assumed dependency present</h4> <div class="essential"> The compiler assumed there is an anti-dependency (Write after read - WAR) or a true dependency (Read after write - RAW) in the loop. Improve performance by investigating the assumption and handling accordingly. </div>'},22207:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"button",class:{selected:e.selected},on:{click:e.click,dblclick:e.doubleClick}},[e.selected?t("div",{staticClass:"check-mark"}):e._e(),e._v(" "),t("div",{staticClass:"image",style:{background:e.color}},[t("img",{attrs:{src:e.icon}})]),e._v(" "),t("h3",[e._v(e._s(e.name))])])};o._withStripped=!0;const n={props:{name:{type:String,required:!0},icon:{type:String,required:!0},color:{type:String,default:"#E1EFF6"},selected:Boolean,disabled:Boolean},methods:{click:function(){this.disabled||this.$emit("click")},doubleClick:function(){this.disabled||this.$emit("dblclick")}}},s=(0,i(98822).A)(n,o,[],!1,null,"1b5dbef0",null).exports},22217:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>l});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"nav"},[e.perspectivePrefix?t("div",{staticClass:"nav-line"},[t("router-link",{attrs:{to:{name:e.summaryName}}},[e._v("\n      "+e._s(e.$t(e.summaryName))+"\n    ")]),e._v(" "),t("span",[e._v("•")]),e._v(" "),t("router-link",{attrs:{to:{name:e.mainViewName}}},[e._v("\n      "+e._s(e.$t(e.mainViewName))+"\n    ")]),e._v(" "),t("span",[e._v("•")]),e._v(" "),t("router-link",{attrs:{to:{name:e.sourceName}}},[e._v("\n      "+e._s(e.$t(e.sourceName))+"\n    ")])],1):e._e()])};o._withStripped=!0;var n=i(84620),s=i(75337);const r=[":log",":source"],a={computed:{...(0,s.mapGetters)(["activePerspectiveId"]),perspectiveName(){return`perspective_${this.perspectivePrefix}_name`},summaryName(){return`${this.perspectivePrefix}:summary`},mainViewName(){switch(this.activePerspectiveId){case n.ProductMode.pmOffload:return"offload:accelerated-regions";case n.ProductMode.pmGPU:return"gpu:main";case n.ProductMode.pmRoofline:return"roofline:main"}return this.perspectiveName},sourceName(){return`${this.perspectivePrefix}:source`},moreNames(){return r.map((e=>`${this.perspectivePrefix}${e}`))},perspectivePrefix(){switch(this.activePerspectiveId){case n.ProductMode.pmOffload:return"offload";case n.ProductMode.pmGPU:return"gpu";case n.ProductMode.pmRoofline:return"roofline"}return""},selectedMoreName(){return`${this.perspectivePrefix}${this.$store.direct.state.visibleNavigationLink}`}},watch:{$route({name:e}){const t=r.find((t=>null==e?void 0:e.includes(t)));t&&this.$store.direct.commit.updateVisibleNavigationLink(t)}}},l=(0,i(98822).A)(a,o,[],!1,null,"11e7308a",null).exports},22818:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(e,t){return e("div",[t._t("default")],2)};o._withStripped=!0;const n=(0,i(98822).A)({},o,[],!0,null,"3ccd00b0",null).exports},22896:(e,t,i)=>{"use strict";i.d(t,{Q:()=>o}),i(84422),i(69212),i(43468),i(21602);const o=({caption:e,filter:t,noDataText:i})=>{const o={response:void 0};try{let n=e?[document.querySelector(`[caption="${e}"]`)]:Array.from(document.querySelectorAll("[caption]"));t&&(n=n.filter((e=>e.innerText!==i))),o.response=n.map((e=>({[e.attributes.caption.value]:e.innerHTML.replaceAll(/[^\x00-\x7F]/g,"")})))}catch(e){o.error=e}return o}},23213:function(e,t,i){"use strict";i(36094),i(27468),i(83038),i(88984),i(2449),i(66824),i(37271),i(16124),i(29590),i(69212),i(43468),i(21602),i(32204);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=i(75337),s=i(1067),r=o(i(38576)),a={props:{type:{type:String,validator:e=>"string"==typeof e&&s.TYPES.includes(e),required:!0}},data:()=>({rooflineConfigurationOptions:[]}),computed:{...(0,n.mapGetters)("gpu",["getOpsAndBandwidthData","getInstructionMixData"]),data(){return this.getOpsAndBandwidthData(this.type)},mix(){var e,t,i,o;const n=(e,t,i)=>t.map((t=>e.filter((e=>e[i]===t||e[i].title===t)).reduce(((e,t)=>e+t.instructionCount.value),0))).map(((e,i)=>{const o=[],n=f.length,s=t[i];return o[n]=e,{title:s,values:o,color:r.default[s.toLowerCase()]}})),s=this.getInstructionMixData(this.type);if(!s)return;const a=null===(e=s.compute)||void 0===e?void 0:e.instructions,l=null===(t=s.memory)||void 0===t?void 0:t.instructions,c=null===(i=s.atomic)||void 0===i?void 0:i.instructions,d=null===(o=s.other)||void 0===o?void 0:o.instructions,p=[...new Set(null==a?void 0:a.map((e=>e.dataType.title)))],u=[...new Set(null==l?void 0:l.map((e=>e.instruction)))],h=[...new Set(null==c?void 0:c.map((e=>e.instruction)))],m=[...new Set(null==d?void 0:d.map((e=>e.instruction)))],f=[],v=n(a,p,"dataType");v.length>0&&f.push(this.$t("compute_col"));const g=n(l,u,"instruction");g.length>0&&f.push(this.$t("memory_col"));const _=n(c,h,"instruction");_.length>0&&f.push(this.$t("atomic_col"));const y=n(d,m,"instruction");return y.length>0&&f.push(this.$t("other_col")),{labels:f,series:[].concat(v,g,_,y)}},flex(){return{flex:[{[s.GPU]:1,[s.CPU]:1},{[s.GPU]:1,[s.CPU]:4},{[s.GPU]:4,[s.CPU]:1},{[s.GPU]:2,[s.CPU]:1}][2*+(this.getOpsAndBandwidthData(s.GPU).length>0)+ +(this.getOpsAndBandwidthData(s.CPU).length>0)][this.type]}},isGPU(){return this.type===s.GPU}},created(){this.rooflineId=`gpu/summary/${this.type}-roofline`,this.rooflineSelectionId=`gpu/main/${this.type}Selection`,this.excludedExtensions=this.type===s.GPU?["zones"]:[]},methods:{updateRooflineOptions(e){const t=this.$refs.roofline.rooflineView;t&&(t.setConfigurationOptionValue(e),t.sendRooflineNotification(`setDefaultConfiguration:${e}`,`gpu/main/${this.type}-roofline`))},fillRooflineOptions(){const e=this.$refs.roofline.rooflineView;e&&(this.rooflineConfigurationOptions=[e.getConfigurationOption("f"),e.getConfigurationOption("i")])}}};t.default=a},23364:e=>{e.exports=' <h4>Use the smallest data type</h4> <div class="text"> <p class="promo"> The <span data-glossary-id="source_loop">source loop</span> contains data types of different widths. To fix: Use the smallest data type that gives the needed precision to use the entire <span data-glossary-id="vector_register_width">vector register width</span>. </p> <p><b>Example:</b> If only 16-bits are needed, using a short rather than an int can make the difference between eight-way or four-way SIMD parallelism, respectively.</p> </div>'},23806:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return e.isEmpty?e._e():t("div",{staticClass:"container"},[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.metric.tooltip,expression:"metric.tooltip"}],staticClass:"metric"},[e._v("\n    "+e._s(e.metric.title)),t("br"),e._v(" "),t("span",[e._v(e._s(e.value))])])])};o._withStripped=!0;var n=i(77106);const s={props:{metric:{type:Object,required:!0}},computed:{isEmpty(){return!this.metric.value},value(){return this.metric.formattedValue||(0,n.formatNumber)(this.metric)}}},r=(0,i(98822).A)(s,o,[],!1,null,"55134bc0",null).exports},23845:(e,t,i)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const o=i(75337),n=i(38235),s={props:{eventName:{type:String,required:!0}},computed:{...(0,o.mapGetters)("log",["getTopSliderHeight","getOutputHeight","getEventLogContentHeight","getRecommendationsContainerHeight","getTopSliderCondition","getTopSliderPrevCondition","isTopSliderVisible","isTopSliderCollapsed","isTopSliderMaximized","isRecommendationsVisibleInTopSlider","isEventLogVisible","isAutoShowRecommendations"]),isCollectionRunning(){return this.$store.direct.getters.log.isCollectionRunning(this.eventName)},events(){return this.$store.direct.getters.log.getEventsByType(this.eventName,n.EVENT_TYPE_EVENT)},recommendations(){return this.$store.direct.getters.log.getEventsByType(this.eventName,n.EVENT_TYPE_RECOMMENDATION)},hasRecommendations(){return this.$store.direct.getters.log.hasRecommendations(this.eventName)},hasApplicationOutput(){return this.$store.direct.getters.log.hasApplicationOutput(this.eventName)},hasCollectorOutput(){return this.$store.direct.getters.log.hasCollectorOutput(this.eventName)},minHeight(){const{isCollectionRunning:e,isEventLogVisible:t,isRecommendationsVisibleInTopSlider:i,hasRecommendations:o,hasApplicationOutput:s,hasCollectorOutput:r,getOutputHeight:a,getRecommendationsContainerHeight:l}=this;let c=0;return e&&(c+=n.METER_HEIGHT),t&&(c+=n.MIN_SPLITTER_SIZE,(s||r)&&(c+=a||n.DEFAULT_OUTPUT_HEIGHT)),o&&i&&(c+=t?l||0:n.MIN_SPLITTER_SIZE),`${c}px`},contentStyle(){const{isCollectionRunning:e,getTopSliderHeight:t,isTopSliderMaximized:i,minHeight:o}=this;let s;return i?s=`calc(100vh - ${78+(e?n.METER_HEIGHT:0)}px)`:void 0!==t&&(s=`${t}px`),{height:s,"min-height":o}},debugInfo(){return n.DEBUG&&`\n        <li>eventName: ${this.eventName}</li>\n        <li>condition: ${this.getTopSliderCondition} (was ${this.getTopSliderPrevCondition})</li>\n        <li>events height: ${this.getEventLogContentHeight}</li>\n        <li>output height: ${this.getOutputHeight}</li>\n        <li>reco height: ${this.getRecommendationsContainerHeight}</li>\n        <li>height: ${this.getTopSliderHeight}</li>\n        <li>style: ${JSON.stringify(this.contentStyle)}</li>\n        `}},methods:{onResize(e){const{height:t}=this.$parent.$el.getBoundingClientRect();e>t-100?this.isTopSliderMaximized||this.$store.direct.dispatch.log.setTopSliderCondition(n.CONDITION_MAXIMIZED):(this.isTopSliderMaximized&&this.$store.direct.dispatch.log.setTopSliderCondition(n.CONDITION_EXPANDED),this.$store.direct.dispatch.log.setTopSliderHeight(Math.max(e,0)))},onCollapse(){this.$store.direct.dispatch.log.setTopSliderCondition(n.CONDITION_COLLAPSED)},onExpand(){this.$store.direct.dispatch.log.expandTopSlider()}},watch:{recommendations(e){e.length&&this.isAutoShowRecommendations&&(this.$store.direct.dispatch.log.toggleRecommendationsVisible(!0),this.$store.direct.commit.log.setAutoShowRecommendations(!1))}}};t.A=s},23949:(e,t,i)=>{"use strict";i.d(t,{A:()=>k}),i(36094),i(69212),i(45361),i(21602);var o,n=i(61262),s="http://www.w3.org/2000/svg",r=(o=0,function(){return"SVG_"+o+++"_"});function a(e){this.el=document.createElementNS(s,e),this.el.owner=this}function l(e){a.call(this,e)}function c(){a.call(this,"filter")}function d(e){a.call(this,e)}function p(){d.call(this,"linearGradient")}function u(){d.call(this,"radialGradient")}function h(){a.call(this,"path"),this.segs=[]}function m(){a.call(this,"rect")}function f(){a.call(this,"image")}function v(){a.call(this,"line")}function g(){a.call(this,"circle")}function _(){a.call(this,"ellipse")}function y(e){return e.join(" ")}function b(e){var t=[];return e&&(t=e.split(" ").map((e=>e.split(",").map((e=>parseFloat(e)))))),t}function w(){a.call(this,"polyline")}function x(){a.call(this,"polygon")}function C(e,t){t=t||"text",a.call(this,t),void 0!==e&&this.setText(e)}function A(){a.call(this,"foreignObject")}function S(){a.call(this,"use")}function T(e){a.call(this,e)}function I(){T.call(this,"defs")}function P(){T.call(this,"clipPath")}function M(){T.call(this,"pattern")}function E(e){T.call(this,e)}function L(){E.call(this,"marker")}function R(e){E.call(this,"svg"),this.id=r(),this.setId(this.id),e&&(this._simpleCTM=!0),this.setAttr("preserveAspectRatio","none")}function D(e,t,i){var o;return this._simpleCTM?(o=this[t])||(this[t]=o=e[i]()):o=e[i](),o}a.prototype.activate=function(){return this.el.classList.add("idvc2_active"),this},a.prototype.deactivate=function(){return this.el.classList.remove("idvc2_active"),this},a.prototype.hide=function(){return this.el.classList.add("idvc2_hidden"),this},a.prototype.isHidden=function(){return this.el.classList.contains("idvc2_hidden")},a.prototype.show=function(){return this.el.classList.remove("idvc2_hidden"),this},a.prototype.getAttr=function(e,t){var i;return t=t||null,e&&(i=this.el.getAttributeNS(t,e)),i},a.prototype.setAttr=function(e,t,i){return i=i||null,e&&void 0!==t&&this.el.setAttributeNS(i,e,t),this},a.prototype.remAttr=function(e,t){return t=t||null,e&&this.el.removeAttributeNS(t,e),this},a.prototype.setRef=function(e){return this.setAttr("href",e,"http://www.w3.org/1999/xlink")},a.prototype.remRef=function(){return this.remAttr("href","http://www.w3.org/1999/xlink")},a.prototype.setClass=function(e){return e=e||"",this.setAttr("class",e)},a.prototype.addClass=function(e){return this.el.classList.add(e),this},a.prototype.remClass=function(e){return this.el.classList.remove(e),this},a.prototype.hasClass=function(e){return this.el.classList.contains(e)},a.prototype.toggleClass=function(e){return this.el.classList.toggle(e),this},a.prototype.getStyle=function(){return this.getAttr("style")},a.prototype.setStyle=function(e){return this.setAttr("style",e)},a.prototype.style=function(e,t){return this.el.style[e]=t,this},a.prototype.setId=function(e){return this.setAttr("id",this.getLocalId(e))},a.prototype.getLocalId=function(e){if(e){var t=this.getCanvas();return t?t.getLocalId(e):e}},a.prototype.getElementById=function(e){if(e){var t=this.getCanvas();return t?t.getElementById(e):void 0}},a.prototype.localRef=function(e){return"#"+this.getLocalId(e)},a.prototype.localUrl=function(e){return"url("+this.localRef(e)+")"},a.prototype.setTransform=function(e){return this.setAttr("transform",e)},a.prototype.setTitle=function(e){for(var t=this.el;t.hasChildNodes();)t.removeChild(t.lastChild);var i=document.createElementNS(s,"title");i.textContent=e,t.appendChild(i)},a.prototype.getCanvas=function(){var e=this.el.ownerSVGElement;if(e)return e.owner},a.prototype.getViewport=function(){var e=this.el.viewportElement;if(e)return e.owner},a.prototype.getParent=function(){var e=this.el.parentNode;if(e)return e.owner},a.prototype.createAnimation=function(e,t){var i=new l(e);return this.el.appendChild(i.el),i.setId(t),i},a.prototype.setFilter=function(e){return this.setAttr("filter",this.localUrl(e)),this},a.prototype.remFilter=function(e){return this.remAttr("filter"),this},a.prototype.getBoundingRect=function(){var e;try{e=this.el.getBBox()}catch(t){e=new DOMRect(0,0,0,0)}return e},a.prototype.remove=function(){var e=this.el.parentNode;return e&&e.removeChild(this.el),this},a.prototype.release=function(){return delete this.el.owner,this},a.prototype.front=function(){var e=this.getParent();return e&&e.toFront(this),this},a.prototype.back=function(){var e=this.getParent();return e&&e.toBack(this),this},a.prototype.before=function(e){var t=this.getParent();return t&&t.beforeElement(this,e),this},a.prototype.after=function(e){var t=this.getParent();return t&&t.afterElement(this,e),this},a.prototype.on=function(e,t,i){return void 0===i&&(i=!1),this.el.addEventListener(e,t,i),this},a.prototype.off=function(e,t,i){return void 0===i&&(i=!1),this.el.removeEventListener(e,t,i),this},a.prototype.createTransform=function(){var e=this.el.ownerSVGElement,t=this.el.scaleIndependentXForm=e.createSVGTransform();return this.el.transform.baseVal.clear(),this.el.transform.baseVal.appendItem(t),t},l.prototype=Object.create(a.prototype),l.prototype.setPath=function(e){var t=new a("mpath");return this.el.appendChild(t.el),t.setRef(this.localRef(e)),this},c.prototype=Object.create(a.prototype),c.prototype.addElement=function(e){var t=new a(e);return this.el.appendChild(t.el),t},d.prototype=Object.create(a.prototype),d.prototype.addStop=function(e,t,i){var o=new a("stop");return this.el.appendChild(o.el),o.setAttr("offset",e),o.setAttr("stop-color",t),i&&o.setAttr("stop-opacity",i),this},d.prototype.addStopClass=function(e,t){var i=new a("stop");return this.el.appendChild(i.el),i.setAttr("offset",e),i.setAttr("class",t),this},d.prototype.setTransform=function(e){return this.setAttr("gradientTransform",e)},d.prototype.useAbsoluteCoords=function(){return this.setAttr("gradientUnits","userSpaceOnUse")},d.prototype.clear=function(){return n.default.removeAllChildren(this.el),this},p.prototype=Object.create(d.prototype),p.prototype.setX1=function(e){return this.setAttr("x1",e)},p.prototype.setY1=function(e){return this.setAttr("y1",e)},p.prototype.setX2=function(e){return this.setAttr("x2",e)},p.prototype.setY2=function(e){return this.setAttr("y2",e)},p.prototype.setTopBottom=function(){return this.setX1("0%").setX2("0%").setY1("0%").setY2("100%")},p.prototype.setBottomTop=function(){return this.setX1("0%").setX2("0%").setY1("100%").setY2("0%")},p.prototype.setLeftRight=function(){return this.setX1("0%").setX2("100%").setY1("0%").setY2("0%")},p.prototype.setRightLeft=function(){return this.setX1("100%").setX2("0%").setY1("0%").setY2("0%")},u.prototype=Object.create(d.prototype),u.prototype.setCX=function(e){return this.setAttr("cx",e)},u.prototype.setCY=function(e){return this.setAttr("cy",e)},u.prototype.setR=function(e){return this.setAttr("r",e)},u.prototype.setFX=function(e){return this.setAttr("fx",e)},u.prototype.setFY=function(e){return this.setAttr("fy",e)},h.prototype=Object.create(a.prototype),h.prototype.setD=function(){return this.setAttr("d",this.segs.join(" "))},h.prototype.moveToAbs=function(e,t){return this.segs.push("M "+e+" "+t),this},h.prototype.moveToRel=function(e,t){return this.segs.push("m "+e+" "+t),this},h.prototype.lineToAbs=function(e,t){return this.segs.push("L "+e+" "+t),this},h.prototype.lineToRel=function(e,t){return this.segs.push("l "+e+" "+t),this},h.prototype.curveToCubicAbs=function(e,t,i,o,n,s){return this.segs.push("C "+[].join.call(arguments," ")),this},h.prototype.curveToCubicRel=function(e,t,i,o,n,s){return this.segs.push("c "+[].join.call(arguments," ")),this},h.prototype.curveToQuadraticAbs=function(e,t,i,o){return this.segs.push("Q "+[].join.call(arguments," ")),this},h.prototype.curveToQuadraticRel=function(e,t,i,o){return this.segs.push("q "+[].join.call(arguments," ")),this},h.prototype.arcAbs=function(e,t,i,o,n,s,r){return this.segs.push("A "+[].join.call(arguments," ")),this},h.prototype.arcRel=function(e,t,i,o,n,s,r){return this.segs.push("a "+[].join.call(arguments," ")),this},h.prototype.lineToHorizontalAbs=function(e){return this.segs.push("H "+e),this},h.prototype.lineToHorizontalRel=function(e){return this.segs.push("h "+e),this},h.prototype.lineToVerticalAbs=function(e){return this.segs.push("V "+e),this},h.prototype.lineToVerticalRel=function(e){return this.segs.push("v "+e),this},h.prototype.curveToCubicSmoothAbs=function(e,t,i,o){return this.segs.push("S "+[].join.call(arguments," ")),this},h.prototype.curveToCubicSmoothRel=function(e,t,i,o){return this.segs.push("s "+[].join.call(arguments," ")),this},h.prototype.curveToQuadraticSmoothAbs=function(e,t){return this.segs.push("T "+e+" "+t),this},h.prototype.curveToQuadraticSmoothRel=function(e,t){return this.segs.push("t "+e+" "+t),this},h.prototype.closePath=function(){return this.segs.push("Z"),this},h.prototype.getTotalLength=function(){return this.el.getTotalLength()},h.prototype.getPointAtLength=function(e){return this.el.getPointAtLength(e)},h.prototype.getSegmentsCount=function(){return this.segs.length},h.prototype.gatSegment=function(e){return this.segs[e]},h.prototype.clearSegments=function(){return this.segs.length=0,this},h.prototype.animateDrawing=function(e,t,i){t=t||"linear";var o=this.getTotalLength();return this.el.style.transition="none",this.el.style.strokeDasharray=[o,o].join(" "),this.el.style.strokeDashoffset=o,i&&(this.el.style.stroke=i),this.el.getBoundingClientRect(),this.el.style.transition="stroke-dashoffset "+e+" "+t,this.el.style.strokeDashoffset="0",this},m.prototype=Object.create(a.prototype),m.prototype.setX=function(e){return this.setAttr("x",e)},m.prototype.setY=function(e){return this.setAttr("y",e)},m.prototype.setWidth=function(e){return this.setAttr("width",e)},m.prototype.setHeight=function(e){return this.setAttr("height",e)},m.prototype.getX=function(){return this.getAttr("x")},m.prototype.getY=function(){return this.getAttr("y")},m.prototype.getWidth=function(){return this.getAttr("width")},m.prototype.getHeight=function(){return this.getAttr("height")},f.prototype=Object.create(a.prototype),f.prototype.setX=function(e){return this.setAttr("x",e)},f.prototype.setY=function(e){return this.setAttr("y",e)},f.prototype.setWidth=function(e){return this.setAttr("width",e)},f.prototype.setHeight=function(e){return this.setAttr("height",e)},v.prototype=Object.create(a.prototype),v.prototype.setX1=function(e){return this.setAttr("x1",e)},v.prototype.setY1=function(e){return this.setAttr("y1",e)},v.prototype.setX2=function(e){return this.setAttr("x2",e)},v.prototype.setY2=function(e){return this.setAttr("y2",e)},g.prototype=Object.create(a.prototype),g.prototype.setCX=function(e){return this.setAttr("cx",e)},g.prototype.setCY=function(e){return this.setAttr("cy",e)},g.prototype.setR=function(e){return this.setAttr("r",e)},g.prototype.getCX=function(){return this.getAttr("cx")},g.prototype.getCY=function(){return this.getAttr("cy")},g.prototype.getR=function(){return this.getAttr("r")},_.prototype=Object.create(a.prototype),_.prototype.setCX=function(e){return this.setAttr("cx",e)},_.prototype.setCY=function(e){return this.setAttr("cy",e)},_.prototype.setRX=function(e){return this.setAttr("rx",e)},_.prototype.setRY=function(e){return this.setAttr("ry",e)},_.prototype.getCX=function(){return this.getAttr("cx")},_.prototype.getCY=function(){return this.getAttr("cy")},_.prototype.getRX=function(){return this.getAttr("rx")},_.prototype.getRY=function(){return this.getAttr("ry")},w.prototype=Object.create(a.prototype),w.prototype.setPoints=function(e){return e.length?this.setAttr("points",y(e)):this},w.prototype.getPoints=function(){return b(this.getAttr("points"))},x.prototype=Object.create(a.prototype),x.prototype.setPoints=function(e){return e.length?this.setAttr("points",y(e)):this},x.prototype.getPoints=function(){return b(this.getAttr("points"))},C.prototype=Object.create(a.prototype),C.prototype.setX=function(e){return this.setAttr("x",e)},C.prototype.setY=function(e){return this.setAttr("y",e)},C.prototype.setDX=function(e){return this.setAttr("dx",e)},C.prototype.setDY=function(e){return this.setAttr("dy",e)},C.prototype.setText=function(e){return this.textNode?this.textNode.data=e:(this.textNode=document.createTextNode(e),this.el.appendChild(this.textNode)),this},C.prototype.setPath=function(e,t){this.el.removeChild(this.textNode),this.textPath=new a("textPath"),this.el.appendChild(this.textPath.el),this.textPath.el.appendChild(this.textNode),this.textPath.setRef(this.localRef(e)).setAttr("startOffset",t)},C.prototype.addSpan=function(e){var t=new C(e,"tspan");return this.el.appendChild(t.el),t},C.prototype.getSpan=function(e){var t=this.el.children[e];if(t)return t.owner},A.prototype=Object.create(a.prototype),A.prototype.setX=function(e){return this.setAttr("x",e)},A.prototype.setY=function(e){return this.setAttr("y",e)},A.prototype.setWidth=function(e){return this.setAttr("width",e)},A.prototype.setHeight=function(e){return this.setAttr("height",e)},A.prototype.getX=function(){return this.getAttr("x")},A.prototype.getY=function(){return this.getAttr("y")},A.prototype.getWidth=function(){return this.getAttr("width")},A.prototype.getHeight=function(){return this.getAttr("height")},A.prototype.appendChild=function(e){return e&&this.el.appendChild(e),this},S.prototype=Object.create(a.prototype),S.prototype.setX=function(e){return this.setAttr("x",e)},S.prototype.setY=function(e){return this.setAttr("y",e)},S.prototype.setWidth=function(e){return this.setAttr("width",e)},S.prototype.setHeight=function(e){return this.setAttr("height",e)},S.prototype.getX=function(){return this.getAttr("x")},S.prototype.getY=function(){return this.getAttr("y")},S.prototype.getWidth=function(){return this.getAttr("width")},S.prototype.getHeight=function(){return this.getAttr("height")},T.prototype=Object.create(a.prototype),T.prototype.appendChild=function(e){return e&&this.el.appendChild(e.el?e.el:e),this},T.prototype.createChild=function(e,t,i,o){var n=new i(o);return t&&this.el.firstChild?this.el.insertBefore(n.el,this.el.firstChild):this.el.appendChild(n.el),n.setId(e),n},T.prototype.toFront=function(e){var t=this.el.removeChild(e.el);return t&&this.el.appendChild(t),this},T.prototype.toBack=function(e){var t=this.el.removeChild(e.el);return t&&this.el.insertBefore(t,this.el.firstChild),this},T.prototype.beforeElement=function(e,t){if(!t)return this.toBack(e);var i=this.el.removeChild(e.el);return i&&t.el&&this.el.insertBefore(i,t.el),this},T.prototype.afterElement=function(e,t){if(!t)return this.toFront(e);var i=this.el.removeChild(e.el);return i&&t.el&&(this.el.lastElementChild===t.el?this.el.appendChild(i):this.el.insertBefore(i,t.el.nextSibling)),this},T.prototype.getChildrenCount=function(){return this.el.children.length},T.prototype.getChild=function(e){return this.el.children[e]},T.prototype.forEach=function(e){return[].forEach.call(this.el.children,e),this},T.prototype.createPath=function(e,t){return this.createChild(e,t,h)},T.prototype.createRect=function(e,t){return this.createChild(e,t,m)},T.prototype.createImage=function(e,t){return this.createChild(e,t,f)},T.prototype.createLine=function(e,t){return this.createChild(e,t,v)},T.prototype.createCircle=function(e,t){return this.createChild(e,t,g)},T.prototype.createEllipse=function(e,t){return this.createChild(e,t,_)},T.prototype.createPolyline=function(e,t){return this.createChild(e,t,w)},T.prototype.createPolygon=function(e,t){return this.createChild(e,t,x)},T.prototype.createText=function(e,t,i){return this.createChild(t,i,C,e)},T.prototype.createForeignObject=function(e,t){return this.createChild(e,t,A)},T.prototype.createUse=function(e,t){return this.createChild(e,t,S)},T.prototype.createG=function(e,t){return this.createChild(e,t,T,"g")},T.prototype.createDefs=function(e,t){return this.createChild(e,t,I)},T.prototype.getDefs=function(e,t){if(e){var i=this.getElementById(e);return i||(i=this.createDefs(e,t)),i}},T.prototype.createClipPath=function(e,t){return this.createChild(e,t,P)},T.prototype.createSymbol=function(e,t){return this.createChild(e,t,E,"symbol")},T.prototype.createCanvas=function(e,t){return this.createChild(e,t,R)},T.prototype.addRect=function(e,t,i,o,n,s,r){return this.createRect(s,r).setX(e).setY(t).setWidth(i).setHeight(o).setClass(n)},T.prototype.addLine=function(e,t,i,o,n,s,r){return this.createLine(s,r).setX1(e).setY1(t).setX2(i).setY2(o).setClass(n)},T.prototype.addText=function(e,t,i,o,n,s){return this.createText(i,n,s).setX(e).setY(t).setClass(o)},T.prototype.clear=function(){return n.default.removeAllChildren(this.el),this},I.prototype=Object.create(T.prototype),I.prototype.createLinearGradient=function(e,t){return this.createChild(e,t,p)},I.prototype.createRadialGradient=function(e,t){return this.createChild(e,t,u)},I.prototype.createFilter=function(e,t){return this.createChild(e,t,c)},I.prototype.createMarker=function(e,t){return this.createChild(e,t,L)},I.prototype.createPattern=function(e,t){return this.createChild(e,t,M)},P.prototype=Object.create(T.prototype),M.prototype=Object.create(T.prototype),M.prototype.setX=function(e){return this.setAttr("x",e)},M.prototype.setY=function(e){return this.setAttr("y",e)},M.prototype.setWidth=function(e){return this.setAttr("width",e)},M.prototype.setHeight=function(e){return this.setAttr("height",e)},M.prototype.useLocalCoords=function(){return this.setAttr("patternUnits","userSpaceOnUse")},M.prototype.useParentContentCoords=function(){return this.setAttr("patternContentUnits","objectBoundingBox")},E.prototype=Object.create(T.prototype),E.prototype.setViewSize=function(e,t,i,o,n){var s=[e,t,i,o].join(" ");return this.setAttr("viewBox",s),n=n||"none",this.setAttr("preserveAspectRatio",n),this},E.prototype.getViewSize=function(){var e=this.getAttr("viewBox");if(e){var t=e.split(" ");return{minX:parseFloat(t[0]),minY:parseFloat(t[1]),width:parseFloat(t[2]),height:parseFloat(t[3]),par:this.getAttr("preserveAspectRatio")}}},L.prototype=Object.create(E.prototype),L.prototype.setMarkerUnits=function(e){return this.setAttr("markerUnits",e)},L.prototype.setRefX=function(e){return this.setAttr("refX",e)},L.prototype.setRefY=function(e){return this.setAttr("refY",e)},L.prototype.setMarkerWidth=function(e){return this.setAttr("markerWidth",e)},L.prototype.setMarkerHeight=function(e){return this.setAttr("markerHeight",e)},L.prototype.setOrient=function(e){return this.setAttr("orient",e)},R.prototype=Object.create(E.prototype),R.prototype.getCanvas=function(){return this},R.prototype.getElementById=function(e){var t=document.getElementById(this.getLocalId(e));if(t)return t.owner},R.prototype.getLocalId=function(e){return this.id?this.id+e:e},R.prototype.Screen2SVG=function(e,t,i){i=i||this;var o=this.el.createSVGPoint();o.x=e,o.y=t;var n=D.call(this,i.el,"_screenCTM","getScreenCTM");return n?o.matrixTransform(n.inverse()):o},R.prototype.Element2SVG=function(e,t,i){i=i||this;var o=this.el.createSVGPoint();o.x=e,o.y=t;var n=D.call(this,i.el,"_CTM","getCTM");return n?o.matrixTransform(n.inverse()):o},R.prototype.SVG2Screen=function(e,t,i){i=i||this;var o=this.el.createSVGPoint();o.x=e,o.y=t;var n=D.call(this,i.el,"_screenCTM","getScreenCTM");return n?o.matrixTransform(n):o},R.prototype.SVG2Element=function(e,t,i){i=i||this;var o=this.el.createSVGPoint();o.x=e,o.y=t;var n=D.call(this,i.el,"_CTM","getCTM");return n?o.matrixTransform(n):o},R.prototype.Screen2SVGX=function(e,t){return this.Screen2SVG(e,0,t).x},R.prototype.Element2SVGX=function(e,t){return this.Element2SVG(e,0,t).x},R.prototype.SVG2ScreenX=function(e,t){return this.SVG2Screen(e,0,t).x},R.prototype.SVG2ElementX=function(e,t){return this.SVG2Element(e,0,t).x},R.prototype.Screen2SVGY=function(e,t){return this.Screen2SVG(0,e,t).y},R.prototype.Element2SVGY=function(e,t){return this.Element2SVG(0,e,t).y},R.prototype.SVG2ScreenY=function(e,t){return this.SVG2Screen(0,e,t).y},R.prototype.SVG2ElementY=function(e,t){return this.SVG2Element(0,e,t).y},R.prototype.getTextHeight=function(e){return this.getTextSize("TEST",e).height},R.prototype.getTextSize=function(e,t){e=e||"",t=t||{};var i=this.createText(e);void 0!==t.fontFamily&&i.setAttr("font-family",t.fontFamily),void 0!==t.fontSize&&i.setAttr("font-size",t.fontSize),void 0!==t.className&&i.setClass(t.className);var o=i.getBoundingRect();return i.remove(),o},R.prototype.createTextBackground=function(e,t){if(e)return t||(t=this.getDefs(e+"Defs")),t.createFilter(e).setAttr("x","0").setAttr("y","0").setAttr("width","1").setAttr("height","1").addElement("feFlood").setAttr("flood-color","white").getParent().addElement("feComposite").setAttr("in","SourceGraphic").getParent()};const k={create:function(e,t){return e=e||"idvc2_canvas",new R(t).setClass(e)},createItem:function(e){return new a(e)},createContainer:function(e){return new T(e)},createScalableContainer:function(e){return new E(e)}}},24137:e=>{e.exports=' <h4>Enable the use of approximate division instructions</h4> <div class="text"> <div class="promo">Static analysis presumes the loop may benefit from using approximate calculations. Independent dividors will be pre-calculated and replaced with multiplicators. To fix: Fine-tune your usage of the following compiler option:</div> <br/> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> <th> Comment </th> </tr> </thead> <tbody> <tr> <td>/Qprec-div-</td> <td>-no-prec-div</td> <td><p><samp class="codeph">-no-prec-div</samp> enables the use of approximate devision optimizations.</p></td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/prec-div-qprec-div.html">prec-div, Qprec-div</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html">Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/floating-point-operations.html">Floating-Point Operations</a> and <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/floating-point-options.html">Floating-Point Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html"> Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},24429:e=>{e.exports=' <h4>Target the AVX-512 Exponential and Reciprocal Instructions ISA</h4> <div class="text"> <div class="promo"> Static analysis presumes the loop may benefit from AVX-512 Exponential and Reciprocal (AVX-512ER) instructions currently supported only on Intel&reg; Xeon Phi&trade; processors, but these instructions were not used. To fix: Use one of the following compiler options: <ul> <li> <samp class="codeph">xMIC-AVX512</samp> - tells the compiler which processor features to target, including instructions sets and optimizations it may generate, including AVX-512ER. </li> <li> <samp class="codeph">axMIC-AVX512</samp> - tells the compiler to generate multiple, feature-specific, auto-dispatch code for Intel processors if there is a performance benefit. </li> </ul> </div> <table> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> <tr> <td>/QxMIC-AVX512 or /QaxMIC-AVX512</td> <td>-xMIC-AVX512 or -axMIC-AVX512</td> </tr> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-2D881A91-C5D7-4DDD-84B1-FB9D0D597F4D.html">ax, Qax</a>; <a href="docs:Fortran/17/index.htm#GUID-09734487-1819-4C1E-B314-2497F2B64C45.html">x, Qx</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/overview.html">Intel&reg; Fortran Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/architecture-and-technology/avx-512-solution-brief.html">Compiling for the Intel&reg; Xeon Phi&trade; processor x200 and the Intel&reg; AVX-512 ISA</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},24482:e=>{e.exports=' <h4>Enable inline expansion</h4> <div class="text"> <p class="promo"> Inlining of user-defined functions is disabled by compiler option. To fix: When using the <samp class="codeph">Ob</samp> or <samp class="codeph">inline-level</samp> compiler option to control inline expansion, replace the <samp class="codeph">0</samp> argument with the <samp class="codeph">1</samp> argument to enable inlining when an <samp class="codeph">inline</samp> keyword or attribute is specified or the <samp class="codeph">2</samp> argument to enable inlining of any function at compiler discretion. </p> <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th>Windows* OS</th> <th>Linux* OS</th> </tr> </thead> <tbody> <tr> <td> /Ob1 or /Ob2 </td> <td> -inline-level=1 or -inline-level=2 </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-53B736C9-3A0A-4CC0-931B-1A1EDF7BF668.htm">inline-level, Ob</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},24674:e=>{e.exports=' <h4>Target the AVX-512 Exponential and Reciprocal Instructions ISA </h4> <div class="text"> <div class="promo"> Static analysis presumes the loop may benefit from AVX-512 Exponential and Reciprocal (AVX-512ER) instructions currently supported only on Intel&reg; Xeon Phi&trade; processors, but these instructions were not used. To fix: Use one of the following compiler options: <ul> <li> <samp class="codeph">xMIC-AVX512</samp> - tells the compiler which processor features to target, including instructions sets and optimizations it may generate, including AVX-512ER. </li> <li> <samp class="codeph">axMIC-AVX512</samp> - tells the compiler to generate multiple, feature-specific, auto-dispatch code for Intel processors if there is a performance benefit. </li> </ul> </div> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td>/QxMIC-AVX512 or /QaxMIC-AVX512</td> <td>-xMIC-AVX512 or -axMIC-AVX512</td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-2D881A91-C5D7-4DDD-84B1-FB9D0D597F4D.html">ax, Qax</a>; <a href="docs:C++/17/index.htm#GUID-09734487-1819-4C1E-B314-2497F2B64C45.html">x, Qx</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html"> Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/architecture-and-technology/avx-512-solution-brief.html">Compiling for the Intel&reg; Xeon Phi&trade; processor x200 and the Intel&reg; AVX-512 ISA</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},24675:e=>{e.exports={ImageType:{itInfo:0,itRemark:1,itWarning:2,itError:3,itInfoGrey:4,itRemarkGrey:5,itWarningGrey:6,itErrorGrey:7,_names:["itInfo","itRemark","itWarning","itError","itInfoGrey","itRemarkGrey","itWarningGrey","itErrorGrey"],id2name:{0:"itInfo",1:"itRemark",2:"itWarning",3:"itError",4:"itInfoGrey",5:"itRemarkGrey",6:"itWarningGrey",7:"itErrorGrey"}},ButtonType:{btNone:0,btOk:1,btYes:2,btNo:4,btContinue:8,btRetry:16,btCancel:32,btClose:64,btCustom:128,_names:["btNone","btOk","btYes","btNo","btContinue","btRetry","btCancel","btClose","btCustom"],id2name:{0:"btNone",1:"btOk",2:"btYes",4:"btNo",8:"btContinue",16:"btRetry",32:"btCancel",64:"btClose",128:"btCustom"}},CheckBoxType:{btNone:0,btDoNotShowAnymore:1,btCustom:"IButtonsDecoration::btCustom",_names:["btNone","btDoNotShowAnymore"],id2name:{0:"btNone",1:"btDoNotShowAnymore"}},BulletType:{btNone:0,btListItem:1,btWarning:2,btError:3,btInfo:4,_names:["btNone","btListItem","btWarning","btError","btInfo"],id2name:{0:"btNone",1:"btListItem",2:"btWarning",3:"btError",4:"btInfo"}},Severity:{sInfo:1,sWarning:2,sError:4,sFatalError:8,sVerbose:16,sAppStdout:32,sAppStderr:64,sUser:128,sNoAppOutput:256,_names:["sInfo","sWarning","sError","sFatalError","sVerbose","sAppStdout","sAppStderr","sUser","sNoAppOutput"],id2name:{1:"sInfo",2:"sWarning",4:"sError",8:"sFatalError",16:"sVerbose",32:"sAppStdout",64:"sAppStderr",128:"sUser",256:"sNoAppOutput"}},ScrollType:{stHorz:1,stVert:2,_names:["stHorz","stVert"],id2name:{1:"stHorz",2:"stVert"}},Mode:{mLog:0,mTooltipHorizontal:1,_names:["mLog","mTooltipHorizontal"],id2name:{0:"mLog",1:"mTooltipHorizontal"}}}},24808:e=>{e.exports=' <h4>Proven (real) dependency present</h4> <div class="essential"> The compiler assumed there is an anti-dependency (Write after read - WAR) or true dependency (Read after write - RAW) in the loop. Improve performance by investigating the assumption and handling accordingly. </div>'},24887:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"func_summary"}},[t("div",{staticClass:"content"},[t("div",{attrs:{name:"params"}},[e._v("Vector (SIMD-enabled) Function")]),e._v(" "),e._m(0),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.compact,expression:"!compact"}],staticClass:"expansion"},[t("div",{attrs:{name:"params"}},[e._v("Function Parameters")]),e._v(" "),t("ul",{attrs:{id:"func_params"}})])])])};o._withStripped=!0,i(36094),i(69212),i(45361);const n={vl:"4",isa:"AVX",maskType:"Non masked",parameters:[{stride:"1",strideType:"Constant Stride",types:["Linear","Linear ref"]},{types:["Vector"]},{alignment:"1",types:["Uniform","Aligned"]}]},s={computed:{compact(){return this.$parent.compact}},mounted(){const{$el:e}=this;qs("#func_vl_value",e).innerHTML=n.vl,qs("#func_isa_value",e).innerHTML=n.isa,n.maskType?(qs("#mask_type_value",e).innerHTML=n.maskType,qs("#mask_type_name",e).parentElement.Visible(!0)):qs("#mask_type_name",e).parentElement.Visible(!1),qs("#params_count_value",e).innerHTML=n.parameters.length;const t=qs("#func_params",e);for(;null!=t.firstChild;)t.removeChild(t.firstChild);if(0==n.parameters.length){const e=document.createElement("li");e.setAttribute("name","none"),e.innerHTML="None",t.appendChild(e)}n.parameters.forEach((function(e){const i=document.createElement("li");i.innerHTML="No Info";const o=[];function n(e,t){t&&o.push(e?e+": "+t:t)}e.stride&&e.strideType&&n(e.strideType,e.stride),n("Alignment",e.alignment),e.types.forEach((function(e){n(0,e)})),o.length>0&&(i.innerHTML=o.join(", ")),t.appendChild(i)}))}},r=(0,i(98822).A)(s,o,[function(){var e=this,t=e._self._c;return t("table",[t("tr",{attrs:{valign:"bottom"}},[t("td",{attrs:{align:"center"}},[t("div",{attrs:{id:"func_isa_value",name:"title","data-tooltip":"Target Processor Instruction Set"}}),e._v(" "),t("div",{attrs:{id:"func_isa_name",name:"name"}},[e._v("Instruction Set")])]),e._v(" "),t("td",{attrs:{align:"center"}},[t("div",{attrs:{id:"mask_type_value",name:"title"}}),e._v(" "),t("div",{attrs:{id:"mask_type_name",name:"name"}},[e._v("Mask Type")])]),e._v(" "),t("td",{attrs:{align:"center"}},[t("div",{attrs:{id:"func_vl_value",name:"title"}}),e._v(" "),t("div",{attrs:{id:"func_vl_name",name:"name"}},[e._v("Vector Length")])]),e._v(" "),t("td",{attrs:{align:"center"}},[t("div",{attrs:{id:"params_count_value",name:"title","data-tooltip":"Number of Parameters"}}),e._v(" "),t("div",{attrs:{id:"params_count_name",name:"name"}},[e._v("Parameters")])])])])}],!1,null,null,null).exports},24911:e=>{e.exports=' <h4>This loop is mostly memory bound but may also be compute bound</h4> <div class="text"> <div class="promo"> <span id="roofline_guidance"> <span id="below_dram"> The performance of the loop is bounded by the DRAM bandwidth.<br/> </span> <span id="below_shared_cache"> The performance of the loop is bounded by the bandwidth of the shared cache and DRAM.<br/> </span> <span id="below_private_cache"> The performance of the loop is bounded by the private cache bandwidth. The bandwidth of the shared cache and DRAM may degrade perfomance.<br/> </span> <span id="bounded_by_l1"> The performance of the loop is bounded by the L1 bandwidth.<br/> </span> <span id="bounded_by_l2"> The performance of the loop is bounded by the L2 bandwidth.<br/> </span> <span id="bounded_by_l3"> The performance of the loop is bounded by the L3 bandwidth.<br/> </span> <span id="bounded_by_l4"> The performance of the loop is bounded by the L4 bandwidth.<br/> </span> <span id="bounded_by_dram"> The performance of the loop is bounded by the DRAM bandwidth.<br/> </span> <span id="bounded_by_mcdram"> The performance of the loop is bounded by the MCDRAM bandwidth.<br/> </span> To improve performance: Improve caching efficiency<span id="inefficient_map"><span id="more_ineff_map_info"> and eliminate inefficient memory access patterns</span></span>. <span id="is_scalar"> The loop is also scalar. To fix: Vectorize the loop. </span> <span id="is_vectorized"> <span id="scalar_mem_instructions"> Scalar memory instructions might degrade application performance. </span> </span> </span> </div> <p class="expander">Read More</p> <ul class="expansion"> <span id="bad_traffic_impact"> <li> Data transferred between L1 and L2 cache levels (in cache lines) exceed CARM traffic between CPU registers and Memory subsystem (in bytes).<br/>This can be due to inefficient memory access pattern and cache line utilization. In this case, you only access a single element from a full cache line stored in L1.<br/> <img id="bad_traffic_img"/> </li> <li> <a href="docs:../help/index.htm#GUID-62A94516-242C-4B0C-9B4F-2ED08F61B146.html">Memory-Level Roofline</a> </li> </span> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div> '},24953:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(71839),n=i(2305),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"4ce6c70d",null).exports},24975:()=>{function e(e,t){if(!e)return;const i=e.querySelector("#no_dependency_disclaimer");i&&i.Visible(t.no_dependency_disclaimer)}window.rec_sqrtdiv_enforce_vec_c=e,window.rec_sqrtdiv_enforce_vec_f=e},25042:()=>{function e(e,t){if(!e)return;const i=e.querySelector("#function_names");if(i){const e=/%function_names%/g,o=t.user_functions&&t.user_functions.length>0;if(i.Visible(o),!o)return;const n=t.user_functions;let s='<code class="hljs-title">'+n[0]+"()</code>";if(n.length>1){s='<ul style="padding-left: 1.5rem; overflow-x:auto;">';for(let e=0,t=n.length;e<t;++e)s+='<li><code class="hljs-title">'+n[e]+"()</code></li>";s+="</ul>"}i.innerHTML=i.innerHTML.replace(e,s)}}window.rec_serialized_user_function_try_simd_c=e,window.rec_serialized_user_function_try_simd_f=e,window.rec_user_function_prevent_vectorization_try_simd_c=e,window.rec_user_function_prevent_vectorization_try_simd_f=e,window.rec_user_function_prevent_vectorization_try_simd_f1=e},25095:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(29794),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},25215:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"content"},e._l(e.data,(function(i,o){return t("bar-metric",{key:i.name,attrs:{name:i.name,values:[i.cpu,i.delta],colors:[e.getColor(o),"#C4D600"]}})})),1)};o._withStripped=!0;var n=i(75337);const s=["#E57373","#64B5F6"],r={computed:{...(0,n.mapGetters)("gpu",["getImpactsSummaryData"]),data(){return this.getImpactsSummaryData.slice(0,2)}},methods:{getColor(e){const t=Math.floor(e/s.length);return s[e-t*s.length]}}},a=(0,i(98822).A)(r,o,[],!1,null,"78d048a0",null).exports},25276:e=>{e.exports=' <h4>Reduce the number/size of arrays promoted to the private memory</h4> <div class="text promo"> Usually, private variables are promoted to <span data-glossary-id="GRF">GRF</span>. If an array is big, a compiler often promotes the variables to the additional region of the private memory. <br><br> <ul> <li><b>Consider using static indexing.</b> <p> Static indexing means that each access is performed using the index known at the moment of compilation (static constant). The compiler can map statically indexed private arrays to registers. Dynamically indexed private arrays are often promoted to the private memory. </p><p class="expander">Examples of a <b>static/dynamic</b> indexing:</p> <pre class="essential"><code class="fortran">\ndata(1)     = 0 !static indexing\ndata(i + 1) = 0 !dynamic indexing\n                </code></pre> <p></p> </li> <br> <li><b>Consider reducing array size.</b> <p> The total GRF size is %grf_size% bytes per thread. The current <span data-glossary-id="SIMD_gpu">SIMD</span> width is %gpu_current_row_simd_width%. The available size of GRF per work item calculated as <b>GRF/SIMD width</b> is %grf_per_wi% bytes. </p> <p> Reduce the array size to fit it into the available GRF space per work item. </p> </li> </ul> </div> '},25405:e=>{"use strict";e.exports=JSON.parse('{"dram":"#463a84","gti":"#463a84","gtigpu":"#463a84","hbm":"#463a84","hbmgpu":"#463a84","hbm_bw":"#463a84","dram_bw":"#463a84","edram_bw":"#463a84","gti_bw":"#463a84","gddr6_bw":"#463a84","l1":"#a9a9a9","l1_bw":"#a9a9a9","l2":"#b4810c","l2_bw":"#b4810c","l3":"#5d9696","l3_bw":"#5d9696","l4":"#00ac56","l4_bw":"#00ac56","llc_bw":"#00ac56","slm":"#951d1d","slm_bw":"#951d1d","mpi":"#e57b7b","stalled":"#f38574","cpuTime":"#fe916c","atomic":"#ff9e64","cpuTimeVectorizedLoops":"#ffae5b","write":"#ffbe53","memory":"#ffd04d","free-yellow":"#ffe24b","all_taxes":"#dca56f","llc":"#e7b870","load":"#edcd73","free-brown":"#efe379","time_after_acc":"#64d3a4","launch_tax":"#71d79e","gpu_time":"#7eda97","read":"#8bdd91","compute":"#15aeae","active":"#a8e284","free-green":"#b7e47e","dependency":"#c37eda","trip_count":"#d286d7","data_transfer":"#e89ad2","dt_tax":"#f0a5d2","config_tax":"#f7b1d3","invoke_tax":"#fcbdd5","free-purple":"#ffc9d9","cpuTimeScalarLoops":"#4d9ad2","cpu_time":"#46a9da","sum_latency":"#45b7df","idle":"#4cc5e2","code_tax":"#5bd3e3","cpu_time_acc":"#6ee0e4","non_offloaded":"#85ede3","free-blue":"#9df9e3","unknown":"#b6b6b6"}')},25443:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(19052),n=i(61105),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"3bee91c2",null).exports},25484:e=>{e.exports=' <h4>Target a specific processor type(s)</h4> <div class="text"> <p> <span class="promo">The default instruction set architecture (ISA) for SIMD-enabled functions is inefficient for your host processor because it could result in extra memory operations between registers. To fix: </span> Add one of the following to tell the compiler to generate an extended set of vector functions. </p> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> processor(cpuid) to #pragma omp declare simd </td> <td> processor(cpuid) to #pragma omp declare simd </td> </tr> <tr> <td> processor(cpuid) to _declspec(vector()) </td> <td> processor(cpuid) to _attribute_(vector()) </td> </tr> <tr> <td> /Qvecabi:cmdtarget Note: Vector variants are created for targets specified for targets specified by compiler options /Qx or /Qax </td> <td> -vecabi=cmdtarget Note: Vector variants are created for targets specified for targets specified by compiler options -x or -ax </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-E3890A58-38D5-4F4F-87A7-D9B70ED13180.html"> cpu_specific</a>; <a href="docs:C++/17/index.htm#GUID-90A7F490-941F-4C07-A88E-07BBA14AE6AF.html"> SIMD-Enabled Functions</a>; <a href="docs:C++/17/index.htm#GUID-0DCAAB47-773D-4308-93CC-A56ED90B1F51.html"> vecabi, Qvecabi</a>; <a href="docs:C++/17/index.htm#GUID-3EA554DE-BF98-435D-8C4E-2DED02170806.html"> vector</a>; <i>omp declare simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html"> OpenMP* Pragmas Summary</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},25733:e=>{e.exports=' <h4>Combine multiple instances of the code region</h4> <div class="text"> <div class="promo"> Modify the region so that it has more than one instance running in parallel. <ul><li> Refactor and merge iteration space of more than one code region instance. </li></ul> <b>Note:</b> This is only possible if there are no dependencies between iterations in the parent cycle. </div> </div> '},25757:e=>{e.exports=' <h4>Use a smaller vector length</h4> <div class="text"> <div class="promo"> The compiler chose a <span data-glossary-id="vector_length">vector length</span> of <span id="peel_remainder"> %vl% </span>, but the <span data-glossary-id="trip_count">trip count</span> might be smaller than the vector length. To fix: Specify a smaller vector length using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">#pragma omp simd simdlen</samp>. <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n// Specify vector length using\n#pragma omp simd simdlen(4)\nfor (int i = 1; i &lt; 100; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void f(int a[], int b[], int c[], int d[])\n{\n    // Specify vector length using\n    #pragma omp simd simdlen(4)\n    for (int i = 1; i &lt; 100; i++)\n    {\n        b[i] = a[i] + 1;\n        d[i] = c[i] + 1;\n    }\n}</code></pre> </div> In version 19.0 and higher of the Intel compiler, there is a new vector length clause that allows the compiler to choose the best vector length based on cost: <samp class="codeph">#pragma vector vectorlength(vl<sub>1</sub>, vl<sub>2</sub>, ..., vl<sub>n</sub>)</samp> where vl is an integer power of 2. <p class="expander">Example</p> <pre class="expansion"><code class="cpp">void f(int a[], int b[], int c[], int d[])\n{\n    // Specify list of vector lengths\n    #pragma vector vectorlength(2, 4, 16)\n    for (int i = 1; i &lt; 100; i++)\n    {\n        b[i] = a[i] + 1;\n        d[i] = c[i] + 1;\n    }\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <i>omp simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html">OpenMP* Pragmas Summary</a>, <a href="docs:C++/17/index.htm#GUID-2B528C72-29B4-4DBC-8B91-EE4D1A03A850.html">vector</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html"> Getting Started with Intel Compiler Pragmas and Directives </a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},26036:e=>{e.exports=' <h4>Vectorize serialized function(s) inside loop</h4> <div class="text"> <p class="promo"> <span id="function_names"> These user-defined function(s) are not vectorized or inlined by the compiler: %function_names% To fix: Do one of the following: </span> </p> <ul> <li> Enforce vectorization of the <span data-glossary-id="source_loop">source loop</span> by means of SIMD instructions and/or create a SIMD version of the function(s) using a <span data-glossary-id="directive">directive</span>: <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Target </th> <th> Directive </th> </tr> </thead> <tbody> <tr> <td> Source loop </td> <td> !$OMP SIMD </td> </tr> <tr> <td> Inner function definition or declaration </td> <td> !$OMP DECLARE SIMD </td> </tr> </tbody> </table> </li> <li> If using the <samp class="codeph">Ob</samp> or <samp class="codeph">inline-level</samp> compiler option to control inline expansion with the <samp class="codeph">1</samp> argument, use an <samp class="codeph">inline</samp> keyword to enable inlining or replace the <samp class="codeph">1</samp> argument with <samp class="codeph">2</samp> to enable inlining of any function at compiler discretion. </li> </ul> <span class="promo"> <p class="expander">Example</p> <pre class="essential"><code class="fortran">real function f (x)\n    !DIR$ OMP DECLARE SIMD\n    real, intent(in), value  :: x\n    f= x + 1\nend function f\n...</code></pre> <pre class="expansion"><code class="fortran">real function f (x)\n    !DIR$ OMP DECLARE SIMD\n    real, intent(in), value  :: x\n    f= x + 1\nend function f\n\n!DIR$ OMP SIMD\ndo k = 1, N\n    a(k) = f(k)\nenddo</code></pre> </span> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-A9B9396B-3984-4DAA-887E-F5493F12B255.htm">DECLARE SIMD</a>, <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.htm">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div> '},26157:e=>{e.exports=' <h4>Parallelize the loop with both threads and SIMD instructions</h4> <div class="text"> <div class="promo"> The loop is threaded and auto-vectorized; however, the <span data-glossary-id="trip_count">trip count</span> is not a multiple of <span data-glossary-id="vector_length">vector length</span>. To fix: Do all of the following: <ul> <li> Use the <samp class="codeph">#pragma omp parallel for simd</samp> directive to parallelize the loop with both threads and SIMD instructions. Specifically, this directive divides loop iterations into chunks (subsets) and distributes the chunks among threads, then chunk iterations execute concurrently using SIMD instructions. </li> <li> Add the <samp class="codeph">schedule(simd: [kind])</samp> modifier to the directive to guarantee the chunk size (number of iterations per chunk) is a multiple of <span data-glossary-id="vector_length">vector length</span>. </li> </ul> <p class="expander">Example (original code)</p> <pre class="essential"><code class="cpp">...\n#pragma omp parallel for schedule(static)\nfor (int i = 0; i &lt; n; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void f(int a[], int b[], int c[])\n{\n    #pragma omp parallel for schedule(static)\n    for (int i = 0; i &lt; n; i++)\n    {\n        a[i] = b[i] + c[i];\n    }\n}</code></pre> </div> <p class="expander">Example (revised code)</p> <pre class="essential"><code class="cpp">...\n#pragma omp parallel for simd schedule(simd:static)\nfor (int i = 0; i &lt; n; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void f(int a[], int b[], int c[])\n{\n    #pragma omp parallel for simd schedule(simd:static)\n    for (int i = 0; i &lt; n; i++)\n    {\n        a[i] = b[i] + c[i];\n    }\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="http://www.openmp.org/mp-documents/openmp-4.5.pdf">OpenMP Application Programming Interface </a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},26326:e=>{e.exports=' <h4>Code region is recommended for offloading</h4> <div class="text promo"> Based on the <b>Offload Modeling</b> results, this code region is potentially profitable to offload. Estimated relative speedup on the %target_device% accelerator is %speed_up% compared to the current platform. Consider using <a href="https://www.intel.com/content/www/us/en/docs/oneapi/programming-guide/current/c-c-or-fortran-with-openmp-offload-programming.html"> OpenMP* Offload Programming Model</a> to offload this region to the target accelerator. <p class="expander">Example of using OpenMP <b>target</b> construct for offloading:</p> <pre class="essential"><code class="fortran" data-source="\n    !$omp target teams distribute parallel do map(to: matrixA, matrixB) map(from: matrixC) private(i, j, k) \n...\n"></code></pre> <pre class="expansion"><code class="fortran" data-source="\n    !$omp target teams distribute parallel do map(to: matrixA, matrixB) map(from: matrixC) private(i, j, k) \n    do j = 1, N\n        do i = 1, N\n            cvalue = 0\n            do k = 1, N\n                cvalue = cvalue + matrixA(i, k) * matrixB(k, j)\n            enddo\n            matrixC(i, j) = cvalue\n        enddo\n    enddo\n"></code></pre> </div> '},26925:e=>{e.exports=' <span id="source_disclaimer" class="disclaimer"> This issue is only detected in some compute tasks (%children_w_rec% from %all_children%) and not present in others. <br/> &nbsp; &nbsp; Expand the kernel to explore compute tasks for detailed recommendations. <br/> </span> '},27157:e=>{e.exports=' <h4>Use a Glibc library with vectorized SVML functions</h4> <div class="text"> <div class="promo">Your application calls scalar instead of vectorized versions of math functions. To fix: Do all of the following: <ul> <li> Upgrade the Glibc library to version 2.22 or higher. It supports SIMD directives in OpenMP* 4.0 or higher. </li> <li> Upgrade the GNU* gcc compiler to version 4.9 or higher. It supports vectorized math function options. </li> <li> Use the<samp class="codeph"> -fopenmp</samp> and <samp class="codeph">-ffast-math</samp> compiler options to enable vector math functions. </li> <li> Use appropriate OpenMP SIMD directives to enable vectorization. </li> </ul> <p> <b>Note</b> : Also use the <samp class="codeph">-I/path/to/glibc/install/include</samp> and <samp class="codeph">-L/path/to/glibc/install/lib</samp> compiler options if you have multiple Glibc libraries installed on the host. </p> <p class="expander">Example</p> <div class="essential"> <pre><code class="bash">gcc program.c -O2 -fopenmp -ffast-math -lrt -lm -mavx2 -I/opt/glibc-2.22/include -L/opt/glibc-2.22/lib -Wl,--dynamic-linker=/opt/glibc-2.22/lib/ld-linux-x86-64.so.2</code></pre> <pre><code class="cpp">...\n#pragma omp simd\nfor (i = 0; i &lt; N; i++)\n...</code></pre> </div> <div class="expansion"> <pre><code class="bash">gcc program.c -O2 -fopenmp -ffast-math -lrt -lm -mavx2 -I/opt/glibc-2.22/include -L/opt/glibc-2.22/lib -Wl,--dynamic-linker=/opt/glibc-2.22/lib/ld-linux-x86-64.so.2</code></pre> <pre><code class="cpp">#include "math.h"\n#include "stdio.h"\n#define N 100000\n\nint main()\n{\n    double angles[N], results[N];\n    int i;\n    srand(86456);\n\n    for (i = 0; i &lt; N; i++)\n    {\n        angles[i] = rand();\n    }\n\n    #pragma omp simd\n    for (i = 0; i &lt; N; i++)\n    {\n        results[i] = cos(angles[i]);\n    }\n\n   return 0;\n}</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://sourceware.org/glibc/wiki/libmvec">Glibc wiki/Libmvec</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},27477:(e,t,i)=>{"use strict";i.d(t,{p:()=>n}),i(69212),i(43468),i(45361),i(21602);var o=i(77106);const n={methods:{getTimeRegionToolTip(e,t,i){let n="";function s(t){if(void 0===e[t])return;const s={...(0,o.getValue)(i,t),value:e[t],formattedValue:e[`${t}_formatted`]};n+=`\n        <div style="white-space: nowrap">\n          <span style="color: ${(0,o.getMarkerColor)(s)}">∎</span>\n          <span style="padding-right: 1.5rem">${s.title}:</span>\n          <span style="float: right"><b>${s.formattedValue||(0,o.formatNumber)(s)}</b></span>\n        </div>`}for(const e of Object.values(t))Array.isArray(e)?e.forEach(s):s(e);return n},getTopRegionColumn:(e,t,i)=>({...(0,o.getValue)(i,t),value:e[t],formattedValue:e[`${t}_formatted`],tooltip:void 0}),getColumnInfo(e,t,i){const n=this.getTopRegionColumn(e,t,i);return n.formattedValue||(0,o.formatNumber)(n)},updateGridColumns(e){return e.map((e=>{const t=(0,o.getValue)(this.allColumns,e.id);return{...e,...t}}))},getBoundedByKeysSorted(e){const t=[...this.boundedBy.acceleratedBreakdown];t.sort(((t,i)=>e[i]-e[t]));let i=t.filter((t=>e[t]>=5e-5));return 0==i.length&&(i=t),{acceleratedBreakdown:i,taxes:this.boundedBy.taxes}},getHeightByNumberOfBars(e){const{acceleratedBreakdown:t}=this.getBoundedByKeysSorted(e),i=.533*t.length;return i>0?i+"rem":""},async onDrillDown(e){const{rowId:t}=e||await this.api.get("offload/summary","get-selected-row",{key:e.key});t&&this.$store.direct.commit.setSelection({id:"offload/accelerated-regions/selection",senderId:"offloadSummary",rowId:t})}}}},27537:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(39959)).default.observable({default:{},"offload:summary":{},"offload:accelerated-regions":{},"offload:source":{},"gpu:summary":{},"gpu:main":{},"gpu:source":{},"roofline:summary":{},"roofline:main":{},selector:{}});t.default=n},27543:e=>{e.exports=' <h4>Check dependencies for outer loop</h4> <div class="text promo"> <div id="no_dependency_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a> to identify real data dependencies. </div> It is not safe to force vectorization without knowing that there are no dependencies. <b>Disable inner vectorization before check Dependency.</b> <span id="actions" style="display:none">To check: Run a <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a>.</span> </div>'},27714:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(2439),n=i(38322),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"53e776a8",null).exports},27725:(e,t,i)=>{i(64180),i(22921),i(52488),i(428),i(21336),i(76955),i(74410),i(37321),i(61207),i(95584),i(15805),i(9295),e.exports=function e(t,i,o){function n(r,a){if(!i[r]){if(!t[r]){if(s)return s(r,!0);var l=new Error("Cannot find module '"+r+"'");throw l.code="MODULE_NOT_FOUND",l}var c=i[r]={exports:{}};t[r][0].call(c.exports,(function(e){return n(t[r][1][e]||e)}),c,c.exports,e,t,i,o)}return i[r].exports}for(var s=void 0,r=0;r<o.length;r++)n(o[r]);return n}({1:[function(e,t,i){var o=.1,n="function"==typeof Float32Array;function s(e,t){return 1-3*t+3*e}function r(e,t){return 3*t-6*e}function a(e){return 3*e}function l(e,t,i){return((s(t,i)*e+r(t,i))*e+a(t))*e}function c(e,t,i){return 3*s(t,i)*e*e+2*r(t,i)*e+a(t)}function d(e){return e}t.exports=function(e,t,i,s){if(!(0<=e&&e<=1&&0<=i&&i<=1))throw new Error("bezier x values must be in [0, 1] range");if(e===t&&i===s)return d;for(var r=n?new Float32Array(11):new Array(11),a=0;a<11;++a)r[a]=l(a*o,e,i);function p(t){for(var n=0,s=1;10!==s&&r[s]<=t;++s)n+=o;--s;var a=n+(t-r[s])/(r[s+1]-r[s])*o,d=c(a,e,i);return d>=.001?function(e,t,i,o){for(var n=0;n<4;++n){var s=c(t,i,o);if(0===s)return t;t-=(l(t,i,o)-e)/s}return t}(t,a,e,i):0===d?a:function(e,t,i,o,n){var s,r,a=0;do{(s=l(r=t+(i-t)/2,o,n)-e)>0?i=r:t=r}while(Math.abs(s)>1e-7&&++a<10);return r}(t,n,n+o,e,i)}return function(e){return 0===e?0:1===e?1:l(p(e),t,s)}}},{}]},{},[1])(1)},27730:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"enum-knob",class:[e.enumStyle,{disabled:e.knob.readOnly}]},[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:e.knob.description||e.knob.name,expression:"knob.description || knob.name",modifiers:{title:!0}}],staticClass:"knob-name"},[e._v("\n    "+e._s(e.knob.name)),e.knob.description?t("i",{staticClass:"icon help-circle",class:e.light?"light":"dark"}):e._e()]),e._v(" "),t("div",{directives:[{name:"click-outside",rawName:"v-click-outside",value:e.close,expression:"close"}],staticClass:"selection dropdown",class:{hide:e.hide}},[t("div",{staticClass:"choice-line",on:{click:function(t){e.isOpened=!e.isOpened}}},[t("span",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:e.selectedItem,expression:"selectedItem",modifiers:{title:!0}}],staticClass:"choice"},[e._v("\n        "+e._s(e.selectedItem)+"\n        "),e.highlightChanges?t("span",{staticClass:"changed",domProps:{innerHTML:e._s(e.asterisk)}}):e._e()]),e._v(" "),t("span",{staticClass:"icon caret-down"})]),e._v(" "),t("div",{staticClass:"menu",class:{opened:e.isOpened}},e._l(e.knob.items,(function(i){return t("div",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:i.displayValue,expression:"item.displayValue",modifiers:{title:!0}}],key:i.value,staticClass:"item",on:{click:function(t){return e.select(i)}}},[e._v("\n        "+e._s(i.displayValue)+"\n        "),i.displayPostfix?t("span",{staticClass:"postfix",domProps:{innerHTML:e._s(i.displayPostfix)}}):e._e()])})),0)])])};o._withStripped=!0,i(69212),i(38333);var n=i(33202);const s={props:{knob:{type:Object,validator:e=>"string"==typeof e.id&&"string"==typeof e.name&&("string"==typeof e.value||"number"==typeof e.value)&&Array.isArray(e.items)},hide:{type:Boolean,default:!1},highlightChanges:{type:Boolean,default:!1},light:Boolean,enumStyle:String},data:()=>({isOpened:!1}),computed:{knobItem(){return this.knob.items.find((e=>e.value===this.knob.value))},selectedItem(){var e;return null==this||null===(e=this.knobItem)||void 0===e?void 0:e.displayValue},asterisk(){var e;return null!=this&&null!==(e=this.knobItem)&&void 0!==e&&e.displayPostfix?"":"*"}},methods:{select(e){this.close(),this.$emit("onKnobChanged",{...this.knob,value:e.value},e.value,e)},close(e){e&&n.Ay.isRequestClick(e.target)||(this.isOpened=!1)}}},r=(0,i(98822).A)(s,o,[],!1,null,"1b9fab40",null).exports},28047:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(38696),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},28293:e=>{e.exports=' <h4>Consider outer loop vectorization</h4> <div class="text"> <div class="promo"> The compiler never targets loops other than innermost ones, so it vectorized the inner loop while did not vectorize the outer loop. However outer loop vectorization could be more profitable because of better Memory Access Pattern, higher Trip Counts or better Dependencies profile. </div> To enforce outer loop vectorization: <table> <tr> <th> Target </th> <th> Directive </th> </tr> <tr> <td> Outer loop</td> <td>#pragma omp simd</td> </tr> <tr> <td> Inner loop</td> <td> #pragma novector</td> </tr> </table> <p id="disclaimer"> Given issue is only about opportunity to vectorize outer loop, to prove profitability you need perform deeper dive analysis (MAP, Trip Counts, Dependencies) </p> <div class="promo"> <p class="expander">Example</p> <pre class="essential"><code class="cpp">#pragma omp simd\nfor(i=0; i&lt;N; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">#pragma omp simd\nfor(i=0; i&lt;N; i++)\n{\n    #pragma novector\n    for(j=0; j&lt;N; j++)\n    {\n        sum += A[i]*A[j];\n    }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <i>omp simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html">OpenMP* Pragmas Summary</a>, <a href="docs:C++/17/index.htm#GUID-CFBEC461-748D-4162-A669-C4F42848267F.html">novector</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/outer-loop-vectorization.html">Outer Loop Vectorization</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},28819:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){return(0,this._self._c)("div")};o._withStripped=!0;var n=i(61262);const s={props:{size:[Number,String],minSize:Number,foldPrimary:{type:Boolean,default:!0},horizontal:{type:Boolean,default:!1},autoFold:{type:Boolean,default:!0},folded:{type:String,default:""},traits:Object},data:()=>({splitterObject:null}),watch:{size(){this.splitterObject&&this.splitterObject.setSize(this.size)},folded(){if(this.splitterObject){const e=this.folded.indexOf("hide")>0;0===this.folded.indexOf("primary")?this.splitterObject.foldPrimary(e):0===this.folded.indexOf("secondary")?this.splitterObject.foldSecondary(e):this.splitterObject.unfold()}}},methods:{get(){return this.splitterObject}},mounted(){const e=this.$el,t=e.parentElement;t.primaryDiv=e.previousElementSibling,t.secondaryDiv=e.nextElementSibling,t.splitterDiv=e;const i=this.autoFold?1:this.minSize,o={refreshSizeByUserAction:!0,...this.traits};if(this.splitterObject=this.horizontal?(0,n.createVertSplitter)(t,i,o):(0,n.createHorzSplitter)(t,i,o),this.splitterObject.setSize(this.size||"50%"),this.splitterObject.addSash(this.foldPrimary),this.folded){const e=this.folded.indexOf("hide")>0;0===this.folded.indexOf("primary")?this.splitterObject.foldPrimary(e):0===this.folded.indexOf("secondary")&&this.splitterObject.foldSecondary(e)}this.autoFold&&(this.splitterObject.onRefreshSize=e=>{const t=parseInt(this.splitterObject.getSize(),10);0!==t&&t<this.minSize&&(this.splitterObject.setSize(this.minSize),this.splitterObject.foldPrimary())}),this.splitterObject.onStopUpdateSplitter=e=>this.$emit("changed",this.splitterObject.getSize()),this.splitterObject.afterFoldPrimary=e=>{this.$emit("changed",this.splitterObject.getSize()),this.$emit("afterFoldPrimary")},this.splitterObject.afterFoldSecondary=e=>this.$emit("afterFoldSecondary"),this.splitterObject.afterUnfold=e=>{this.$emit("changed",this.splitterObject.getSize()),this.$emit("afterUnfold")}},destroyed(){this.splitterObject&&this.splitterObject.remove()}},r=(0,i(98822).A)(s,o,[],!1,null,null,null).exports},28973:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this._self._c;return e("div",{staticClass:"content"},[e("tree-list",{attrs:{items:this.getPlatformInformation,collapsed:!1}})],1)};o._withStripped=!0,i(36094);const n={computed:{...(0,i(75337).mapGetters)("gpu",["getPlatformInformationData","getCpuPlatformInformationData"]),getPlatformInformation(){const e=this.getPlatformInformationData,t=this.getCpuPlatformInformationData,i=["cpuName","cpuFrequency","cpuCount","osName","hostName","mpiRank"],o=[];for(const e of i)t[e]&&o.push(t[e]);return 2===e.length?[{...e[0],children:[...e[0].children,e[1]]},{...t.cpuInfo,children:o}]:[...e,{...t.cpuInfo,children:o}]}}},s=(0,i(98822).A)(n,o,[],!1,null,"3240936e",null).exports},29397:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>l});var o=function(){var e=this,t=e._self._c;return t("nav",[t("div",{staticClass:"container"},[t("div",{staticClass:"name-help",on:{click:function(t){return e.onButtonHelpClick()}}},[t("i",{staticClass:"icon help-circle"}),e._v("\n      "+e._s(e.$t("getting_started"))+"\n    ")]),e._v(" "),t("div",{staticClass:"name-section"},[t("div",{staticClass:"name-welcome"},[t("img",{attrs:{src:e.welcomeNameImage}})]),e._v(" "),t("div",{staticClass:"name-version"},[e._v("\n        "+e._s(e.getProductVersion)+"\n      ")])]),e._v(" "),t("div",{staticClass:"name-description"},[e._v("\n      "+e._s(e.getProductDescription)+"\n    ")]),e._v(" "),t("div",{staticClass:"button-section",class:{"single-btn":!e.isAdditionalButton}},[t("div",{staticClass:"button-main btn-style",class:{"cli-project":e.isCurrentProjectCli},on:{click:function(t){return e.onButtonClick(e.getMainButton.id)}}},[t("i",{staticClass:"icon",class:e.getMainButton.icon}),e._v("\n        "+e._s(e.$t(e.getMainButton.title))+"\n      ")]),e._v(" "),e.isAdditionalButton?t("div",{staticClass:"button-additional btn-style",on:{click:function(t){return e.onButtonClick(e.getAdditionalButton.id)}}},[t("i",{staticClass:"icon",class:e.getAdditionalButton.icon}),e._v("\n        "+e._s(e.$t(e.getAdditionalButton.title))+"\n      ")]):e._e()]),e._v(" "),t("welcome-actions",{staticClass:"welcome-actions"})],1)])};o._withStripped=!0;var n=i(75337),s=i(15885),r=i(18977);const a={mixins:[{created(){r.A.welcome.getHTML((e=>document.documentElement.innerHTML))}},{created(){r.A.welcome.pressButton((e=>{const{value:t}=e;this.onButtonClick(t)}))}}],created(){this.welcomeNameImage="assets/intel-logo-title.svg"},computed:{...(0,n.mapGetters)("welcome",["getMainButton","getAdditionalButton","isAdditionalButton","getProductDescription","getProductVersion","isCurrentProjectCli"])},methods:{onButtonClick(e){this.$store.direct.dispatch.welcome.setActionButtonId({id:e})},onButtonHelpClick(){this.$store.direct.dispatch.welcome.loadGettingStarted()}},components:{WelcomeActions:s.default}},l=(0,i(98822).A)(a,o,[],!1,null,"5d0e5730",null).exports},29427:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("layout-panel-group",{staticClass:"metrics",attrs:{accent:""}},e._l(e.data,(function(e){return t("metric-item-box",{key:e.id,attrs:{metric:e}})})),1)};o._withStripped=!0,i(69212),i(43468);var n=i(75337),s=i(82488);const r={components:{MetricItemBox:i(48706).default},computed:{...(0,n.mapGetters)("offload",["getMainMetricsData"]),data(){return this.getMainMetricsData.filter((e=>e.id!==s.s))}}},a=(0,i(98822).A)(r,o,[],!1,null,"b79bdec4",null).exports},29618:e=>{e.exports=' <h4>Add data padding</h4> <div class="text"> <div class="promo"> <span id="peel_remainder"> The <span data-glossary-id="trip_count">trip count</span> %trip_count_wo_peel% <span id="tc_peel_gt_0">remaining after the compiler generates the <span data-glossary-id="peeled_loop">peeled loop</span></span> is not a multiple of <span id="uf_le_1"><span data-glossary-id="vector_length">vector length</span></span> %vl_x_uf%<span id="uf_gt_1"> (<span data-glossary-id="vector_length">vector length</span> * <span data-glossary-id="unroll">unroll factor</span>)</span>. To fix: Do one of the following: </span> <ul> <li>Increase the size of objects and add iterations so the trip count is a multiple of vector length.</li> <li>Increase the size of static and automatic objects, and use a compiler option to add data padding.</li> </ul> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-4D8408E2-D3B5-4AA5-9727-26EE46A9DEC1.html">LOOP COUNT</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/utilizing-full-vectors.html">Utilizing Full Vectors</a>, <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a>, and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div> '},29794:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(57143)),s={props:{eventName:{type:String,required:!0}},data:()=>({contentHeightObserver:void 0,contentHeight:void 0}),mounted(){this.contentHeightObserver=new n.default(this.onObserveContentHeight),this.contentHeightObserver.observe(this.$refs.content)},beforeDestroy(){this.contentHeightObserver.unobserve(this.$refs.content)},computed:{isCollectionRunning(){return this.$store.direct.getters.log.isCollectionRunning(this.eventName)},recommendations(){return this.$store.direct.getters.log.getVisibleRecommendations(this.eventName,this.$t("do_not_show_this_message_again"))}},methods:{onObserveContentHeight(){const{height:e}=this.$refs.container.getBoundingClientRect(),t=Math.ceil(e);this.contentHeight!==t&&(this.$store.direct.dispatch.log.setRecommendationsContainerHeight(t),this.contentHeight=t)}}};t.default=s},29993:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"group",class:{accent:e.accent}},[e.title?t("h3",[t("label",[e._v(e._s(e.title))]),e._v(" "),e._t("title")],2):e._e(),e._v(" "),e._t("default")],2)};o._withStripped=!0;const n={props:{title:String,accent:Boolean}},s=(0,i(98822).A)(n,o,[],!1,null,"2bd4b340",null).exports},30115:e=>{e.exports=' <h4>Apply data reuse</h4> <div class="text"> <div class="promo"> <p>Apply the <b>data reuse</b> technique.</p> <p> With this technique, two sequential kernels can share data without additional data transfer. This can improve data transfer efficiency. For variables used by multiple target constructs, use the <samp class="codeph">target enter data</samp> and <samp class="codeph">target exit data</samp> directives to minimize data transfers between host and target devices. </p> </div> <br> <p> The estimated <b>default</b> data transfer without data reuse for this kernel is %data_transfer_total_no_reuse% (the data transferred from the target device is %data_transfer_read_no_reuse%, the data transferred to the target device is %data_transfer_write_no_reuse%). </p> <br> <p> The estimated data transfer <b>with data reuse applied</b> is %data_transfer_total% (the data transferred from the target device is %data_transfer_read%, the data transferred to the target device is %data_transfer_write%). </p> <br> <p> With the data reuse applied, you may get the data transfer gain (speedup): %data_reuse_speed_up_percents%. </p> <br> Place the data reuse directives as follows: <ul> <li> Place the <samp class="codeph">target enter data</samp> directive before the first <samp class="codeph">target</samp> directive to transfer data from host to target device. </li> <li> Place the <samp class="codeph">target exit data</samp> directive after the last <samp class="codeph">target</samp> directive to transfer data from target to host device. </li> </ul> See the <a href="https://www.openmp.org/spec-html/5.1/openmpsu66.html">OpenMP* specification</a> for more details. <p class="expander">Example of data reuse organization:</p> <pre class="essential"><code class="cpp" data-source="\nvoid matmult(float* mA, float* mB, float* mC)                                  \n{                                                                              \n    #pragma omp target teams distribute parallel for collapse(2) map(to: mA[0:N*N], mB[0:N*N]) map(from: mC[0:N*N]) \n...\n}                                                                              \n...\n    #pragma omp target enter data map(to: A[0:N*N], B[0:N*N], C[0:N*N]) map(alloc: C1[0:N*N]) \n    matmult(A, B, C1); \n    matmult(C1, C, D); \n    #pragma omp target exit data map(delete: C1[0:N*N])  \n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\nvoid matmult(float* mA, float* mB, float* mC)                                  \n{                                                                              \n    #pragma omp target teams distribute parallel for collapse(2) map(to: mA[0:N*N], mB[0:N*N]) map(from: mC[0:N*N]) \n    for (int i = 0; i < N; i++)\n        for (int j = 0; j < N; j++)\n            {\n                float item = 0;\n                for (int k = 0; k < N; k++)\n                    item += mA[i * N + k] * mB[k * N + j];\n                mC[i * N + j] = item;\n            }\n}                                                                              \n\nvoid matmult3(float* A, float* B, float* C, float* D)\n{\n    float* C1 = new float[N*N];\n    #pragma omp target enter data map(to: A[0:N*N], B[0:N*N], C[0:N*N]) map(alloc: C1[0:N*N]) \n    matmult(A, B, C1); \n    matmult(C1, C, D); \n    #pragma omp target exit data map(delete: C1[0:N*N])  \n    delete[] C1;\n}\n"></code></pre> </div> '},30130:e=>{e.exports=' <h4>Use a smaller vector length</h4> <div class="text"> <div class="promo"> The compiler chose a <span data-glossary-id="vector_length">vector length</span> of <span id="peel_remainder"> %vl% </span>, but the <span data-glossary-id="trip_count">trip count</span> might be smaller than the vector length. To fix: Specify a smaller vector length using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">!$OMP SIMD SIMDLEN</samp>. <p class="expander">Example</p> <pre class="essential"><code class="fortran">...\n!$OMP SIMD SIMDLEN(4)\ndo i = 1, m\n...</code></pre> <pre class="expansion"><code class="fortran">!$OMP SIMD SIMDLEN(4)\ndo i = 1, m\n    b(i) = a(i) + 1\n    d(i) = c(i) + 1\nenddo</code></pre> </div> </div> In version 19.0 and higher of the Intel compiler, there is a new vector length clause that allows the compiler to choose the best vector length based on cost: <samp class="codeph">!DIR$ VECTOR VECTORLENGTH (vl<sub>1</sub>, vl<sub>2</sub>, ..., vl<sub>n</sub>)</samp> where vl is an integer power of 2. <p class="expander">Example</p> <pre class="expansion"><code class="fortran">!DIR$ VECTOR VECTORLENGTH(2, 4, 16)\ndo i = 1, m\n    b(i) = a(i) + 1\n    d(i) = c(i) + 1\nenddo</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a>, <a href="docs:Fortran/17/index.htm#GUID-967D7284-0E6D-4B02-B679-4DEE93D96E49.html">VECTOR and NOVECTOR</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html"> Getting Started with Intel Compiler Pragmas and Directives </a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> '},30241:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>c});var o=function(){var e=this,t=e._self._c;return t("header",[t("div",{staticClass:"header-panel"},[e.isReport?t("div",{staticClass:"report-only title"},[t("img",{attrs:{src:e.AdSvg}}),e._v(" "),t("div",{staticClass:"report-logo"},[t("img",{attrs:{src:e.IntelAdvisorSvg}}),e._v(" "),t("span",{staticClass:"build"},[e._v("\n          "+e._s(e.$t("build_number"))+" "+e._s(e.projectData.buildNumber)+"\n        ")])])]):t("div"),e._v(" "),t("i",{staticClass:"icon crossroads-sign light"}),e._v(" "),t("perspective-selector",{staticClass:"selector",attrs:{"enum-style":e.enumStyle}}),e._v(" "),t("div",{staticClass:"divider"}),e._v(" "),t("div",{staticClass:"navigation"},[e._t("navigation")],2),e._v(" "),e.isReport?t("div",{staticClass:"report-only metrics"},[t("div",{attrs:{title:e.projectData.projectPath}},[e._v("\n        "+e._s(e.$t("project_title"))+": "),t("span",[e._v(e._s(e.projectData.projectTitle))])]),e._v(" "),t("div",{attrs:{title:e.projectData.appPath}},[e._v("\n        "+e._s(e.$t("app_name"))+": "),t("span",[e._v(e._s(e.projectData.appName))])])]):e._e(),e._v(" "),t("div",{staticClass:"metrics"},[e._t("metrics")],2),e._v(" "),t("div",{staticClass:"divider"}),e._v(" "),t("div",{staticClass:"buttons",class:{disabled:e.disabled}},[e._t("buttons")],2)],1)])};o._withStripped=!0;var n=i(84620),s=i(8933);const r=i.p+"assets/ad-logo.svg",a=i.p+"assets/intel-advisor-logo.svg",l={props:{disabled:Boolean},data:()=>({AdSvg:r,IntelAdvisorSvg:a}),computed:{name(){const e=this.$store.state.activePerspectiveId;return{[n.ProductMode.pmOffload]:"perspective_offload_name",[n.ProductMode.pmGPU]:"perspective_gpu_name",[n.ProductMode.pmRoofline]:"perspective_roofline_name"}[e]||""},enumStyle:()=>"h-perspective",isReport:()=>(0,s.P)(),projectData(){return this.isReport?i(99046).U1():void 0}}},c=(0,i(98822).A)(l,o,[],!1,null,"d8d100ee",null).exports},30290:e=>{e.exports=' <h4>Apply data reuse</h4> <div class="text"> <div class="promo"> <p>Apply the <b>data reuse</b> technique.</p> <p> With this technique, two sequential kernels can share data without additional data transfer. This can improve data transfer efficiency. For variables used by multiple target constructs, use the <samp class="codeph">target enter data</samp> and <samp class="codeph">target exit data</samp> directives to minimize data transfers between host and target devices. </p> </div> <br> <p> The estimated <b>default</b> data transfer without data reuse for this kernel is %data_transfer_total_no_reuse% (the data transferred from the target device is %data_transfer_read%, the data transferred to the target device is %data_transfer_write%). </p> <br> <p> The estimated data transfer <b>with data reuse applied</b> is %data_transfer_total% (the data transferred from the target device is %data_transfer_read%, the data transferred to the target device is %data_transfer_write%). </p> <br> <p> With the data reuse applied, you may get the data transfer gain (speedup): %data_reuse_speed_up_percents%. </p> <br> Place the data reuse directives as follows: <ul> <li> Place the <samp class="codeph">target enter data</samp> directive before the first <samp class="codeph">target</samp> directive to transfer data from host to target device. </li> <li> Place the <samp class="codeph">target exit data</samp> directive after the last <samp class="codeph">target</samp> directive to transfer data from target to host device. </li> </ul> See the <a href="https://www.openmp.org/spec-html/5.1/openmpsu66.html">OpenMP* specification</a> for more details. <p class="expander">Example of data reuse organization:</p> <pre class="essential"><code class="fortran" data-source="\nsubroutine matmult(N, mA, mB, mC) \n...\n    !$omp target teams distribute parallel do collapse(2) map(to: mA, mB) map(from: mC) \n...\nend \n...\n    !$omp target enter data map(to: A, B, C) map(alloc: C1) \n    call matmult(N, A, B, C1) \n    call matmult(N, C1, C, D) \n    !$omp target exit data map(delete: C1)  \n...\n"></code></pre> <pre class="expansion"><code class="fortran" data-source="\nsubroutine matmult(N, mA, mB, mC) \n\n    integer(kind = 4), intent (in)    :: N\n    real   (kind = 4), intent (inout) :: mA(N,N), mB(N,N), mC(N,N)\n    real   (kind = 4)                 :: cvalue\n\n    !$omp target teams distribute parallel do collapse(2) map(to: mA, mB) map(from: mC) \n    do j = 1, N\n        do i = 1, N\n            cvalue = 0\n            do k = 1, N\n                cvalue = cvalue + mA(i, k) * mB(k, j)\n            enddo\n            mC(i, j) = cvalue\n        enddo\n    enddo\n\nend \n\n\nsubroutine matmult3(N, A, B, C, D)\n\n    integer(kind = 4), intent (in)    :: N\n    real   (kind = 4), intent (inout) :: A(N,N), B(N,N), C(N,N), D(N,N)\n    real   (kind = 4), allocatable    :: C1(:,:)\n\n    allocate( C1(1:N, 1:N) )\n\n    !$omp target enter data map(to: A, B, C) map(alloc: C1) \n    call matmult(N, A, B, C1) \n    call matmult(N, C1, C, D) \n    !$omp target exit data map(delete: C1)  \n    \n    deallocate(C1)\n\nend\n"></code></pre> </div> '},30331:e=>{e.exports=' <h4>Vectorize user function(s) inside loop</h4> <div class="text"> <p class="promo"> <span id="function_names" style="display:none"> These user-defined function(s) are not vectorized or inlined by the compiler: %function_names% To fix: Do one of the following: </span> </p> <ul> <li> Enforce vectorization of the <span data-glossary-id="source_loop">source loop</span> by means of SIMD instructions and/or create a SIMD version of the function(s) using a <span data-glossary-id="directive">directive</span>: <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th>Target</th> <th>Directive</th> </tr> </thead> <tbody> <tr> <td> Source loop </td> <td> !$OMP SIMD </td> </tr> <tr> <td> Inner function definition or declaration </td> <td> !$OMP DECLARE SIMD </td> </tr> </tbody> </table> </li> <li> If using the <samp class="codeph">Ob</samp> or <samp class="codeph">inline-level</samp> compiler option to control inline expansion with the <samp class="codeph">1</samp> argument, use an <samp class="codeph">inline</samp> keyword to enable inlining or replace the <samp class="codeph">1</samp> argument with <samp class="codeph">2</samp> to enable inlining of any function at compiler discretion. </li> </ul> <span class="promo"> <p class="expander">Example</p> <pre class="essential"><code class="fortran">real function f (x)\n    !DIR$ OMP DECLARE SIMD\n    real, intent(in), value  :: x\n    f= x + 1\nend function f\n...</code></pre> <pre class="expansion"><code class="fortran">real function f (x)\n    !DIR$ OMP DECLARE SIMD\n    real, intent(in), value  :: x\n    f= x + 1\nend function f\n\n!DIR$ OMP SIMD\ndo k = 1, N\n    a(k) = f(k)\nenddo</code></pre> </span> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-A9B9396B-3984-4DAA-887E-F5493F12B255.htm">DECLARE SIMD</a>, <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.htm">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},30347:function(e,t,i){"use strict";i(69212),i(38333),i(45361);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(39959)),s={updateActivePerspectiveId(e,t){e.activePerspectiveId=t},updatePerspectives(e,t=[]){e.allPerspectives=t},updateVisibleNavigationLink(e,t){e.visibleNavigationLink=t},updateFilterActivated(e,t){e.filterActivated=t},setDataLoadedStatus(e,t){const i=JSON.parse(JSON.stringify(e.selection)),{path:o}=t,s=o.split("/").find((e=>!!e));Object.getOwnPropertyNames(i).forEach((e=>{0===e.indexOf(s)&&delete i[e]})),e.selection=i,n.default.set(e.dataLoadedStatus,o,{...t,hash:Date.now()})},setSelection(e,{id:t,senderId:i,rowId:o}){const n={...e.selection,[t]:{senderId:i,rowId:o}};e.selection=Object.assign({},n)},deleteSelection(e,t){n.default.delete(e.selection,t)},setEnabledFeatures(e,t){e.enabledFeatures=t}};t.default=s},30443:e=>{e.exports=' <h4>Vectorize math function calls inside loops</h4> <div class="text"> <div class="promo"> Your application calls serialized versions of math functions when you use the <samp class="codeph">precise</samp> floating point model. To fix: Do one of the following: <ul> <li> Add <samp class="codeph">fast-transcendentals</samp> compiler option to replace calls to transcendental functions with faster calls. <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /Qfast-transcendentals </td> <td> -fast-transcendentals </td> </tr> </tbody> </table> <p> CAUTION: This may reduce floating point accuracy. </p> </li> <li> Enforce vectorization of the <span data-glossary-id="source_loop">source loop</span> using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">!$OMP SIMD</samp> </li> </ul> <p class="expander">Example</p> <pre class="essential"><code class="fortran">...\n!DIR$ OMP SIMD\ndo i=x+1, n\n...</code></pre> <pre class="expansion"><code class="fortran">subroutine add(A, N, X)\n    integer N, X\n    real    A(N)\n    !DIR$ OMP SIMD\n    do i=x+1, n\n        a(i) = a(i) + a(i-x)\n    enddo\nend</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-0A4F4F35-1495-4154-8AD5-238E8C68CE9B.html">fast-transcendentals, Qfast-transcendentals</a>; <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},30521:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(48025),n=i(28047),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"33ed61ba",null).exports},30712:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"header",class:[{events:e.events},{recommendations:e.recommendations}]},[e.events?t("h4",[t("i",{staticClass:"icon bell"}),e._v(e._s(e.$t("top_slider_events"))+"\n  ")]):e._e(),e._v(" "),e.events?t("div",{staticClass:"controls"},[t("toggle-switch",{attrs:{checked:e.isAppOutputVisible},on:{click:e.onShowAppOutput}},[t("span",{attrs:{slot:"right"},slot:"right"},[e._v(e._s(e.$t("top_slider_app_output")))])]),e._v(" "),t("toggle-switch",{attrs:{checked:e.isCollectorOutputVisible},on:{click:e.onShowCollectorOutput}},[t("span",{attrs:{slot:"right"},slot:"right"},[e._v(e._s(e.$t("top_slider_collection_log")))])]),e._v(" "),t("spark-button",{attrs:{quiet:""},on:{click:e.onCloseEvents}},[t("i",{staticClass:"icon cross"})])],1):e._e(),e._v(" "),e.recommendations?t("h4",[t("i",{staticClass:"icon megaphone"}),e._v(e._s(e.$t("top_slider_recommendations"))+"\n    "),e.length>0?t("span",[e._v(" ("+e._s(e.length)+")")]):e._e()]):e._e(),e._v(" "),e.recommendations?t("div",{staticClass:"controls"},[t("spark-button",{attrs:{quiet:""},on:{click:e.onPinRecs}},[t("i",{class:e.pinRecsIconClass})]),e._v(" "),t("spark-button",{attrs:{quiet:""},on:{click:e.onCloseRecs}},[t("i",{staticClass:"icon cross"})])],1):e._e()])};o._withStripped=!0;var n=i(75337);const s={props:{length:Number,events:Boolean,recommendations:Boolean},computed:{...(0,n.mapGetters)("log",["isAppOutputVisible","isCollectorOutputVisible","isRecommendationsPinned"]),pinRecsIconClass(){return this.isRecommendationsPinned?"icon pin solid":"icon pin"}},methods:{onShowAppOutput(){this.$store.direct.dispatch.log.toggleAppOutputVisible()},onShowCollectorOutput(){this.$store.direct.dispatch.log.toggleCollectorOutputVisible()},onCloseEvents(){this.$store.direct.dispatch.log.toggleEventLogVisible(!1)},onPinRecs(){this.$store.direct.dispatch.log.toggleRecommendationsPinned()},onCloseRecs(){this.$store.direct.dispatch.log.toggleRecommendationsVisible(!1)}}},r=(0,i(98822).A)(s,o,[],!1,null,"4bc57a7b",null).exports},30832:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(39959)),s=i(38235),r=n.default.observable({switchViewChangeReason:{[s.OFFLOAD_LOG]:null,[s.GPU_LOG]:null,[s.ROOFLINE_LOG]:null},collectionRunning:{[s.OFFLOAD_LOG]:!1,[s.GPU_LOG]:!1,[s.ROOFLINE_LOG]:!1},eventLogMessageCount:{[s.OFFLOAD_LOG]:void 0,[s.GPU_LOG]:void 0,[s.ROOFLINE_LOG]:void 0},applicationOutputLength:{[s.OFFLOAD_LOG]:void 0,[s.GPU_LOG]:void 0,[s.ROOFLINE_LOG]:void 0},eventLog:{[s.OFFLOAD_LOG]:[],[s.GPU_LOG]:[],[s.ROOFLINE_LOG]:[]},collectorOutput:{[s.OFFLOAD_LOG]:[],[s.GPU_LOG]:[],[s.ROOFLINE_LOG]:[]},applicationOutput:{[s.OFFLOAD_LOG]:[],[s.GPU_LOG]:[],[s.ROOFLINE_LOG]:[]},topSlider:{condition:s.CONDITION_COLLAPSED,prevCondition:s.CONDITION_EXPANDED,height:void 0,outputHeight:void 0,eventLogContentHeight:void 0,recommendationsContainerHeight:void 0,isRecommendationsPinned:!1,isRecommendationsVisible:!1,isEventLogVisible:!1,isAppOutputVisible:!0,isCollectorOutputVisible:!0,isAutoShowRecommendations:!1}});t.default=r},31033:function(e,t,i){"use strict";i(36094),i(27468),i(69212),i(43827),i(43468),i(38333),i(9178),i(45361),i(21602),i(32204),i(60426);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(57143)),s=i(75337),r=o(i(21673)),a=o(i(14624)),l=o(i(75829)),c=o(i(42248)),d=o(i(99597)),p=o(i(42973)),u=i(60970),h={mixins:[d.default,p.default],props:{dimensions:{type:Number,required:!0,default:2},direction:{type:String,default:u.DIRECTION_ROW},disabled:Boolean,features:{type:Array,validator:e=>{const t=e.every((e=>"string"==typeof e&&u.ALL_FEATURES.includes(e))),i=e.includes(u.HIDE_BY_CROSS_BUTTON)&&e.includes(u.CLOSE_BY_CROSS_BUTTON);return t&&!i},default:()=>u.DEFAULT_FEATURES},guideSizes:{type:Array,default:()=>[]},size:String},computed:{...(0,s.mapGetters)("layout",["getStateVersion","getVisibleGuides","getAllTabs","getLayoutFlexDirection","getLayoutSize"]),isInitialized(){return this.$store.direct.getters.layout.isInitialized(this.view)},visibleGuides(){return this.getVisibleGuides(this.view)},layoutFlexDirection(){return this.getLayoutFlexDirection(this.view)},layoutSize(){return this.getLayoutSize(this.view)},flex(){return(0,u.sizeToFlex)(this.layoutSize)}},created(){this.view=this.$route.name||"default",this.panelCache={};const{view:e}=this,t=(this.$slots.default||[]).filter((e=>e.tag)),i=this.getAllTabs(e),o=i.length!==t.length||i.some((e=>{var i;const{caption:o,name:n,slotIndex:s}=e,r=t[s],a=(null==r||null===(i=r.data)||void 0===i?void 0:i.attrs)||{};return!r||a.caption!==o||a.name!==n})),n=this.getStateVersion(e);this.isInitialized&&!o&&n===u.STATE_VERSION&&"default"!==this.view||this.initLayoutState(),this.updateCaptionsInStore()},mounted(){this.resizeObserver=new n.default(this.fitLayoutToContainer),this.resizeObserver.observe(this.$el)},beforeUpdate(){this.updateCaptionsInStore()},render(e){const{view:t,visibleGuides:i,layoutFlexDirection:o,flex:n,disabled:s}=this,r=(this.$slots.default||[]).filter((e=>e.tag)),a=t=>e("layout-splitter",{props:t}),l=e=>{const{type:t,tabs:i}=e;return{...e,tabs:t===u.TYPE_PANEL?i.map((({slotIndex:e,...t})=>({slot:r[e],slotIndex:e,...t}))):void 0}},c=i.map((i=>{const{type:o,...n}=i;return o===u.TYPE_GUIDE?(s={view:t,guide:i,...n,panels:i.panels.map(l)},e("layout-guide",{props:s,ref:"guide",refInFor:!0})):(t=>e("layout-placeholder",{props:t,ref:"placeholder",refInFor:!0}))({view:t,type:u.GUIDE_SPLITTER});var s})).reduce(((e,i,n,s)=>n<s.length-1?e.concat(i,a({view:t,type:u.GUIDE_SPLITTER,prevElement:i,nextElement:s[n+1]})):e.concat(i,o!==u.DIRECTION_ROW?a({view:t,type:u.GUIDE_SPLITTER,prevElement:i}):[])),[]),d=e("div",{class:"layout-content",style:{"flex-direction":o}},c),p=s&&e("div",{class:"disabled-overlay"}),h=u.DEBUG&&i.map((e=>{const{size:i}=e;return`<li>Guide ${this.$store.direct.getters.layout.getGuideIndex(t,e)}: flex: ${(0,u.sizeToFlex)(i)}</li>`})),m=u.DEBUG&&e("div",{class:"debug-panel",domProps:{innerHTML:`<li>flex-direction: ${o}</li><li>flex: ${n}</li>${h.join("")}`}});return e("div",{class:"layout"},[p,d,m])},beforeDestroy(){this.resizeObserver.unobserve(this.$el);for(const{destroy:e}of Object.values(this.panelCache))"function"==typeof e&&e()},methods:{getPanelGuideIndex:(e,{numPanelsPerGuide:t})=>Math.floor(e/t),fitLayoutToContainer(e){const{view:t,layoutFlexDirection:i}=this,[o]=e,{contentRect:n}=o,{width:s,height:r}=n,{width:a,height:l}=this;s!==a&&(i===u.DIRECTION_ROW?this.$store.direct.dispatch.layout.fitGuidesToContainer({view:t}):this.$store.direct.dispatch.layout.fitPanelsToContainer({view:t})),r!==l&&(i===u.DIRECTION_ROW?this.$store.direct.dispatch.layout.fitPanelsToContainer({view:t}):this.$store.direct.dispatch.layout.fitGuidesToContainer({view:t})),this.width=s,this.height=r},updateCaptionsInStore(){const{view:e}=this,t=(this.$slots.default||[]).filter((e=>e.tag));for(const{slotIndex:o}of this.getAllTabs(e)){var i;const n=t[o],s=null==n||null===(i=n.data)||void 0===i||null===(i=i.attrs)||void 0===i?void 0:i.caption;this.$store.direct.getters.layout.getTabBySlotIndex(e,o).caption!==s&&this.$store.direct.dispatch.layout.setTabCaption({view:e,slotIndex:o,caption:s})}},initLayoutState(){const{view:e,direction:t,features:i,size:o,guideSizes:n,getPanelGuideIndex:s}=this,r=(this.$slots.default||[]).filter((e=>e.tag)),{dimensions:a}=this,l=Math.min(r.length,a),c=Math.ceil(r.length/l),d=Array(l).fill(null).map(((e,t)=>({type:u.TYPE_GUIDE,panels:[],size:n[t]})));r.forEach(((e,t)=>{const i=(e.data||{}).attrs||{},{panelState:o,compact:n,compactHeight:r,tabToSlot:a,tabState:p,name:h,...m}=i;if(delete m.caption,void 0===a){const e=i.guideIndex||s(t,{numGuides:l,numPanelsPerGuide:c});d[e].panels.push({type:u.TYPE_PANEL,tabs:[{slotIndex:t,compact:n,compactHeight:r,name:h,tabState:p||u.STATE_ACTIVE}],panelState:o||u.STATE_NORMAL,...m})}else{var f;const e=d.flatMap((e=>e.panels)).find((e=>{var t;return null===(t=e.tabs)||void 0===t?void 0:t.some((e=>e.slotIndex===+a))}));null==e||null===(f=e.tabs)||void 0===f||f.push({slotIndex:t,compact:n,compactHeight:r,name:h,tabState:p||u.STATE_NORMAL})}})),this.$store.dispatch("layout/setLayoutState",{view:e,guides:d,direction:t.toLowerCase(),features:i.map((e=>e.toLowerCase())),size:o,enabled:!0,version:u.STATE_VERSION})}},watch:{direction(){this.initLayoutState()}},components:{LayoutGuide:r.default,LayoutSplitter:a.default,BottomSplitter:l.default,CollapsedList:c.default}};t.default=h},31124:e=>{e.exports=' <h4>Potential underutilization of FMA instructions</h4> <div class="essential"> Your current hardware supports the AVX2 instruction set architecture (ISA), which enables the use of fused multiply-add (<a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a>) instructions. Improve performance by utilizing <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a> instructions. </div>'},31129:function(e,t,i){"use strict";i(69212),i(38333);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(51382)),s=i(60970),r={props:{view:{type:String,required:!0},panels:{type:Array,required:!0}},methods:{getSlotIndex(e){var t;return null==e||null===(t=e.tabs)||void 0===t?void 0:t.find((e=>e.tabState===s.STATE_ACTIVE)).slotIndex},onPanelExpanded(e){const{view:t}=this;this.$store.direct.dispatch.layout.restorePanel({view:t,slotIndex:e})},onPanelClosed(e){const{view:t}=this;this.$store.direct.dispatch.layout.closePanel({view:t,slotIndex:e})}},components:{PanelHeader:n.default}};t.default=r},31156:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",e._l(e.data,(function(i){return t("top-slider-list-item",e._b({key:i.id,attrs:{eventName:e.eventName}},"top-slider-list-item",i,!1))})),1)};o._withStripped=!0;const n={props:{data:Array,eventName:{type:String,required:!0}}},s=(0,i(98822).A)(n,o,[],!1,null,null,null).exports},31531:e=>{e.exports=' <h4>Use SoA instead of AoS</h4> <div class="text"> <p class="promo"> An array is the most common type of data structure containing a contiguous collection of data items that can be accessed by an ordinal index. You can organize this data as an array of structures (AoS) or as a structure of arrays (SoA). While AoS organization is excellent for encapsulation, it can hinder effective vector processing. To fix: Rewrite code to organize data using SoA instead of AoS. </p> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-D284C1EE-BFA4-4EA3-BB67-4A3E5D50199F.html">Programming Guidelines for Vectorization</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/memory-layout-transformations.html">Case study: Comparing Arrays of Structures and Structures of Arrays Data Layouts for a Compute-Intensive Loop</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},31608:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this;return(0,e._self._c)("idvc-bar-chart",{attrs:{"no-axis":"",horizontal:"",stacked:"","grid-lines":!1,"bar-shadow-color":e.shadowColor,"bars-width":e.barWidth,"chart-data":e.idvcSeries,onTooltip:e.tooltipProcessor}})};o._withStripped=!0,i(21602);var n=i(77106),s=i(85038);const r={props:{height:{type:String,default:""},series:{type:Array,required:!0},disableTooltip:{type:Boolean,default:!1},barWidth:{type:Number,default:.2}},mounted(){this.height&&(this.$el.style.height=this.height,this.$el.style.width="auto")},computed:{idvcSeries(){const{series:e}=this;return{labels:[],series:e.map((e=>({values:e.data.map((e=>+e)),color:(0,n.getMarkerColor)(e)})))}},tooltipProcessor(){if(!this.disableTooltip)return this.getTooltip.bind(this)},shadowColor:()=>s.light.L2},methods:{getTooltip(e){const t=this.series[e];return t?this.$t("metric_name_value",t.name,(0,n.formatNumber)(t)):""}}},a=(0,i(98822).A)(r,o,[],!1,null,null,null).exports},31623:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(78129),n=i(25095),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"b003fbac",null).exports},32035:(e,t,i)=>{"use strict";i.r(t),i.d(t,{assignObject:()=>n,createDataProcessing:()=>l,scrollToEnd:()=>s,scrollToEndMixin:()=>r}),i(36094),i(69212),i(45361);var o=i(77106);function n(e,t){e&&t&&(function(e,t){if(!Array.isArray(e)||!Array.isArray(t))return!1;let i=!1;return t.length>e.length?(e.length?e.push(t[t.length-1]):e.push(...t),i=!0):t.length||(e.splice(0,e.length),i=!0),i}(e,t)||Object.getOwnPropertyNames(t).forEach((function(i){Array.isArray(t)&&"length"===i||(e[i]&&"object"==typeof t[i]?n(e[i],t[i]):Array.isArray(e)&&void 0===t[i]?e.splice(+i,1):e[i]=t[i])})))}async function s(e,t){if(e&&(t=t||e.$el).scrollHeight-t.scrollTop-t.clientHeight<10){await e.$nextTick();const i=t.lastElementChild;i&&i.scrollIntoView()}}const r={methods:{async scrollToEnd(){await s(this)}}},a={id:"",type:"",hidden:!1,title:"",text:"",imageType:-1,animation:void 0,textItems:[],optionState:!1,optionCaption:"",buttons:[],min:0,max:100,val:0};function l(e,t,i,s,r){if(!e||!t)return;function l(e,t){return!(!e||!Array.isArray(t)||t.length||(e.splice(0,e.length),0))}const c={eventLog:function(e){if(!i||!e)return;if(l(i,e.data))return;const t=i.findIndex((t=>t.id===e.messageBoxId));if(t<0){if(e.data){const t=JSON.parse(JSON.stringify(a));t.id=e.messageBoxId,t.type=e.messageBoxType||"messageBoxEx",n(t,e.data),i.push(t)}}else e.data?n(i[t],e.data):i.splice(t,1)},output:function(e){const t=[],i=[];function n(e,t){t.length&&e.push(...t)}e&&(l(s,e)&&l(r,e)||(e.forEach((e=>{(0,o.hasAppOutput)(e.severity)?i.push(e):t.push(e)})),n(s,t),n(r,i)))}};function d(e){if(!e)return;const t=c[e.to];t&&t(e.data)}return{init(){t.subscribe(e,d)},unInit(){t.unsubscribe(e,d)}}}},32095:e=>{e.exports={CommandType:{ctSimple:0,ctDrillDown:1,ctHelp:2,ctCopyToClipboard:3,ctRunCollection:4,ctStartPausedCollection:5,ctStartSurveyCollection:6,ctStartSurveyPausedCollection:7,ctStartSuitabilityCollection:8,ctStartSuitabilityPausedCollection:9,ctStartMemoryAnalysisCollection:10,ctStartFullMemoryAnalysisCollection:11,ctStartMAPCollection:12,ctStartCorrectnessCollection:13,ctStartTripCountsCollection:14,ctStartTripCountsPausedCollection:15,ctOpenResult:16,ctOpenSurveyTab:17,ctOpenMemoryAnalysisTab:18,ctOpenFullMemoryAnalysisTab:19,ctOpenMAPTab:20,ctOpenCorrectnessTab:21,ctOpenTripCountsTab:22,ctOpenSuitabilityTab:23,ctPauseCollection:24,ctResumeCollection:25,ctStopCollection:26,ctCancelCollection:27,ctMarkCollection:28,ctMakeSnapshot:29,ctNewGroup:30,ctSeparator:31,ctCommandLine:32,ctStopAllCollections:33,ctCancelAllCollections:34,ctRefinalize:35,ctShowFloatCols:36,ctShowIntegerCols:37,ctShowIntegerAndFloatCols:38,ctCustomOpCols:39,ctShowL1Cols:40,ctShowL2Cols:41,ctShowL3Cols:42,ctShowL4Cols:43,ctShowDRAMCols:44,ctCustomMemCols:45,ctShowLoadsCols:46,ctShowStoresCols:47,ctShowLoadsAndStoresCols:48,ctExpandSubtree:49,ctShowWideInt:50,ctShowStrictInt:51,ctHideColumn:52,ctShowAllColumns:53,ctShowLayoutConfigurationDialog:54,ctOpenProjectProperties:55,ctRemodelCollection:56,ctUnknown:57,_names:["ctSimple","ctDrillDown","ctHelp","ctCopyToClipboard","ctRunCollection","ctStartPausedCollection","ctStartSurveyCollection","ctStartSurveyPausedCollection","ctStartSuitabilityCollection","ctStartSuitabilityPausedCollection","ctStartMemoryAnalysisCollection","ctStartFullMemoryAnalysisCollection","ctStartMAPCollection","ctStartCorrectnessCollection","ctStartTripCountsCollection","ctStartTripCountsPausedCollection","ctOpenResult","ctOpenSurveyTab","ctOpenMemoryAnalysisTab","ctOpenFullMemoryAnalysisTab","ctOpenMAPTab","ctOpenCorrectnessTab","ctOpenTripCountsTab","ctOpenSuitabilityTab","ctPauseCollection","ctResumeCollection","ctStopCollection","ctCancelCollection","ctMarkCollection","ctMakeSnapshot","ctNewGroup","ctSeparator","ctCommandLine","ctStopAllCollections","ctCancelAllCollections","ctRefinalize","ctShowFloatCols","ctShowIntegerCols","ctShowIntegerAndFloatCols","ctCustomOpCols","ctShowL1Cols","ctShowL2Cols","ctShowL3Cols","ctShowL4Cols","ctShowDRAMCols","ctCustomMemCols","ctShowLoadsCols","ctShowStoresCols","ctShowLoadsAndStoresCols","ctExpandSubtree","ctShowWideInt","ctShowStrictInt","ctHideColumn","ctShowAllColumns","ctShowLayoutConfigurationDialog","ctOpenProjectProperties","ctRemodelCollection","ctUnknown"],id2name:{0:"ctSimple",1:"ctDrillDown",2:"ctHelp",3:"ctCopyToClipboard",4:"ctRunCollection",5:"ctStartPausedCollection",6:"ctStartSurveyCollection",7:"ctStartSurveyPausedCollection",8:"ctStartSuitabilityCollection",9:"ctStartSuitabilityPausedCollection",10:"ctStartMemoryAnalysisCollection",11:"ctStartFullMemoryAnalysisCollection",12:"ctStartMAPCollection",13:"ctStartCorrectnessCollection",14:"ctStartTripCountsCollection",15:"ctStartTripCountsPausedCollection",16:"ctOpenResult",17:"ctOpenSurveyTab",18:"ctOpenMemoryAnalysisTab",19:"ctOpenFullMemoryAnalysisTab",20:"ctOpenMAPTab",21:"ctOpenCorrectnessTab",22:"ctOpenTripCountsTab",23:"ctOpenSuitabilityTab",24:"ctPauseCollection",25:"ctResumeCollection",26:"ctStopCollection",27:"ctCancelCollection",28:"ctMarkCollection",29:"ctMakeSnapshot",30:"ctNewGroup",31:"ctSeparator",32:"ctCommandLine",33:"ctStopAllCollections",34:"ctCancelAllCollections",35:"ctRefinalize",36:"ctShowFloatCols",37:"ctShowIntegerCols",38:"ctShowIntegerAndFloatCols",39:"ctCustomOpCols",40:"ctShowL1Cols",41:"ctShowL2Cols",42:"ctShowL3Cols",43:"ctShowL4Cols",44:"ctShowDRAMCols",45:"ctCustomMemCols",46:"ctShowLoadsCols",47:"ctShowStoresCols",48:"ctShowLoadsAndStoresCols",49:"ctExpandSubtree",50:"ctShowWideInt",51:"ctShowStrictInt",52:"ctHideColumn",53:"ctShowAllColumns",54:"ctShowLayoutConfigurationDialog",55:"ctOpenProjectProperties",56:"ctRemodelCollection",57:"ctUnknown"}},CommandInfo:{ciNone:0,ciRadio:1,ciEndGroup:2,_names:["ciNone","ciRadio","ciEndGroup"],id2name:{0:"ciNone",1:"ciRadio",2:"ciEndGroup"}}}},32466:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("section",{class:e.sectionClass},[t("header",[t("h4",{on:{click:function(t){e.isCollapsed=!e.isCollapsed}}},[e.icon?t("i",{class:e.icon}):e._e(),e._v(e._s(e.title)),e.value?t("span",[e._v(": ")]):e._e(),e._v(" "),t("b",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.tooltip,expression:"tooltip"}]},[e._v(e._s(e.value))])]),e._v(" "),t("hr"),e._v(" "),t("i",{staticClass:"icon",class:e.isCollapsed?"chevron-down":"chevron-up",on:{click:function(t){e.isCollapsed=!e.isCollapsed}}})]),e._v(" "),t("slide-transition",[t("div",{directives:[{name:"show",rawName:"v-show",value:!e.isCollapsed,expression:"!isCollapsed"}],staticClass:"content"},[e._t("default")],2)])],1)};o._withStripped=!0;const n={props:{title:{type:String,required:!0},value:String,tooltip:String,icon:String,nested:Boolean,collapsed:{type:Boolean,default:!1}},data(){return{isCollapsed:this.collapsed}},computed:{sectionClass(){return this.nested?"nested":void 0}}},s=(0,i(98822).A)(n,o,[],!1,null,"8e24daf2",null).exports},33014:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(83448),n=i(44164),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"6a8ca1ea",null).exports},33103:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>m});var o=function(){var e=this,t=e._self._c;return Object.keys(e.currentPerspective).length>0?t("div",{staticClass:"current-perspective"},[t("div",{staticClass:"common-knob-section"},[t("main-run-panel",{attrs:{commands:e.commands,analysisTypes:e.selectedAnalyzes}}),e._v(" "),e._l(e.visibleCommonKnobs,(function(i,o){return[t(e.getKnobComponent(i),{key:o,tag:"component",attrs:{knob:i,analysisTypes:e.analysisTypes,"enum-style":e.enumStyle},on:{onKnobChanged:e.onCommonKnobChanged}})]}))],2),e._v(" "),t("h3",[e._v(e._s(e.$t("analysis_types"))),t("i",{staticClass:"icon help-circle dark"})]),e._v(" "),t("div",{staticClass:"analysis-section"},e._l(e.analysisTypes,(function(i,o){return e.analysisShown(i.id)?t("analysis",{key:o,staticClass:"analysis",attrs:{analysisId:i.id},on:{"set-warning":e.updateWarningState,onKnobsChanged:function(t){return e.onKnobsChanged(i)}},scopedSlots:e._u([{key:"name",fn:function(){return[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:i.description,expression:"analysis.description",modifiers:{title:!0}}],staticClass:"label"},[t("span",{staticClass:"name"},[e._v(e._s(i.analysisName))]),e._v(" "),t("i",{staticClass:"icon help-circle dark"})])]},proxy:!0}],null,!0)},[t("analysis-status-icon",{attrs:{slot:"icon",status:e.analysisStatus(i.id),disabled:e.isAnalysisDisabled(i),checked:i.checked},on:{"on-icon-click":function(t){return e.toggleChecked(i)}},slot:"icon"})],1):e._e()})),1)]):e._e()};o._withStripped=!0,i(69212),i(43468),i(38333),i(45361),i(21602),i(60426);var n=i(75337),s=i(17807),r=i(84620),a=i(3861),l=i(81341),c=i.n(l),d=i(42612),p=i(33874);const u=e=>"a"+e,h={inject:["api"],data:()=>({currentPerspective:{},isWarning:!1,matchAnalysesToPreset:c()((function(){const{activePerspectiveId:e,analysisKnobs:t,presetIndex:i}=this,o=p.C.get(e,i),{analysisTypes:n=[]}=this.currentPerspective,s=p.C.values.find((e=>{const i=n.some((i=>{const n=o.preset(i.id);if(!n)return!1;if(i.checked!==n.checked[e])return!0;if(!i.checked)return!1;const s=t[i.id];if(!s)return!1;for(const t in n.knobs){var r;let i=n.knobs[t][e];if(void 0===i&&(i=s[t].defaultValue),(null===(r=s[t])||void 0===r?void 0:r.value)!==i)return!0}return!1}));return!i&&e}));s&&this.$store.commit("workflow/setAccuracyValue",{id:e,value:s}),this.$store.commit("workflow/setCustomAccuracy",!s)}),a.q8)}),methods:{getKnobComponent:e=>({overheadIndicator:"overhead-indicator",config:"target-panel",targetGPU:"target-panel",baselineDevice:"baseline-device-panel"}[e.id]||e.type||e.id),onCommonKnobChanged(e){this.commonKnobs[e.id]=e;const t=r.ProductMode.id2name[this.activePerspectiveId];this.api.workflow.send("common-knobs",{modeTag:t,knobs:this.commonKnobs})},analysisStatus(e){return this.$store.state.workflow.analysisStatus[e]},analysisShown(e){const t=p.C.get(this.activePerspectiveId,this.presetIndex).preset(e);return!(null!=t&&t.hidden)},updateCheckedActivities(){const{value:e,isCustomPreset:t,analysisTypes:i}=this;!t&&i&&i.forEach((t=>{const i=p.C.get(this.activePerspectiveId,this.presetIndex).preset(t.id);t.checked=i&&i.checked[e]}))},onKnobsChanged(e){e.checked&&this.matchAnalysesToPreset()},toggleChecked(e){e.checked=!e.checked,this.sendCheckedActivities(),this.matchAnalysesToPreset()},sendCheckedActivities(){const e=this.getChecked();if(e){const t=r.ProductMode.id2name[this.activePerspectiveId];this.api.workflow.send("checked-activities",{modeTag:t,checked:e})}},getChecked(){const e={},{analysisTypes:t=[]}=this.currentPerspective;return t.forEach((t=>e[u(t.id)]=t.checked)),t.length&&e},updateWarningState(e){this.isWarning=e},isAnalysisDisabled(e){return!(!this.isWarning||e.id!==r.ActivityType.atTripCounts||(e.checked=!1,0))}},computed:{...(0,n.mapState)("workflow",["accuracy","analysisKnobs"]),...(0,n.mapGetters)("workflow",["isReadOnly","presetIndex","isCustomPreset"]),...(0,n.mapGetters)("workflow",{value:"currentAccuracy"}),activePerspectiveId(){return this.$store.state.activePerspectiveId},selectedAnalyzes(){return(this.analysisTypes||[]).filter((e=>e.checked)).map((e=>e.id))},commonKnobs(){return this.currentPerspective.commonKnobs||{}},visibleCommonKnobs(){return(0,d.G_)(this.commonKnobs)},commands(){return this.currentPerspective.commands},analysisTypes(){return this.currentPerspective.analysisTypes},enumStyle:()=>"wf-target"},watch:{async activePerspectiveId(e){const t=this.getChecked(),i=r.ProductMode.id2name[e],o=await this.api.workflow.getPerspectiveDetails(e,i);t&&o.analysisTypes.forEach((e=>e.checked=!!t[u(e.id)])),this.currentPerspective=o,this.updateCheckedActivities()},isReadOnly(e){for(const t in this.commonKnobs)s.Ay.set(this.currentPerspective.commonKnobs[t],"readOnly",e)},accuracy:{handler:function(){this.updateCheckedActivities(),this.api.workflow.send("preset-enable",!this.isCustomPreset),this.sendCheckedActivities()},deep:!0}}},m=(0,i(98822).A)(h,o,[],!1,null,"4ffe4692",null).exports},33172:e=>{e.exports=' <h4>Add more parallel work</h4> <div class="text"> <div class="promo"> Add more parallel work to this region. For example, use a larger dataset or collapse nested loop iteration space. <ul><li> With <a href="https://www.intel.com/content/www/us/en/develop/documentation/get-started-with-cpp-fortran-compiler-openmp/top.html">OpenMP* Offload</a> programming model, you can collapse several nested loops into a logical iteration space width by using the <samp class="codeph">collapse(&lt;N&gt;)</samp> clause. </li></ul></div> <ul><li style="list-style-type:none"> See the <a href="https://www.openmp.org/spec-html/5.1/openmpsu48.html">OpenMP specification</a> for more details. </li></ul> <div class="promo"><ul><li style="list-style-type:none"> <p class="expander">Example of the OpenMP collapse clause:</p> <pre class="essential"><code class="cpp" data-source="\n        #pragma omp target teams distribute parallel for collapse(2) map(from: dst[0:imageW*imageH/BLOCK_SIZE]) map(to: colors[0:4]) \n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\n        #pragma omp target teams distribute parallel for collapse(2) map(from: dst[0:imageW*imageH/BLOCK_SIZE]) map(to: colors[0:4]) \n        for (int32_t iy = 0; iy < imageH; ++iy)\n        {\n            for (int32_t ixb = 0; ixb < imageW/BLOCK_SIZE; ++ixb)\n            {\n"></code></pre> </li></ul></div> </div> '},33202:(e,t,i)=>{"use strict";i.d(t,{Ay:()=>b,KE:()=>l,NI:()=>c,S3:()=>y,_Y:()=>f,mi:()=>g}),i(36094),i(69212),i(45361);var o={},n={},s=null;function r(e,t){var i=o[e];if(i&&i.process)try{i.process(function(e){return"string"==typeof e?new Function("return "+e)():e}(t))}catch(e){s={message:e.message,stack:e.stack,data:t},i.onerror&&i.onerror(e,t),console.error(e),console.log("Error data",t)}else"executeScript"===e?new Function(t)():void 0===i?(n[e]=n[e]||[]).push(t):console.error(`processing request '${e}' error`,i)}function a(e){const t=n[e];Array.isArray(t)&&(delete n[e],t.forEach((t=>r(e,t))))}function l(e,t){o[e]=t,setTimeout(a.bind(this,e),0)}function c(e){delete o[e]}var d,p,u="data-consumer-id",h="data-consumer-data",m="idvc_global_request";function f(e,t){if(!d||!e)return;let i=!1;window.idvcGlobalSender&&(i=window.idvcGlobalSender.sendNotification(e,t)),i||(e=void 0!==t?`${e}:${JSON.stringify(t)}`:e,d.setAttribute("href","callbackdata:"+e),d.click())}(p=document.createElement("div")).style.display="none",p.id=m,p.addEventListener("click",(function(e){var t=p.getAttribute(u);t&&r(t,p.getAttribute(h)),p.setAttribute(u,""),p.setAttribute(h,""),e.stopPropagation(),e.preventDefault()}),!0),document.body.appendChild(p),(d=document.createElement("a")).style.display="none",d.addEventListener("click",(function(e){e.stopPropagation()}),!0),document.body.appendChild(d);let v=0;function g(e,t={}){e=`${e}/${v++}`;const i=new Promise((t=>{l(e,{process:i=>{t(i),c(e)}})}));return f(e,t),i}var _={addConsumer:l,removeConsumer:c,removeConsumers:function(e){var t=[];Object.getOwnPropertyNames(o).forEach((function(i){0===i.indexOf(e)&&t.push(i)})),t.forEach((function(e){delete o[e]}))},receiveData:r,sendNotification:f,setNotificationSender:function(e){window.idvcGlobalSender=e},getResponse:g,getLastError:function(){return s},clearLastError:function(){s=null},getLastErrorMessage:function(){function e(e){return e?e+"\n":""}return s?e(s.message)+e(s.stack)+e(s.data):""},isRequestClick:function(e){return e&&(e===d||e.id===m)}};window.idvcGlobalRequest||(window.idvcGlobalRequest=_);const y=r,b=_},33352:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(43792),n=i(22088),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"0b20558b",null).exports},33705:e=>{e.exports=' <span id="unsupported_programming_model" class="disclaimer"> The programming model used in the code is unknown. If your code uses <a href="https://www.intel.com/content/www/us/en/develop/documentation/oneapi-programming-guide/top/oneapi-programming-model/data-parallel-c-dpc.html">Data Parallel C++ (DPC++)</a> or you are going to port it to DPC++, consider applying the following advice. <br> </span> '},33765:e=>{e.exports=' <h4>This loop is mostly compute bound but may also be memory bound</h4> <div class="text"> <div class="promo"> <span id="roofline_guidance"> <span id="fma_dominates"> The bottleneck depends heavily on the fused multiply-add (FMA) computational unit. </span> <span id="add_dominates"> The bottleneck depends greatly on the accessed computational unit. </span> <span id="below_dram"> The performance of the loop is also bounded by the DRAM bandwidth.<br/> </span> <span id="below_shared_cache"> The performance of the loop is also bounded by the bandwidth of the shared cache and DRAM.<br/> </span> <span id="below_private_cache"> The performance of the loop is also bounded by the private cache bandwidth.<br/> </span> <span id="bounded_by_l1"> The performance of the loop is also bounded by the L1 bandwidth.<br/> </span> <span id="bounded_by_l2"> The performance of the loop is also bounded by the L2 bandwidth.<br/> </span> <span id="bounded_by_l3"> The performance of the loop is also bounded by the L3 bandwidth.<br/> </span> <span id="bounded_by_l4"> The performance of the loop is also bounded by the L4 bandwidth.<br/> </span> <span id="bounded_by_dram"> The performance of the loop is also bounded by the DRAM bandwidth.<br/> </span> <span id="bounded_by_mcdram"> The performance of the loop is also bounded by the MCDRAM bandwidth.<br/> </span> <span id="is_vectorized"> <span id="isa_issue"> To improve performance: Switch from %c_isa% to %b_isa% - the highest available instruction set architecture (ISA). </span> <span id="inefficient_map"> <span id="more_ineff_map_info"> Eliminate inefficient memory access patterns. </span> </span> <span id="has_traits"> %traits% instructions might degrade performance. </span> </span> <span id="is_scalar"> The loop is scalar. To fix: Vectorize the loop. </span> </span> </div> <p class="expander">Read More</p> <ul class="expansion"> <span id="bad_traffic_impact"> <li> Data transferred between L1 and L2 cache levels (in cache lines) exceed CARM traffic between CPU registers and Memory subsystem (in bytes).<br/>This can be due to inefficient memory access pattern and cache line utilization. In this case, you only access a single element from a full cache line stored in L1.<br/> <img id="bad_traffic_img"/> </li> <li> <a href="docs:../help/index.htm#GUID-62A94516-242C-4B0C-9B4F-2ED08F61B146.html">Memory-Level Roofline</a> </li> </span> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul>  </div> '},33823:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>d});var o=function(){var e=this,t=e._self._c;return t("nav",[t("perspective-selector-header"),e._v(" "),t("div",{staticClass:"buttons"},[t("h2",[e._v(e._s(e.$t("gpu_modeling_title")))]),e._v(" "),t("img",{staticClass:"paths",attrs:{src:"assets/perspective-selector-paths.svg"}}),e._v(" "),t("h2",[e._v(e._s(e.$t("gpu_analysis_title")))]),e._v(" "),e._l(e.leftGroup,(function(i){return t("perspective-button",e._b({key:i.id,attrs:{selected:e.activePerspectiveId===i.id},on:{click:function(t){return e.onPerspectiveButtonClick(i.id)},dblclick:function(t){return e.onPerspectiveButtonDblClick(i.id)}}},"perspective-button",i,!1))})),e._v(" "),t("span"),e._v(" "),e._l(e.rightGroup,(function(i){return t("perspective-button",e._b({key:i.id,attrs:{selected:e.activePerspectiveId===i.id},on:{click:function(t){return e.onPerspectiveButtonClick(i.id)},dblclick:function(t){return e.onPerspectiveButtonDblClick(i.id)}}},"perspective-button",i,!1))})),e._v(" "),t("h2",{staticClass:"cpu-group"},[e._v(e._s(e.$t("cpu_perspectives_title")))]),e._v(" "),e._l(e.bottomGroup,(function(i){return t("perspective-button",e._b({key:i.id,attrs:{selected:e.activePerspectiveId===i.id},on:{click:function(t){return e.onPerspectiveButtonClick(i.id)},dblclick:function(t){return e.onPerspectiveButtonDblClick(i.id)}}},"perspective-button",i,!1))}))],2),e._v(" "),t("perspective-selector-footer",e._b({on:{choose:function(t){return e.onCloseSelector()}}},"perspective-selector-footer",e.activeButton,!1)),e._v(" "),t("spark-button",{staticClass:"close",attrs:{quiet:""},on:{click:function(t){return e.onCloseSelector()}}},[t("i",{staticClass:"icon cross"})])],1)};o._withStripped=!0,i(69212),i(43468),i(38333),i(21602);var n=i(84620),s=i(75337),r=i(65196),a=i(18977);const l=[{description:"perspective_vectorization_description",link:"perspective_vectorization_link",icon:"assets/vectorization-icon.svg",screen:"assets/vectorization-screen.png"},{description:"perspective_threading_description",link:"perspective_threading_link",icon:"assets/threading-icon.svg",screen:"assets/threading-screen.png"},{description:"perspective_offload_description",link:"perspective_offload_link",icon:"assets/offload-modeling-icon.svg",screen:"assets/offload-modeling-screen.png",color:"#EEF4E3"},{description:"perspective_gpu_description",link:"perspective_gpu_link",icon:"assets/gpu-roofline-icon.svg",screen:"assets/gpu-roofline-screen.png",color:"#F8ECEC"},{description:"perspective_cpu_roofline_description",link:"perspective_cpu_roofline_link",icon:"assets/cpu-roofline-icon.svg",screen:"assets/cpu-roofline-screen.png"}],c={mixins:[{created(){a.A.perspective_selector.buttonDblClick((e=>{const{perspectiveId:t}=e,i=n.ProductMode[t];return void 0===i?"Error: No Perspective id found":(this.onPerspectiveButtonDblClick(i),!0)}))}}],computed:{...(0,s.mapGetters)(["getAllPerspectives","activePerspectiveId"]),...(0,s.mapGetters)("workflow",["perspectiveStatus"]),buttons(){return this.getAllPerspectives.map((({value:e,displayValue:t})=>({id:e,name:t,...l[e]})))},activeButton(){return this.buttons.find((e=>e.id===this.activePerspectiveId))},leftGroup(){return this.buttons.filter((e=>e.id===n.ProductMode.pmOffload))},rightGroup(){return this.buttons.filter((e=>e.id===n.ProductMode.pmGPU))},bottomGroup(){const e=[n.ProductMode.pmVectorization,n.ProductMode.pmRoofline,n.ProductMode.pmThreading];return this.buttons.filter((t=>e.includes(t.id)))}},watch:{perspectiveStatus(e,t){"selector"===this.$route.name&&t===r.A2&&this.onCloseSelector()}},methods:{onPerspectiveButtonClick(e){this.$store.direct.commit.updateActivePerspectiveId(e)},onPerspectiveButtonDblClick(e){this.onPerspectiveButtonClick(e),this.onCloseSelector()},onCloseSelector(){this.$router.replace("/")}}},d=(0,i(98822).A)(c,o,[],!1,null,"5c6520c3",null).exports},33874:(e,t,i)=>{"use strict";i.d(t,{C:()=>a}),i(83038),i(88984),i(2449),i(66824),i(37271),i(16124),i(29590),i(69212),i(45361);var o=i(84620),n=i(77106);const s=JSON.parse('{"values":["low","medium","high"],"pmVectorization":{"defaultValue":"low","atSurvey":{"overhead":0.1,"checked":"low"},"atTripCounts":{"checked":"medium","knobs":{"trip_counts":{">=":"low","overhead":4},"flops_and_masks":{">=":"high","overhead":3},"stacks":{">=":"high","overhead":12}}},"atMap":{"overhead":10,"checked":"high"},"atCorrectness":{"overhead":75,"knobs":{"reduction_filtering":{"overhead":5}}}},"pmRoofline":{"defaultValue":"low","atSurvey":{"overhead":0.1,"checked":"low"},"atTripCounts":{"checked":"low","knobs":{"trip_counts":{">=":"medium","overhead":4},"flops_and_masks":{">=":"low","overhead":3},"enable_cache_simulation":{">=":"medium","overhead":15},"stacks":{">=":"medium","overhead":12}}},"atMap":{"overhead":10,"checked":"medium"},"atCorrectness":{"overhead":75,"knobs":{"reduction_filtering":{"overhead":5}}}},"pmThreading":{"defaultValue":"low","atSurvey":{"overhead":0.1,"checked":"low"},"atTripCounts":{"checked":"medium","knobs":{"trip_counts":{">=":"low","overhead":4},"flops_and_masks":{"overhead":3},"stacks":{"overhead":12}}},"atSuitability":{"overhead":3,"checked":"medium"},"atCorrectness":{"overhead":75,"checked":"medium","knobs":{"reduction_filtering":{"overhead":5}}}},"pmOffload":[{"defaultValue":"medium","atSurvey":{"overhead":0.1,"checked":"low","knobs":{"gpu_profiling":{"value":false,"hidden":true},"gpuSamplingInterval":{"hidden":true},"stackwalk":{"value":"offline"},"static_instruction_mix":{"value":true,"hidden":true}}},"atTripCounts":{"overhead":0.1,"checked":"low","knobs":{"gpu_profiling":{"value":false,"hidden":true},"track_memory_objects":{"value":false,"hidden":true},"track_stack_accesses":{"value":false,"hidden":true},"trip_counts":{">=":"low","overhead":4},"flops_and_masks":{">=":"low","overhead":3},"cache_simulation":{"medium":"single","high":"single","overhead":15},"stacks":{">=":"medium","overhead":12},"data_transfer":{"medium":"light","high":"medium","overhead":14}}},"atCorrectness":{"overhead":75,"checked":"high","knobs":{"markup":{"value":"gpu_generic"},"reduction_filtering":{"value":true,"overhead":5,"hidden":true},"loop_call_count_limit":{"value":16,"hidden":true}}},"atProjection":{"overhead":0.1,"checked":"low","knobs":{"gpu_profiling":{"value":false,"hidden":true},"assume_dependencies":{">=":"high"},"assume_hide_taxes":{},"data_reuse_analysis":{}}}},{"defaultValue":"medium","atSurvey":{"overhead":0.1,"checked":"low","knobs":{"stackwalk":{"value":"offline","hidden":true},"static_instruction_mix":{"value":false,"hidden":true},"gpu_profiling":{">=":"low","overhead":0.2},"gpuSamplingInterval":{"value":0.1,"hidden":false}}},"atTripCounts":{"checked":"low","overhead":0.1,"knobs":{"stacks":{"value":false,"hidden":true},"cache_simulation":{"value":"off","hidden":true},"gpu_profiling":{">=":"low","overhead":0.2},"trip_counts":{">=":"low","overhead":4},"flops_and_masks":{">=":"low","overhead":3},"track_memory_objects":{">=":"medium","overhead":4},"track_stack_accesses":{"value":false,"hidden":true},"data_transfer":{"medium":"light","high":"medium","overhead":14}}},"atCorrectness":{"hidden":true},"atProjection":{"overhead":0.1,"checked":"low","knobs":{"gpu_profiling":{">=":"low","overhead":0.2},"assume_dependencies":{"value":false,"hidden":true},"assume_hide_taxes":{},"data_reuse_analysis":{}}}}],"pmGPU":{"defaultValue":"low","atSurvey":{"overhead":0.1,"checked":"low","knobs":{"gpu_profiling":{">=":"low","overhead":0.2},"targetGPU":{">=":"low","hidden":true}}},"atTripCounts":{"checked":"low","knobs":{"trip_counts":{">=":"high","overhead":4},"flops_and_masks":{">=":"low","overhead":3},"enable_cache_simulation":{">=":"high","overhead":15},"stacks":{">=":"high","overhead":12},"gpu_profiling":{">=":"low","overhead":2},"targetGPU":{">=":"low","hidden":true},"data_transfer":{"medium":"light","high":"medium","overhead":14},"track_memory_objects":{">=":"medium","overhead":4}}},"atProjection":{"overhead":0.1,"checked":"low"}}}');function r(e,t){let i=!1;e.forEach((e=>{t[e]?i=!0:t[e]=i}))}const a=function(){const e={...s,allKnobs:new Set("")},t=new Set(o.ProductMode._names),i=new Set(o.ActivityType._names);for(const o in e)t.has(o)&&(Array.isArray(e[o])?e[o]:[e[o]]).forEach((t=>{for(const o in t){if(!i.has(o))continue;const n=t[o];n.checked=n.checked?{[n.checked]:!0}:{},r(e.values,n.checked),n.knobs=n.knobs||{},Object.keys(n.knobs).forEach((t=>{e.allKnobs.add(t);const i=n.knobs[t],o=i[">="];o?(i[o]=!0,r(e.values,i),delete i[">="]):void 0!==i.value&&(e.values.forEach((e=>i[e]=i.value)),delete i.value)}))}}));return(0,n.deepVisitor)(e,(e=>t.has(e)?o.ProductMode[e]:i.has(e)?o.ActivityType[e]:e)),{get(t,i=0){const o=e[t],n=Array.isArray(o)?o[i]:o;return n||console.error(`preset for "${t}" is not implemented`),{get defaultValue(){return n.defaultValue},preset:e=>n[e]||{hidden:!0,checked:{},knobs:{}}}},get values(){return e.values},get allKnobs(){return e.allKnobs}}}()},34049:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>d});var o=function(){var e=this,t=e._self._c;return t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.buttonTooltip,expression:"buttonTooltip"}],staticClass:"buttons",class:{disabled:e.isNoData&&!e.getOffloadFilterData.isFilterEnabled}},[t("div",{staticClass:"buttons-set",on:{click:function(t){return e.selectNext()}}},e._l(e.buttons,(function(e,i){return t("a",{key:i,staticClass:"icon",class:[e.icon,e.class,e.extraClass]})})),0),e._v(" "),t("dropdown",{attrs:{knob:e.convertOffloadFilterListToKnob,"enum-style":e.enumStyle},on:{onKnobChanged:({value:t})=>e.currentFilter=t}})],1)};o._withStripped=!0,i(69212),i(38333);var n=i(81341),s=i.n(n),r=i(75337);const a=JSON.parse('{"Ye":{"class":"default-button cpu-left","icon":"cpu solid","extraClass":""},"n8":{"class":"line","icon":"minus","extraClass":""},"EM":{"class":"default-button gpu-right","icon":"cpu","extraClass":""},"in":{"class":"default-button gpu-right","icon":"gpu","extraClass":""},"ZC":{"class":"default-button cpu-right","icon":"cpu","extraClass":""}}');var l=i(18977);const c={inject:["api"],mixins:[{created(){l.A.offload.onButtonOffloadClick((e=>{const{value:t}=e;this.currentFilter=t}))}}],props:{isNoData:{type:Boolean}},data(){return{currentFilter:2,offloadFilterStates:[{description:this.$t("filter_offloaded_description"),displayValue:this.$t("filter_offloaded_name"),selected:!1,value:0},{description:this.$t("filter_non_offloaded_description"),displayValue:this.$t("filter_non_offloaded_name"),selected:!1,value:1},{description:this.$t("filter_all_description"),displayValue:this.$t("filter_all_name"),selected:!1,value:2}],triggerFilter:s()((function(){this.api.header.send("offload-filter",this.currentFilter),this.$store.direct.commit.offload.setOffloadFilterStatus({id:this.currentFilter,enabled:2!==this.currentFilter})}),300)}},computed:{...(0,r.mapGetters)("offload",["getOffloadFilterData"]),buttons(){switch(this.currentFilter){case 0:default:return[a.Ye,a.n8,a.in];case 1:return[a.Ye,a.n8,a.EM];case 2:return[a.Ye,a.n8,a.in,a.ZC]}},convertOffloadFilterListToKnob(){return{name:"",id:"",readOnly:!1,items:this.offloadFilterStates,value:this.currentFilter}},enumStyle:()=>"h-filter",buttonTooltip(){return this.offloadFilterStates.find((e=>e.value===this.currentFilter)).description}},methods:{selectNext(){this.currentFilter=(this.currentFilter+1)%this.offloadFilterStates.length,this.triggerFilter()}},watch:{currentFilter:function(){this.triggerFilter()}}},d=(0,i(98822).A)(c,o,[],!1,null,"d79e8a70",null).exports},34800:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"metric"},[e.color?t("div",{style:{background:e.color},attrs:{name:"color"}}):e._e(),e._v(" "),e.title?t("span",{attrs:{name:"title"}},[e._v(e._s(e.title)+":\n    "),e.tooltip?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.tooltip,expression:"tooltip"}],staticClass:"icon help-circle"}):e._e()]):e._e(),e._v(" "),e.value?t("span",{attrs:{name:"value"}},[e._v(e._s(e.value))]):e._e()])};o._withStripped=!0;var n=i(89564);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"5fc43068",null).exports},34839:e=>{e.exports=' <h4>Compiler lacks sufficient information to vectorize loop</h4> <div class="essential"> Cause: You are using a non-Intel compiler or an outdated Intel compiler. Nevertheless, it appears there are no issues preventing vectorization and vectorization may be profitable. </div>'},34919:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(73738),n=i(88659),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"3cb07172",null).exports},35031:e=>{e.exports=' <h4>Change the chunk size</h4> <div class="text"> <div class="promo"> The loop is threaded and vectorized using the <samp class="codeph">!$omp parallel for simd</samp> directive, which parallelizes the loop with both threads and SIMD instructions. Specifically, the directive divides loop iterations into chunks (subsets) and distributes the chunks among threads, then chunk iterations execute concurrently using SIMD instructions. In this case, the chunk size (number of iterations per chunk) is not a multiple of <span data-glossary-id="vector_length">vector length</span>. To fix: Add a <samp class="codeph">schedule (simd: [kind])</samp> modifier to the <samp class="codeph">!$omp parallel for simd</samp> directive. <p class="expander">Example</p> <div class="expansion"> Guarantee a multiple of <span data-glossary-id="vector_length">vector length</span>. <pre><code class="fortran">!$omp parallel do simd schedule(simd: static)\ndo i = 1,1000\n    c(i) = a(i)*b(i)\nend do\n!$omp end parallel do simd</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="http://www.openmp.org/mp-documents/openmp-4.5.pdf">OpenMP Application Programming Interface</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},35044:function(e,t,i){"use strict";i(69212),i(38333),i(21602);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(40941)),s=i(75337),r=i(77106),a=i(1067),l=o(i(25405)),c={data:()=>({compact:!1}),computed:{...(0,s.mapGetters)("gpu",["getGpuPerformanceCharData","getCpuPerformanceCharData"]),data(){const e=this.getCpuPerformanceCharData,t=(e.cpuTime||{}).value;return Object.entries(e).map((([e,i])=>({id:e,title:i.title,formattedValue:(0,r.formatNumber)(i),percentValue:t?(0,r.formatNumber)({value:100*i.value/t,type:"f",digits:0,postfix:"%"}):void 0,values:[i.value/t],colors:[l.default[e]]})))},compactData(){return this.data.find((e=>"cpuTimeVectorizedLoops"===e.id))},flex(){return{flex:[{[a.GPU]:1,[a.CPU]:1},{[a.GPU]:1,[a.CPU]:4},{[a.GPU]:4,[a.CPU]:1},{[a.GPU]:2,[a.CPU]:1}][2*+(this.getGpuPerformanceCharData.length>0)+ +(Object.keys(this.getCpuPerformanceCharData).length>0)][a.CPU]}}},methods:{onCollapsed(e){this.compact=e}},components:{LayoutPanelCard:n.default}};t.default=c},35144:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this;return(0,e._self._c)("div",{staticClass:"scrollable",class:{"fit-parent":e.fitParent}},[e._t("default")],2)};o._withStripped=!0;const n={props:{fitParent:Boolean}},s=(0,i(98822).A)(n,o,[],!1,null,"ff57a3ac",null).exports},35418:e=>{e.exports=' <h4>Roofline conclusions</h4> <div class="essential"> Conclusions, with optimization recommendations, are sorted by relevance. <div id="roofline" class="padding"> <img id="plot_img"/> <span id="code_analytics_link"> You can switch to the Code Analytics tab to see a more detailed Roofline plot </span> </div> </div> '},35439:(e,t,i)=>{"use strict";i.d(t,{B1:()=>y,BI:()=>w,CU:()=>m,Ez:()=>h,KE:()=>r,OG:()=>v,Q$:()=>n,T5:()=>l,UP:()=>f,VY:()=>u,al:()=>b,fx:()=>c,on:()=>_,pA:()=>a,t9:()=>s,tC:()=>d,tN:()=>x,uR:()=>p}),i(36094),i(69212),i(45361);var o=i(33202);const n="toolbar/button",s="welcome/button",r="welcome/name",a="welcome/mru",l="welcome/current",c="workflow/analysis/update",d="workflow/knobs/update",p="workflow/analysis/runMRU",u="open-perspective",h="idvc-splitter",m="data-loaded",f="switch-view",v="log/message",g={},_=e=>({add(t){g[e]?g[e].push(t):(g[e]=[t],(0,o.KE)(e,{process:t=>g[e].forEach((e=>e(t)))}))},remove(t){g[e]&&(g[e].splice(g[e].indexOf(t),1),g[e].length||((0,o.NI)(e),delete g[e]))}}),y=(e,t)=>_(e).add(t),b=(e,t)=>_(e).remove(t),w=(e,t)=>(0,o.S3)(e,t),x=(e,t)=>(0,o._Y)(e,t)},35993:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>o});const o="data:image/png;base64,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"},36470:(e,t,i)=>{"use strict";i(83038),i(88984),i(2449),i(66824),i(37271),i(16124),i(29590),i(69212),i(43468),i(21602),Object.defineProperty(t,"B",{value:!0});const o=i(77106),n=i(36750),s={props:{id:{type:String,required:!0},data:{type:Array,required:!0},showDataType:Boolean},data:()=>({editedFilter:null,filters:{}}),created(){this.formatNumber=o.formatNumber},computed:{rowsFiltered(){return this.data.filter((e=>{const{instruction:t,dataType:i}=e,{title:o}=i,{instruction:n,dataType:s}=this.filters;return(!n||n.includes(t))&&(!s||s.includes(o))}))},totalFiltered(){const{isFilterSet:e}=this;if(!e("instruction")&&!e("dataType"))return;const t=(0,n.aggField)(this.rowsFiltered,"instructionCount");return(0,o.formatNumber)(t)}},methods:{isFilterSet(e){const t=this.getFilterItems(e),i=this.filters[e];return i&&i.length!==t.length},getFilterItems(e){let t;switch(e){case"instruction":t=this.data.map((t=>t[e]));break;case"dataType":t=this.data.map((t=>t[e].title));break;default:t=[]}return[...new Set(t)]},getFilterClass(e){return this.isFilterSet(e)?"icon filter solid":"icon filter"},onFilterClick(e){let t;switch(e){case"instruction":t=this.$t("instruction-mix-details-instruction");break;case"dataType":t=this.$t("instruction-mix-details-data-type")}const i=this.getFilterItems(e);this.editedFilter={column:e,title:t,items:i,filter:this.filters[e]||[...i]}},onFilterUpdated(e){this.editedFilter.filter=e},onFilterApplied(e,t){this.filters={...this.filters,[e]:t},this.onFilterClosed()},onFilterClosed(){this.editedFilter=null}}};t.A=s},36632:e=>{e.exports=' <h4>Inefficient processing of SIMD-enabled functions possible</h4> <div class="essential"> Vector declaration defaults for your SIMD-enabled functions may result in extra computations or ineffective memory access patterns. Improve performance by overriding defaults. </div>'},36732:e=>{e.exports=' <h4>Explicitly enable FMA generation when using the strict floating-point model</h4> <div class="text"> <p class="promo"> Static analysis presumes the loop may benefit from <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a> instructions available with the AVX2 ISA, but the <samp class="codeph">strict</samp> floating-point model disables FMA instruction generation by default. To fix: Override this behavior using the <samp class="codeph">fma</samp> compiler option. </p> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /Qfma </td> <td> -fma </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li><a href="docs:C++/17/index.htm#GUID-969A5F48-C013-4313-B513-77ED872541C8.html"> fma, Qfma</a></li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/floating-point-operations.html">Floating-Point Operations</a> and <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html"> Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},36750:(e,t,i)=>{"use strict";function o(e,t){return e.reduce(((e,i)=>{const o=i[t]||i;return{...o,value:o.value+e.value}}),{value:0})}function n(e,t){return e.reduce(((e,i)=>((e[i[t]]=e[i[t]]||[]).push(i),e)),{})}i.r(t),i.d(t,{aggField:()=>o,groupBy:()=>n}),i(36094),i(27468),i(69212),i(32204)},36851:(e,t,i)=>{"use strict";var o=i(61262);i(69212),i(45361);var n=i(77106),s=i(18323),r=i(33202),a=i(17807);(0,r.mi)("get-message-catalog",["discclient.knobs","discclient.loader","discclient.core","discclient.roofline","discclient.panes"]).then((e=>{e||console.error("No messages: probably wrong unicode symbol. Check xmc catalog.");for(const t in e)s.A.addMessage(t,e[t])}));const l={data:()=>({translated_:{}}),methods:{_translate(e,t){if(e in this.translated_)return this.translated_[e];const i=this._processing_message||(e=>`%${e}%`);return a.Ay.set(this.translated_,e,i(e)),this._get_message(e,t),this.translated_[e]},async _get_message(e,t){const i=await(0,r.mi)("translate",{id:e});s.A.addMessage(e,i),this.translated_[e]=(0,n.applyParams)(i,t)}},beforeCreate(){a.Ay.prototype.$t=(e,...t)=>void 0===e?"...":(s.A.hasMessage(e)&&a.Ay.set(this.translated_,e,(0,n.applyParams)(s.A.getMessage(e),t)),this._translate(e,t))}};i(43468);const c=i(8686),d=["./code-analytics/"];c.keys().filter((e=>!d.some((t=>e.includes(t))))).forEach((e=>{const t=c(e),i=e.replace(/.*\/([\w-]+)\.\w+/,"$1");a.Ay.component(i,t.default||t)}));const p=new a.Ay;Object.defineProperties(a.Ay.prototype,{$bus:{get:()=>p}}),i(64180),i(36094);const u=[];function h(e){u.forEach((t=>{const{el:i,value:o,modifiers:n}=t;(n.bubble||!i.contains(e.target)&&i!==e.target)&&o(e)}))}const m={bind:(e,{value:t,modifiers:i})=>{if("function"!=typeof t)throw new Error("v-click-outside: Binding value must be a function");u.push({el:e,value:t,modifiers:i}),1===u.length&&document.addEventListener("click",h,!0)},unbind:e=>{const t=u.findIndex((t=>t.el===e));t>=0&&(u.splice(t,1),u.length||document.removeEventListener("click",h,!0))}},f={install(e){e.directive("click-outside",m)}};var v=i(40838);function g(e,t){const{value:i,oldValue:o,modifiers:n,arg:s=3e4}=t;if(null!==i&&i!==o)if(n.title)e.title=document.createRange().createContextualFragment(i).textContent;else{const t={...n,autoHideDelay:s};(0,v.A)(e,i,t)}}a.Ay.directive("tooltip",{bind:g,update:g,unbind:v.w}),a.Ay.use(f);var _=i(83230),y=function(){var e=this,t=e._self._c;return t("main",[t("workflow",{on:{"on-close":function(t){return e.hideSidebar()}}}),e._v(" "),t("idvc-splitter",{ref:"splitter",attrs:{size:e.sidebarWidth,"min-size":160,"fold-primary":""},on:{changed:e.updateSplitter}}),e._v(" "),t("section",[t("transition",{attrs:{name:"fade"}},[t("keep-alive",[t("router-view",{key:e.$route.name})],1)],1)],1)],1)};y._withStripped=!0;var b=i(84620),w=i(18977);const x={created(){w.A.offload.summaryTabClick((e=>{this.$router.push({name:"offload:summary"}).catch((({message:e})=>console.error(e)))}))}},C={created(){w.A.offload.saveRemodelingConfiguration((e=>{this.$el.querySelector('[class="icon download"]').click()}))}},A={created(){w.A.gpu_roofline.clickGPUMainView((e=>{this.$router.push({name:"gpu:main"}).catch((({message:e})=>console.error(e)))}))}},S={created(){w.A.offload.sourceTabClick((e=>{this.$router.push({name:"offload:source"}).catch((({message:e})=>console.error(e)))}))}},T={created(){w.A.offload.clickAcceleratedRegions((e=>{this.$router.push({name:"offload:accelerated-regions"}).catch((({message:e})=>console.error(e)))}))}},I={created(){w.A.gpu_roofline.clickGPUSummary((e=>{this.$router.push({name:"gpu:summary"}).catch((({message:e})=>console.error(e)))}))}},P={},M={inject:["api"],mixins:[T,A,S,{created(){w.A.offload.logsTabClick((e=>{this.$router.push({name:"offload:log"}).catch((({message:e})=>console.error(e)))}))}},{created(){w.A.gpu_roofline.sourceTabClick((e=>{this.$router.push({name:"gpu:source"}).catch((({message:e})=>console.error(e)))}))}},{created(){w.A.gpu_roofline.logsTabClick((e=>{this.$router.push({name:"gpu:log"}).catch((({message:e})=>console.error(e)))}))}},x,I,C],data:e=>({sidebarWidth:330}),computed:{activePerspectiveId(){return this.$store.state.activePerspectiveId}},watch:{activePerspectiveId:"updatePerspective",$route(e){const t=e.matched[0]&&e.matched[0].path;P[t]=e.path,this.api.send("update-help-id",e.name),"/"===e.path&&(this.openPane(b.HtmlPane.hpWorkflow),this.updatePerspective(this.activePerspectiveId))}},methods:{isFeatureEnabled(e){return this.$store.direct.getters.isFeatureEnabled(e)},updatePerspective(e){if("/selector"===this.$router.currentRoute.path||null===e)return;let t=!1;switch(e){case b.ProductMode.pmOffload:this.openRoute("/offload");break;case b.ProductMode.pmGPU:this.openRoute("/gpu");break;case b.ProductMode.pmRoofline:if(this.isFeatureEnabled("html_ui")){this.openRoute("/roofline");break}default:t=!0}this.hideSecondaryTimeout&&(clearTimeout(this.hideSecondaryTimeout),delete this.hideSecondaryTimeout),t?this.hideSecondaryTimeout=setTimeout((()=>{this.splitter.hideSecondary(),delete this.hideSecondaryTimeout}),100):this.showResultArea(),this.api.workflow.send("switch-perspective",{mode:e})},openRoute(e){const t=P[e]||e;0!==this.$router.currentRoute.path.indexOf(t)&&this.$router.push(t).catch((({message:e})=>console.error(e)))},updateSplitter(e){this.api.send("update-splitter",parseInt(e)*window.devicePixelRatio)},openPane(e){switch(e){case b.HtmlPane.hpSelectorFullWidth:this.hideSidebar();case b.HtmlPane.hpSelector:this.openRoute("/selector"),this.showResultArea();break;case b.HtmlPane.hpWorkflow:this.showSidebar()}},togglePane(e){switch(e){case b.HtmlPane.hpSelectorFullWidth:this.hideSidebar();case b.HtmlPane.hpSelector:const t="/selector",{$router:i}=this;i.currentRoute.path===t?i.replace("/"):this.openPane(e);break;case b.HtmlPane.hpWorkflow:this.toggleSidebar()}},resultAreaFolded(){return this.splitter.isSecondaryFolded()},showResultArea(){this.resultAreaFolded()&&(!this.splitter.isPrimaryFolded()&&this.splitter.unfold()||this.splitter.showSecondary())},hideSidebar(){this.resultAreaFolded()?this.api.send("close-side-panel"):this.splitter.foldPrimary()},removeSidebar(){this.splitter.foldPrimary(!0)},toggleSidebar(){this.resultAreaFolded()?this.api.send("toggle-side-panel"):this.splitter.isPrimaryFolded()?this.splitter.unfold():this.splitter.foldPrimary()},showSidebar(){this.splitter.isPrimaryFolded()&&this.splitter.unfold()}},async created(){this.api.onSplitterChange((e=>{this.sidebarWidth=e/window.devicePixelRatio,e&&this.splitter.isPrimaryFolded()&&this.splitter.isSecondaryFolded()?(this.splitter.unfold(),this.splitter.foldSecondary(!0)):e||(this.splitter.foldPrimary(),this.splitter.hideSecondary())})),this.api.subscribe("open-pane",(e=>this.openPane(e))),this.api.subscribe("toggle-pane",(e=>this.togglePane(e)));const e=await this.api.layout.loadState();e&&this.$store.direct.dispatch.layout.assignLayoutState(e);const t=await this.api.get("loadFeatures");this.$store.direct.dispatch.setEnabledFeatures(t)},mounted(){this.splitter=this.$refs.splitter.get()}},E=M;var L=i(98822);const R=(0,L.A)(E,y,[],!1,null,"4b0bcff0",null).exports;var D=i(3741),k=function(){var e=this,t=e._self._c;return t("section",{on:{mousedown:e.clickHandler}},[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-offload-filter",{attrs:{isNoData:e.isMainGridEmpty}}),e._v(" "),t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report"),e._v(" "),t("button-add",{attrs:{panelType:e.view}})]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"}),e._v(" "),t("header-metric-block",{attrs:{slot:"metrics",metricsData:e.getFilteredOffloadHeaderMetrics},slot:"metrics"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),t("scrollable-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}],attrs:{fitParent:""}},[e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),t("layout-container",{attrs:{direction:"column",guideSizes:["70%",null],dimensions:2}},[t("idvc-grid",{key:e.gridId,ref:"bottomUpGrid",attrs:{caption:e.$t("acc_regions_grid"),size:"70%","request-id":e.gridId,"rows-height-model":"freeRowsHeight","selection-id":e.selectionId,cellPainters:e.offloadPainters,columnLayouts:e.offloadColumnLayouts,contextMenu:e.gridContextMenu},on:{gridDblClick:e.openSourceView}}),e._v(" "),t("roofline",{key:e.rooflineId,attrs:{tabToSlot:"0","constant-roofs":"","roofline-id":e.rooflineId,"selection-id":e.selectionId,caption:`<i class='icon graph-chart light'></i> ${e.$t("roofline")}`,name:"roofline",size:"70%","excluded-extensions":["zones"]}}),e._v(" "),t("idvc-source-view",{key:e.sourceId,attrs:{caption:e.$t("acc_regions_source"),"request-id":e.sourceId,"selection-id":e.selectionId,contextMenu:e.gridContextMenu}}),e._v(" "),t("idvc-grid",{key:e.topDownId,attrs:{caption:e.$t("acc_regions_top_down"),panelState:"collapsed",tabToSlot:"2","request-id":e.topDownId,"rows-height-model":"freeRowsHeight","selection-id":e.selectionId,"no-set-current-row":"",cellPainters:e.offloadPainters,columnLayouts:e.offloadColumnLayouts,contextMenu:e.gridContextMenu},on:{gridDblClick:e.openSourceView}}),e._v(" "),t("recommendation-pane",{key:e.recommendationsId,attrs:{caption:`<i class='icon bulb light'></i> ${e.$t("recommendation_pane_title")}`,tabToSlot:"2",name:"#recommendation-pane","request-id":e.recommendationsId,"selection-id":e.selectionId}}),e._v(" "),t("offload-details-block",{attrs:{caption:e.$t("acc_regions_details"),"selection-id":e.selectionId}}),e._v(" "),t("data-transfer-block",{key:e.dataTransferId,attrs:{caption:e.$t("acc_regions_data_transfer"),tabToSlot:5,"request-id":e.dataTransferId,"selection-id":e.selectionId}})],1)],1)],1)};k._withStripped=!0;var O=i(75337),N=i(94722);function z(e){return{data:()=>({dataLoadedHash:void 0}),computed:{...(0,O.mapGetters)(e,["getDataLoadedHash"])},watch:{dataLoadedHash(){this.processDataLoaded&&this.processDataLoaded(),(0,N.raiseRefreshEvent)({sender:this,dataLoaded:!0})}},created(){this.dataLoadedHash=this.getDataLoadedHash},activated(){this.dataLoadedHash=this.getDataLoadedHash,this.unwatchDataLoaded=this.$watch("getDataLoadedHash",(e=>this.dataLoadedHash=e))},deactivated(){this.unwatchDataLoaded()}}}var B=i(57721);const V={created(){w.A.offload.loopSelection((e=>{const{value:t}=e,i=t;this.$store.direct.commit.setSelection({id:"offload/accelerated-regions/selection",senderId:"offloadSummary",rowId:i})}))}};var G=i(38235),F=i(96456),U=i(1919),H=i(82488);const j={paint(e,t,i,o,n){if(!e)return"";if(!n)return e;if(void 0===n._offloadedColumnIndex&&(n._offloadedColumnIndex=n.indexOfColumn((e=>"fdOffloadSummary"===e.type))),n._offloadedColumnIndex>=0){let i=n.getRawData(t,n._offloadedColumnIndex);if("string"==typeof i&&i.startsWith("{")&&(i=JSON.parse(i),i.device)){const t=(0,F.xO)(i.device),o=`<i class="${t.clsName}" style="${t.style}; vertical-align:middle;"\n            ${U.A.CellTooltipAttr}="${i.offload||""}"></i> ${e}`;return t.isGPU?o:{innerHTML:o,classNames:["idvc2_grid_inactive_cell"]}}}return e}},Y={mixins:[z("offload"),V],data:()=>({view:"offload:accelerated-regions",eventName:G.OFFLOAD_LOG,isMainGridEmpty:!0,offloadPainters:{fdFunctionName:j},offloadColumnLayouts:{fdSpeedUp:F.Fd,fdOffloadBoundedBy:F.Fd,fdRegionType:F.dU,fdIterationSpace:F.dU}}),computed:{...(0,O.mapGetters)("offload",["getOffloadHeaderMetricsData","getOffloadFilterData"]),...(0,O.mapGetters)("log",["isCollectionFinalizing","isRecommendationsVisibleInView","isTopSliderOverlapsView"]),isDisabled(){return this.isCollectionFinalizing(this.eventName)},selection(){return this.$store.direct.getters.getSelection(this.selectionId)},getFilteredOffloadHeaderMetrics(){return this.getOffloadHeaderMetricsData.filter((e=>e.id!==H.s))}},created(){this.gridId="offload/accelerated-regions/grid",this.sourceId="offload/accelerated-regions/source",this.dataTransferId="offload/accelerated-regions/data-transfer",this.topDownId="offload/accelerated-regions/top-down",this.recommendationsId="offload/accelerated-regions/recommendations",this.rooflineId="offload/accelerated-regions/roofline",this.selectionId="offload/accelerated-regions/selection",this.gridContextMenu=[{caption:this.$t("view_source"),command:this.openSourceView},{caption:this.$t("edit_source"),noReport:!0,command:this.drillDownNativeSource}]},mounted(){this.unwatchNoData=this.$watch("$refs.bottomUpGrid.isNoData",(e=>this.isMainGridEmpty=e))},beforeDestroy(){this.unwatchNoData()},methods:{async getSource(){const{rowId:e}=this.selection||{};if(e)return await _.default.get(this.sourceId,"update-source",{rowId:(0,B.getCurrentRowId)(e)})},async openSourceView(){const{selection:e}=this,t=await this.getSource();t&&"found"===t.state&&this.$router.push({name:"offload:source",params:{source:t,selection:e}}).catch((({message:e})=>console.error(e)))},async drillDownNativeSource(){const e=await this.getSource();e&&"found"===e.state&&_.default.send("openNativeSource",e)},clickHandler(e){var t;const{view:i}=this,o=null==e||null===(t=e.target)||void 0===t?void 0:t.hash;o&&this.$store.direct.dispatch.layout.activateTab({view:i,name:o})}},watch:{getOffloadFilterData(){!async function(e){e&&await e.refresh()}(this.$refs.bottomUpGrid)}}},W=Y,X=(0,L.A)(W,k,[],!1,null,"0dc4d5d0",null).exports;var q=function(){var e=this,t=e._self._c;return t("section",{attrs:{"data-idvc-namespace":"code-analytics"}},[t("layout",{attrs:{direction:"row",dimensions:3}},[t("traits-summary-block",{attrs:{caption:e.$t("traits-summary"),compactHeight:100}}),e._v(" "),t("roofline-guidance-block",{attrs:{caption:e.$t("roofline-guidance")}}),e._v(" "),t("code-optimizations-block",{attrs:{caption:e.$t("code-optimizations"),compactHeight:100}}),e._v(" "),t("efficiency-summary-block",{attrs:{caption:e.$t("efficiency-summary"),compactHeight:100}}),e._v(" "),t("flops-summary-block",{attrs:{caption:e.$t("flops-summary"),compactHeight:100}}),e._v(" "),t("func-summary-block",{attrs:{caption:e.$t("func-summary"),compactHeight:100}}),e._v(" "),t("instr-mix-block",{attrs:{caption:e.$t("instr-mix")}}),e._v(" "),t("loop-summary-block",{attrs:{caption:e.$t("loop-summary"),compactHeight:100}}),e._v(" "),t("memory-metrics-block",{attrs:{caption:e.$t("memory-metrics"),compactHeight:100}}),e._v(" "),t("memory-summary-block",{attrs:{caption:e.$t("memory-summary"),compactHeight:100}}),e._v(" "),t("trip-count-summary-block",{attrs:{caption:e.$t("trip-count-summary")}})],1)],1)};q._withStripped=!0,i(20095),i(92573),i(30241);var Z=i(6195);i(91452),i(40187),i(38649);var Q=i(92425);window.qs=(e,t)=>(t||document).querySelector(e),window.qsa=(e,t)=>(t||document).querySelectorAll(e),window.$on=(e,t,i,o)=>(i||window).addEventListener(e,t,!!o),window.$off=(e,t,i,o)=>(i||window).removeEventListener(e,t,!!o),window.$detach=function(e,t){return t=t||0,window.setTimeout(e,t)},window.$invoke=(e,t)=>{const i=window.document.createEvent("UIEvents");i.initUIEvent(e,!0,!1,window,0),(t||window).dispatchEvent(i)};const K=[];window.HTMLElement.prototype.Visible=function(e){"none"!=this.style.display&&(K[this]=this.style.display),this in K||(K[this]="block"),this.style.display=e?K[this]:"none"};const $={components:{Layout:Z.Layout,CodeOptimizationsBlock:Q.CodeOptimizationsBlock,EfficiencySummaryBlock:Q.EfficiencySummaryBlock,FlopsSummaryBlock:Q.FlopsSummaryBlock,FuncSummaryBlock:Q.FuncSummaryBlock,InstrMixBlock:Q.InstrMixBlock,LoopSummaryBlock:Q.LoopSummaryBlock,MemoryMetricsBlock:Q.MemoryMetricsBlock,MemorySummaryBlock:Q.MemorySummaryBlock,RooflineGuidanceBlock:Q.RooflineGuidanceBlock,TraitsSummaryBlock:Q.TraitsSummaryBlock,TripCountSummaryBlock:Q.TripCountSummaryBlock}};(0,L.A)($,q,[],!1,null,null,null).exports;var J=function(){var e=this,t=e._self._c;return t("section",{on:{mousedown:e.clickHandler}},[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report"),e._v(" "),t("button-add",{attrs:{panelType:e.view}})]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"}),e._v(" "),t("header-metric-block",{attrs:{slot:"metrics",metricsData:e.getGpuHeaderMetricsData},slot:"metrics"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),t("scrollable-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}],attrs:{fitParent:""}},[e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),t("layout-container",{attrs:{direction:"row",guideSizes:["70%","30%","30%"],dimensions:3}},[t("roofline",{key:e.gpuRoofline,attrs:{"roofline-id":e.gpuRoofline,"selection-id":e.gpuSelectionId,caption:e.$t("gpu_roofline_caption"),name:"roofline",size:"70%","excluded-extensions":["zones"]}}),e._v(" "),t("gpu-details-block",{attrs:{caption:e.$t("gpu_details"),size:"30%","selection-id":e.gpuSelectionId}}),e._v(" "),t("data-transfer-block",{key:e.dataTransferId,attrs:{caption:e.$t("gpu_data_transfer"),tabToSlot:"1","request-id":e.dataTransferId,"selection-id":e.gpuSelectionId}}),e._v(" "),t("idvc-grid",{key:e.gpuGridRequestId,attrs:{caption:e.$t("gpu_grid_caption"),guideIndex:"1",name:"gpu-grid","request-id":e.gpuGridRequestId,"selection-id":e.gpuSelectionId,getCustomCellStyle:e.getGPUGridCellStyle,contextMenu:e.gpuGridContextMenu},on:{gridDblClick:e.openSourceView}}),e._v(" "),t("recommendation-pane",{key:e.recommendationsId,attrs:{caption:`<i class='icon bulb light'></i> ${e.$t("recommendation_pane_title")}`,tabToSlot:"2",name:"#recommendation-pane","request-id":e.recommendationsId,"selection-id":e.gpuSelectionId}}),e._v(" "),t("idvc-source-view",{key:e.gpuSourceRequestId,attrs:{caption:e.$t("gpu_source"),tabToSlot:"2","request-id":e.gpuSourceRequestId,"selection-id":e.gpuSelectionId,contextMenu:e.gpuGridContextMenu}}),e._v(" "),t("idvc-source-view",{key:e.gpuAssemblyRequestId,attrs:{caption:e.$t("gpu_assembly"),tabToSlot:"2","request-id":e.gpuAssemblyRequestId,"selection-id":e.gpuSelectionId}}),e._v(" "),t("roofline",{key:e.cpuRoofline,attrs:{"roofline-id":e.cpuRoofline,"selection-id":e.cpuSelectionId,caption:e.$t("cpu_roofline_caption"),name:"roofline",panelState:"hidden"}}),e._v(" "),t("idvc-grid",{key:e.cpuGridRequestId,attrs:{caption:e.$t("cpu_grid_caption"),name:"cpu-grid","request-id":e.cpuGridRequestId,"selection-id":e.cpuSelectionId,panelState:"hidden"}})],1)],1)],1)};J._withStripped=!0;const ee={created(){w.A.gpu_roofline.loopSelection((e=>{const{value:t}=e,i=t;this.$store.direct.commit.setSelection({id:"gpu/main/gpuSelection",senderId:"gpuSummary",rowId:i})}))}},te={created(){w.A.gpu_roofline.mlrEnterDumbbell((e=>{const t=this.$el.querySelector('[caption="GPU Roofline"] .idvc2_roofline_body_area');t&&t.dispatchEvent(new KeyboardEvent("keydown",{key:"Enter",code:"Enter",keyCode:"13"}))}))}},ie={created(){w.A.gpu_roofline.mlrGetDumbbellHTML((e=>{const t={response:void 0};try{t.response=this.$el.querySelector('[caption="GPU Roofline"] .idvc2_chart_body').innerHTML}catch(e){t.error=e}return t}))}},oe={created(){w.A.gpu_roofline.mlrOpenMemMetricsPanel((e=>{this.$el.querySelector('[caption="GPU Roofline"] .idvc2_splitter_sash').dispatchEvent(new Event("mousedown"))}))}},ne={created(){w.A.gpu_roofline.mlrGetMemMetricsHTML((e=>{const t={response:void 0};try{t.response=this.$el.querySelector('[caption="GPU Roofline"] #memoryMetricsSection').innerHTML}catch(e){t.error=e}return t}))}},se={mixins:[z("gpu"),ee,te,ie,oe,ne],props:{panelName:String},data:()=>({view:"gpu:main",eventName:G.GPU_LOG,getGPUGridCellStyle(e,t,i,o,n){let s=Object.getPrototypeOf(this).getCellStyle.call(this,e,t,i,o,n);if(void 0===this._taskPurposeColumnIndex&&(this._taskPurposeColumnIndex=this.indexOfColumn((e=>"fdTaskPurpose"===e.type))),this._taskPurposeColumnIndex>=0){const e=this.getRawData(o,this._taskPurposeColumnIndex);(!e||e.toLowerCase().indexOf("unknown")>=0)&&(s+=" idvc2_grid_inactive_cell")}return s}}),computed:{...(0,O.mapGetters)("gpu",["getGpuHeaderMetricsData"]),...(0,O.mapGetters)("log",["isCollectionFinalizing","isRecommendationsVisibleInView","isTopSliderOverlapsView"]),isDisabled(){return this.isCollectionFinalizing(this.eventName)},selection(){return this.$store.direct.getters.getSelection(this.gpuSelectionId)}},created(){this.gpuRoofline="gpu/main/gpu-roofline",this.cpuRoofline="gpu/main/cpu-roofline",this.gpuGridRequestId="gpu/main/gpu-grid",this.cpuGridRequestId="gpu/main/cpu-grid",this.gpuSourceRequestId="gpu/main/source",this.gpuAssemblyRequestId="gpu/main/assembly",this.recommendationsId="gpu/main/recommendations",this.dataTransferId="gpu/main/data-transfer",this.gpuSelectionId="gpu/main/gpuSelection",this.cpuSelectionId="gpu/main/cpuSelection",this.gpuGridContextMenu=[{caption:this.$t("view_source"),command:this.openSourceView,disabled:async({rowId:e})=>!await this.hasSourceView(this.getRowId(e))},{caption:this.$t("edit_source"),command:this.drillDownNativeSource,noReport:!0,disabled:async({rowId:e})=>!await this.hasNativeSource(this.getRowId(e))}]},activated(){const{view:e,panelName:t}=this;t&&this.$store.direct.dispatch.layout.activateTab({view:e,name:t})},methods:{async getSource(e){return await _.default.get(this.gpuSourceRequestId,"update-source",{rowId:(0,B.getCurrentRowId)(e)})},getTaskInfo:async e=>await _.default.get("gpu","task-info",{rowId:(0,B.getCurrentRowId)(e)}),getRowId(e){var t;return e&&"r"===e[0]&&(e=void 0),e||(0,B.getCurrentRowId)(null===(t=this.selection)||void 0===t?void 0:t.rowId)||"-1"},async hasSourceView(e){const{sourceViewEnabled:t,assemblyViewEnabled:i}=await this.getTaskInfo(e);return t||i},async hasNativeSource(e){return"found"===(await this.getSource(e)||{}).state},async openSourceView(){const{selection:e}=this,{rowId:t}=e||{};if(!t||!await this.hasSourceView(t))return;const i=await this.getSource(t);this.$router.push({name:"gpu:source",params:{source:i,selection:e}}).catch((({message:e})=>console.error(e)))},async drillDownNativeSource(){const{rowId:e}=this.selection||{};if(!e)return;const t=await this.getSource(e);_.default.send("openNativeSource",t)},clickHandler(e){var t;const{view:i}=this,o=null==e||null===(t=e.target)||void 0===t?void 0:t.hash;o&&this.$store.direct.dispatch.layout.activateTab({view:i,name:o})}}},re=se,ae=(0,L.A)(re,J,[],!1,null,"6b7ffda6",null).exports;var le=function(){var e=this,t=e._self._c;return t("section",[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report"),e._v(" "),t("button-add",{attrs:{panelType:e.view}})]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),t("scrollable-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}]},[e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),t("layout-container",{attrs:{direction:"row",features:["hresize","swap","move","dock","collapse"],dimensions:4}},[t("with-no-data",{attrs:{caption:e.$t("program_metrics"),isNoData:!e.isProgramMetricsAvailable}},[t("top-gpu-metrics-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("ops_and_bandwidth"),guideIndex:"1",isNoData:!e.isOpsAndBandwidthAvailable}},[t("ops-and-bandwidth-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("top_hotspots"),guideIndex:"2",isNoData:!e.isTopHotspotsAvailable}},[t("top-hotspots-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("performance_characterization"),guideIndex:"3",isNoData:!e.isPerformanceCharAvailable}},[t("performance-characterization-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("platform_information"),guideIndex:"3",name:"platform-information",size:"30%",isNoData:!e.isPlatformInformationAvailable}},[t("platform-information-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("collection_information"),guideIndex:"3",name:"collection-information",size:"30%",isNoData:!e.isCollectionInfoAvailable}},[t("collection-information-block")],1)],1)],1)],1)};le._withStripped=!0;var ce=i(3390),de=(i(25215),i(78373)),pe=i(86442),ue=i(84190),he=i(28973),me=i(91581),fe=i(22896);const ve={created(){w.A.gpu_roofline.getGPUSummaryHTML((e=>(e.noDataText||(e.noDataText=this.$t("no_data")),(0,fe.Q)(e))))}},ge={created(){w.A.gpu_roofline.drillDownClick((e=>{const{kernel:t}=e,i=document.querySelectorAll("td[class='link']");for(let e=0;e<i.length;e++)if(i[e].innerText===t){i[e].click();break}}))}},_e={mixins:[ve,z("gpu"),N.RefreshMixin,ge],data:()=>({view:"gpu:summary",eventName:G.GPU_LOG}),computed:{...(0,O.mapGetters)("gpu",["canRequestData","isProgramMetricsAvailable","isImpactsSummaryAvailable","isOpsAndBandwidthAvailable","isTopHotspotsAvailable","isPerformanceCharAvailable","isPlatformInformationAvailable","isCollectionInfoAvailable"]),...(0,O.mapGetters)("log",["isCollectionFinalizing","isRecommendationsVisibleInView","isTopSliderOverlapsView"]),isDisabled(){return this.isCollectionFinalizing(this.eventName)}},methods:{processDataLoaded(){this.canRequestData&&(this.$store.direct.dispatch.gpu.fetchCpuOpsAndBandwidth(),this.$store.direct.dispatch.gpu.fetchGpuOpsAndBandwidth(),this.$store.direct.dispatch.gpu.fetchTopHotspots(),this.$store.direct.dispatch.gpu.fetchPerformanceChar(),this.$store.direct.dispatch.gpu.fetchPlatformInformation(),this.$store.direct.dispatch.gpu.fetchProgramMetrics(),this.$store.direct.dispatch.gpu.fetchCollectionInformation())},refresh(e){function t(e){return i&&0===i.indexOf(e)&&i.indexOf(`${e}-roofline`)>0}if(e&&e.dataLoaded)return;const{senderId:i}=e;t("gpu")?this.$store.direct.dispatch.gpu.fetchGpuOpsAndBandwidth():t("cpu")&&this.$store.direct.dispatch.gpu.fetchCpuOpsAndBandwidth()}},components:{TopGpuMetricsBlock:ce.default,OpsAndBandwidthBlock:de.default,TopHotspotsBlock:pe.default,PerformanceCharacterizationBlock:ue.default,PlatformInformationBlock:he.default,CollectionInformationBlock:me.default}},ye=(0,L.A)(_e,le,[],!1,null,"517d70ee",null).exports;var be=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("section",[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-source-layout",{attrs:{direction:e.direction},on:{directionChanged:e.onDirectionChanged}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report")]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),e.sources.length?t("layout-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}],key:e.sources.length,attrs:{features:["close_by_cross_button"],dimensions:1},scopedSlots:e._u([{key:"options",fn:function(){return[t("div",{staticClass:"options"},[t("div",{staticClass:"option-button",class:{pushed:"primary"!==e.folded},on:{click:e.onHideSource}},[e._v("\n          "+e._s(e.$t("source-view-source"))+"\n        ")]),e._v(" "),t("div",{staticClass:"option-button",class:{pushed:"secondary"!==e.folded},on:{click:e.onHideAssembly}},[e._v("\n          "+e._s(e.$t("source-view-assembly"))+"\n        ")])])]},proxy:!0}],null,!1,1253214017)},[e._v(" "),e._l(e.sources,(function(i,o){return t("layout-panel-template",{key:i.id,staticClass:"container",attrs:{name:i.name,caption:i.caption,tabToSlot:o>0?0:void 0,tabState:o===e.sources.length-1?"active":"normal",optionsSlot:"options",wrap:"nowrap",direction:e.direction}},[t("idvc-source-view",{attrs:{"request-id":i.sourceRequestId,"selection-id":i.selectionId,contextMenu:i.contextMenu,name:"source"},on:{selectionChanged:e.onSourceSelectionChanged,gridDblClick:function(t){return e.drillDownNativeSource(i.source)}}}),e._v(" "),e._l([e.direction],(function(o){return t("idvc-splitter",{key:`${i.id}-${o}`,attrs:{"min-size":150,"fold-primary":!1,"auto-fold":!1,folded:e.folded,horizontal:o===e.DIRECTION_COLUMN},on:{afterFoldSecondary:function(t){return e.onFolded("secondary")},afterUnfold:function(t){return e.onFolded("")}}})})),e._v(" "),t("idvc-source-view",{attrs:{"request-id":i.assemblyRequestId,"selection-id":i.selectionId,name:"assembly"},on:{selectionChanged:e.onAssemblySelectionChanged}})],2)}))],2):t("no-data",{attrs:{message:e.$t("source-view-no-data-gpu",e.$t("gpu:main"),e.$t("gpu:source")),suggestions:[e.$t("source-view-no-data-suggestion","#/gpu/main",e.$t("gpu:main"))]}})],1)};be._withStripped=!0;var we=i(85702);const xe=i.n(we)(),Ce=(0,L.A)(xe,be,[],!1,null,"47b78da7",null).exports;var Ae=function(){return(0,this._self._c)("no-data",{staticClass:"no-data",attrs:{message:this.$t("no_data_message")}})};Ae._withStripped=!0,(0,L.A)({},Ae,[],!1,null,"42966499",null).exports;var Se=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("section",[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report")]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),e.sources.length?t("layout-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}],key:e.sources.length,attrs:{features:["close_by_cross_button"],dimensions:1}},e._l(e.sources,(function(i,o){return t("idvc-source-view",{key:i.id,attrs:{name:i.name,caption:i.caption,"request-id":i.requestId,"selection-id":i.selectionId,contextMenu:i.contextMenu,tabToSlot:o>0?0:void 0,tabState:o===e.sources.length-1?"active":"normal"},on:{gridDblClick:function(t){return e.drillDownNativeSource(i.source)}}})})),1):t("no-data",{attrs:{message:e.$t("source-view-no-data-offload",e.$t("offload:accelerated-regions"),e.$t("offload:source")),suggestions:[e.$t("source-view-no-data-suggestion","#/offload/accelerated-regions",e.$t("offload:accelerated-regions"))]}})],1)};Se._withStripped=!0;var Te=i(54277);const Ie=i.n(Te)(),Pe=(0,L.A)(Ie,Se,[],!1,null,"7b6b9026",null).exports;var Me=function(){var e=this,t=e._self._c;return t("section",[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report"),e._v(" "),t("button-add",{attrs:{panelType:e.view}})]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),t("scrollable-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}]},[e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),t("layout-container",{attrs:{direction:"row",features:["hresize","swap","move","dock","collapse"],dimensions:3}},[t("with-no-data",{attrs:{caption:e.withSpinner("top_metrics"),isNoData:!e.isMainMetricsAvailable}},[t("top-offload-metrics-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.withSpinner("program_metrics"),isNoData:!e.isAdditionalMetricsAvailable,size:"50%",guideIndex:"1"}},[t("program-metrics-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.withSpinner("characterization_metrics"),isNoData:!e.isCharacterizationMetricsAvailable,size:"32rem",guideIndex:"1"}},[t("characterization-metrics-block")],1),e._v(" "),t("modeling-pane",{attrs:{caption:e.withSpinner("modeling_pane"),guideIndex:"1",min:"19rem",name:"modeling-pane"}}),e._v(" "),t("with-no-data",{attrs:{caption:e.withSpinner("top_offloaded"),isNoData:!e.isTopOffloadedAvailable,size:"50%",guideIndex:"2"}},[t("top-offloaded-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.withSpinner("top_non_offloaded"),isNoData:!e.isTopNonOffloadedAvailable,guideIndex:"2"}},[t("top-non-offloaded-block")],1)],1)],1)],1)};Me._withStripped=!0;const Ee={created(){w.A.offload.getSummaryHTML((e=>(e.noDataText||(e.noDataText=this.$t("no_data")),(0,fe.Q)(e))))}},Le={created(){w.A.offload.drillDownClick((e=>{const{loop:t}=e,i=document.querySelectorAll("a[href='#/offload/accelerated-regions']");for(let e=0;e<i.length;e++)if(i[e].innerText===t){i[e].click();break}}))}},Re={created(){w.A.offload.setRemodelingConfiguration((e=>{const{config:t}=e;!async function(e,t){await async function(e){e.querySelector('[caption="Modeling Parameters"] .icon.caret-down').click()}(e),e.querySelector(`[caption="Modeling Parameters"] [title="${t}"]`).click()}(this.$el,t)}))}};var De=i(8933);const ke={mixins:[Ee,z("offload"),Le,Re],data:()=>({view:"offload:summary",eventName:G.OFFLOAD_LOG}),computed:{...(0,O.mapGetters)("offload",["canRequestData","isMainMetricsAvailable","isAdditionalMetricsAvailable","isCharacterizationMetricsAvailable","isTopOffloadedAvailable","isTopNonOffloadedAvailable","isLoadingPane","isModelingPaneAvailable"]),...(0,O.mapGetters)("log",["isCollectionFinalizing","isRecommendationsVisibleInView","isTopSliderOverlapsView"]),isDisabled(){return this.isCollectionFinalizing(this.eventName)}},methods:{withSpinner(e){const t=this.$t(e);return this.isLoadingPane({modeling_pane:"modelingPane",top_metrics:"mainMetrics",program_metrics:"additionalMetrics",characterization_metrics:"boundMetrics",top_offloaded:"topOffloaded",top_non_offloaded:"topNonOffloaded"}[e])?`<span>${t}</span> <i class="icon circle-third spin"></i>`:t},async processDataLoaded(){if(this.canRequestData&&(await this.$store.direct.dispatch.offload.fetchAll(),(0,De.P)()||(0,n.getOs)().macOs)){const{view:e}=this,t="modeling-pane";this.isModelingPaneAvailable?this.$store.direct.dispatch.layout.restorePanel({view:e,name:t}):this.$store.direct.dispatch.layout.hidePanel({view:e,name:t})}}},created(){this.$store.direct.dispatch.offload.fetchModelingPane()}},Oe=(0,L.A)(ke,Me,[],!1,null,"2cb51bd4",null).exports;var Ne=function(){var e=this,t=e._self._c;return t("section",[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report"),e._v(" "),t("button-add",{attrs:{panelType:e.view}})]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),t("scrollable-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}]},[e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),t("layout-container",{attrs:{direction:"row",features:["hresize","swap","move","dock","collapse"],dimensions:4}},[t("with-no-data",{attrs:{caption:e.$t("program_metrics"),isNoData:!e.isProgramMetricsAvailable}},[t("top-gpu-metrics-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("ops_and_bandwidth"),guideIndex:"1",isNoData:!e.isOpsAndBandwidthAvailable}},[t("ops-and-bandwidth-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("top_hotspots"),guideIndex:"2",isNoData:!e.isTopHotspotsAvailable}},[t("top-hotspots-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("performance_characterization"),guideIndex:"3",compact:!0,isNoData:!e.isPerformanceCharAvailable}},[t("performance-characterization-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("platform_information"),guideIndex:"3",name:"platform-information",size:"30%",panelState:"collapsed",isNoData:!e.isPlatformInformationAvailable}},[t("platform-information-block")],1),e._v(" "),t("with-no-data",{attrs:{caption:e.$t("collection_information"),guideIndex:"3",name:"collection-information",size:"30%",panelState:"collapsed",isNoData:!e.isCollectionInfoAvailable}},[t("collection-information-block")],1)],1)],1)],1)};Ne._withStripped=!0;const ze={mixins:[z("roofline")],data:()=>({view:"roofline:summary",eventName:G.ROOFLINE_LOG}),computed:{...(0,O.mapGetters)("gpu",["canRequestData","isProgramMetricsAvailable","isImpactsSummaryAvailable","isOpsAndBandwidthAvailable","isTopHotspotsAvailable","isPerformanceCharAvailable","isPlatformInformationAvailable","isCollectionInfoAvailable"]),...(0,O.mapGetters)("log",["isCollectionFinalizing","isRecommendationsVisibleInView","isTopSliderOverlapsView"]),isDisabled(){return this.isCollectionFinalizing(this.eventName)}},methods:{processDataLoaded(){this.canRequestData&&(this.$store.direct.dispatch.gpu.fetchCpuOpsAndBandwidth(),this.$store.direct.dispatch.gpu.fetchGpuOpsAndBandwidth(),this.$store.direct.dispatch.gpu.fetchTopHotspots(),this.$store.direct.dispatch.gpu.fetchPerformanceChar(),this.$store.direct.dispatch.gpu.fetchPlatformInformation(),this.$store.direct.dispatch.gpu.fetchProgramMetrics(),this.$store.direct.dispatch.gpu.fetchCollectionInformation())}}},Be=(0,L.A)(ze,Ne,[],!1,null,"e4ff2ee4",null).exports;var Ve=function(){var e=this,t=e._self._c;return t("section",{on:{mousedown:e.clickHandler}},[t("disabled-overlay",{attrs:{disabled:e.isDisabled}}),e._v(" "),t("header-panel",{staticClass:"header",attrs:{disabled:e.isDisabled},scopedSlots:e._u([{key:"buttons",fn:function(){return[t("button-recommendations",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-event-log",{attrs:{eventName:e.eventName}}),e._v(" "),t("button-snapshot"),e._v(" "),t("button-html-report"),e._v(" "),t("button-add",{attrs:{panelType:e.view}})]},proxy:!0}])},[t("navigation",{attrs:{slot:"navigation"},slot:"navigation"}),e._v(" "),t("header-metric-block",{attrs:{slot:"metrics",metricsData:e.getGpuHeaderMetricsData},slot:"metrics"})],1),e._v(" "),t("top-slider",{attrs:{eventName:e.eventName}}),e._v(" "),t("scrollable-container",{directives:[{name:"show",rawName:"v-show",value:!e.isTopSliderOverlapsView,expression:"!isTopSliderOverlapsView"}],attrs:{fitParent:""}},[e.isRecommendationsVisibleInView?t("top-slider-recommendations",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),t("layout-container",{attrs:{direction:"row",guideSizes:["70%","30%","30%"],dimensions:3}},[t("roofline",{key:e.cpuRoofline,attrs:{"roofline-id":e.cpuRoofline,"selection-id":e.cpuSelectionId,caption:e.$t("cpu_roofline_caption"),name:"roofline",size:"70%","excluded-extensions":["zones"]}}),e._v(" "),t("idvc-grid",{key:e.cpuGridRequestId,attrs:{caption:e.$t("cpu_grid_caption"),guideIndex:"1","request-id":e.cpuGridRequestId,"selection-id":e.cpuSelectionId}}),e._v(" "),t("recommendation-pane",{key:e.recommendationsId,attrs:{caption:`<i class='icon bulb light'></i> ${e.$t("recommendation_pane_title")}`,tabToSlot:"1",name:"#recommendation-pane","request-id":e.recommendationsId,"selection-id":e.cpuSelectionId}})],1)],1)],1)};Ve._withStripped=!0;const Ge={mixins:[z("roofline")],props:{panelName:String},data:()=>({view:"roofline:main",eventName:G.ROOFLINE_LOG}),computed:{...(0,O.mapGetters)("gpu",["getGpuHeaderMetricsData"]),...(0,O.mapGetters)("log",["isCollectionFinalizing","isRecommendationsVisibleInView","isTopSliderOverlapsView"]),isDisabled(){return this.isCollectionFinalizing(this.eventName)},selection(){return this.$store.direct.getters.getSelection(this.cpuSelectionId)}},created(){this.cpuRoofline="roofline/main/cpu-roofline",this.cpuGridRequestId="roofline/main/cpu-grid",this.recommendationsId="roofline/main/recommendations",this.cpuSelectionId="roofline/main/cpuSelection"},activated(){const{view:e,panelName:t}=this;t&&this.$store.direct.dispatch.layout.activateTab({view:e,name:t})},methods:{clickHandler(e){var t;const{view:i}=this,o=null==e||null===(t=e.target)||void 0===t?void 0:t.hash;o&&this.$store.direct.dispatch.layout.activateTab({view:i,name:o})}}},Fe=(0,L.A)(Ge,Ve,[],!1,null,"63d023a8",null).exports;var Ue=function(){return(0,this._self._c)("perspective-selector-pane")};Ue._withStripped=!0;const He=(0,L.A)({},Ue,[],!1,null,null,null).exports;var je=function(){return(0,this._self._c)("router-view")};je._withStripped=!0;const Ye={inject:["api"],props:{viewId:{type:String,required:!0}},beforeDestroy(){this.api.unsubscribe(this.viewId,this.processData)},activated(){this.api.subscribe(this.viewId,this.processData)},deactivated(){this.api.unsubscribe(this.viewId,this.processData)},methods:{processData(e){e&&(e.data.viewId=this.viewId,this.$bus.$emit(e.name,e.data),this.api.sendEvent(e.name,e.data))}}},We=(0,L.A)(Ye,je,[],!1,null,null,null).exports;function Xe(e,t){return{render:i=>i(e,{props:{viewId:t}})}}a.Ay.use(D.Ay);const qe=[{path:"/offload",component:Xe(We,"offload"),children:[{path:"",name:"offload:summary",component:Oe},{path:"accelerated-regions",name:"offload:accelerated-regions",component:X},{path:"source",name:"offload:source",component:Pe,props:!0}]},{path:"/gpu",component:Xe(We,"gpu"),children:[{path:"",name:"gpu:summary",component:ye},{path:"main",name:"gpu:main",component:ae,props:!0},{path:"source",name:"gpu:source",component:Ce,props:!0}]},{path:"/roofline",component:Xe(We,"roofline"),children:[{path:"",name:"roofline:summary",component:Be},{path:"main",name:"roofline:main",component:Fe}]},{path:"/selector",name:"selector",component:He}],Ze=new D.Ay({routes:qe});var Qe=i(83373),Ke=i(81154),$e=i.n(Ke),Je=i(37387),et=i(30347),tt=i.n(et),it=i(99428),ot=i(35439);function nt({api:e}){return[t=>e.onOpenPerspective((e=>{t.commit("updateActivePerspectiveId",e)})),t=>e.subscribe(ot.CU,(i=>{t.commit("setDataLoadedStatus",i);const{path:o}=i;if(o){const t=o.replace("/","");e.send(`${t}/log`,{notification:"get-saved-messages"})}}))]}i(38333);const st=[e=>w.A.toolbar.pressButton((t=>e.dispatch("toolbar/setActiveButtonId",t))),e=>w.A.toolbar.getButtonState((t=>e.state.toolbar.buttons.find((e=>e.id===t.id))))],rt=a.Ay.observable({analysisStatus:[],accuracy:{value:{},custom:!1},totalOverhead:{},analysisKnobs:{},linkedKnobs:{},commonKnobs:{},savingMode:{}});i(60426);var at=i(65196),lt=i(32095);const ct=[lt.CommandType.ctRunCollection,lt.CommandType.ctStartPausedCollection,lt.CommandType.ctCommandLine,lt.CommandType.ctOpenProjectProperties,lt.CommandType.ctRefinalize,lt.CommandType.ctRemodelCollection],dt={[at.A2]:ct,[at.aD]:[],[at.pN]:[lt.CommandType.ctCancelCollection],[at.Ze]:[lt.CommandType.ctPauseCollection,lt.CommandType.ctStopCollection,lt.CommandType.ctCancelCollection],[at.HH]:[lt.CommandType.ctResumeCollection,lt.CommandType.ctStopCollection,lt.CommandType.ctCancelCollection],[at.qn]:[],[at.PO]:[],[at.lG]:[]},pt={[at.A2]:ct,[at.aD]:ct,[at.pN]:ct,[at.Ze]:[lt.CommandType.ctPauseCollection,lt.CommandType.ctStopCollection,lt.CommandType.ctCancelCollection,lt.CommandType.ctStartPausedCollection,lt.CommandType.ctCommandLine,lt.CommandType.ctOpenProjectProperties,lt.CommandType.ctRefinalize,lt.CommandType.ctRemodelCollection],[at.HH]:[lt.CommandType.ctResumeCollection,lt.CommandType.ctStopCollection,lt.CommandType.ctCancelCollection,lt.CommandType.ctStartPausedCollection,lt.CommandType.ctCommandLine,lt.CommandType.ctOpenProjectProperties,lt.CommandType.ctRefinalize,lt.CommandType.ctRemodelCollection],[at.qn]:[lt.CommandType.ctRunCollection,lt.CommandType.ctStartPausedCollection,lt.CommandType.ctCommandLine,lt.CommandType.ctOpenProjectProperties,lt.CommandType.ctRemodelCollection],[at.PO]:[lt.CommandType.ctRunCollection,lt.CommandType.ctStartPausedCollection,lt.CommandType.ctCommandLine,lt.CommandType.ctOpenProjectProperties,lt.CommandType.ctRemodelCollection],[at.lG]:ct},ut={perspectiveStatus(e){const{analysisStatus:t}=e;let i=at.A2,o=0;for(const e of t)switch(e){case at.Ze:case at.HH:return e;case at.aD:case at.PO:case at.lG:i=e;break;case at.qn:i!==at.aD&&(i=e);break;case at.pN:++o===t.length&&(i=at.pN)}return i},isReadOnly:(e,t)=>t.perspectiveStatus!==at.A2,isButtonVisible:(e,t)=>({cmd:i,analysisTypes:o})=>{let n=t.perspectiveStatus;return 1===o.length&&(n=e.analysisStatus[o[0]]||n),(pt[n]||[]).some((e=>e===i))},isButtonAvailable:(e,t)=>({cmd:i,analysisTypes:o})=>{if(e.analysisStatus[b.ActivityType.atProjection]===at.Ze&&{[lt.CommandType.ctPauseCollection]:!0,[lt.CommandType.ctStopCollection]:!0,[lt.CommandType.ctCancelCollection]:!0}[i])return!1;let n=t.perspectiveStatus;return 1===o.length&&(n=e.analysisStatus[o[0]]||n),(dt[n]||[]).some((e=>e===i))},currentAccuracy:(e,t,i,o)=>e.accuracy.value[o.activePerspectiveId],isCustomPreset:e=>e.accuracy.custom,isSaving:e=>Object.keys(e.savingMode).length>0,getAnalysisStatus:e=>e.analysisStatus,commonKnobs:e=>e.commonKnobs,baselineDeviceValue:(e,t)=>({CPU:0===t.presetIndex,GPU:1===t.presetIndex}),presetIndex(e){const{baselineDevice:t}=e.commonKnobs;return"bdGPU"===t?1:0}},ht={changeAnalysisStatus(e,{id:t,status:i}){a.Ay.set(e.analysisStatus,t,i)},setAnalysisStatus(e,t){e.analysisStatus=t},setCustomAccuracy(e,t){e.accuracy.custom=t},setAccuracyValue(e,{id:t,value:i}){a.Ay.set(e.accuracy.value,t,i)},setTotalOverhead(e,{id:t,overhead:i}){a.Ay.set(e.totalOverhead,t,i)},setAnalysisKnobs(e,{analysisId:t,analysisKnobs:i}){e.analysisKnobs[t]=Object.freeze(i)},setLinkedKnobs(e,{analysisId:t,newKnobs:i}){a.Ay.set(e.linkedKnobs,t,Object.freeze(i))},setCommonKnobs(e,t){e.commonKnobs={...e.commonKnobs,...t}},setSavingMode(e,t){a.Ay.set(e.savingMode,t,!0)},clearSavingMode(e,t){a.Ay.delete(e.savingMode,t)}},mt={changeAnalysisStatus({commit:e,state:t},{id:i,analysisState:o}){const n=t.analysisStatus[i];let s;switch(o){case b.ActivityState.avStateAvailable:case b.ActivityState.avStateActual:case b.ActivityState.avStateStale:s=at.A2;break;case b.ActivityState.avStateCollAlarmingWarning:s=at.lG;break;case b.ActivityState.avStateCollAlarmingError:s=at.PO;break;case b.ActivityState.avStateTempDisabled:case b.ActivityState.avStateCollWaiting:switch(n){case at.aD:case at.pN:case at.Ze:s=n;break;default:s=at.pN}break;case b.ActivityState.avStateCollRunning:case b.ActivityState.avStateCollResumed:s=at.Ze;break;case b.ActivityState.avStateCollPaused:s=at.HH;break;case b.ActivityState.avStateUnavailable:case b.ActivityState.avStateUndefined:s=at.pN;break;default:at.A2}e("changeAnalysisStatus",{id:i,status:s})},onRunCollection({commit:e,state:t},{analysisTypes:i}){const o=new Array(t.analysisStatus.length).fill(at.pN);for(const e of i)o[e]=at.aD;e("setAnalysisStatus",o)}};function ft({api:e}){return[t=>e.workflow.onStatusChange((e=>{t.dispatch("workflow/changeAnalysisStatus",e)}))]}const vt=a.Ay.observable({mainMetrics:{data:[],isLoading:!1},additionalMetrics:{data:[],isLoading:!1},overheadMetrics:{data:[],isLoading:!1},boundMetrics:{data:[],isLoading:!1},targetDevice:{data:[],isLoading:!1},topOffloaded:{data:{},isLoading:!1},topNonOffloaded:{data:{},isLoading:!1},markers:{data:[],isLoading:!1},modelingPane:{data:{},isLoading:!1},offloadFilter:{filterId:null,isFilterEnabled:!1},isMainMetricsAvailable:!1,isAdditionalMetricsAvailable:!1,isCharacterizationMetricsAvailable:!1,isTopOffloadedAvailable:!1,isTopNonOffloadedAvailable:!1,isLoadingPane:!1,isModelingPaneAvailabl:!1});i(43827);const gt={getMainMetricsData:e=>e.mainMetrics.data,getAdditionalMetricsData:e=>e.additionalMetrics.data,getOverheadMetricsData:e=>e.overheadMetrics.data,getBoundMetricsData:e=>e.boundMetrics.data,getTargetDeviceData:e=>e.targetDevice.data,getTopOffloadedData:e=>e.topOffloaded.data,getTopNonOffloadedData:e=>e.topNonOffloaded.data,getOffloadFilterData:e=>e.offloadFilter,getDataLoadedStatus:(e,t,i,o)=>{const{getDataLoadedStatus:n}=o;return n("/offload")},isLoading:(e,t)=>{const{getDataLoadedStatus:i}=t,o=Object.keys(e);return!i||o.some((t=>e[t].isLoading))},getDataLoadedHash:(e,t)=>{const{getDataLoadedStatus:i}=t,{hash:o}=i||{};return o},canRequestData:(e,t)=>{const{getDataLoadedStatus:i}=t,{data:o}=i||{},{state:n}=o||{};return!!i&&"no data"!==n},isNoData:(e,t)=>{const{getDataLoadedStatus:i}=t,{data:o}=i||{},{state:n}=o||{},{isMainMetricsAvailable:s,isAdditionalMetricsAvailable:r,isCharacterizationMetricsAvailable:a,isTopOffloadedAvailable:l,isTopNonOffloadedAvailable:c}=t;return"no data"===n||[s,r,a,l,c].every((e=>!0!==e))},isMainMetricsAvailable:(e,t)=>{const{getMainMetricsData:i}=t;return(0,n.has)(i)},getOffloadHeaderMetricsData:(e,t)=>{const{isMainMetricsAvailable:i,getMainMetricsData:o}=t;return i?o:[]},isAdditionalMetricsAvailable:(e,t)=>{const{getAdditionalMetricsData:i}=t;return(0,n.has)(i)},isCharacterizationMetricsAvailable:(e,t)=>{const{getBoundMetricsData:i}=t;return(0,n.has)(i)},isTopOffloadedAvailable:(e,t)=>{const{getTopOffloadedData:i}=t;return(0,n.has)(Object.keys(i))},isTopNonOffloadedAvailable:(e,t)=>{const{getTopNonOffloadedData:i}=t;return(0,n.has)(Object.keys(i))},isLoadingPane:e=>t=>!!e[t].isLoading,isModelingPaneAvailable:e=>(0,n.has)(Object.keys(e.modelingPane.data.resultValuesModelParams))};function _t(e,{data:t,isLoading:i=!1}){return{...e,data:t||e.data,isLoading:i}}const yt={setMainMetrics(e,t){e.mainMetrics=_t(e.mainMetrics,t)},setAdditionalMetrics(e,t){e.additionalMetrics=_t(e.additionalMetrics,t)},setOverheadMetrics(e,t){e.overheadMetrics=_t(e.overheadMetrics,t)},setBoundMetrics(e,t){e.boundMetrics=_t(e.boundMetrics,t)},setTargetDevice(e,t){e.targetDevice=_t(e.targetDevice,t)},setTopOffloaded(e,t){e.topOffloaded=_t(e.topOffloaded,t)},setTopNonOffloaded(e,t){e.topNonOffloaded=_t(e.topNonOffloaded,t)},setOffloadFilterStatus(e,{id:t,enabled:i}){e.offloadFilter={filterId:t,isFilterEnabled:i}},setModelingTargetDeviceKnob(e,{targetDeviceKnob:t}){e.modelingPane.data.targetDeviceKnob=t},setModelingPane(e,{data:t={resultValuesModelParams:{},resultTargetDevice:"",modelParams:{},targetDeviceKnob:{}},isLoading:i=!1}){e.modelingPane.data=t,e.modelingPane.isLoading=i}};function bt({api:e}){const t={async fetchMainMetrics({commit:t,state:i}){const{isLoading:o}=i.mainMetrics;o||(t("setMainMetrics",{isLoading:!0}),t("setMainMetrics",{data:await e.offload.summary.get("main-metrics")}))},async fetchAdditionalMetrics({commit:t,state:i}){const{isLoading:o}=i.additionalMetrics;o||(t("setAdditionalMetrics",{isLoading:!0}),t("setAdditionalMetrics",{data:await e.offload.summary.get("additional-metrics")}))},async fetchOverheadMetrics({commit:t,state:i}){const{isLoading:o}=i.overheadMetrics;o||(t("setOverheadMetrics",{isLoading:!0}),t("setOverheadMetrics",{data:await e.offload.summary.get("overhead-metrics")}))},async fetchBoundMetrics({commit:t,state:i}){const{isLoading:o}=i.boundMetrics;o||(t("setBoundMetrics",{isLoading:!0}),t("setBoundMetrics",{data:await e.offload.summary.get("bound-metrics")}))},async fetchTargetDevice({commit:t,state:i}){const{isLoading:o}=i.targetDevice;o||(t("setTargetDevice",{isLoading:!0}),t("setTargetDevice",{data:await e.offload.summary.get("target-device")}))},async fetchTopOffloaded({commit:t,state:i}){const{isLoading:o}=i.topOffloaded;o||(t("setTopOffloaded",{isLoading:!0}),t("setTopOffloaded",{data:await e.offload.summary.get("top-offloaded")}))},async fetchTopNonOffloaded({commit:t,state:i}){const{isLoading:o}=i.topNonOffloaded;o||(t("setTopNonOffloaded",{isLoading:!0}),t("setTopNonOffloaded",{data:await e.offload.summary.get("top-non-offloaded")}))},async fetchModelingPane({commit:t,state:i}){const{isLoading:o}=i.modelingPane;if(o)return;t("setModelingPane",{isLoading:!0});const s=await Promise.all(["resultValuesModelParams","modelParams"].map((async t=>await e.get("modelingPane",t)))),[a,l]=s;Object.keys(a).forEach((e=>{var t,i;a[e]=(0,n.parseValue)(a[e],null===(t=l[e])||void 0===t?void 0:t.postfix,null===(i=l[e])||void 0===i?void 0:i.units)}));const c=await e.workflow.getTargetPlatform(b.ProductMode.pmOffload)||{items:[]},d=a.device_id,p=a.device_name;let u=c.items.find((({value:e})=>e===d));u||(u={value:d,displayValue:p},c.items.unshift(u)),u.displayPostfix=await(0,r.mi)("translate",{id:"modeled_device"}),c.value=d;for(const[e,t]of Object.entries(l)){const{min:i,max:o,log:s}=t,r=a[e];if(s&&i<=0&&console.error('Error: incorrect "min" value for log scale',{id:e,min:i}),void 0!==r){const{min_na:s,max_na:l}=t,c=[s,l].map(n.valid),d=(0,n.logScale)({addPoint:n.logScale.fromEdges(c),minval:i,maxval:o});r===s?a[e]=d.value(d.min):r===l?a[e]=d.value(d.max):r>0&&(void 0!==i&&(t.min=Math.min(i,r)),void 0!==o&&(t.max=Math.max(o,r)))}}const h=e=>{null!=e&&e.min&&delete e.min,null!=e&&e.max&&delete e.max};h(l.Tiles_per_process),h(l.Stacks_per_process),t("setModelingPane",{data:{resultValuesModelParams:a,resultTargetDevice:d,modelParams:l,targetDeviceKnob:c}})}};return{...t,async fetchAll({dispatch:e}){const i=Object.keys(t).filter((e=>e.startsWith("fetch")));await Promise.all(i.map((t=>e(t))))}}}function wt({api:e}){return(0,Qe.ki)({namespaced:!0,state:vt,getters:gt,mutations:yt,actions:bt({api:e})})}function xt({api:e}){const t=(0,Qe.ki)({namespaced:!0,state:{buttons:[{id:7042,title:"run_analysis_t_title",tooltip:"run_analysis_t_tooltip",icon:"play light",visible:!0,active:!1,marked:!1,pressed:!1},{id:7040,title:"show_result_t_title",tooltip:"show_result_t_tooltip",icon:"clipboard-arrow-right light",visible:!0,active:!0,marked:!1,pressed:!1},{id:7039,title:"perspective_selector_t_title",tooltip:"perspective_selector_t_tooltip",icon:"crossroads-sign light",visible:!0,active:!0,marked:!1,pressed:!1},{id:7032,title:"project_properties_t_title",tooltip:"project_properties_t_tooltip",icon:"document-gear light",visible:!0,active:!0,marked:!1,pressed:!1},{id:7037,title:"snapshot_title",tooltip:"snapshot_tooltip",icon:"camera light",visible:!0,active:!0,marked:!1,pressed:!1},{icon:"minus light",visible:!0},{id:6002,title:"create_project_t_title",tooltip:"create_project_t_tooltip",icon:"document-plus light",visible:!0,active:!0,marked:!1,pressed:!1},{id:6001,title:"open_project_t_title",tooltip:"open_project_t_title",icon:"document-arrow-right light",visible:!0,active:!0,marked:!1,pressed:!1},{id:6e3,title:"open_result",visible:!1,active:!0,marked:!1,pressed:!1},{id:8027,title:"project_navigator_title",tooltip:"project_navigator_tooltip",icon:"bookshelf light",visible:!0,active:!0,marked:!1,pressed:!1},{id:7033,title:"",tooltip:"help",icon:"help-circle light",visible:!0,active:!0,marked:!1,pressed:!1}],activeButtonId:void 0},getters:{visibleButtons:e=>e.buttons.filter((e=>e.visible))},mutations:{setToolbarButton(e,t){const{id:i,...o}=t;e.buttons=e.buttons.map((e=>e.id===i?{...e,...o}:e))},setActiveButtonId(e,{id:t}){e.activeButtonId=t}},actions:{setActiveButtonId({commit:t},i){t("setActiveButtonId",i),e.toolbar.sendCommand(i)},setToolbarButton({commit:e},t){e("setToolbarButton",t)}}});return t}function Ct({api:e}){return[t=>e.toolbar.onButtonUpdate((e=>t.dispatch("toolbar/setToolbarButton",e)))]}i(21602);var At=i(27537),St=i.n(At),Tt=i(91604),It=i(12100),Pt=i.n(It),Mt=i(83595);function Et({api:e}){return[t=>t.subscribe(((t,{layout:i})=>{["layout/assignLayoutState","layout/setLayoutState","layout/setSize","layout/addPanel","layout/addTab","layout/swapPanels","layout/setPanelState","layout/setTabState","layout/setCapturedPanel"].includes(t.type)&&e.layout.saveState(i)}))]}function Lt({api:e}){const t=(0,Qe.ki)({namespaced:!0,state:{allButtons:[{id:"filters",icon:"filter",tooltip:"open_filters",selected:!1,component:null,variable:null},{id:"snapshot",icon:"camera solid",tooltip:"snapshot_dlg_title",selected:!1,component:null,variable:null},{id:"modelingDirection",icon:"layout-direct",tooltip:"modeling_direction",selected:!1,component:"modeling-direction-block",variable:null},{id:"htmlReport",icon:"download",tooltip:"roofline_toolbar_html_export",selected:!1,component:null,variable:null},{id:"addPanel",icon:"plus",selected:!1,component:"add-panel",variable:null},{id:"remodeling",icon:"replay ",tooltip:"remodeling_tooltip",selected:!1,component:null,variable:null},{id:"acceleratedRegions",icon:"crossroads-sign",tooltip:"button_caption_switch_to_offload",selected:!1,component:null,variable:"offload:accelerated-regions"},{id:"gpuMain",icon:"crossroads-sign",tooltip:"button_caption_switch_to_gpu",selected:!1,component:null,variable:"gpu:main"},{id:"recommendations",icon:"megaphone",tooltip:"recommendations_tooltip",selected:!1,component:null,variable:null},{id:"eventLog",icon:"bell",tooltip:"event_log_tooltip",selected:!1,component:null,variable:null}],selectedButtonId:null},getters:{getButton:e=>t=>e.allButtons.filter((e=>e.id===t))[0]},mutations:{setSelectedButtonId(e,{id:t}){e.selectedButtonId=t}},actions:{setSelectedButtonId({commit:t},i){t("setSelectedButtonId",i),e.header.send(i)}}});return t}function Rt({api:e}){const t=(0,Qe.ki)({namespaced:!0,state:{},getters:{isGridEmpty:e=>t=>{const{rowCount:i}=e[t]||{};return!i||0===i}},mutations:{setGridData(e,{gridId:t,...i}){const o=e[t];a.Ay.set(e,t,{...o,...i})}},actions:{async update({commit:t},i){const[o]=i,n=await e.grid.update(...i),{rows:s}=n||{};return s&&t("setGridData",{gridId:o,rowCount:s.length}),n}}});return t}var Dt=i(55233),kt=i.n(Dt),Ot=i(6276),Nt=i.n(Ot);const zt={setCpuOpsAndBandwidth(e,{data:t,isCpuLoading:i=!1}){const{opsAndBandwidth:o}=e,n=o.data;t&&t.hasOwnProperty("cpu")&&(n.cpu=t.cpu),e.opsAndBandwidth={...o,dataPatched:n,isCpuLoading:i}},setGpuOpsAndBandwidth(e,{data:t,isGpuLoading:i=!1}){const{opsAndBandwidth:o}=e,n=o.data;t&&t.hasOwnProperty("gpu")&&(n.gpu=t.gpu),e.opsAndBandwidth={...o,dataPatched:n,isGpuLoading:i}},setTopHotspots(e,{data:t,isLoading:i=!1}){const{topHotspots:o}=e;e.topHotspots={...o,data:t||o.data,isLoading:i}},setPerformanceChar(e,{data:t,isLoading:i=!1}){const{performanceChar:o}=e;e.performanceChar={...o,data:t||o.data,isLoading:i}},setProgramMetrics(e,{data:t,isLoading:i=!1}){const{programMetrics:o}=e;e.programMetrics={...o,data:t||o.data,isLoading:i}},setPlatformInformation(e,{data:t,isLoading:i=!1}){const{platformInformation:o}=e;e.platformInformation={...o,data:t||o.data,isLoading:i}},setCollectionInformation(e,{data:t,isLoading:i=!1}){const{collectionInformation:o}=e;e.collectionInformation={...o,data:t||o.data,isLoading:i}}};function Bt({api:e}){return{async fetchCpuOpsAndBandwidth({commit:t,state:i}){const{isCpuLoading:o}=i.opsAndBandwidth;o||(t("setCpuOpsAndBandwidth",{isCpuLoading:!0}),t("setCpuOpsAndBandwidth",{data:{cpu:await e.gpu.getCpuOpsAndBandwidth()}}))},async fetchGpuOpsAndBandwidth({commit:t,state:i}){const{isGpuLoading:o}=i.opsAndBandwidth;o||(t("setGpuOpsAndBandwidth",{isGpuLoading:!0}),t("setGpuOpsAndBandwidth",{data:{gpu:await e.gpu.getGpuOpsAndBandwidth()}}))},async fetchTopHotspots({commit:t,state:i}){const{isLoading:o}=i.topHotspots;o||(t("setTopHotspots",{isLoading:!0}),t("setTopHotspots",{data:{gpu:await e.gpu.getGpuTopHotspots(),cpu:await e.gpu.getCpuTopHotspots()}}))},async fetchPerformanceChar({commit:t,state:i}){const{isLoading:o}=i.performanceChar;o||(t("setPerformanceChar",{isLoading:!0}),t("setPerformanceChar",{data:{gpu:await e.gpu.getGpuPerformanceChar(),cpu:await e.gpu.getCpuPerformanceChar()}}))},async fetchPlatformInformation({commit:t,state:i}){const{isLoading:o}=i.platformInformation;o||(t("setPlatformInformation",{isLoading:!0}),t("setPlatformInformation",{data:{gpu:await e.gpu.getPlatformInformationData(),cpu:await e.gpu.getCpuPlatformInformationData()}}))},async fetchProgramMetrics({commit:t,state:i}){const{isLoading:o}=i.programMetrics;o||(t("setProgramMetrics",{isLoading:!0}),t("setProgramMetrics",{data:{gpu:await e.gpu.getGpuProgramMetrics(),cpu:await e.gpu.getCpuProgramMetrics()}}))},async fetchCollectionInformation({commit:t,state:i}){const{isLoading:o}=i.collectionInformation;o||(t("setCollectionInformation",{isLoading:!0}),t("setCollectionInformation",{data:await e.gpu.getCollectionInformationData()}))}}}function Vt({api:e}){return(0,Qe.ki)({namespaced:!0,state:kt(),getters:Nt(),mutations:zt,actions:Bt({api:e})})}const Gt={},Ft={getDataLoadedStatus:(e,t,i,o)=>{const{getDataLoadedStatus:n}=o;return n("/roofline")},isLoading:(e,t)=>{const{getDataLoadedStatus:i}=t,o=Object.keys(e);return!i||o.some((t=>e[t].isLoading))},getDataLoadedHash:(e,t)=>{const{getDataLoadedStatus:i}=t,{hash:o}=i||{};return o},canRequestData:(e,t)=>{const{getDataLoadedStatus:i}=t,{data:o}=i||{},{state:n}=o||{};return!!i&&"no data"!==n}},Ut={};function Ht(){const e={async fetchMetrics(){}};return{...e,async fetchAll({dispatch:t}){const i=Object.keys(e).filter((e=>e.startsWith("fetch")));await Promise.all(i.map((e=>t(e))))}}}function jt({api:e}){return(0,Qe.ki)({namespaced:!0,state:Gt,getters:Ft,mutations:Ut,actions:Ht()})}const Yt=7040,Wt=6002;function Xt({api:e}){const t=(0,Qe.ki)({namespaced:!0,state:{mainButtons:[{id:7042,title:"run_analysis_w_title",tooltip:"run_analysis_w_tooltip",icon:"play light",visible:!0,active:!1},{id:7032,title:"project_properties_w_title",tooltip:"project_properties_w_tooltip",icon:"document-gear light",visible:!0,active:!0},{id:Wt,title:"create_project_w_title",icon:"document-plus light",visible:!0,active:!0}],buttons:[{id:Yt,title:"show_result_w_title",tooltip:"show_result_w_tooltip",icon:"clipboard-arrow-right light",visible:!0,active:!0},{id:7039,title:"perspective_selector_w_title",tooltip:"perspective_selector_w_tooltip",icon:"crossroads-sign light",visible:!0,active:!0},{id:7032,title:"project_properties_w_title",tooltip:"project_properties_w_tooltip",icon:"document-gear light",visible:!0,active:!0},{id:6001,title:"open_project_w_title",icon:"document-arrow-right light",visible:!0,active:!0},{id:Wt,title:"create_project_w_title",icon:"document-plus light",visible:!0,active:!0}],actionButtonId:void 0,productName:{},currentProject:{},mruProjects:[]},getters:{actionButtons:e=>e.buttons,getMainButton(e){const t=e.buttons.find((e=>e.id===Yt)),i=e.mainButtons.find((e=>7042===e.id)),o=e.mainButtons.find((e=>e.id===Wt));return i&&i.active?i:t&&t.active?t:o},getAdditionalButton(e,t){const{getMainButton:i}=t,o=e.buttons.find((e=>e.id===Yt));return o&&o.active&&i!==o?o:void 0},isAdditionalButton(e,t){const{getAdditionalButton:i}=t;return void 0!==i},isProductDescription:e=>"object"==typeof e.productName&&e.productName.hasOwnProperty("description")&&""!==e.productName.description,getProductDescription(e,t){const{isProductDescription:i}=t;return i?e.productName.description:""},isProductName:e=>"object"==typeof e.productName&&e.productName.hasOwnProperty("name")&&""!==e.productName.name,getProductVersion(e,t){const{isProductName:i}=t;if(i){const t=/(\d+\.?\d+)/g.exec(e.productName.name);return Array.isArray(t)?t[0]:""}return""},mruProjects:e=>e.mruProjects,currentProject:e=>e.currentProject,isMruProjects:e=>e.mruProjects!==[],isCurrentProject:e=>"object"==typeof e.currentProject&&e.currentProject.hasOwnProperty("name")&&""!==e.currentProject.name,isCurrentProjectCli:e=>"object"==typeof e.currentProject&&e.currentProject.hasOwnProperty("isCli")&&e.currentProject.isCli},mutations:{setWelcomeButton(e,t){const{id:i,...o}=t;e.buttons=e.buttons.map((e=>e.id===i?{...e,...o}:e)),e.mainButtons=e.mainButtons.map((e=>e.id===i?{...e,...o}:e))},setProductName(e,t){"object"==typeof t&&null!==t&&(e.productName=t)},setMruProjects(e,t){const i=[];Array.isArray(t)&&t.length&&t.forEach((e=>{e.hasOwnProperty("name")&&""!==e.name&&e.hasOwnProperty("path")&&""!==e.path&&i.push(e)})),e.mruProjects=i},setCurrentProject(e,t){let i={};"object"==typeof t&&null!==t&&t.hasOwnProperty("name")&&(i=t),e.currentProject=i},setActionButtonId(e,{id:t}){e.actionButtonId=t}},actions:{setWelcomeButton({commit:e},t){e("setWelcomeButton",t)},setProductName({commit:e},t){e("setProductName",t)},setMruProjects({commit:e},t){e("setMruProjects",t)},setCurrentProject({commit:e},t){e("setCurrentProject",t)},setActionButtonId({commit:t},i){t("setActionButtonId",i),e.welcome.sendCommand(i)},loadGettingStarted(){e.welcome.sendCommand({id:1540})},loadRecentProject({commit:t},i){t("setActionButtonId",{id:1541});const{path:o}=i;e.welcome.sendCommand({id:1541,path:o})}}});return t}function qt({api:e}){return[t=>e.welcome.onButtonUpdate((e=>t.dispatch("welcome/setWelcomeButton",e))),t=>e.welcome.onNameUpdate((e=>t.dispatch("welcome/setProductName",e))),t=>e.welcome.onCurrentProjectUpdate((e=>t.dispatch("welcome/setCurrentProject",e))),t=>e.welcome.onMruProjectsUpdate((e=>t.dispatch("welcome/setMruProjects",e)))]}var Zt=i(30832),Qt=i.n(Zt),Kt=i(53497),$t=i(5065),Jt=i.n($t),ei=i(54262),ti=i(62067);function ii({api:e}){return[t=>e.subscribe(ot.UP,(e=>{const{change:i,type:o,batchMode:n,viewId:s}=e,r=function(e){const t=e+"/log";switch(t){case G.OFFLOAD_LOG:case G.ROOFLINE_LOG:case G.GPU_LOG:return t;default:console.error("Not found log for: ",{viewId:e})}}(s),a=t.direct.getters.log.isCollectionRunning(r);t.direct.commit.log.setSwitchViewChangeReason({eventName:r,value:i}),1===o?t.direct.dispatch.log.toggleEventLogVisible(!0):2===o&&t.direct.dispatch.log.toggleEventLogVisible(!1),a||i!==ti.VisualisationChange.vcCollectionStarting?!a||n||i!==ti.VisualisationChange.vcUnknown&&i!==ti.VisualisationChange.vcShowNoData||t.direct.commit.log.setCollectionRunning({eventName:r,value:!1}):(t.direct.dispatch.log.setTopSliderHeight(void 0),t.direct.commit.log.setRecommendationsVisible(!1),t.direct.commit.log.setAutoShowRecommendations(!0),t.direct.commit.log.setCollectionRunning({eventName:r,value:!0}))})),t=>e.subscribe(G.OFFLOAD_LOG,(e=>{t.direct.dispatch.log.processEvent({eventName:G.OFFLOAD_LOG,message:e})})),t=>e.subscribe(G.GPU_LOG,(e=>{t.direct.dispatch.log.processEvent({eventName:G.GPU_LOG,message:e})})),t=>e.subscribe(G.ROOFLINE_LOG,(e=>{t.direct.dispatch.log.processEvent({eventName:G.ROOFLINE_LOG,message:e})}))]}a.Ay.use(O.default);const oi=function({api:e}){const{store:t}=(0,Qe.zP)({modules:{workflow:(0,Qe.ki)({namespaced:!0,state:rt,getters:ut,mutations:ht,actions:mt}),offload:wt({api:e}),toolbar:xt({api:e}),layout:(0,Qe.ki)({namespaced:!0,state:St(),getters:Tt.A,mutations:Pt(),actions:Mt.A}),header:Lt({api:e}),grid:Rt({api:e}),gpu:Vt({api:e}),roofline:jt({api:e}),welcome:Xt({api:e}),log:(0,Qe.ki)({namespaced:!0,state:Qt(),getters:Kt.A,actions:ei.A,mutations:Jt()})},state:$e(),mutations:tt(),getters:Je.A,actions:it.A,plugins:[...Ct({api:e}),...qt({api:e}),...ft({api:e}),...Et({api:e}),...ii({api:e}),...nt({api:e}),...st],strict:!1});return t}({api:_.default}).original;Ze.afterEach((()=>{setTimeout(o.hideCurrentTooltip,25)})),(0,n.stopLoading)(!1).then((e=>new a.Ay({provide:{api:_.default},router:Ze,store:oi,mixins:[l],render:e=>e(R)}).$mount("#app")))},37255:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(8546),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},37260:(e,t,i)=>{"use strict";i.r(t),i(84422),i(69212),i(45361);var o=i(77106),n=i(33705),s=i.n(n);function r(e,t){a(e,t);const i=e.children[1];i.innerHTML=i.innerHTML.replaceAll("%dpcpp_disclaimer%",s());const o=e.querySelector("#unsupported_programming_model");o&&o.Visible(!t.is_programming_model_supported)}function a(e,t){e&&e.children[1]&&(e.children[1].innerHTML=(0,o.applyRecParams)(e.children[1].innerHTML,t))}function l(e,t){if(!e||!t)return;const i=e.querySelector("#num_threads_text");i&&i.Visible(null!=t.parallel_threads&&null!=t.parallel_threads_per_eu);const o=e.querySelector("#simd_divergence_impact");o&&o.Visible(null==t.factor);const n=e.querySelector("#spills_impact");n&&n.Visible("spills"==t.factor),r(e,t),function(e,t){const i=e.querySelector("#no_perf_modeling_disclaimer");i&&i.Visible(t.no_perf_modeling_disclaimer)}(e,t)}function c(e,t){if(!e||!t)return;const i=e.querySelector("#low_thread_occupancy");i&&i.Visible(!!t.low_thread_occupancy),r(e,t)}function d(e,t){if(!e||!t)return;const i=t.data_reuse_speed_up_percents;if(void 0!==i){const n=`${(0,o.formatNumber)({value:i,type:"auto",digits:2})}%`;r(e,{...t,data_reuse_speed_up_percents:n})}r(e,t)}window.rec_gpu_reduce_simd_width_f_omp_target=l,window.rec_gpu_reduce_simd_width_c_omp_target=l,window.rec_gpu_reduce_simd_width_c_dpcpp=l,window.rec_private_memory_c_dpcpp=r,window.rec_private_memory_f_omp_target=a,window.rec_private_memory_c_omp_target=a,window.rec_gpu_dataset_tile_share_data_c_dpcpp=function(e,t){if(!e||!t)return;const i=e.querySelector("#kernel_args");i&&i.Visible(t.kernel_arg_size);const o=e.querySelector("#no_kernel_args");o&&o.Visible(!t.kernel_arg_size),r(e,t)},window.rec_gpu_dataset_tile_share_data_c_omp_target=a,window.rec_gpu_dataset_tile_share_data_f_omp_target=a,window.rec_gpu_cas_atomic_c_dpcpp=function(e,t){e&&t&&(e.querySelectorAll("#apply_native_atomics_flag").forEach((function(e){e.Visible(!t.native_atomics_flag)})),r(e,t))},window.rec_kernel_complex_structure_c_dpcpp=r,window.rec_gpu_reduce_spills_c_dpcpp=r,window.rec_gpu_apply_data_reuse_c_dpcpp=d,window.rec_gpu_apply_data_reuse_c_omp_target=d,window.rec_gpu_apply_data_reuse_f_omp_target=d,window.rec_gpu_dataset_tile_share_data_slm_c_dpcpp=c,window.rec_gpu_dataset_tile_share_data_slm_c_omp_target=c,window.rec_gpu_dataset_tile_share_data_slm_f_omp_target=c},37387:(e,t,i)=>{"use strict";const o=i(84620),n={isBeefup:e=>e.activePerspectiveId===o.ProductMode.pmOffload||e.activePerspectiveId===o.ProductMode.pmGPU,activePerspectiveId:e=>e.activePerspectiveId,getAllPerspectives:e=>e.allPerspectives,getDataLoadedStatus:e=>(t="")=>{const{dataLoadedStatus:i}=e;return i[t]},getSelection:e=>(t="")=>e.selection[t],isFeatureEnabled:e=>(t="")=>{const{enabledFeatures:i}=e;return i.includes(t)}};t.A=n},37445:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"metric",class:{"value-important":e.metric.value_important,hover:e.enableHovering&&(e.metric.hover||e.hover)},on:{mouseover:function(t){return e.onHover(!0)},mouseleave:function(t){return e.onHover(!1)}}},[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.metric.tooltip,expression:"metric.tooltip"}],staticClass:"title",class:{[e.legendColor]:e.enableLegend,"legend-enabled ":e.enableLegend}},[e._v("\n    "+e._s(e.metric.title||e.$t(e.metric.id))+"\n  ")]),e._v(" "),t("div",{staticClass:"value"},[e._v(e._s(e.value))])])};o._withStripped=!0;var n=i(77106);const s={props:{metric:{type:Object,required:!0},enableHovering:Boolean,enableLegend:Boolean},data:()=>({hover:!1}),computed:{legendColor(){const{metric:e}=this;return`legend-color-${e.marker||"unknown"}`},value(){return this.metric&&this.metric.formattedValue?this.metric.formattedValue:(0,n.formatNumber)(this.metric)||this.$t("no_data")}},methods:{onHover(e){this.hover=e,this.$emit("metric-hover",{...this.metric,hover:e})}}},r=(0,i(98822).A)(s,o,[],!1,null,"78bc05bc",null).exports},37490:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{directives:[{name:"click-outside",rawName:"v-click-outside",value:e.close,expression:"close"}],staticClass:"button"},[e.button?t("a",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.buttonTooltip,expression:"buttonTooltip"}],staticClass:"dot icon",class:[e.buttonIcon,{selected:e.isShowMenu},{available:e.buttonAvailable}],on:{click:function(t){e.isOpened=e.isOpened!=e.buttonAvailable}}}):e._e(),e._v(" "),t("transition",{attrs:{name:"slide"}},[e.isShowMenu?t("div",{staticClass:"arrow-down"}):e._e()]),e._v(" "),e.isShowMenu?t(e.componentIn,{tag:"component",staticClass:"overlay",on:{close:function(t){return e.close()}}}):e._e()],1)};o._withStripped=!0;var n=i(75337);const s={mixins:[i(78281).A],props:{panelType:{type:String,required:!0}},data:()=>({isOpened:!1}),computed:{...(0,n.mapGetters)("header",["getButton"]),...(0,n.mapGetters)("layout",["getHiddenPanels","getHiddenTabs"]),button(){return this.getButton("addPanel")},componentIn(){return this.button.component},isShowMenu(){return this.buttonAvailable&&this.isOpened},buttonAvailable(){return this.getHiddenPanels(this.panelType).length>0||this.getHiddenTabs(this.panelType).length>0}},methods:{close(){this.isOpened=!1}}},r=(0,i(98822).A)(s,o,[],!1,null,"71d3087a",null).exports},37537:e=>{e.exports=' <h4>System function call(s) present</h4> <div class="essential"> System function call(s) in the <span data-glossary-id="loop_body">loop body</span> are preventing the compiler from vectorizing the loop. </div>'},37653:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"data"},e._l(e.items,(function(i,o){return t("div",{key:void 0!==i.index?i.index:o,staticClass:"output-item"},[t("i",{staticClass:"icon",class:e.getSeverityIcon(i.severity)}),e._v(" "),t("message-text",{attrs:{text:i.text}})],1)})),0)};o._withStripped=!0;var n=i(24675),s=i(32035);const r={props:{items:{type:Array,required:!0}},mixins:[s.scrollToEndMixin],methods:{getSeverityIcon:e=>({sInfo:"information-circle",sWarning:"alert-triangle",sError:"cross-circle",sFatalError:"cross-circle",sVerbose:"",sAppStdout:"",sAppStderr:"",sUser:"",sNoAppOutput:""}[n.Severity.id2name[e]])},watch:{items(){this.scrollToEnd()}}},a=(0,i(98822).A)(r,o,[],!1,null,"45de0434",null).exports},37672:e=>{e.exports=' <h4>Force vectorization if possible</h4> <div class="text"> <div class="promo"> <div id="no_dependency_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a> to identify real data dependencies. </div> The loop contains <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a> instructions (so vectorization could be beneficial), but is not vectorized. To fix, review: <ul> <li>Corresponding compiler diagnostic to check if vectorization enforcement is possible and profitable</li> <li>The Dependencies analysis to distinguish between compiler-assumed dependencies and real dependencies</li> </ul> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},38103:e=>{e.exports=' <h4>Avoid big arguments and/or complex structures in kernel arguments</h4> <div class="text"> <div class="promo"> %dpcpp_disclaimer% The <a href="https://www.intel.com/content/www/us/en/develop/documentation/oneapi-programming-guide/top/oneapi-programming-model/data-parallel-c-dpc.html"> Data Parallel C++ (DPC++) Programming Model</a> uses lambda functions to desribe the kernel code. The kernel arguments are specified via the <b>lambda capture list</b>. See <a href="https://intel.github.io/llvm-docs/KernelParameterPassing.html">SYCL Kernel Parameter Handling</a> for more details. <br/><br/> Consider reducing kernel arguments number or size. </div> <br/> <ul> <li> <b>Consider using DPC++ capture clause (instead of default-capture).</b> <p> Consider using direct specification of parameters or separate fields instead of complete structure. Using DPC++ capture clause (instead of default-capture) will limit the transfer only for kernel arguments captured explicitly. </p> <p class="expander">Example of a <b>DPC++ capture clause</b> for kernel arguments:</p> <pre class="essential"><code class="cpp" data-source="\n//DPC++ limited capture list is applied here:\nqueue.submit([a_data, b_data, sharedData](cl::sycl::handler &cgh)\n...\n        "></code></pre> <pre class="expansion"><code class="cpp" data-source="\nconst int N = 25;\ntemplate < typename T, typename IndexType >\nstruct TensorInfo\n{\n    T* data;\n    IndexType sizes[N];\n    IndexType strides[N];\n    int dims;\n};\n\n...\nTensorInfo < double, int64_t > a, b, c;\ndouble* sharedData = malloc_shared < double > (1, queue);\nauto *a_data = a.data, *b_data = b.data;\n//DPC++ limited capture list is applied here:\nqueue.submit([a_data, b_data, sharedData](cl::sycl::handler &cgh)\n{\n    cgh.parallel_for < class my_task > (cl::sycl::range < 1 > { Q }, [=](cl::sycl::id <1> idx)\n    {\n        *sharedData = a_data[0] + b_data[0];\n    });\n});\nqueue.wait();\n        "></code></pre> <br/> </li> <li> <b>Consider using reduced data types for kernel arguments or reducing the number of arguments.</b> <br/> Consider replacing kernel argument types with similar types with a reduced width: <ul> <li><b>double</b> &#8680; <b>float</b></li> <li><b>long</b> &#8680; <b>int</b> &#8680; <b>short</b></li> </ul> </li> </ul> </div> '},38235:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.DEBUG=t.METER_HEIGHT=t.MIN_SPLITTER_SIZE=t.DEFAULT_OUTPUT_HEIGHT=t.EVENT_TYPE_RECOMMENDATION=t.EVENT_TYPE_EVENT=t.ROOFLINE_LOG=t.OFFLOAD_LOG=t.GPU_LOG=t.CONDITION_MAXIMIZED=t.CONDITION_EXPANDED=t.CONDITION_COLLAPSED=void 0,t.CONDITION_COLLAPSED="COLLAPSED",t.CONDITION_EXPANDED="EXPANDED",t.CONDITION_MAXIMIZED="MAXIMIZED",t.GPU_LOG="gpu/log",t.OFFLOAD_LOG="offload/log",t.ROOFLINE_LOG="roofline/log",t.EVENT_TYPE_EVENT=1,t.EVENT_TYPE_RECOMMENDATION=2,t.DEFAULT_OUTPUT_HEIGHT=120,t.MIN_SPLITTER_SIZE=32*window.devicePixelRatio,t.METER_HEIGHT=8,t.DEBUG=!1},38311:e=>{e.exports=' <h4>Misaligned loop code present</h4> <div class="essential"> Current placement of the loop in memory may result in inefficient use of the <span data-glossary-id="cpu_front_end">CPU front-end</span>. Improve performance by <span data-glossary-id="alignment_of_code">aligning loop code</span>. </div>'},38322:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(21255),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},38340:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"memory_metrics"}},[t("div",{staticClass:"content"},[t("div",{attrs:{name:"title"}},[e._v(e._s(e.$t("memory-metrics")))]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.compact,expression:"compact"}],staticClass:"essential"},[t("div",[e._v("Memory Shares and Memory Impacts")])]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.compact,expression:"!compact"}],staticClass:"expansion"},[t("div",{attrs:{name:"data_wrapper"}})])])])};o._withStripped=!0;var n=i(9007);const s={props:{data:Object},computed:{compact(){return this.$parent.compact}},mounted(){this.refresh()},watch:{data(){this.refresh()}},methods:{refresh(){const{$el:e,data:t}=this,i=qs("[name=data_wrapper]",e),o=e.memoryView||n.A.create(i);if(o.clear(),!t||!t.metrics)return;o.setData(t.metrics),e.memoryView=o;const s=qs("[name=title]",e);s&&(null!==s.firstElementChild&&s.removeChild(s.firstElementChild),t.explanation&&(s.innerHTML+=`<i data-tooltip="${t.explanation}"</i>`))}}},r=(0,i(98822).A)(s,o,[],!1,null,null,null).exports},38576:e=>{"use strict";e.exports=JSON.parse('{"bfloat8":"#1e90ff","halffloat":"#2786f8","sp":"#307Df0","dp":"#3873e9","other float":"#4169e1","int8":"#3454dd","int16":"#273fd9","int32":"#1a2ad5","int64":"#0d15d1","other int":"#0000cd","store":"#ffd700","slm store":"#daa520","load":"#cd853f","slm load":"#d2691e","atomic":"#ff9e64","slm atomic":"#ff6347","move":"#da70d6","control flow":"#ba55d3","sync":"#8b008b","other":"#663399"}')},38649:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"tree-list"},e._l(e.items,(function(i){return t("tree-list-node",{key:i.title,attrs:{item:i,features:e.features,level:e.level,collapsed:e.collapsed,"min-node-width":e.minItemWidth}})})),1)};o._withStripped=!0,i(69212),i(43827);var n=i(66459);const s={props:{items:{type:Array,required:!0},features:{type:Array,validator:e=>e.every((e=>"string"==typeof e&&n.ALL_FEATURES.includes(e.toLowerCase()))),default:()=>n.ALL_FEATURES},level:{type:Number,default:0},collapsed:{type:Boolean,default:!0},minItemWidth:{type:String,default:""}},components:{TreeListNode:()=>Promise.resolve().then(i.bind(i,46339))}},r=(0,i(98822).A)(s,o,[],!1,null,"119cb007",null).exports},38696:function(e,t,i){"use strict";i(69212),i(38333);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(25405)),s="rec_compute_bound",r={props:{data:{type:Array,required:!0}},data:()=>({isExpanded:!0}),computed:{boundedBy(){const e=[s,"rec_memory_bound","rec_other_bound"];return this.data.find((({id:t})=>e.includes(t)))},limitingRoof(){const{params:e,id:t}=this.boundedBy||{},{limitingRoof:i=""}=e||{},{offloadBoundedBy:o=""}=e||{};let r="",a="";t===s&&(a=i,r=this.$t("Compute"));const l=o.toLowerCase()||r.toLowerCase()||i.toLowerCase().split(" ")[0]||"unknown";return{name:r||i||this.$t(o),desc:a,style:{color:n.default[l]},isOffload:!!o}},rec(){const e=["rec_cache_line_utilization","rec_cache_locality"],{id:t,params:i={}}=this.data.find((({id:t})=>e.includes(t)))||{};return this.$t(t,Object.values(i))},isExpandable(){return!!this.rec&&"..."!==this.rec}}};t.default=r},38965:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"message-text-item"},[t("div",{staticClass:"message-text-item-body"},[t("message-image",{staticClass:"item-image",attrs:{type:e.textItem.imageType,classes:e.imageClasses}}),e._v(" "),t("message-text",{attrs:{text:e.getText(e.textItem)},on:{linkClick:e.onLinkClick}})],1),e._v(" "),e.textItem.fullText?t("div",{staticClass:"more-less-button",on:{click:e.onMoreLess}},[e._v("\n    "+e._s(e.getMoreLessCaption())+"\n  ")]):e._e()])};o._withStripped=!0;const n={props:{textItem:{type:Object,required:!0}},data:()=>({imageClasses:["none","list","alert-triangle","cross-circle","information-circle"]}),methods:{getText(e){return e?void 0===this.textItem.isBrief||this.textItem.isBrief?e.briefText:e.fullText:""},getMoreLessCaption(){return this.textItem.isBrief?this.$t("expand_link_name"):this.$t("collapse_link_name")},onMoreLess(){this.textItem.isBrief=!this.textItem.isBrief},onLinkClick(e){this.$emit("linkClick",e)}}},s=(0,i(98822).A)(n,o,[],!1,null,"0192c3f1",null).exports},39299:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("span",e._l(e.filteredAttrs,(function(i,o){return t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:i.tooltip,expression:"attr.tooltip"}],key:o,staticClass:"attr"},[e._v("\n    "+e._s(i.name)+": "+e._s(i.value)+"\n  ")])})),0)};o._withStripped=!0,i(69212),i(43468);const n={props:{attrs:{type:Array,required:!0}},computed:{filteredAttrs(){return this.attrs.filter((e=>e.value&&e.value.toString().length>0))}}},s=(0,i(98822).A)(n,o,[],!1,null,"a2f7228c",null).exports},39668:e=>{e.exports=' <h4>Data type conversions present</h4> <div class="essential"> There are multiple data types within loops. Utilize hardware vectorization support more effectively by avoiding data type conversion. </div>'},39699:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(){var e=this,t=e._self._c;return t("section",{staticClass:"hint"},[t("i",{staticClass:"icon megaphone"}),e._v(" "),t("aside",[t("h4",{on:{click:function(t){e.showContent=!e.showContent}}},[e._t("title")],2),e._v(" "),t("slide-transition",[t("div",{directives:[{name:"show",rawName:"v-show",value:e.showContent,expression:"showContent"}],staticClass:"content"},[e._t("content")],2)])],1)])};o._withStripped=!0;const n=(0,i(98822).A)({data:()=>({showContent:!1})},o,[],!1,null,"270cb932",null).exports},39708:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("svg",{staticClass:"svg",attrs:{id:"svg",width:e.getSvgSize.x,height:e.getSvgSize.y}},[t("line",{staticClass:"shape",attrs:{x1:e.line1.x1,x2:e.line1.x2,y1:e.line1.y1,y2:e.line1.y2,opacity:e.line1.opacity,stroke:e.lineColor,"stroke-width":e.getStrokeWigth}}),e._v(" "),t("line",{staticClass:"shape",attrs:{x1:e.line2.x1,x2:e.line2.x2,y1:e.line2.y1,y2:e.line2.y2,opacity:e.line2.opacity,stroke:e.lineColor,"stroke-width":e.getStrokeWigth}}),e._v(" "),t("circle",{staticClass:"clickable shape",attrs:{cx:e.CPU1.x,cy:e.CPU1.y,r:e.getInnerRadius,fill:e.getCenterColor(e.CPU1),opacity:e.getOpacity(e.CPU1),stroke:e.backgroundCirculColor,"stroke-width":e.getStrokeWigth},on:{click:function(t){return e.setModelingState(e.CPU1)}}}),e._v(" "),t("circle",{staticClass:"clickable shape",attrs:{cx:e.CPU2.x,cy:e.CPU2.y,r:e.getInnerRadius,fill:e.getCenterColor(e.CPU2),opacity:e.getOpacity(e.CPU2),stroke:e.backgroundCirculColor,"stroke-width":e.getStrokeWigth},on:{click:function(t){return e.setModelingState(e.CPU2)}}}),e._v(" "),t("circle",{staticClass:"clickable shape",attrs:{cx:e.GPU1.x,cy:e.GPU1.y,r:e.getInnerRadius,fill:e.getCenterColor(e.GPU1),opacity:e.getOpacity(e.GPU1),stroke:e.backgroundCirculColor,"stroke-width":e.getStrokeWigth},on:{click:function(t){return e.setModelingState(e.GPU1)}}}),e._v(" "),t("circle",{staticClass:"clickable shape",attrs:{cx:e.GPU2.x,cy:e.GPU2.y,r:e.getInnerRadius,fill:e.getCenterColor(e.GPU2),opacity:e.getOpacity(e.GPU2),stroke:e.backgroundCirculColor,"stroke-width":e.getStrokeWigth},on:{click:function(t){return e.setModelingState(e.GPU2)}}}),e._v(" "),t("text",{staticClass:"clickable",attrs:{x:e.CPU1.x,y:e.CPU1.y+6,fill:"white","font-size":"18","font-family":"icons","alignment-baseline":"bottom","text-anchor":"middle"},on:{click:function(t){return e.setModelingState(e.CPU1)}}},[e._v("")]),e._v(" "),t("text",{staticClass:"clickable",attrs:{x:e.CPU2.x,y:e.CPU2.y+6,fill:"white","font-size":"18","font-family":"icons","alignment-baseline":"bottom","text-anchor":"middle"},on:{click:function(t){return e.setModelingState(e.CPU2)}}},[e._v("")]),e._v(" "),t("text",{staticClass:"clickable",attrs:{x:e.GPU1.x,y:e.GPU1.y+6,fill:"white","font-size":"18","font-family":"icons","alignment-baseline":"bottom","text-anchor":"middle"},on:{click:function(t){return e.setModelingState(e.GPU1)}}},[e._v("")]),e._v(" "),t("text",{staticClass:"clickable",attrs:{x:e.GPU2.x,y:e.GPU2.y+6,fill:"white","font-size":"18","font-family":"icons","alignment-baseline":"bottom","text-anchor":"middle"},on:{click:function(t){return e.setModelingState(e.GPU2)}}},[e._v("")])])};o._withStripped=!0;var n=i(85038);const s={props:["radius"],computed:{getStrokeWigth(){return this.radius/4},getInnerRadius(){return this.radius/4*3},getSvgSize(){return{x:5*this.radius,y:4*this.radius+this.radius/2}},getMessage(){if(!this.modelingBlock.CPU1.activated&&!this.modelingBlock.GPU1.activated||!this.modelingBlock.CPU2.activated&&!this.modelingBlock.GPU2.activated)return"Please, select the both sides";let e="Offload most of the code from ";return this.modelingBlock.CPU1.activated&this.modelingBlock.GPU1.activated?e+="CPU + GPU":this.modelingBlock.CPU1.activated?e+="CPU":this.modelingBlock.GPU1.activated&&(e+="GPU"),e+=" to ",this.modelingBlock.CPU2.activated&this.modelingBlock.GPU2.activated?e+="CPU` + GPU`":this.modelingBlock.CPU2.activated?e+="CPU`":this.modelingBlock.GPU2.activated&&(e+="GPU`"),e}},data(){const e=4*this.radius,t=this.radius/4,i=this.radius/4;return{offsetX:this.radius/4,offsetY:this.radius/4,lineColor:n.light.L3,backgroundCirculColor:n.light.L3,backgroundColor:n.intel.primary.white,frontCirculColorMeasured:n.intel.accent["digital-blue"],frontCirculColorModeled:n.intel.accent.green,CPU1:{name:"CPU1",x:this.radius+i,y:this.radius,opacity:1,measured:!0},CPU2:{name:"CPU2",x:e-i,y:this.radius,opacity:1,measured:!1},GPU1:{name:"GPU1",x:this.radius+i,y:e-2*t,opacity:1,measured:!0},GPU2:{name:"GPU2",x:e-i,y:e-2*t,opacity:1,measured:!1},line1:{x1:null,y1:null,x2:null,y2:null,opacity:1},line2:{x1:null,y1:null,x2:null,y2:null,opacity:1},modelingBlock:{CPU1:{activated:!0},CPU2:{activated:!0},GPU1:{activated:!0},GPU2:{activated:!0}}}},mounted(){this.recalcLines()},methods:{getOpacity(e){return this.modelingBlock[e.name].activated?1:.3},getCenterColor(e){return this.modelingBlock[e.name].activated?e.measured?this.frontCirculColorMeasured:this.frontCirculColorModeled:this.backgroundCirculColor},getCoord(e,t,i){let o=i,n=i;return this.modelingBlock[e.name].activated?({x:o,y:n}=e):this.modelingBlock[t.name].activated&&({x:o,y:n}=t),{x:o,y:n}},recalcLines(){this.line1.x1=this.getCoord(this.CPU1,this.GPU1,-1).x,this.line1.y1=this.getCoord(this.CPU1,this.GPU1,this.CPU1.y).y,this.line1.x2=this.getCoord(this.CPU2,this.GPU2,this.CPU1.x).x,this.line1.y2=this.getCoord(this.CPU2,this.GPU2,this.line1.y1).y,this.line2.x1=this.getCoord(this.GPU1,this.CPU1,-1).x,this.line2.y1=this.getCoord(this.GPU1,this.CPU1,this.GPU1.y).y,this.line2.x2=this.getCoord(this.GPU2,this.CPU2,this.GPU1.x).x,this.line2.y2=this.getCoord(this.GPU2,this.CPU2,this.line2.y1).y,this.line1.opacity=-1===this.line1.x1?0:1,this.line2.opacity=-1===this.line2.x1?0:1,this.$emit("text-updated",this.getMessage)},setModelingState(e){this.modelingBlock[e.name].activated=!this.modelingBlock[e.name].activated,this.recalcLines()}}},r=(0,i(98822).A)(s,o,[],!1,null,"2e2110f2",null).exports},39844:e=>{e.exports=' <h4>Force vectorization if possible</h4> <div class="text"> <div class="promo"> <div id="no_dependency_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-3DE3B537-A174-44F8-9993-AD17D70866CA.html">Dependencies analysis</a> to identify real data dependencies. </div> The loop contains SQRT/DIV instructions (so vectorization could be beneficial), but is not vectorized. To fix, review: <ul> <li>Corresponding compiler diagnostic to check if vectorization enforcement is possible and profitable</li> <li>The Dependencies analysis to distinguish between compiler-assumed dependencies and real dependencies</li> </ul> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> '},39907:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{ref:"drag-area",staticClass:"splitter",class:{collapsed:e.collapsed},on:{pointerdown:e.onPointerDown,pointermove:e.onPointerMove,pointerup:e.onPointerUp,lostpointercapture:e.onLostPointerCapture}},[t("div",{staticClass:"central-area",class:e.collapseIcon,on:{click:e.onClick}})])};o._withStripped=!0;const n={props:{collapsed:Boolean},computed:{collapseIcon(){return this.collapsed?"icon caret-down":"icon caret-up"}},methods:{onPointerDown(e){const{pointerId:t,target:i}=e;i===this.$refs["drag-area"]&&(this.pointerId=t,this.$refs["drag-area"].setPointerCapture(t),e.preventDefault(),e.stopPropagation())},onPointerMove(e){if(!this.pointerId)return;const{layerY:t}=e;this.$emit("resized",t),e.preventDefault(),e.stopPropagation()},onPointerUp(e){if(!this.pointerId)return;const{pointerId:t}=e;this.$refs["drag-area"].releasePointerCapture(t),e.preventDefault(),e.stopPropagation()},onLostPointerCapture(){this.pointerId=void 0},onClick(){this.$emit(this.collapsed?"expanded":"collapsed")}}},s=(0,i(98822).A)(n,o,[],!1,null,"1bb35ace",null).exports},39963:(e,t,i)=>{"use strict";i(27468),i(69212),i(21602),i(32204),Object.defineProperty(t,"B",{value:!0});const o={props:{value:Number,valueMin:{type:Number,default:0},valueMax:{type:Number,default:1},color:String,values:Array,colors:Array,minWidth:{type:String,default:"0"}},computed:{items(){const{value:e,color:t,values:i,colors:o}=this,n=i||[e],s=o||[t];let r=[],a=[];if(this.valueMin>0){r=[this.getItem(this.valueMin,"transparent","gap")];const e=this.valueMin+n.reduce(((e,t)=>e+t));e<this.valueMax&&(a=[this.getItem(this.valueMax-e,"","gap default-background")])}const l=n.map(((e,t)=>this.getItem(e,s[t])));return[...r,...l,...a]},barChartStyle(){return this.valueMax<1?`margin-right: ${this.getPercentValue(1-this.valueMax)}`:""}},methods:{getPercentValue:e=>100*e+"%",getWidth(e){const t=e/this.valueMax;return this.getPercentValue(t)},getMinWidth(e){return e>0?this.minWidth:"0"},getItem(e,t,i){return{value:e,color:t,className:i=i||"",width:this.getWidth(e),minWidth:this.getMinWidth(e)}}}};t.A=o},40169:e=>{e.exports=' <h4>Code region is recommended for offloading</h4> <div class="text promo"> Based on the <b>Offload Modeling</b> results, this code region is potentially profitable to offload. Estimated relative speedup on the %target_device% accelerator is %speed_up% compared to the current platform. Consider using <a href="https://www.intel.com/content/www/us/en/docs/oneapi/programming-guide/current/data-parallelism-in-c-using-sycl.html"> Data Parallel C++ (DPC++)</a> or <a href="https://www.intel.com/content/www/us/en/docs/oneapi/programming-guide/current/c-c-or-fortran-with-openmp-offload-programming.html"> OpenMP* Offload Programming Model</a> to offload this region to the target accelerator. <p class="expander">Example of using a DPC++ <b>parallel for</b> construct for offloading:</p> <pre class="essential"><code class="cpp" data-source="\n...\n        cgh.parallel_for<kernel>(N, [=](id<1> i) {   \n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\n    buffer<double, 1> a_buf(matrixA, N);\n    buffer<double, 1> b_buf(matrixB, N);\n    buffer<double, 1> c_buf(matrixC, N);\n\n    q.submit([&](handler &cgh)\n    {\n        auto A = a_buf.get_access<access::mode::read>(cgh);\n        auto B = b_buf.get_access<access::mode::read>(cgh);\n        auto C = c_buf.get_access<access::mode::read_write>(cgh);\n\n        cgh.parallel_for<kernel>(N, [=](id<1> i) {   \n            for(size_t j=0; j<N; j++)\n            {\n                double cvalue = 0;\n                for(size_t k=0; k<N; k++)\n                    cvalue += A[i*N+k] * B[k*N+j];\n                C[i*N+j] = cvalue;\n            }\n        });\n    });\n"></code></pre> <p class="expander">Example of using OpenMP <b>target</b> construct for offloading:</p> <pre class="essential"><code class="cpp" data-source="\n...\n    #pragma omp target teams distribute parallel for map(to: matrixA, matrixB) map(from: matrixC) private(i, j, k) \n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\n    int i, j, k;\n    #pragma omp target teams distribute parallel for map(to: matrixA, matrixB) map(from: matrixC) private(i, j, k) \n    for(size_t i=0; i<N; i++)\n        for(size_t j=0; j<N; j++)\n        {\n            double cvalue = 0;\n            for(size_t k=0; k<N; k++)\n                cvalue += matrixA[i*N+k] * matrixB[k*N+j];\n            matrixC[i*N+j] = cvalue;\n        }\n"></code></pre> </div> '},40187:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"bar-chart",class:{"default-background":0===e.valueMin},style:e.barChartStyle},e._l(e.items,(function(e,i){return t("div",{key:i,class:e.className,style:{width:e.width,minWidth:e.minWidth,background:e.color}})})),0)};o._withStripped=!0;var n=i(39963);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"0ba52ff4",null).exports},40535:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});const o={props:{knob:Object},mounted(){console.warn(`not implemented "${this.knob.type}" knob`,this.knob)},render(){return this.$slots.default}},n=(0,i(98822).A)(o,void 0,void 0,!1,null,null,null).exports},40773:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return e.isEmpty?e._e():t("div",{staticClass:"container"},[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.metric1.tooltip,expression:"metric1.tooltip"}],staticClass:"metric"},[e._v("\n    "+e._s(e.metric1.title)),t("br"),e._v(" "),t("span",[e._v(e._s(e.value1))])]),e._v(" "),t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.metric2.tooltip,expression:"metric2.tooltip"}],staticClass:"metric"},[e._v("\n    "+e._s(e.metric2.title)),t("br"),e._v(" "),t("span",[e._v(e._s(e.value2))])])])};o._withStripped=!0;var n=i(77106);const s={props:{metric1:{type:Object,required:!0},metric2:{type:Object,required:!0}},computed:{isEmpty(){return!(this.metric1.value&&this.metric2.value)},value1(){return this.metric1.formattedValue||(0,n.formatNumber)(this.metric1)},value2(){return this.metric2.formattedValue||(0,n.formatNumber)(this.metric2)}}},r=(0,i(98822).A)(s,o,[],!1,null,"f54205ce",null).exports},40838:(e,t,i)=>{"use strict";i.d(t,{A:()=>d,w:()=>p});var o=i(61262);const n="data-adv-tooltip",s=Symbol("tooltipTraits");let r,a;function l(e){if(!e)return;const{text:t,target:i}=function(e){let t,i;for(;e;){if(t=e.getAttribute(n),t){i=e;break}e=e.parentElement}return{text:t,target:i}}(e);return t?(r=i,{text:t,target:i,delay:350,...e[s]}):void 0}let c=0;function d(e,t,i={}){e&&(e.hasAttribute(n)||c++,e.setAttribute(n,t),e[s]=i,a||(a=(0,o.addTooltip)(document.body,l,(e=>!0),"custom_tooltip")),e===r&&a.update())}function p(e){r&&e===r&&(a.hide&&a.hide(),r=void 0),c&&c--,!c&&a&&(a.destroy(),a=void 0)}},40941:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"content-card"},[t("div",{staticClass:"title",class:{top:e.top}},[t("span",{staticClass:"caption"},[t("i",{class:e.icon}),e._v("\n      "+e._s(e.$t(e.caption))+"\n    ")]),e._v(" "),e.canCollapse?t("span",{staticClass:"toggle",class:{collapsed:e.isCollapsed},on:{click:function(t){return t.preventDefault(),e.onToggleClick.apply(null,arguments)}}},[t("i",{class:e.collapseIcon})]):e._e()]),e._v(" "),e._t("default")],2)};o._withStripped=!0;var n=i(1067);const s={props:{type:{type:String,validator:e=>"string"==typeof e&&n.TYPES.includes(e),required:!0},top:Boolean,canCollapse:{type:Boolean,default:!1}},data:()=>({isCollapsed:!1}),computed:{icon(){return this.type===n.CPU?"icon cpu":"icon gpu"},caption(){return this.type===n.CPU?"cpu_card_caption":"gpu_card_caption"},collapseIcon(){return this.isCollapsed?"icon chevron-down":"icon chevron-up"}},methods:{onToggleClick(){this.isCollapsed=!this.isCollapsed,this.$emit("collapsed",this.isCollapsed)}}},r=(0,i(98822).A)(s,o,[],!1,null,"63ff0a2c",null).exports},41279:e=>{e.exports=' <h4>Move OpenMP call(s) outside the loop body</h4> <div class="text"> <div class="promo"> OpenMP calls prevent automatic vectorization when the compiler cannot move the calls outside the <span data-glossary-id="loop_body">loop body</span>, such as when OpenMP calls are not invariant. To fix: <ol> <li> Split the OpenMP parallel loop <span data-glossary-id="directive">directive</span> into two <span data-glossary-id="directive">directives</span>. <table> <thead> <tr> <th> Target </th> <th> Directive </th> </tr> </thead> <tbody> <tr> <td> Outer </td> <td> #pragma omp parallel [clause, clause, ...] </td> </tr> <tr> <td> Inner </td> <td> #pragma omp for [clause, clause, ...] </td> </tr> </tbody> </table> </li> <li>Move the OpenMP calls outside the loop when possible.</li> </ol> <p class="expander">Example (original code)</p> <pre class="expansion"><code class="cpp">#pragma omp parallel for private(tid, nthreads)\nfor (int k = 0; k &lt; N; k++)\n{\n    tid = omp_get_thread_num(); // this call inside loop prevents vectorization\n    nthreads = omp_get_num_threads(); // this call inside loop prevents vectorization\n    ...\n}</code></pre> </div> <p class="expander">Example (revised code)</p> <pre class="expansion"><code class="cpp">#pragma omp parallel private(tid, nthreads)\n{\n    // Move OpenMP calls here\n    tid = omp_get_thread_num();\n    nthreads = omp_get_num_threads();\n\n    #pragma omp for nowait\n    for (int k = 0; k &lt; N; k++)\n    {\n        ...\n    }\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <i>omp for</i>, <i>omp parallel recommendations</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html"> OpenMP* Pragmas Summary</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html"> Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},41280:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>l});var o=function(){var e=this,t=e._self._c;return e.idea.content?t("article",{staticClass:"idea"},[t("rec-headline",{ref:"header",staticClass:"idea",class:[e.confidence,e.promo?"closed":""],attrs:{title:e.idea.header,attrs:e.attrs},nativeOn:{click:function(t){e.promo=!e.promo,e.$bus.$emit("rec-header-clicked",e.$refs.header.$el)}}}),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.promo,expression:"promo"}],ref:"promo",domProps:{innerHTML:e._s(e.idea.promo)}}),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.promo,expression:"!promo"}],ref:"content",domProps:{innerHTML:e._s(e.idea.content)}})],1):t(e.idea.id,{tag:"component",attrs:{idea:e.idea}})};o._withStripped=!0;var n=i(72127),s=i(79091),r=i(1033);const a={props:{idea:{type:Object,required:!0}},data:()=>({promo:!0}),methods:{updateExpanders(){this.$refs.content&&(0,s.A)(this.$refs.content,!0),this.$refs.promo&&(0,s.A)(this.$refs.promo)},updateGlossaryTip(){this.$refs.content&&(0,r.A)(this.$refs.content),this.$refs.promo&&(0,r.A)(this.$refs.promo)}},computed:{confidence(){return(0,n.A)(this.idea.confidence)},attrs(){return[{name:this.$t("confidence_name"),value:this.confidence,tooltip:this.$t("confidence_tooltip")}]}},mounted(){this.setPromoOff=e=>this.promo=!1,this.$bus.$on("rec-#"+this.$el.id,this.setPromoOff),this.updateExpanders(),this.updateGlossaryTip()},updated(){this.updateExpanders(),this.updateGlossaryTip()},beforeDestroy(){this.$bus.$off("rec-#"+this.$el.id,this.setPromoOff)}},l=(0,i(98822).A)(a,o,[],!1,null,"77a7383a",null).exports},41602:e=>{e.exports=' <h4>Potential reduction detected</h4> <div class="text promo"> Potential reduction is detected in this code region. When rewriting the code with a target framework, implement the reduction pattern for this region. <p class="expander">Example of reduction on OpenMP:</p> <pre class="essential"><code class="fortran" data-source="\n    !$omp target parallel do map(to: data) reduction(+ : sum) \n...\n"></code></pre> <pre class="expansion"><code class="fortran" data-source="\n    !$omp target parallel do map(to: data) reduction(+ : sum) \n    do i = 1, globalRange\n        sum = sum + data(i)\n    enddo\n"></code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://github.com/intel/llvm/blob/sycl/sycl/doc/extensions/Reduction/Reduction.md"> Reduction (draft specification)</a> </li> </ul> </div> '},41633:e=>{e.exports=' <h4>Enforce the compiler to ignore assumed vector dependencies</h4> <div class="text"> <p> <span class="promo"> To ensure correct code, the compiler treats an assumed dependence as a proven dependence, which results in additional checks using heavy conflict detection instructions. However, there were no real vector dependencies detected and "ivdep" pragma may be used to override the compiler\'s decision. To fix: Tell the compiler it is safe to vectorize without resolving dependencies </span> using the <span data-glossary-id="directive">directive</span> <samp class="codeph">#pragma ivdep</samp>. Note that it may potentially be unsafe on other input parameters. </p> <div class="promo"> <p class="expander">Example</p> <pre class="essential"><code class="cpp">#pragma ivdep ...</code></pre> <pre class="expansion"><code class="cpp">#pragma ivdep\nfor (i = 0; i &lt; n; i++)\n{\n    a[index[i]] = b[i] * c;\n}</code></pre></div> <p class="expander">Read more</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-B25ABCC2-BE6F-4599-AEDF-2434F4676E1B.htm">ivdep</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},41975:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"snippet"},[t("div",{on:{click:function(t){e.showExample=!e.showExample}}},[t("i",{staticClass:"icon caret-right",class:{expanded:e.showExample}}),e._v("Example\n  ")]),e._v(" "),t("slide-transition",[t("pre",{directives:[{name:"show",rawName:"v-show",value:e.showExample,expression:"showExample"}]},[t("code",{domProps:{innerHTML:e._s(e.code)}})])])],1)};o._withStripped=!0;var n=i(62285),s=i.n(n);const r={props:["source"],data:()=>({showExample:!0}),computed:{code(){return s().highlight(this.source,{language:"cpp",ignoreIllegals:!0}).value}}},a=(0,i(98822).A)(r,o,[],!1,null,"dcbd23cc",null).exports},42072:e=>{e.exports=' <h4>GRF register pressure present</h4> <div class="essential"> %disclaimer% In this code region, <span data-glossary-id="GRF">GRF</span> register pressure is caused by a big size of kernel arguments. <br><br> Kernel arguments, private variables, and intermediate calculation results are allocated in the <span data-glossary-id="GRF">GRF</span>. Using big kernel arguments or complex structures can increase register pressure, which can result in <span data-glossary-id="spilling">spills</span> and decrease performance. <br><br> The current kernel arguments size is %kernel_arg_size% bytes, the available <span data-glossary-id="GRF">GRF</span> size is %grf_size% bytes per GPU thread. The kernel arguments use %grf_usage_per% of the <span data-glossary-id="GRF">GRF</span> size that is estimated as %grf_usage% <span data-glossary-id="GRF">GRF</span> register pressure. </div> '},42128:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",[t("transition",{attrs:{name:"fade"}},[e.hotspotStyle?t("div",{staticClass:"hotspot",style:e.hotspotStyle}):e._e()]),e._v(" "),t("div",{staticClass:"cursor",style:e.cursorStyle,domProps:{innerHTML:e._s(e.caption)}})],1)};o._withStripped=!0;var n=i(87565);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"6475e478",null).exports},42188:e=>{e.exports=' <h4>Enable auto-vectorization</h4> <div class="text"> <div class="promo"> You compiled with auto-vectorization disabled; enable auto-vectorization: <ul> <li>Intel compiler 14.x or below: Increase the optimization level to O2 or O3.</li> <li>Microsoft Visual C++* compiler: Increase the optimization level to O2 or O3.</li> <li>GNU* gcc compiler, do one of the following:</li> <ul> <li>Increase the optimization level to O2 or O3.</li> <li>Use the ftree-vectorize compiler option</li> </ul> </ul> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://msdn.microsoft.com/en-us/library/fwkeyyhe.aspx">Visual Studio 2015/Visual C++ Compiler Options Listed Alphabetically</a> </li> <li> <a href="https://gcc.gnu.org/onlinedocs/">GCC online documentation</a> </li> </ul> </div>'},42248:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(2798),n=i(62424),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"75a035ea",null).exports},42612:(e,t,i)=>{"use strict";i.d(t,{G_:()=>l,d2:()=>s,ki:()=>a}),i(27468),i(69212),i(32204);var o=i(33874);function n(e){if(!e)return!1;switch(e.type){case"boolean":if(!1===e.value)return!1;break;case"enum":if(void 0===e.value||e.value===e.defaultValue)return!1;break;default:console.error(`Overhead by value for ${e.type} knobs is not implemented`)}return!0}function s(e,t,i,s){const r=o.C.get(t,i).preset(e);let a=r.overhead||0;for(const[e,t]of Object.entries(r.knobs))t.overhead&&n(s[e])&&(a+=t.overhead||0);return a}const r=new Map;function a(e,t,i,n="max"){const s=t+n+e+"/"+i;if(r.has(s))return r.get(s);const a=o.C.get(t,i).preset(e);let l=a.overhead||0;for(const e of Object.values(a.knobs))e.overhead&&("max"===n||e[n])&&(l+=e.overhead||0);return r.set(s,l),l}function l(e){return Object.keys(e).reduce(((t,i)=>(e[i].visibility&&(t[i]=e[i]),t)),{})}},42642:e=>{e.exports=' <h4>Enforce the compiler to ignore assumed vector dependencies</h4> <div class="text"> <div class="promo"> No real dependencies were detected, so there is no need for conflict-detection instructions. To fix: Tell the compiler it is safe to vectorize using a <span data-glossary-id="directive">directive</span> <samp class="codeph">#pragma ivdep</samp>. Note: This fix may be unsafe in other scenarios; use with care to avoid incorrect results. <p class="expander">Example</p> <pre class="expansion"><code class="cpp">#pragma ivdep\n    for (i = 0; i &lt; n; i++)\n    {\n        a[index[i]] = b[i] * c;\n    }</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-B25ABCC2-BE6F-4599-AEDF-2434F4676E1B.html">ivdep</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html"> Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},42721:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("layout-panel-card",{style:e.flex,attrs:{type:"gpu","can-collapse":""},on:{collapsed:e.onCollapsed}},[e.compact?t("div",{staticClass:"perf-data compact"},[e.compactData?t("bar-metric",e._b({attrs:{compact:!0}},"bar-metric",e.compactData,!1)):e._e()],1):t("div",{staticClass:"perf-data"},[e.legend.length?t("layout-panel-group",[t("div",[t("div",{staticClass:"chart"},[t("idvc-pie-chart",{attrs:{size:74,innerRadius:.7,hidePercentLabels:!0,"chart-data":e.chart}})],1),e._v(" "),t("div",{staticClass:"legend"},e._l(e.legend,(function(i){return t("legend-metric",e._b({key:i.id},"legend-metric",i,!1))})),1)])]):e._e(),e._v(" "),t("div",{staticClass:"list"},e._l(e.list,(function(i){return t("legend-metric",e._b({key:i.id},"legend-metric",i,!1))})),1)],1)])},n=[];o._withStripped=!0},42933:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(42721),n=i(51749),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"685e0cc8",null).exports},42973:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n}),i(69212),i(38333);var o=i(18977);const n={created(){o.A.layout.hidePanel((({caption:e})=>{const{view:t}=this,i=this.$store.direct.getters.layout.getAllTabs(t),{slotIndex:o}=i.find((t=>t.caption===e))||{};return void 0===o?"Error: Panel does not exist":(this.$store.direct.dispatch.layout.hidePanel({view:t,slotIndex:o}),!0)}))}}},43399:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(46897),n=i(37255),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"63550436",null).exports},43792:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",[t("div",{staticClass:"group"},[t("div",{staticClass:"chart"},[t("idvc-pie-chart",{attrs:{size:74,innerRadius:.7,hidePercentLabels:!0,"chart-data":e.chart}})],1),e._v(" "),t("div",{staticClass:"legend"},e._l(e.legend,(function(i){return t("legend-metric",e._b({key:i.id},"legend-metric",i,!1))})),1)]),e._v(" "),t("div",{staticClass:"list"},e._l(e.list,(function(i){return t("legend-metric",e._b({key:i.id},"legend-metric",i,!1))})),1)])},n=[];o._withStripped=!0},43823:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("table-view",{staticClass:"content",attrs:{columns:e.gridColumns,rows:e.getTopNonOffloadedData.rows||[],"single-line-header":""},scopedSlots:e._u([{key:"execution_time",fn:function({row:i}){return[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.getTimeRegionToolTip(i,e.speedUp,e.allColumns),expression:"getTimeRegionToolTip(row, speedUp, allColumns)"}],staticClass:"speedup-metrics"},[t("region-time-chart",{staticClass:"bar",attrs:{row:i,"bars-height":"2.667em","bar-width":.14,allColumns:e.allColumns,timeKeys:e.speedUp}}),e._v(" "),t("metric-item",{staticClass:"time-metric orig",attrs:{metric:e.getOffloadElapsedTime(i)}}),e._v(" "),t("metric-item",{staticClass:"time-metric accel",attrs:{metric:e.getEstimatedAccelTime(i)}})],1)]}},{key:"offload_bounded_by",fn:function({row:i,column:o}){return[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.getTimeRegionToolTip(i,e.boundedBy,e.allColumns),expression:"getTimeRegionToolTip(row, boundedBy, allColumns)"}],staticClass:"bound-by-metrics"},[t("region-time-chart",{staticClass:"bar",attrs:{row:i,"bars-height":e.getHeightByNumberOfBars(i),"bar-width":.85,allColumns:e.allColumns,timeKeys:e.getBoundedByKeysSorted(i)}}),e._v(" "),t("div",{staticClass:"info-after"},[e._v(e._s(e.getColumnInfo(i,o.id,e.allColumns)))])],1)]}},{key:"location",fn:function({row:i,value:o}){return[t("router-link",{attrs:{to:{name:"offload:accelerated-regions"}},nativeOn:{click:function(t){return e.onDrillDown(i)}}},[e._v("\n      "+e._s(o)+"\n    ")])]}}])})};o._withStripped=!0,i(36094);var n=i(75337);const s={inject:["api"],mixins:[i(27477).p],created(){this.updateNonOffloaded()},computed:{...(0,n.mapGetters)("offload",["getTopNonOffloadedData"]),allColumns(){return{execution_time:{id:"execution_time",title:this.$t("execution_time"),tooltip:this.$t("execution_time_tooltip")},...this.getTopNonOffloadedData.columns}},gridColumns(){return this.updateGridColumns([{id:"location",width:"minmax(13rem, 1fr)"},{id:"execution_time",width:"max-content"},{id:"offload_bounded_by",width:"minmax(13rem, 1fr)"},{id:"why_not_offloaded",width:"minmax(13rem, 1fr)"},{id:"data_transferred_total",width:"max-content",align:"right"}])}},data:()=>({boundedBy:{acceleratedBreakdown:[],taxes:[]},speedUp:{original:"offload_elapsed_time",totalAccelerated:"total_time_on_accel"}}),methods:{getEstimatedAccelTime(e){const t=this.speedUp.totalAccelerated||"total_time_on_accel";return this.getTopRegionColumn(e,t,this.allColumns)},getOffloadElapsedTime(e){return this.getTopRegionColumn(e,this.speedUp.original,this.allColumns)},updateNonOffloaded(){if(!this.boundedBy.taxes.length||!this.boundedBy.acceleratedBreakdown.length)for(const e in this.allColumns)e.startsWith("offload_taxes_")||e.startsWith("latencies_")?this.boundedBy.taxes.push(e):e.startsWith("throughput_")&&this.boundedBy.acceleratedBreakdown.push(e)}}},r=(0,i(98822).A)(s,o,[],!1,null,"7a03e923",null).exports},44164:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(54759),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},44316:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"traits_summary"}},[t("div",{staticClass:"content"},[t("div",{attrs:{name:"title"}},[e._v(e._s(e.$t("traits-summary")))]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.compact,expression:"compact"}],staticClass:"essential"},[t("div",{attrs:{id:"traits"}})]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.compact,expression:"!compact"}],staticClass:"expansion"},[t("div",{attrs:{id:"traits_details"}})])])])};o._withStripped=!0,i(69212),i(45361);const n={traits:["Type Conversions","Masked Stores","Shuffles","Permute","Inserts","Shuffles","Permute","Inserts","Shuffles","Permute","Inserts","Shuffles","Permute","Inserts","Shuffles"],tips:[{first:"Type Conversions",second:"Loop Branches May Decrease Performance<br/>Suggestions: Loop Splitting, __builtin_expect"},{first:"Type Conversions",second:"Irregular Memory Access Patterns May Decrease Performance<br/>Suggestion: See Recommendations Tab"},{first:"Masked Stores",second:"Irregular Memory Access Patterns May Decrease Performance<br/>Suggestion: See Recommendations Tab"},{first:"Shuffles",second:"Irregular Memory Access Patterns May Decrease Performance<br/>Suggestion: See Recommendations Tab"}]},s={computed:{compact(){return this.$parent.compact}},mounted(){const{$el:e,calculateHeight:t}=this,i=qs("[name = title]",e);i.classList.remove("with_warning"),qs("#traits",e).innerHTML=n.traits.join(", ");const o=qs("#traits_details",e);for(;null!=o.firstChild;)o.removeChild(o.firstChild);void 0!==n.traits&&n.traits.forEach((e=>{const s=document.createElement("div");s.classList.add("trait");const r=document.createElement("span");r.innerHTML=e,s.appendChild(r),void 0!==n.tips&&n.tips.forEach((o=>{if(o.first==e){i.classList.add("with_warning");const e=qs(".warning",s);if(null!==e){const t=qs("ul",e),i=document.createElement("li");i.innerHTML=o.second,t.appendChild(i),e.appendChild(t)}else{r.classList.add("with_warnings");const e=document.createElement("div"),i=document.createElement("ul"),n=document.createElement("li");n.innerHTML=o.second,i.appendChild(n),e.appendChild(i),e.classList.add("warning"),s.addEventListener("click",(i=>{r.classList.toggle("shown"),r.classList.contains("shown")?e.style.height=t(e)+"px":e.style.height=0,e.classList.add("animated"),$invoke("sectionChanged")})),s.appendChild(e)}}})),o.appendChild(s)}))},methods:{calculateHeight(e){const t=e.cloneNode(!0);t.setAttribute("style","visibility: hidden; height: auto;"),e.parentElement.appendChild(t);const i=t.offsetHeight;return e.parentElement.removeChild(t),i}}},r=(0,i(98822).A)(s,o,[],!1,null,null,null).exports},44372:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=i(75337),s=o(i(83534));t.default={components:{MetricItemBox:s.default},computed:{...(0,n.mapGetters)("gpu",["getProgramMetricsHeaderData"]),data(){return this.getProgramMetricsHeaderData}}}},44481:e=>{e.exports=' <h4>Enable the use of approximate division instructions</h4> <div class="text"> <div class="promo"> Static analysis presumes the loop may benefit from using approximate calculations. Independent dividors will be pre-calculated and replaced with multiplicators. To fix: Fine-tune your usage of the following compiler option: </div> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> <th> Comment </th> </tr> </thead> <tbody> <tr> <td>/Qprec-div-</td> <td>-no-prec-div</td> <td><p><samp class="codeph">-no-prec-div</samp> enables the use of approximate devision optimizations.</p></td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/prec-div-qprec-div.html">prec-div, Qprec-div</a> in the <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/overview.html">Intel&reg; Fortran Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/floating-point-operations.html">Floating-Point Operations</a> and <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/floating-point-options.html">Floating-Point Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/overview.html">Intel&reg; Fortran Compiler Developer Guide and Reference</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},44604:e=>{e.exports=' <h4>Specify the expected loop trip count</h4> <div class="text"> <div class="promo"> <div id="no_tripcounts_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-91D0F36B-2F21-460B-A47B-D6EC6EF0504C.html">Trip Counts analysis</a> to generate expected number of iterations data. </div> The compiler cannot detect the <span data-glossary-id="trip_count">trip count</span> statically. To fix: Specify the expected number of iterations using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">#pragma loop_count</samp>. <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n// Iterate through a loop a minimum of three, maximum of ten, and average of five times\n#pragma loop_count min(3), max(10), avg(5)\nfor (int i=start;i&lt;=end;i++)\n...</code></pre> <pre class="expansion"><code class="cpp">#include &lt;stdio.h&gt;\n\nint mysum(int start, int end, int a)\n{\n    int iret=0;\n    // Iterate through a loop a minimum of three, maximum of ten, and average of five times\n    #pragma loop_count min(3), max(10), avg(5)\n    for (int i=start;i&lt;=end;i++)\n        iret += a;\n    return iret;\n}\n\nint main()\n{\n    int t;\n    t = mysum(1, 10, 3);\n    printf("t1=%d&#92;r&#92;n",t);\n    t = mysum(2, 6, 2);\n    printf("t2=%d&#92;r&#92;n",t);\n    t = mysum(5, 12, 1);\n    printf("t3=%d&#92;r&#92;n",t);\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-5C5112FB-898C-41E4-86EA-0CFC27591F39.html">loop_count</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},44819:e=>{e.exports=' <h4>Serialized user function call(s) present</h4> <div class="essential"> User-defined functions in the <span data-glossary-id="loop_body">loop body</span> are not vectorized. </div>'},45150:(e,t,i)=>{var o={"./roofline-float-bad-map.png":80592,"./roofline-int-bad-map.png":47545};function n(e){var t=s(e);return i(t)}function s(e){if(!i.o(o,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return o[e]}n.keys=function(){return Object.keys(o)},n.resolve=s,e.exports=n,n.id=45150},45620:e=>{e.exports=' <h4>Collect trip counts data</h4> <div class="text promo"> <div id="no_tripcounts_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-91D0F36B-2F21-460B-A47B-D6EC6EF0504C.html">Trip Counts analysis</a> to generate expected number of iterations data. </div> The Survey Report lacks <span data-glossary-id="trip_counts">trip counts</span> data that might generate more precise recommendations. </div>'},45656:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("layout-panel-template",{staticClass:"content"},[t("div",{staticClass:"top-metrics"},[t("div",{staticClass:"time-metrics"},[t("metric-item",{staticClass:"metric-item",attrs:{metric:e.totalOriginalTime}}),e._v(" "),t("metric-item",{staticClass:"metric-item",attrs:{metric:e.totalAccelTime}})],1),e._v(" "),t("metrics-bar-chart",{staticClass:"bar",attrs:{series:e.timeSeries,"bar-width":.575}})],1),e._v(" "),t("metric-list-donut-chart",{attrs:{donutHeight:130,metrics:e.getOverheadMetricsData,total:e.offloadAccelTime}},[t("metric-list",{attrs:{metrics:e.offloadMetrics,enableHovering:!1,highlightImportant:!0}})],1)],1)};o._withStripped=!0,i(69212),i(38333),i(21602);const n={computed:{...(0,i(75337).mapGetters)("offload",["getMainMetricsData","getAdditionalMetricsData","getOverheadMetricsData","getTargetDeviceData"]),totalOriginalTime(){return{...this.getTotalOriginalTimeMetric(),value_important:!0}},totalAccelTime(){return{...this.getTotalAcceleratedTimeMetric(),value_important:!0}},offloadAccelTime(){return this.getMetric("offload_accel_time")},offloadMetrics(){return[...this.getMainMetricsData,this.getTargetPlatformInfo(),this.getBaselinePlatformInfo()].map((e=>({...e,value_important:!0})))},timeSeries(){const e=this.totalOriginalTime,t={...e,name:e.title||this.$t(e.id),data:[e.value,0]},i=this.totalAccelTime;return[t,{...i,name:i.title||this.$t(i.id),data:[0,i.value||0]}]}},methods:{getMetric(e){return[...this.getMainMetricsData,...this.getAdditionalMetricsData].find((t=>t.id===e))||{}},getMetrics(e){return e.map((e=>this.getMetric(e)))},getBaselinePlatformInfo(){const e="baseline_platform";return this.getTargetDeviceData[e]||{id:e}},getTargetPlatformInfo(){const e="target_platform";return this.getTargetDeviceData[e]||{id:e}},getTotalOriginalTimeMetric(){let e=this.getMetric("total_time_on_host");return e.title||(e=this.getMetric("measured_total_time_on_host")),e},getTotalAcceleratedTimeMetric(){let e=this.getMetric("total_est_exe_time");return e.title||(e=this.getMetric("offload_accel_time")),e}}},s=(0,i(98822).A)(n,o,[],!1,null,"20fee780",null).exports},45666:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"traits_summary"}},[t("div",{staticClass:"content"},[e._m(0),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.compact,expression:"!compact"}],staticClass:"expansion"},[e._m(1)])])])};o._withStripped=!0,i(69212),i(45361);const n=74.3,s=!1,r={computed:{compact(){return this.$parent.compact}},mounted(){const{$el:e,drawEfficiency:t}=this;let i="~",o=n;o>100&&(o=100,i=">="),qsa("[name=vector_gain]",e).forEach((function(e){e.innerHTML="2.617x"})),qsa("[name=vector_efficiency]",e).forEach((function(e){e.innerHTML=i+Math.round(o)+"%"})),qsa("[name=vector_length]",e).forEach((function(e){e.innerHTML=8})),qsa("[name=ref_efficiency_value]",e).forEach((function(e){e.innerHTML=Math.round(50)+"% "}));const r=o>50;qs("#eff_tooltip_info_orange",e).Visible(r),qs("#eff_tooltip_info_grey",e).Visible(!r),qs("#eff_tooltip_warn_approx",e).Visible(!0),qs("#eff_tooltip_warn_too_high_eff",e).Visible(!1),t(s,o,50)},methods:{drawEfficiency(e,t,i){const o=document.getElementById("efficiencyCanvas"),n=o.getContext("2d");n.clearRect(0,0,o.width,o.height);const s=Math.round(.15*o.height),r=o.height-s,a=o.width-2,l="#000000",c="#FFFFFF";n.beginPath(),n.fillStyle=l,n.rect(0,0,a+2,r+2),n.fill(),n.closePath(),n.beginPath(),n.fillStyle=c,n.rect(1,1,a,r),n.fill(),n.closePath();const d=Math.round(a/100*t),p=Math.round(a/100*i);let u=!1,h=1,m=1,f=1,v=1;t<=i?(u=!1,h=1,m=h+d):t>i&&(u=!0,h=1,m=h+p,f=m,v=f+(d-p-1));let g=1,_=1,y=1,b=1,w="#D0D0D0";if(u&&(w="#FFA500"),!e){const e=10,t=Math.round(a/100*e);m-h>0&&(g=h,_=m),v-f>0&&(g=f,_=v),y=g,b=_,_-g<t?_=g:(_-=t,y=_)}if(m-h>0&&(n.fillStyle=w,n.fillRect(h,1,m-h,r)),v-f>0&&(n.fillStyle=w,n.fillRect(f,1,v-f,r)),b-y>0){const e=n.createLinearGradient(y,0,b,0);e.addColorStop(0,w),e.addColorStop(1,c),n.fillStyle=e,n.fillRect(y,1,b-y,r)}const x=o.height-s-4,C=p;n.fillStyle=l,n.beginPath(),n.moveTo(C,x),n.lineTo(C+4,x+4),n.lineTo(C+4,x+(4+s)),n.lineTo(C-4,x+(4+s)),n.lineTo(C-4,x+4),n.lineTo(C,x),n.closePath(),n.fill()}}},a=(0,i(98822).A)(r,o,[function(){var e=this,t=e._self._c;return t("table",{staticStyle:{width:"100%"}},[t("tr",{attrs:{valign:"bottom"}},[t("td",[t("canvas",{attrs:{id:"efficiencyCanvas",width:"200",height:"25"}})]),e._v(" "),t("td",{attrs:{name:"vector_gain"}})]),e._v(" "),t("tr",[t("td",[t("span",{attrs:{name:"vector_efficiency"}}),e._v("\n          Vectorization Efficiency\n        ")]),e._v(" "),t("td",[e._v("Vectorization Gain")])])])},function(){var e=this,t=e._self._c;return t("table",[t("tr",[t("td",{attrs:{name:"vector_efficiency"}}),e._v(" "),t("td",[e._v("\n            Achieved Vectorization Efficiency"),t("br"),e._v("\n            Achieved Vectorization Efficiency = (Estimated Gain/Vector Length) * 100%"),t("br"),e._v("\n            Estimated Gain = "),t("b",{attrs:{name:"vector_gain"}}),t("br"),e._v("\n            Vector Length = "),t("b",{attrs:{name:"vector_length"}})])]),e._v(" "),t("tr",{attrs:{id:"eff_tooltip_info_grey"}},[t("td",[t("img",{attrs:{src:"images/legend-grey-16x16.png",width:"16",height:"16"}})]),e._v(" "),t("td",[e._v("Grey color = Achieved vectorization efficiency is lower\n            than reference efficiency for original scalar loop")])]),e._v(" "),t("tr",{attrs:{id:"eff_tooltip_info_orange"}},[t("td",[t("img",{attrs:{src:"images/legend-orange-16x16.png",width:"16",height:"16"}})]),e._v(" "),t("td",[e._v("Orange color = Achieved vectorization efficiency is higher\n            than reference efficiency for original scalar loop")])]),e._v(" "),t("tr",{attrs:{id:"eff_tooltip_warn_approx"}},[t("td",[t("img",{attrs:{src:"images/warning-16x16.png",width:"16",height:"16"}})]),e._v(" "),t("td",[e._v("Efficiency is approximately "),t("b",{attrs:{name:"vector_efficiency"}}),e._v(",\n            which means actual efficiency may be lower")])]),e._v(" "),t("tr",{attrs:{id:"eff_tooltip_warn_too_high_eff"}},[t("td",[t("img",{attrs:{src:"images/warning-16x16.png",width:"16",height:"16"}})]),e._v(" "),t("td",[e._v("This simplified formula does not account for additional speed-ups\n            related to microarchitecture or ISA code generation")])]),e._v(" "),t("tr",[t("td",{attrs:{name:"reference_efficiency"}},[t("div",{staticClass:"crop"},[t("img",{attrs:{src:"images/reference-12x12.png",width:"12",height:"12"}})])]),e._v(" "),t("td",[t("b",{attrs:{name:"ref_efficiency_value"}}),e._v("Reference Efficiency for original scalar loop"),t("br"),e._v("\n            Reference Efficiency = (1x/Vector Length) * 100%\n          ")])]),e._v(" "),t("tr",[t("td",{attrs:{name:"max_efficiency"}},[t("img",{attrs:{src:"images/legend-white-16x16.png",width:"16",height:"16"}})]),e._v(" "),t("td",[e._v("\n            (100%) Theoretical Maximum Vectorization Efficiency"),t("br"),e._v("\n            Maximum Vectorization Efficiency = (Theoretical Maximum Gain/Vector Length) * 100%"),t("br"),e._v("\n            Theoretical Maximum Gain = Currently selected Vector Length = "),t("b",{attrs:{name:"vector_length"}})])])])}],!1,null,null,null).exports},45710:e=>{e.exports=' <h4>Confirm inefficient memory access patterns</h4> <div class="text promo"> There is no confirmation inefficient memory access patterns are present. To fix: Run a <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a>. </div>'},45971:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,e.isNoData?t("no-data"):t("layout-panel-template",{staticClass:"content"},[t("header-section",{attrs:{metric:e.loopName}},[e.loopIcon?t("i",{class:e.loopIcon}):e._e(),e._v(" "),e.loopIcon?t("span",{staticClass:"divider"},[e._v("•")]):e._e(),e._v(" "),e.regionTypeIcon?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.regionType.tooltip,expression:"regionType.tooltip"}],class:e.regionTypeIcon}):e._e(),e._v(" "),e.regionTypeIcon?t("span",{staticClass:"divider"},[e._v("•")]):e._e()]),e._v(" "),e.whyNotOffloaded?t("div",{staticClass:"why-not-offloaded"},[t("b",[e._v(e._s(e.whyNotOffloaded.title)+":")]),e._v(" "+e._s(e.whyNotOffloaded.value))]):e._e(),e._v(" "),t("details-section",{staticClass:"summary",attrs:{title:e.$t("acc_regions_efficiency"),value:e.speedUp.value,tooltip:e.speedUp.tooltip}},[t("summary-section",[t("summary-metric",{attrs:{metric:e.estimatedTime}}),e._v(" "),t("summary-metric",{attrs:{metric:e.measuredTime}})],1)],1),e._v(" "),t("details-section",{staticClass:"bounded-by",attrs:{title:e.$t("acc_regions_bounded_by"),value:e.boundedBy.value,tooltip:e.boundedBy.tooltip}},e._l(e.boundedByMetrics,(function(i){return t("bar-metric",e._b({key:i.id,attrs:{"min-width":"4px"}},"bar-metric",i,!1))})),1)],1)},n=[];o._withStripped=!0},46192:(e,t,i)=>{"use strict";i.d(t,{Z:()=>a,r:()=>r});const o=!0;function n(e){return e.$parent.layout||{}}function s(e){e&&"function"==typeof e.destroy&&e.destroy()}function r(e,t,i,r){if(!e)return!1;if(!(r=r||e.$el))return!1;const{panelCache:a}=n(e);if(o&&a){const o=e[i],n=document.createDocumentFragment();for(const e of Array.from(r.childNodes))n.appendChild(e);return a[t]={fragment:n,instance:o,destroy:s.bind(void 0,o)},!0}return!1}function a(e,t,i,s){if(!e)return!1;if(!(s=s||e.$el))return!1;const{panelCache:r}=n(e);if(o&&r&&r[t]){const{fragment:o,instance:n}=r[t];return s.appendChild(o),e[i]=n,delete r[t],!0}return!1}},46339:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"node",class:e.levelClass,style:{minWidth:e.minNodeWidth}},[t("div",{staticClass:"tree"},[e.isNested?t("button",{on:{click:e.onCollapseExpand}},[t("i",{class:e.caretIcon})]):e._e()]),e._v(" "),t("div",{staticClass:"content"},[t("div",{staticClass:"title"},[t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.item.tooltip,expression:"item.tooltip"}],staticClass:"name"},[e.isNested?t("span",{staticClass:"nested",on:{click:e.onCollapseExpand}},[e._v(e._s(e.item.title)+":")]):t("span",[e._v(e._s(e.item.title)+":")]),e._v(" "),e.item.tooltip?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.item.tooltip,expression:"item.tooltip"}],staticClass:"icon help-circle"}):e._e()]),e._v(" "),e.isNested?t("span",{class:e.getSubtitleClass(e.item),style:e.item.style},[t("div",[e._v(e._s(e.item.formattedValue))]),e._v(" "),e.showMeasure?t("span",[e._v(e._s(e.item.formattedMaxValue||e.item.measure||""))]):e._e(),e._v(" "),t("span",[e._v(e._s(e.item.roofName))]),e._v(" "),e.showBar&&e.item.maxValue?t("simple-bar-chart",{attrs:{value:e.item.value/e.item.maxValue,color:e.item.color}}):e._e()],1):t("span",{staticClass:"value",style:e.item.style},[t("div",[e._v(e._s(e.item.formattedValue||e.item.value))]),e._v(" "),e.showMeasure?t("span",[e._v(e._s(e.item.measure||""))]):e._e()])]),e._v(" "),e.isExpanded?t("tree-list",{attrs:{features:e.features,items:e.item.children,level:e.level+1}}):e._e()],1)])};o._withStripped=!0,i(69212),i(43827);var n=i(66459);const s={props:{item:{type:Object,required:!0},features:{type:Array,validator:e=>e.every((e=>"string"==typeof e&&n.ALL_FEATURES.includes(e.toLowerCase()))),required:!0},level:{type:Number,required:!0},collapsed:{type:Boolean,default:!0},minNodeWidth:{type:String,default:""}},data(){return{isExpanded:!this.collapsed}},computed:{showBar(){return this.features.includes(n.SHOW_BAR)},showMeasure(){return this.features.includes(n.SHOW_MEASURE)},isNested(){return!!this.item.children},caretIcon(){return this.isExpanded?"icon caret-down":"icon caret-right"},levelClass(){return`level-${this.level}`}},methods:{onCollapseExpand(){this.isExpanded=!this.isExpanded},getSubtitleClass:e=>e&&(e.formattedValue||e.formattedMaxValue||e.measure||e.roofName)?"subtitle":""},components:{TreeList:()=>Promise.resolve().then(i.bind(i,38649))}},r=(0,i(98822).A)(s,o,[],!1,null,"5bf13d53",null).exports},46406:e=>{e.exports=' <h4>Use the Fortran 2008 CONTIGUOUS attribute</h4> <div class="text"> <div class="promo"> The loop is multi-versioned for unit and non-unit strides in assumed-shape arrays or pointers, but marked versions of the loop have unit stride access only. The <samp class="codeph">CONTIGUOUS</samp> attribute specifies the target of a pointer or an assumed-shape array is contiguous. It can make it easier to enable optimizations that rely on the memory layout of an object occupying a contiguous block of memory. <p class="expander">Example</p> <pre class="expansion"><code class="fortran">real, pointer, contiguous :: ptr(:)\nreal, contiguous :: arrayarg(:, :)</code></pre> </div> When multiple calling routines are involved, to tell the compiler assumed-shape arrays and/or pointers are always contiguous in memory, use the following options available in Version 18 and higher of the Intel&reg; Fortran Compiler: <table> <thead> <tr> <th>Type</th> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td>assumed-shape array</td> <td>/assume:contiguous_assumed_shape</td> <td>-assume contiguous_assumed_shape</td> </tr> <tr> <td>pointer</td> <td>/assume:contiguous_pointer</td> <td>-assume contiguous_pointer</td> </tr> </tbody> </table> <br/> <b>Note</b>: Results are indeterminate and could result in incorrect code and segmentation faults if the user assertion is wrong and the data is not contiguous at runtime. To check at runtime if targets of contiguous pointer assignments are indeed contiguous in memory, use the following options available in Version 18 and higher of the Intel&reg; Fortran Compiler: <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td>/check:contiguous</td> <td>-check contiguous</td> </tr> </tbody> </table> <p class="expander">Example</p> <pre class="expansion"><code class="bash">$ ifort -DCONTIG -check contiguous -traceback\n\nforrtl: severe (408): fort: (32): A pointer with the CONTIGUOUS attributes is being made to a non-contiguous target.</code></pre> In this example, the compiler detects the assignment of a contiguous pointer to a non-contiguous target.The <samp class="codeph">-traceback</samp> (Linux* OS)/ <samp class="codeph">/traceback</samp> (Windows* OS) option identifies the function and source file line number at which the incorrect assignment occurs. It is not necessary to compile with the debugging option <samp class="codeph">-g</samp> (Linux* and macOS* OS) / <samp class="codeph">/Zi</samp> (Windows* OS) to get this traceback. <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-DAEBF260-BE29-4CBD-9417-F774597F9071.html">assume</a>, <a href="docs:Fortran/17/index.htm#GUID-AFB42D1D-FE3D-42CD-B703-9A7AA602ED12.html">check</a>, <a href="docs:Fortran/17/index.htm#GUID-1C133644-3883-4146-A6BB-1B948B29EDC7.html">CONTIGUOUS</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/fortran-array-data-and-arguments-and-vectorization.html">Fortran Array Data and Arguments and Vectorization</a>, <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/vectorization-and-array-contiguity.html">Vectorization and Array Contiguity with the Intel&reg; Fortran Compiler</a>, <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/contiguity-checking-for-pointer-assignments-in-the-intel-fortran-compiler.html">Contiguity Checking for Pointer Assignments in the Intel&reg; Fortran Compiler</a>, <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},46481:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(){return this._self._c,this._m(0)};o._withStripped=!0;const n=(0,i(98822).A)({},o,[function(){var e=this;return(0,e._self._c)("footer",{staticClass:"footer",domProps:{innerHTML:e._s(e.$t("recs_footer"))}})}],!1,null,"30d1fff7",null).exports},46591:e=>{e.exports=' <h4>Implement a tiling technique in a Shared Local Memory and reuse data between work items in one work group</h4> <div class="text"> <div class="promo"> <span data-glossary-id="SLM">Shared Local Memory (SLM)</span> is more efficient than global memory and can be used to share data between work items in one work group. To improve data locality: <ul> <li> Divide a big dataset into small tiles or arrays of elements. </li> <li> Explicitly load each tile or array to the <span data-glossary-id="SLM">SLM</span> and reuse it between work items in one work group. </li> <li> Load the result to the global memory. </li> </ul> Currently, local size, or work-group size, is %local_work_size% work items, and SLM allocation should not exceed %max_slm_per_wg% per work group. With <a href="https://www.intel.com/content/www/us/en/develop/documentation/get-started-with-cpp-fortran-compiler-openmp/top.html">OpenMP* Offload programming model</a> use <span data-glossary-id="fixed_array">fixed array</span> to allocate tile in SLM and <samp class="codeph">shared</samp> clause to share tile between work items. <p class="expander">Explanation</p> <p class="expansion"> To find the amount of data that a work group can effectively use, you need to know the maximum <span data-glossary-id="SLM">SLM</span> allocation size available for it. SLM is a memory shared between execution units (EU) running on the same sub-slice of an Intel® Graphics Processor. Each sub-slice of the current GPU hardware has %eu_count_per_ss% EUs and %gpu_slm_size_per_ss% of SLM. Each EU can start %thread_slots_per_eu% hardware threads. In theory, up to %thread_slots_per_ss% EU threads can run in parallel on one sub-slice. <br> <br> Thread occupancy of the current kernel is %thread_occupancy%. <span id="low_thread_occupancy"> It means a smaller number of threads runs in parallel than is available on the current GPU. </span> High SLM allocation can be the reason of reduced number of parallel threads and decreased thread occupancy. One hardware thread should not allocate more than %max_slm_per_thread% so that high SLM allocation does not increase thread occupancy. <br> <br> Currently, local size, or work-group size, is %local_work_size% work items. The number of work items that are processed together as a SIMD vector on one EU thread is %gpu_current_row_simd_width%. To run one work group, %threads_per_wg% EU threads are required. As a result, %parallel_wq_per_ss% work groups can run in parallel and SLM allocation should not exceed %max_slm_per_wg% per work group. <br> <br> <b>Note: </b> SLM is a program-driven memory, and synchronizing data between work items is a developer’s responsibility. A work group barrier may be a good way to organize work when local memory is shared between work items. For example, put a barrier after allocating a tile in the SLM and before releasing it, because other work items could use this data in parallel. With <a href="https://www.intel.com/content/www/us/en/develop/documentation/get-started-with-cpp-fortran-compiler-openmp/top.html">OpenMP* Offload programming model</a>, you can use <samp class="codeph">barrier</samp> construct. See <a href="https://www.openmp.org/spec-html/5.1/openmpsu100.html#x133-1430002.19.2">documentation</a> for more details. <br> <br> </p> <p>Example of the allocating fixed array in SLM:</p> <pre class="essential"><code class="cpp" data-source="\nreal (kind = 8) :: A(N,N)\n...\n!$omp target teams private(A)\n...\n!$omp parallel shared(A)\n...\n!$omp barrier\n...\n  "></code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/develop/documentation/oneapi-gpu-optimization-guide/top/kernels/slm.html"> oneAPI GPU Optimization Guide</a> </li> <li> <a href="https://www.openmp.org/spec-html/5.1/openmpsu100.html#x133-1430002.19.2"> Barrier Construct</a> </li> <li> <a href="https://www.openmp.org/spec-html/5.1/openmpsu116.html#x151-1650002.21.4"> Data-Sharing Attribute Clauses</a> </li> </ul> </div> '},46757:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("idvc-bar-chart",{attrs:{"bar-width":.9,"bar-offset":.5,"chart-data":e.data,onTooltip:e.tooltipProcessor}})};o._withStripped=!0;var n=i(5246);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,null,null).exports},46897:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",[t("div",{staticClass:"events"},[t("top-slider-header",{attrs:{events:""}}),e._v(" "),t("div",{ref:"content"},[t("top-slider-list",{attrs:{data:e.events,eventName:e.eventName}}),e._v(" "),e.events.length||e.isCollectionRunning?e._e():t("top-slider-list-item",{attrs:{eventName:e.eventName,eventType:1,title:e.$t("top_slider_no_events"),icon:"document-text-strikethrough gray"}})],1)],1),e._v(" "),e.hasAnyOutput?t("div",{staticClass:"idvc2_splitter_vert_splitter"},[t("div",{staticClass:"idvc2_splitter_sash"})]):e._e(),e._v(" "),e.hasAnyOutput?t("div",{staticClass:"output",style:e.outputStyle},[e.hasApplicationOutput?t("output-log",{attrs:{caption:e.$t("log_message_pane_app_output"),items:e.applicationOutput},on:{close:e.onCloseAppOutput}}):e._e(),e._v(" "),e.hasBothOutputs?t("idvc-splitter",{attrs:{"min-size":150,"auto-fold":!1}}):e._e(),e._v(" "),e.hasCollectorOutput?t("output-log",{attrs:{caption:e.$t("log_message_pane_collector_output"),items:e.collectorOutput},on:{close:e.onCloseCollectorOutput}}):e._e()],1):e._e()])},n=[];o._withStripped=!0},47058:e=>{e.exports=' <h4>Check memory access patterns for the outer loop</h4> <div class="text promo"> This loop has inefficient memory access patterns. <span id="actions" style="display:none"> To fix: Run a <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a> on the outer loop. </span> If the memory access patterns are more efficient for the outer loop, reorder the loops if possible. </div> '},47455:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>o});const o="data:image/png;base64,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"},47545:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>o});const o="data:image/png;base64,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"},47693:e=>{e.exports=' <h4>Enable inline expansion</h4> <div class="text"> <p class="promo"> Inlining of user-defined functions is disabled by compiler option. To fix: When using the <samp class="codeph">Ob</samp> or <samp class="codeph">inline-level</samp> compiler option to control inline expansion, replace the <samp class="codeph">0</samp> argument with the <samp class="codeph">1</samp> argument to enable inlining when an <samp class="codeph">inline</samp> keyword or attribute is specified or the <samp class="codeph">2</samp> argument to enable inlining of any function at compiler discretion. </p> <table> <thead> <tr> <th>Windows* OS</th> <th>Linux* OS</th> </tr> </thead> <tbody> <tr> <td>/Ob1 or /Ob2</td> <td>-inline-level=1 or -inline-level=2</td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-53B736C9-3A0A-4CC0-931B-1A1EDF7BF668.htm">inline-level, Ob</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},47843:e=>{e.exports=' <h4>Disable dynamic alignment</h4> <div class="text"> <div class="promo"> The compiler automatically peeled iterations from the vector loop into a scalar loop to align the vector loop with a particular memory reference; however, this optimization may not be ideal. To possibly achieve better performance, disable automatic <span data-glossary-id="peeled_loop"> peel generation </span> using the directive: <samp class="codeph">!DIR$ VECTOR NODYNAMIC_ALIGN</samp> <p class="expander">Example (original code)</p> <pre class="essential"><code class="fortran">!DIR$ VECTOR NODYNAMIC_ALIGN\ndo i = 1, len\n    a(i) = b(i) * c(i)\nenddo</code></pre><p></p> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-967D7284-0E6D-4B02-B679-4DEE93D96E49.html">VECTOR and NOVECTOR</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/vector-and-novector.html">Dynamic Alignment Clause for Vector Pragma/Directive</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div></div>'},48025:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"conclusion"},[e._m(0),e._v(" "),e.boundedBy?t("div",[t("div",{staticClass:"title",class:{expandable:e.isExpandable},on:{click:function(t){e.isExpanded=!e.isExpanded}}},[e._v("\n      "+e._s(e.$t("rec_bounded_by"))+"\n      "),t("span",{style:e.limitingRoof.style},[e._v(e._s(e.limitingRoof.name))]),e.limitingRoof.desc?t("span",{attrs:{dummy:""}},[e._v(" ("+e._s(e.limitingRoof.desc)+")")]):e._e(),e._v(".\n      "),e.limitingRoof.isOffload?t("span",[e._v("\n        "+e._s(e.$t("rec_bounded_by_apm"))+"\n      ")]):e._e()]),e._v(" "),e.isExpandable&&e.isExpanded?t("div",{domProps:{innerHTML:e._s(e.rec)}}):e._e()]):e._e()])},n=[function(){var e=this._self._c;return this._self._setupProxy,e("span",[e("i",{staticClass:"icon megaphone"})])}];o._withStripped=!0},48520:e=>{e.exports=' <h4>Split loop into smaller loops</h4> <div class="text"> <div class="promo"> Possible register <span data-glossary-id="spilling">spilling</span> along with high vector <span data-glossary-id="register_pressure">register pressure</span> is preventing effective vectorization. To fix: Use the <span data-glossary-id="directive">directive</span> <samp class="codeph">!DIR$ DISTRIBUTE POINT</samp> or rewrite your code to distribute the <span data-glossary-id="source_loop">source loop</span>. This can decrease register pressure as well as enable software pipelining and improve both instruction and data cache use. <p class="expander">Example</p> <pre class="essential"><code class="fortran">!DIR$ DISTRIBUTE POINT\ndo i = 1, m\n    ...\n    b(i) = a(i) + 1\n    ...\n    c(i) = a(i) + b(i) ! Compiler will decide\n    ! where to distribute.\n    ! Data dependencies are observed\n...</code></pre> <pre class="expansion"><code class="fortran">!DIR$ DISTRIBUTE POINT\ndo i = 1, m\n    b(i) = a(i) + 1\n    ...\n    c(i) = a(i) + b(i) ! Compiler will decide\n    ! where to distribute.\n    ! Data dependencies are observed\n    ...\n    d(i) = c(i) + 1\nenddo\ndo i =1, m\n    b(i) = a(i) + 1\n    ...\n    !DIR$ DISTRIBUTE POINT\n    call sub(a, n)! Distribution will start here,\n    ! ignoring all loop-carried depedencies\n    c(i) = a(i) + b(i)\n    ...\n    d(i) = c(i) + 1\nenddo</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-759F460A-1FF1-44AC-B64C-910D8C57BB1B.html">DISTRIBUTE POINT</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/3d-isotropic-acoustic-finite-difference-wave-equation-code-a-many-core-processor.html">3D Finite Differences on Multi-core Processors</a>, <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a>, and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},48615:e=>{e.exports=' <h4>Target the higher ISA</h4> <div class="text"> <div class="promo"> Although static analysis presumes the loop may benefit from <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a> instructions available with the AVX2 or higher ISA, no FMA instructions executed for this loop. To fix: Use the following compiler options: <ul> <li> <samp class="codeph">xCORE-AVX2</samp> to compile for machines with and without AVX2 support </li> <li> <samp class="codeph">axCORE-AVX2</samp> to compile for machines with AVX2 support only </li> <li> <samp class="codeph">xCOMMON-AVX512</samp> to compile for machines with AVX-512 support only </li> <li> <samp class="codeph">axCOMMON-AVX512</samp> to compile for machines with and without AVX-512 support </li> </ul> Note: the compiler options may vary depending on the CPU microarchitecture. </div> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /QxCORE-AVX2 or /QaxCORE-AVX2 </td> <td> -xCORE-AVX2 or -axCORE-AVX2 </td> </tr> <tr> <td> /QxCOMMON-AVX512 or /QaxCOMMON-AVX512 </td> <td> -xCOMMON-AVX512 or -axCOMMON-AVX512 </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-2D881A91-C5D7-4DDD-84B1-FB9D0D597F4D.html"> ax, Qax</a>; <a href="docs:C++/17/index.htm#GUID-09734487-1819-4C1E-B314-2497F2B64C45.html"> x, Qx</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html"> Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/architecture-and-technology/avx-512-solution-brief.html"> Compiling for the Intel&reg; Xeon Phi™ processor x200 and the Intel&reg; AVX-512 ISA</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},48706:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return e.value?t("div",{staticClass:"metric"},[t("div",{staticClass:"content"},[t("div",{staticClass:"value-container",class:{compact:e.compact}},[t("span",{staticClass:"value"},[e._v("\n        "+e._s(e.value)+"\n      ")]),e._v(" "),t("div",{staticClass:"title-wrapper"},[t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.metric.tooltip||e.metric.title,expression:"metric.tooltip || metric.title"}],staticClass:"title"},[e._v("\n          "+e._s(e.metric.title||e.$t(e.metric.id))+"\n        ")])])]),e._v(" "),e.metric.maxValue?t("simple-bar-chart",{staticClass:"bar-chart",attrs:{value:e.metric.value/e.metric.maxValue,color:e.color,small:""}}):t("div",{staticClass:"bar-chart",attrs:{name:"spacer"}}),e._v(" "),e.children.length>0?t("table",{staticClass:"child-metrics"},e._l(e.children,(function(i){return t("tr",{key:i.id},[t("td",[e._v(e._s(i.title))]),e._v(" "),t("td",[e._v(e._s(i.formattedValue))])])})),0):e._e()],1),e._v(" "),e.metric.tooltip?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.metric.tooltip,expression:"metric.tooltip"}],staticClass:"icon help-circle"}):e._e()]):e._e()};o._withStripped=!0;var n=i(77106),s=i(85038);const r={props:{metric:{type:Object,required:!0},compact:Boolean},computed:{value(){const{formattedValue:e}=this.metric;return e||(0,n.formatNumber)(this.metric)},children(){const{children:e}=this.metric;return e||[]},color(){return this.metric.color||s.charts["metric-box-bar"]}}},a=(0,i(98822).A)(r,o,[],!1,null,"adc76420",null).exports},48768:e=>{e.exports=' <h4>Force the compiler to align loop code</h4> <div class="text"> <div class="promo">Caution: Excessive <span data-glossary-id="alignment_of_code">code alignment</span> may increase application binary size and decrease performance.<br/> Static analysis shows the loop may benefit from code alignment. To fix: Force the compiler to align the loop to a power-of-two byte boundary using a compiler <span data-glossary-id="directive">directive</span> for finer-grained control: <samp class="codeph">#pragma code_align (n)</samp> </div> <div class="promo"> <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n#pragma code_align 32\n    for (j = 0; j &lt; m; j++)\n...</code></pre> <div class="expansion"><p>Align inner loop to 32-byte boundary</p><pre><code class="cpp">for (i = 0; i &lt; n; i++)\n{\n#pragma code_align 32\n    for (j = 0; j &lt; m; j++)\n    {\n        a[i] *= b[i] + c[j];\n    }\n}</code></pre></div> </div> <p>You may also use the following compiler option:</p> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS and macOS*</th> </tr> </thead> <tbody> <tr> <td>/Qalign-loops[:n]</td> <td>-falign-loops[=n]</td> </tr> </tbody> </table> <p>where n = a power of 2 betwen 1 and 4096, such as 1, 2, 4, 8, 16, 32, etc. n = 1 performs no alignment. If n is not present, the compiler uses an alignment of 16 bytes. Suggestion: Try 16 and 32 first.</p> <p><samp class="codeph">/Qalign-loops-</samp> and <samp class="codeph">-fno-align-loops</samp>, the default compiler option, disables special loop alignment.</p> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/code-align-002.html">Code Alignment for Loops</a> </li> </ul> </div>'},48956:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"enum-with-button",class:{disabled:e.knob.readOnly}},[t("dropdown",{staticClass:"knob",attrs:{knob:e.knob},on:{onKnobChanged:e.onKnobChanged}}),e._v(" "),t("div",{staticClass:"action-button icon hamburger",on:{click:e.onActionButtonClick}})],1)};o._withStripped=!0;const n={props:{knob:{type:Object,validator:e=>"string"==typeof e.id&&"string"==typeof e.name&&"string"==typeof e.value&&"string"==typeof e.action&&"boolean"==typeof e.readOnly&&Array.isArray(e.items)}},data:()=>({isOpened:!1}),methods:{onActionButtonClick(){this.$emit("onActionButtonClick",this.knob.action)},onKnobChanged(...e){this.$emit("onKnobChanged",...e)}}},s=(0,i(98822).A)(n,o,[],!1,null,"b1f99ebe",null).exports},49128:function(e,t,i){"use strict";i(27468),i(69212),i(43468),i(21602),i(32204);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=i(75337),s=i(1067),r=o(i(25405)),a=["active","stalled","idle"],l={data:()=>({compact:!1}),computed:{...(0,n.mapGetters)("gpu",["getGpuPerformanceCharData","getCpuPerformanceCharData"]),chart(){return this.getGpuPerformanceCharData.filter(this.isChartMetric).reduce(((e,t)=>({labels:[...e.labels,t.title],values:[...e.values,t.value],colors:[...e.colors,this.getColor(t)]})),{labels:[],values:[],colors:[]})},legend(){return this.getGpuPerformanceCharData.filter(this.isChartMetric).map((e=>({title:e.title,value:e.formattedValue,color:this.getColor(e)})))},list(){return this.getGpuPerformanceCharData.filter((e=>!this.isChartMetric(e))).map((e=>({title:e.title,value:e.formattedValue})))},compactData(){const e=this.getGpuPerformanceCharData.filter(this.isChartMetric).reduce(((e,t)=>({title:[...e.title,t.title],formattedValue:[...e.formattedValue,`<span style="color: ${this.getColor(t)}; vertical-align: text-bottom; line-height: 1.3rem">&#9632;</span> ${t.formattedValue}`],values:[...e.values,t.value],colors:[...e.colors,this.getColor(t)]})),{title:[],formattedValue:[],values:[],colors:[]});return{...e,title:e.title.join(" / "),formattedValue:e.formattedValue.join(" / ")}},flex(){return{flex:[{[s.GPU]:1,[s.CPU]:1},{[s.GPU]:1,[s.CPU]:4},{[s.GPU]:4,[s.CPU]:1},{[s.GPU]:2,[s.CPU]:1}][2*+(this.getGpuPerformanceCharData.length>0)+ +(Object.keys(this.getCpuPerformanceCharData).length>0)][s.GPU]}}},methods:{isChartMetric:({title:e})=>a.some((t=>e.toLowerCase().includes(t))),getColor({title:e}){const t=(a.find((t=>e.toLowerCase().includes(t)))||"").toLowerCase();return r.default[t]},onCollapsed(e){this.compact=e}}};t.default=l},49279:e=>{e.exports=' <h4>Explore vectorization opportunities</h4> <div class="text"> <div class="promo"> You compiled with auto-vectorization enabled; however, the compiler did not vectorize the code. Explore vectorization opportunities: <ul> <li>Run a Dependencies analysis to identify real data dependencies that could make forced vectorization unsafe.</li> <li>Microsoft Visual C++* compiler: Use the Qvec-report compiler option (i.e. /Qvec-report:2) to set the</li> <li>Auto-Vectorizer Reporting Level to output missed optimization opportunities.</li> <li>GNU* gcc compiler, do one of the following:</li> <ul> <li>Use the fopt-info-vec-missed compiler option to output missed optimization opportunities.</li> <li>Use the OpenMP* omp simd directive to tell the compiler it is safe to vectorize.</li> <li>Use additional auto-vectorization directives.</li> </ul> </ul> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://msdn.microsoft.com/en-us/library/fwkeyyhe.aspx">Visual Studio 2015/Visual C++ Compiler Options Listed Alphabetically</a> </li> <li> <a href="https://gcc.gnu.org/onlinedocs/">GCC online documentation</a> </li> <li> <a href="http://openmp.org/resources/">OpenMP Resources</a> </li> </ul> </div>'},49306:function(e,t,i){"use strict";i(36094),i(69212),i(38333);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=i(75337),s=o(i(51382)),r=o(i(42128)),a=i(60970),l="panel-collapsing",c="panel-closing",d={props:{view:{type:String,required:!0},layout:{type:Object,required:!0},tabs:{type:Array,required:!0},captureType:String,size:String,min:String},data:()=>({draggableCoordinates:void 0,isHovering:!1,animation:void 0}),computed:{...(0,n.mapGetters)("layout",["getGuideBySlotIndex"]),activeTab(){return this.tabs.find((e=>e.tabState===a.STATE_ACTIVE))},caption(){const{captureType:e,activeTab:t,tabs:i}=this;return e===a.CAPTURE_TYPE_TAB?null==t?void 0:t.caption:`${null==t?void 0:t.caption} + ${i.length-1} more`},slotIndex(){var e;return null===(e=this.activeTab)||void 0===e?void 0:e.slotIndex},compactHeight(){var e;return null===(e=this.activeTab)||void 0===e?void 0:e.compactHeight},compact(){var e;return null===(e=this.activeTab)||void 0===e?void 0:e.compact},name(){var e;return null===(e=this.activeTab)||void 0===e?void 0:e.name},flex(){return(0,a.sizeToFlex)(this.size)},minSize(){return{minHeight:this.min,minWidth:this.min}},compactIcon(){return this.compact?"icon chevron-down":"icon chevron-up"},isSearch(){return!!this.$scopedSlots.search},isOptions(){return!!this.$scopedSlots.options},debug(){if(!a.DEBUG)return;const{flex:e,name:t,slotIndex:i}=this,o=[];return t&&o.push(`name: ${t}`),o.push(`${i}: flex: ${e}`),o.join(", ")}},mounted(){this.compactHeight},beforeDestroy(){this.resizeObserver&&this.resizeObserver.unobserve(this.$el)},methods:{onSizeChanged(e){const{view:t,slotIndex:i,compactHeight:o,compact:n}=this,[s]=e,{contentRect:r}=s,a=Math.trunc(r.height),l=e=>{this.$store.direct.dispatch.layout.compactTab({view:t,slotIndex:i,compact:e})};this.prevHeight||l(a<o),this.prevHeight&&this.prevHeight<a&&n&&l(a<o),this.prevHeight&&this.prevHeight>a&&!n&&l(a<o),this.prevHeight=a},onPanelReleased(){const{type:e,slotIndex:t,index:i}=this.draggableHotspot||{},{view:o,getGuideBySlotIndex:n,captureType:s}=this;if(this.draggableHotspot=void 0,this.$store.direct.dispatch.layout.releasePanel({view:o,slotIndex:this.slotIndex}),e===a.ACTION_MOVE){const e=n(o,t);this.$store.direct.dispatch.layout.removePlaceholder({guide:e,index:i}),s===a.CAPTURE_TYPE_TAB?this.$store.direct.dispatch.layout.moveTab({view:o,slotIndex:this.slotIndex,guide:e,index:i}):this.$store.direct.dispatch.layout.movePanel({view:o,slotIndex:this.slotIndex,guide:e,index:i})}else if(e===a.ACTION_MOVE_ACROSS){this.$store.direct.dispatch.layout.removePlaceholder({view:o,index:i});const e={type:a.TYPE_GUIDE,panels:[]};this.$store.direct.dispatch.layout.addGuide({view:o,index:i,guide:e}),s===a.CAPTURE_TYPE_TAB?this.$store.direct.dispatch.layout.moveTab({view:o,slotIndex:this.slotIndex,guide:e,index:i}):this.$store.direct.dispatch.layout.movePanel({view:o,slotIndex:this.slotIndex,guide:e,index:i})}else e===a.ACTION_DOCK?this.$store.direct.dispatch.layout.dockTab({view:o,slotIndexFrom:this.slotIndex,slotIndexTo:t}):e===a.ACTION_SWAP&&this.$store.direct.dispatch.layout.swapPanels({view:o,slotIndexFrom:this.slotIndex,slotIndexTo:t})},onPanelDragged(e){this.draggableCoordinates=e},onTabCompacted(){const{view:e,slotIndex:t,compact:i}=this;this.$store.direct.dispatch.layout.compactTab({view:e,slotIndex:t,compact:!i})},onPanelCollapsed(){this.animation=l,this.onAnimationEnd()},onPanelClosed(){this.animation=c,this.onAnimationEnd()},onDraggableHotspotChanged(e){const{view:t,draggableHotspot:i,getGuideBySlotIndex:o}=this,{type:n,slotIndex:s,index:r}=e||{},{type:l,slotIndex:c,index:d}=i||{};if(l===a.ACTION_MOVE){const e=o(t,c);this.$store.direct.dispatch.layout.removePlaceholder({guide:e,index:d})}else l===a.ACTION_MOVE_ACROSS&&this.$store.direct.dispatch.layout.removePlaceholder({view:t,index:d});if(n===a.ACTION_MOVE){const e=o(t,s);this.$store.direct.dispatch.layout.addPanel({guide:e,index:r,panel:{type:a.TYPE_PLACEHOLDER,panelState:a.STATE_NORMAL}})}else n===a.ACTION_MOVE_ACROSS&&this.$store.direct.dispatch.layout.addGuide({view:t,index:r,guide:{type:a.TYPE_PLACEHOLDER,panels:[]}});this.draggableHotspot=e},onAnimationEnd(){const{animation:e,view:t,slotIndex:i}=this;switch(e){case l:this.$store.direct.dispatch.layout.collapsePanel({view:t,slotIndex:i});break;case c:this.$store.direct.dispatch.layout.closePanel({view:t,slotIndex:i})}}},components:{PanelHeader:s.default,PanelDraggable:r.default}};t.default=d},49452:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>_});var o=function(){var e=this,t=e._self._c;return t("section",{staticClass:"analysis-type",class:{expanded:e.expanded}},[t("div",{staticClass:"caption",class:{expanded:e.expanded},on:{click:function(t){e.expanded=!e.expanded}}},[e._t("icon"),e._v(" "),t("div",{staticClass:"analysis-name"},[e._t("name"),e._v(" "),t("transition",{attrs:{name:"fadeout"}},[e.loading?t("i",{staticClass:"loading icon circle-third spin"}):e._e()])],2),e._v(" "),t("div",{staticClass:"complexity-level icon"}),e._v(" "),t("i",{staticClass:"icon",class:e.expanded?"chevron-up":"chevron-down"})],2),e._v(" "),t("transition",{attrs:{name:"fadein"}},[e.expanded&&!e.loading?t("div",{staticClass:"content"},[t("run-panel",{staticClass:"analysis-command",attrs:{analysisTypes:[e.analysisId],commands:e.analysis.commands,hideDisabled:!0,disabled:e.isWarning}}),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.isWarning,expression:"isWarning"},{name:"tooltip",rawName:"v-tooltip",value:e.$t("wflow_select_at_least_one"),expression:"$t('wflow_select_at_least_one')"}],staticClass:"warning-site"},[t("i",{staticClass:"icon warning"}),e._v(" "+e._s(e.$t("wflow_select_at_least_one"))+"\n      ")]),e._v(" "),e._l(e.visibleKnobs,(function(i,o){return t(e.getComponentName(i.type),e._b({key:o,tag:"component",attrs:{"enum-style":"wf-knob"},on:{onKnobChanged:e.onKnobChanged}},"component",{knob:i},!1))}))],2):e._e()])],1)};o._withStripped=!0,i(27468),i(69212),i(43468),i(45361),i(32204);var n=i(75337),s=i(17807),r=i(81341),a=i.n(r),l=i(3861),c=i(42612),d=i(84620),p=i(33874),u=i(77106),h=(i(4711),i(36094),i(88774),i(18977));const m=[];function f(e,...t){return Object.keys(e).reduce(((i,o)=>(i[o]=function(e,...t){return Object.entries(e).reduce(((e,[i,o])=>({...e,...t.includes(i)&&{[i]:o}})),{})}(e[o],...t),i)),{})}const v={inject:["api"],mixins:[{created(){this._handlerIndex_set_option_mixin=m.length,m.push((({at:e,id:t,value:i})=>{const{analysisId:o,knobs:n}=this;if(d.ActivityType[e]!=o||void 0===n[t])return!1;const s=n[t];return s.value=i,this.onKnobChanged(s),!0})),h.A.workflow.setOption((e=>m.some((t=>t(e)))))},destroyed(){delete m[this._handlerIndex_set_option_mixin]}}],props:{analysisId:Number},data:()=>({analysis:{expanded:!0},knobs:{},loading:!1,isWarning:!1,saveKnobs:a()((async function(e,t){await this.api.workflow.updateKnobs(function(e){return Object.keys(e).reduce(((t,i)=>(t[i]=e[i].value,t)),{})}(e),t),this.$store.commit("workflow/clearSavingMode",this.analysisId)}),l.Vd)}),computed:{...(0,n.mapState)("workflow",["accuracy","linkedKnobs"]),...(0,n.mapGetters)("workflow",["isReadOnly","presetIndex","isCustomPreset","currentAccuracy","commonKnobs"]),...(0,n.mapGetters)(["activePerspectiveId"]),expanded:{get(){return this.analysis.expanded},set(e){this.analysis.expanded=e}},visibleKnobs(){return(0,c.G_)(this.knobs)}},watch:{analysisId(){this.fetchAnalysis()},isReadOnly(e){this.setKnobProps(e,["readOnly"])},activePerspectiveId(e){this.updateKnobs(e)},accuracy:{handler:function(){this.updateKnobs(this.activePerspectiveId)},deep:!0},linkedKnobs:{handler:function(e){e[this.analysisId]&&e[this.analysisId].forEach((e=>{this.knobs[e.id].value=e.value}))},deep:!0},commonKnobs:"onCommonKnobsChanged"},methods:{async onCommonKnobsChanged(e){for(;this.loading;)await(0,u.sleep)(l.pE);let t=!1;for(const i in e)void 0!==this.knobs[i]&&this.knobs[i].value!==e[i]&&(this.knobs[i].value=e[i],t=!0);this.updateKnobs(this.activePerspectiveId),t&&this.handleKnobs(this.knobs)},updateKnobs(e){if(this.loading)return;const{currentAccuracy:t,isCustomPreset:i,analysisId:o,presetIndex:n}=this,s=p.C.get(e,n).preset(o),r=!s||s.checked[t],a=this.knobs,l=new Map;!i&&r&&Object.keys(a).forEach((e=>{if(!p.C.allKnobs.has(e))return;const t=a[e];t.value!==t.defaultValue&&(l.set(e,t.value),t.value=t.defaultValue)}));let c=!1;Object.keys(a).forEach((e=>{const o=a[e];if(o.visibility=!1,s&&s.knobs[e]&&(o.visibility=!s.knobs[e].hidden,!i&&t&&r)){const i=s.knobs[e][t];void 0!==i&&o.value!==i&&(c||(l.get(e)===i?l.delete(e):c=!0),o.value=i)}})),(c||l.size>0)&&this.handleKnobs(a),this.updateOverhead(a),this.$store.commit("workflow/setAnalysisKnobs",{analysisId:o,analysisKnobs:f(a,"value","defaultValue")})},handleKnobs(e){this.checkForPaired(e),this.checkLinkedKnobs(e),this.$store.direct.commit.workflow.setSavingMode(this.analysisId),this.saveKnobs(e,this.analysisId)},onKnobChanged(e){if(this.loading)return;const{analysisId:t,knobs:i}=this;i[e.id]=e,this.updateOverhead(i),this.handleKnobs(i),this.$store.direct.commit.workflow.setAnalysisKnobs({analysisId:t,analysisKnobs:f(i,"value","defaultValue")}),this.$emit("onKnobsChanged")},setKnobProps(e,t=["readOnly","visibility"]){for(const i in this.knobs)t.forEach((t=>s.Ay.set(this.knobs[i],t,e)))},getComponentName:e=>({enum:"dropdown",boolean:"checkbox",int:"input-number",double:"input-number"}[e]||e||"unknown"),async fetchAnalysis(){this.loading=!0;const e=await this.api.workflow.getAnalysisCommands(this.analysisId);e.expanded=(null==e?void 0:e.expanded)||this.analysis.expanded,this.analysis=e,this.knobs=await this.api.workflow.getAnalysisKnobs(this.analysisId)||{},this.setKnobProps(!1),this.loading=!1,this.updateKnobs(this.activePerspectiveId)},updateOverhead(e){const t=(0,c.d2)(this.analysisId,this.activePerspectiveId,this.presetIndex,e);this.$store.direct.commit.workflow.setTotalOverhead({id:this.analysisId,overhead:t})},async updateKnobsFromProjProperties(){this.knobs=await this.api.workflow.getAnalysisKnobs(this.analysisId)||{},this.$store.direct.commit.workflow.setCustomAccuracy(!0),this.setKnobProps(!1),this.updateKnobs(this.activePerspectiveId),this.$emit("onKnobsChanged")},setWarningState(e){this.isWarning=e,this.$emit("set-warning",this.isWarning)},checkForPaired(e){const t=["trip_counts","flops_and_masks"],i=Object.values(e).filter((e=>t.includes(e.id))).filter((e=>!0===e.value));this.setWarningState(!1),this.analysisId===d.ActivityType.atTripCounts&&0===i.length&&this.setWarningState(!0)},checkLinkedKnobs(e){if(this.analysisId===d.ActivityType.atProjection){let t=[];e.data_reuse_analysis.value&&(t=[{id:"data_transfer",value:"full"}]),this.$store.direct.commit.workflow.setLinkedKnobs({analysisId:d.ActivityType.atTripCounts,newKnobs:t})}}},created(){this.api.workflow.onKnobsUpdate(this.updateKnobsFromProjProperties),this.fetchAnalysis()},destroyed(){this.api.workflow.offKnobsUpdate(this.updateKnobsFromProjProperties)}},g=v,_=(0,i(98822).A)(g,o,[],!1,null,"b931bb54",null).exports},49463:(e,t,i)=>{"use strict";i.d(t,{A:()=>N}),i(36094),i(69212),i(45361);var o=i(23949),n=i(61262);function s(e,t){return e&&e.classList&&e.classList.contains(t)}function r(e){return s(e,"idvc2_chart_right")}function a(e){return s(e,"idvc2_chart_top")}function l(){return void 0===this._sizes.top&&(this._sizes.top=this._centralPart.getTop()),this._sizes.top}function c(){return this._sizes.height||(this._sizes.height=this._centralPart.getHeight()),this._sizes.height}function d(){return this._sizes.boundingHeight||(this._sizes.boundingHeight=this.body.getBoundingClientRect().height),this._sizes.boundingHeight}function p(){return this._sizes.width||(this._sizes.width=this._centralPart.getWidth()),this._sizes.width}function u(){return this._sizes.boundingWidth||(this._sizes.boundingWidth=this.body.getBoundingClientRect().width),this._sizes.boundingWidth}function h(e){e._checkedPos&&(e.representation.setPos(e._checkedPos),delete e._checkedPos)}const m="idvc2_chart_axis",f="idvc2_chart_axis_text";var v={getClass:function(){return"idvc2_chart_vertaxis"},getValueLayout:function(e){if(this._centralPart){var t={},i="",o=l.call(this),n=this._centralPart.L2PY(e)+o;if(t.tickClass=m,t.textClass=f,t.tickStartY=n,t.tickEndY=n,t.textY=n,r(this._parent)||r(this.body))t.tickStartX=6,t.tickEndX=0,t.textX=10,i="start;";else{var s=u.call(this);t.tickStartX=s-6,t.tickEndX=s,t.textX=s-10,i="end;"}return t.textStyle="text-anchor: "+i+"dominant-baseline: middle",t}},getLineLayout:function(){var e={},t=l.call(this),i=c.call(this);if(e.startY=t,e.endY=t+i+1,e.lineClass=m,r(this._parent)||r(this.body))e.startX=.5,e.endX=.5;else{var o=u.call(this);e.startX=o-.5,e.endX=o-.5}return e},getRectLayout:function(e){return{alongStart:e.y,alongSize:e.height,acrossStart:e.x,acrossSize:e.width}},updateValuePos:function(e){if(this._centralPart&&e){var t=l.call(this),i=this._centralPart.L2PY(e.value)+t;e.representation.updatePos({y:i}),e._checkedPos={y:i}}},updateLinePos:function(){if(this._centralPart){var e=l.call(this),t=c.call(this)+e;this.axisLine.setY2(t)}},checkValuePos:function(e,t,i){if(e._checkedPos){var o=e.representation.getBoundingRect();o.y+o.height>i.height&&(o.y=i.height-o.height,e._checkedPos.y-=o.y),o.y<t.pos?t.pos?e._checkedPos.isHidden=!0:(e._checkedPos.y-=o.y,t.pos=o.height+2):(t.pos=o.y+o.height+2,delete e._checkedPos)}},getPos:e=>e.y},g={getClass:function(){return"idvc2_chart_horzaxis"},getValueLayout:function(e){if(this._centralPart){var t={},i=this._centralPart.L2PX(e),o="";if(t.tickClass=m,t.textClass=f,t.tickStartX=i,t.tickEndX=i,t.textX=i,a(this._parent)||a(this.body)){var n=d.call(this);t.tickStartY=n-6,t.tickEndY=n,t.textY=n-10,o="text-after-edge;"}else t.tickStartY=6,t.tickEndY=0,t.textY=10,o="text-before-edge;";return t.textStyle="text-anchor: middle; dominant-baseline:"+o,t}},getLineLayout:function(){var e={},t=p.call(this);if(e.startX=0,e.endX=t,e.lineClass=m,a(this._parent)||a(this.body)){var i=d.call(this);e.startY=i-.5,e.endY=i-.5}else e.startY=.5,e.endY=.5;return e},getRectLayout:function(e){return{alongStart:e.x,alongSize:e.width,acrossStart:e.y,acrossSize:e.height}},updateValuePos:function(e){if(this._centralPart&&e){var t=this._centralPart.L2PX(e.value);e.representation.updatePos({x:t}),e._checkedPos={x:t}}},updateLinePos:function(){if(this._centralPart){var e=p.call(this);this.axisLine.setX2(e)}},checkValuePos:function(e,t,i){if(e._checkedPos){var o=!1,n=e.representation.getBoundingRect();if(n.x+n.width>i.width){let t=n.x;n.x=i.width-n.width,e._checkedPos.x+=n.x-t,o=!0}n.x<t.pos?t.pos?e._checkedPos.isHidden=!0:(e._checkedPos.x-=n.x,t.pos=n.width+5):(t.pos=n.x+n.width+5,o||delete e._checkedPos)}},getPos:e=>e.x};function _(e,t){var i=this._layout.getValueLayout.call(this,e.value);e.representation.create(e,this.canvas,this.getFormatValue(),i,t),e._checkedPos={x:i.textX,y:i.textY}}function y(){if(!this.axisLine){var e=this._layout.getLineLayout.call(this);this.axisLine=this.canvas.addLine(e.startX,e.startY,e.endX,e.endY,e.lineClass)}}function b(){if(void 0!==this.from){this.textBaseWidth||(this.textBaseWidth=this.canvas.getTextSize("0000").width/4);var e=this.from,t=this.to,i=t-e,o=Math.log10(i),n=10**(Math.floor(o)-1),s=Math.floor(i/n),r=Math.ceil(Math.log10(t)),a=((r>0?r:1)+(o<0?-Math.floor(o):0))*this.textBaseWidth,l=Math.floor(p.call(this)/(2.5*a));s>l&&(n*=Math.floor(s/l));var c=e>0?Math.ceil(e/n)*n:n;c===e&&(c+=n);for(var d=o<0?1-Math.floor(o):0;c<t;c+=n)this.addValue(c,void 0,void 0,d);this.layoutValues()}}function w(){if(!this.noValuePosCheck){var e={pos:0},t=this.body.getBoundingClientRect();this.values.sort(function(e,t){if(e._checkedPos&&t._checkedPos){var i=this._layout.getPos;return i(e._checkedPos)-i(t._checkedPos)}return 0}.bind(this)).forEach(function(i){this._layout.checkValuePos(i,e,t)}.bind(this)),this.values.forEach(h.bind(this))}}function x(e,t,i){this._parent=n.default.getDomElement(e),this._layout=t,this.values=[],this.body=document.createElement("div"),this.body.className=t.getClass(),this._parent.appendChild(this.body),this.canvas=o.A.create(void 0,!i),this.body.appendChild(this.canvas.el),this._sizes={},this.body.refreshSize=function(e){if(this._centralPart)return e&&e.movingZoomFrame||(this._sizes={}),this.values.forEach(this._layout.updateValuePos.bind(this)),this._layout.updateLinePos.call(this),w.call(this),!0}.bind(this)}function C(){}function A(e,t){e&&e.show().front().setAttr("font-weight","bold").setFilter(t)}function S(e,t){e&&e.hide().remAttr("font-weight").remFilter(t)}x.prototype.getFormatValue=function(){return this.onformat||function(e){return e}},C.prototype.create=function(e,t,i,o,n){this.line=t.addLine(o.tickStartX,o.tickStartY,o.tickEndX,o.tickEndY,o.tickClass),this.hotLine=t.addLine(o.tickStartX,o.tickStartY,o.tickEndX,o.tickEndY,"idvc2_chart_axis_hot"),this.text=t.addText(o.textX,o.textY,i(e.value,n),o.textClass,e.id),this.text.setStyle(o.textStyle)},C.prototype.updatePos=function(e){e&&(void 0!==e.y?(this.text.setY(e.y),this.line.setY1(e.y).setY2(e.y),this.hotLine.setY1(e.y).setY2(e.y)):void 0!==e.x&&(this.text.setX(e.x),this.line.setX1(e.x).setX2(e.x),this.hotLine.setX1(e.x).setX2(e.x)),this.show())},C.prototype.setPos=function(e){e&&(void 0!==e.y&&this.text.setY(e.y),void 0!==e.x&&this.text.setX(e.x),e.isHidden?this.hide():this.show())},C.prototype.getBoundingRect=function(){return this.text.getBoundingRect()},C.prototype.setLabel=function(e,t,i){this.text.setText(t(e,i))};const T="TextBackground";function I(e,t){x.call(this,e,g,t)}function P(e){var t=!1,i=function(e){e=e||event,this.dragProcessor&&this.dragProcessor.dragging(e.pageX,e.pageY)}.bind(this),o=function(e){e=e||event,this.dragProcessor&&this.dragProcessor.stopDragging(e.pageX,e.pageY),t=!1,window.removeEventListener("mousemove",i,!0),window.removeEventListener("mouseup",o,!0)}.bind(this);e.onmousedown=function(e){this.dragProcessor&&0===(e=e||event).button&&(e.ctrlKey||e.shiftKey||(this.dragProcessor.startDragging(e.pageX,e.pageY),t=!0,window.addEventListener("mousemove",i,!0),window.addEventListener("mouseup",o,!0)))}.bind(this),e.addEventListener("mousemove",function(e){this.dragProcessor&&((e=e||event).ctrlKey||e.shiftKey||(e.preventDefault(),!t&&this.dragProcessor.movingOver&&this.dragProcessor.movingOver(e.pageX,e.pageY)))}.bind(this),!1)}C.prototype.show=function(){this.text.show(),this.showText&&this.hideText&&(this.hotLine.deactivate().off("mouseenter",this.showText).off("mouseleave",this.hideText),delete this.showText,delete this.hideText)},C.prototype.hide=function(){this.text.hide(),function(e,t){if(e&&t){var i=e.getElementById(t);i||(i=e.createTextBackground(t))}}(this.text.getCanvas(),T),this.showText=A.bind(this,this.text,T),this.hideText=S.bind(this,this.text,T),this.hotLine.activate().on("mouseenter",this.showText).on("mouseleave",this.hideText)},x.prototype.addValue=function(e,t,i,o){return i=i||C,this.values.push({value:e,id:t,representation:new i,prec:o}),this._centralPart&&_.call(this,this.values[this.values.length-1],o),this},x.prototype.changeValue=function(e,t){if(e>=0&&e<this.values.length){var i=this.values[e];i.value=t,this._layout.updateValuePos.call(this,i,!0),i.representation.setLabel(i.value,this.getFormatValue())}return this},x.prototype.layoutValues=function(){return w.call(this),this},x.prototype.setCentralPart=function(e){return this._centralPart=e,y.call(this),this},x.prototype.clear=function(){return this._centralPart=void 0,this.values.length=0,this.canvas.clear(),this.axisLine=void 0,this._sizes={},this},x.prototype.recreate=function(){var e=this.values.slice(),t=this._centralPart;return this.clear(),this.setCentralPart(t),e.forEach((e=>this.addValue(e.value,e.id,e.representation.constructor,e.prec))),this},x.prototype.getOptimalWidth=function(e){var t=0;return e=e||0,this.values.forEach(function(i){var o=i.representation.getBoundingRect(),n=this._layout.getValueLayout.call(this,i.value);t=Math.max(t,o.width+function(e){return e&&e.textX&&e.tickEndX?Math.abs(e.textX-e.tickEndX):0}(n)+e)}.bind(this)),t},I.prototype=Object.create(x.prototype),I.prototype.setTimeFrame=function(e,t){return this.from=e,this.to=t,this._centralPart&&b.call(this),this},I.prototype.setCentralPart=function(e){return x.prototype.setCentralPart.call(this,e),b.call(this),this},I.prototype.clear=function(){return x.prototype.clear.call(this),delete this.from,delete this.to,this};const M="idvc2_chart_selection";function E(e,t){this._parent=n.default.getDomElement(e),n.default.addClass(this._parent,"idvc2_chart_content"),this.body=document.createElement("div"),this.body.className="idvc2_chart_body",this._parent.appendChild(this.body),this.canvas=o.A.create(void 0,!t),this.body.appendChild(this.canvas.el),this.graphicsRoot=this.canvas,this.dragProcessor=void 0,P.call(this,this.body),this.body.addEventListener("dblclick",function(e){if(e=e||event,this.ondblclick){var t=this.screenP2L(e.pageX,e.pageY);this.ondblclick(t.x,t.y)}}.bind(this),!1);var i=n.default.addTooltip(this.body,function(e,t,i){if(!this._disabledTooltip&&e){var o=this.screenP2L(t,i),n=this.ontooltiptext&&this.ontooltiptext(e,o.x,o.y)||"",s={};return this.ontooltipattrs&&(s=this.ontooltipattrs(e,n,o.x,o.y)||{}),{text:n,target:e,keepCurrent:!0,tracking:!0,autoHideDelay:s.autoHideDelay||4e3,delay:s.showDelay||0}}}.bind(this),(function(){return!0}),"idvc2_chart_tooltip");this.body.refreshSize=function(e){e&&e.movingZoomFrame||this.tr&&this.tr._clear()}.bind(this),this._updateTooltip=i.update.bind(i),this.hideTooltip=i.hide.bind(i)}function L(e,t,i){const o=1e7;return t>o?(this["L2C"+i]=function(i){return e+function(e,t){return t*o/e}(t,i-e)},this["C2L"+i]=function(i){return e+function(e,t){return t*e/o}(t,i-e)},o):t}function R(e,t){return t<0?{start:e+t,width:-t}:{start:e,width:t}}function D(e,t){return e>t?{start:t,end:e}:{start:e,end:t}}function k(){function e(e){this[e]!==E.prototype[e]&&delete this[e]}e.call(this,"L2CX"),e.call(this,"L2CY"),e.call(this,"C2LX"),e.call(this,"C2LY")}function O(e){this.body=e;var t=e.refreshSize;e.refreshSize=function(e){e&&e.movingZoomFrame||this.tr&&this.tr._clear(),t&&t(e)}.bind(this)}E.prototype.enableTooltip=function(e){e?delete this._disabledTooltip:this._disabledTooltip=!0},E.prototype.setDragProcessor=function(e){this.removeSelection(),this.dragProcessor=e},E.prototype.setViewbox=function(e,t,i,o,s){var r=o-t,l=i-e;if(this.canvas){if(r=L.call(this,t,r,"Y"),l=L.call(this,e,l,"X"),s=s||function(e,t,i,o,n){return e.createG().createRect().setClass("idvc2_chart_empty").setX(t).setY(i).setWidth(o).setHeight(n).getParent()}(this.canvas,e,t,l,r),this.graphicsRoot=s,this.canvas.setViewSize(e,t,l,r),!a(this._parent)){var c=r+2*t;s.setAttr("transform","translate(0,"+c+") scale(1,-1)")}}else{function p(e){return Math.round(e)}const u=100,h=100;var d={};this.tr&&(d=this.tr._sizes),this.tr={_getClientWidth:function(){return Math.max(this._getBoundingWidth(),u)},_getClientHeight:function(){return Math.max(this._getBoundingHeight(),h)},canvas:this.getCanvas(),body:this.body,_sizes:{},getCanvas:function(){return this.canvas},getTop:function(){return 0},getHeight:function(){return this._getBoundingHeight()},getWidth:function(){return this._getBoundingWidth()},L2P:function(e,t){return{x:this.L2PX(e),y:this.L2PY(t)}},L2PX:function(t){return p((t-e)*this._getClientWidth()/(i-e))},L2PY:function(e){return p(this._getClientHeight()*(1-(e-t)/(o-t)))},P2L:function(e,t){return{x:this.P2LX(e),y:this.P2LY(t)}},P2LX:function(t){return e+t*(i-e)/this._getClientWidth()},P2LY:function(e){return t+(o-t)*(1-e/this._getClientHeight())},screenP2L:function(e,t){return{x:this.screenP2LX(e),y:this.screenP2LY(t)}},screenP2LX:function(e){return e-=n.default.getElementPos(this.body).x,this.P2LX(e)},screenP2LY:function(e){return e-=n.default.getElementPos(this.body).y,this.P2LY(e)},_clear:function(){this._sizes={}},_getBoundingWidth:function(){return this._sizes.width||(this._sizes.width=this.body.getBoundingClientRect().width),this._sizes.width},_getBoundingHeight:function(){return this._sizes.height||(this._sizes.height=this.body.getBoundingClientRect().height),this._sizes.height}},this.tr._sizes=d}this._updateTooltip&&this._updateTooltip()},E.prototype.getTop=function(){return this.body&&this.body.offsetTop||0},E.prototype.getHeight=function(){var e;return this.body&&(e=this.body.getBoundingClientRect().height),e||0},E.prototype.getWidth=function(){var e;return this.body&&(e=this.body.getBoundingClientRect().width),e||0},E.prototype.updateCursor=function(){var e=this.body.style.cursor;e&&n.default.changeCursor(e)},E.prototype.removeSelection=function(){this.selection&&(this.selection.remove(),delete this.selection)},E.prototype.createHorzSelection=function(e,t){if(this.selection)return this.selection;this.selection=this.canvas.addRect(0,e,0,t-e,M);var i=this.selection;i.el.onselectstart=function(){return!1};var o=this,n={x:-1,dragged:!1,isBorder:!1,width:0,start:0};function s(e,t){return t>e-4&&t<e+4}const r="e-resize";return this.dragProcessor={startDragging:function(e){n.x=e,n.isBorder=o.body.style.cursor===r},stopDragging:function(e){n.dragged&&n.width&&(this.movingOver(e),o.onselectionchanged&&o.onselectionchanged(o.screenP2LX(n.start),o.P2LX(n.width))),n.x=-1,n.dragged=!1},dragging:function(e){!function(e){var t=e-n.x;!n.dragged&&Math.abs(t)>1&&(n.dragged=!0,o.body.style.cursor=r,n.isBorder?s(n.start,n.x)&&(n.start+=n.width,n.width=-n.width):(n.width=0,n.start=n.x),o.onselectionstarted&&o.onselectionstarted(o.screenP2LX(n.start))),n.dragged&&(n.width+=t,function(e,t){if(t){var n=R(e,t),s=n.start,r=n.start+n.width;if(o.graphicsRoot){let e=o.graphicsRoot.getCanvas();e&&(s=e.Screen2SVGX(s,o.graphicsRoot),r=e.Screen2SVGX(r,o.graphicsRoot))}i.setX(s).setWidth(Math.abs(r-s))}}(n.start,n.width),n.x=e)}(e)},movingOver:function(e){s(n.start,e)||s(n.start+n.width,e)?o.body.style.cursor=r:o.body.style.cursor=""}},this.selection},E.prototype.createFreeSelection=function(){if(this.selection)return this.selection;this.selection=this.canvas.addRect(0,0,0,0,M);var e=this.selection;e.el.onselectstart=function(){return!1};var t=this,i={x:-1,y:-1,dragged:!1,width:0,height:0,startX:0,startY:0};return this.dragProcessor={startDragging:function(e,t){i.x=e,i.y=t},stopDragging:function(e,o){i.dragged&&i.width&&i.height&&t.onselectionchanged&&setTimeout((function(){var e=t.screenP2LX(i.startX),o=t.screenP2LY(i.startY),n=t.screenP2LX(i.startX+i.width),s=t.screenP2LY(i.startY+i.height),r=D(e,n),a=D(o,s);t.onselectionchanged(r.start,a.start,r.end,a.end)}),0),i.x=-1,i.y=-1,i.dragged=!1},dragging:function(o,n){!function(o,n){var s=o-i.x,r=n-i.y;!i.dragged&&(Math.abs(s)>1||Math.abs(r)>1)&&(i.dragged=!0,i.width=0,i.height=0,i.startX=i.x,i.startY=i.y,t.onselectionstarted&&t.onselectionstarted(t.screenP2LX(i.startX),t.screenP2LY(i.startY))),i.dragged&&(i.width+=s,i.height+=r,function(i,o,n,s){if(n||s){var r=R(i,n),a=R(o,s),l=r.start,c=a.start,d=r.start+r.width,p=a.start+a.width;if(t.graphicsRoot){let e=t.graphicsRoot.getCanvas();e&&(l=e.Screen2SVGX(l,t.graphicsRoot),c=e.Screen2SVGY(c,t.graphicsRoot),d=e.Screen2SVGX(d,t.graphicsRoot),p=e.Screen2SVGY(p,t.graphicsRoot))}e.setX(l).setY(c).setWidth(Math.abs(d-l)).setHeight(Math.abs(p-c))}}(i.startX,i.startY,i.width,i.height),i.x=o,i.y=n)}(o,n)}},this.selection},E.prototype.setSelection=function(e,t){var i=this.selection;if(i){var o=R(e,t);i.setX(o.start).setWidth(o.width),this.onselectionchanged&&this.onselectionchanged(e,t)}},E.prototype.getSelection=function(){var e=this.selection;if(e)return{start:parseFloat(e.getAttr("x")),width:parseFloat(e.getAttr("width"))}},E.prototype.hideSelection=function(){var e=this.selection;e&&e.setX(0).setY(0).setWidth(0).setHeight(0)},E.prototype.event2SVGPos=function(e){return this.screenP2L(e.pageX,e.pageY)},E.prototype.clear=function(){return this.selection&&delete this.selection,this.canvas.clear(),k.call(this),this.tr&&delete this.tr,this},E.prototype.L2CY=function(e){return e},E.prototype.L2CX=function(e){return e},E.prototype.C2LY=function(e){return e},E.prototype.C2LX=function(e){return e},E.prototype.L2P=function(e,t){var i={x:e,y:t};if(this.tr)i=this.tr.L2P(e,t);else if(this.graphicsRoot){let o=this.graphicsRoot.getCanvas();o&&(i=o.SVG2Element(this.L2CX(e),this.L2CY(t),this.graphicsRoot))}return i},E.prototype.L2PX=function(e){var t=e;if(this.tr)t=this.tr.L2PX(e);else if(this.graphicsRoot){let i=this.graphicsRoot.getCanvas();i&&(t=i.SVG2ElementX(this.L2CX(e),this.graphicsRoot))}return t},E.prototype.L2PY=function(e){var t=e;if(this.tr)t=this.tr.L2PY(e);else if(this.graphicsRoot){let i=this.graphicsRoot.getCanvas();i&&(t=i.SVG2ElementY(this.L2CY(e),this.graphicsRoot))}return t},E.prototype.P2L=function(e,t){var i={x:e,y:t};if(this.tr)i=this.tr.P2L(e,t);else if(this.graphicsRoot){let o=this.graphicsRoot.getCanvas();o&&(i=o.Element2SVG(e,t,this.graphicsRoot),i={x:this.C2LX(i.x),y:this.C2LY(i.y)})}return i},E.prototype.P2LX=function(e){var t=e;if(this.tr)t=this.tr.P2LX(e);else if(this.graphicsRoot){let i=this.graphicsRoot.getCanvas();i&&(t=this.C2LX(i.Element2SVGX(e,this.graphicsRoot)))}return t},E.prototype.P2LY=function(e){var t=e;if(this.tr)t=this.tr.P2LY(e);else if(this.graphicsRoot){let i=this.graphicsRoot.getCanvas();i&&(t=this.C2LY(i.Element2SVGY(e,this.graphicsRoot)))}return t},E.prototype.screenP2L=function(e,t){var i={x:e,y:t};if(this.tr)i=this.tr.screenP2L(e,t);else if(this.graphicsRoot){let o=this.graphicsRoot.getCanvas();o&&(i=o.Screen2SVG(e,t,this.graphicsRoot),i={x:this.C2LX(i.x),y:this.C2LY(i.y)})}return i},E.prototype.screenP2LX=function(e){var t=e;if(this.tr)t=this.tr.screenP2LX(e);else if(this.graphicsRoot){let i=this.graphicsRoot.getCanvas();i&&(t=this.C2LX(i.Screen2SVGX(e,this.graphicsRoot)))}return t},E.prototype.screenP2LY=function(e){var t=e;if(this.tr)t=this.tr.screenP2LY(e);else if(this.graphicsRoot){let i=this.graphicsRoot.getCanvas();i&&(t=this.C2LY(i.Screen2SVGY(e,this.graphicsRoot)))}return t},E.prototype.getCanvas=function(){return this.canvas},O.prototype=Object.create(E.prototype);const N={createVertAxis:function(e,t){return new x(e,v,t)},createHorzAxis:function(e,t){return new x(e,g,t)},createTimeAxis:function(e,t){return new I(e,t)},createCentralPart:function(e,t){return new E(e,t)},createSelfCentralPart:function(e){return new O(e)},DefValueRepresentation:C,formatAxisValue:function(e,t,i){if(!e)return"0";var o=Math.floor(Math.log10(e));if(void 0===t&&(t=o>-1?2:Math.ceil(Math.abs(o))+1),i||o>=-4&&o<=4){var s=n.default.round(e,t);return i&&(o<-4||o>4)&&(s=+s.toFixed(t)),s}return n.default.roundExp(e,2)}}},49466:e=>{e.exports=' <h4>Reduce spills</h4> <div class="text"> <div class="promo"> Reduce spills using the following techniques: recompute cheap-to-compute values, choose smaller data types. </div> <div class="text"> <br> <ul> <li><b>Recompute cheap-to-compute values on demand.</b></li> <p> Recompute cheap-to-compute values on demand. Otherwise, the values stay in registers for a long time and increase register pressure. </p> <br> <li><b>Avoid using big private arrays or large private structure.</b></li> <p> Big arrays may be promoted to <span data-glossary-id="GRF">GRF</span> increasing the register pressure or to an extended private memory region increasing the memory traffic. To improve performance, consider decreasing the size of the arrays to fit into <span data-glossary-id="GRF">GRF</span> or promoting such arrays to <span data-glossary-id="SLM">SLM</span>. </p> <br> <li><b>Choose smaller data types.</b></li> <p> Smaller data types occupy less space in <span data-glossary-id="GRF">GRF</span>. Use smaller data types to decrease the register pressure: </p><ul> <li><b>integer(kind = 4)</b> instead of <b>integer(kind = 8)</b></li> <li><b>real(kind = 4)</b> instead of <b>real(kind = 8)</b></li> </ul> <p></p> <br> </ul> </div> </div> '},49473:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>f});var o=function(){return(0,this._self._c)("div",{staticClass:"bar-chart-body"})};o._withStripped=!0,i(36094),i(27468),i(69212),i(32204);var n=i(66275),s=i(61262),r=i(49463);const a="data-tooltip",l="data-index";function c(e,t){function i(e){e!==this._activeElemIndex&&(this._activeElemIndex>=0&&this.onExitElement.raise(this._activeElemIndex),this._activeElemIndex=e,this._activeElemIndex>=0&&this.onEnterElement.raise(this._activeElemIndex))}e=s.default.getDomElement(e),this._parent=e,this.hidePercentLabels=t,this._parent.classList.add("idvc2_chart_top"),this._parent.classList.add("idvc2_chart_no_axis"),this.onTooltipText=n.A.create(),this.onTooltipAttrs=n.A.create(),this.onEnterElement=n.A.create(),this.onExitElement=n.A.create(),this.elements=[],this._activeElemIndex=-1,this.centralPart=r.A.createCentralPart(e,!0),this.centralPart.ontooltiptext=e=>{if(e&&e.owner){var t=e.owner,o=t.getAttr(l);if(o){o=+o,i.call(this,o);var n={tooltipText:t.getAttr(a)};return this.onTooltipText.raise(o,n),n.tooltipText}i.call(this,-1)}else i.call(this,-1)},this.centralPart.ontooltipattrs=e=>{if(!e||!e.owner)return{};var t={};return this._activeElemIndex>=0&&this.onTooltipAttrs.raise(this._activeElemIndex,t),t},this.centralPart.body.addEventListener("mouseout",i.bind(this,-1),!1)}c.prototype.setValues=function(e,t,i,o,n){if(this.setViewbox(),this.centralPart.graphicsRoot){n=n||r.A.formatAxisValue,this.textSize=this.centralPart.canvas.getTextSize("100%"),this.textSize.width&&this.textSize.height||(this.textSize.width=30.7,this.textSize.height=13.4);var s=e.reduce(((e,t)=>e+t),0),c=0,d=0;for(let r=0,p=e.length;r<p;r++){let u=e[r],h=u/s,m=r<p-1?Math.round(100*h):100-d,f=(Array.isArray(i)?i[r]:i)||"white",v=this.createElement(c,h,t[r],this.hidePercentLabels?"":m+"%",f);v&&v.body.setAttr(a,o[r]+": "+n(u)).setAttr(l,r),this.elements.push(v),c+=h,d+=m}}},c.prototype.clear=function(){this.centralPart.clear(),this.elements=[],this._activeElemIndex=-1},c.prototype.refreshSize=function(){s.default.refreshSize(this._parent)},c.prototype.toggleElement=function(){},c.prototype.setViewbox=function(){},c.prototype.createElement=function(){};const d=c;function p(e,t,i,o){d.call(this,e,i),t=t||0,this.innerRadius=t<1?t:1/t,this.size=o}p.prototype=Object.create(d.prototype),p.prototype.setViewbox=function(){this.centralPart.setViewbox(-1.05,-1.05,1.05,1.05),this.centralPart.canvas.setAttr("preserveAspectRatio","xMidYMid meet"),this.size&&(this.centralPart.canvas.setAttr("width",this.size),this.centralPart.canvas.setAttr("height",this.size))},p.prototype.createElement=function(e,t,i,o,n){if(!t)return;1===t&&(t=.99999);var s=this.centralPart.graphicsRoot;if(!s)return;var{innerRadius:r,textSize:a}=this;const l=Math.PI/2;var c,d=2*Math.PI*e-l,p=2*Math.PI*(e+t)-l,u=Math.cos(d),h=Math.sin(d),m=Math.cos(p),f=Math.sin(p),v=r*u,g=r*h,_=r*m,y=r*f,b=t<.5?0:1,w=s.createPath().moveToAbs(u,h).arcAbs(1,1,0,b,1,m,f).lineToAbs(_,y).arcAbs(r,r,0,b,0,v,g).closePath().setD().setStyle(`vector-effect: non-scaling-stroke; fill: ${i};`).activate().addClass("idvc2_chart_pie");if(o&&t>.09){let e=(d+p)/2,t=(1+r)/2,i=t*Math.cos(e),l=t*Math.sin(e),u=a.height/a.width*(1-r)*.8;c=s.createText(o).setX(i).setY(l).setStyle(`fill: ${n};font-size: ${u};\n          text-anchor: middle; dominant-baseline: middle;`)}return{body:w,text:c}};const u="idvc2_piechart_toggled";p.prototype.toggleElement=function(e){if(!(e<0||e>=this.elements.length)){var t=this.elements[e];t&&(t.body.toggleClass(u),t.text&&t.text.toggleClass(u))}},p.prototype.activateElement=function(e,t){if(!(e<0||e>=this.elements.length)){var i=this.elements[e];i&&(t?(i.body.addClass(u),i.text&&i.text.addClass(u)):(i.body.remClass(u),i.text&&i.text.remClass(u)))}};const h={data:()=>({chart:null}),props:{chartData:{type:Object,required:!0},size:{type:Number,default:150},innerRadius:{type:Number,default:.35},hidePercentLabels:{type:Boolean,default:!1}},mounted(){var e,t,i,o;this.$el.style.width=this.size+"px",this.$el.style.height=this.size+"px",this.chart=(e=this.$el,t=this.innerRadius,i=this.hidePercentLabels,new p(e,t,i,o)),this.fillChart()},watch:{chartData(){this.chart.clear(),this.fillChart()}},methods:{fillChart(){const e=this.chartData,t=this.chart;t&&e&&e.values&&e.values.length&&t.setValues(e.values,e.colors,e.textColors,e.labels,e.formatValues)}}},m=h,f=(0,i(98822).A)(m,o,[],!1,null,"ab0c1e26",null).exports},49602:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=i(60970);const n={functional:!0,props:{wrap:{type:String,default:"wrap"},direction:{type:String,default:o.DIRECTION_ROW}},render(e,t){const{props:i,data:o,children:n}=t;return e("div",{style:{display:"flex","flex-wrap":i.wrap,"flex-direction":i.direction},...o},n)}},s=(0,i(98822).A)(n,void 0,void 0,!1,null,null,null).exports},49802:e=>{e.exports=' <h4>Apply data reuse</h4> <div class="text"> <div class="promo"> <p>Apply the <b>data reuse</b> technique.</p> <p> With this technique, two sequential kernels can share data without additional data transfer. This can improve data transfer efficiency. For variables used by multiple target constructs, use the <samp class="codeph">target enter data</samp> and <samp class="codeph">target exit data</samp> directives to minimize data transfers between host and target devices. </p> </div> <br> <p> The estimated <b>default</b> data transfer without data reuse for this kernel is %data_transfer_total_no_reuse% (the data transferred from the target device is %data_transfer_read_no_reuse%, the data transferred to the target device is %data_transfer_write_no_reuse%). </p> <br> <p> The estimated data transfer <b>with data reuse applied</b> is %data_transfer_total% (the data transferred from the target device is %data_transfer_read%, the data transferred to the target device is %data_transfer_write%). </p> <br> <p> With the data reuse applied, you may get the data transfer gain (speedup): %data_reuse_speed_up_percents%. </p> <br> Place the data reuse directives as follows: <ul> <li> Place the <samp class="codeph">target enter data</samp> directive before the first <samp class="codeph">target</samp> directive to transfer data from host to target device. </li> <li> Place the <samp class="codeph">target exit data</samp> directive after the last <samp class="codeph">target</samp> directive to transfer data from target to host device. </li> </ul> See the <a href="https://www.openmp.org/spec-html/5.1/openmpsu66.html">OpenMP* specification</a> for more details. <p class="expander">Example of data reuse organization:</p> <pre class="essential"><code class="cpp" data-source="\nvoid matmult(float* mA, float* mB, float* mC)                                  \n{                                                                              \n    #pragma omp target teams distribute parallel for collapse(2) map(to: mA[0:N*N], mB[0:N*N]) map(from: mC[0:N*N]) \n...\n}                                                                              \n...\n    #pragma omp target enter data map(to: A[0:N*N], B[0:N*N], C[0:N*N]) map(alloc: C1[0:N*N]) \n    matmult(A, B, C1); \n    matmult(C1, C, D); \n    #pragma omp target exit data map(delete: C1[0:N*N])  \n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\nvoid matmult(float* mA, float* mB, float* mC)                                  \n{                                                                              \n    #pragma omp target teams distribute parallel for collapse(2) map(to: mA[0:N*N], mB[0:N*N]) map(from: mC[0:N*N]) \n    for (int i = 0; i < N; i++)\n        for (int j = 0; j < N; j++)\n            {\n                float item = 0;\n                for (int k = 0; k < N; k++)\n                    item += mA[i * N + k] * mB[k * N + j];\n                mC[i * N + j] = item;\n            }\n}                                                                              \n\nvoid matmult3(float* A, float* B, float* C, float* D)\n{\n    float* C1 = new float[N*N];\n    #pragma omp target enter data map(to: A[0:N*N], B[0:N*N], C[0:N*N]) map(alloc: C1[0:N*N]) \n    matmult(A, B, C1); \n    matmult(C1, C, D); \n    #pragma omp target exit data map(delete: C1[0:N*N])  \n    delete[] C1;\n}\n"></code></pre> </div> '},49892:(e,t,i)=>{"use strict";i.r(t),i(84422);var o=i(77106),n=i(18323);function s(e,t){if(!e||!e.children[1])return;let i=e.children[1].innerHTML;if(null!=t.bounded_by||null!=t.gpu_bounded_by){let e="<p>"+n.A.getMessage("rec_bounded_by");e+=' <span class="hljs-title">%bounded_by%</span>.</p>',i=i.replaceAll(/%kernel_bounded_by%/g,e),t.bounded_by?t.bounded_by=n.A.getMessage(t.bounded_by):t.gpu_bounded_by&&(t.bounded_by=n.A.getMessage(t.gpu_bounded_by))}else i=i.replaceAll(/%kernel_bounded_by%/g,"");e.children[1].innerHTML=(0,o.applyRecParams)(i,t)}window.issue_insufficient_parallel_work=function(e,t){if(!e||!t)return;const i=e.querySelector("#global_work_size");i&&i.Visible(null!=t.global_work_size);const o=e.querySelector("#thread_occupancy_percent");o&&o.Visible(null!=t.thread_occupancy_percent);const n=e.querySelector("#thread_slots_all");n&&n.Visible(null!=t.thread_slots);const r=e.querySelector("#thread_slots_per_eu");r&&r.Visible(null!=t.thread_slots_per_eu);const a=e.querySelector("#eu_count");a&&a.Visible(null!=t.eu_count);const l=e.querySelector("#threads");l&&l.Visible(null!=t.gpu_current_row_simd_width&&null!=t.thread_issued_per_compute_task_count),s(e,t)},window.issue_inefficient_data_transfer=s},50139:e=>{e.exports=' <h4>Remove indirect call(s) inside loop</h4> <div class="text promo"> Indirect function or subroutine calls cannot be vectorized. To fix: Avoid using indirect calls in loops. </div>'},50370:e=>{e.exports=' <h4>Improve branch prediction</h4> <div class="text"> <p class="promo"> For 64-bit applications, branch prediction performance can be negatively impacted when the branch target is more than 4 GB away from the branch. This is more likely to happen when the application is split into shared libraries. To fix: Do the following: </p> <ul> <li>Upgrade the Glibc library to version 2.23 or higher.</li> <li>Set environment variable export <samp class="codeph">LD_PREFER_MAP_32BIT_EXEC=1</samp>.</li> </ul> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.sourceware.org/ml/libc-alpha/2016-02/msg00502.html">Glibc 2.23 release notes</a> and <a href="HTTPS://PERMALINK.GMANE.ORG/GMANE.COMP.LIB.GLIBC.BUGS/23698">libc bug report 19367: Improve branch prediction</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},50484:(e,t,i)=>{"use strict";i.d(t,{A:()=>s});var o=i(33202),n=i(35439);const s={getPreset:async()=>await(0,o.mi)("workflow/preset"),getAllPerspectives:async()=>await(0,o.mi)("workflow/all-perspectives"),getPerspectiveDetails:async(e,t)=>await(0,o.mi)("workflow/perspective-details",{mode:e,modeTag:t}),getAnalysisKnobs:async e=>await(0,o.mi)("workflow/analysis-knobs",{id:e}),getAnalysisCommands:async e=>await(0,o.mi)("workflow/analysis-commands",{id:e}),getTargetPlatform:async e=>await(0,o.mi)("workflow/target-platform",{mode:e}),getBaselineDevice:async()=>await(0,o.mi)("workflow/baseline-device"),executeCommand:async(e,t)=>await(0,o.mi)("workflow/execute-command",{cmd:e,analysisTypes:t}),updateKnobs:async(e,t)=>await(0,o.mi)("workflow/update-knobs",{knobs:e,analysisId:t}),getProject:async()=>await(0,o.mi)("workflow/project"),onStatusChange(e){n.on(n.fx).add(e)},onKnobsUpdate(e){n.on(n.tC).add(e)},offKnobsUpdate(e){n.on(n.tC).remove(e)},onRunMRUAnalysis(e){n.on(n.uR).add(e)},offRunMRUAnalysis(e){n.on(n.uR).remove(e)},send(e,t={}){(0,o._Y)(`workflow/${e}`,t)}}},50677:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"workflow"},[null===e.$store.state.activePerspectiveId?t("data-loading",{attrs:{static:""}}):e._e(),e._v(" "),t("i",{staticClass:"close-button icon cross",on:{click:function(t){return e.$emit("on-close")}}}),e._v(" "),t("perspective-selector",{staticClass:"perspective-selector",attrs:{"enum-style":"wf-perspective"}}),e._v(" "),t("perspective")],1)};o._withStripped=!0,i(69212),i(38333);var n=i(83230);const s={async created(){const{accuracyEnable:e}=await n.default.workflow.getPreset();this.$store.direct.commit.workflow.setCustomAccuracy(!e);const t=await n.default.workflow.getAllPerspectives(),i=t.find((e=>e.selected))||{value:0};this.$store.direct.commit.updatePerspectives(t),this.$store.direct.commit.updateActivePerspectiveId(i.value)}},r=(0,i(98822).A)(s,o,[],!1,null,"52e877e7",null).exports},50860:e=>{e.exports=' <h4>Ineffective peeled/remainder loop(s) present</h4> <div class="essential"> All or some <span data-glossary-id="source_loop">source loop</span> iterations are not executing in the <span data-glossary-id="loop_body">loop body</span>. Improve performance by moving source loop iterations from <span data-glossary-id="peeled_loop">peeled</span>/<span data-glossary-id="remainder_loop">remainder</span> loops to the loop body. </div>'},50918:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"code_optimizations"}},[t("div",{staticClass:"content"},[t("div",{attrs:{name:"title","data-tooltip":"Code Optimizations Applied by Compiler"}},[e._v(e._s(e.$t("code-optimizations")))]),e._v(" "),e._m(0),e._v(" "),e._m(1),e._v(" "),e._m(2),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.compact,expression:"compact"}],staticClass:"essential",attrs:{id:"code_optimizations_summary"}},[e._m(3)]),e._v(" "),t("div",{staticClass:"expander"}),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.compact,expression:"!compact"}],staticClass:"expansion"},[e._m(4),e._v(" "),t("ul",{attrs:{id:"vectorization_details","aria-label":"Compiler Notes On Vectorization:"}}),e._v(" "),t("ul",{attrs:{id:"optimization_details","aria-label":"Compiler Optimization Details:"}})])])])};o._withStripped=!0,i(69212),i(45361);const n={compiler_name:"Intel C++",compiler_ver:"16.1",unroll_factor:"5",estimated_gain:"2.27x",multiversion:[{name:"Assumed Dependencies In Strides",number:1,good:!0},{name:"Trip Count"}],vectorization_details:["Unaligned access in Vector Loop"],optimization_details:["LOOP STMTS WERE REORDERED","PEELED LOOP","LOOP WAS INTERCHANGED"]},s={computed:{compact(){return this.$parent.compact}},mounted(){const{$el:e}=this,t=void 0!==n.compiler_name,i=void 0!==n.compiler_ver,o=void 0!==n.estimated_gain,s=void 0!==n.multiversion;n.vectorization_details=n.vectorization_details||[],n.optimization_details=n.optimization_details||[];const r=n.vectorization_details.length+n.optimization_details.length,a=t||i||o||s||r>0;if(e.Visible(a),!a)return;qs("#compiler_name",e).parentElement.Visible(t),t&&(qs("#compiler_name",e).innerHTML=n.compiler_name),qs("#compiler_ver",e).parentElement.Visible(i),i&&(qs("#compiler_ver",e).innerHTML=n.compiler_ver);const l=qs("#estimated_gain",e);l.parentElement.Visible(o),o&&(l.innerHTML=n.estimated_gain);const c=qs("#multiversioned",e);if(c.Visible(s),s){const e=c.firstElementChild;for(;null!=c.firstChild;)c.removeChild(c.firstChild);n.multiversion.forEach((function(t){const i=e.cloneNode(!0),o=i.firstElementChild;o.classList.remove("multi_good"),o.classList.remove("multi_bad"),null!=t.number?(o.classList.add(t.good?"multi_good":"multi_bad"),o.innerHTML=t.name+" (v"+t.number+")",o.dataset.tooltip=(t.good?"Vectorizable":"Non-vectorizable")+" version"):o.innerHTML=t.name,c.appendChild(i)}))}qs(".expander",e).Visible(0!==r),qs("#total_optimizations",e).innerHTML=r>0?r:"no",0===r?qs("#code_optimizations_summary",e).classList.remove("essential"):qs("#code_optimizations_summary",e).classList.add("essential");let d=qs("#vectorization_details",e);for(;null!=d.firstChild;)d.removeChild(d.firstChild);for(d.Visible(n.vectorization_details.length>0),n.vectorization_details.forEach((function(e){const t=document.createElement("li");t.innerHTML=e,d.appendChild(t)})),d=qs("#optimization_details",e);null!=d.firstChild;)d.removeChild(d.firstChild);d.Visible(n.optimization_details.length>0),n.optimization_details.forEach((function(e){const t=document.createElement("li");t.innerHTML=e,d.appendChild(t)}))}},r=(0,i(98822).A)(s,o,[function(){var e=this._self._c;return e("div",[this._v("Compiler: "),e("span",{attrs:{id:"compiler_name"}})])},function(){var e=this._self._c;return e("div",[this._v("Version: "),e("span",{attrs:{id:"compiler_ver"}})])},function(){var e=this._self._c;return e("div",[this._v("Compiler estimated gain: "),e("span",{attrs:{id:"estimated_gain"}})])},function(){var e=this,t=e._self._c;return t("div",{attrs:{"data-tooltip":"Total report messages"}},[e._v("Vectorization/Optimization report by Compiler:\n        "),t("span",{attrs:{id:"total_optimizations","data-tooltip":"Total report messages"}}),e._v(" messages\n      ")])},function(){var e=this._self._c;return e("section",{attrs:{id:"multiversioned"}},[e("div",[this._v("Loop multiversioned for "),e("span")])])}],!1,null,null,null).exports},51069:(e,t,i)=>{"use strict";i.d(t,{A:()=>n});var o=i(18977);const n={created(){o.A.snapshot.buttonSnapshotClick((e=>{this.makeSnapshot()}))}}},51382:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("header",{class:!e.showTabs&&e.activeTab.animation},[e.collapsed?t("div",{staticClass:"title"},[t("header-tab",{attrs:{caption:e.activeTab.caption,view:e.view,showTab:!1,collapsed:e.collapsed}})],1):t("div",{staticClass:"title"},[e._l(e.visibleTabs,(function(i){return t("header-tab",{key:i.slotIndex,attrs:{view:e.view,animation:i.animation,caption:i.caption,slotIndex:i.slotIndex,tabState:i.tabState,showTab:e.showTabs},on:{captured:e.onCaptured,released:e.onReleased,dragged:e.onDragged}})})),e._v(" "),e.showTabs?t("header-tab",{attrs:{view:e.view,showTab:!1},on:{captured:e.onCaptured,released:e.onReleased,dragged:e.onDragged}}):e._e()],2),e._v(" "),t("div",{staticClass:"actions"},[e.isSearch?t("button",{on:{click:function(t){return t.preventDefault(),e.onSearch.apply(null,arguments)}}},[t("i",{staticClass:"icon magnifier light"})]):e._e(),e._v(" "),e.isOptions?t("button",{on:{click:function(t){return t.preventDefault(),e.onOptions.apply(null,arguments)}}},[t("i",{staticClass:"icon gear light"})]):e._e(),e._v(" "),e.canCollapse?t("button",{on:{click:function(t){return t.preventDefault(),e.onCollapse.apply(null,arguments)}}},[t("i",{class:e.collapseIcon})]):e._e(),e._v(" "),e.isCrossButton?t("button",{on:{click:function(t){return t.preventDefault(),e.onClose.apply(null,arguments)}}},[t("i",{staticClass:"icon cross light"})]):e._e()]),e._v(" "),e.isSearchVisible?t("div",{staticClass:"popup"},[t("i",{staticClass:"icon magnifier"}),e._v(" "),e._t("search"),e._v(" "),t("div",{staticClass:"close-button",on:{click:function(t){e.isSearchVisible=!1}}},[t("i",{staticClass:"icon cross"})])],2):e._e(),e._v(" "),e.isOptionsVisible?t("div",{staticClass:"popup"},[t("i",{staticClass:"icon gear"}),e._v(" "),e._t("options"),e._v(" "),t("div",{staticClass:"close-button",on:{click:function(t){e.isOptionsVisible=!1}}},[t("i",{staticClass:"icon cross"})])],2):e._e()])};o._withStripped=!0;var n=i(98137);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"63f13c48",null).exports},51730:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("nav",[t("img",{staticClass:"logo",attrs:{src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAAsTAAA\n       LEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAIxSURBVHgB7VZLSBtRFD0p/WmpHVA3tWDoIrHQp\n       rqoi5YGFy7aTX+7lra6c6GQbASFgLoRwYUGdO0Ht2qWgopu3PhB0YXRhSSiblSICvGDGt+dyczLTJKZh4pBmANh3n1\n       vJve8c+77OFD2J4Ec4gFyDJuATcAmkHMCD4XflIp4+zgOnMYtP3G+5N9EdvZwMwJ/G4EXhUr7hCXvabIkMTUYgLOkW\n       CFT7UN0O52EmAWejzw54Wk+UFmN24AYAe/39L73n3AbsLag1M1nH9tns89TFKA+GouuQXqeD9//r/DXfJHbsaM4QhP\n       zkAqeWf69NQGSX8XsuJLc+02JP7NntBOLo+2a1wQiUfvTCxGYW0Cz9KRIvb4EzE3wmCngD/h0yadnVxGanIcozBVQZ\n       0pYngEOklXMZJflJ7jLtVfaeofR2jMit6sq32BqIIDrEyCpS8t47KoA6pMx1UES/RuXaPEkID12MN8XtH5SIrK9q1M\n       nE7Jb4CpPX3pSofKjdhKxswSC4XO5LRXwfmdJkWVyQnYFUpceVb8R6mpg6A5fMBUeoa+9DsHBMcQO42hp+AURZCbgr\n       tDvekOd3H+NAEte3yE/SYXQ1gV+vCpGV/M/mOL1W12Y2YIPKbvc+mJ6cpXY5poWBlfPdcNUA7QfWMGR8VYsevA8YSr\n       kcd+rXIrnZMFSOCrXgYqIeg4YFHDc+bXcQED8NBRO8M7QYT4/+0Z0j65k2WAoKmysmI//9utC24KcE7gCVneVDG/9P\n       t8AAAAASUVORK5CYII="},on:{click:function(t){return e.onLogoClick()}}}),e._v(" "),e._l(e.visibleButtons,(function(i){return t("vertical-toolbar-button",{key:i.id,attrs:{selected:e.activeButtonId===i.id,disabled:!i.active,marked:i.marked,pressed:i.pressed,icon:i.icon,title:i.title,tooltip:i.tooltip},on:{click:function(t){return e.onButtonClick(i.id)}}})}))],2)};o._withStripped=!0;var n=i(75337),s=i(84733);const r={computed:{...(0,n.mapGetters)("toolbar",["visibleButtons"]),...(0,n.mapState)({activeButtonId:e=>e.toolbar.activeButtonId})},methods:{onLogoClick(){},onButtonClick(e){this.$store.direct.dispatch.toolbar.setActiveButtonId({id:e})}},components:{VerticalToolbarButton:s.default}},a=(0,i(98822).A)(r,o,[],!1,null,"14d73458",null).exports},51749:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(49128),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},51941:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"details"},[t("table",[t("tr",[t("th",[t("b",[e._v(e._s(e.$t("instruction-mix-details-instruction")))]),e._v(" "),t("i",{class:e.getFilterClass("instruction"),on:{click:function(t){return e.onFilterClick("instruction")}}})]),e._v(" "),e.showDataType?t("th",[t("b",[e._v(e._s(e.$t("instruction-mix-details-data-type")))]),e._v(" "),t("i",{class:e.getFilterClass("dataType"),on:{click:function(t){return e.onFilterClick("dataType")}}})]):e._e(),e._v(" "),t("th",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("instruction-mix-details-giga-instructions"),expression:"$t('instruction-mix-details-giga-instructions')"}]},[t("b",[e._v(e._s(e.$t("instruction-mix-details-count")))])])]),e._v(" "),e._l(e.rowsFiltered,(function(i){return t("tr",{key:i.key,class:i.isDominating?"dominating":""},[t("td",[e._v(e._s(i.instruction))]),e._v(" "),e.showDataType?t("td",[e._v("\n        "+e._s(i.dataType.title)+"\n        "),i.isDominating?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("instruction-mix-details-dominating-type"),expression:"$t('instruction-mix-details-dominating-type')"}],staticClass:"icon help-circle"}):e._e()]):e._e(),e._v(" "),t("td",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("instruction-mix-details-giga-instructions"),expression:"$t('instruction-mix-details-giga-instructions')"}]},[e._v("\n        "+e._s(e.formatNumber(i.instructionCount))+"\n      ")])])}))],2),e._v(" "),e.totalFiltered?t("div",{staticClass:"total"},[t("span",[e._v(e._s(e.$t("instruction-mix-details-total-filtered"))+":")]),e._v(" "),t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("instruction-mix-details-giga-instructions"),expression:"$t('instruction-mix-details-giga-instructions')"}]},[e._v(e._s(e.totalFiltered))])]):e._e(),e._v(" "),e.editedFilter?t("instruction-mix-details-filter",e._b({on:{updated:e.onFilterUpdated,applied:e.onFilterApplied,closed:e.onFilterClosed}},"instruction-mix-details-filter",e.editedFilter,!1)):e._e(),e._v(" "),e.editedFilter?t("div",{staticClass:"outside",on:{click:e.onFilterClosed}}):e._e()],1)};o._withStripped=!0;var n=i(36470);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"7664cbe3",null).exports},52074:e=>{e.exports=' <h4>Use Parallel STL alternative to std::for_each</h4> <div class="text"> <p class="promo"> The <code class="hljs-title">std::for_each</code> algorithm runs sequentially. <span id="execution_polices">To run in parallel, use the Parallel STL alternative <span id="several_polices_text">with one of the following execution polices:</span> <span id="one_policy_text">with the following execution policy:</span> %polices% </span> </p> <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\nstd::for_each(std::execution::%policy%, a, a+n, [](float elem)\n...</code></pre> <pre class="expansion"><code class="cpp">#include "pstl/execution"\n#include "pstl/algorithm"\nvoid foo(float* a, int n)\n{\n   std::for_each(std::execution::%policy%, a, a+n, [](float elem)\n   {\n       ...\n   });\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/guide/get-started-with-parallel-stl.html">Getting Started with Parallel STL</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},52141:e=>{e.exports=' <h4>Enable non-temporal store</h4> <div class="text"> <p> Enable non-temporal store using <samp class="codeph">#pragma vector nontemporal</samp>. The nontemporal clause instructs the compiler to use non-temporal (that is, streaming) stores on systems based on all supported architectures, unless specified otherwise; optionally takes a comma-separated list of variables. </p><p> When this pragma is specified, it is your responsibility to also insert any fences as required to ensure correct memory ordering within a thread or across threads. One typical way to do this is to insert a _mm_sfence intrinsic call just after the loops (such as the initialization loop) where the compiler may insert streaming store instructions. </p><p> Streaming stores may cause significant performance improvements over non-streaming stores for large numbers on certain processors. However, the misuse of streaming stores can significantly degrade performance. </p> <div class="promo"> <p class="expander">Example</p> <pre class="essential"><code class="cpp">float a[1000];\n...\nint i;\n#pragma vector nontemporal\nfor (i = 0; i &lt; N; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">float a[1000];\nvoid foo(int N)\n{\n  int i;\n  #pragma vector nontemporal\n  for (i = 0; i &lt; N; i++)\n  {\n    a[i] = 1;\n  }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-2B528C72-29B4-4DBC-8B91-EE4D1A03A850.html">vector</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},52863:e=>{e.exports=' <h4>Change the floating point model</h4> <div class="text"> <div class="promo"> Your application calls serialized versions of math functions when you use the <samp class="codeph">strict</samp> floating point model. To fix: Do one of the following: <ul> <li> Use the <samp class="codeph">fast</samp> floating point model to enable more aggressive optimizations or the <samp class="codeph">precise</samp> floating point model to disable optimizations that are not value-safe on fast transcendental functions. <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /fp:fast </td> <td> -fp-model fast </td> </tr> <tr> <td> /fp:precise /Qfast-transcendentals </td> <td> -fp-model precise -fast-transcendentals </td> </tr> </tbody> </table> <p> CAUTION: This may reduce floating point accuracy. </p> </li> <li> Use the <samp class="codeph">precise</samp> floating point model and enforce vectorization of the <span data-glossary-id="source_loop">source loop</span> using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">!$OMP SIMD</samp> </li> </ul> <p class="expander">Example</p> <div class="essential"> <pre><code class="bash">gfortran program.for -O2 -fopenmp -fp-model precise -fast-transcendentals</code></pre> <pre><code class="fortran">!DIR$ OMP SIMD COLLAPSE(2)\ndo i = 1, N\n...</code></pre> </div> <div class="expansion"> <pre><code class="bash">gfortran program.for -O2 -fopenmp -fp-model precise -fast-transcendentals</code></pre> <pre><code class="fortran">!DIR$ OMP SIMD COLLAPSE(2)\ndo i = 1, N\n    a(i) = b(i) * c(i)\n    do j = 1, N\n        d(j) = e(j) * f(j)\n    enddo\nenddo</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-0A4F4F35-1495-4154-8AD5-238E8C68CE9B.html">fast-transcendentals, Qfast-transcendentals</a>; <a href="docs:Fortran/17/index.htm#GUID-63514789-6BE7-4FA8-9389-F3B618A2EE1A.html">fp-model, fp</a>; <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},53102:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){return this._self._c,this._m(0)};o._withStripped=!0,i(69212),i(45361);const n={loopTime:{total:"25.235s",self:"3.14s",body:12,peel:12,remainder:1,perIteration:"0.5s"},loopISA:{value:"AVX, AVX2"},loopType:{type:"vectorized",displayName:"Vectorized + Threaded (OpenMP)"},loopName:"main",sourceInfo:"main.cpp:26"},s={computed:{compact(){return this.$parent.compact}},mounted(){const{$el:e}=this;let t="";const i=n.sourceInfo;t=n.loopType.type.indexOf("function")<0?"Loop in "+n.loopName:n.loopName+" function",0!==i.length&&(t+=" at "+i),qs("#source_info",e).innerHTML=t.replace(/</g,"&lt;").replace(/>/g,"&gt;"),qs("#loop_type",e).innerHTML=n.loopType.displayName,qs("#loop_type_img",e).src="images/"+{scalar:"cycle-48x48.png",vectorized:"cycle-vect-48x48.png",inside_vectorized:"cycle-inside-vect-48x48.png",not_executed:"cycle-fake-48x48.png",scalar_function:"function-48x48.png",vectorized_function:"function-vect-48x48.png",inlined_function:"function-inlined-48x48.png"}[n.loopType.type],qs("#total_time",e).innerHTML=n.loopTime.total,qs("#self_time",e).innerHTML=n.loopTime.self,qs("#loop_isa",e).Visible(void 0!==n.loopISA),qs("#loop_isa_descr",e).Visible(void 0!==n.loopISA),void 0!==n.loopISA&&(qs("#loop_isa",e).innerHTML=n.loopISA.value),qs("#per_iteration",e).innerHTML=n.loopTime.perIteration||"n/a",qs("#per_instance",e).innerHTML=n.loopTime.perInstance||"n/a",qsa(".after_tripcounts",e).forEach((e=>e.Visible(n.loopTime.perIteration||n.loopTime.perInstance)))}},r=(0,i(98822).A)(s,o,[function(){var e=this,t=e._self._c;return t("div",{attrs:{id:"loop_summary"}},[t("div",{staticClass:"content"},[t("div",{attrs:{id:"source_info"}}),e._v(" "),t("table",[t("tr",{attrs:{valign:"bottom"}},[t("td",{attrs:{align:"right"}},[t("img",{attrs:{id:"loop_type_img",src:"images/cycle-fake-48x48.png",width:"48",height:"48"}}),e._v(" "),t("div",{attrs:{id:"loop_type",name:"name"}})]),e._v(" "),t("td",{attrs:{align:"left"}},[t("div",{attrs:{id:"total_time"}}),e._v(" "),t("div",{attrs:{name:"name"}},[e._v("Total time")])])]),e._v(" "),t("tr",{attrs:{valign:"top"}},[t("td",{attrs:{align:"right"}},[t("div",{attrs:{id:"loop_isa"}}),e._v(" "),t("div",{attrs:{id:"loop_isa_descr",name:"name"}},[e._v("Instruction Set")])]),e._v(" "),t("td",{attrs:{align:"left"}},[t("div",{attrs:{id:"self_time"}}),e._v(" "),t("div",{attrs:{name:"name"}},[e._v("Self time")])])]),e._v(" "),t("tr",[t("td",{attrs:{align:"center",colspan:"2"}},[t("div",{staticClass:"idvc2_text_hierarchy",attrs:{id:"instr_mix_details_text"}})])]),e._v(" "),t("tr",{staticClass:"after_tripcounts",attrs:{valign:"bottom"}},[t("td",{attrs:{align:"center",colspan:"2"}},[t("div",{attrs:{name:"name"}},[e._v("CPU Total Time")])])]),e._v(" "),t("tr",{staticClass:"after_tripcounts",attrs:{valign:"top"}},[t("td",{attrs:{align:"right"}},[t("div",{attrs:{id:"per_iteration"}}),e._v(" "),t("div",{attrs:{name:"name"}},[e._v("Per Iteration")])]),e._v(" "),t("td",{attrs:{align:"left"}},[t("div",{attrs:{id:"per_instance"}}),e._v(" "),t("div",{attrs:{name:"name"}},[e._v("Per Instance")])])])])])])}],!1,null,null,null).exports},53188:e=>{e.exports=' <h4>Split loop into smaller loops</h4> <div class="text"> <div class="promo"> Possible register <span data-glossary-id="spilling">spilling</span> along with high vector <span data-glossary-id="register_pressure">register pressure</span> is preventing effective vectorization. To fix: Use the <span data-glossary-id="directive">directive</span> <samp class="codeph">#pragma distribute_point</samp> or rewrite your code to distribute the <span data-glossary-id="source_loop">source loop</span>. This can decrease register pressure as well as enable software pipelining and improve both instruction and data cache use. <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\nfor (i=0; i&lt; NUM; i++)\n{\n    ...\n    c[i] = c[i] +i;\n    #pragma distribute_point\n    x[i] = x[i] +i;\n    ...\n}\n...</code></pre> <pre class="expansion"><code class="cpp">#define NUM 1024\nvoid loop_distribution_pragma2(\n       double a[NUM], double b[NUM], double c[NUM],\n       double x[NUM], double y[NUM], double z[NUM] )\n{\n    int i;\n    // After distribution or splitting the loop.\n    for (i=0; i&lt; NUM; i++)\n    {\n        a[i] = a[i] +i;\n        b[i] = b[i] +i;\n        c[i] = c[i] +i;\n        #pragma distribute_point\n        x[i] = x[i] +i;\n        y[i] = y[i] +i;\n        z[i] = z[i] +i;\n    }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li><a href="docs:C++/17/index.htm#GUID-03B94EAB-70E2-4B45-B275-D73FD76961A0.html">distribute_point</a></li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/3d-isotropic-acoustic-finite-difference-wave-equation-code-a-many-core-processor.html">3D Finite Differences on Multi-core Processors</a>, <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a>, and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},53271:e=>{e.exports=' <h4>Explicitly enable FMA generation when using the strict floating-point model</h4> <div class="text"> <p class="promo"> Static analysis presumes the loop may benefit from <a href="https://www.intel.com/content/www/us/en/docs/advisor/user-guide/current/glossary.html">FMA</a> instructions available with the AVX2 ISA, but the <samp class="codeph">strict</samp> floating-point model disables FMA instruction generation by default. To fix: Override this behavior using the <samp class="codeph">fma</samp> compiler option. </p> <table cellpadding="4" border="1" cellspacing="0"> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /Qfma </td> <td> -fma </td> </tr> </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li><a href="docs:Fortran/17/index.htm#GUID-969A5F48-C013-4313-B513-77ED872541C8.html">fma, Qfma</a></li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/floating-point-operations.html">Floating-Point Operations</a> and <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/overview.html">Intel&reg; Fortran Compiler Developer Guide and Reference</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},53386:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(40187)),s={props:{title:String,tooltip:String,valueTooltip:String,formattedValue:String,percentValue:String,values:{type:Array,required:!0},colors:{type:Array,required:!0},valueMin:{type:Number,default:0},valueMax:{type:Number,default:1},minWidth:{type:String,default:"0"},compact:Boolean,clickable:Boolean},components:{SimpleBarChart:n.default},methods:{onTitleClick(){this.clickable&&this.$emit("click")}}};t.default=s},53497:(e,t,i)=>{"use strict";i(69212),i(43468),i(38333);const o=i(62067),n=i(38235),s=i(77106),r={isCollectionRunning:e=>t=>!!e.collectionRunning[t],isCollectionFinalizing:e=>t=>e.switchViewChangeReason[t]===o.VisualisationChange.vcFinalizationStarted,getEventLog:e=>t=>e.eventLog[t]||[],getEventLogMessageCount:e=>t=>e.eventLogMessageCount[t]||0,getEventById:(e,t)=>(e,i)=>t.getEventLog(e).find((e=>e.id===i)),getEventsByType:(e,t)=>(e,i)=>t.getEventLog(e).filter((e=>e.eventType===i)),getVisibleRecommendations:(e,t)=>(e,i)=>t.getEventsByType(e,n.EVENT_TYPE_RECOMMENDATION).filter((e=>{const{hidden:t,optionCaption:o,optionState:n}=e;return!(t||o===i&&!0===n)})),getEventsCount:(e,t)=>e=>t.getEventsByType(e,n.EVENT_TYPE_EVENT).length,getRecommendationsCount:(e,t)=>e=>t.getEventsByType(e,n.EVENT_TYPE_RECOMMENDATION).length,hasMessageCount:(e,t)=>e=>t.getEventLogMessageCount(e)>0,hasEvents:(e,t)=>e=>t.getEventsCount(e)>0,hasRecommendations:(e,t)=>e=>t.getRecommendationsCount(e)>0,getCollectorOutput:e=>t=>e.collectorOutput[t]||[],hasCollectorOutput:(e,t)=>e=>t.isCollectorOutputVisible&&(0,s.getOutputLength)(t.getCollectorOutput(e))>0,getApplicationOutput:e=>t=>e.applicationOutput[t]||[],hasApplicationOutput:(e,t)=>e=>t.isAppOutputVisible&&(0,s.getOutputLength)(t.getApplicationOutput(e))>0,getApplicationOutputLength:e=>t=>e.applicationOutputLength[t]||0,getTopSliderHeight:e=>e.topSlider.height,getOutputHeight:e=>e.topSlider.outputHeight,getEventLogContentHeight:e=>e.topSlider.eventLogContentHeight,getRecommendationsContainerHeight:e=>e.topSlider.recommendationsContainerHeight,getTopSliderCondition:e=>e.topSlider.condition,getTopSliderPrevCondition:e=>e.topSlider.prevCondition,isTopSliderVisible:(e,t)=>t.isEventLogVisible||t.isRecommendationsVisibleInTopSlider,isTopSliderOverlapsView:(e,t)=>t.isTopSliderVisible&&t.isTopSliderMaximized,isTopSliderCollapsed:(e,t)=>t.getTopSliderCondition===n.CONDITION_COLLAPSED,isTopSliderMaximized:(e,t)=>t.getTopSliderCondition===n.CONDITION_MAXIMIZED,isRecommendationsPinned:e=>e.topSlider.isRecommendationsPinned,isRecommendationsVisible:e=>e.topSlider.isRecommendationsVisible,isRecommendationsVisibleInTopSlider:(e,t)=>t.isRecommendationsVisible&&!t.isRecommendationsPinned,isRecommendationsVisibleInView:(e,t)=>t.isRecommendationsVisible&&t.isRecommendationsPinned,isEventLogVisible:e=>e.topSlider.isEventLogVisible,isAppOutputVisible:e=>e.topSlider.isAppOutputVisible,isCollectorOutputVisible:e=>e.topSlider.isCollectorOutputVisible,isAutoShowRecommendations:e=>e.topSlider.isAutoShowRecommendations};t.A=r},54043:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>c});var o=function(){var e=this,t=e._self._c;return t("section",{staticClass:"slider"},[t("div",{staticClass:"title"},[t("label",{attrs:{for:"inputId"}},[e._v(e._s(e.label)),e.tooltip?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.tooltip,expression:"tooltip"}],staticClass:"icon help-circle light"}):e._e()]),e._v(" "),e._t("default")],2),e._v(" "),e.available?t("input",{ref:"inputRef",style:e.inputStyle,attrs:{id:"inputId",type:"range",list:"data",min:e.scale.min,max:e.scale.max,step:"any"},domProps:{value:e.scale.position(e.value)},on:{input:e.onInput}}):e._e(),e._v(" "),e.available?t("datalist",{attrs:{id:"data"}},e._l(e.values,(function(e){return t("option",{key:e,attrs:{label:"|"},domProps:{value:e}})})),0):e._e(),e._v(" "),e.available?t("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.refValueTooltip,expression:"refValueTooltip"}],ref:"valueRef",staticClass:"refValue"},[e.refValue?t("div",{style:e.refValueStyle,on:{click:e.refValueClick}},[e._v("▲")]):e._e()]):e._e()])};o._withStripped=!0;var n=i(57143),s=i(77106),r=i(61262),a=i(85038);const l={props:{label:String,tooltip:String,min:[Number,String],max:[Number,String],logScale:{type:Boolean,default:!1},value:[Number,String],initialValue:{type:[Number,String],default(){return this.value}},refValue:Number,refValueTooltip:String,edges:{type:Array,default:e=>[!1,!1],validator:e=>2===e.length},updateTicks:{type:Boolean,default:!1}},data(){return{resizeObserver:new n.default((e=>{this.$el instanceof HTMLElement&&this.$refs.valueRef&&(this.inputWidth=parseFloat(getComputedStyle(this.$refs.valueRef).width),this.updateTicks&&(this.totalTicks=Math.trunc(this.inputWidth/24)))})),inputWidth:0,totalTicks:10}},computed:{values(){const{min:e,max:t,totalTicks:i}=this;return(0,s.createUniformMesh)(e,t,i)},available(){return(0,s.valid)(this.min)&&(0,s.valid)(this.max)},refValueStyle(){const{refValue:e,scale:t}=this;return{left:`calc(${t.size(e)}% - 1rem/2)`}},inputStyle(){const{scale:e,value:t,initialValue:i,inputWidth:o}=this;let n=e.size(Math.min(i,t)),s=e.size(Math.max(i,t));if(o>0){const e=r.default.em2px(1);n=(o*n/100+e/2)/(o+e)*100,s=(o*s/100+e/2)/(o+e)*100}return{backgroundImage:`\n          linear-gradient(90deg,\n            ${a.dark.L6}                  0%,\n            ${a.dark.L6}            ${n}%,\n            ${a.intel.accent.blue}  ${n}%,\n            ${a.intel.accent.blue} ${s}%,\n            ${a.light.L2}          ${s}%,\n            ${a.light.L2}               100%\n          )`}},scale(){const{min:e,max:t}=this;return this.logScale?(0,s.logScale)({addPoint:s.logScale.fromEdges(this.edges),minval:e,maxval:t}):(0,s.linearScale)({min:e,max:t})}},methods:{onInput(e){this.$emit("change",this.scale.value(parseFloat(e.target.value)))},refValueClick(){var e;this.$emit("change",this.refValue),null===(e=this.$refs)||void 0===e||e.inputRef.focus()}},mounted(){if(this.resizeObserver.observe(this.$el),this.updateTicks){const e=parseFloat(getComputedStyle(this.$el).width);this.totalTicks=Math.trunc(e/24)}},beforeDestroy(){this.resizeObserver.disconnect()}},c=(0,i(98822).A)(l,o,[],!1,null,"351510f1",null).exports},54149:e=>{e.exports=' <h4>Consider outer loop vectorization</h4> <div class="text"> <div class="promo"> The compiler did not vectorize the inner loop due to potential dependencies detected. You might vectorize outer loop if it has no dependency. Use a <span data-glossary-id="directive">directive</span> right before your loop block in the source code. </div> <table> <tr> <th> <span data-glossary-id="IFORT">IFORT</span> Directive </th> </tr> <tr> <td> !$OMP SIMD </td> </tr> </table> <p id="disclaimer"> Given issue is only about opportunity to vectorize outer loop, to prove profitability you need perform deeper dive analysis (MAP, Trip Counts, Dependencies) </p> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/outer-loop-vectorization.html">Outer Loop Vectorization</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},54262:(e,t,i)=>{"use strict";i(69212),i(43468),i(21602),i(60426);const o=i(77106),n=i(38235),s={hidden:!1,title:"",text:"",imageType:-1,animation:void 0,textItems:[],optionState:!1,optionCaption:"",buttons:[],min:0,max:100,val:0},r={processEvent({dispatch:e},{eventName:t,message:i}){const{to:o,type:n,data:s}=i;"eventLog"===o?e("updateEventLog",{eventName:t,eventType:n,data:s}):"output"===o&&e("updateOutput",{eventName:t,eventType:n,data:s})},updateEventLog({commit:e,getters:t},{eventName:i,eventType:n,data:r}){const a=t.getEventLog(i),{messageBoxId:l,messageBoxType:c="messageBoxEx",data:d}=r;if(-1==l)e("setEventLog",{eventName:i,data:[]});else if(a.some((e=>e.id===l))){let t;t=d?a.map((e=>e.id===l?(0,o.mergeLogItem)(e,d):e)):a.filter((e=>e.id!==l)),e("setEventLog",{eventName:i,data:t})}else{const o={...s,...d,id:l,type:c,eventType:n},r=t.getEventLogMessageCount(i)+1;e("setEventLog",{eventName:i,data:[...a,o]}),e("setEventLogMessageCount",{eventName:i,count:r})}},updateOutput({commit:e,getters:t},{eventName:i,data:n}){if(Array.isArray(n))if(n.length>0){const s=n.filter((e=>(0,o.hasAppOutput)(e.severity))),r=n.filter((e=>!(0,o.hasAppOutput)(e.severity)));if(r.length){const o=t.getCollectorOutput(i);Array.isArray(o)&&e("setCollectorOutput",{eventName:i,data:[...o,...r]})}if(s.length){const o=t.getApplicationOutput(i);Array.isArray(o)&&(e("setApplicationOutput",{eventName:i,data:[...o,...s]}),e("setApplicationOutputLength",{eventName:i,length:t.getApplicationOutputLength(i)+s.length}))}}else e("setCollectorOutput",{eventName:i,data:[]}),e("setApplicationOutput",{eventName:i,data:[]}),e("setApplicationOutputLength",{eventName:i,length:0});else"collection"===n.name?e("setCollectorOutput",{eventName:i,data:n}):e("setApplicationOutput",{eventName:i,data:n})},setEventField({commit:e,getters:t},{eventName:i,id:o,field:n,value:s}){const r=t.getEventById(i,o);r&&e("setEventField",{event:r,field:n,value:s})},setTopSliderHeight({commit:e},t){e("setTopSliderHeight",t)},setOutputHeight({commit:e},t){e("setOutputHeight",t)},setEventLogContentHeight({commit:e},t){e("setEventLogContentHeight",t)},setRecommendationsContainerHeight({commit:e},t){e("setRecommendationsContainerHeight",t)},setTopSliderCondition({commit:e,getters:t},i){e("setTopSliderPrevCondition",t.getTopSliderCondition),e("setTopSliderCondition",i)},expandTopSlider({dispatch:e,getters:t}){const i=t.getTopSliderCondition;e("setTopSliderCondition",i===n.CONDITION_COLLAPSED?t.getTopSliderPrevCondition:i)},toggleRecommendationsPinned({commit:e,dispatch:t,getters:i},o){const n=void 0!==o?o:!i.isRecommendationsPinned;n||(t("setTopSliderCondition",i.getTopSliderPrevCondition),i.isEventLogVisible||t("setTopSliderHeight",void 0)),e("setRecommendationsPinned",n)},toggleRecommendationsVisible({commit:e,dispatch:t,getters:i},o){const s=void 0!==o?o:!i.isRecommendationsVisible;s&&(t("expandTopSlider"),i.isEventLogVisible||t("setTopSliderCondition",n.CONDITION_EXPANDED)),t("setTopSliderHeight",void 0),e("setRecommendationsVisible",s)},toggleEventLogVisible({commit:e,dispatch:t,getters:i},o){const s=void 0!==o?o:!i.isEventLogVisible;s&&t("expandTopSlider"),i.isRecommendationsVisible&&(t("setTopSliderHeight",void 0),s||t("setTopSliderCondition",n.CONDITION_EXPANDED)),e("setEventLogVisible",s)},toggleAppOutputVisible({commit:e,getters:t},i){e("setAppOutputVisible",void 0!==i?i:!t.isAppOutputVisible)},toggleCollectorOutputVisible({commit:e,getters:t},i){e("setCollectorOutputVisible",void 0!==i?i:!t.isCollectorOutputVisible)}};t.A=r},54277:function(e,t,i){"use strict";i(69212),i(43468),i(38333),i(21602),i(60426);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(83230)),s=i(38235),r=i(75337),a=i(57721),l={props:{source:Object,selection:Object},data:()=>({sources:[],view:"offload:source",eventName:s.OFFLOAD_LOG,sourceSelectionId:"offload/accelerated-regions/selection",sourceRequestId:"offload/accelerated-regions/source"}),computed:{...(0,r.mapGetters)("log",["isCollectionFinalizing","isRecommendationsVisibleInView","isTopSliderOverlapsView"]),tabs(){return this.$store.direct.getters.layout.getAllTabs(this.view)},isDisabled(){return this.isCollectionFinalizing(this.eventName)}},async activated(){let{source:e,selection:t}=this;if(t||(t=this.$store.direct.getters.getSelection(this.sourceSelectionId)),t&&!e){let{rowId:i}=t;i=(0,a.getCurrentRowId)(i),e=await n.default.get(this.sourceRequestId,"update-source",{rowId:i})}if(!e||!t)return;const i=this.sources.find((t=>t.source.file===e.file));if(i){const e=this.$store.direct.getters.layout.getTabByName(this.view,i.name);this.$store.direct.dispatch.setSelection({id:i.selectionId,selection:t}),this.$store.direct.dispatch.layout.setActiveTab({view:this.view,slotIndex:e.slotIndex})}else{const i=Math.max(...this.sources.map((e=>e.id))),o=i>=0?i+1:0,s=o.toString(),r=`${this.sourceSelectionId}-${o}`;await n.default.offload.openSource(s);const a=[{caption:this.$t("edit_source"),noReport:!0,disabled:"found"!==e.state,command:()=>this.drillDownNativeSource(e)}];this.sources=[...this.sources,{id:o,name:s,caption:this.getSourceCaption(e),requestId:`offload/source-${o}`,selectionId:r,contextMenu:a,source:e}],this.$store.direct.dispatch.setSelection({id:r,selection:t})}},methods:{drillDownNativeSource(e){n.default.send("openNativeSource",e)},getSourceCaption(e){const{file:t,name:i}=e;return i?t?`&nbsp;<span title="${t}">${i}</span>`:"":this.$t("source-view-source")}},watch:{async tabs(e){const t=this.sources.filter((t=>e.some((e=>e.name===t.name)))),i=this.sources.filter((t=>!e.some((e=>e.name===t.name))));for(const e of i)this.$store.direct.dispatch.deleteSelection(e.selectionId),await n.default.offload.closeSource(e.name);this.sources=t}}};t.default=l},54284:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return t("layout-panel-group",{staticClass:"metrics"},e._l(e.data,(function(e){return t("metric-item-box",{key:e.id,attrs:{metric:e,"no-border":""}})})),1)},n=[];o._withStripped=!0},54420:e=>{e.exports=' <h4>Implement a tiling technique in GRF and share data between work items in a subgroup</h4> <div class="text"> <div class="promo"> %dpcpp_disclaimer% To improve data locality, divide a big dataset to small tiles or arrays of elements. Load it to the <span data-glossary-id="GRF">GRF</span>, for example, as a private array, and reuse this array many times, while it remains in the <span data-glossary-id="GRF">GRF</span>. To find the best tiling parameter, consider how much <span data-glossary-id="GRF">GRF</span> space is available.<br><br> </div> Your current <span data-glossary-id="SIMD_gpu">SIMD</span> width is %gpu_current_row_simd_width%. The maximum available <span data-glossary-id="GRF">GRF</span> space per work item is a ratio of <span data-glossary-id="GRF">GRF</span> size to <span data-glossary-id="SIMD_gpu">SIMD</span> width (4KB / %gpu_current_row_simd_width%). For the current GPU kernel, the available <span data-glossary-id="GRF">GRF</span> space is %available_grf_space_bytes% bytes per work item. Adjust your algorithm to operate with a small range of elements. The total amount of data should be less than %available_grf_space_bytes% bytes. <br> <b>Note: </b> <span id="kernel_args"> This amount of data is an upper limit per work item and is reduced to %kernel_arg_size% bytes, which is the size of kernel arguments. </span> <span id="no_kernel_args"> This amount of data is an upper limit per work item. </span> <span data-glossary-id="GRF">GRF</span> space is also used to store private variables and intermediate results of operations. Consider using less space than the upper limit outlined above when choosing a tile size. If the tiling parameter is large and exceeds the free <span data-glossary-id="GRF">GRF</span> space, a private array will be spilled into the private memory, resulting in poor performance. <br> <br> <div class="promo"> To allocate a bigger tile to the same <span data-glossary-id="GRF">GRF</span> space, you can share parts of the big tile between work items in a <span data-glossary-id="subgroup">subgroup</span> using group functions like <samp class="codeph">select_from_group</samp> and <samp class="codeph">group_broadcast</samp>. See <a href="https://www.khronos.org/registry/SYCL/specs/sycl-2020/html/sycl-2020.html#sec:algorithms"> Group algorithms library</a> for details. </div> <b>Note: </b>By default, the compiler selects a <span data-glossary-id="subgroup">subgroup</span> size using device-specific information and heuristics. If you want to define the <span data-glossary-id="subgroup"> subgroup</span> size or a <span data-glossary-id="SIMD_gpu">SIMD</span> width, use <samp class="codeph"> intel::reqd_sub_group_size</samp> for <a href="https://www.intel.com/content/www/us/en/develop/documentation/oneapi-programming-guide/top/oneapi-programming-model/data-parallel-c-dpc.html"> Data Parallel C++ (DPC++)</a> programming model. <br> <div class="promo"> <p class="expander">Example of the matrix transpose algorithm, which loads a sub-matrix, operates on it, and shares data between work items: </p> <pre class="essential"><code class="cpp" data-source="\n...\nh.parallel_for(sycl::nd_range<2>(sycl::range<2>(N / blockSize, N), sycl::range<2>(1, blockSize)),\n    [=](sycl::nd_item<2> it)[[intel::reqd_sub_group_size(subgroupSize)]] {\n...\nsycl::ext::oneapi::sub_group sg = it.get_sub_group();\n...\nfor (int i = 0; i < blockSize; i++) {\n...\ntcol[k] = sycl::select_from_group(sg, bcol[i], k);\n...\n"></code></pre> <pre class="expansion"><code class="cpp" data-source="\n\nconstexpr size_t blockSize = 16;\n// For this example, set subgroup size equal to the block size\nconstexpr size_t subgroupSize = 16;\nsycl::buffer<unsigned int, 2> m(matrix.data(), sycl::range<2>(N, N));\n\nauto e = q.submit([&](auto &h) {\n    sycl::accessor marr(m, h);\n\n    h.parallel_for(\n    sycl::nd_range<2>(sycl::range<2>(N / blockSize, N), sycl::range<2>(1, blockSize)),\n    [=](sycl::nd_item<2> it)[[intel::reqd_sub_group_size(subgroupSize)]] {\n        int gi = it.get_group(0);\n        int gj = it.get_group(1);\n\n        sycl::ext::oneapi::sub_group sg = it.get_sub_group();\n        // Set ID of a work item in a subgroup\n        int sgId = sg.get_local_id()[0];\n\n        unsigned int bcol[blockSize];\n        // Set the beginning of a block (row)\n        int ai = blockSize * gi;\n        // Set the beginning of a block (column)\n        int aj = blockSize * gj;\n\n        for (int k = 0; k < blockSize; k++) {\n            // Block loading for a subgroup\n            bcol[k] = sg.load(marr.get_pointer() + (ai + k) * N + aj);\n        }\n\n        unsigned int tcol[blockSize];\n        for (int i = 0; i < blockSize; i++) {\n            // Shuffle data one by one\n            if (sgId == i) {\n                for (int k = 0; k < blockSize; k++) {\n                    /* Get the bcol[i] of each k-th work item (read row)\n                     * 0 is bcol[0] of 0-th work item, 1 is bcol[0] of 1-th, and so on\n                     * | 0 1 2 |     | 0 ...|\n                     * | 0 ... | ->  | 1 ...|\n                     * | 0 ... |     | 2 ...|\n                     * Store the result in tcol[k] (as column)\n                     * tcol = [ 0, 1, 2 ]\n                     */\n                    tcol[k] = sycl::select_from_group(sg, bcol[i], k);\n                }\n            }\n        }\n\n        for (int k = 0; k < blockSize; k++) {\n          // Block storing for the subgroup\n            sg.store(marr.get_pointer() + (ai + k) * N + aj, tcol[k]);\n        }\n    });\n});"></code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/develop/documentation/oneapi-gpu-optimization-guide/top/kernels/sub-group.html#sub-groups_data-sharing"> oneAPI GPU Optimization Guide</a> </li> </ul> </div> '},54469:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("table-view",{attrs:{columns:e.getColumns(),rows:e.getRows(),"single-line-header":""},scopedSlots:e._u([{key:"source",fn:function({value:i}){return[t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:i,expression:"value"}]},[e._v(e._s(i))])]}},{key:"direction",fn:function({value:i}){return[t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t(i),expression:"$t(value)"}],staticClass:"icon",class:e.getIconName(i)})]}},{key:"reuse",fn:function({value:i}){return[t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.$t("reuse_detected_"+i),expression:"$t('reuse_detected_' + value)"}],staticClass:"icon",class:e.getReuseIconName(i)})]}}])})};o._withStripped=!0;var n=i(95733);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"2f2d01eb",null).exports},54668:e=>{e.exports=' <h4>Reduce the number/size of arrays promoted to the private memory</h4> <div class="text promo"> %dpcpp_disclaimer% Usually, private variables are promoted to <span data-glossary-id="GRF">GRF</span>. If an array is big, a compiler often promotes the variables to the additional region of the private memory. <br><br> <ul> <li><b>Consider explicitly promoting some arrays to the local memory.</b> <p> Arrays promoted to the <span data-glossary-id="SLM">SLM</span> are located in the faster memory (than private memory). Also such arrays can be shared between work items. </p> <p> In the <a href="https://www.intel.com/content/www/us/en/docs/oneapi/programming-guide/current/data-parallelism-in-c-using-sycl.html"> Data Parallel C++ (DPC++) Programming Model</a> you can use a special accessor and barrier for synchronization between work items: </p><p class="expander">Example of a <b>local accessor</b> and a <b>barrier</b> for SLM:</p> <pre class="essential"><code class="cpp">\n​sycl::accessor&lt;int, 1, sycl::access::mode::read_write,\n    ​sycl::access::target::local&gt; accessor(sycl::range(32 * 64), h);\n...\n​it.barrier(sycl::access::fence_space::local_space);\n                </code></pre> <p></p> </li> <br> <li><b>Consider using static indexing.</b> <p> Static indexing means that each access is performed using the index known at the moment of compilation (static constant). The compiler can map statically indexed private arrays to registers. Dynamically indexed private arrays are often promoted to the private memory. </p><p class="expander">Examples of a <b>static/dynamic</b> indexing:</p> <pre class="essential"><code class="cpp">\ndata[0]   = 0; //static indexing\ndata[i++] = 0; //dynamic indexing\n                </code></pre> <p></p> </li> <br> <li><b>Consider reducing array size.</b> <p> The total GRF size is %grf_size% bytes per thread. The current <span data-glossary-id="SIMD_gpu">SIMD</span> width is %gpu_current_row_simd_width%. The available size of GRF per work item calculated as <b>GRF/SIMD width</b> is %grf_per_wi% bytes. </p> <p> Reduce the array size to fit it into the available GRF space per work item. </p> </li> <br> <li><b>Consider applying the Register Sharing technique.</b> <p> The Register Sharing technique allows the work items to load data from registers occupied by other work items using the functions <b>broadcast</b>, <b>shuffle</b>. It means that a big array can be divided and shared between work items in a subgroup so that this array becomes available for all work items in the subgroup. Using the same <span data-glossary-id="GRF">GRF</span> space it is possible to allocate array of bigger size (times <span data-glossary-id="SIMD_gpu">SIMD</span> width). See the <a href="https://www.intel.com/content/www/us/en/docs/oneapi/optimization-guide-gpu/current/registerization-and-avoiding-register-spills.html"> GPU optimization guide</a> for more details. </p><p class="expander">Examples of a register sharing with <b>broadcast</b>:</p> <pre class="essential"><code class="cpp">\nunsigned int histogram[NUM_BINS / 16];\nfor (int k = 0; k &lt; blockSize; k++)\n{\n    unsigned long x = sg.load(macc.get_pointer() + group * gSize * blockSize +\n                        sgGroup * sgSize * blockSize + sgSize * k);\n    for (int j = 0; j &lt; 16; j++) {\n        unsigned long y = broadcast(sg, x, j);\n...\n}\n</code></pre> <p></p> </li> </ul> </div> '},54694:e=>{e.exports=' <h4>STL algorithms present</h4> <div class="essential"> STL algorithms are algorithmically optimized. Improve performance with algorithms that are both algorithmically and programmatically optimized by using Parallel STL. Parallel STL is an implementation of C++ standard library algorithms for the next version of the C++ standard, commonly called C++17, that supports execution policies and is specifically optimized for Intel® processors. Pass one of the following values as the first parameter in an algorithm call to specify the desired execution policy. <table> <thead> <tr> <th> Execution policy </th> <th> Meaning </th> </tr> </thead> <tbody> <tr> <td> seq </td> <td> Execute sequentially. </td> </tr> <tr> <td> unseq </td> <td> Use SIMD. (Requires SIMD-safe functions.) </td> </tr> <tr> <td> par </td> <td> Use multithreading. (Requires thread-safe functions.) </td> </tr> <tr> <td> par_unseq </td> <td> Use SIMD and multithreading. (Requires SIMD-safe and thread-safe functions.) </td> </tr> </tbody> </table> <p>Parallel STL supports SIMD and multithreading execution policies for a <a href="https://www.intel.com/content/www/us/en/developer/articles/guide/get-started-with-parallel-stl.html">subset of algorithms</a> if random access iterators are provided. Execution remains sequential for all other algorithms.</p> </div>'},54759:function(e,t,i){"use strict";i(27468),i(69212),i(21602),i(32204);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=i(77106),s=o(i(85038)),r=i(36750),a={props:{data:{type:Object,required:!0}},data:()=>({itemExpanded:{}}),computed:{items(){const e=Object.entries(this.data).map((([e,t])=>{const{instructions:i}=t;return{id:e,...t,instructionCount:(0,r.aggField)(i,"instructionCount")}})),t=(0,r.aggField)(e,"instructionCount").value;return e.map((e=>{const{id:i,name:o,showDataType:a,instructions:l,instructionCount:c}=e,d=(0,n.formatNumber)(c),p=c.value/t,u=(0,n.formatNumber)({value:100*p,type:"f",digits:0,postfix:"%"}),h={title:o,valueTooltip:this.$t("instruction-mix-details-giga-instructions"),formattedValue:d,percentValue:u,values:[p],colors:[s.default.dark.L8]},m=Object.entries((0,r.groupBy)(l.map((e=>({...e,key:e.dataType.id}))),"key")).reduce(((e,t)=>{const[i,o]=t,n=(0,r.aggField)(o,"instructionCount");return e.value<n.value?{id:+i,value:n.value}:e}),{id:null,value:0}),f=e=>a?`${e.instruction}_${e.dataType.id}`:e.instruction,v=Object.values((0,r.groupBy)(l.map((e=>({...e,key:f(e)}))),"key")).map((e=>{const[{instruction:t,dataType:i}]=e;return{instruction:t,dataType:i,instructionCount:(0,r.aggField)(e,"instructionCount"),isDominating:a&&i.id===m.id}}));return{id:i,header:h,table:v,showDataType:a}}))}},methods:{getCaretIcon(e){return this.itemExpanded[e]?"icon caret-down":"icon caret-right"},onCollapseExpand(e){this.itemExpanded={...this.itemExpanded,[e]:!this.itemExpanded[e]}}}};t.default=a},54995:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"layout-placeholder",class:e.direction})};o._withStripped=!0;var n=i(63047);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"a694f9f6",null).exports},55233:function(e,t,i){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=o(i(39959)).default.observable({opsAndBandwidth:{data:{gpu:{},cpu:{}},isCpuLoading:!1,isGpuLoading:!1},topHotspots:{data:{gpu:{},cpu:{}},isLoading:!1},performanceChar:{data:{gpu:[],cpu:{}},isLoading:!1},platformInformation:{data:{gpu:{},cpu:{}},isLoading:!1},programMetrics:{data:{gpu:[],cpu:{}},isLoading:!1},collectionInformation:{data:{},isLoading:!1}});t.default=n},55489:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(65412),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},55504:e=>{e.exports=' <h4>Disable dynamic alignment</h4> <div class="text"> <div class="promo"> The compiler automatically peeled iterations from the vector loop into a scalar loop to align the vector loop with a particular memory reference; however, this optimization may not be ideal. To possibly achieve better performance, disable automatic <span data-glossary-id="peeled_loop"> peel generation </span> using the directive: <samp class="codeph">#pragma vector nodynamic_align</samp> <p class="expander">Example (original code)</p> <pre class="essential"><code class="cpp">...\n#pragma vector nodynamic_align\nfor (int i = 0; i &lt; len; i++)\n...</code></pre><p></p> <pre class="expansion"><code class="cpp">void f(float * a, float * b, float * c, int len)\n{\n    #pragma vector nodynamic_align\n    for (int i = 0; i &lt; len; i++)\n    {\n        a[i] = b[i] * c[i];\n    }\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-2B528C72-29B4-4DBC-8B91-EE4D1A03A850.html">vector</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/vector-001.html">Dynamic Alignment Clause for Vector Pragma/Directive</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div></div>'},55777:e=>{e.exports=' <h4>Use Parallel STL alternative to std::any_of</h4> <div class="text"> <p class="promo"> The <code class="hljs-title">std::any_of</code> algorithm runs sequentially. <span id="execution_polices">To run in parallel, use the Parallel STL alternative <span id="several_polices_text">with one of the following execution polices:</span> <span id="one_policy_text">with the following execution policy:</span> %polices% </span> </p> <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\nstd::any_of(std::execution::%policy%, a, a+n, [](float elem)\n...</code></pre> <pre class="expansion"><code class="cpp">#include "pstl/execution"\n#include "pstl/algorithm"\nvoid foo(float* a, int n)\n{\n   std::any_of(std::execution::%policy%, a, a+n, [](float elem)\n   {\n       return elem > 100.f;\n   });\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/guide/get-started-with-parallel-stl.html">Getting Started with Parallel STL</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},55926:(e,t,i)=>{function o(e,t){if(!e)return;const i=e.querySelector("#execution_polices");if(!i)return;const o=t.pstl_exec_polices;if(!o||o.length<=0)return void i.Visible(!1);const n=o.length>1;let s="";if(n){s='<ul style="padding-left: 1.5rem; overflow-x:auto;">';for(let e=0,t=o.length;e<t;++e)s+='<li><code class="hljs-title">std::execution::'+o[e]+"</code></li>";s+="</ul>"}else s='<code class="hljs-title">std::execution::'+o[0]+"</code>";i.innerHTML=i.innerHTML.replace(/%polices%/g,s);const r=i.querySelector("#several_polices_text");r&&r.Visible(n);const a=i.querySelector("#one_policy_text");a&&a.Visible(!n);const l=e.querySelectorAll(".cpp");l&&l.forEach((function(e){e.innerHTML=e.innerHTML.replace("%policy%",o[o.length-1])}))}i(69212),i(45361),window.preload_rec_use_parallel_stl_c=function(e){e.params&&e.params.stl_algorithm&&(e.id=e.id.replace(/_c$/,"_"+e.params.stl_algorithm))},window.rec_use_parallel_stl_any_of=o,window.rec_use_parallel_stl_copy_if=o,window.rec_use_parallel_stl_for_each=o,window.rec_use_parallel_stl_sort=o},56409:e=>{e.exports=' <h4>OpenMP function call(s) present</h4> <div class="essential"> OpenMP* function call(s) in the <span data-glossary-id="loop_body">loop body</span> are preventing the compiler from effectively vectorizing the loop. </div>'},56799:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"filters"},[t("div",{staticClass:"header"},[t("i",{staticClass:"icon filter"}),e._v(" "),t("span",[e._v(e._s(e.title))]),e._v(" "),t("i",{staticClass:"icon cross",on:{click:e.onClose}})]),e._v(" "),t("div",{staticClass:"all"},[t("i",{class:e.getAllIcon(),on:{click:e.onSelectAll}}),e._v(" "),t("span",[e._v(e._s(e.$t("instruction-mix-details-filter-all")))])]),e._v(" "),t("div",{staticClass:"items"},e._l(e.items,(function(i){return t("div",{key:i,staticClass:"item"},[t("i",{class:e.getItemIcon(i),on:{click:function(t){return e.onSelect(i)}}}),e._v(" "),t("span",[e._v(e._s(i))])])})),0),e._v(" "),t("div",{staticClass:"buttons"},[t("button",{attrs:{name:"Ok"},on:{click:e.onOk}},[e._v("\n      "+e._s(e.$t("instruction-mix-details-filter-ok"))+"\n    ")]),e._v(" "),t("button",{attrs:{name:"Cancel"},on:{click:e.onClose}},[e._v("\n      "+e._s(e.$t("instruction-mix-details-filter-cancel"))+"\n    ")])])])};o._withStripped=!0;var n=i(81902);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"17e7f9ce",null).exports},56990:e=>{e.exports=' <h4>Enable the use of approximate sqrt instructions</h4> <div class="text"> <div class="promo"> Static analysis presumes the loop may benefit from using approximate sqrt instructions, but the precision and floating-point model settings may prevent the compiler from using these instructions. To fix: Fine-tune your usage of the following compiler option: </div> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> <th> Comment </th> </tr> </thead> <tbody> <td>/Qprec-sqrt-</td> <td>-no-prec-sqrt</td> <td><p><samp class="codeph">-no-prec-sqrt</samp> enables the use of approximate sqrt instructions.</p></td>  </tbody> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/prec-sqrt-qprec-sqrt.html">prec-sqrt, Qprec-sqrt</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html">Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/floating-point-operations.html">Floating-Point Operations</a> and <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/floating-point-options.html">Floating-Point Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/overview.html">Intel&reg; C++ Compiler Developer Guide and Reference</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},57114:e=>{e.exports=' <h4>Consider outer loop vectorization</h4> <div class="text"> <div class="promo">The compiler never targets loops other than innermost ones, so it vectorized the inner loop while did not vectorize the outer loop. However outer loop vectorization could be more profitable because of better Memory Access Pattern, higher Trip Counts or better Dependencies profile. <br> To enforce outer loop vectorization: <table> <tr> <th> Target </th> <th> Directive </th> </tr> <tr> <td> Outer loop</td> <td>!$OMP SIMD</td> </tr> <tr> <td> Inner loop</td> <td>!$OMP NOVECTOR</td> </tr> </table> <p id="disclaimer"> Given issue is only about opportunity to vectorize outer loop, to prove profitability you need perform deeper dive analysis (MAP, Trip Counts, Dependencies) </p> <p class="expander">Example</p> <pre class="essential"><code class="fortran">!$OMP SIMD\nDO I=1,N\n    !$OMP NOVECTOR\n    DO J=1,N\n...</code></pre> <pre class="expansion"><code class="fortran">!$OMP SIMD\nDO I=1,N\n    !$OMP NOVECTOR\n    DO J=1,N\n        SUM = SUM + A(i)*A(j)\n    ENDDO\nENDDO</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a>, <a href="docs:Fortran/17/index.htm#GUID-967D7284-0E6D-4B02-B679-4DEE93D96E49.html">VECTOR and NOVECTOR</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/outer-loop-vectorization.html">Outer Loop Vectorization</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},57163:e=>{e.exports=' <h4>Reduce spills</h4> <div class="text"> <div class="promo"> Reduce spills using the following techniques: make small distance between defining and using variables, recompute cheap-to-compute values, choose smaller data types. </div> <div class="text"> <br> <ul> <li><b>Make the distance between loading a value to a variable and using the variable as short as possible.</b></li> <p> The compiler schedules instructions and optimizes the distances, but in some cases, moving a variable closer to define/use site may help the compiler to perform a better optimization. </p> <br> <li><b>Recompute cheap-to-compute values on demand.</b></li> <p> Recompute cheap-to-compute values on demand. Otherwise, the values stay in registers for a long time and increase register pressure. </p> <br> <li><b>Avoid using big private arrays or large private structure.</b></li> <p> Big arrays may be promoted to <span data-glossary-id="GRF">GRF</span> increasing the register pressure or to an extended private memory region increasing the memory traffic. To improve performance, consider decreasing the size of the arrays to fit into <span data-glossary-id="GRF">GRF</span> or promoting such arrays to <span data-glossary-id="SLM">SLM</span>. </p> <br> <li><b>Choose smaller data types.</b></li> <p> Smaller data types occupy less space in <span data-glossary-id="GRF">GRF</span>. Use smaller data types to decrease the register pressure: </p><ul> <li><b>short/int</b> instead of <b>long</b></li> <li><b>float</b> instead of <b>double</b></li> </ul> <p></p> <br> </ul> </div> </div> '},57524:(e,t,i)=>{"use strict";i.r(t),i.d(t,{dropOrphanNodes:()=>s}),i(69212),i(43468),i(21602);var o=i(6195),n=i(77106);const s=e=>(0,n.deepVisitor)(e,((e,t)=>"panels"===t?e.filter((e=>e.type===o.TYPE_PANEL)).map((({captureType:e,...t})=>t)):e))},57721:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n,getCurrentRowId:()=>o});const o=e=>Array.isArray(e)?e[0]:e,n={props:{selectionId:{type:String,required:!0}},mounted(){this.noAutoRefreshSelection||this.refreshSelection()},computed:{selection(){return this.$store.direct.getters.getSelection(this.selectionId)}},methods:{onSelectionChanged(e){},changeSelection(e,t){this.$store.direct.commit.setSelection({id:this.selectionId,senderId:e,rowId:t})},refreshSelection(){const{selection:e}=this;e&&this.onSelectionChanged(e)},getCurrentRowId:o},watch:{selection:{handler(e){e&&this.onSelectionChanged(e)},deep:!0}}}},58190:e=>{e.exports=' <h4>Target the AVX-512 ISA</h4> <div class="text"> <div class="promo"> Static analysis presumes the loop may benefit from AVX-512 approximate reciprocal instructions, but these instructions were not used. To fix: Use one of the following compiler options: <ul> <li> <samp class="codeph">xCOMMON-AVX512</samp> - tells the compiler which processor features to target, including instructions sets and optimizations it may generate, including AVX-512. </li> <li> <samp class="codeph">axCOMMON-AVX512</samp> - tells the compiler to generate multiple, feature-specific, auto-dispatch code for Intel processors if there is a performance benefit. </li> </ul> </div> <table> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> <tr> <td>/QxCOMMON-AVX512 or /QaxCOMMON-AVX512</td> <td>-xCOMMON-AVX512 or -axCOMMON-AVX512</td> </tr> </table> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-2D881A91-C5D7-4DDD-84B1-FB9D0D597F4D.html">ax, Qax</a>; <a href="docs:Fortran/17/index.htm#GUID-09734487-1819-4C1E-B314-2497F2B64C45.html">x, Qx</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/code-generation-options.html">Code Generation Options</a> in the <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/overview.html">Intel&reg; Fortran Compiler Developer Guide and Reference</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/architecture-and-technology/avx-512-solution-brief.html">Compiling for the Intel&reg; Xeon Phi&trade; processor x200 and the Intel&reg; AVX-512 ISA</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},58383:e=>{e.exports=' <h4>Remove system function call(s) inside loop</h4> <div class="text promo"> Typically system function or subroutine calls cannot be vectorized; even a print statement is sufficient to prevent vectorization. To fix: Avoid using system function calls in loops. </div>'},58435:e=>{e.exports=' <h4>Inefficient memory access patterns present</h4> <div class="essential"> There is a high of percentage memory instructions with irregular (variable or random) stride accesses. Improve performance by investigating and handling accordingly. </div>'},58849:e=>{e.exports=' <h4>Disable unrolling</h4> <div class="text"> <div class="promo"> The <span data-glossary-id="trip_count">trip count</span> <span id="peel_remainder"> %trip_count% after loop unrolling is too small compared to the <span data-glossary-id="vector_length">vector length</span> %vl% </span>. To fix: Prevent loop <span data-glossary-id="unroll">unrolling</span> or decrease the unroll factor using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">!DIR$ NOUNROLL</samp> or <samp class="codeph">!DIR$ UNROLL</samp>. <p class="expander">Example</p> <div class="expansion"> Disable automatic loop unrolling using <samp class="codeph">!DIR$ NOUNROLL</samp> <pre><code class="fortran">!DIR$ NOUNROLL\ndo i = 1, m\n    b(i) = a(i) + 1\n    d(i) = c(i) + 1\nenddo</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-F74EB440-3541-42B0-8C89-C5D4DB6673DA.html">UNROLL and NOUNROLL</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},59029:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return e.metric.value?t("header",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.tooltip,expression:"tooltip"}]},[e._t("default"),e._v("\n  "+e._s(e.metric.value)+"\n")],2):e._e()};o._withStripped=!0;const n={props:{metric:{type:Object,required:!0}},computed:{tooltip(){const{value:e,tooltip:t}=this.metric;return e.length>100?e:t}}},s=(0,i(98822).A)(n,o,[],!1,null,"7b5d013a",null).exports},59400:e=>{e.exports=' <h4>Check memory access patterns for outer loop</h4> <div class="text promo"> <div id="no_map_disclaimer" class="disclaimer" style="display:none"> Run the <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a> to check for memory issues. </div> <span id="actions" style="display:none">To ensure that outer loop has optimal memory access patterns run a <a href="docs:../help/index.htm#GUID-FEE0B0A5-059A-41EA-B622-2E6F3C0DC108.html">Memory Access Patterns analysis</a>.</span> </div>'},59743:(e,t,i)=>{"use strict";i.d(t,{Aw:()=>n,gi:()=>r}),i(69212),i(43827),i(43468),i(21602);const o=new Map;function n(e,t){o.set(e,t)}function s(e){return o.get(e)||e}class r{constructor(e){this.gridClass=e,this.mappedClass=""}get(){if(!this.mappedClass){const{gridClass:e}=this;let t=s(e);if(t===e){const i=e.split(" ");i.length>1&&(t=i.map(s).join(" "))}t!==e&&(this.mappedClass=t)}return this.mappedClass||this.gridClass}}},59991:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>n});var o=function(){var e=this,t=e._self._c;return t("header",[e._m(0),e._v(" "),t("div",{staticClass:"title"},[t("h2",[e._v(e._s(e.$t("perspective_selector_title")))]),e._v(" "),t("span",[e._v(e._s(e.$t("perspective_selector_description")))])])])};o._withStripped=!0;const n=(0,i(98822).A)({},o,[function(){var e=this._self._c;return e("div",{staticClass:"square"},[e("div",{staticClass:"circle"},[e("i",{staticClass:"icon crossroads-sign light"})])])}],!1,null,"9aa84b78",null).exports},60116:e=>{e.exports=' <h4>This loop is mostly compute bound</h4> <div class="text"> <div class="promo"><span id="roofline_guidance"> <span id="fma_dominates"> The bottleneck depends heavily on the fused multiply-add (FMA) computational unit.<br/> </span> <span id="add_dominates"> The bottleneck depends greatly on the accessed computational unit.<br/> </span> <span id="is_vectorized"> <span id="isa_issue"> To improve performance: Switch from %c_isa% to %b_isa% - the highest available instruction set architecture (ISA). </span> <span id="inefficient_map"> Eliminate inefficient memory access patterns. </span> <span id="has_traits"> %traits% instructions might degrade performance. </span> </span> <span id="is_scalar"> The loop is scalar. To fix: Vectorize the loop. </span> </span></div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div> '},60469:e=>{e.exports=' <h4>Add more parallel work</h4> <div class="text"> <div class="promo"> Add more parallel work to this region. For example, use a larger dataset or collapse nested loop iteration space. <ul><li> With <a href="https://www.intel.com/content/www/us/en/develop/documentation/get-started-with-cpp-fortran-compiler-openmp/top.html">OpenMP* Offload</a> programming model, you can collapse several nested loops into a logical iteration space width by using the <samp class="codeph">collapse(&lt;N&gt;)</samp> clause. </li></ul></div> <ul><li style="list-style-type:none"> See the <a href="https://www.openmp.org/spec-html/5.1/openmpsu48.html">OpenMP specification</a> for more details. </li></ul> <div class="promo"><ul><li style="list-style-type:none"> <p class="expander">Example of the OpenMP collapse clause:</p> <pre class="essential"><code class="fortran" data-source="\n!$omp target teams distribute parallel do collapse(2) &    \n...\n"></code></pre> <pre class="expansion"><code class="fortran" data-source="\n!$omp target teams distribute parallel do collapse(2) &    \n!$omp shared ( b, count, count_max, g, r, x_max, x_min, y_max, y_min ) &\n!$omp private ( i, j, k, x, x1, x2, y, y1, y2 )\n  do i = 1, m\n    !$omp simd simdlen(8)\n    do j = 1, n\n"></code></pre> </li></ul></div> </div> '},60970:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sizeToFlex=t.STATE_VERSION=t.DEBUG=t.MOUSE_BUTTON_LEFT=t.USER_INTERACTION_DELAY=t.MIN_PANEL_SIZE=t.DIRECTION_VERTICAL=t.DIRECTION_HORIZONTAL=t.PANEL_SPLITTER=t.GUIDE_SPLITTER=t.SPLITTER_WIDTH=t.HEADER_HEIGHT=t.DIRECTION_COLUMN=t.DIRECTION_ROW=t.ACTION_DOCK=t.ACTION_MOVE_ACROSS=t.ACTION_MOVE=t.ACTION_SWAP=t.CAPTURE_TYPE_TAB=t.CAPTURE_TYPE_PANEL=t.STATE_COLLAPSED=t.STATE_HIDDEN=t.STATE_ACTIVE=t.STATE_NORMAL=t.TYPE_PLACEHOLDER=t.TYPE_PANEL=t.TYPE_GUIDE=t.DEFAULT_FEATURES=t.ALL_FEATURES=t.CLOSE_BY_CROSS_BUTTON=t.HIDE_BY_CROSS_BUTTON=t.CAN_COLLAPSE=t.CAN_DOCK=t.CAN_MOVE=t.CAN_SWAP=t.CAN_HRESIZE=t.CAN_VRESIZE=t.CAN_RESIZE=void 0,t.CAN_RESIZE="resize",t.CAN_VRESIZE="vresize",t.CAN_HRESIZE="hresize",t.CAN_SWAP="swap",t.CAN_MOVE="move",t.CAN_DOCK="dock",t.CAN_COLLAPSE="collapse",t.HIDE_BY_CROSS_BUTTON="hide_by_cross_button",t.CLOSE_BY_CROSS_BUTTON="close_by_cross_button",t.ALL_FEATURES=[t.CAN_RESIZE,t.CAN_VRESIZE,t.CAN_HRESIZE,t.CAN_SWAP,t.CAN_MOVE,t.CAN_DOCK,t.CAN_COLLAPSE,t.HIDE_BY_CROSS_BUTTON,t.CLOSE_BY_CROSS_BUTTON],t.DEFAULT_FEATURES=[t.CAN_RESIZE,t.CAN_SWAP,t.CAN_MOVE,t.CAN_DOCK,t.CAN_COLLAPSE,t.HIDE_BY_CROSS_BUTTON],t.TYPE_GUIDE="TYPE_GUIDE",t.TYPE_PANEL="TYPE_PANEL",t.TYPE_PLACEHOLDER="TYPE_PLACEHOLDER",t.STATE_NORMAL="normal",t.STATE_ACTIVE="active",t.STATE_HIDDEN="hidden",t.STATE_COLLAPSED="collapsed",t.CAPTURE_TYPE_PANEL="CAPTURE_TYPE_PANEL",t.CAPTURE_TYPE_TAB="CAPTURE_TYPE_TAB",t.ACTION_SWAP="ACTION_SWAP",t.ACTION_MOVE="ACTION_MOVE",t.ACTION_MOVE_ACROSS="ACTION_MOVE_ACROSS",t.ACTION_DOCK="ACTION_DOCK",t.DIRECTION_ROW="row",t.DIRECTION_COLUMN="column",t.HEADER_HEIGHT=25,t.SPLITTER_WIDTH=16,t.GUIDE_SPLITTER="GUIDE_SPLITTER",t.PANEL_SPLITTER="PANEL_SPLITTER",t.DIRECTION_HORIZONTAL="horizontal",t.DIRECTION_VERTICAL="vertical",t.MIN_PANEL_SIZE=100,t.USER_INTERACTION_DELAY=150,t.MOUSE_BUTTON_LEFT=1,t.DEBUG=!1,t.STATE_VERSION="0.65",t.sizeToFlex=e=>e?`0 1 ${e}`:"1"},60984:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(11397),n=i(21154),s={};for(const e in n)"default"!==e&&(s[e]=()=>n[e]);i.d(t,s);const r=(0,i(98822).A)(n.default,o.X,o.Y,!1,null,"505770e4",null).exports},60997:e=>{e.exports=' <h4>Change the floating point model</h4> <div class="text"> <div class="promo"> Your application calls serialized versions of math functions when you use the <samp class="codeph">strict</samp> floating point model. To fix: Do one of the following: <ul> <li> Use the <samp class="codeph">fast</samp> floating point model to enable more aggressive optimizations or the <samp class="codeph">precise</samp> floating point model to disable optimizations that are not value-safe on fast transcendental functions. <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /fp:fast </td> <td> -fp-model fast </td> </tr> <tr> <td> /fp:precise /Qfast-transcendentals </td> <td> -fp-model precise -fast-transcendentals </td> </tr> </tbody> </table> <p>CAUTION: This may reduce floating point accuracy.</p> </li> <li> Use the <samp class="codeph">precise</samp> floating point model and enforce vectorization of the <span data-glossary-id="source_loop">source loop</span> using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">#pragma omp simd</samp> </li> </ul> <p class="expander">Example</p> <div class="essential"> <pre><code class="bash">gcc program.c -O2 -fopenmp -fp-model precise -fast-transcendentals</code></pre> <pre><code class="cpp">#pragma omp simd collapse(2)\nfor (i=0; i&lt;N; i++)\n...</code></pre> </div> <div class="expansion"> <pre><code class="bash">gcc program.c -O2 -fopenmp -fp-model precise -fast-transcendentals</code></pre> <pre><code class="cpp">#pragma omp simd collapse(2)\nfor (i=0; i&lt;N; i++)\n{\n    a[i] = b[i] * c[i];\n    for (i=0; i&lt;N; i++)\n    {\n        d[i] = e[i] * f[i];\n    }\n}</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-0A4F4F35-1495-4154-8AD5-238E8C68CE9B.html"> fast-transcendentals, Qfast-transcendentals</a>; <a href="docs:C++/17/index.htm#GUID-63514789-6BE7-4FA8-9389-F3B618A2EE1A.html"> fp-model, fp</a>; <i>omp simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html"> OpenMP* Pregmas Summary</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html"> Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html"> Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},61105:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(53386),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},61124:e=>{e.exports=' <h4>Use the smallest data type</h4> <div class="text"> <p class="promo"> The <span data-glossary-id="source_loop">source loop</span> contains data types of different widths. To fix: Use the smallest data type that gives the needed precision to use the entire <span data-glossary-id="vector_register_width">vector register width</span>. </p> <p><b>Example:</b> If only 16-bits are needed, using a short rather than an int can make the difference between eight-way or four-way SIMD parallelism, respectively.</p> </div>'},61143:e=>{e.exports=' <h4>Possible inefficient memory access patterns present</h4> <div class="essential"> Inefficient memory access patterns may result in significant vector code execution slowdown or block automatic vectorization by the compiler. Improve performance by investigating. </div>'},61250:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"modal-container"},[t("div",{staticClass:"section"},[t("directionSvg",{staticClass:"svg",attrs:{radius:22},on:{"text-updated":e.updateText}}),e._v(" "),t("div",{staticClass:"measured"},[e._v("Measured")]),e._v(" "),t("div",{staticClass:"modeled"},[e._v("Modeled")]),e._v(" "),t("div",{staticClass:"cpu-title-before platform-name"},[e._v("CPU")]),e._v(" "),t("div",{staticClass:"cpu-title-after platform-name"},[e._v("CPU`")]),e._v(" "),t("div",{staticClass:"gpu-title-before platform-name"},[e._v("GPU")]),e._v(" "),t("div",{staticClass:"gpu-title-after platform-name"},[e._v("GPU`")])],1),e._v(" "),t("div",{staticClass:"direction-info"},[e._v(e._s(e.text))]),e._v(" "),t("span",{staticClass:"apply-btn",on:{click:function(t){return e.$emit("close")}}},[e._v("Apply")])])};o._withStripped=!0;var n=i(39708);const s={data:()=>({text:""}),methods:{updateText(e){this.text=e}},components:{directionSvg:n.default}},r=(0,i(98822).A)(s,o,[],!1,null,"7bd3507c",null).exports},61262:(e,t,i)=>{"use strict";i.r(t),i.d(t,{addTooltip:()=>S,clearCurrentTooltipHideProc:()=>x,createHorzSplitter:()=>b,createVertSplitter:()=>y,default:()=>F,hideCurrentTooltip:()=>C,setCurrentTooltipHideProc:()=>w}),i(36094),i(69212),i(43468),i(45361);var o={browserPrefix:"-webkit-",engine:"webkit",os:"win"};!function(){if(-1===navigator.userAgent.indexOf("WebKit")){o.engine="moz",o.browserPrefix="-moz-";var e=navigator.userAgent.lastIndexOf("/");-1!==e&&parseInt(navigator.userAgent.substr(e+1))>=54&&(o.browserPrefix="")}const t=navigator.platform.toLowerCase();t.indexOf("lin")>=0?o.os="lin":t.indexOf("mac")>=0&&(o.os="mac")}();var n;function s(e,t,i){var o=Math.pow(10,t);return Math[i](e*o)/o}function r(e,t){return s(e,t,"round")}function a(e){function t(e){return e.preventDefault(),!1}e&&(e.addEventListener("dragstart",t),e.addEventListener("drop",t))}function l(e,t,i,o,n,s){n=n||"div";var r=document.createElement(n);return a(r),t&&(r.className=t),i&&(r.id=i),e&&(r.innerHTML=e),s&&s(r),o&&o.appendChild(r),r}var c,d=(c={},function(e,t){var i;return t||!c[e]?(i=document.getElementById(e))&&(c[e]=i):i=c[e],i});function p(e){if(!e)return{x:0,y:0,width:0,height:0};var t=e.getBoundingClientRect(),i=document.documentElement,o=window.pageYOffset||i.scrollTop,n=window.pageXOffset||i.scrollLeft,s=t.top+o-i.clientTop;return{x:t.left+n-i.clientLeft,y:s,width:t.width,height:t.height}}function u(e,t){var i=[].slice.call(arguments,2);return function(){return e.apply(t,i.concat([].slice.call(arguments)))}}function h(e){var t=[].slice.call(arguments,1);return function(){var i=[].slice.call(arguments),o=t.shift();if(o){var n=o.apply(e,i);return t.forEach((function(t){n=t.call(e,n)})),n}}}function m(e){return"string"==typeof e?document.getElementById(e):e}var f,v="data-stopRefreshSize";function g(e,t){var i;if(e&&(e.hasAttribute(v)?i=!0:e.refreshSize&&(i=e.refreshSize(t)),!i&&e.children))for(var o=0,n=e.children.length;o<n;o++)g(e.children[o],t)}function _(e,t,i,n){function s(t,i){var o,n=e[t];return n&&((o=m(n)).classList.add(i),a=o.offsetParent||a),o}function r(e){var t=document.createElement("div");return t.className=e,t.idvcCreatedBySplitter=!0,a.appendChild(t),t}if(i=i||.3,e){var a,l=s("primaryDiv",n.primaryDivClass),c=s("splitterDiv",n.splitterDivClass),d=s("secondaryDiv",n.secondaryDivClass),p=!1;if(a||(a=m(e)),a){l||(l=r(n.primaryDivClass)),c||(c=r(n.splitterDivClass)),d||(d=r(n.secondaryDivClass)),c.onselectstart=function(){return!1};var u={pos:-1,dragged:!1,primarySize:0,secondarySize:0},h=null,f=function(e){if(!y&&u.dragged){t=t||100;let i=e[n.eventPos],{primarySize:o,secondarySize:s}=u;const r=o+s;let a=i-u.pos;o+a<t?(a=t-o,i=a+u.pos):s-a<t&&(a=s-t,i=a+u.pos),o+=a,function(e,t,i){var o=I();n.backward&&(e=t-e),p?A(100*e/(t+o)+"%",o,i):S(e,o,i)}(o,r,!0),u.pos=i,u.primarySize=o,u.secondarySize=r-o}},_=function(){document.body.removeChild(h),h=null,u.pos=-1,u.dragged=!1,u.primarySize=0,u.secondarySize=0,c.classList.remove("idvc2_grid_splitter_hover"),window.removeEventListener("mousemove",f,!0),window.removeEventListener("mouseup",_,!0),w&&w.onStopUpdateSplitter&&w.onStopUpdateSplitter()};c.onmousedown=function(e){if(e=e||event,y)w.unfold(!0);else if(!e.ctrlKey&&!e.shiftKey&&e.target===c){e.preventDefault(),(h=document.createElement("div")).className="idvc2_grid_global_cursor";var t=window.getComputedStyle(c,null);h.style.cursor=t.cursor,document.body.appendChild(h),c.classList.add("idvc2_grid_splitter_hover"),u.pos=e[n.eventPos],u.dragged=!0,u.primarySize=l[n.offsetSize],u.secondarySize=d[n.offsetSize],window.addEventListener("mousemove",f,!0),window.addEventListener("mouseup",_,!0),w&&w.onStartUpdateSplitter&&w.onStartUpdateSplitter()}};var y,b=E(i),w={primaryDiv:l,splitterDiv:c,secondaryDiv:d,setSize:function(e,t){if(y)parseInt(e,10)&&(y=e);else{var i=I();(p="%"===e[e.length-1])?A(e,i,t):S(parseInt(e,10),i,t)}},getSize:function(){return p||!n.backward?l.style[n.size]:d.style[n.size]},foldPrimary:function(e,t){T(),l.style.display="none",l.setAttribute(v,"1"),d.style.display="",d.removeAttribute(v),e&&(c.style.display="none"),A("0%",I(),t),this.afterFoldPrimary&&this.afterFoldPrimary(t)},isPrimaryFolded:function(){return"none"===l.style.display},foldSecondary:function(e,t){T(),d.style.display="none",d.setAttribute(v,"1"),l.style.display="",l.removeAttribute(v),c.style.display=e?"none":"block",A("100%",I(),t),this.afterFoldSecondary&&this.afterFoldSecondary(t)},isSecondaryFolded:function(){return"none"===d.style.display},isSplitterHidden:function(){return"none"===c.style.display},unfold:function(e){if(!y)return!1;l.style.display="",l.removeAttribute(v),d.style.display="",d.removeAttribute(v),c.style.display="block";var t=y;return y=void 0,this.setSize(t,e),c.classList.remove("idvc2_splitter_folded"),this.afterUnfold&&this.afterUnfold(e),!0},hideSecondary:function(){d.style.display="none",d.setAttribute(v,"1"),c.style.display="none"},showSecondary:function(){d.style.display="",d.removeAttribute(v),c.style.display="block",this.setSize(l.style[n.size])},addSash:function(e,t){t=t||"idvc2_splitter_sash";var i=document.createElement("div");return i.className=t,i.onmousedown=function(t){y?this.unfold(!0):e?this.foldPrimary(!1,!0):this.foldSecondary(!1,!0),t.stopPropagation(),t.preventDefault()}.bind(this),c.appendChild(i),this.sashDiv=i,i},removeSash:function(){V(c),delete this.sashDiv},remove:function(){function e(e){e.idvcCreatedBySplitter&&e.parentNode.removeChild(e)}l.classList.remove(n.primaryDivClass),d.classList.remove(n.secondaryDivClass),c.classList.remove(n.splitterDivClass),C(),e(l),e(d),e(c)}};return w.setSize("50%"),w}}function x(e){if(e||!n.refreshSizeByUserAction){var t={};t[n.size]=!0,g(l,t),g(d,t),w&&w.onRefreshSize&&w.onRefreshSize()}}function C(){function e(e){e.style[n.size]="",e.style[n.pos]="",e.style[n.posBackward]=""}e(l),e(c),e(d)}function A(e,t,i){if(C(),"100%"===e)e=o.browserPrefix+"calc(100% - "+t+"px)",l.style[n.size]=e,c.style[n.pos]=e,d.style[n.pos]="100%";else if("0%"===e)e="0",l.style[n.size]=e,c.style[n.pos]=e,d.style[n.pos]=t+"px";else{l.style[n.size]=e,c.style[n.pos]=e;var s=o.browserPrefix+"calc("+e+" + "+t+"px)";d.style[n.pos]=s}x(i)}function S(e,t,i){C(),l.style[n.backward?n.posBackward:n.size]=(n.backward?e+t:e)+"px",c.style[n.backward?n.posBackward:n.pos]=e+"px",d.style[n.backward?n.size:n.pos]=(n.backward?e:e+t)+"px",x(i)}function T(){y||(y=w.getSize(),c.classList.add("idvc2_splitter_folded"),u.dragged&&_())}function I(){var e=c[n.offsetSize];return e<0&&(e=0),c&&"none"===c.style.display||e||(e=b),e}}function y(e,t,i){var o={primaryDivClass:(i=i||{}).primaryDivClass||"idvc2_splitter_vert_primary",splitterDivClass:i.splitterDivClass||"idvc2_splitter_vert_splitter",secondaryDivClass:i.secondaryDivClass||"idvc2_splitter_vert_secondary",size:"height",pos:"top",posBackward:"bottom",offsetSize:"offsetHeight",eventPos:"pageY",backward:i.backward,refreshSizeByUserAction:i.refreshSizeByUserAction};return _(e,t,i.splitterSize,o)}function b(e,t,i){var o={primaryDivClass:(i=i||{}).primaryDivClass||"idvc2_splitter_horz_primary",splitterDivClass:i.splitterDivClass||"idvc2_splitter_horz_splitter",secondaryDivClass:i.secondaryDivClass||"idvc2_splitter_horz_secondary",size:"width",pos:"left",posBackward:"right",offsetSize:"offsetWidth",eventPos:"pageX",backward:i.backward,refreshSizeByUserAction:i.refreshSizeByUserAction};return _(e,t,i.splitterSize,o)}function w(e){f=e}function x(){f=void 0}function C(){f&&f()}function A(e,t,i){if(t){var o=m(e);if(o){var n,s,r,a,l,c={tooltip:null,timer:void 0},d=function(e){s&&(clearTimeout(s),s=void 0),c.tooltip&&document.body.removeChild(c.tooltip),e&&(a=!0,l||(l=D((function(){a=void 0}),window,e)),l.call()),c.timer&&(window.clearTimeout(c.timer),c.timer=void 0),c.tooltip=null,c.elem=null,x()},p=function(){r||d()},u=function(e,i,o,n){if(!a){c.timer=void 0;var s=t.create(this,e);s&&(z(s.style,n),h(s,i,o),c.tooltip=s)}},h=function(e,i,o){void 0===i&&(i=n.pageX),void 0===o&&(o=n.pageY),t.simpleMode||(e.classList.remove("idvc2_grid_tooltip_ellipsis"),e.style.height=""),e.offsetWidth>.8*window.innerWidth&&(e.style.height="auto",e.style.width=Math.floor(.8*window.innerWidth)+"px");var s=window.getComputedStyle(e,null),r=parseInt(s.getPropertyValue("margin-left"),10),a=i;a<0?a=0:a+r+e.offsetWidth+6>window.innerWidth+window.scrollX&&(a=window.innerWidth+window.scrollX-e.offsetWidth-r-6);var l=parseInt(s.getPropertyValue("margin-top"),10),c=o;if(c<0&&(c=0),c+e.offsetHeight+l+2>window.innerHeight+window.scrollY&&(c=window.innerHeight+window.scrollY-e.offsetHeight-l-2)<1){c=1;var d=window.innerHeight-c-2*(parseInt(s.getPropertyValue("padding-top"),10)+2);e.style.height=d+"px",t.simpleMode||e.classList.add("idvc2_grid_tooltip_ellipsis"),e.style.lineHeight&&parseInt(e.style.lineHeight)>d&&(e.style.lineHeight=e.style.height)}const p=.5*r,u=.5*l;if(!t.ignoreOverlapping&&a<=i-p&&c<=o-u)if(a===i-p)a+=3;else{var h=i-6-3*p-e.offsetWidth;if(h>=0)a=h;else{var m=o-2-3*u-e.offsetHeight;m>=0&&(c=m)}}e.style.left=a+"px",e.style.top=c+"px"};return o.addEventListener("mouseout",p,!1),o.addEventListener("mousemove",g,!1),{show:function(e,t,i,o,n,s){f(e),c.tooltip?(c.tooltip.innerHTML=t,z(c.tooltip.style,s),h(c.tooltip,i,o)):(w(d),u(t,i,o,s)),v(n)},hide:function(e){d(e)},update:function(){c.tooltip&&setTimeout(g.bind(this,n),0)},getTooltipDOMElement:function(){if(c)return c.tooltip},getParentDOMElement:function(){if(c)return c.elem},destroy:function(){o.removeEventListener("mouseout",p,!1),o.removeEventListener("mousemove",g,!1),o=void 0}}}}function f(e){c.elem=e}function v(e){s&&clearTimeout(s),s=void 0,e>0&&(s=setTimeout((function(){s=void 0,d()}),e))}function g(e){var o=t.needUpdate||function(e,t){return e!==t};if(e=e||event,n=e,o(c.elem,e.target,e.pageX,e.pageY)){var a=t.getInfo(e.target,e.pageX,e.pageY);if(a){if(a.keepCurrent&&c.tooltip)a.tracking&&(a.text&&(c.tooltip.innerHTML=a.text),h(c.tooltip,e.pageX,e.pageY));else if(d(),a.text){var l=void 0!==a.delay?a.delay:i;f(a.target),w(d),c.timer=window.setTimeout(u.bind(a.target,a.text,a.x,a.y,a.style),l)}c.tooltip&&z(c.tooltip.style,a.style),s||v(a.autoHideDelay),r=a.ignoreMouseOut}else c.tooltip&&d()}}}function S(e,t,i,o){return A(e,{needUpdate:function(e,t,o,n){return(i=i||function(e,t){return e!==t})(e,t)},getInfo:function(e,i,o){var n,s;return(s="function"==typeof t?t(e,i,o):t)&&("object"==typeof s?z(n={},s):n={text:s,target:e}),n},create:function(e,t){var i=function(e,t){if(e&&e.length){var i=document.createElement("div");return i.className="idvc2_grid_popup idvc2_grid_tooltip",t&&i.classList.add(t),i.innerHTML=e,document.body.appendChild(i),i}}(t,o);return M(i,window.getComputedStyle(document.body,null)),i}},250)}function T(e,t,i){var o;e&&t&&(i=i||{},M(e,t),e.style.paddingLeft=t.paddingLeft,e.style.paddingTop=t.paddingTop,e.style.paddingRight=t.paddingRight,e.style.paddingBottom=t.paddingBottom,e.style.borderTopStyle=t.borderTopStyle,e.style.borderTopWidth=t.borderTopWidth,e.style.borderRightStyle=t.borderRightStyle,e.style.borderRightWidth=t.borderRightWidth,e.style.borderBottomStyle=t.borderBottomStyle,e.style.borderBottomWidth=t.borderBottomWidth,e.style.borderLeftStyle=t.borderLeftStyle,e.style.borderLeftWidth=t.borderLeftWidth,e.style.color=i.color||t.color,e.style.borderColor=i.backgroundColor||t.backgroundColor,e.style.backgroundColor=i.backgroundColor||t.backgroundColor,e.style.backgroundImage=t.backgroundImage,e.style.backgroundRepeat=t.backgroundRepeat,e.style.backgroundPosition=t.backgroundPosition,e.style.backgroundOrigin=t.backgroundOrigin,e.style.whiteSpace="pre"===(o=t.whiteSpace)?"pre-wrap":"nowrap"===o?"normal":o)}function I(e,t,i,o,n){if(e&&t){(o=o||function(e,t){t.innerHTML=e.innerHTML})(e,t);var s=window.getComputedStyle(e,null);t.style.boxSizing=s.boxSizing,t.style.lineHeight=s.lineHeight,n?t.style.width=s.width:t.style.height=s.height,T(t,s,{backgroundColor:i})}}function P(e,t,i,o){if(o=o||!1,!(i=i||function(){return!0})())return{disabler:n,disabled:s,end:function(){}};var n=null,s=m(e);return s&&(o&&(n=s.getElementsByClassName("idvc2_grid_disabler")[0]),n||((n=document.createElement("div")).className="idvc2_grid_disabler",s.appendChild(n)),t&&(n.innerText=t),n.getBoundingClientRect()),{disabler:n,disabled:s,end:function(){n.parentNode&&n.parentNode.removeChild(n)}}}function M(e,t,i){if(e&&t){if(i){var o=parseInt(t.fontSize);o=2*Math.floor(o/2),e.style.fontSize=o+"px"}else e.style.fontFamily=t.fontFamily,e.style.fontSize=t.fontSize;e.style.fontStyle=t.fontStyle,e.style.fontWeight=t.fontWeight,e.style.fontVariant=t.fontVariant}}function E(e,t){return t=t||document.documentElement,e*parseFloat(getComputedStyle(t).fontSize)}function L(e,t,i,o){t=t||"click",void 0===(e=e||{x:0,y:0}).x&&(e.x=0),void 0===e.y&&(e.y=0);var n,s={view:window,bubbles:!0,cancelable:!0,screenX:e.x,screenY:e.y,clientX:e.x,clientY:e.y};z(s,o),i=i||document.elementFromPoint(e.x,e.y)||window;try{n=new MouseEvent(t,s)}catch(i){(n=document.createEvent("MouseEvents")).initMouseEvent(t,!0,!0,window,0,e.x,e.y,e.x,e.y,!1,!1,!1,!1,0,null)}n.simulation=!0,i.dispatchEvent(n)}var R="idvc2_disable_hover";function D(e,t,i){var o;return i=i||0,t=t||window,e=e||function(){},{call:function(){this.cancel();var n=arguments;o=setTimeout((function(){e.apply(t,n),o=void 0}),i)},cancel:function(){o&&(clearTimeout(o),o=void 0)},isCalled:function(){return!!o},setFunction:function(t){e=t||function(){}},setThisArg:function(e){t=e||window},setDelay:function(e){i=e}}}var k,O=function(){};function N(){"function"==typeof k&&k.apply(this,arguments)}function z(e,t){e&&t&&"object"==typeof t&&Object.getOwnPropertyNames(t).forEach((function(i){"object"!=typeof t[i]||B(t[i])?"className"===i&&e.classList?e.classList.add(t.className):e[i]=t[i]:(e[i]||(Array.isArray(t[i])?e[i]=[]:e[i]={}),z(e[i],t[i]))}))}function B(e){return e instanceof Node&&void 0!==e.nodeType&&void 0!==e.nodeName}function V(e){if(e)for(;e.firstChild;)e.removeChild(e.firstChild)}function G(){this.scrolled=[]}N.enable=function(){k=console.log.bind(console)},N.disable=function(){k=O},N.set=function(e){k=e},N.disable(),G.prototype.updateVisibleScrollTop=function(e){this.scrolled.forEach((function(t){t._updateVisibleScrollTop(e)}))},G.prototype.addScrolled=function(e,t){t?this.scrolled.unshift(e):this.scrolled.push(e)},G.prototype.removeAllScrolled=function(){this.scrolled.length=0},G.prototype.syncScrollTop=function(e){var t=0,i=0,o=!1,n=!0,s=!0;this.scrolled.forEach((function(r){if(r._isActive()){r._updateScrollTop(e);var a=r._getScrollState(),l=a.visibleScrollTop;s?(t=l,i=a.topIndex,s=!1):l!==t&&(t=Math.min(t,l),o=!0,n=n&&i===a.topIndex)}})),n&&o&&this.updateVisibleScrollTop(t),this.scrolled.forEach((function(e){e._isActive()&&e._endScroll&&e._endScroll()}))};const F={Consts:o,appendCSS:function(e){var t=document.createElement("link");t&&(t.setAttribute("href",e),t.setAttribute("rel","stylesheet"),t.setAttribute("type","text/css")),document.getElementsByTagName("head")[0].appendChild(t)},appendScript:function(e,t,i){var o=document.getElementsByTagName("head")[0],n=document.createElement("script");n.setAttribute("src",e),n.setAttribute("type","text/javascript"),t&&(n.onload=t),i&&(n.onerror=i),o.appendChild(n)},applyUAFont:function(e){var t=m(e)||document.body,i=document.createElement("button");i.style.position="absolute",i.style.left="0",i.style.top="0",t.appendChild(i),M(t,window.getComputedStyle(i,null),!0),t.removeChild(i)},getScrollbarSize:function(e){if(!n||e){var t=document.createElement("div");t.style.overflow="scroll",t.style.position="absolute",t.style.top="0",t.style.left="0",t.style.width="100px",t.style.height="100px",document.body.appendChild(t),n={width:t.offsetWidth-t.clientWidth,height:t.offsetHeight-t.clientHeight},document.body.removeChild(t)}return n},disableDragging:a,createElement:l,getElementById:d,round:r,floor:function(e,t){return s(e,t,"floor")},ceil:function(e,t){return s(e,t,"ceil")},roundExp:function(e,t){return e<=10&&e>=1||e<=-1&&e>=-10?r(e,t):e.toExponential(t)},getElementPos:p,defaultCompareItems:function(e,t){return"number"==typeof e||"boolean"==typeof e?t-e:"string"==typeof e?t.localeCompare(e):0},format:function(){var e=arguments,t=arguments[0];if(t)return t.replace(/\{\d+\}/g,(function(t){return e[parseInt(t.slice(1,-1),10)]}))},curry:function(e){var t=[].slice.call(arguments,1);return t.unshift(void 0),t.unshift(e),u.apply(void 0,t)},curryThis:u,compose:function(){var e=[].slice.call(arguments);return e.unshift(void 0),h.apply(void 0,e)},composeThis:h,getDomElement:m,refreshSize:g,createResizeProcess:function(e,t,i,n){i=i||t,void 0===n&&(n=0);var s,r={},a=m(e);function l(e){e.button===n&&t.accepted.call(i,e.target)&&(r.isStarted=!1,r.startMousePos={x:e.pageX,y:e.pageY},r.mousePos={x:e.pageX,y:e.pageY},r.globalCursor=document.createElement("div"),r.globalCursor.className="idvc2_grid_global_cursor",r.globalCursor.style.cursor=t.getCursor(),document.body.appendChild(r.globalCursor),window.addEventListener("mousemove",c,!0),window.addEventListener("mouseup",d,!0),e.preventDefault(),e.stopPropagation(),t.onDblClick&&!s&&(s={count:0,timeout:setTimeout((function(){s=void 0}),800)}))}function c(e){var o=5;t.getDeltaThreshold&&(o=t.getDeltaThreshold());var n={x:e.pageX,y:e.pageY},s=t.getDelta.call(i,n,r.mousePos,r.startMousePos);r.isStarted?(e.preventDefault(),t.onProcess.call(i,s),r.mousePos=n):Math.abs(s)>o&&(r.isStarted=!0)}function d(e){r.globalCursor&&(document.body.removeChild(r.globalCursor),r.globalCursor=null),r={},window.removeEventListener("mousemove",c,!0),window.removeEventListener("mouseup",d,!0),s&&(s.count++,s.count>1&&(t.onDblClick.call(i),clearTimeout(s.timeout),s=void 0)),t.onEnd.call(i),"moz"===o.engine&&L({x:e.pageX,y:e.pageY},"mousemove")}return a.addEventListener("mousedown",l,!1),{destroy(){a.removeEventListener("mousedown",l,!1)}}},createVertSplitter:y,createHorzSplitter:b,addTooltip:S,copyAppearance:T,addExpansion:function(e,t,i,o){var n;t=t||function(e){return e},n=o?{check:function(e,t){if(!e||!t)return!1;var i=p(e),o=e.offsetHeight;return i.y+o>window.innerHeight+window.scrollY&&(o=window.innerHeight+window.scrollY-i.y),t.offsetHeight-1>o}}:{check:function(e,t){if(!e||!t)return!1;var i=p(e),o=e.offsetWidth;return i.x+o>window.innerWidth+window.scrollX&&(o=window.innerWidth+window.scrollX-i.x),t.offsetWidth-1>o}};var s=A(e,{ignoreOverlapping:!0,simpleMode:!0,needUpdate:function(e,t){return e!==t},getInfo:function(e,i,o){if(e=t(e,i,o)){var n=p(e);return{x:n.x,y:n.y,target:e,text:"exp"}}},create:function(e){if(e.innerHTML.length){var t=document.createElement("div");return t.className="idvc2_grid_popup",I(e,t,i,r.processContent,o),document.body.appendChild(t),r.afterCreateTooltip&&r.afterCreateTooltip(t),n.check(e,t)?t:void document.body.removeChild(t)}}},50),r={update:function(){I(s.getParentDOMElement(),s.getTooltipDOMElement())},hide:function(){s.hide()}};return r},buildHierarchy:function(e,t,i,o,n){var s="idvc2_hierarchy_caption",r="idvc2_hierarchy_expanded";function a(e,t,i){if(e&&t){var o=t.children;Array.isArray(o)&&o.forEach((function(o){var n=function(e,t){var i,o,n,r=document.createElement("div");return t?(r.className=s,(o=document.createElement("div")).className="idvc2_hierarchy_container",o.appendChild(r),(i=document.createElement("div")).className="idvc2_hierarchy_body",o.appendChild(i),n=o):(r.className="idvc2_hierarchy_leaf",n=r),e.appendChild(n),{expand:r,body:i,container:o}}(e,o.hasChildren||o.children&&o.children.length),l=i(n,o,t),d=n.expand;l||(o.expanded&&d.classList.add(r),o.className&&d.classList.add(o.className)),o.expanded?a(n.body,c(o),i):d.hierarchicalObj=o}))}}var l=m(e);function c(e){var i=e;return"function"==typeof t&&(i=t(e!==t?e:void 0)),i}i=i||function(e,t){if(e&&e.expand&&t){var i=e.expand;(t.html||t.displayName)&&(i.innerHTML=t.html||t.displayName)}};var d=c(t);return Array.isArray(d)&&(d={children:d}),a(l,d,i),function(e,t,o){t=t||function(){return!1},o=o||function(){},(e=e||document).addEventListener("click",(function(e){for(var n=(e=e||window.event).target;n&&n.classList&&!n.classList.contains(s);)n=n.parentNode;n&&n.classList&&n.classList.contains(s)&&!t(n,n.classList.contains(r),e.target)&&(n.hierarchicalObj&&(a(n.nextElementSibling,c(n.hierarchicalObj),i),delete n.hierarchicalObj),n.classList.toggle(r),o(n))}))}(l,o,n),l},getTextWidth:function(e,t){var i=document.createElement("div");i.className="idvc2_grid_popup",I(e,i),document.body.appendChild(i);var o=i.offsetWidth;return document.body.removeChild(i),o},disableElement:P,makeCaption:function(e,t){var i="<b>"+e+"</b>";return t&&(i+=" ("+t+")"),i},setFont:M,changeCursor:function(e){var t=document.createElement("div");t.style.overflow="hidden",t.style.position="absolute",t.style.left="0",t.style.top="0",t.style.width="100%",t.style.height="100%";var i=document.createElement("div");i.style.width="120%",i.style.height="120%",t.appendChild(i),document.body.appendChild(t),i.style.cursor=e,t.scrollLeft=1,t.scrollLeft=0,document.body.removeChild(t)},em2px:E,addClass:function(e,t){if(e&&t){var i=e.className.split(" "),o=t.split(" ").filter((function(e){return-1===i.indexOf(e)})).join(" ");o.length&&(e.className+=" "+o)}},removeClass:function(e,t){if(e&&t){var i=t.split(" ");e.className=e.className.split(" ").filter((function(e){return-1===i.indexOf(e)})).join(" ")}},getParentByClass:function(e,t){for(;e&&e.classList&&!e.classList.contains(t);)e=e.parentElement;return e},animate:function(e,t){var i,o=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame;o&&o((function n(s){if(i){var r=s-i;e(r)?o(n):t&&t(r)}else i=s,o(n)}))},dispatchMouseEvent:L,dispatchElementMouseEvent:function(e,t){if(t){var i=p(t);L({x:i.x+i.width/2,y:i.y+i.height/2},e,t)}},disableHover:function(e){e&&!e.classList.contains(R)&&e.classList.add(R)},enableHover:function(e){e&&e.classList.remove(R)},createAsyncCall:D,consoleLog:N,applyObjectProperties:z,copyObject:function e(t,i,o){t&&i&&"object"==typeof i&&(o=o||function(e){return e},Object.getOwnPropertyNames(t).forEach((function(n){let s=t[n];var r,a;if(!((a=(r=n).length)>4&&"_"===r[0]&&"_"===r[1]&&"_"===r[a-1]&&"_"===r[a-2]||"function"==typeof s))if(s=o(s,n),"object"==typeof s){if(null===s||B(s))return;i[n]||(Array.isArray(s)?i[n]=[]:i[n]={}),e(s,i[n],o)}else i[n]=s})))},isHTMLNode:B,createSequence:function(){var e,t=-1,i=-1,o=!1,n=!1,s=[],r=void 0;function a(){s.length=0,t=i=-1,n=!1,e=void 0,o=!1,r=void 0}function l(s){s&&(n=!1,o=!0,t++,i=t,void 0!==e?s(e):s())}function c(e){this.end(e())}return{do:function(e){if(e)return s.splice(i+1,0,e),i++,o||l(e),this},do_:function(e){return this.do(c.bind(this,e))},end:function(i){if(o)return e=i,o=!1,t<s.length-1?l(s[t+1]):(r&&!n&&r(),a()),this},end_:function(e){return setTimeout(this.end.bind(this,e),0),this},nextStep:function(e){return n?this.end():(setTimeout(e,0),this)},cancel:function(){return o?(n=!0,s.splice(t+1)):a(),this},canceled:function(){return n},isActive:function(){return!!s.length},forEach:function(e,t,i){if(Array.isArray(e)){i=i||e.length;var o=e.length,s=0;o>i?function e(){n?this.end():(r(),s+=i,(o-=i)>0?this.nextStep(e.bind(this)):this.end())}.call(this):(r(),this.end())}function r(){for(var n=s,r=s+Math.min(o,i);n<r;n++)t(e[n],n,e)}},wait(e){return e&&e(),new Promise((e=>{this.isActive()?r=function(t){t&&t(),e(!0)}.bind(void 0,r):e(!0)}))}}},createCounter:function(e){var t=e=e||0;return{next:function(){return++t<e&&(t=++e),t},get:function(){return t}}},removeAllChildren:V,addWindowResizeListener:function(e,t){t=t||{height:!0,width:!0};var i=g.bind(void 0,e,t);return window.addEventListener("resize",i,!1),{remove:function(){window.removeEventListener("resize",i,!1),i=void 0}}},toast:function(e,t,i){t=t||document.body,i=i||{top:"1em"};var o=l(e,"idvc2_toast","");z(o.style,i),(t=P(t,"",void 0,!0)).disabler.classList.add("idvc2_toast_holder"),t.disabler.appendChild(o);var n=!1,s=!1;function r(e){(e||!n&&s)&&(o.classList.remove("toast-show"),setTimeout((function(){t&&(t.end(),t=void 0)}),400))}setTimeout((function(){o.classList.add("toast-show")}),0);var a=setTimeout((function(){s=!0,r()}),5400);o.addEventListener("mouseenter",(function(){n=!0}),!1),o.addEventListener("mouseleave",(function(){n=!1,r()}),!1),t.disabler.addEventListener("click",(function(e){clearTimeout(a),r(!0),e.stopPropagation(),e.preventDefault()}),!1)},ScrolledHolder:G,getWheelCoef:function(){return"webkit"===o.engine?100:30}}},61333:()=>{function e(e,t){if(!e)return;const i=e.querySelector("#patternTable"),o=t.gather;if(!o||o.length<=0)return;let n=!1;for(let e=0,t=o.length;e<t;e++){const t=o[e];if(t&&i){const o=i.insertRow(e+1);o.insertCell(0).innerHTML='<a href="drilldown:'+t.sites+'-0">'+t.variable+"</a>",o.insertCell(1).innerHTML=t.pattern}-1!=t.pattern.toLowerCase().indexOf("constant (non-unit)")&&(n=!0)}const s=e.querySelector("#custom_text1");s&&s.Visible(n);const r=e.querySelector("#custom_text2");r&&r.Visible(n)}window.rec_gather_scatter_info_c=e,window.rec_gather_scatter_info_f=e},61525:e=>{e.exports=' <h4>Inefficient data transfer present</h4> <div class="text"> %kernel_bounded_by% When this kernel is offloaded, the data transfer might not be efficient and might decrease performance. For computations that run on a GPU, you should minimize data transfers between host and target devices. </div> '},61716:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",[t("idvc-bar-chart",{attrs:{"chart-data":e.data,horizontal:"","bar-gap":.05,"bar-width":.15,"value-labels":""},on:{"axis-width":e.setAxisLabelWidth}}),e._v(" "),t("label",{ref:"axisLabel"},[t("span",{attrs:{mem:""}},[e._v("\n      "+e._s(e.$t("transferred_data_hint"))+"\n    ")]),e._v(" "),e.data.series.length>1?t("span",{attrs:{tax:""}},[e._v("\n      "+e._s(e.$t("tax_hint"))+"\n    ")]):e._e()])],1)};o._withStripped=!0;var n=i(14224);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"1c3dbae9",null).exports},61913:e=>{e.exports=' <h4>Use the Intel short vector math library for vector intrinsics</h4> <div class="text"> <div class="promo">Your application calls scalar instead of vectorized versions of math functions. To fix: Do all of the following: <ul> <li> Use the <samp class="codeph">-mveclibabi=svml</samp> compiler option to specify the Intel short vector math library ABI type for vector instrinsics. </li> <li> Use the <samp class="codeph">-ftree-vectorize</samp> and <samp class="codeph">-funsafe-math-optimizations</samp> compiler options to enable vector math functions. </li> <li> Use the <samp class="codeph">-L/path/to/intel/lib</samp> and <samp class="codeph">-lsvml</samp> compiler options to specify an SVML ABI-compatible library at link time. </li> </ul> <p class="expander">Example</p> <pre class="essential"><code class="bash">gfortran PROGRAM.FOR -O2 -ftree-vectorize -funsafe-math-optimizations -mveclibabi=svml -L/opt/intel/lib/intel64 -lm -lsvml -Wl,-rpath=/opt/intel/lib/intel64</code></pre> <div class="expansion"> <pre><code class="bash">gfortran PROGRAM.FOR -O2 -ftree-vectorize -funsafe-math-optimizations -mveclibabi=svml -L/opt/intel/lib/intel64 -lm -lsvml -Wl,-rpath=/opt/intel/lib/intel64</code></pre> <pre><code class="fortran">program main\n    parameter (N=100000000)\n    real*8 angles(N), results(N)\n    integer i\n    call srand(86456)\n\n    do i=1,N\n        angles(i) = rand()\n    enddo\n\n    ! the loop will be auto-vectorized\n    do i=1,N\n        results(i) = cos(angles(i))\n    enddo\n\nend</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://gcc.gnu.org/onlinedocs/gfortran/">The GNU Fortran Compiler</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},62067:e=>{e.exports={VisualisationType:{vtMessages:1,vtData:2,vtCurrent:"vtMessages|vtData",_names:["vtMessages","vtData"],id2name:{1:"vtMessages",2:"vtData"}},VisualisationChange:{vcUnknown:0,vcCollectionStarting:1,vcCollectionStarted:2,vcFinalizationStarted:4,vcCollectionCanceled:8,vcResultLoading:16,vcShowNoData:32,vcResultClosing:64,vcRefinalization:128,vcShowRecommendations:256,_names:["vcUnknown","vcCollectionStarting","vcCollectionStarted","vcFinalizationStarted","vcCollectionCanceled","vcResultLoading","vcShowNoData","vcResultClosing","vcRefinalization","vcShowRecommendations"],id2name:{0:"vcUnknown",1:"vcCollectionStarting",2:"vcCollectionStarted",4:"vcFinalizationStarted",8:"vcCollectionCanceled",16:"vcResultLoading",32:"vcShowNoData",64:"vcResultClosing",128:"vcRefinalization",256:"vcShowRecommendations"}}}},62424:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(31129),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},62728:e=>{e.exports=' <h4>Inefficient gather/scatter instructions present</h4> <span class="essential"> The compiler assumes indirect or irregular stride access to data used for vector operations. </span> <span class="expansion"> Improve memory access by alerting the compiler to detected regular stride access patterns, such as: <br/> <table> <tr> <th>Pattern</th> <th>Description</th> </tr> <tr> <td>Invariant</td> <td>The instruction accesses values in the same memory throughout the loop.</td> </tr> <tr> <td>Uniform (Horizontal Invariant)</td> <td>The instruction accesses values in the same memory within the vector iteration.</td> </tr> <tr> <td>Vertical Invariant</td> <td>The instruction accesses the memory locations using the same offset across all vector iterations.</td> </tr> <tr> <td>Unit</td> <td>The instruction accesses values in contiguous memory throughout the loop, and the stride between vector iterations = vector length.</td> </tr> <tr> <td>Constant (Non-Unit)</td> <td>The instruction accesses the memory locations using the same stride between iterations.</td> </tr> </table> </span> '},63047:(e,t,i)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const o=i(75337),n=i(60970),s={props:{view:{type:String,required:!0},type:{type:String,validator:e=>[n.GUIDE_SPLITTER,n.PANEL_SPLITTER].includes(e),required:!0}},computed:{...(0,o.mapGetters)("layout",["getGuideSplitterDirection","getPanelSplitterDirection"]),direction(){return this.type===n.GUIDE_SPLITTER?this.getGuideSplitterDirection(this.view):this.getPanelSplitterDirection(this.view)}}};t.A=s},63275:e=>{e.exports=' <h4>Refactor code with detected regular stride access patterns</h4> <div class="text"> <div class="promo"> The Memory Access Patterns Report shows the following regular stride access(es): <table id="patternTable"> <tr> <th>Variable</th> <th>Pattern</th> </tr> </table> </div> <p> See details in the Memory Access Patterns Report Source Details view. </p><p> To improve memory access: Refactor your code to alert the compiler to a regular stride access. Sometimes, it might be beneficial to use the <samp class="codeph">ipo/Qipo</samp> compiler option to enable interprocedural optimization (IPO) between files. </p><p id="custom_text1"> An array is the most common type of data structure containing a contiguous collection of data items that can be accessed by an ordinal index. You can organize this data as an array of structures (AoS) or as a structure of arrays (SoA). Detected constant stride might be the result of AoS implementation. While this organization is excellent for encapsulation, it can hinder effective vector processing. To fix: Rewrite code to organize data using SoA instead of AoS. </p><p id="custom_text2"> However, the cost of rewriting code to organize data using SoA instead of AoS may outweigh the benefit. To fix: Use Intel SIMD Data Layout Templates (Intel SDLT), introduced in version 16.1 of the Intel compiler, to mitigate the cost. Intel SDLT is a C++11 template library that may reduce code rewrites to just a few lines. </p> <p class="expander">Example: Refactor for Vertical Invariant pattern</p> <pre class="expansion"><code class="cpp">// main.cpp\nint a[8] = {1,0,5,7,4,2,6,3};\n\n// gather.cpp\nvoid test_gather(int* a, int* b, int* c, int* d)\n{\n    int i, k;\n// inefficient access\n#pragma omp simd\n    for (i = 0; i &lt; INNER_COUNT; i++)\n        d[i] = b[a[i%8]] + c[i];\n\n   int b_alt[8];\n   for (k = 0; k &lt; 8; ++k)\n        b_alt[k] = b[a[k]];\n\n// more effective version\n   for (i = 0; i &lt; INNER_COUNT/8; i++)\n   {\n#pragma omp simd\n       for(k = 0; k &lt; 8; ++k)\n           d[i*8+k] = b_alt[k] + c[i*8+k];\n   }\n}</code></pre> <p> Also make sure vector function clauses match arguments in the calls within the loop (if any). Note: You may use several <samp class="codeph">#pragma declare simd</samp> directives to tell the compiler to generate several vector variants of a function. </p> <p class="expander">Example: Compare function calls with their declarations</p> <pre class="expansion"><code class="cpp">// functions.cpp\n#pragma omp declare simd\nint foo1(int* arr, int idx) { return 2 * arr[idx]; }\n\n#pragma omp declare simd uniform(arr) linear(idx)\nint foo2(int* arr, int idx) { return 2 * arr[idx]; }\n\n#pragma omp declare simd linear(arr) uniform(idx)\nint foo3(int* arr, int idx) { return 2 * arr[idx]; }\n\n// gather.cpp\nvoid test_gather(int* a, int* b, int* c)\n{\n    int i, k;\n\n// Loop will be vectorized, for complex access patterns gathers could be used for function call.\n#pragma omp simd\n    for (i = 0; i &lt; INNER_COUNT; i++) a[i] = b[i] + foo1(c,i);\n\n// Loop will be vectorized with vectorized call\n#pragma omp simd\n    for (i = 0; i &lt; INNER_COUNT; i++) a[i] = b[i] + foo2(c,i);\n\n// Loop will be vectorized with serialized function call\n#pragma omp simd\n    for (i = 0; i &lt; INNER_COUNT; i++) a[i] = b[i] + foo3(c,i);\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-FEF23B3B-D0F6-484F-8DC5-9AB1315A6431.html">ipo, Qipo</a>; <i>omp simd</i>, <i>omp declare simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html">OpenMP* Pragmas Summary</a> </li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/memory-layout-transformations.html">Case study: Comparing Arrays of Structures and Structures of Arrays Data Layouts for a Compute-Intensive Loop</a></li> <li><a href="docs:C++/17/index.htm#GUID-F434587D-0F2D-4AC6-9D12-9988E2FDB751.html">Introduction to the Intel&reg; SIMD Data Layout Templates (Intel&reg;SDLT)</a></li> <li><a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a></li> </ul> </div>'},63382:e=>{e.exports=' <h4>Force scalar remainder generation </h4> <div class="text"> <div class="promo"> The compiler generated a masked vectorized <span data-glossary-id="remainder_loop">remainder loop</span> that contains too few iterations for efficient vector processing. A scalar loop may be more beneficial. To fix: Force scalar remainder generation using a <span data-glossary-id="directive">directive</span>: <samp class="codeph">#pragma vector novecremainder</samp>. <br/> <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n// Force the compiler to not vectorize the remainder loop\n#pragma vector novecremainder\nfor (i=0; i&lt;n; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void add_floats(float *a, float *b, float *c, float *d, float *e, int n)\n{\n    int i;\n    // Force the compiler to not vectorize the remainder loop\n    #pragma vector novecremainder\n    for (i=0; i&lt;n; i++)\n    {\n        a[i] = a[i] + b[i] + c[i] + d[i] + e[i];\n    }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-2B528C72-29B4-4DBC-8B91-EE4D1A03A850.html">vector</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},63780:e=>{e.exports=' <div class="idvc2_roofline_body_area idvc2_roofline_data_loading"> <div class="content"> <div class="idvc2_roofline_zoom_toolbar hidden4copy" id="roofline_zoom_toolbar"> <label id="roofline_cores_bar" class="br toolbar_item_bar invisible"> <div id="roofline_cores_control" class="roofline_toolbar_control"> <div id="roofline_cores_select_items" class="roofline_toolbar_control_items no_close_popup roofline_popup_shadow"> <ul id="core_number_items" class="zoom_select_items no_close_popup"></ul> </div> <span class="roofline_cores_caption">%roofline_N_threaded_roofs%</span> <span id="roofline_cores_content" class="roofline_toolbar_control_content"></span> <label class="idvc2_roofline_explanation_symbol" data-tooltip="%roofline_N_threaded_roofs_expl%">?</label> <div id="roofline_cores_select" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_select"></div> </div> </label> <label id="roofline_roofs_configuration_bar" class="br toolbar_item_bar invisible"> <div id="roofline_roofs_configuration_control" class="roofline_toolbar_control"> <div id="roofline_roofs_configuration_select_items" class="roofline_toolbar_control_items no_close_popup roofline_popup_shadow"> <ul id="roofs_configuration_items" class="zoom_select_items no_close_popup"></ul> </div> <span id="roofline_roofs_configuration_content"> </span> <div id="roofline_cores_select" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_select"> </div> </div> </label> <label id="roofline_type_bar" class="br no_data_visible toolbar_item_bar invisible"> <div id="roofline_type_control" class="roofline_toolbar_control"> <div id="roofline_type_select_items" class="roofline_toolbar_control_items no_close_popup roofline_popup_shadow"> <div id="roofline_type_select_body" class="no_close_popup auto_adjust_height"> <form class="invisible"> <label><input type="radio" class="no_close_popup" disabled="disabled"></label> </form> </div> <div class="roofline_toolbar_control_btns no_close_popup"> <button>%roofline_configuration_default%</button> <button>%roofline_configuration_apply%</button> <button>%roofline_configuration_cancel%</button> </div> </div> <span id="roofline_type_content" class="roofline_toolbar_control_content pictured"></span> <div id="roofline_type_select" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_select"></div> </div> </label> <label id="roofline_compare_bar" class="br toolbar_item_bar"> <div id="roofline_compare_control" class="roofline_toolbar_control"> <div id="roofline_compare_select_items" class="roofline_toolbar_control_items no_close_popup roofline_popup_shadow auto_adjust_height"> <span id="load_compare" data-tooltip="%roofline_toolbar_load_compare%" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_compare no_close_popup no_report"></span> <div class="roofline_toolbar_control_caption roofline_group_caption_colors no_report"> %roofline_compare_results_label% <span id="delete_compare" data-tooltip="%roofline_toolbar_clear_compare%" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_cross no_close_popup no_report disabled idvc2_roofline_clear_compare"></span> </div> <ul id="loaded_compare_items" class="zoom_select_items pictured no_close_popup"></ul> <div class="roofline_toolbar_control_caption roofline_group_caption_colors no_report"> %roofline_compare_recent_label% </div> <ul id="ready_compare_items" class="zoom_select_items no_report no_close_popup"></ul> </div> <span id="roofline_compare_content" class="roofline_toolbar_control_content pictured">%roofline_compare_nodata_label%</span> <div id="roofline_compare_select" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_select"></div> </div> </label> <label id="roofline_guidance_bar" class="br toolbar_item_bar"> <div id="roofline_guidance_control" class="roofline_toolbar_control"> <div id="roofline_guidance_select_items" class="roofline_toolbar_control_items no_close_popup roofline_popup_shadow"> <div class="auto_adjust_height"> <div id="roofline_guidance_select_body" class="no_close_popup"></div> <div id="roofline_guidance_image_body" class="roofline_toolbar_image no_close_popup"></div> </div> <div id="roofline_guidance_buttons_body" class="roofline_toolbar_control_btns no_close_popup"> <button>%roofline_configuration_default%</button> <button>%roofline_configuration_apply%</button> <button>%roofline_configuration_cancel%</button> </div> </div> <span id="roofline_guidance_content" class="roofline_toolbar_control_content pictured">%roofline_toolbar_guidance_label%</span> <div id="roofline_guidance_select" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_select"></div> </div> </label> <label id="copy_content_control" class="no_report"> <div id="copy_content" data-tooltip="%roofline_toolbar_html_export%" class="idvc2_roofline_tool_button idvc2_alt idvc2_roofline_icon idvc2_roofline_export"></div> <div id="copy_content_select" class="idvc2_roofline_zoom_button idvc2_roofline_icon idvc2_roofline_select idvc2_roofline_cling_button"> <ul id="copy_content_items" class="zoom_select_items roofline_popup_shadow radio extra_space"> <li id="export_as_html" class="selected splitter">%roofline_toolbar_html_export%</li> <li id="export_as_svg">%roofline_toolbar_svg_export% <label class="invisible"><input type="text" class="no_close_popup" disabled="disabled"></label> <br><label class="zoom_select_prop">%roofline_toolbar_svg_width%<input type="text" width="true" class="zoom_select_prop_input no_close_popup"></label> <br><label class="zoom_select_prop">%roofline_toolbar_svg_height%<input type="text" class="zoom_select_prop_input no_close_popup"></label> </li> </ul> </div> </label> <div id="expand_toolbar_content" class="idvc2_roofline_expand_button idvc2_roofline_icon idvc2_roofline_expand"> </div> </div> <div class="idvc2_roofline_menu_toolbar hidden4copy"> <div id="roofline_menu_button" data-tooltip="%roofline_toolbar_properties%" class="idvc2_roofline_tool_button idvc2_alt idvc2_roofline_icon idvc2_roofline_gear"></div> </div> <div class="idvc2_roofline_zoom_toolbar hidden4copy vert" id="roofline_zoom_toolbar_vert"> <span id="select_point" data-tooltip="%roofline_toolbar_select_point%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_cursor"></span> <span id="select_hand" data-tooltip="%roofline_toolbar_select_move%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_hand"></span> <span id="select_zoom" data-tooltip="%roofline_toolbar_select_zoom%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_magnifier"></span> <span id="zoom_in" data-tooltip="%roofline_toolbar_zoomin%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_zoomin"></span> <span id="zoom_out" data-tooltip="%roofline_toolbar_zoomout%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_zoomout"></span> <span id="cancel_zoom" data-tooltip="%roofline_toolbar_cancel_zoom%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_zoom_cancel"></span> <span id="undo_zoom" data-tooltip="%roofline_toolbar_undo%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_undo"></span> <span id="redo_zoom" data-tooltip="%roofline_toolbar_redo%" class="idvc2_roofline_tool_button idvc2_roofline_icon idvc2_roofline_redo"></span> <div id="expand_toolbar_content_vert" class="idvc2_roofline_expand_button idvc2_roofline_icon idvc2_roofline_expand vert"> </div> </div> <div class="idvc2_roofline_settings_holder"> <div class="idvc2_roofline_settings" id="roofline_settings"> <div class="settings_title roofline_group_caption_colors"> %roofline_settings_representation_caption% </div> <div class="single_settings_item roofline_view_mode_setting" id="roofline_view_mode"> <label class="radio_settings_item"> <input type="radio" class="" name="rooflineviewmode" value="fittoview">%roofline_settings_fit_to_view% <label class="idvc2_roofline_explanation_symbol" data-tooltip="%roofline_settings_fit_to_view_expl%">?</label> </label> <label class="radio_settings_item"> <input type="radio" class="" name="rooflineviewmode" value="onewideview">%roofline_settings_one_view% <label class="idvc2_roofline_explanation_symbol" data-tooltip="%roofline_settings_one_view_expl%">?</label> </label> </div> <label class="single_settings_item roofline_histogram_setting"> <input type="checkbox" class="toolbar_item_input" id="show_roofline_histogram">Show Roofline Histogram </label> <div class="settings_title roofline_group_caption_colors">%roofline_settings_roofs_caption%</div> <label class="single_settings_item roofs_strategy_setting invisible"> <input type="checkbox" class="toolbar_item_input" id="use_single_thread_strategy">%roofline_settings_use_single_thread_strategy% <label class="idvc2_roofline_explanation_symbol" data-tooltip="%roofline_settings_use_single_thread_strategy_expl%">?</label> </label> <table id="roofs_table" class="roofs_table"> <thead> <tr> <th>%roofline_settings_roof_name%</th> <th>%roofline_settings_roof_visible%</th> <th>%roofline_settings_roof_selected%</th> <th style="white-space:nowrap"><label>%roofline_settings_roof_value%</label> <button id="revert_roofs_values_settings_button">%roofline_settings_roof_default%</button> </th> </tr> </thead> <tbody id="roofs_table_body"> </tbody> </table> <div class="settings_buttons_container"> <button id="load_roofs_settings_button" class="loadsave_settings_button">%roofline_settings_roof_load%</button> <button id="save_roofs_settings_button" class="loadsave_settings_button">%roofline_settings_roof_save%</button> </div> <div class="settings_title roofline_group_caption_colors">%roofline_settings_loop_caption% </div> <div class="settings_title subtitle">%roofline_settings_loop_calculation%</div> <label class="single_settings_item loop_weight_base_value">%roofline_settings_loop_base_value% <select id="roofline_loop_weight_base"></select> </label> <div class="single_settings_item loop_weight_formula" id="roofline_loop_weight_formula"></div> <div class="settings_title subtitle">%roofline_settings_loop_ranges%</div> <table id="loops_table"> <thead> <tr> <th></th> <th align="left">%roofline_settings_loop_size%</th> <th align="left">%roofline_settings_loop_color%</th> <th>%roofline_settings_loop_range%</th> <th></th> </tr> </thead> <tbody id="loops_table_body"> </tbody> </table> <div class="settings_buttons_container"> <button id="load_loops_settings_button" class="loadsave_settings_button">%roofline_settings_roof_load%</button> <button id="save_loops_settings_button" class="loadsave_settings_button">%roofline_settings_roof_save%</button> <button id="cancel_loops_settings_button" class="loadsave_settings_button">%roofline_settings_loop_cancel%</button> <button id="revert_loops_settings_button" class="loadsave_settings_button">%roofline_settings_loop_default%</button> </div> <div class="settings_title subtitle">Points Colorization</div> <div id="roofline_color_mode"> <label class="radio_settings_item"> <input type="radio" class="" name="rooflinecolormode" value="0">Colors of Point Weight Ranges </label> <label class="radio_settings_item"> <input type="radio" class="" name="rooflinecolormode" value="1"> <span>Vectorized</span> <span class="loop_sample loop_fixed_sample small" style="background-color:orange"></span> <span class="settings_item_separator"> / </span> <span>Scalar</span> <span class="loop_sample loop_fixed_sample small" style="background-color:#3473d4"></span> </label> </div> <div class="no_self_time_item"> <label class="settings_item_caption">%roofline_settings_loop_color_nst% <div class="loop_sample loop_fixed_sample" id="roofline_nst_loop_color_sample"></div> <input class="color_input" id="roofline_nst_loop_color_edit"> </label> </div> </div> </div> <div class="idvc2_roofline_summary hidden4copy" id="roofline_summary"> <label class="br" id="cores" name="summary_item"> <span class="summary_caption">%roofline_physical_cores_count%</span> <span id="value" class="summary_value"></span> <label class="idvc2_roofline_explanation_symbol" data-tooltip="%roofline_cores_expl%">?</label> </label> <label class="br" id="used_threads" name="summary_item"> <span class="summary_caption">%roofline_used_threads_count%</span> <span id="value" class="summary_value"></span> <label class="idvc2_roofline_explanation_symbol" data-tooltip="%roofline_threads_expl%">?</label> </label> <label class="br" id="self" name="summary_item"> <span id="name" class="summary_caption"></span> <span id="value" class="summary_value flash"></span> <span id="measure" class="summary_measure"></span> </label> <label class="br" id="total" name="summary_item"> <span id="name" class="summary_caption"></span> <span id="value" class="summary_value flash"></span> <span id="measure" class="summary_measure"></span> </label> <div id="expand_summary_content" class="idvc2_roofline_expand_button idvc2_roofline_icon idvc2_roofline_expand"></div> </div> <div class="idvc2_roofline_main_area" id="roofline_content"> </div> <div class="idvc2_roofline_zoom_button idvc2_roofline_icon frame_settings hidden4copy" id="roofline_frame_settings"> </div> <div class="frame_settings_cover frame_settings_area"> </div> <div class="frame_settings_axis idvc2_roofline_vert frame_settings_area"> <input class="frame_settings_input" id="frame_max_perf"> <input class="frame_settings_input" id="frame_min_perf"> </div> <div class="frame_settings_axis idvc2_roofline_horz frame_settings_area"> <input class="frame_settings_input" id="frame_min_intens"> <input class="frame_settings_input" id="frame_max_intens"> </div> <div class="frame_settings_corner frame_settings_area"> <button class="frame_settings_button idvc2_roofline_icon idvc2_roofline_ok" id="frame_apply_btn"></button> <button class="frame_settings_button idvc2_roofline_icon idvc2_roofline_cross" id="frame_cancel_btn"></button> </div> </div> <div class="idvc2_roofline_data_loading_message" id="roofline_data_loading_message">%no_data%</div> <div class="idvc2_roofline_no_data_message_container"> <div class="idvc2_roofline_no_data_message"> <div class="idvc2_roofline_no_data_message_title"></div> <div class="idvc2_roofline_no_data_message_content"></div> </div> <div class="idvc2_roofline_no_data_message_report">%no_data%</div> </div> </div> '},63814:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>a});var o=function(){var e=this,t=e._self._c;return t("layout-panel-card",{class:e.type,style:e.flex,attrs:{type:e.type}},[t("div",{staticClass:"hotspots-data"},[t("table",[t("tr",e._l(e.columns,(function({title:i,tooltip:o},n){return t("th",{key:n},[e._v("\n          "+e._s(i)+"\n          "),o?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:o,expression:"tooltip"}],staticClass:"icon help-circle"}):e._e()])})),0),e._v(" "),e._l(e.rows,(function(i,o){return t("tr",{key:o},e._l(i,(function(i,n){return t("td",{directives:[{name:"tooltip",rawName:"v-tooltip",value:0===n?i:null,expression:"i === 0 ? col : null"}],key:n,class:{link:0==n},on:{click:function(t){return e.onDrillDown(t,o,n)}}},[e._v("\n          "+e._s(i?i.value||i:"")+"\n          "),e.columns[n].maxValue?t("simple-bar-chart",{staticClass:"bar-chart",attrs:{value:i/e.columns[n].maxValue,color:e.columns[n].color,values:i.values,colors:i.colors,small:""}}):e._e()],1)})),0)}))],2)])])};o._withStripped=!0,i(36094);var n=i(75337),s=i(1067);const r={props:{type:{type:String,validator:e=>"string"==typeof e&&s.TYPES.includes(e),required:!0}},computed:{...(0,n.mapGetters)("gpu",["getTopHotspotsData"]),data(){return this.getTopHotspotsData(this.type)},columns(){return this.data.columns},rows(){return this.data.rows},selectionId(){return`gpu/main/${this.type}Selection`},flex(){return{flex:[{[s.GPU]:1,[s.CPU]:1},{[s.GPU]:1,[s.CPU]:4},{[s.GPU]:4,[s.CPU]:1},{[s.GPU]:2,[s.CPU]:1}][2*+(this.getTopHotspotsData(s.GPU).rows.length>0)+ +(this.getTopHotspotsData(s.CPU).rows.length>0)][this.type]}}},methods:{async onDrillDown(e,t,i){i>0||(e&&e.target&&(e.target.style.color="#865cac"),this.$store.direct.commit.setSelection({id:this.selectionId,senderId:"gpuSummary",rowId:this.data.rowIds[t]}),await this.$nextTick(),this.$router.push({name:"gpu:main",params:{panelName:`${this.type}-grid`}}).catch((({message:e})=>console.error(e))))}}},a=(0,i(98822).A)(r,o,[],!1,null,"74a9e3f0",null).exports},64098:e=>{e.exports=' <h4>Parallelize the loop with both threads and SIMD instructions</h4> <div class="text"> <div class="promo"> The loop is threaded and auto-vectorized; however, the <span data-glossary-id="trip_count">trip count</span> is not a multiple of <span data-glossary-id="vector_length">vector length</span>. To fix: Do all of the following: <ul> <li> Use the <samp class="codeph">!$omp parallel do simd</samp> directive to parallelize the loop with both threads and SIMD instructions. Specifically, this directive divides loop iterations into chunks (subsets) and distributes the chunks among threads, then chunk iterations execute concurrently using SIMD instructions. </li> <li> Add the <samp class="codeph">schedule(simd: [kind])</samp> modifier to the directive to guarantee the chunk size (number of iterations per chunk) is a multiple of <span data-glossary-id="vector_length">vector length</span>. </li> </ul> <p class="expander">Example (original code)</p> <pre class="expansion"><code class="fortran">!$omp parallel do schedule(static)\ndo i = 1,1000\n    c(i) = a(i)*b(i)\nend do\n!$omp end parallel do</code></pre> </div> <p class="expander">Example (revised code)</p> <pre class="expansion"><code class="fortran">!$omp parallel do simd schedule(simd: static)\ndo i = 1,1000\n    c(i) = a(i)*b(i)\nend do\n!$omp end parallel do simd</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="http://www.openmp.org/mp-documents/openmp-4.5.pdf">OpenMP Application Programming Interface </a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},64413:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=i(93580),n=i.n(o),s={};for(const e in o)"default"!==e&&(s[e]=()=>o[e]);i.d(t,s);const r=n()},64917:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>l});var o=function(){var e=this,t=e._self._c;return t("section",{staticClass:"remodel-run-panel"},[t("run-panel",{attrs:{commands:e.commands,analysisTypes:e.analysisTypes},scopedSlots:e._u([{key:"default",fn:function({cmd:t}){return[e._v("\n      "+e._s(e.buttonCaption(t))+"\n    ")]}}])})],1)};o._withStripped=!0;var n=i(78052),s=i(32095),r=i(84620);const a={props:{regionId:{type:Object}},methods:{buttonCaption(e){const t={};return t[s.CommandType.ctRunCollection]="re_model",this.$t(t[e])}},computed:{commands:()=>[s.CommandType.ctRunCollection],analysisTypes:()=>[r.ActivityType.atProjection]},components:{RunPanel:n.default}},l=(0,i(98822).A)(a,o,[],!1,null,"1815b728",null).exports},64978:e=>{e.exports=' <h4>Possible inefficient conflict-detection instructions present</h4> <span class="essential"> Stores with indirect addressing caused the compiler to assume a potential dependency. </span> <span class="expansion"> This resulted in the use of conflict-detection instructions during SIMD processing, such as the AVX-512 vpconflict instruction, which detects duplicate values within a vector and creates conflict-free subsets. Improve performance by removing the need for conflict-detection instructions. <p class="expander">Explanation</p> <p class="expansion"> Assume a vector length equal to 4. Two elements are conflict-free; two elements conflict (these values are stored to the same memory address). The vpconflict instruction checks the conflict and creates a mask for the vector register that is applied during SIMD processing. This mask ensures only two conflict-free elements are computed during vector processing; the other two elements are processed separately (and ignored during vector processing) to avoid unsafe behavior or an incorrect result. The loop is re-executed for any masked-out lanes. </p> </span>'},65196:(e,t,i)=>{"use strict";i.d(t,{A2:()=>o,HH:()=>s,PO:()=>c,Ze:()=>n,aD:()=>r,lG:()=>d,pN:()=>a,qn:()=>l});const o="available",n="running",s="paused",r="scheduled",a="unscheduled",l="collected",c="error",d="warning"},65238:e=>{e.exports=' <h4>Private memory usage present</h4> <div class="essential"> %disclaimer% This code region uses private memory. The size of the private memory region is %gpu_private_memory_size% bytes per hardware thread. <br><br> Private variables not allocated into <span data-glossary-id="GRF">GRF</span> are promoted to an additional private memory region. The region is slow in comparison with registers and usually decreases the performance. </div> '},65348:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{directives:[{name:"show",rawName:"v-show",value:!e.message.hidden,expression:"!message.hidden"}],staticClass:"message-box"},[t("message-image",{staticClass:"big",attrs:{type:e.message.imageType,animation:e.message.animation,classes:e.imageClasses}}),e._v(" "),t("div",{staticClass:"message-body"},[t("message-text",{staticClass:"message-title",attrs:{text:e.message.title}}),e._v(" "),e.messageContent?t("div",{staticClass:"message-item"},[e.simpleMessage?t("message-text",{attrs:{text:e.message.text},on:{linkClick:e.onLinkClick}}):e._l(e.message.textItems,(function(i,o){return t("message-text-item",{key:i.briefText+o,attrs:{textItem:i},on:{linkClick:e.onLinkClick}})})),e._v(" "),e.message.optionCaption?t("div",{staticClass:"message-item"},[t("input",{attrs:{type:"checkbox",id:e.optionId},domProps:{checked:e.message.optionState},on:{input:e.onChangeOption}}),e._v(" "),t("message-text",{staticClass:"input-caption",attrs:{for:e.optionId,text:e.message.optionCaption},on:{linkClick:e.onLinkClick}})],1):e._e(),e._v(" "),t("message-buttons",{staticClass:"message-box-buttons",attrs:{buttons:e.message.buttons},on:{"button-click":e.onButtonClick}})],2):t("div",{staticClass:"message-item"},[t("div",{staticClass:"progress-holder"},[t("progress",{attrs:{max:e.progressMax},domProps:{value:e.progressValue}}),e._v(" "),t("message-buttons",{attrs:{buttons:e.message.buttons},on:{"button-click":e.onCanceled}})],1),e._v(" "),t("message-text",{attrs:{text:e.message.text}})],1)],1)],1)};o._withStripped=!0;var n=i(12168);const s={props:{message:{type:Object,required:!0}},mixins:[n.default],data:()=>({imageClasses:["information-circle","check-circle","alert-triangle","cross-circle",["information-circle","gray"],["check-circle","gray"],["alert-triangle","gray"],["cross-circle","gray"]]}),computed:{simpleMessage(){return!this.message.textItems},messageContent(){return"gaugeBox"!==this.message.type},min(){return this.message.min||0},max(){return this.message.max||100},progressMax(){return this.max-this.min},progressValue(){return this.message.val||this.min},optionId(){return"optionInput"+this.message.id}},methods:{onButtonClick(e){this.sendNotification(this.getEvent("buttonPressed",{id:+e}))},onCanceled(){this.sendNotification(this.getEvent("gaugeCanceled"))},onLinkClick(e){this.sendNotification(this.getEvent("linkClicked",{linkText:e}))},onChangeOption(e){this.sendNotification(this.getEvent("optionChanged",{state:e.target.checked}))},getEvent(e,t){const i={messageBoxId:this.message.id,type:this.message.type,notification:e};return t&&(i.data=t),i},sendNotification(e){this.$emit("notify",e)}}},r=(0,i(98822).A)(s,o,[],!1,null,"e90a5a68",null).exports},65350:()=>{function e(e,t){if(!e)return;const i=e.querySelector("#disclaimer");i&&i.Visible(t.disclaimer)}function t(e,t){if(!e)return;const i=e.querySelector("#no_tripcounts_disclaimer"),o=e.querySelector("#actions");i&&o&&(i.Visible(t.no_tripcounts_disclaimer),o.Visible(!t.no_tripcounts_disclaimer))}function i(e,t){if(!e)return;const i=e.querySelector("#no_dependency_disclaimer"),o=e.querySelector("#actions");i&&o&&(i.Visible(t.no_dependency_disclaimer),o.Visible(!t.no_dependency_disclaimer))}function o(e,t){if(!e)return;const i=e.querySelector("#no_map_disclaimer"),o=e.querySelector("#actions");i&&o&&(i.Visible(t.no_map_disclaimer),o.Visible(!t.no_map_disclaimer))}window.rec_need_for_simd_complex_loop_vectorization_c=e,window.rec_need_for_simd_complex_loop_vectorization_f=e,window.rec_need_for_simd_outer_vectorization_inner_not_vectorized_c=e,window.rec_need_for_simd_outer_vectorization_inner_not_vectorized_f=e,window.rec_need_for_simd_outer_vectorization_instead_of_inner_c=e,window.rec_need_for_simd_outer_vectorization_instead_of_inner_f=e,window.rec_need_for_simd_run_trip_count_c=t,window.rec_need_for_simd_run_trip_count_f=t,window.rec_need_for_simd_run_correctness_c=i,window.rec_need_for_simd_run_correctness_f=i,window.rec_need_for_simd_run_map_c=o,window.rec_need_for_simd_run_map_f=o},65412:function(e,t,i){"use strict";i(27468),i(69212),i(43468),i(38333),i(21602),i(32204);var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});const n=i(75337),s=o(i(34919)),r=o(i(14624)),a=i(60970),l={props:{view:{type:String,required:!0},guide:{type:Object,required:!0},panels:{type:Array,required:!0},size:String},computed:{...(0,n.mapGetters)("layout",["getGuideFlexDirection"]),guideFlexDirection(){return this.getGuideFlexDirection(this.view)},flex(){return(0,a.sizeToFlex)(this.size)}},render(e){const{view:t,panels:i,guideFlexDirection:o,flex:n}=this,{createGuide:s,createGuideWrapper:r}=this,l=this.$parent,c=i.filter((({type:e,panelState:t})=>e===a.TYPE_PLACEHOLDER||t===a.STATE_NORMAL)).map((({type:i,tabs:o,optionsSlot:n,searchSlot:s,...r})=>{if(i===a.TYPE_PANEL){const{slot:i}=o.find((e=>e.tabState===a.STATE_ACTIVE)),c={search:l.$scopedSlots[s],options:l.$scopedSlots[n]};return((t,i,o)=>e("layout-panel",{props:t,ref:"panel",refInFor:!0,scopedSlots:i},[o]))({view:t,layout:l,tabs:o,...r},c,i)}return c={view:t,type:a.PANEL_SPLITTER},e("layout-placeholder",{props:c,ref:"placeholder",refInFor:!0});var c})).reduce(((i,o,n,s)=>{return n<s.length-1?i.concat(o,(r={view:t,type:a.PANEL_SPLITTER,prevElement:o,nextElement:s[n+1]},e("layout-splitter",{props:r}))):i.concat(o);var r}),[]),d=i.filter((({panelState:e})=>e===a.STATE_COLLAPSED)),p=d.length>0&&e("collapsed-list",{props:{view:t,panels:d}});if(c.length>0&&d.length>0){if(o===a.DIRECTION_COLUMN)return s(e,[p,c],{"flex-direction":o,flex:n});{const t={flex:n},i=s(e,[c],{"flex-direction":o});return r(e,[p,i],t)}}return c.length>0?s(e,[c],{"flex-direction":o,flex:n}):r(e,[p],{flex:0})},methods:{createGuide:(e,t,i)=>e("div",{class:"layout-guide",style:i},t),createGuideWrapper:(e,t,i)=>e("div",{class:"guide-wrapper",style:i},t)},components:{LayoutPanel:s.default,LayoutSplitter:r.default}};t.default=l},65879:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"button route"},[t("router-link",{attrs:{to:{name:e.buttonVariable}}},[t("div",{staticClass:"line"}),e._v(" "),t("div",{staticClass:"route-arrow text"},[e._v("\n      "+e._s(e.buttonTooltip)+"\n    ")])])],1)};o._withStripped=!0;var n=i(75337);const s={mixins:[i(78281).A],props:{buttonType:{type:String,required:!0}},computed:{...(0,n.mapGetters)("header",["getButton"]),button(){return this.getButton(this.buttonType)}}},r=(0,i(98822).A)(s,o,[],!1,null,"5b596a6c",null).exports},66275:(e,t,i)=>{"use strict";function o(){this._subscribers=[]}i.d(t,{A:()=>n}),i(36094),i(69212),i(38333),o.prototype.find=function(e,t){for(var i=0,o=this._subscribers.length;i<o;i++)if(e===this._subscribers[i].obj&&(t===this._subscribers[i].funct||void 0===t&&void 0===this._subscribers[i].funct))return i;return-1},o.prototype.subscribe=function(e,t){this.find(e,t)<0&&this._subscribers.push({obj:e,funct:t})},o.prototype.unsubscribe=function(e,t){var i=this.find(e,t);i>=0&&this._subscribers.splice(i,1)},o.prototype.unsubscribeAll=function(e){for(var t=this._subscribers.length-1;t>=0;t--)e===this._subscribers[t].obj&&this._subscribers.splice(t,1)},o.prototype.raise=function(){for(var e=0;e<this._subscribers.length;e++){var t=this._subscribers[e].obj||window;this._subscribers[e].funct?this._subscribers[e].funct.apply(t,arguments):t.raise&&t.raise.apply(t,arguments)}},o.prototype.clear=function(){this._subscribers.length=0};const n={create:function(){return new o}}},66327:e=>{e.exports=' <h4>Insufficient parallel work</h4> <div class="text"> %disclaimer% <span id="thread_occupancy_percent">The code region occupies %thread_occupancy_percent% of all <span id="thread_slots_all"> %thread_slots% </span> thread slots available on the hardware. </span> <br>The number of work items in this code region is %global_work_items_count%<span id="global_work_size"> (global work size is %global_work_size%)</span>. <span id="threads"> <span id="with_SIMD"> With SIMD width %gpu_current_row_simd_width%, the work items are distributed over %thread_issued_per_compute_task_count% threads on the device, which corresponds to less than 1 thread per execution unit<span id="eu_count"> (the target platform has %eu_count% execution units<span id="thread_slots_per_eu"> with %thread_slots_per_eu% threads per unit</span>)</span>. </span> <span id="without_SIMD"> They are distributed over %thread_issued_per_compute_task_count% threads on the device, which corresponds to less than 1 thread per execution unit<span id="eu_count"> (the target platform has %eu_count% execution units<span id="thread_slots_per_eu"> with %thread_slots_per_eu% threads per unit</span>)</span>. </span> </span> This is not enough to fully utilize parallel hardware resources, some execution units stay idle while the region is executed. </div> '},66393:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,e.items.length?t("div",{staticClass:"flops-list"},[e.isExpanded||!e.mainItem?t("div",{staticClass:"list"},[t("tree-list",{attrs:{features:e.features,items:e.items,"min-item-width":"45em"}}),e._v(" "),e._t("default")],2):t("span",{staticClass:"summary"},[t("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.mainItem.tooltip,expression:"mainItem.tooltip"}],class:{emphasize:!!e.boundedByCaption}},[e._v("\n      "+e._s(e.mainItemCaption)+":\n    ")]),e._v(" "),e.mainItem.tooltip?t("i",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.mainItem.tooltip,expression:"mainItem.tooltip"}],staticClass:"icon help-circle"}):e._e(),e._v(" "),t("div",{staticClass:"main-item"},[t("b",[e._v(e._s(e.mainItem.formattedValue))]),e._v(" "),e.showMeasure?t("span",{staticClass:"value-measure"},[e._v("\n        "+e._s(e.mainItem.formattedMaxValue)+"\n      ")]):e._e(),e._v(" "),t("span",[e._v(e._s(e.mainItem.roofName))]),e._v(" "),e.mainItem.maxValue?t("simple-bar-chart",{attrs:{value:e.mainItem.value/e.mainItem.maxValue,color:e.mainItem.color}}):e._e()],1)]),e._v(" "),e.canCollapse&&e.mainItem?t("button",{on:{click:e.onCollapse}},[t("i",{class:e.collapseIcon})]):e._e()]):e._e()};o._withStripped=!0;var n=i(83897);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"0c52f125",null).exports},66459:(e,t,i)=>{"use strict";i.r(t),i.d(t,{ALL_FEATURES:()=>s,SHOW_BAR:()=>o,SHOW_MEASURE:()=>n});const o="show_bar",n="show_measure",s=[o,n]},66929:(e,t,i)=>{var o={"./issues/gpu/custom_render.js":92771,"./issues/offload/custom_render.js":49892,"./issues/roofline_guidance/custom_render.js":77450,"./recs/cpp/custom_render.js":87311,"./recs/fma/custom_render.js":4438,"./recs/fortran/custom_render.js":1792,"./recs/gather_scatter_info/custom_render.js":61333,"./recs/gpu/custom_render.js":37260,"./recs/need_for_simd/custom_render.js":65350,"./recs/offload/custom_render.js":67587,"./recs/peel_remainder/custom_render.js":90780,"./recs/roofline_guidance/custom_render.js":21397,"./recs/sqrtdiv/custom_render.js":24975,"./recs/stl_algorithms/custom_render.js":55926,"./recs/user_function/custom_render.js":25042};function n(e){var t=s(e);return i(t)}function s(e){if(!i.o(o,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return o[e]}n.keys=function(){return Object.keys(o)},n.resolve=s,e.exports=n,n.id=66929},67052:e=>{e.exports=' <h4>Enable inline expansion</h4> <div class="text"> <p class="promo"> Inlining is disabled by compiler option. To fix: When using the <samp class="codeph">Ob</samp> or <samp class="codeph">inline-level</samp> compiler option to control inline expansion, replace the <samp class="codeph">0</samp> argument with the <samp class="codeph">1</samp> argument to enable inlining when an <samp class="codeph">inline</samp> keyword or attribute is specified or the <samp class="codeph">2</samp> argument to enable inlining of any function at compiler discretion. </p> <table> <thead> <tr> <th> Windows* OS </th> <th> Linux* OS </th> </tr> </thead> <tbody> <tr> <td> /Ob1 or /Ob2 </td> <td> -inline-level=1 or -inline-level=2 </td> </tr> </tbody> </table> <p> Alternatively use <samp class="codeph">#include &lt;mathimf.h&gt;</samp> header instead of the standard <samp class="codeph">#include &lt;math.h&gt;</samp> header to call highly optimized and accurate mathematical functions commonly used in applications that rely heaving on floating point computations. </p> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-53B736C9-3A0A-4CC0-931B-1A1EDF7BF668.html">inline-level, Ob</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},67185:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{ref:"title",class:[{active:e.isActive,close:e.isCrossButton,tab:e.showTab},e.animation],on:{pointerdown:function(t){return t.preventDefault(),e.onPointerDown.apply(null,arguments)},pointermove:function(t){return t.preventDefault(),e.onPointerMove.apply(null,arguments)},pointerup:function(t){return t.preventDefault(),e.onPointerUp.apply(null,arguments)},lostpointercapture:function(t){return t.preventDefault(),e.onLostPointerCapture.apply(null,arguments)}}},[e.caption?t("i",{staticClass:"icon drag",class:{disabled:e.isDragDisabled}}):e._e(),e._v(" "),t("span",{domProps:{innerHTML:e._s(e.caption)}}),e._v(" "),e.showTab&&e.isCrossButton?t("button",{on:{click:function(t){return t.preventDefault(),e.onClose.apply(null,arguments)}}},[t("i",{staticClass:"icon cross light"})]):e._e()])};o._withStripped=!0;var n=i(72796);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"380545af",null).exports},67368:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>r});var o=function(){var e=this;return(0,e._self._c)("label",{staticClass:"message-text",domProps:{innerHTML:e._s(e.decoratedText)},on:{click:e.onClick}})};o._withStripped=!0;const n="data-link",s={props:{text:{required:!0}},computed:{decoratedText(){return this.text?this.text.replace(/<a ([^<>]*)>([^<>]*)<\/a>/gi,`<span class="message-box-text-link" ${n}="$1">$2</span>`):""}},methods:{onClick(e){e.target&&e.target.hasAttribute(n)&&(e.stopPropagation(),e.preventDefault(),this.$emit("linkClick",e.target.getAttribute(n)))}}},r=(0,i(98822).A)(s,o,[],!1,null,"6f7cb4ae",null).exports},67418:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>l});var o=function(){var e=this,t=e._self._c;return e.hasRecommendations?t("div",{staticClass:"button no_report"},[t("a",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.buttonTooltip,expression:"buttonTooltip"}],staticClass:"dot icon",class:[e.buttonIcon,{selected:e.isRecommendationsVisible},{available:e.buttonAvailable}],on:{click:function(t){return e.onClick()}}}),e._v(" "),e.recommendations.length>0?t("div",{staticClass:"badge"},[e._v(e._s(e.recommendations.length))]):e._e()]):e._e()};o._withStripped=!0;var n=i(75337),s=i(78281),r=i(51069);const a={mixins:[s.A,r.A],props:{buttonAvailable:{type:Boolean,default:()=>!0},eventName:{type:String,required:!0}},data:()=>({isOpened:!1}),computed:{...(0,n.mapGetters)("header",["getButton"]),...(0,n.mapGetters)("log",["isRecommendationsVisible"]),button(){return this.getButton("recommendations")},hasRecommendations(){return this.$store.direct.getters.log.hasRecommendations(this.eventName)},recommendations(){return this.$store.direct.getters.log.getVisibleRecommendations(this.eventName,this.$t("do_not_show_this_message_again"))}},methods:{onClick(){this.$store.direct.dispatch.log.toggleRecommendationsVisible()}}},l=(0,i(98822).A)(a,o,[],!1,null,"2a62c628",null).exports},67587:(e,t,i)=>{"use strict";i.r(t);var o=i(77106);function n(e,t){e&&e.children[1]&&(e.children[1].innerHTML=(0,o.applyRecParams)(e.children[1].innerHTML,t))}function s(e,t){const i=t.data_reuse_speed_up_percents;if(void 0!==i){const s=`${(0,o.formatNumber)({value:i,type:"auto",digits:2})}%`;n(e,{...t,data_reuse_speed_up_percents:s})}else n(e,t)}window.rec_offload_trivial_c=n,window.rec_offload_trivial_f=n,window.rec_offload_reduction_c=n,window.rec_offload_reduction_f=n,window.rec_offload_combine_region_instances=function(e,t){if(n(e,t),!e)return;const i=e.querySelector("#dependencies_unknown");i&&i.Visible(null==t.outer_loop_dependencies);const o=e.querySelector("#dependencies_defined");o&&o.Visible(t.outer_loop_dependencies)},window.rec_apply_data_reuse_c=s,window.rec_apply_data_reuse_f=s},67863:e=>{e.exports=' <h4>Decrease unroll factor</h4> <div class="text"> <div class="promo"> The current <span data-glossary-id="directive">directive</span> unroll factor increases vector <span data-glossary-id="register_pressure">register pressure</span>. To fix: Decrease <span data-glossary-id="unroll">unroll</span> factor using a directive: <samp class="codeph">#pragma nounroll</samp> or <samp class="codeph">#pragma unroll</samp>. <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\n#pragma nounroll\nfor (int i = 1; i &lt; 100; i++)\n...</code></pre> <pre class="expansion"><code class="cpp">void nounroll(int a[], int b[], int c[], int d[])\n{\n    #pragma nounroll\n    for (int i = 1; i &lt; 100; i++)\n    {\n        b[i] = a[i] + 1;\n        d[i] = c[i] + 1;\n    }\n}</code></pre> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-30B36136-E399-4D7A-9BF8-06D96B8536E9.html">unroll/nounroll</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},68201:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>A});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"grid-holder source-view"},[t("no-data",{directives:[{name:"show",rawName:"v-show",value:e.isNoData,expression:"isNoData"}]}),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.isNoData,expression:"!isNoData"}],ref:"gridParent",staticClass:"grid"})],1)};o._withStripped=!0,i(69212),i(43468),i(38333),i(45361),i(21602),i(60426);var n=i(86112),s=i(57721),r=i(46192),a=i(62285),l=i.n(a),c=i(51949),d=i.n(c),p=i(28105),u=i.n(p),h=i(73506),m=i.n(h),f=i(69015),v=i.n(f),g=i(97856),_=i.n(g),y=i(96456),b=i(5957);const w="source";n.A.addCellPainter(w,{paint:e=>e}),n.A.addColumnLayout(w,{cells:{fontFamily:"monospace"}}),n.A.addCellPainter("percentValue",(0,y.o0)({showBar:!1})),l().registerLanguage("c-like",d()),l().registerLanguage("cpp",u()),l().registerLanguage("fortran",m()),l().registerLanguage("bash",_());const x=v()(l());x.contains=x.contains.filter((e=>"comment"!==e.className)),x.keywords.built_in+="r8 r9 r10 r11 r12 r13 r14 r15 r16 r17 r18 r19 r20 r21 r22 r23 r24 r25 r26 r27 r28 r29 r30 r31 r32 r33 r34 r35 r36 r37 r38 r39 r40 r41 r42 r43 r44 r45 r46 r47 r48 r49 r50 r51 r52 r53 r54 r55 r56 r57 r58 r59 r60 r61 r62 r63 r64 r65 r66 r67 r68 r69 r70 r71 r72 r73 r74 r75 r76 r77 r78 r79 r80 r81 r82 r83 r84 r85 r86 r87 r88 r89 r90 r91 r92 r93 r94 r95 r96 r97 r98 r99 r100 r101 r102 r103 r104 r105 r106 r107 r108 r109 r110 r111 r112 r113 r114 r115 r116 r117 r118 r119 r120 r121 r122 r123 r124 r125 r126 r127 r128 r129 r130 r131 r132 r133 r134 r135 r136 r137 r138 r139 r140 r141 r142 r143 r144 r145 r146 r147 r148 r149 r150 r151 r152 r153 r154 r155 r156 r157 r158 r159 r160 r161 r162 r163 r164 r165 r166 r167 r168 r169 r170 r171 r172 r173 r174 r175 r176 r177 r178 r179 r180 r181 r182 r183 r184 r185 r186 r187 r188 r189 r190 r191 r192 r193 r194 r195 r196 r197 r198 r199 r200 r201 r202 r203 r204 r205 r206 r207 r208 r209 r210 r211 r212 r213 r214 r215 r216 r217 r218 r219 r220 r221 r222 r223 r224 r225 r226 r227 r228 r229 r230 r231 r232 r233 r234 r235 r236 r237 r238 r239 r240 r241 r242 r243 r244 r245 r246 r247 r248 r249 r250 r251 r252 r253 r254 r255",l().registerLanguage("x86asm",(()=>x));const C={inject:["api"],mixins:[s.default],props:{requestId:{type:String,required:!0},contextMenu:Array},data:()=>({gridControl:null,noAutoRefreshSelection:!0,currentRowId:void 0,currentFile:void 0,sourceName:void 0,functionName:void 0,isActive:!1,isNoData:!0}),async mounted(){await this.$nextTick();const{requestId:e}=this,{gridParent:t}=this.$refs;(0,r.Z)(this,e,"gridControl",t)?(this.gridControl.setParent(t),this.isNoData=!1,this.gridControl.recalcScroll(),this.gridControl.grid.rightGrid.onUpdateViewComplete.clear(),this.gridControl.onDblClick.clear(),this.gridControl.onContextMenu.clear(),this.gridControl.onSelectionChange.clear()):await this.createGridControl(),this.gridControl.grid.rightGrid.onUpdateViewComplete.subscribe(this,this.initialSetRightColumnsWidth),this.gridControl.onDblClick.subscribe(this,this.onDblClick),this.gridControl.onContextMenu.subscribe(this,b.O.bind(this,this.contextMenu)),this.gridControl.onSelectionChange.subscribe(this,(e=>{const t=this.getCurrentRowId(e);this.$emit("selectionChanged",t,this)})),this.isActive=!0,this.refreshSelection()},beforeDestroy(){this.isActive=!1,this.gridControl&&this.gridControl.setParent(void 0);let e=!1;!this.isNoData&&this.gridControl&&(e=(0,r.r)(this,this.requestId,"gridControl",this.$refs.gridParent)),!e&&this.gridControl&&this.gridControl.destroy()},async activated(){this.isActive=!0,await this.$nextTick(),this.refreshSelection()},deactivated(){this.isActive=!1},methods:{async update(e,t,i){const o=await this.api.grid.update(e,t,i);if(o){if(t===n.A.gridRequestProtocol.getInitialInfo&&o.columns){const e=o.columns.find((e=>e.type===w));e&&(this.sourceColumnId=e.id)}o.rows&&(this.sourceColumnId&&this.highlightSyntax(o.rows),this.isNoData=!o.rows.length)}return o},async createGridControl(){const{update:e,requestId:t}=this,{gridParent:i}=this.$refs,o={...n.A.gridRequestProtocol};delete o.sortColumn,this.gridControl=n.A.create(t,i,{protocol:o,noSetCurrentRow:!0,resizeMode:n.A.ResizeMode.rmCenter,addKeyboardCopy:!0}),this.gridControl.setCentralColumnWidth("70%"),await this.gridControl.init(e)},initialSetRightColumnsWidth(){const{grid:e}=this.gridControl,{gridBody:t}=e.rightGrid,i=e.getCentralColumnWidth();if(i&&i.indexOf("%")<0)return void e.rightGrid.onUpdateViewComplete.unsubscribe(this,this.initialSetRightColumnsWidth);const o=t.columns.length;if(o){const i=2;let n=0;t.columns.some(((e,t)=>(n+=e.area.offsetWidth,t>=i))),o>1&&(n=Math.round(.7*n)),n&&(e.setCentralColumnWidth(`${n}px`),e.rightGrid.onUpdateViewComplete.unsubscribe(this,this.initialSetRightColumnsWidth))}},highlightSyntax(e){if(!e||!e.length)return;let t=e.map((e=>e.data[this.sourceColumnId])).join("\n");t=this.highlightSource(t),t.split("\n").forEach(((t,i)=>{const o=e[i];o&&(o.data[this.sourceColumnId]=t,o.escapedHTML={[this.sourceColumnId]:!0})}))},highlightSource(e){switch((this.currentFile||"").split(".").pop().toLowerCase()){case"c":case"cc":case"cpp":case"cxx":case"h":case"hh":case"hpp":return l().highlight(e,{language:"cpp",ignoreIllegals:!0}).value;case"f":case"for":case"fpp":case"ftn":case"f77":case"f90":case"f95":case"f03":return l().highlight(e,{language:"fortran",ignoreIllegals:!0}).value;default:return l().highlightAuto(e).value}},onDblClick(...e){this.$emit("gridDblClick",...e)},async onSelectionChanged({senderId:e,rowId:t}){if(t=this.getCurrentRowId(t),this.isActive&&this.gridControl&&this.requestId!==e&&this.currentRowId!==t){this.currentRowId=t;const e=await this.api.get(this.requestId,"update-source",{rowId:t});this.isNoData="not_found"===e.state,this.$emit("sourceChanged",e);const{file:i,line:o,name:n,loop:s}=e;i!==this.currentFile&&(this.currentFile=i),this.sourceName=n,this.functionName=s,await this.gridControl.refresh(),o&&this.gridControl.setCurrentRowIndex(o-1)}}}},A=(0,i(98822).A)(C,o,[],!1,null,"cde65a76",null).exports},68546:(e,t,i)=>{"use strict";i.r(t),i.d(t,{__esModule:()=>n.B,default:()=>r});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"top-slider"},[e.isCollectionRunning?t("top-slider-meter",{attrs:{eventName:e.eventName}}):e._e(),e._v(" "),e.isTopSliderVisible?t("div",[e.isTopSliderCollapsed?e._e():t("div",{staticClass:"content",style:e.contentStyle},[e.isEventLogVisible?t("top-slider-featured-events",{staticClass:"section",attrs:{eventName:e.eventName}}):e._e(),e._v(" "),e.isRecommendationsVisibleInTopSlider?t("top-slider-recommendations",{staticClass:"section",attrs:{eventName:e.eventName}}):e._e()],1),e._v(" "),t("top-slider-splitter",{attrs:{collapsed:e.isTopSliderCollapsed},on:{resized:e.onResize,collapsed:e.onCollapse,expanded:e.onExpand}}),e._v(" "),e.debugInfo?t("div",{staticClass:"debug-panel",domProps:{innerHTML:e._s(e.debugInfo)}}):e._e()],1):e._e()],1)};o._withStripped=!0;var n=i(23845);const s=n.A,r=(0,i(98822).A)(s,o,[],!1,null,"6fc2b09c",null).exports},68819:(e,t,i)=>{"use strict";function o(e,t){return t?` ${e}="${t}"`:""}function n(e){return o("class",e)}function s(e){return o("style",e)}function r(e,t){t=t||{};let i="";return Array.isArray(t.attrs)&&t.attrs.forEach((e=>{i+=o(e.tag,e.val)})),`<${e}${n(t.clsName)}${s(t.style)} ${i}>`}function a(e,t){return e||function(e){return e&&(e.clsName||e.style)}(t)?`${r("span",t)}${e}</span>`:""}function l(e,t){var i=r("div",t);return e.forEach((e=>{i+=e})),i+="</div>"}i.d(t,{A:()=>c}),i(69212),i(45361),i(21602);const c={attr:o,cls:n,style:s,elem:r,span:a,div:l,text:function(e,t){return l([e],t=t||{clsName:"idvc2_grid_painter_text center"})},labels:function(e,t){return l(e.map((e=>a(e,{clsName:"idvc2_grid_painter_label small"}))),{clsName:"idvc2_grid_painter_labels"+(t?" default":"")})},bar:function(e,t,i,o,n){let s;return t=t||"rgba(0,0,0,0)",i=i||0,o=o||100,e=e||[],(n=n||{}).clsName||(n.clsName="idvc2_grid_painter_bar"),e.length?(s="background: linear-gradient(90deg",i&&(s+=`,${t} 0%, ${t} ${i}%`),e.forEach((e=>{s+=`,${e.color} ${i}%,\n        ${e.color} ${i+e.percent}%`,i+=e.percent})),i<100&&(s+=`,${t} ${i}%, ${t} ${o}%`,o<100&&(s+=`,${t} ${o}%, ${t} 100%`)),s+=");"):s=`background-color: ${t};`,l([],{...n,style:s})}}},68895:e=>{e.exports=' <h4>Inefficient data transfer present</h4> <div class="text"> %disclaimer% %kernel_bounded_by% When this kernel is offloaded, the data transfer might not be efficient and might decrease performance. For computations that run on a GPU, you should minimize data transfers between host and target devices. </div> '},69226:e=>{e.exports=' <h4>Enable auto-vectorization</h4> <div class="text"> <div class="promo"> You compiled with auto-vectorization disabled; enable auto-vectorization: <ul> <li>Intel compiler 14.x or below: Increase the optimization level to O2 or O3.</li> <li>GNU* Fortran compiler, do one of the following:</li> <ul> <li>Increase the optimization level to O2 or O3.</li> <li>Use the ftree-vectorize compiler option</li> </ul> </ul> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://gcc.gnu.org/onlinedocs/">GCC online documentation</a> </li> </ul> </div>'},69514:e=>{e.exports=' <h4>Use Parallel STL alternative to std::copy_if</h4> <div class="text"> <p class="promo"> The <code class="hljs-title">std::copy_if</code> algorithm runs sequentially. <span id="execution_polices">To run in parallel, use the Parallel STL alternative <span id="several_polices_text">with one of the following execution polices:</span> <span id="one_policy_text">with the following execution policy:</span> %polices% </span> </p> <p class="expander">Example</p> <pre class="essential"><code class="cpp">...\nstd::copy_if(std::execution::%policy%, a, a+n, b, [](float elem)\n...</code></pre> <pre class="expansion"><code class="cpp">#include "pstl/execution"\n#include "pstl/algorithm"\nvoid foo(float* a, float* b, int n)\n{\n    std::copy_if(std::execution::%policy%, a, a+n, b, [](float elem)\n    {\n        return elem  > 10.f;\n    });\n}</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/guide/get-started-with-parallel-stl.html">Getting Started with Parallel STL</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},69633:e=>{e.exports=' <h4>Potential underutilization of approximate reciprocal instructions</h4> <div class="essential"> Your current hardware supports Advanced Vector Extensions 512 (AVX-512) instructions that enable the use of approximate reciprocal and reciprocal square root instructions both for single- and double-precision floating-point calculations. Improve performance by utilizing these instructions. </div>'},69915:e=>{e.exports=' <h4>Remove system function call(s) inside loop</h4> <div class="text promo"> Typically system function or subroutine calls cannot be vectorized; even a print statement is sufficient to prevent vectorization. To fix: Avoid using system function calls in loops. </div>'},70077:e=>{e.exports=' <h4>Reduce the number/size of arrays promoted to the private memory</h4> <div class="text promo"> Usually, private variables are promoted to <span data-glossary-id="GRF">GRF</span>. If an array is big, a compiler often promotes the variables to the additional region of the private memory. <br><br> <ul> <li><b>Consider using static indexing.</b> <p> Static indexing means that each access is performed using the index known at the moment of compilation (static constant). The compiler can map statically indexed private arrays to registers. Dynamically indexed private arrays are often promoted to the private memory. </p><p class="expander">Examples of a <b>static/dynamic</b> indexing:</p> <pre class="essential"><code class="cpp">\ndata[0]   = 0; //static indexing\ndata[i++] = 0; //dynamic indexing\n                </code></pre> <p></p> </li> <br> <li><b>Consider reducing array size.</b> <p> The total GRF size is %grf_size% bytes per thread. The current <span data-glossary-id="SIMD_gpu">SIMD</span> width is %gpu_current_row_simd_width%. The available size of GRF per work item calculated as <b>GRF/SIMD width</b> is %grf_per_wi% bytes. </p> <p> Reduce the array size to fit it into the available GRF space per work item. </p> </li> </ul> </div> '},70182:e=>{e.exports=' <h4>Use natively supported data types</h4> <div class="text"> <div class="promo"> Some data types - such as 80-bit, IEEE* Standard 754 floating-point numbers - are not supported by vector registers. To fix: Avoid unsupported data types. </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <b>C++</b>: <a href="docs:C++/17/index.htm#GUID-63514789-6BE7-4FA8-9389-F3B618A2EE1A.html">fp-model, fp</a> </li> <li> <b>Fortran</b>: <a href="docs:Fortran/17/index.htm#GUID-63514789-6BE7-4FA8-9389-F3B618A2EE1A.html">fp-model, fp</a> </li> </ul> </div>'},70505:e=>{e.exports=' <h4>Resolve dependency</h4> <div class="text"> <div class="promo"> The Dependencies analysis shows there is a real (proven) dependency in the loop. To fix: Do one of the following: <ul> <li>If there is an anti-dependency, enable vectorization using the <span data-glossary-id="directive">directive</span> <samp class="codeph">!$OMP SIMD SAFELEN(length)</samp>, where <samp class="codeph">length</samp> is smaller than the distance between dependent iterations in anti-dependency. <p class="expander">Example</p> <pre class="essential"><code class="fortran">!$OMP SIMD SAFELEN(4)\n...</code></pre> <pre class="expansion"><code class="fortran">!$OMP SIMD SAFELEN(4)\ndo i = 1, N-4, 4\n    a(i+4) = b(i) * c\nenddo</code></pre> </li> <li> If there is a reduction pattern dependency in the loop, enable vectorization using the directive <samp class="codeph">!$OMP SIMD REDUCTION(operator:list)</samp>. <p class="expander">Example</p> <pre class="essential"><code class="fortran">!$OMP SIMD REDUCTION(+:SUMX)\n...</code></pre> <pre class="expansion"><code class="fortran">!$OMP SIMD REDUCTION(+:SUMX)\ndo k = 1, size2\n    sumx = sumx + x(k) * b(k)\nenddo</code></pre> </li> <li>Rewrite the code to remove the dependency. Use programming techniques such as variable privatization.</li> </ul> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:Fortran/17/index.htm#GUID-179A38EE-4D40-4EB6-9717-4B625DDB1C27.html">SIMD Directive (OpenMP* API)</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/fortran-compiler/developer-guide-reference/current/general-compiler-directives.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},70632:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("layout-panel-card",{class:e.type,style:e.flex,attrs:{type:e.type}},[t("div",{staticClass:"ops-data"},[t("div",{staticClass:"groups"},[t("layout-panel-group",{staticClass:"roofline-group",attrs:{title:e.$t("roofline")},scopedSlots:e._u([{key:"title",fn:function(){return[t("option-selector",{attrs:{options:e.rooflineConfigurationOptions},on:{change:e.updateRooflineOptions}})]},proxy:!0}])},[e._v(" "),t("roofline",{key:`${e.type}-roofline`,ref:"roofline",staticClass:"roofline",attrs:{"roofline-id":e.rooflineId,"selection-id":e.rooflineSelectionId,"simple-view":"","excluded-extensions":e.excludedExtensions},on:{initialized:e.fillRooflineOptions}})],1)],1),e._v(" "),t("flops-list",{attrs:{items:e.data,collapsed:!0,"bounded-by-caption":e.isGPU?e.$t("app_bounded_by"):""}},[e.mix?t("div",{staticClass:"mix"},[t("span",[e._v(e._s(e.$t("gpu_instruction_mix")))]),e._v(" "),t("idvc-bar-chart",{attrs:{"chart-data":e.mix,"bar-width":.3,stacked:"","value-labels":""}}),e._v(" "),t("div",{staticClass:"legend"},e._l(e.mix.series,(function({title:i,color:o},n){return t("div",{key:n},[t("span",{style:{color:o}},[t("span",[e._v(e._s(i))])])])})),0)],1):e._e()])],1)])},n=[];o._withStripped=!0},71388:(e,t)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const i={props:{data:Array}};t.A=i},71534:e=>{e.exports=' <h4>Replace call(s) to virtual method with direct call(s)</h4> <div class="text"> <div class="promo"> Calls to virtual methods are always indirect because the function address is calculated during runtime. Do the following to fix: <ul> <li> Force vectorization of the <span data-glossary-id="source_loop">source loop</span> using SIMD instructions and/or create a SIMD version of the function(s) using a <span data-glossary-id="directive">directive</span>: <table> <tr> <th> Target </th> <th> Directive </th> </tr> <tr> <td> Source loop </td> <td> #pragma omp simd </td> </tr> <tr> <td> Inner function definition or declaration </td> <td> #pragma omp declare simd </td> </tr> </table> </li> <li> Update to Intel Compiler <samp class="codeph">17.x</samp> or higher. Or replace the virtual method with a direct function call. </li> </ul> <p class="expander">Example (original code)</p> <pre class="essential"><code class="cpp">...\nvirtual double foo(double x) { return x+1; }\n...\n<mark>// virtual indirect call</mark>\n<b>sum += obj->foo(a[k]);</b>\n...</code></pre> <pre class="expansion"><code class="cpp">struct A {\n    virtual double foo(double x) { return x+1; }\n};\n\nstruct B : public A {\n    double foo(double x) override { return x-1; }\n};\n\n ...\n\nA* obj = new B();\n\ndouble sum = 0.0;\n#pragma omp simd reduction(+:sum)\nfor (int k = 0; k &lt; N; ++k) {\n    <mark>// virtual indirect call</mark>\n    <b>sum += obj->foo(a[k]);</b>\n}\n...</code></pre> </div> <p class="expander">Example (revised code)</p> <pre class="essential"><code class="cpp">...\n<b>#pragma omp declare simd</b>\nvirtual double foo(double x) { return x+1; }\n...\n<b>sum += ((B*)obj)->B::foo(a[k]);</b>\n...</code></pre> <pre class="expansion"><code class="cpp">struct A {\n    <b>// Intel Compiler 17.x or higher could vectorize call to virtual method</b>\n    <b>#pragma omp declare simd</b>\n    virtual double foo(double x) { return x+1; }\n};\n\n ...\n\nsum = 0.0;\n#pragma omp simd reduction(+:sum)\nfor (int k = 0; k &lt; N; ++k) {\n    <b>// step for Intel Compiler 16.x or lower:</b>\n    <b>// if you know the method to be called,</b>\n    <b>// replace virtual call with direct one</b>\n    <b>sum += ((B*)obj)->B::foo(a[k]);</b>\n}\n...</code></pre> <p class="expander">Read More</p> <ul class="expansion"> <li> <i>omp simd</i>, <i>omp declare simd</i> in <a href="docs:C++/17/index.htm#GUID-6DEAFDEA-3DAF-4EEE-8067-DEDDA5A56E5D.html">OpenMP* Pragmas Summary</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/docs/cpp-compiler/developer-guide-reference/current/pragmas.html">Getting Started with Intel Compiler Pragmas and Directives</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},71673:e=>{e.exports=' <h4>Potential excessive caching present</h4> <div class="essential"> </div>'},71697:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this;return(0,e._self._c)("i",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:e.tooltip,expression:"tooltip",modifiers:{title:!0}}],staticClass:"button icon",class:[e.iconName,e.isAvailable?"":"disabled"]},[e._t("default")],2)};o._withStripped=!0;const n={props:{tooltip:String,iconName:String,isAvailable:Boolean}},s=(0,i(98822).A)(n,o,[],!1,null,"f2b8e32c",null).exports},71746:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>p});var o=function(){var e=this,t=e._self._c;return t("div",{staticClass:"accuracy-control",class:{disabled:e.knob.readOnly}},[t("div",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:e.$t("accuracy_tooltip"),expression:"$t('accuracy_tooltip')",modifiers:{title:!0}}],staticClass:"label"},[e._v("\n    "+e._s(e.$t("accuracy_preset"))+"\n    "),t("i",{staticClass:"icon help-circle dark"})]),e._v(" "),t("div",{staticClass:"accuracy"},e._l(e.values,(function(i){return t("div",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:e.$t("accuracy_"+i),expression:"$t('accuracy_'+value)",modifiers:{title:!0}}],key:i,staticClass:"button",class:[i,{current:i===e.currentAccuracyValue}],on:{click:function(t){return e.setAccuracyValue(e.id,i)}}},[e._v("\n      "+e._s(e.$t("accuracy_"+i))+"\n    ")])})),0)])};o._withStripped=!0;var n=i(75337),s=i(14400),r=i(18977),a=i(84620);const l={created(){r.A.workflow.setAccuracyMode((e=>{const{perspectiveId:t}=e,i=a.ProductMode[t];if(void 0===i)return"Error: No Perspective id found";const{mode:o}=e;return-1===this.values.indexOf(o)?"Error: No value for accurucy mode found":(this.setAccuracyValue(i,o),!0)}))}};var c=i(33874);const d={mixins:[l],props:{knob:Object},watch:{knob:{handler:function(){const{id:e}=this,t=this.$store.direct.getters.workflow.presetIndex,i=c.C.get(e,t);if(!this.currentAccuracy){const{value:t=i.defaultValue}=this.knob;this.$store.direct.commit.workflow.setAccuracyValue({id:e,value:t})}},immediate:!0}},computed:{...(0,n.mapGetters)("workflow",["currentAccuracy","isCustomPreset"]),id(){return this.$store.state.activePerspectiveId},values:()=>[...c.C.values,s._],currentAccuracyValue(){return this.isCustomPreset?s._:this.currentAccuracy}},methods:{setAccuracyValue(e,t){t!==s._&&this.$store.direct.commit.workflow.setAccuracyValue({id:e,value:t}),this.$store.direct.commit.workflow.setCustomAccuracy(t===s._),this.knob.value=t,this.$emit("onKnobChanged",this.knob)}}},p=(0,i(98822).A)(d,o,[],!1,null,"521956e6",null).exports},71839:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("layout-panel-card",{style:e.flex,attrs:{type:"cpu","can-collapse":""},on:{collapsed:e.onCollapsed}},[e.compact?t("div",{staticClass:"perf-data compact"},[e.compactData?t("bar-metric",e._b({attrs:{compact:!0}},"bar-metric",e.compactData,!1)):e._e()],1):t("div",{staticClass:"perf-data"},e._l(e.data,(function(i){return t("bar-metric",e._b({key:i.id},"bar-metric",i,!1))})),1)])},n=[];o._withStripped=!0},72127:(e,t,i)=>{"use strict";function o(e){switch(e){case 1:default:return"low";case 2:return"medium";case 3:return"high"}}i.d(t,{A:()=>o})},72796:(e,t,i)=>{"use strict";Object.defineProperty(t,"B",{value:!0});const o=i(60970),n={props:{view:{type:String,required:!0},animation:String,caption:String,slotIndex:Number,tabState:String,showTab:{type:Boolean,default:!1},collapsed:{type:Boolean,default:!1}},data:()=>({isPointerCapture:!1}),computed:{canSwap(){return this.$store.direct.getters.layout.canSwap(this.view)},canMove(){return this.$store.direct.getters.layout.canMove(this.view)},isHideByCrossButton(){return this.$store.direct.getters.layout.isHideByCrossButton(this.view)},isCloseByCrossButton(){return this.$store.direct.getters.layout.isCloseByCrossButton(this.view)},isCrossButton(){return this.isHideByCrossButton||this.isCloseByCrossButton},isActive(){return this.tabState===o.STATE_ACTIVE},isDragDisabled(){const e=this.$store.direct.getters.layout.canDock(this.view);return this.collapsed||!(this.canSwap||this.canMove||e)}},methods:{onPointerDown(e){if(e.buttons!==o.MOUSE_BUTTON_LEFT)return;const{view:t,slotIndex:i}=this;if("number"==typeof i&&this.$store.direct.dispatch.layout.setActiveTab({view:t,slotIndex:i}),!this.canSwap&&!this.canMove)return;const{pointerId:n,x:s,y:r}=e;this.pointerId=n,this.x=s,this.y=r},startDrag(){const{pointerId:e,x:t,y:i,slotIndex:o}=this;this.isPointerCapture=!0,this.$refs.title.setPointerCapture(e),this.$refs.title.style.cursor="move",this.$emit("captured",{x:t,y:i,slotIndex:o})},onPointerMove(e){if(!this.pointerId)return;if(!this.isPointerCapture){if(!(Math.abs(this.x-e.x)>3||Math.abs(this.y-e.y)>3))return;this.startDrag()}const{x:t,y:i}=e;this.x=t,this.y=i,this.$emit("dragged",{x:t,y:i})},onPointerUp(e){if(!this.pointerId)return;const{pointerId:t}=e;this.$refs.title.releasePointerCapture(t),this.pointerId=void 0},onLostPointerCapture(){this.isPointerCapture&&(this.isPointerCapture=!1,this.$refs.title.style.cursor="",this.$emit("released"))},onClose(){const{view:e,slotIndex:t}=this;"number"==typeof t&&this.$store.direct.dispatch.layout.closeTab({view:e,slotIndex:t})}}};t.A=n},73267:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var o=function(){var e=this,t=e._self._c;return t("label",{staticClass:"knob-checkbox",class:{disabled:e.knob.readOnly}},[t("input",{attrs:{type:"checkbox"},domProps:{checked:e.knob.value},on:{change:e.selectionChanged}}),e._v(" "),t("div",{directives:[{name:"tooltip",rawName:"v-tooltip.title",value:e.knob.description||e.knob.name,expression:"knob.description || knob.name",modifiers:{title:!0}}],staticClass:"name"},[e._v("\n    "+e._s(e.knob.name)+"\n  ")])])};o._withStripped=!0;const n={props:{knob:{type:Object,validator:e=>"string"==typeof e.id&&"string"==typeof e.name&&"boolean"==typeof e.readOnly&&"boolean"==typeof e.value&&"boolean"==typeof e.readOnly}},methods:{selectionChanged({target:e}){this.$emit("onKnobChanged",{...this.knob,value:e.checked})}}},s=(0,i(98822).A)(n,o,[],!1,null,"369603e6",null).exports},73397:e=>{e.exports=' <h4>Align data</h4> <div class="text"> <p class="promo"> One of the memory accesses in the <span data-glossary-id="source_loop">source loop</span> does not start at an optimally aligned address boundary. To fix: Align the data and tell the compiler the data is aligned. </p> <p><b>Dynamic Data:</b></p> <p> To align dynamic data, replace <samp class="codeph">malloc()</samp> and <samp class="codeph">free()</samp> with <samp class="codeph">_mm_malloc()</samp> and <samp class="codeph">_mm_free()</samp>. To tell the compiler the data is aligned, use <samp class="codeph">__assume_aligned()</samp> before the source loop. Also consider using <samp class="codeph">#include &lt;aligned_new&gt;</samp> to enable automatic allocation of aligned data. </p> <p><b>Static Data:</b></p> <p> To align static data, use <samp class="codeph">__declspec(align())</samp>. To tell the compiler the data is aligned, use <samp class="codeph">__assume_aligned()</samp> before the source loop. </p> <div class="promo"> <p class="expander">Example - Dynamic Data</p> <div class="expansion"> Align dynamic data using a 64-byte boundary and tell the compiler the data is aligned: <pre><code class="cpp">float *array;\narray = (float *)_mm_malloc(ARRAY_SIZE*sizeof(float), 32);\n// Somewhere else\n__assume_aligned(array, 32);\n// Use array in loop\n_mm_free(array);</code></pre> </div> <p class="expander">Example - Static Data</p> <div class="expansion"> Align static data using a 64-byte boundary: <pre><code class="cpp">__declspec(align(64)) float array[ARRAY_SIZE]</code></pre> </div> </div> <p class="expander">Read More</p> <ul class="expansion"> <li> <a href="docs:C++/17/index.htm#GUID-0E65C236-47E7-4E98-963F-D2339F1AA414.html">align</a> </li> <li> <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/data-alignment-to-assist-vectorization.html">Data Alignment to Assist Vectorization</a> and <a href="https://www.intel.com/content/www/us/en/developer/articles/technical/advisor-vectorization-resources.html">Vectorization Resources for Intel&reg; Advisor Users</a> </li> </ul> </div>'},73513:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>o});const o="data:image/png;base64,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"},73738:(e,t,i)=>{"use strict";i.d(t,{X:()=>o,Y:()=>n});var o=function(){var e=this,t=e._self._c;return e._self._setupProxy,t("div",{staticClass:"layout-panel",class:[{captured:e.captureType},e.animation],style:{flex:e.flex,...e.minSize},attrs:{name:e.name},on:{animationend:e.onAnimationEnd}},[t("div",{staticClass:"panel-content"},[t("panel-header",{attrs:{view:e.view,tabs:e.tabs,isSearch:e.isSearch,isOptions:e.isOptions},on:{released:e.onPanelReleased,dragged:e.onPanelDragged,collapsed:e.onPanelCollapsed,closed:e.onPanelClosed},scopedSlots:e._u([{key:"search",fn:function(){return[e._t("search")]},proxy:!0},{key:"options",fn:function(){return[e._t("options")]},proxy:!0}],null,!0)}),e._v(" "),t("section",{class:{hovering:e.isHovering},on:{mouseover:function(t){e.isHovering=!0},mouseout:function(t){e.isHovering=!1}}},[e._t("default")],2),e._v(" "),e.compactHeight?t("button",{staticClass:"compact",on:{click:function(t){return t.preventDefault(),e.onTabCompacted.apply(null,arguments)}}},[t("i",{class:e.compactIcon})]):e._e(),e._v(" "),e.debug?t("div",{staticClass:"debug"},[t("span",[e._v(e._s(e.debug))])]):e._e()],1),e._v(" "),e.captureType?t("panel-draggable",{attrs:{view:e.view,slotIndex:e.slotIndex,caption:e.caption,coordinates:e.draggableCoordinates,captureType:e.captureType,layout:e.layout},on:{hotspotChanged:e.onDraggableHotspotChanged}}):e._e()],1)},n=[];o._withStripped=!0},73990:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>je});var o=function(){return(0,this._self._c)("div",{staticClass:"roofline_holder styled-buttons"})};o._withStripped=!0,i(36094),i(69212),i(43468);var n=i(57143),s=i(18323),r=(i(27468),i(83038),i(88984),i(2449),i(66824),i(37271),i(16124),i(29590),i(43827),i(38333),i(45361),i(21602),i(32204),i(61262)),a=i(66275);const l=function(e){var t=function(){var e,t,i={},n=!1,s={},a=!1;function l(){t&&t("rooflineState:"+JSON.stringify(s))}function c(e){Object.getOwnPropertyNames(i).forEach((function(t){var o=i[t];o&&e&&e(o)}))}return{init:function(e){t=e},checkGlobalState:function(){window.rooflineState&&(s=window.rooflineState,delete window.rooflineState)},disableSaving:function(){n=!0},enableSaving:function(){n=!1},apply:function(e,t){if(e&&r.default.applyObjectProperties(s,e),s){var o=[].slice.call(arguments,2),n=function(e){e&&e.apply&&this._callProcessor(e,e.apply,s,o)}.bind(this);t?n(i[t]):(c(n),a=!0)}},save:function(t){if(!n){if(t){var s=i[t];if(s&&s.saveState){var a=[].slice.call(arguments,1);this._callProcessor(s,s.saveState,this.getState(),a)}}o.onChangeSettings.raise(t),e||(e=r.default.createAsyncCall(l,void 0,2e3)),e.call()}},changeSetting:function(e,t,i){var o=this.getState();return o[e]!==t&&(o[e]=t,this.apply(void 0,e,i?{doProcessing:!0}:void 0),!0)},reApplySetting:function(e){this.apply(void 0,e,{doProcessing:!0})},onClose:function(){e&&e.isCalled()&&(e.cancel(),l())},getState:function(e){var t=!!e;if(e=e||s||{},t){r.default.copyObject(s,e);var i=[].slice.call(arguments,1);c(function(t){t&&t.saveState&&this._callProcessor(t,t.saveState,e,i)}.bind(this))}return e},addProcessor:function(e,t){return t&&(i[e]=t),a&&this.apply(void 0,e),t},_callProcessor:function(e,t,i,o){t&&e&&(o=o||[],t.apply(e,[i].concat(o)))}}}();function i(e,t,i){e&&e.doProcessing&&t&&t(i)}var o={onChangeSettings:a.A.create(),get:function(){return t},addBoolSetting:function(e,i){return{get:function(){var o=t.getState();return i?!0===o[e]:!!o[e]},set:function(i){var o=t.getState();o[e]!==i&&(o[e]=i,t.save(e))}}},addCheckSetting:function(o,n,s,r,a){var l=e(o);l&&(a=a||(e=>e),l.onchange=function(e){t.save(n),s&&s(e.target.checked)},t.addProcessor(n,{apply:function(e,t){if(e){var o=a(!0),c=a(!1);l.checked=r?e[n]===o:e[n]!==c,i(t,s,l.checked)}},saveState:function(e){e[n]=a(l.checked)}}))},addComboSetting:function(o,n,s,r,a){var l=e(o);l&&(a=a||(e=>e),l.onchange=function(e){t.save(n),s&&s(e.target.selectedIndex)},t.addProcessor(n,{apply:function(e,t){if(e){var o=r,c=e[n];if(void 0!==c){var d=a(c);if(c===d)o=d;else for(var p=0,u=l.length;p<u;p++)if(c===a(p)){o=p;break}}o>=l.length&&(o=l.length-1),l.selectedIndex=o,i(t,s,l.selectedIndex)}},saveState:function(e){e[n]=a(l.selectedIndex)}}))},addTextSetting:function(o,n,s,r,a){var l=e(o);l&&(l.oninput=function(e){s&&s(e.target.value)&&t.save(n),r&&r(e.target.value)},t.addProcessor(n,{apply:function(e,t){if(e){var o=a,s=e[n];void 0!==s&&(o=s),l.value=o,i(t,r,l.value)}},saveState:function(e){var t=e[n],i=l.value;i!==t&&(i&&i!==a?e[n]=i:t&&delete e[n])}}))},addRadioGroupSetting:function(o,n,s,r){var a=e(o);if(a){var l=Number.isInteger(r),c=r;a.onchange=function(e){var i;e&&e.target&&(i=e.target.value,c=l?parseInt(i):i,t.save(n),s&&s(c))},t.addProcessor(n,{apply:function(e,t){if(e){var o=e[n];o&&(c=o);var r=d(c);if(r)r.checked=!0;else if(l)for(var a=c-1;a>=0;a--)if(r=d(a)){r.checked=!0,c=a;break}i(t,s,c)}},saveState:function(e){c!==r?e[n]=c:delete e[n]}})}function d(e){return a.querySelector('input[value="'+e+'"]')}}};return o},c={pref:": <b>",post:"</b> ",formatVal:function(e,t,i){if(void 0===t&&(t=e>-1?2:Math.ceil(Math.abs(e))+1),i||e>=-4&&e<=4){var o=r.default.round(Math.pow(10,e),t);return i&&(e<-4||e>4)&&(o=+o.toFixed(t)),o}return r.default.roundExp(Math.pow(10,e),2)},simpleFormat:function(e,t,i){t=t||4;var o=r.default.round(e,t);if(i){var n=Math.pow(10,-t);o<n&&(o="<"+n)}return o},formatTime:function(e){return(+(e=e||0)).toFixed(3)},getLine:function(e,t){var i=e.x-t.x;if(0===i)return()=>{};var o=(e.y-t.y)/i,n=e.y-e.x*o;return function(e){return o*e+n}}},d=function(e,t,i){var o=function(){var e={};function i(e){return!e||void 0!==e.minX&&void 0!==e.minY&&void 0!==e.maxX&&void 0!==e.maxY}function o(t,i){if(e||(e={}),e.frames||(e.frames=[]),void 0===e.zoomIndex&&(e.zoomIndex=-1),void 0===e.index?e.index=-1:e.index<e.frames.length-1&&e.frames.splice(e.index+1),e.frames.push(t),e.index++,i&&(e.zoomIndex=e.index),e.frames.length>200){var o=Math.round(100);e.frames.splice(0,o),e.index-=o,e.zoomIndex-=o}}function n(e,t,i){e=e||2,i=i||function(e){return e};var o=this.getMinMax(),n=o.maxX-o.minX,s=o.maxY-o.minY,r=.05;(t=t||{x:o.minX+n/2,y:o.minY+s/2}).x<=o.minX&&(t.x=o.minX+n*r),t.x>=o.maxX&&(t.x=o.maxX-n*r),t.y<=o.minY&&(t.y=o.minY+s*r),t.y>=o.maxY&&(t.y=o.maxY-s*r);var a=t.x-o.minX,l=o.maxX-t.x,c=t.y-o.minY,d=o.maxY-t.y;return o.minX=t.x-i(a,e),o.maxX=t.x+i(l,e),o.minY=t.y-i(c,e),o.maxY=t.y+i(d,e),this.setZoom(o)}function s(e){if(e){var i=t.getRooflineData(),o=0,n=1e-7;e.minX-n<i.minIntens&&(e.minX=i.minIntens,o++),e.maxX+n>i.maxIntens&&(e.maxX=i.maxIntens,o++),e.minY-n<i.minPerf&&(e.minY=i.minPerf,o++),e.maxY+n>i.maxPerf&&(e.maxY=i.maxPerf,o++),4===o&&(e.isNoZoom=!0),(e.maxX<=e.minX||e.maxY<=e.minY)&&(e.isWrongZoom=!0)}return e}return{zoomChanged:a.A.create(),undoListChanged:a.A.create(),zoomIn:function(e,t){return n.call(this,e,t,(function(e,t){return e/t}))},zoomOut:function(e,t){if(this.getCurrentZoom())return n.call(this,e,t,(function(e,t){return e*t}))},setZoom:function(e,t){var i=!1;if(!(e=s(e)).isWrongZoom){var n=this.getCurrentZoom();return n&&n.minX==e.minX&&n.maxX==e.maxX&&n.minY==e.minY&&n.maxY==e.maxY||Math.abs(e.maxX-e.minX)>.02&&Math.abs(e.maxX-e.minX)>.02&&(o(e,!0),this._notifyChangeZoomState(t),i=!0),i}},addUndoFrame:function(e){o(e),this._notifyChangeUndoList()},getCurrentZoom:function(){var t;return e&&e.frames&&void 0!==e.zoomIndex&&e.zoomIndex>=0&&(t=s(e.frames[e.zoomIndex]))&&t.isNoZoom&&(t=void 0),t},undoZoom:function(){e&&e.frames&&e.index>=0&&(this._checkCurrentFrame(),e.index--,this._notifyChangeUndoList(),this._updateZoomFrame(!0))},redoZoom:function(){e&&e.frames&&e.index<e.frames.length-1&&(e.index++,this._checkCurrentFrame(),this._notifyChangeUndoList(),this._updateZoomFrame())},cancelZoom:function(){if(e&&e.frames){var i=t.getRooflineData();this.setZoom({minX:i.minIntens,maxX:i.maxIntens,minY:i.minPerf,maxY:i.maxPerf})}},getZoomState:function(){var t=!1,i=!1,o=!1;if(e&&(t=e.index>=0,e.frames)){i=e.index<e.frames.length-1;var n=this.getCurrentZoom();o=(n=s(n))&&!n.isNoZoom}return{undo:t,redo:i,cancel:o}},getMinMax:function(e){var i=t.getViewFrame(),o=t.getMinMax(),n=(e?0:i.minIntens)||o.minX,s=(e?0:i.maxIntens)||o.maxX,r=(e?0:i.minPerf)||o.minY,a=(e?0:i.maxPerf)||o.maxY,l=this.getCurrentZoom();return l&&(n=l.minX,s=l.maxX,r=l.minY,a=l.maxY),{minX:n,maxX:s,minY:r,maxY:a}},saveMinMax:function(e){(e=e||t.getRooflineData())&&void 0!==e.minIntens&&void 0!==e.maxIntens&&void 0!==e.minPerf&&void 0!==e.maxPerf&&(this.minMaxFrame={minX:e.minIntens,maxX:e.maxIntens,minY:e.minPerf,maxY:e.maxPerf})},moveCurrentZoomFrame:function(e,i){let o;const n=this.getCurrentZoom();if(n){const s=t.getRooflineData();n.minX+e<s.minIntens&&(e=s.minIntens-n.minX),n.maxX+e>s.maxIntens&&(e=s.maxIntens-n.maxX),n.minY+i<s.minPerf&&(i=s.minPerf-n.minY),n.maxY+i>s.maxPerf&&(i=s.maxPerf-n.maxY),o=e||i?{minX:n.minX+e,maxX:n.maxX+e,minY:n.minY+i,maxY:n.maxY+i}:{isWrongZoom:!0}}return o},clearDataUndo:function(){if(e&&e.frames)for(var t=e.frames.length-1;t>=0;t--)i(e.frames[t])||(e.frames.splice(t,1),void 0!==e.zoomIndex&&e.zoomIndex>=t&&e.zoomIndex--,void 0!==e.index&&e.index>=t&&e.index--)},_checkCurrentFrame:function(){if(e){var t=e.frames[e.index];t&&t.process&&t.process()}},_updateZoomFrame:function(t){if(e){var o,n=e.frames[e.index];if(i(n))o=e.index;else if(t&&e.zoomIndex>e.index)for(o=e.index-1,n=e.frames[o];!i(n);)o--,n=e.frames[o];void 0!==o&&e.zoomIndex!==o&&(e.zoomIndex=o,this._notifyChangeZoomState())}},_notifyChangeZoomState:function(e){this.zoomChanged.raise(e)},_notifyChangeUndoList:function(){this.undoListChanged.raise()}}}(),n={init:function(){this.maxPerfEdit||(this.maxPerfEdit=e.getElementById("frame_max_perf"),this.maxPerfEdit.onblur=this._checkValue.bind(this,"maxY"),this.minPerfEdit=e.getElementById("frame_min_perf"),this.minPerfEdit.onblur=this._checkValue.bind(this,"minY"),this.maxIntensEdit=e.getElementById("frame_max_intens"),this.maxIntensEdit.onblur=this._checkValue.bind(this,"maxX"),this.minIntensEdit=e.getElementById("frame_min_intens"),this.minIntensEdit.onblur=this._checkValue.bind(this,"minX"),this.maxPerfEdit.onkeypress=this.minPerfEdit.onkeypress=this.maxIntensEdit.onkeypress=this.minIntensEdit.onkeypress=i.filterNumberInput,e.getElementById("frame_apply_btn").onclick=this.apply.bind(this),e.getElementById("frame_cancel_btn").onclick=this.close.bind(this));var t=this._getEditableFrame();this.maxPerfEdit.value=t.maxY,this.minPerfEdit.value=t.minY,this.maxIntensEdit.value=t.maxX,this.minIntensEdit.value=t.minX},apply:function(){var e=this._getEditableFrame();e.minX.toString()===this.minIntensEdit.value&&e.maxX.toString()===this.maxIntensEdit.value&&e.minY.toString()===this.minPerfEdit.value&&e.maxY.toString()===this.maxPerfEdit.value||o.setZoom({maxY:Math.log10(this.maxPerfEdit.value),minY:Math.log10(this.minPerfEdit.value),maxX:Math.log10(this.maxIntensEdit.value),minX:Math.log10(this.minIntensEdit.value)}),this.close()},close:function(){s.classList.remove("idvc2_roofline_expanded")},_checkValue:function(e,t){var i=t.target,n=i.value;if(isNaN(n)||!n){var s=o.getMinMax();i.value=c.formatVal(s[e],4,!0)}},_getEditableFrame:function(){var e=o.getMinMax();return{maxY:c.formatVal(e.maxY,4,!0),minY:c.formatVal(e.minY,4,!0),maxX:c.formatVal(e.maxX,4,!0),minX:c.formatVal(e.minX,4,!0)}}},s=e.getElementById("roofline_frame_settings");return s.onclick=function(){!s.classList.contains("idvc2_roofline_expanded")&&o&&(n.init(),s.classList.add("idvc2_roofline_expanded"))},o};var p=i(33202);function u(e){this._roofsMap=e||{},this._strategyId=void 0,this._threadCount=void 0,this._packageCount=0,this._allRoofsLoaded=!1}function h(e,t){return e=e||this._threadCount,t=t||this._packageCount,e?!t||t<=0?e:parseFloat(e+"."+t)||0:0}function m(e){return Math.floor(e)}function f(e){return e%1}i(60426),u.prototype.add=function(e,t,i,o){e&&(t=t||this._threadCount,i=i||this._strategyId,o=o||this._packageCount,this._roofsMap[i]||(this._roofsMap[i]={}),this._roofsMap[i][h.call(this,t,o)]=e)},u.prototype.get=function(e,t,i){if(e=e||this._threadCount,t=t||this._strategyId,i=i||this._packageCount,!this._roofsMap[t])return null;var o=h.call(this,e,i);return this._roofsMap[t][o]?this._roofsMap[t][o]:null},u.prototype.removeIfEmpty=function(e,t,i){var o=this.get(e,t,i);o&&("object"!=typeof o||Object.keys(o).length||delete this._roofsMap[t][h.call(this,e,i)]),this._roofsMap[t]&&(Object.keys(this._roofsMap[t]).length||delete this._roofsMap[t])},u.prototype.forEach=function(e){for(let i in this._roofsMap)for(let o in this._roofsMap[i]){const n=this._roofsMap[i][o],s=m(o),r=f(o);for(var t in n)e(n[t],s,i,r)}},u.prototype.clear=function(){this._roofsMap={},this._strategyId=void 0,this._threadCount=void 0,this._allRoofsLoaded=!1,this._packageCount=0},u.prototype.empty=function(){return!Object.keys(this._roofsMap).length},u.prototype.setStrategyId=function(e){e&&(this._strategyId=e)},u.prototype.getStrategyId=function(){return this._strategyId},u.prototype.setThreadCount=function(e){e&&(this._threadCount=e)},u.prototype.getThreadCount=function(e){return this._threadCount},u.prototype.setAllRoofsLoaded=function(e){this._allRoofsLoaded=e},u.prototype.areAllRoofsLoaded=function(){return this._allRoofsLoaded},u.prototype.setPackageCount=function(e){this._packageCount=e||0},u.prototype.getPackageCount=function(){return this._packageCount};const v=function(e){return new u(e)},g=function(){var e,t,i,o,n=!1,a=v(),l=[],c=function(e){i=(o=e).concat()},d=function(){if(i&&i.length){var e=i.shift();return i.push(e),e}},p=function(e){if(i&&i.length){var t=i.indexOf(e);t>0&&(i.splice(t,1),i.unshift(e))}},u=function(){i=o.concat()},h={items:[],originalLoopsCount:void 0,clear:function(){this.items=[],this.originalLoopsCount=void 0,this.minMax&&delete this.minMax},getIndexByPath:function(e){var t=-1;return this.items.some((function(i,o){var n=i.resultInfo.path===e;return n&&(t=o),n})),t},getItem:function(e){return e<this.items.length&&e>=0?this.items[e]:void 0}};function m(){return n?"+":"-"}function f(e,t){if(e&&Array.isArray(e.loops)){if(t&&!e.wholeMinMax&&void 0!==e.minX&&void 0!==e.maxX&&void 0!==e.minY&&void 0!==e.maxY){var i={minX:e.minX,maxX:e.maxX,minY:e.minY,maxY:e.maxY};e.wholeMinMax=i}if(e.loops.length){var o=Number.MAX_VALUE,n=-Number.MAX_VALUE,s=Number.MAX_VALUE,r=-Number.MAX_VALUE;e.loops.forEach((function(e){void 0!==e.x&&void 0!==e.y&&(c(e.x),d(e.y)),void 0!==e.x1&&void 0!==e.y1&&(c(e.x1),d(e.y1))}));var a=e.programTotal;if(a&&(Array.isArray(a)||(a=[a]),a.forEach((function(e){c(e.x),d(e.y)}))),e.minX=o,e.maxX=n,e.minY=s,e.maxY=r,t&&!e.fitMinMax&&void 0!==e.minX&&void 0!==e.maxX&&void 0!==e.minY&&void 0!==e.maxY){var l={minX:e.minX,maxX:e.maxX,minY:e.minY,maxY:e.maxY};e.fitMinMax=l}}else e.minX=e.maxX=e.minY=e.maxY=void 0}function c(e){o=Math.min(o,e),n=Math.max(n,e)}function d(e){s=Math.min(s,e),r=Math.max(r,e)}}function g(e,i,o,n){if(e&&t&&t.loops){var s=[],r=t.loops,a=!!n&&"-"!==n.state;d(e,n,a);for(var l=0;l<s.length;l++){var c=s[l];a=c.isHidden||"-"!==c.loop.state,!o&&a||d(c.loop.children,c.loop,a)}}function d(e,t,o){if(e){var n=!t;e.forEach((function(e){var a;(a="number"==typeof e?r[e]:e)&&(n&&void 0!==a.parent||(i(a,t,o),s.push({loop:a,isHidden:o})))}))}}}function _(e){e&&e.sort((function(e,t){var i=0;return e.isMem&&!t.isMem?i=-1:!e.isMem&&t.isMem&&(i=1),i||(i=t.val-e.val),i}))}function y(e){return!e||(e.state&&"+"!==e.state||!e.state)&&(void 0===e.x||void 0===e.y)}function b(e,t){if(!e)return{};void 0===t&&(t=y(e));var i=t||"+"===e.state?e.x1:e.x,o=t||"+"===e.state?e.y1:e.y;return{x:void 0!==i?i:e.x,y:void 0!==o?o:e.y}}function w(e,t,i){if(!e||!t)return!1;var o=b(e),n=b(t);return Math.abs(o.x1-n.x1)<=i.x&&Math.abs(o.y1-n.y1)<=i.y}function x(e){if(e>=0)return t.loops[e]}var C,A=(C=0,function(e){return(e=e||"id")+ ++C});function S(e,t){if(e&&t&&(void 0!==e.parent&&(e.parent+=t),e.children))for(var i=0,o=e.children.length;i<o;i++)e.children[i]+=t}function T(e,t,i,o){if(e&&o){for(var n=t,s=h.items.length;n<s;n++)h.items[n].resultInfo.baseIndex+=o;for(n=i,s=e.loops.length;n<s;n++)S(e.loops[n],o)}}function I(){h.items.length||(t.resultInfo?(t.resultInfo.baseIndex=0,t.resultInfo.loopCount=t.loops.length):t.resultInfo={caption:s.A.getMessage("roofline_compare_current_result_label"),id:"cr",baseIndex:0,loopCount:t.loops.length},t.resultInfo.id=t.resultInfo.id||A(),h.items.push(t))}function P(e){return e.objId||e.id}function M(e){var t;if(e.resIndex){var i=h.getItem(e.resIndex);i&&(t=function(e){return e&&e.resultInfo?e.resultInfo.path||e.resultInfo.caption.toLowerCase():""}(i))}return t||e.resIndex||0}function E(e){return function(e){return e.key||e.id}(e)+M(e)}var L={in:"in",out:"out",insubtree:"insubtree"},R={in:e=>!e,out:e=>e,insubtree:e=>!e};function D(e){g(e,(function(e,t,i){e&&i&&!e.filtered&&(e.filtered=!0)}))}function k(e,t,i){function o(e,t,i,o){if(e&&t&&t.keys){var n=R[i]||R.out,s=[];t.processing&&(s=t.processing(t.keys,e));var r=new Set;t.keys.forEach(a),s&&s.forEach(a),e.forEach((function(e){n(function(e,t){var i=E(e);return t.has(i)}(e,r))&&(o?e.filtered?e.filtered++:e.filtered=1:(e.filtered||console.error("Filtering undo failed"),e.filtered--,e.filtered||delete e.filtered))}))}function a(e){r.add(e)}}e&&i&&(o(e,i[L.in],L.in,t),o(e,i[L.out],L.out,t),o(e,i[L.insubtree],L.insubtree,t))}function O(e){D(e),l.forEach(k.bind(void 0,e,!0))}function N(e,t,i){e.matchingLoops&&e.matchingLoops.forEach(t,i||this)}var z=(e,t)=>!e&&!t||e===t;function B(e){N(e,(function(t){if(t.matchingLoops){var i=t.matchingLoops.indexOf(e);i>-1&&t.matchingLoops.splice(i,1)}})),delete e.matchingLoops}function V(e){h.items.forEach((t=>t&&t.compared&&t.compared.delete(e)))}function G(e,i,o,n,s){function r(e,t){return void 0!==e?Math.min(e,t):t}function a(e,t){return void 0!==e?Math.max(e,t):t}e=e||"fitMinMax",t&&t[e]&&(t[e].minX=r(i,t[e].minX),t[e].minY=r(o,t[e].minY),t[e].maxX=a(n,t[e].maxX),t[e].maxY=a(s,t[e].maxY))}return{isNewData:function(e){return!!(!t||!e.resultInfo||e.resultInfo.isNew||!h.items.length&&e.resultInfo&&e.resultInfo.replase&&t.resultInfo&&e.resultInfo.id===t.resultInfo.id)},setRooflineData:function(e,i,o,s){e&&(this.isNewData(e)?(a.clear(),i&&o&&(a.setThreadCount(i),a.setStrategyId(o),a.setPackageCount(s),e.allRoofs?(e.allRoofs.forEach((function(e){a.add(e.roofs,e.threadCount,e.strategyId,e.packageCount)})),delete e.allRoofs):e.roofs&&e.roofs.length&&(a.add(e.roofs),delete e.roofs)),function(e){if(e){if(f(e,!0),h.items.length&&void 0!==h.originalLoopsCount){var i=e.loops.length,o=h.originalLoopsCount,s=i-o,r=h.items[0],l=[];t.loops.length>o&&(l=t.loops).splice(0,o),r.resultInfo.loopCount=h.originalLoopsCount=i,l.length&&(e.loops=e.loops.concat(l)),T(e,1,i,s),r.loops&&delete r.loops}var c;(t=e).compareData&&((c=t.compareData)&&c.length&&(h.clear(),u(),I(),c.forEach((function(e){e&&e.resultInfo&&(e.resultInfo.pointConstructor=d()),h.items.push(e)}))),delete t.compareData),n=!!e.withCallstacks,_(a.get()),e.isFiltered&&O(e.loops)}}(e)):function(e){if(t&&e&&e.loops&&e.resultInfo){var i=t.loops.length,o=function(e,t){if(e&&e.loops&&e.resultInfo){h.items.length||I();var i=h.getIndexByPath(e.resultInfo.path);if(i>=0&&(t=h.items[i].resultInfo.baseIndex),t>=0){var o,n=i>=0?i:h.items.length;return e.loops.forEach((function(e){e.resIndex=n,S(e,t)})),e.resultInfo.baseIndex=t,e.resultInfo.loopCount=e.loops.length,e.resultInfo.id=e.resultInfo.id||A(),f(e),i>=0?(o=h.items[i],e.resultInfo.pointConstructor=o.resultInfo.pointConstructor,h.items[i]=e,o.replasedResultIndex=i):(e.resultInfo.pointConstructor=d(),h.items.push(e)),o}}}(e,i);if(e.isFiltered&&O(e.loops),o){var n=e.loops.length-o.resultInfo.loopCount,s=o.resultInfo.baseIndex+o.resultInfo.loopCount,r=t.loops.slice(0,o.resultInfo.baseIndex),a=t.loops.slice(s);t.loops=r.concat(e.loops,a),s+=n,T(t,o.replasedResultIndex+1,s,n),V(e.resultInfo.path)}else t.loops=t.loops.concat(e.loops);delete e.loops,null==h.originalLoopsCount&&(h.originalLoopsCount=i)}}(e),h.minMax&&delete h.minMax)},updateComparisonResults:function(e){var i=function(e){const i=e.path1,o=e.path2,n="current"===i?0:h.getIndexByPath(i);if(n<0)return;const s="current"===o?0:h.getIndexByPath(o);if(!(s<0)&&n!==s){var r=(e,t,i)=>P(e)===P(t)&&z(e.resIndex,i);return e.comparison&&e.comparison.length>0?e.comparison.forEach((function(e){var a=t.loops.find((t=>r(t,e[i],n)));if(!a)return;var l=t.loops.find((t=>r(t,e[o],s)));if(!l)return;a.matchingLoops||(a.matchingLoops=[]),l.matchingLoops||(l.matchingLoops=[]);const c=a.matchingLoops.findIndex((e=>z(l.resIndex,e.resIndex)));a.matchingLoops.splice(c,c>-1?1:0,l);const d=l.matchingLoops.findIndex((e=>z(a.resIndex,e.resIndex)));l.matchingLoops.splice(d,d>-1?1:0,a)}),this):t.loops.forEach((function(e){function t(t,i){e&&z(e.resIndex,t)&&function(e,t){if(!e||!e.matchingLoops||!e.matchingLoops.length)return;let i=e.matchingLoops.filter((e=>!(e&&z(e.resIndex,t))));delete e.matchingLoops,i.length&&(e.matchingLoops=i)}(e,i)}t(n,s),t(s,n)})),function(e,t){const i=e.resultInfo&&e.resultInfo.path?e.resultInfo.path:"current";function o(e,t){e.compared?e.compared.add(t):e.compared=new Set([t])}function n(e){return!!(e.compared.size>=h.items.findIndex((t=>t===e))&&e.resultInfo)&&(delete e.resultInfo.comparing,!0)}return o(e,t.resultInfo&&t.resultInfo.path?t.resultInfo.path:"current"),o(t,i),n(e)||n(t)}(h.items[n],h.items[s])}}(e);return e.isLastComparison&&this.isFiltered()&&(this.forEachLoopsSimple(this.getLoops(),(function(e){e.filtered&&delete e.filtered})),O(this.getLoops())),i},getRooflineData:function(){return t},getRooflineData4Loop:function(e){if(e)return e.resIndex?h.items[e.resIndex]:t},getMemoryLevelPrefix:function(e,t){return t=t||this.getRooflineData4Loop(e),e&&e.memoryLevelPref||(t&&t.memoryLevelPref?t.memoryLevelPref:"L1 ")},isHierarchical:function(){return n},getProp:function(e){if(t)return t[e]},getProgramTotalValue:function(e,i){var o=0;return t&&i&&(o=(e=e||0)>0&&e<h.items.length?h.items[e][i]:t[i]),o||0},getLoops:function(){return t&&t.loops?t.loops:[]},getRoofs:function(e,t,i){return a.get(e,t,i)||[]},getParent:function(e,i){if(e&&t&&t.loops&&void 0!==e.parent){if(i)for(var o;(o=x(e.parent))&&w(e,o,i);)e=o;return x(e.parent)}},setHierarchicalData:function(t){e=t},addRoofs:function(e,t,i,o){e&&(_(e),a.add(e,t,i,o))},setRoofsStrategyId:function(e){a.setStrategyId(e)},getRoofsStrategyId:function(){return a.getStrategyId()},setThreadCount:function(e){a.setThreadCount(e)},getThreadCount:function(){return a.getThreadCount()},setPackageCount:function(e){a.setPackageCount(e)},getPackageCount:function(){return a.getPackageCount()},setAllRoofsLoaded:function(e){a.setAllRoofsLoaded(e)},areAllRoofsLoaded:function(){return a.areAllRoofsLoaded()},applySavedHierarchy:function(t){e&&(e.forEach((function(e){if(e){var i=t[e.i];i&&function(e,t){return e.name===t.n}(i,e)&&i.state===(n?"-":"+")&&(i.state=m())}})),e=void 0)},getHierachicalData:function(){if(t)return function(e){if(e){var t=[];return e.forEach((function(e,i){e&&e.state===m()&&t.push({i,n:e.name})})),t}}(t.loops)},isNoLoopPosition:y,getLoopPosition:b,forEachLoops:g,forEachLoopsSimple:function(e,t){e&&e.forEach((function(e){t(e,void 0)}))},forEachChildren:function(e,i,o){if(e&&e.children&&t&&t.loops){for(var n;o&&e.children&&1===e.children.length&&(n=x(e.children[0]))&&n.children&&n.children.length&&w(e,n,o);)e=n;e&&e.children&&e.children.forEach((function(e){var t=x(e);t&&i(t)}))}},forEachChildrenEx:function(e,t,i){e&&this.forEachLoops(e.children,t,i,e)},forEachRoofs:function(e){this.getRoofs().forEach(e)},forEachAllRoofs:function(e){a.forEach(e)},isResultEmpty:function(e){var t=h.items[e];return!(t&&0!==t.resultInfo.loopCount)},getResultCount:function(){return h.items.length},getResultCaption:function(e){var t=h.items[e];if(t&&t.resultInfo)return t.resultInfo.caption},getResultInfo:function(e){var t=h.items[e];return t&&t.resultInfo},getResultIndex:function(e){return h.getIndexByPath(e)},setExtraData:function(e,i,o){var n;(n=o?h.items[o]:t)&&(n.extraData||(n.extraData={}),n.extraData[e]=i)},getExtraData:function(e,i){return function(t){if(t&&t.extraData)return t.extraData[e]}(i?h.items[i]:t)},removeResult:function(e){if(!(e<=0)){var i=h.items[e];if(i&&i.resultInfo){p(i.resultInfo.pointConstructor);for(var o=i.resultInfo.loopCount,n=i.resultInfo.baseIndex,s=n;s<n+o;++s)B(t.loops[s]);t.loops.splice(n,o),V(i.resultInfo.path),h.items.splice(e,1),o>0&&T(t,e,n,-o),s=n;for(var r=t.loops.length;s<r;s++){var a=t.loops[s];a.resIndex&&(a.resIndex-=1)}h.items.length<=1&&(h.clear(),u())}}},removeResultByPath:function(e){if(!e)return!1;var t=h.getIndexByPath(e);return this.removeResult(t),t>=1},clearCompareData:function(){if(void 0!==h.originalLoopsCount){var e=t.loops.length-h.originalLoopsCount;t.loops.splice(h.originalLoopsCount,e),t.loops.forEach((function(e){B(e)})),h.clear(),u()}},getCompareData:function(){for(var e=[],t=1,i=h.items.length;t<i;t++){var o={};r.default.copyObject(h.items[t],o,(function(e,t){return 0!==t.indexOf("roof")&&"compareItem"!==t?e:null})),e.push(o)}return e},forEachMatchingLoops:N,getMinMax:function(){var e=[{name:"minX",fn:Math.min},{name:"minY",fn:Math.min},{name:"maxX",fn:Math.max},{name:"maxY",fn:Math.max}];if(!h.minMax){var i={minX:0,minY:0,maxX:0,maxY:0};t&&e.forEach((function(e){i[e.name]=t[e.name]}));var o=h.items.length;if(o>1)for(var n=1;n<o;n++){var s=h.items[n];e.forEach((function(e){var t=s[e.name];void 0!==t&&(i[e.name]=e.fn(t,i[e.name]))}))}h.minMax=i}return h.minMax},getViewFrame:function(){var e={minIntens:0,minPerf:0,maxIntens:0,maxPerf:0};return t&&(e.minIntens=t.minIntens,e.minPerf=t.minPerf,e.maxIntens=t.maxIntens,e.maxPerf=t.maxPerf),e},FilterOperation:L,clearFiltering:function(){var e=l;return l=[],this.forEachLoopsSimple(this.getLoops(),(function(e){e.filtered&&delete e.filtered})),e},isFiltered:function(){return!!l.length},addFilterInfo:function(e){e&&(Array.isArray(e)||(e=[e]),l.length||D(this.getLoops()),e.forEach(k.bind(void 0,this.getLoops(),!0)),l=l.concat(e))},remFilterInfo:function(e){e&&(Array.isArray(e)||(e=[e]),l.length===e.length&&l.every((function(t,i){return t===e[i]}))?this.clearFiltering():e.forEach(function(e){var t=l.indexOf(e);t>=0&&(k(this.getLoops(),!1,e),l.splice(t,1))}.bind(this)))},getLoopId:function(e){return P(e)+M(e)},getLoopKey:E,getLoopByIndex:x,setPointConstructors:function(e){c(e)},getPointConstructor:function(e){var t;if(e>0){var i=h.items[e];i&&i.resultInfo&&(t=i.resultInfo.pointConstructor)}return t},updateWholeView(e,t,i,o){G("wholeMinMax",e,t,i,o)},updateFitView(e,t,i,o){G("fitMinMax",e,t,i,o)},setWholeView:function(e){var i;(i=e?t.wholeMinMax:t.fitMinMax)&&(t.minX=i.minX,t.maxX=i.maxX,t.minY=i.minY,t.maxY=i.maxY,delete h.minMax)},destroy:function(){h.clear(),t=void 0,a.clear(),this.clearCompareData()}}};var _=i(12715),y=i(1919);const b=function(e,t,i){var o=[];function n(){this._columnCount=1,this._rowCount=100,this.changed=a.A.create()}n.prototype.getColumnCount=function(){return this._columnCount},n.prototype.getRowCount=function(){return o.length||0},n.prototype.getColumnCaption=function(){return""},n.prototype.getCell=function(t,i){var n="";if(t>=0&&t<o.length){var s=o[t].loop,r=(n=s.name,s.locat);n&&"["!==n[0]&&r&&(n+=" at "+r);var a=s.rooflinePoint;if(a&&!s.filtered){var l=o[t].backgroundColor;l||((l=a.el.getAttr("data-color"))||-1!==(l=window.getComputedStyle(a.el.el,null).getPropertyValue("fill")).indexOf("url")&&(l="lightgray"),o[t].backgroundColor=l),l||(l="lightgray"),n={innerHTML:n,style:{backgroundImage:_.A.getPointIcon(e.getPointConstructor(s.resIndex)||_.A.CirclePoint,l)}}}}return n},n.prototype.getCellStyle=function(e,t,i,n,s){var r;if(n>=0&&n<o.length&&(r=o[n])&&r.loop&&r.loop.rooflinePoint){var a=r.loop.rooflinePoint.el;if(a&&a.isHidden()||r.loop.filtered)return i+" "+(e?t+" ":" ")+"hidden_loop"}},n.prototype.toString=function(){return"[object DataModel]"};var r,l=new n;return{create:function(e,n,a,c){if(e&&e.classList)return e.classList.add("roofline_stack_view"),(r=y.A.create(e,"0")).hideHeader(),r.setDataModel(l),"function"==typeof n&&r.gridBody.onChangeCurrentRow.subscribe(this,(function(e){this.processFill?delete this.processFill:n(o[e].loop)})),"function"==typeof a&&r.gridBody.onDblClick.subscribe(this,(function(e){a(o[e].loop)})),"function"==typeof c&&r.gridBody.onContextMenu.subscribe(this,(function(e,t,n,r,a,l,d){var p=[];if(e>=0){var u=o[e].loop;u&&u.state&&p.push({caption:"-"===u.state?s.A.getMessage("roofline_menu_collapse"):s.A.getMessage("roofline_menu_expand"),command:c.bind(this,u)})}n.stopPropagation=!1,i.show(p,a,l),i.defProcessing(d)})),t.onChangeSettings.subscribe(this,(function(e){"colorMode"!==e&&"defLoopColor"!==e&&"nstLoopColor"!==e&&"loopsThs"!==e||this.refresh()})),this},fill:function(t){if(this.currentLoop!==t){for(this.currentLoop=t,o=[];t;)o.unshift({loop:t}),t=e.getParent(t);o.length&&"Total"===o[0].loop.name&&o.shift(),l.changed.raise(),this.processFill=!0,r.gridBody.setCurrentRow(o.length-1),r.gridBody.currentToVisibleBottom()}},refresh:function(e){e&&e!==this.currentLoop&&!o.some((function(t){return t.loop===e}))||(o.forEach((function(e){e&&e.backgroundColor&&delete e.backgroundColor})),setTimeout((function(){l.changed.raise({regetStart:0,regetCount:o.length})}),10))},destroy:function(){r.destroy()}}};var w=i(75609),x=i(49463),C=i(90895);const A=function(e,t,i,o,n,a,l){var d,u,h,m,f,v,g="infoSection",y=1,b={},A="loops_table_body",S=t.get();function T(e){e&&(v||(v=r.default.createAsyncCall(p.Ay.sendNotification.bind(p.Ay,"hierarchy"),p.Ay,1e4)),v.call(e))}function I(){return o("roofline_settings")}var P="progTime",M=function(){var e,t=o("roofline_loop_weight_base"),i=o("roofline_loop_weight_formula");function n(){var t=h.getRooflineData();if(!t||!e)return"";var i=t.attrs[e].name.toLowerCase();return"point "+i+" / program "+i.replace(s,r)+" * 100 (%)"}t&&(t.onchange=function(){var o=t.selectedOptions;o&&1===o.length&&(e=o[0].value,S.save(P),z(),O.fillHistogramLoops(),O.fillHistogramChart(),i&&(i.innerHTML=n()))});const s="self",r="total";var a={refresh:function(){var o=h.getRooflineData();if(o&&t){t.innerHTML="";var s=0;Object.getOwnPropertyNames(o.attrs).forEach((function(i){if(i){var n=o.attrs[i];if(n&&h.getProgramTotalValue(0,i)>0){var r=document.createElement("option");r.text=n.name,r.value=i,t.add(r),i===e&&(s=t.length-1)}}})),t.selectedIndex=s,t.length&&(e=t.options[s].value),i&&(i.innerHTML=n())}},calcWeight:function(t,i){let o=0;const n=h.getProgramTotalValue(i,e);return 0!==n&&(o=t/n*100,o>100&&(o=100)),o},getLoopValue:function(t){if(!t||!e)return 0;let i=0;if("+"===t.state)i=this.getLoopTotalValue(t);else if(!h.isNoLoopPosition(t)){let o=e;i=t[o],void 0===i&&0===o.indexOf(r)&&(o=o.replace(r,s),i=t[o]),Number.isFinite(i)||(console.error("Loop value is not a number",i,t,o),i=0)}return i},getLoopTotalValue:function(t){if(!t||!e)return 0;let i=e;0===i.indexOf(s)&&(i=i.replace(s,r));let o=t[i];return void 0===o&&(i=i.replace(r,s),o=t[i]),Number.isFinite(o)||(console.error("Loop value is not a number",o,t,i),o=0),o},getWeightFormula:n,apply:function(t){t.weightBaseValue&&(e=t.weightBaseValue)},saveState:function(t){t&&(t.weightBaseValue=e)}};return a}();function E(e){return void 0===e?0:e}function L(e,t){var i={isValid:!1,isNew:!0};if(!e||!t)return i;var o=t.style.backgroundColor.toLowerCase();t.style.backgroundColor="",t.style.backgroundColor=e;var n=t.style.backgroundColor.toLowerCase();return o===n?(i.isValid=!0,i.isNew=!1):i.isValid=!!n,i.isValid||(t.style.backgroundColor=o),i}S.addProcessor(P,M);var R,D,k="loopsThs",O=function(){var t,i,c,v,P=0,R=0,V=0;function G(e){return r.default.round(e,V)}function F(){return Math.min(Math.max(P+5,10),100)}function U(e){var t=0,i=M.getLoopValue(e);return i>0&&((t=r.default.round(M.calcWeight(i,e.resIndex),V))<R?t=R:t>100&&(t=100)),t}function j(e){if(e){var t=U(e);if(t){P=Math.max(P,t);var i=G(t-R);void 0===c[i]&&(c[i]=0),c[i]++,v++}}}function Y(e){if(e){var t=U(e);if(t){var i=G(t-R);c[i]--,v--}}}function W(e){var o=S.getState();return e&&!i&&(i=o.loopsThs?JSON.parse(JSON.stringify(o.loopsThs)):[]),e&&!o.loopsThs&&(o.loopsThs=JSON.parse(JSON.stringify(t))),e&&(m.disabled=!1,f.disabled=!1),t||function(){function e(e,t){return Math.ceil(M.calcWeight(e,t))}var i=[];h.forEachLoops(h.getLoops(),(function(e){e.resIndex||i.push({loopValue:M.getLoopValue(e)})}),!1),i.sort((function(e,t){return t.loopValue-e.loopValue}));var o=i.length,n=Math.floor(.03*o)||1;n>5&&(n=5);var s=Math.floor(.25*o)||1;t=[];var r=20;r>=P&&(r=P-10*R);var a=1;if(a>=r&&(a=r/2),o>3&&P){var l=i[n];r=e(l.loopValue,l.resIndex)||2*R||2;var c=i[n+s];(a=e(c.loopValue,c.resIndex)||R||1)>=r&&(a=r/2)}t.push({th:a,radius:Math.round(4*y),color:"green"}),t.push({th:r,radius:Math.round(6*y),color:"yellow"}),t.push({radius:Math.round(8*y),color:"red"})}(),o.loopsThs||t}var X=function(){let e,t,i,o=!1;function n(){return 10*y+1}return{create:function(o){if(i)return;const s=n(),r=2*y;o=o||function(){},e=d.centralPart.graphicsRoot.createDefs();let a=e.createG("expanderTemplate").addRect(0,0,s,s).getParent().addLine(r,s/2,s-r,s/2,"roofline_expander_horz_line").getParent();t=a.addLine(s/2,r,s/2,s-r,"roofline_expander_vert_line"),i=d.getForegroundLayer().createUse().setRef(e.localRef("expanderTemplate")).setClass("roofline_expander").activate().on("mousedown",o),this.hide()},isValid:function(){return!!i},hide:function(e){i&&(i.setX(-100).setY(-100),e||delete i.rooflineLoop)},refreshState:function(e){e&&t&&("-"===e.state?t.style("visibility","hidden"):"+"===e.state&&t.style("visibility",""))},connect:function(e){i&&(i.rooflineLoop=e)},isConnected:function(){return i&&i.rooflineLoop},isConnectedTo:function(e){return i&&i.rooflineLoop===e},getConnectedLoop:function(){if(i)return i.rooflineLoop},setPos:function(e,t,o){if(i){var s=n()/2;i.setX(e-1.5*s-o).setY(t-s)}},clear:function(){i=e=t=void 0,o=!1},front:function(){i&&i.front()},setIgnored:function(e){o=e},isIgnored:function(){return o}}}();function q(e,t){function i(e,t){t=t||!1,e&&h.forEachChildrenEx(e,(function(e){e&&e.rooflinePoint&&(t?(e.rooflinePoint.show(),j(e)):(e.rooflinePoint.hide(),X.isConnectedTo(e)&&(te(e),ie(e),X.hide()),Y(e)))}))}function o(){function e(e,t){e&&(this.fillLoop(e,t),X.isConnectedTo(e.loopData)&&this.highlightPoint(e),e.x=t.getX(),e.y=t.getY())}n.forEach(function(t){e.call(this,t.loop.rooflinePoint,t.newLoopInfo)}.bind(this)),l.send("loopChangedState",s)}if(e&&e.rooflinePoint){C.A.setLoopPointFront(e.rooflinePoint,d);var n=function(e){var t=[];const i=h.getLoopKey(e);return h.forEachLoopsSimple(h.getLoops(),(function(e){h.isFiltered()&&e.filtered||h.getLoopKey(e)===i&&t.push({loop:e})})),t}(e);n.length||(n=[{loop:e}]),n.forEach(function(e){var t=e.loop;e.oldLoopInfo=this.getLoopInfo(t),Y(t),"+"===t.state?(t.state="-",i(t,!0)):"-"===t.state&&(i(t,!1),t.state="+"),j(t)}.bind(this)),e.state&&(this.fillHistogramChart(),T(h.getHierachicalData()),d.companions.stackView.refresh(e)),n.forEach(function(e){var t=this.getLoopInfo(e.loop),i=e.oldLoopInfo;e.x=i.getX(),e.x1=t.getX(),e.y=i.getY(),e.y1=t.getY(),e.r=i.getRadius(),e.r1=t.getRadius(),e.newLoopInfo=t}.bind(this));var s=n.map((e=>e.loop));l.send("loopChangingState",s),n[0].x!==n[0].x1||n[0].y!==n[0].y1?(te(e),ie(e),X.setIgnored(!0),X.hide(!0),r.default.animate((function(e){var t=e/700;return t>1&&(t=1),n.forEach((function(e){var i=e.x+(e.x1-e.x)*t,o=e.y+(e.y1-e.y)*t,n=e.r+(e.r1-e.r)*t,s=d.tr.L2P(i,o);e.loop.rooflinePoint.move(s.x,s.y).setR(n)})),t<1}),function(){X.setIgnored(!1),o.call(this)}.bind(this))):o.call(this),t||u.addUndoFrame({process:q.bind(this,e,!0)})}}function Z(){X.create(function(e){var t=e.target.owner.rooflineLoop;t&&q.call(this,t)}.bind(this))}function Q(){var e=10*y/(window.devicePixelRatio||1);return{x:Math.abs(d.tr.getMaxIntens()-d.tr.getMinIntens())*e/d.tr._getClientWidth(),y:Math.abs(d.tr.getMaxPerf()-d.tr.getMinPerf())*e/d.tr._getClientHeight()}}var K="ChildArrow",$="ParentArrow";function J(e,t,i){this.line=d.getForegroundLayer().addLine(e[0].x,e[0].y,e[1].x,e[1].y,i),this.line.setStyle(t.head+":"+this.line.localUrl(t.id))}function ee(e){if(e){var t=h.getParent(e,Q());if(t&&!t.filtered){C.A.setLoopPointFront(t.rooflinePoint,d);var i=new J(C.A.getLoopPoints(e,t,!0),{id:$,head:"marker-start"},"roofline_parent_line");e.rooflineConnectedParent={loop:t,line:i}}}}function te(e){e&&e.rooflineConnectedChildren&&(e.rooflineConnectedChildren.forEach((e=>e.line.remove())),delete e.rooflineConnectedChildren)}function ie(e){e&&e.rooflineConnectedParent&&(e.rooflineConnectedParent.line.remove(),delete e.rooflineConnectedParent)}function oe(e,t,i){var o="loopFill-"+e+"-"+t;return i&&(o+="-"+i),o}function ne(e,t,i){return 0===t?e:void 0!==i?"#ffa500":"#3473d4"}function se(e,t){e&&(e.filtered&&console.error("Filtering of already filtered loop"),t.push(h.getLoopKey(e)))}function re(e,t,i){if(t&&i&&e!==h.FilterOperation.out&&(e!==h.FilterOperation.insubtree||h.isHierarchical())){var o=[];return i.forEach((function(i){if(i){var n=h.getLoopKey(i);t.some((e=>e===n))&&(e===h.FilterOperation.insubtree&&h.forEachChildrenEx(i,(e=>se(e,o)),!0),h.forEachMatchingLoops(i,(function(t){se(t,o),e===h.FilterOperation.insubtree&&h.forEachChildrenEx(t,(e=>se(e,o)),!0)})))}})),o}}function ae(e){var t=[];d.selectedPoints.forEach((function(e){e&&se(e.loopData,t)}));var i={};return i[e]={keys:t,processing:re.bind(this,e)},i}function le(e){var t=e();h.addFilterInfo(t),l.send("rooflineDataUpdated",{isOldData:!0}),this.unHighlightPoint(),ce.call(this,[t],!1)}function ce(e,t){e&&u.addUndoFrame({process:function(){t?h.addFilterInfo(e):h.remFilterInfo(e),l.send("rooflineDataUpdated",{isOldData:!0}),t=!t}.bind(this)})}function de(){var e=d.selectedPoints;return e&&e.length}function pe(){x.A.DefValueRepresentation.call(this)}function ue(e,t){e.setStyle("cursor: pointer; stroke: transparent; stroke-width:"+he+"; marker-start:"+e.localUrl(t))}J.prototype.update=function(e){this.line.setX1(e[0].x).setY1(e[0].y).setX2(e[1].x).setY2(e[1].y)},J.prototype.remove=function(){this.line&&this.line.remove(),delete this.line},pe.prototype=Object.create(x.A.DefValueRepresentation.prototype);const he=19,me="SliderActive",fe="Slider";function ve(e){return e+" < "+s.A.getMessage("roofline_settings_loop_weight_abr")+" ≤"}function ge(e){var t=d.companions.get(g);if(t){if(e){let i=H.accepted;H.accepted=O.getLoopByElement(e)||e.loopData,t.innerHTML=H.getText(),H.accepted=i}else t.innerHTML="";let i=Array.from(t.parentElement.children||[]).find((e=>"BUTTON"===e.tagName));i&&(i.disabled=""===t.innerHTML)}}return pe.prototype.create=function(e,t,i,o,n){o.textY=12,o.tickStartY=10,x.A.DefValueRepresentation.prototype.create.call(this,e,t,i,o,n),ue(this.line,fe),this.line.activate(),this.line.el.isMovableItem=!0,this.line.on("mouseenter",ue.bind(this,this.line,me)),this.line.on("mouseleave",ue.bind(this,this.line,fe)),this.text.activate(),this.text.el.isMovableItem=!0,this.text.on("mouseenter",ue.bind(this,this.line,me)),this.text.on("mouseleave",ue.bind(this,this.line,fe))},{setRoofline:function(e){h=(d=e).companions.rooflineData,d.companions.onChange.subscribe(null,(function(){var e=d.companions.get("sidePanel"),t=d.companions.get(g);if(e&&!t){t=e.addSection("%roofline_point_info_caption%","pointInfo");var i=document.createElement("div");i.classList.add("roofline_point_info");var o=document.createElement("button");o.innerHTML="%roofline_toolbar_copy_clipboard%",o.addEventListener("click",(function(){var e=document.createElement("textarea");e.value=i.innerText,i.appendChild(e),e.select(),document.execCommand("copy"),i.removeChild(e)})),t.content.appendChild(i),t.content.appendChild(o),d.companions.add(g,i),o.disabled=""===i.innerHTML}})),d.onCurrentPointChanged.subscribe(null,ge),d.centralPart.body.addEventListener("wheel",B,!0),d.centralPart.body.addEventListener("contextmenu",function(e){var t,i=[];h.isHierarchical()&&((t=this.getLoopByElement(e.target))&&t.state&&i.unshift({caption:"-"===t.state?s.A.getMessage("roofline_menu_collapse"):s.A.getMessage("roofline_menu_expand"),command:function(){this.changeLoopState(t)}.bind(this)},{caption:"-"}),h.isFiltered()||i.push({caption:s.A.getMessage("roofline_menu_collapse_root"),disabled:this.IsRootCollapsed(),command:function(){this.collapseRoot()}.bind(this)},{caption:s.A.getMessage("roofline_menu_expand_all"),disabled:!this.canExpandAll(),command:function(){this.expandAll()}.bind(this)},{caption:"-"})),i.push({caption:s.A.getMessage("roofline_filter_in_label"),disabled:!de(),command:le.bind(this,ae.bind(this,h.FilterOperation.in))}),h.isHierarchical()&&i.push({caption:s.A.getMessage("roofline_filter_in_subtree_label"),disabled:!de(),command:function(){le.call(this,ae.bind(this,h.FilterOperation.insubtree)),d.onCurrentPointChanged.raise(d.currentPoint)}.bind(this)}),i.push({caption:s.A.getMessage("roofline_filter_out_label"),disabled:!de(),command:function(){le.call(this,ae.bind(this,h.FilterOperation.out)),d.onCurrentPointChanged.raise(d.currentPoint)}.bind(this)}),i.push({caption:s.A.getMessage("roofline_filter_clear_label"),disabled:!h.isFiltered(),command:function(){this.cancelFiltering()}.bind(this)}),t&&(i.length&&i.push({caption:"-"}),i.push({caption:s.A.getMessage("roofline_toolbar_copy_clipboard"),command:function(){var e=H.getText.call({accepted:t});e=w.A.unEscapeHTML(e.replace(/<br>/gi,"%0A").replace(/<[^>]*>/g,"")),p.Ay.sendNotification(n("copy:"+e))}.bind(this)})),a.show(i,e.pageX,e.pageY),a.defProcessing(e)}.bind(this),!1)},setZoomer:function(e){u=e},setScale:function(e){y=e},setConfiguration:function(e){e&&r.default.applyObjectProperties(b,e)},clear:function(){this.unHighlightPoint(),X.clear(),D=void 0},getLoopByElement:function(e){var t;if(e)return e.roofLinePoint?t=e.roofLinePoint.loopData:e.owner&&e.owner.rooflineLoop&&(t=e.owner.rooflineLoop),t},getLoopInfo:function(e){function t(e){return void 0!==e?e:100}var i=this.getLoopColor||ne;if(e){var o,n=S.getState(),s=h.isNoLoopPosition(e),r=e.resIndex||0,a=M.calcWeight(M.getLoopValue(e),r);"-"===e.state&&(o=M.calcWeight(M.getLoopTotalValue(e),r));for(var l,c,d=h.getLoopPosition(e,s),p=E(n.colorMode),u=W(),m=0,f=u.length;m<f;m++)o&&!c&&o>a&&o<=t(u[m].th)&&(c=u[m].radius,e.isCustomTotalPoint&&(c+=1)),!l&&a<=t(u[m].th)&&(l={radius:Math.round(4*y),_x:d.x,_y:d.y,getRadius:function(){return this.totalRadius?this.totalRadius:this.radius},getX:function(){return this._x},getY:function(){return this._y}},!1!==n.useSizes&&(l.radius=u[m].radius),l.color=i(u[m].color,p,e.vec,n.defLoopColor));return!1!==n.useSizes&&c&&c>l.radius&&(l.patternId=oe(c,l.radius,1===p?e.vec:0),l.totalRadius=c),(s&&!n.ignoreNoLoopPosition||!h.isHierarchical()&&"-"===e.state)&&(l.noLoopPosition=!0,l.color=n.nstLoopColor),r&&(l.resIndex=r),l}},createLinesArrows:function(){e.createLineArrowMarker(K,"roofline_child_arrow",d,y),e.createLineArrowMarker($,"roofline_parent_arrow",d,y,0)},fillPatterns:function(e){if(d){var t,i="fill_patterns";if(e?t=d.centralPart.graphicsRoot.createDefs(i):(t=d.centralPart.graphicsRoot.getElementById(i))&&t.clear(),t){var o=W();if(o&&o.length){for(var n=E(S.getState().colorMode),s=[_.A.CirclePoint],r=1,a=h.getResultCount();r<a;r++){var l=h.getPointConstructor(r);if(!(s.indexOf(l)<0))break;s.push(l)}s.forEach((function(e){if(e)for(var i=1,s=o.length;i<s;i++)for(var r=o[i].radius,a=0;a<i;a++){var l=o[a].radius;n<1?e.createFillPattern(t,r,l,o[a].color,oe(r,l)):(e.createFillPattern(t,r,l,ne(o[a].color,n,1),oe(r,l,1)),e.createFillPattern(t,r,l,ne(o[a].color,n),oe(r,l)))}}))}}}},fillLoop:function(t,i){t&&i&&(i.noLoopPosition?(t.addClass("no_loop_position"),t.setFillColor(i.color)):(t.remClass("no_loop_position"),e.isSimpleView()||(i.patternId?t.setPatternId(i.patternId):t.setFillColor(i.color))),i.color?t.el.setAttr("data-color",i.color):t.el.remAttr("data-color"))},fillHistogramLoops:function(){var e;c=[],v=0,P=0,e=h.getLoops(),h.forEachLoops(e,(function(e){if(!e.filtered){var t=U(e);t&&(P=Math.max(P,t))}}),!1),function(){if(P){R=r.default.round(2*P/r.default.em2px(23),2)||.01;var e=.1;for(V=0;;){if(R>e){R=10*e;break}e/=10,V++}}else P=100,R=1,V=0}(),function(e){h.forEachLoops(e,(function(e){e.filtered||j(e)}),!1)}(h.getLoops())},fillLoops:function(){M.refresh(),l.send("loopsCreating"),this.createLinesArrows(),this.fillHistogramLoops(),this.fillPatterns(!0),function(e){e&&h.forEachLoops(e,function(e,t,i){if(!e.filtered){var o=this.getLoopInfo(e),n=d.addPoint(o.getX(),o.getY(),o.getRadius(),"roofline_loop",void 0,_.A.getPointConstructor(e.shape)||h.getPointConstructor(o.resIndex)||_.A.CirclePoint);n.loopData=e,e.rooflinePoint=n,this.fillLoop(n,o),i&&n.hide()}}.bind(this),!0)}.call(this,h.getLoops()),l.send("loopsCreated")},updateLoopVisualisation:N,highlightPoint:function(e){var t;if(e&&!X.isIgnored()&&!e.isHidden())if(X.isConnected()&&(te(X.getConnectedLoop()),ie(X.getConnectedLoop())),X.isValid()||Z.call(this),e.loopData.state&&" "!==e.loopData.state&&e.loopData.children&&e.loopData.children.length){var i=e.getX(),o=e.getY(),n=e.getR();X.setPos(i,o,n),X.connect(e.loopData),X.refreshState(e.loopData),"-"===e.loopData.state&&(t=e.loopData)&&h.forEachChildren(t,(function(e){if(!e.filtered){t.rooflineConnectedChildren||(t.rooflineConnectedChildren=[]),C.A.setLoopPointFront(e.rooflinePoint,d);var i=new J(C.A.getLoopPoints(t,e),{id:K,head:"marker-end"},"roofline_child_line");t.rooflineConnectedChildren.push({loop:e,line:i})}}),Q()),ee(e.loopData),C.A.setLoopPointFront(e,d),X.front()}else this.unHighlightPoint(),X.connect(e.loopData),ee(e.loopData),X.setPos(-100,-100,10),C.A.setLoopPointFront(e,d)},unHighlightPoint:function(){X.isConnected()&&(te(X.getConnectedLoop()),ie(X.getConnectedLoop()),X.hide())},changeLoopState:q,collapseThisPosition:function(e){for(var t=e,i=h.getParent(t);i&&i.x1===t.x1&&i.y1===t.y1;)t=i,i=h.getParent(t);"-"===t.state&&this.changeLoopState(t)},collapseRoot:function(){var e=h.getLoops()[0];e&&"-"===e.state&&this.changeLoopState(e)},IsRootCollapsed:function(){var e=h.getLoops()[0];return!!e&&"+"===e.state},expandAll:function(){function e(e,t){e.state=t}var t=[];if(h.forEachLoopsSimple(h.getLoops(),(function(i){"+"===i.state&&(e(i,"-"),t.push(i))}),!0),t.length>1)u.addUndoFrame({process:function(){t.forEach((function(t){t&&t.state&&e(t,"+"===t.state?"-":"+")})),l.send("rooflineDataUpdated"),T(h.getHierachicalData())}}),l.send("rooflineDataUpdated"),T(h.getHierachicalData());else if(t.length){var i=t[0];e(i,"+"),this.changeLoopState(i)}},canExpandAll:function(){var e=!1;return h.forEachLoopsSimple(h.getLoops(),(function(t){"+"===t.state&&(e=!0)})),e},fillSettings:function(){var e=o(A);r.default.removeAllChildren(e);var t=W(),i=0;t.forEach(function(o,n){var s=o.th||100,r=0;n-1>=0&&(r=t[n-1].th),this._fillLoopRow(e.insertRow(-1),o,s-r>0,i),i=o.th}.bind(this)),this._updateBtnsState(S.getState())},fillHistogramChart:function(e){function t(e,t){e.addStop("0%",t[0].color);for(var i=0,o=t.length;i<o;i++){var n=t[i].th?t[i].th/F()*100:0;n?(e.addStop(n+"%",t[i].color),e.addStop(n+"%",t[i+1].color)):e.addStop("100%",t[i].color)}}function i(e,t,i){e.createMarker(t).setMarkerWidth(he).setMarkerHeight(10).setRefX(a).setRefY(9).setOrient("0").setMarkerUnits("userSpaceOnUse").createPath().moveToAbs(0,9).lineToAbs(a,0).lineToAbs(he,9).lineToAbs(0,9).setD().setClass(i)}this._parent=this._parent||o(e),r.default.removeAllChildren(this._parent);let n=S.getState();if(v<1||!1===n.showHistogram)this._parent.style.display="none";else{this._parent.style.display="block",this.horzAxis=x.A.createHorzAxis(this._parent,!0),this.centralPart=x.A.createCentralPart(this._parent,!0);var a=he/2,l=this.horzAxis.canvas.createDefs();i(l,fe,"idvc2_roofline_histogram_slider"),i(l,me,"idvc2_roofline_histogram_slider_active"),this.axisCaption=r.default.createElement(M.getWeightFormula(),"idvc2_roofline_legend_axis_caption","",this._parent),this.centralPart.setViewbox(0,0,F(),v),this.horzAxis.setCentralPart(this.centralPart),this.centralPart.ontooltiptext=function(e,t,i){var o,n,a=r.default.floor(t,V);return o=G(a+R),n=c[a]||0,r.default.format(1!==n?s.A.getMessage("roofline_histogram_tooltip_loops"):s.A.getMessage("roofline_histogram_tooltip_loop"),o.toString(),n.toString())};var d=W(),p=this.centralPart.canvas.createDefs().createLinearGradient("FillGradient").setLeftRight();t(p,d);for(var u=0,h=d.length;u<h;u++){var m=d[u].th;m&&this.horzAxis.addValue(G(m),void 0,pe)}var f,g=this.centralPart.graphicsRoot.createPath();for(g.setClass("histogramLine").setAttr("fill",g.localUrl("FillGradient")).moveToAbs(0,0),u=0,h=F();u<h;u+=R)u=G(u),g.lineToVerticalAbs(c[u]||0).lineToHorizontalRel(R);g.lineToVerticalAbs(0).closePath().setD(),function(e,t){function i(e){e&&e.el&&e.el.getCTM()&&e.createTransform().setMatrix(e.el.getCTM().inverse())}var o;i(this.centralPart.graphicsRoot.createLine().setClass("idvc2_roofline_legend_total_line").setX1(1).setY1(1).setX2(t).setY2(1)),i(this.centralPart.canvas.createText((o=e,r.default.format(1!==o?s.A.getMessage("roofline_histogram_loops"):s.A.getMessage("roofline_histogram_loop"),o.toString()))).setClass("idvc2_roofline_legend_total_text").setX(t-3).setY(3).setStyle("text-anchor: end; dominant-baseline: text-before-edge;"))}.call(this,v,this.centralPart.body.offsetWidth),this._parent.classList.contains("user_activity")||this._parent.classList.add("idvc2_roofline_collapsed");var _,y,b,w=-1,C={init:function(e){var t=function(e){return o(A).children[I._getRowIndex4ThIndex(e)]}(e);t&&(y=function(e){if(e)return e.querySelector(".threshold_input")}(t),b=function(e){if(e&&e.nextSibling)return e.nextSibling.querySelector(".threshold_label")}(t))},update:function(e){y&&(y.value=e),b&&(b.innerHTML=ve(e))},clear:function(){y=void 0,b=void 0}},T=this.horzAxis,I=this;this.thMoving=r.default.createResizeProcess(T.body,{accepted:function(e){var t=e.isMovableItem;if(t&&(T.values.some((function(t,i){return(t.representation.text.el===e||t.representation.line.el===e)&&(w=i,!0)})),w>=0)){f=r.default.getElementPos(T.body);var i=W();_={min:0,max:100};var o=i[w-1];o&&(_.min=o.th),(o=i[w+1])&&(_.max=o.th||F()),C.init(w)}return t},getDeltaThreshold:function(){return 0},getDelta:function(e,t,i){return e.x-f.x},getCursor:function(){return"pointer"},onProcess:function(e){var i=G(e/T.body.clientWidth*F());if(i>_.min&&i<_.max){var o=W(!0);if(o[w].th===i)return;T.changeValue(w,i),T.layoutValues(),o[w].th=i,p.clear(),t(p,o),this._applyChanges(!0),C.update(i)}},onEnd:function(){f=void 0,w=-1,C.clear()}},this)}},processResize:function(e){e&&function(e){if(X.isConnected()&&e){var t=X.getConnectedLoop(),i=t.rooflinePoint;if(i){var o=i.getX(),n=i.getY(),s=i.getR();t.state&&" "!==t.state&&X.setPos(o,n,s),t.rooflineConnectedChildren&&t.rooflineConnectedChildren.forEach((e=>e.line.update(C.A.getLoopPoints(t,e.loop))));var r=t.rooflineConnectedParent;r&&r.line.update(C.A.getLoopPoints(t,r.loop,!0))}}}(e)},cancelFiltering:function(){if(h.isFiltered()){var e=h.clearFiltering();l.send("rooflineDataUpdated",{isOldData:!0}),this.highlightPoint(d.currentPoint),ce.call(this,e,!0)}},_getRowIndex4ThIndex:function(e){return e},_insertThSettings:function(e){var t=W(!0),i=t[e],n=i.th||100,s=0;e-1>=0&&(s=t[e-1].th);var r={radius:i.radius,color:i.color,th:s+(n-s)/2};if(r.th>s&&r.th<n){t.splice(e,0,r);var a=o(A),l=this._getRowIndex4ThIndex(e);this._updateTh4Row(l,r.th);var c=0;e>0&&(c=t[e-1].th),this._fillLoopRow(a.insertRow(l),r,r.th-s>0,c),this._applyChanges()}},_removeThSettings:function(e){var t=W(!0),i=0;e>0&&(i=t[e-1].th),t.splice(e,1);var n=o(A),s=this._getRowIndex4ThIndex(e);n.deleteRow(s),this._updateTh4Row(s,i),this._applyChanges()},_fillLoopRow:function(t,i,o,n){if(t&&i){t.className="loop_row";var s=t.insertCell(-1);s.className="loop_sample_cell";var a=r.default.createElement("","loop_sample","",s,"div",(function(e){e.style.backgroundColor=i.color,e.style.width=e.style.height=2*i.radius+"px"})),l=t.insertCell(-1);r.default.createElement("","size_input","",l,"input",function(t){t.setAttribute("value",i.radius),t.oninput=this._changeSize.bind(this,a),t.onblur=this._processBlur.bind(this,"radius"),t.onkeypress=e.filterNumberInput}.bind(this));var c=t.insertCell(-1);r.default.createElement("","color_input","",c,"input",function(t){t.setAttribute("type","text"),t.setAttribute("value",i.color),t.oninput=this._changeColor.bind(this,a),e.addColorPicker(t),t.onblur=this._processBlur.bind(this,"color")}.bind(this));var d=t.insertCell(-1);d.setAttribute("align","right"),r.default.createElement(ve(n),"threshold_label","",d,"label"),r.default.createElement("","threshold_input","",d,"input",function(t){t.setAttribute("value",i.th||100),t.oninput=this._changeTh.bind(this),t.onblur=this._processBlur.bind(this,"th"),t.onkeypress=e.filterNumberInput,t.disabled=!i.th}.bind(this));var p=t.insertCell(-1);p.setAttribute("align","right"),i.th&&r.default.createElement("","idvc2_roofline_icon idvc2_roofline_minus","",p,"button",function(e){e.onclick=this._removeTh.bind(this)}.bind(this)),r.default.createElement("","idvc2_roofline_icon idvc2_roofline_plus","",p,"button",function(e){e.onclick=this._insertTh.bind(this),e.disabled=!o}.bind(this))}},_updateTh4Row:function(e,t){o(A).children[e].querySelector(".threshold_label").innerHTML=ve(t)},_getRowByElement:function(e){if(e)return e.parentNode.parentNode},_getThIndex:function(e){var t=this._getRowByElement(e),i=t.parentNode;return[].indexOf.call(i.children,t)},_insertTh:function(e){var t=e.target;if(t){var i=this._getThIndex(t);this._insertThSettings(i)}},_removeTh:function(e){var t=e.target;if(t){var i=this._getThIndex(t);this._removeThSettings(i)}},_changeColor:function(t,i){var o=i.target;if(o){var n=o.value,s=L(n,t);if(s.isValid){if(s.isNew){var r=this._getThIndex(o);W(!0)[r].color=n,this._applyChanges()}e.markNormal(o,I())}else e.markWrong(o,"The value should be a valid CSS color",I())}},_changeSize:function(t,i){var o=i.target;if(o){var n=parseFloat(o.value),s=Math.round(12*y);if(!isNaN(n)&&n<=s&&n>0){t.style.width=t.style.height=2*n+"px";var r=this._getThIndex(o);W(!0)[r].radius=n,this._applyChanges(),e.markNormal(o,I())}else e.markWrong(o,"The value should be between 0 and "+s,I())}},_changeTh:function(t){var i=t.target;if(i){var o=parseFloat(i.value);if(!isNaN(o)){var n=this._getThIndex(i),s=W(!0),r=100;n+1<s.length-1&&(r=s[n+1].th);var a=0;if(n-1>=0&&(a=s[n-1].th),o<r&&o>=a){s[n].th=o;var l=function(e){return this._getRowByElement(e).querySelector(".idvc2_roofline_plus")}.call(this,i);l&&(l.disabled=o-a<=1),this._updateTh4Row(n+1,o),this._applyChanges(),e.markNormal(i,I())}else e.markWrong(i,"The value should be between "+a+" and "+r,I())}}},_processBlur:function(t,i){var o=i.target;if(o){var n=this._getThIndex(o),s=W(!0)[n][t].toString();o.value!==s&&(o.value=s,e.markNormal(o,I()))}},_processEnter:function(e){var t=e.target;t&&13===e.which&&t.oninput&&t.oninput(e)},_applyChanges:function(e){S.save(k),z(),e||this.fillHistogramChart()},_updateBtnsState:function(e){e=e||{},m.disabled=!i,f.disabled=!e.loopsThs},revertDefault:function(){var e=S.getState();e.loopsThs&&delete e.loopsThs,i=void 0,this.fillSettings(),this._applyChanges()},cancelChanges:function(){i.length?(S.getState().loopsThs=i,i=void 0,this.fillSettings(),this._applyChanges()):this.revertDefault()},apply:function(e){this._updateBtnsState(e)},saveState:function(e){this._updateBtnsState(e),e&&!e.loopThs&&(e.loopThs=W())},getLoopsThs:function(){return W()},updateInfoContent:ge}}();function N(e){if(e){var t=e.loopData;if(t){var i=O.getLoopInfo(t),o=i.getRadius();e.setR(o),O.fillLoop(e,i)}}}function z(){d&&(O.fillPatterns(),d.points.forEach(N))}function B(t){if(d.companions.processWheellScroll(t))return;const i=function(e){return R||(R=r.default.getElementPos(d.centralPart.body)),{x:e.pageX-R.x,y:e.pageY-R.y}}(t);let o;o=D?{x:D.x,y:D.y}:d.tr.P2L(i.x,i.y),t.deltaY<0?u.zoomIn(e.getDefZoomStep(),o):t.deltaY>0&&u.zoomOut(e.getDefZoomStep(),o),t.stopPropagation(),t.preventDefault()}S.addProcessor(k,O),l.recv("rooflineCleared",O.clear,O),l.recv("rooflineResized",O.processResize,O),l.recv("currentPointChanged",(function(e){O.highlightPoint(e),e&&e.loopData&&l.send("currentLoopChanged",e.loopData)})),l.recv("loopStateChanged",O.changeLoopState,O),l.recv("loopHighlighted",(function(e){if(e){var t=e.rooflinePoint;t&&C.A.setLoopPointFront(t,d)}})),l.recv("loopBottleneckChanged",(function(e){e&&e.loopData&&H&&H.accepted&&h.getLoopKey(e.loopData)===h.getLoopKey(H.accepted)&&O.updateInfoContent(e)}));var V='<span style="font-weight: bold">',G="</span><br>";function F(e,t,i){return isNaN(t)||!e?"":e[i.name]+c.pref+(o=t,(n=i.format)?n(o,3,!0):o)+c.post+e[i.measure];var o,n}var U=[{name:"selfTime",format:c.formatTime},{name:"selfElapsedTime",format:c.formatTime},{name:"totalTime",format:c.formatTime},{name:"totalElapsedTime",format:c.formatTime},{name:"selfMem",format:c.simpleFormat},{name:"totalMem",format:c.simpleFormat},{name:"effectiveBand",format:c.simpleFormat}],H=e.addTooltipProcessor({accepted:void 0,accept:function(e){if(!e)return!1;var t=O.getLoopByElement(e)||e.loopData;if(t)this.accepted!==t&&(this.accepted&&l.send("loopLeaved"),this.accepted=t,D=this.accepted.rooflinePoint,l.send("loopEntered",this.accepted));else{var i=!!this.accepted;this.accepted=void 0,D=void 0,i&&l.send("loopLeaved")}return!!this.accepted},getText:function(e){var t=this.accepted;if(t){var i=h.getRooflineData4Loop(t);if(i){var o=function(e){var t="";return e&&h.getResultCount()>1&&(t=s.A.getMessage("roofline_compare_tooltip_result_label")+" "+V+h.getResultCaption(e.resIndex||0)+G),t}(t)+function(e){var t=e.desc;return t||(t=w.A.escapeHTML(e.name))&&"["!==t.charAt(0)&&(t+=" "+(e.locat||"")),t||(t=e.locat),V+t+G}(t)+function(e,t){if(t&&t.loopTypes&&e&&e.type){var i=t.loopTypes[e.type];if(i)return i+"<br>"}return""}(t,i)+function(e,t){var i="";return e&&void 0!==e.y&&(t&&t.namePref&&(i+=t.namePref),i+=F(t,e.y,{name:"nameY",measure:"measureY",format:c.formatVal})+"<br>"),i}(t,i)+function(e,t){var i="";return e&&void 0!==e.y1&&(t&&t.namePref1&&(i+=t.namePref1),i+=F(t,e.y1,{name:"nameY",measure:"measureY",format:c.formatVal})+"<br>"),i}(t,i),n=U.map((e=>function(e,t,i){var o="";return e&&void 0!==e[i.name]&&(t.attrs[i.name]&&t.attrs[i.name].isMem&&(o+=C.A.getLoopMemoryLevelCaption(h.getMemoryLevelPrefix(e,t))+" "),o+=F(t.attrs[i.name],e[i.name],{name:"name",measure:"measure",format:i.format})),o}(t,i,e))).filter((e=>e));return o+=n.join("<br>")+"<br>"+function(e,t){var i="";return e&&void 0!==e.x&&(i+=C.A.getLoopMemoryLevelCaption(h.getMemoryLevelPrefix(e,t))+" ",t&&t.namePref&&(i+=t.namePref),i+=F(t,e.x,{name:"nameX",measure:"measureX",format:c.formatVal})+"<br>"),i}(t,i)+function(e,t){var i="";return e&&void 0!==e.x1&&(i+=C.A.getLoopMemoryLevelCaption(h.getMemoryLevelPrefix(e,t))+" ",t&&t.namePref1&&(i+=t.namePref1),i+=F(t,e.x1,{name:"nameX",measure:"measureX",format:c.formatVal})+"<br>"),i}(t,i)+function(e){var t="";return e&&e.boundedBy&&(t=s.A.getMessage("roofline_bounded_by_tooltip")+": "+V+e.boundedBy+"</span>",e.boundedByUtil&&(t+=" ("+e.boundedByUtil+")")),t}(t),o}}}});(m=o("cancel_loops_settings_button")).onclick=O.cancelChanges.bind(O),(f=o("revert_loops_settings_button")).onclick=O.revertDefault.bind(O),t.addCheckSetting(i.querySelector('input[value="size"][type="checkbox"]'),"useSizes",z),t.addRadioGroupSetting("roofline_color_mode","colorMode",z,0);var j="defLoopColor",Y="nstLoopColor";return function(t,i,n,s){var a=o("roofline_nst_loop_color_edit");r.default.disableDragging(a);var l=o("roofline_nst_loop_color_sample");a&&l&&(l.style.backgroundColor=s,a.oninput=function(t){var i=t.target.value,o=L(i,l);!i||o.isValid?(o.isNew&&(S.save(n),l.style.backgroundColor=i||s,z()),e.markNormal(a,I())):e.markWrong(a,"The value should be empty or a valid CSS color",I())},a.onblur=function(t){var i=t.target.value,o=L(i,l);i&&o.isValid||(a.value=s,e.markNormal(a,I()))},e.addColorPicker(a,(function(e,t){return!!e})),S.addProcessor(n,{apply:function(e){if(e){var t=s,i=e[n];void 0!==i&&(t=i),a.value=t,l.style.backgroundColor=t}},saveState:function(e){var t=e[n],i=a.value;i!==t&&(i&&i!==s?e[n]=i:t&&delete e[n])}}))}(0,0,Y,"#eee"),o("load_loops_settings_button").onclick=function(){p.Ay.sendNotification(n("loadLoopsColors"))},p.Ay.addConsumer(n("loadedLoopsColors"),{process:function(e){var t=S.getState();e.loopsThs&&(t.loopsThs=e.loopsThs,S.apply(void 0,k)),e.defLoopColor&&(t.defLoopColor=e.defLoopColor,S.apply(void 0,j)),e.nstLoopColor&&(t.nstLoopColor=e.nstLoopColor,S.apply(void 0,Y)),l.send("rooflineDataUpdated",{isOldData:!0}),S.save(k),S.save(j),S.save(Y)},onerror:function(t){t.message&&e.toast(t.message)}}),o("save_loops_settings_button").onclick=function(){var e={},t=S.getState();e.loopsThs=O.getLoopsThs(),t.defLoopColor&&(e.defLoopColor=t.defLoopColor),t.nstLoopColor&&(e.nstLoopColor=t.nstLoopColor),p.Ay.sendNotification(n("saveLoopsColors"),e)},O};var S=i(87011),T=i(8933);const I=function(e,t,i,o,n,s){var l,d,u,h=1,m={},f="roofsCrossing",g="roofsRepresentation",_="selected",y=t.get(),b=function(){var t="idvc2_chart_roofline_text_active",f="idvc2_roofline_line_hover",w="idvc2_hidden",C="TextBackground";function I(e){var t=e.target;if(t){var i=t.roofRepresentation;i&&(t.checked?i.show(!0):i.hide(!0),i.highlight(),function(e){if(e){var t,i,o=-Number.MAX_VALUE,n=Number.MAX_VALUE;u.forEachRoofs((function(s){s!==e&&s.hidden||!function(t){return!!e.isMem==!!t.isMem}(s)||(s.val>o&&(t=s,o=s.val),s.val<n&&(i=s,n=s.val))})),t!==e&&i!==e||s.send("rooflineDataUpdated",{isOldData:!0,changingRoofs:!0})}}(i.roofData),s.send("roofVisibilityChanged",u.getRoofs()),b._updateRoofsText(l.tr),b.updateSelection(),y.save(g))}}function P(e){var t=this;if(t){var i=t.roofRepresentation;i&&(i.setSelected(t.checked),s.send("roofSelectionChanged",u.getRoofs()),b._updateRoofsText(l.tr),b.updateSelection(),y.save(g))}}var M=0;function E(e,t){e&&(t?(e.style.fontWeight="bold",M++):(e.style.fontWeight="",M--),M<0&&(M=0))}async function L(e){var t=e.target;if(t){var i=t.roofRepresentation;if(i){var r=i.roofData;if(r){var a=c.formatVal(r.val,2,!0),l=parseFloat(t.value);if(isNaN(l)||!l)t.value=a;else if(a!==l){void 0===r.defVal?(r.defVal=r.val,E(t,!0)):l===c.formatVal(r.defVal,2,!0)&&(r.val=r.defVal,delete r.defVal,E(t,!1)),void 0!==r.defVal&&(r.val=Math.log10(l)),d.disabled=0===M;try{var h=e.relatedTarget;h&&h.roofRepresentation&&(b.activeRoofRepresentation=h.roofRepresentation)}catch(e){n.handleException(e)}s.send("rooflineDataUpdated",{isOldData:!0}),y.save(g),(0,T.P)()||await(0,p.mi)(o("changeRoofValue"),{configuration:S.A.getRoofsConfiguration(u.getThreadCount(),y.getState().useSTRoofsStrategy,u.getPackageCount()).str(),roofId:r.id,value:l,needResponse:1}),A()}}}}}function R(e){if(13===e.keyCode){var t=e.target;e.relatedTarget=t,t.onblur(e)}}function D(e){var t=e.target;b.activeRoofRepresentation=t.roofRepresentation}function k(){b.activeRoofRepresentation&&delete b.activeRoofRepresentation}function O(e){var t=e.target;if(t){var i=t.firstChild;i&&i.click()}}function N(t,i,o,n,s){function a(e,t,i){var n=r.default.createElement("","","",e,"input",(function(e){e.type="checkbox"}));return n.roofRepresentation=o,n.onclick=i,n.checked=t,e.className="roof_settings_input",e.roofRepresentation=o,e.onclick=O,n}var l=o.roofData,d=t.insertRow(-1);d.className=l.isMem?"roof_memory":"roof_calculation";var p=d.insertCell(0);p.innerHTML=i,p.style.whiteSpace="nowrap",p.roofRepresentation=o,a(d.insertCell(1),n,I);var u=a(d.insertCell(2),s,P);o.onClick.subscribe(u,u.click);var h=d.insertCell(3);h.style.whiteSpace="nowrap",h.roofRepresentation=o;var m=r.default.createElement("","value_input","",h,"input",(function(t){t.setAttribute("value",c.formatVal(l.val,2,!0)),void 0!==l.defVal&&E(t,!0),t.onkeydown=R,t.onblur=L,t.onkeypress=e.filterNumberInput,t.onmouseover=D,t.onmouseout=k,t.roofRepresentation=o,t.disabled=(0,T.P)()||e.isRoofsEditDisabled()}));this.activeRoofRepresentation&&this.activeRoofRepresentation===m.roofRepresentation&&(m.focus(),m.select(),r.default.dispatchElementMouseEvent("mousemove",m)),r.default.createElement(l.measure,"measure_label","",h,"label",(function(e){e.roofRepresentation=o}))}function z(e){return e.toLowerCase().replace("(single-threaded)","").replace(/\s/g,"")}function B(e){return e.replace(/\s*\(single.*\)/g,"")}function V(e){if(e&&e.el)return e.el.el}function G(t,i){var o=l.addRoof(i,"idvc2_roofline_line_hotarea",void 0,!0),n=l.addRoof(i,"idvc2_roofline_line "+t.name.replace(/\s+/g,""));o.el.activate(),this.line=n,this.hotLine=o,this.roofData=t,this.caption=B(t.name),this.text=this.createText(function(e,t){return B(e.name)+": "+t(e.val,2)+" "+e.measure}(t,c.formatVal)),this.onClick=a.A.create(),this.setTo(o),e.isSimpleView()||(V(this.hotLine).onclick=this.processRoofClick);var s=t.selected;s&&this._setSelectedVis(s)}function F(e,t){this.startY=t[0],G.call(this,e,t)}function U(e,t){G.call(this,e,t)}return G.prototype.setTo=function(e){V(e).roofRepresentation=this},G.getFrom=function(e){return V(e).roofRepresentation},G.prototype._setSelectedVis=function(e){var t=e?"addClass":"remClass";this.line.el[t](_),this.text&&this.text.svgText[t](_)},G.prototype.setSelected=function(e){var t=this.roofData;e?(t.selected=!0,t.userSelected=!0):(delete t.selected,t.userSelected=!1),this._setSelectedVis(e)},G.prototype.show=function(e){this.line.show(),this.hotLine.show(),delete this.roofData.hidden,e&&(this.roofData.userHidden=!1)},G.prototype.hide=function(e){this.unhighlight(),this.line.hide(),this.hotLine.hide(),this.roofData.hidden=!0,e&&(this.roofData.userHidden=!0)},G.prototype.clear=function(){var e=V(this.hotLine);e&&delete e.roofRepresentation,this.line=void 0,this.hotLine=void 0,this.roofData=void 0,this.text=void 0},G.prototype.highlight=function(){var e;V(this.line).classList.add(f),this.line.isHidden()||(e=this.text)&&(e.svgText.front(),e.svgText.addClass(t),e.svgText.setFilter(C)),this.line.el.front()},G.prototype.unhighlight=function(){var e;V(this.line).classList.remove(f),this.line.isHidden()||(e=this.text)&&(e.svgText.remClass(t),e.svgText.remFilter(C))},G.prototype.recalculate=function(e){if(e){var t=e(this.roofData);return this.line.change(t),this.hotLine.change(t),t}},G.prototype.processRoofClick=function(e){var t=e.target;t&&t.roofRepresentation&&t.roofRepresentation.onClick.raise(e)},G.prototype.setStyle=function(e){function t(e,t){if(e){var i=e.getStyle()||"";-1===i.indexOf(t)&&(i+=t,e.setStyle(i))}}(e=e||{}).line&&(this.line&&t(this.line.el,e.line),this.selectedLine&&t(this.selectedLine.el,e.selectedLine||e.line)),e.text&&this.text&&t(this.text.svgText,e.text)},G.prototype.clearStyle=function(e){function t(e,t){if(e){var i,o,n=(o=t,(i=e.getStyle())?i.replace(o,""):"");e.setStyle(n)}}(e=e||{}).line&&(this.line&&t(this.line.el,e.line),this.selectedLine&&t(this.selectedLine.el,e.selectedLine||e.line)),e.text&&this.text&&t(this.text.svgText,e.text)},F.prototype=Object.create(G.prototype),F.prototype.show=function(e){G.prototype.show.call(this,e),this.selectedLine&&this.selectedLine.show()},F.prototype.hide=function(e){G.prototype.hide.call(this,e),this.selectedLine&&this.selectedLine.hide()},F.prototype.highlight=function(){G.prototype.highlight.call(this),this.selectedLine&&(V(this.selectedLine).classList.add(f),this.selectedLine.el.front())},F.prototype.unhighlight=function(){G.prototype.unhighlight.call(this),this.selectedLine&&V(this.selectedLine).classList.remove(f)},F.prototype.clear=function(){G.prototype.clear.call(this),this.selectedLine&&delete this.selectedLine},F.prototype._setSelectedVis=function(e){if(G.prototype._setSelectedVis.call(this,e),void 0!==this.startY)if(this.line.el.remClass(_),e){var t=S.A.getTopSelectedRoof(u.getRoofs(),!1),i=S.A.getRoofsCrossing(this.roofData,t||{val:l.tr.getMaxPerf()});this.selectedLine=l.addRoof([this.startY,i.x,i.y],"idvc2_roofline_line "+_),this.selectedLine.el.after(this.line.el),this.line.el.isHidden()&&this.selectedLine.hide(),this.line.el.hasClass(f)&&this.selectedLine.el.addClass(f)}else this.selectedLine&&(this.selectedLine.remove(),delete this.selectedLine)},F.prototype.updateSelection=function(e){if(this.selectedLine){e=e||S.A.getTopSelectedRoof(u.getRoofs(),!1);var t=S.A.getRoofsCrossing(this.roofData,e||{val:l.tr.getMaxPerf()});this.selectedLine.change([this.startY,t.x,t.y])}},F.prototype.recalculate=function(e,t){if(e){var i=G.prototype.recalculate.call(this,e);this.startY=i[0],this.updateSelection(t)}},F.prototype.createText=function(e){if(this.hotLine&&this.roofData)return this.hotLine.setBeginText(e,void 0,void 0,!!this.roofData.desc),this.hotLine.startText},F.prototype.updateTextPos=function(e,t){this.hotLine.updateBeginOffsets(t,e)},U.prototype=Object.create(G.prototype),U.prototype.createText=function(e){if(this.hotLine&&this.roofData)return this.hotLine.setEndText(e,void 0,void 0,!!this.roofData.desc),this.hotLine.endText},U.prototype.updateTextPos=function(e,t){t=t||this.hotLine.endText.alongOffset,this.hotLine.updateEndOffsets(t,e)},{representations:[],setRoofline:function(e){u=(l=e).companions.rooflineData;var t=i("roofline_settings");l.centralPart.body.onmousemove=t.onmousemove=function(e){x.processMouseMove(e.target)},l.centralPart.body.onmouseout=t.onmouseout=function(e){x.processMouseOut(e.target)}},setScale:function(e){h=e},setConfiguration:function(e){e&&r.default.applyObjectProperties(m,e)},processResize:function(e){this._updateRoofsText(e)},clear:function(e){this.activeRoofRepresentation&&delete this.activeRoofRepresentation,this.representations.forEach((function(e){e.clear()})),this.representations.length=0,S.A.roofDefs.clear()},updateSelection:function(){var e=S.A.getTopSelectedRoof(u.getRoofs(),!1);this.representations.forEach((function(t){t.updateSelection&&t.updateSelection(e)}))},fillRoofsPatterns:function(){l.centralPart.graphicsRoot.createTextBackground(C,S.A.roofDefs.get(l))},fillRoofs:function(e,t){if(e){var o=i("roofs_table_body");r.default.removeAllChildren(o),M=0,this._captionTextHeight||(this._captionTextHeight=l.centralPart.canvas.getTextHeight({className:"idvc2_chart_roofline_text"})),e.sort((function(e,t){return!!t.isMem-!!e.isMem||t.val-e.val})).forEach(function(e){var i=function(e,t){if(e)return e.isMem?new F(e,t):new U(e,t)}(e,t(e));this.representations.push(i);var n=e.hidden;n&&i.hide(),N.call(this,o,i.caption,i,!n,e.selected)}.bind(this)),this._updateRoofsText(l.tr),this.updateSelection(),s.send("roofsCreated",e),this.activeRoofRepresentation&&delete this.activeRoofRepresentation}},recalculateRoofs:function(e,t){var i=S.A.getTopSelectedRoof(u.getRoofs(),!1);this.representations.forEach((function(e){e.recalculate(t,i)})),s.send("roofsUpdated",e)},apply:function(e){if(e&&u&&u.getThreadCount()){var t=u.getRoofs();if(t){var i=e.roofsState;t.forEach((function(t){var o=i?e.roofsState[z(t.name)]:null,n=o&&void 0!==o.userHidden?o.userHidden:t.userHidden;o&&(o.hidden&&void 0===n||t.userHidden||o.userHidden)?t.hidden=!0:delete t.hidden;var s=o&&void 0!==o.userSelected?o.userSelected:t.userSelected;o&&(o.selected&&void 0===s||o.userSelected||t.userSelected)?t.selected=!0:delete t.selected,void 0!==n?t.userHidden=n:delete t.userHidden,void 0!==s?t.userSelected=s:delete t.userSelected}))}var o=e.roofsValues?v(e.roofsValues):null,n=o?o.get(u.getThreadCount(),u.getRoofsStrategyId(),u.getPackageCount()):null,s=!1;o&&!n&&u.getPackageCount()&&(n=o.get(u.getThreadCount(),u.getRoofsStrategyId(),0),s=n),d.disabled=!o||o.empty(),t&&n&&t.forEach((function(e){if(!s||!S.A.isMatchedRoof(e,"dram")){var t=n[z(e.name)];t&&e.val!==t&&(void 0===e.defVal&&(e.defVal=e.val),e.val=t)}}))}},saveState:function(e,t){if(e)if((t=t||{}).clearRoofsValues)delete e.roofsValues;else{e.roofsValues=e.roofsValues||{};var i=v(e.roofsValues);if(e.roofsState||(e.roofsState={}),u.forEachRoofs((function(i){var o=z(i.name);t.all||i.hidden||i.selected||void 0!==i.userHidden||void 0!==i.userSelected?(e.roofsState[o]={hidden:i.hidden||!1,selected:i.selected||!1},void 0!==i.userSelected&&(e.roofsState[o].userSelected=i.userSelected),void 0!==i.userHidden&&(e.roofsState[o].userHidden=i.userHidden)):o in e.roofsState&&delete e.roofsState[o]})),Object.keys(e.roofsState).length||delete e.roofsState,t.all)u.forEachAllRoofs(r);else{var o=u.getThreadCount(),n=u.getRoofsStrategyId(),s=u.getPackageCount();u.forEachRoofs((function(e){r(e,o,n,s)}))}i.empty()&&delete e.roofsValues}function r(e,o,n,s){var r=i.get(o,n,s),a=z(e.name);t.all||void 0!==e.defVal?r?r[a]=e.val:((r={})[a]=e.val,i.add(r,o,n,s)):r&&r[a]&&(delete r[a],i.removeIfEmpty(o,n,s))}},_updateRoofsText:function(e){const t=4*h;function i(i){var r,a,c=[];i=i||function(e){return e&&!e.hidden},l.roofs.forEach((function(l){if(a=G.getFrom(l)){var d=a.roofData;i(d)&&(r=function(i,r,l){function d(e,t,i){return void 0!==t&&t<s||i&&i.some((function(t){return Math.abs(e-t)<s}))}if(i)return function(e){if(!i)return r;var t=e(i.val,r),n=function(e,t,i){var n,s=e,r=t.roofPosition;return void 0!==e&&(n=r-e),d(r,n,o)?(i.addClass(w),t.acrossOffset=1):(i.remClass(w),s=r,c.push(s)),s}(r,t,l);return a.updateTextPos(t.acrossOffset,t.alongOffset),n}(i.isMem?function(i,s){var r,a,l,c=e.getMinIntens(),p=e.getMinPerf(),u=p-i,h=i+c,m=e.L2PY(h)-e.L2PY(p),f=e.L2PX(u),v=Math.sqrt(Math.pow(f,2)+Math.pow(m,2)),g=e.L2PY(h);return void 0!==s&&(l=Math.abs((g-s)/v*f)),d(g,l,o)&&(r=-1,g+=n),u>c?(a=v+2,-1===r&&(a+=Math.abs(f*n/m))):a=-1===r?1:Math.abs(n/f*m)+t,{roofPosition:g,acrossOffset:r,alongOffset:a}}:function(i,s){var r,a,l=e.L2PY(i);return void 0!==s&&(a=l-s),d(l,a,o)&&(r=-1,l+=n),{roofPosition:l,acrossOffset:r,alongOffset:-t}})}(d,r,a.text.svgText))}})),o=c}if(e&&this._captionTextHeight){var o,n=this._captionTextHeight,s=.9*n;i.call(this,(function(e){return e&&!e.hidden&&e.isMem&&e.selected})),i.call(this,(function(e){return e&&!e.hidden&&e.isMem&&!e.selected})),o=void 0,i.call(this,(function(e){return e&&!e.hidden&&!e.isMem&&e.selected})),i.call(this,(function(e){return e&&!e.hidden&&!e.isMem&&!e.selected}))}},removeSingleThreadedCaption:B}}();y.addProcessor(g,b),s.recv("rooflineCleared",b.clear,b),s.recv("rooflineResized",b.processResize,b);var w=function(){function e(e){return e.replace(/\s+/g,"")}var t={},i="idvc2_roofline_roofs_cross_hover",o="roofline_coord_line_hover";function n(e){if(e)return e.el}function r(e){this.line=void 0,this.rect=void 0,this.selected=!!e}function a(e){var t=6*h;return{x:e.x-t/2,y:e.y-t/2}}function c(e){var t=6*h;return{x:e.x,y:e.y+t/2}}r.prototype.create=function(e,t,i,o){if(o){this.line&&this.line.remove(),this.rect&&this.rect.remove();var n=o.L2P(e.x,e.y),s=a(n),r=6*h,d=l.getRoofsLayer().addRect(s.x,s.y,r,r,"roofline_roofs_cross").front().activate().on("mousedown",this.processCrossPointClick,!1),p=c(n),u=l.getRoofsLayer().addLine(p.x,p.y,p.x,l.tr.getMinY(),"roofline_coord_line");this.name1=i,this.name2=t,this.x=e.x,this.y=e.y,this.line=u,this.rect=d,this.selected&&this.toggleSelection(),this.setTo(d)}},r.prototype.setTo=function(e){n(e).crossingRepresentation=this},r.getFrom=function(e){return n(e).crossingRepresentation},r.prototype.toggleSelection=function(){this.rect&&this.rect.toggleClass(_),this.line&&(this.line.toggleClass(_),this.selected=this.line.hasClass(_))},r.prototype.highlight=function(){this.rect&&this.rect.addClass(i),this.line&&this.line.addClass(o)},r.prototype.unhighlight=function(){this.rect&&this.rect.remClass(i),this.line&&this.line.remClass(o)},r.prototype.updatePos=function(e){var t=e.L2P(this.x,this.y);if(this.rect){var i=a(t);this.rect.setX(i.x).setY(i.y)}if(this.line){var o=c(t);this.line.setX1(o.x).setX2(o.x).setY1(o.y).setY2(e.getMinY())}},r.prototype.clear=function(e){this.rect&&(e&&this.rect.remove(),this.rect=void 0),this.line&&(e&&this.line.remove(),this.line=void 0),this.x=0,this.y=0},r.prototype.processCrossPointClick=function(e){var t=e.target;t&&t.crossingRepresentation&&(t.crossingRepresentation.toggleSelection(),y.save(f))};var d={set:function(e,t,i,o){o=o||l.tr,this.get(t,i).create(e,t,i,o)},get:function(i,o){var n=e(i),s=e(o),a=t[n+s];return a||(a=t[s+n]),a||(a=new r,t[n+s]=a),a},forEach:function(e){Object.getOwnPropertyNames(t).forEach((function(i){var o=t[i];o&&e(o,i)}))},processResize:function(e){e&&this.forEach((function(t){t.updatePos(e)}))},clear:function(e){this.forEach((function(t){t.clear(e)}))},apply:function(e){e&&e.crossings&&Object.getOwnPropertyNames(e.crossings).forEach((function(i){var o=e.crossings[i];if(o){var n=t[i];n&&n.clear(!0),t[i]=new r(o.selected)}}))},saveState:function(e,t){e&&(e.crossings&&delete e.crossings,this.forEach((function(i,o){(t||i.selected)&&(e.crossings||(e.crossings={}),e.crossings[o]={selected:!!i.selected})})))}};function p(e){new S.A.RoofsCrossingManager(e).forEach(((e,t,i)=>this.set(e,t.name,i.name)))}return s.recv("rooflineCleared",d.clear,d),s.recv("rooflineResized",d.processResize,d),s.recv("roofsCreated",p,d),s.recv("roofVisibilityChanged",(function(e){this.clear(!0),p.call(this,e)}),d),d}();y.addProcessor(f,w);var x=function(){var e,t=[];function i(){e&&(t.some((function(t){return t.unhighlight(e)})),e=void 0)}return{processMouseMove:function(o){o&&o!==e&&(i(),t.some((function(t){var i=t.highlight(o);return i&&(e=o),i})))},processMouseOut:i,addProcessor:function(e){t.push(e)},clear:function(){e=void 0}}}();function C(e){return e&&e.parentNode&&e.parentNode.parentRoof}function A(){l&&l.companions.notifications&&l.companions.notifications.onRoofChanged&&l.companions.notifications.onRoofChanged()}function I(){var e={roofsValues:{}};b.saveState(e,{all:!0}),r.default.copyObject(y.getState().roofsValues,e.roofsValues),w.saveState(e,!0),p.Ay.sendNotification(o("saveRoofs"),e)}return x.addProcessor({accept:function(e){return e&&e.roofRepresentation},highlight:function(e){return!!this.accept(e)&&(e.roofRepresentation.highlight(),!0)},unhighlight:function(e){return!!this.accept(e)&&(e.roofRepresentation.unhighlight(),!0)}}),x.addProcessor({accept:function(e){return e&&e.crossingRepresentation},highlight:function(e){return!!this.accept(e)&&(e.crossingRepresentation.highlight(),!0)},unhighlight:function(e){return!!this.accept(e)&&(e.crossingRepresentation.unhighlight(),!0)}}),s.recv("rooflineCleared",x.clear,x),e.addTooltipProcessor({accept:function(e){return e&&e.roofRepresentation},getText:function(e){var t=e.roofRepresentation.roofData;return t.name+c.pref+(t.isMem,c.formatVal(t.val,2))+c.post+t.measure}}),e.addTooltipProcessor({accept:function(e){return e&&e.crossingRepresentation},getText:function(e){var t=e.crossingRepresentation,i=u.getRooflineData();return t.name1+" X "+t.name2+"<br>"+i.nameY+c.pref+c.formatVal(t.y)+c.post+i.measureY+"<br>"+i.nameX+c.pref+c.formatVal(t.x)+c.post+i.measureX}}),e.addTooltipProcessor({accept:C,getText:function(e){if(C(e)&&e.parentNode.parentRoof.el.roofRepresentation)return e.parentNode.parentRoof.el.roofRepresentation.roofData.desc}}),(d=i("revert_roofs_values_settings_button")).disabled=!0,d.onclick=function(){u.forEachAllRoofs((function(e){void 0!==e.defVal&&(e.val=e.defVal,delete e.defVal)})),d.disabled=!0,s.send("rooflineDataUpdated",{isOldData:!0}),y.save(g,{clearRoofsValues:!0}),(0,T.P)()||p.Ay.sendNotification(o("clearRoofValues"),{configuration:S.A.getRoofsConfiguration(u.getThreadCount(),y.getState().useSTRoofsStrategy,u.getPackageCount()).str()}),A()},i("load_roofs_settings_button").onclick=function(){p.Ay.sendNotification(o("loadRoofs"))},p.Ay.addConsumer(o("loadedRoofs"),{process:function(e){var t=y.getState();t.roofsState=e.roofsState||{},t.roofsValues=e.roofsValues,y.apply(void 0,g),t.crossings=e.crossings,y.apply(void 0,f),s.send("rooflineDataUpdated",{isOldData:!0}),y.save(f),y.save(g)},onerror:function(t){t.message&&e.toast(t.message)}}),i("save_roofs_settings_button").onclick=function(){u.areAllRoofsLoaded()?I():p.Ay.sendNotification(o("getAllRoofs"))},p.Ay.addConsumer(o("allRoofs"),{process:function(e){Array.isArray(e)&&(e.forEach((function(e){var t=e.threadCount,i=e.strategyId,o=e.packageCount;u.getRoofs(t,i,o).length||u.addRoofs(e.roofs,t,i,o)})),u.setAllRoofsLoaded(!0)),I()}}),t.addCheckSetting("use_single_thread_strategy","useSTRoofsStrategy",(function(){var e=!!(y.getState()||{}).useSTRoofsStrategy;u.setRoofsStrategyId(S.A.getRoofsStrategyId(e)),u.getRoofs().length?s.send("rooflineDataUpdated",{isOldData:!0,isNewRoofs:!0}):p.Ay.sendNotification(o("changeRoofs:"+S.A.getRoofsConfiguration(u.getThreadCount(),e,u.getPackageCount()).str()))}),!0),b},P=function(e,t,i,o,n,s,l,u,h){var m,f,v=g(),y=A(e,t,i,o,n,l,u),w=I(e,t,o,n,s,u),C=1,S=t.get();const T=e.getChartAreaPadding();var P=!1;function M(e,t,i){var o=R/2;e.createMarker(t).setMarkerWidth(D).setMarkerHeight(R).setRefX(1).setRefY(o).setOrient("auto").setMarkerUnits("userSpaceOnUse").createPath().moveToAbs(0,0).lineToAbs(0,R).lineToAbs(D,o).lineToAbs(0,0).setD().setClass(i)}function E(){x.A.DefValueRepresentation.call(this)}function L(e,t,i){if(e.setStyle("stroke: transparent; stroke-width:"+R+"; marker-start:"+e.localUrl(t)),m){let e=m.centerMarkers[this.centerMarkerIndex];e&&(i?e.activate():e.deactivate())}}u.recv("rooflineCleared",(function(){m&&m.clear(),i.classList.remove("idvc2_roofline_no_data"),i.classList.add("idvc2_roofline_data_loading")})),u.recv("rooflineDataUpdated",(function(t){function n(e){e.length&&(e.sort(((e,t)=>t.val-e.val)),e[0].selected=!0)}var s=!(!t||!t.isOldData),a=!(!t||!t.isNewRoofs),l=!(!t||!t.movingZoomFrame),c=!(!t||!t.changingZoomFrame),d=!(!t||!t.changingRoofs),p=!(e.isSimpleView()||s&&!m.centralPart.selection),h=l||c||d,g=(s||!(!t||!t.keepSelection))&&!h,_=v.getRooflineData();if(_){var b=r.default.disableElement(i,"Processing...",(function(){var e=v.getLoops();return e&&e.length>250||!s}));s=s&&!a;try{var x=[];g&&B(x),h?(m.horzAxis.clear(),m.vertAxis.clear()):u.send("rooflineCleared"),f=m.companions.zooming,y.setZoomer(f),s||S.apply(),S.disableSaving();var A=v.getRoofs()||[];if(_.loops=_.loops||[],e.isSimpleView()){let pe=!1;const ue=[];let he=!1;const me=[];A.forEach((e=>{e.isMem?(ue.push(e),e.selected&&(pe=!0)):(me.push(e),e.selected&&(he=!0))})),pe||n(ue),he||n(me),A=A.filter((e=>!e.removed))}if(s||function(e){function t(t,i){function o(t){return t&&e&&e[t]?e[t]:""}var n=o(t),s=o(i);return n+(s?' (<span class="axis_caption_expl">'+s+"</span>)":"")}var i=o("roofline_vert_axis_caption");i&&(i.innerHTML=t("measureY"));var n=o("roofline_horz_axis_caption");n&&(n.innerHTML=t("measureX","nameX"))}(_),i.classList.remove("idvc2_roofline_data_loading"),_.noDataMessage){var I=i.getElementsByClassName("idvc2_roofline_no_data_message");if(I.length){e.hideStdTooltip(),m.centralPart.hideTooltip(),i.classList.add("idvc2_roofline_no_data");var L=I[0];return L.firstElementChild.innerHTML=_.noDataMessage.title,void(L.lastElementChild.innerHTML=_.noDataMessage.descr)}}else i.classList.remove("idvc2_roofline_no_data"),v.isHierarchical()?i.classList.remove("plain_data"):i.classList.add("plain_data");v.applySavedHierarchy(_.loops),A.length?i.classList.remove("no_roofs"):i.classList.add("no_roofs");var R=l?t.movingZoomFrame:f.getMinMax(!0),D=R.minX,N=R.maxX,z=R.minY,G=R.maxY,U=-Number.MAX_VALUE,H=Number.MAX_VALUE,j=Number.MAX_VALUE,Y=-Number.MAX_VALUE,W=0,X=0;A.forEach((function(e){e.hidden||(e.isMem?(j=Math.min(j,e.val),Y=Math.max(Y,e.val),W++):(U=Math.max(U,e.val),H=Math.min(H,e.val),X++))}));var q=a||d||void 0===_.minIntens||void 0===_.maxIntens||void 0===_.minPerf||void 0===_.maxPerf,Z=l?t.movingZoomFrame:f.getCurrentZoom();if((q||!Z)&&X&&W){var Q=U-j;N=Math.max(N,Q),D=Math.min(D,Q),Q=H-Y,D=Math.min(D,Q)}var K=N-D;N===D&&(K=Math.abs(D));var $=D-T*K,J=N+T*K;!q&&Z||(X&&(z=Math.min(z,H),G=Math.max(G,U)),W&&(z=Math.min(z,j+$),(G=Math.max(G,Y+$))===Y+$&&(G=Y+($+J)/2)));var ee=G-z;G===z&&(ee=Math.abs(z)),!q&&Z||(_.minIntens=D,_.maxIntens=N,_.minPerf=z,_.maxPerf=G,f.saveMinMax(_)),q&&Z&&(D=R.minX,N=R.maxX,z=R.minY,ee=(G=R.maxY)-z,$=D-T*(K=N-D),J=N+T*K);var te=z-T*ee,ie=G+T*ee,oe=(e.isSimpleView()?20:100)*C;function se(e,t){var i;if(e!==t){var o=Math.abs(10**t-10**e);(i=Math.abs(Math.floor(Math.log10(o)))+1)<3&&(i=void 0)}return i}function re(t,i,o,n,s){function r(e,o){e>t&&e<i&&(s.addValue(e,void 0,void 0,o),d++)}const a=e.isSimpleView()?2:4;var l=se(t,i),c=Math.round((n-o)/(i-t)/2);c<1&&(c=1);for(var d=0,p=Math.floor(i-t)<a,u=Math.floor(o);u<n;u++)if(r(u),p){let e=10**u,t=10*e,i=(t-e)/(3*c),o=e+i;for(;o<t;)r(Math.log10(o),l),o+=i}return d}function ae(e,t,i){var o=se(e,t);i.addValue(e,void 0,void 0,o),e!==t&&i.addValue(t,void 0,void 0,o)}function le(e){var t,i=e.val;if(e.isMem){i=e.val+$;var o=X?U:ie;o<=i&&(o=ie),t=[i,o-e.val,o]}else t=[W?e.val-Y:$,i];return t}function ce(e){if(e&&e.programTotal){var t=e.programTotal;return t&&!Array.isArray(t)?[t]:t}}function de(e){var t=e.canvas.createDefs();M(t,O,"idvc2_roofline_total_value_tick"),M(t,k,"idvc2_roofline_total_value_tick_active")}m.setViewbox($,te,J,ie,oe,oe),Z?(ae(D,N,m.horzAxis),re(D,N,_.minIntens,_.maxIntens,m.horzAxis),ae(z,G,m.vertAxis),re(z,G,_.minPerf,_.maxPerf,m.vertAxis)):(re($,J,$,J,m.horzAxis)||ae(D,N,m.horzAxis),re(te,ie,te,ie,m.vertAxis)||ae(z,G,m.vertAxis)),m.vertAxis.layoutValues(),m.horzAxis.layoutValues();var ne=ce(_);if(e.isSimpleView()){const fe=5,ve=m.fitVertAxis(fe);let ge=o("roofline_vert_axis_caption");ge&&(ge.style.left=parseInt(ve)+fe+"px")}ne&&(de(m.vertAxis),de(m.horzAxis),ne.forEach((function(e,t){function i(e,t){if(e){var i=e.values[e.values.length-1];i&&i.representation&&(i.representation.centerMarkerIndex=t)}}m.vertAxis.addValue(e.y,void 0,E),i(m.vertAxis,t),m.horzAxis.addValue(e.x,void 0,E),i(m.horzAxis,t),V(m.vertAxis,e),V(m.horzAxis,e)}))),m.addGridLines(),h?(w.recalculateRoofs(A,le),r.default.refreshSize(m.centralPart.body,{movingZoomFrame:!0})):(p&&m.centralPart.createFreeSelection(),w.fillRoofsPatterns(),y.fillLoops(_.loops),y.fillSettings(),y.fillHistogramChart("roofline_legend"),w.fillRoofs(A,le),ne&&ne.forEach((function(e){m.addCenterMarker(e.x,e.y,C)}))),g&&function(e){if(m&&e.length){m.onSelectionChanged.unsubscribe(null,F),m.clearSelectedPoints();var t=e.shift();t&&(m.currentPoint=t.rooflinePoint),e.forEach((function(e){e&&m.addSelectedPoint(e.rooflinePoint)})),F(0,0,!0),m.onSelectionChanged.subscribe(null,F)}}(x)}finally{S.enableSaving(),b.end(),P=!0,u.send("rooflineDataProcessed")}}})),u.recv("dominatingRoofsUpdated",(function(){P&&u.send("rooflineDataUpdated",{isOldData:!0,isNewRoofs:!0})})),u.recv("loopHighlighted",(function(e){if(e){var t=e.rooflinePoint;t&&setTimeout(z,50,[t])}})),E.prototype=Object.create(x.A.DefValueRepresentation.prototype),E.prototype.constructor=E;const R=10,D=6,k="TotalValueActive",O="TotalValue";E.prototype.create=function(e,t,i,o){x.A.DefValueRepresentation.prototype.create.call(this,e,t,i,o),L.call(this,this.line,O),this.line.activate(),this.line.on("mouseenter",L.bind(this,this.line,k,!0)),this.line.on("mouseleave",L.bind(this,this.line,O,!1)),this.text.setClass("").setAttr("fill","none")},E.prototype.getBoundingRect=function(){var e=x.A.DefValueRepresentation.prototype.getBoundingRect.call(this);return e.width=e.height=0,e},E.prototype.show=E.prototype.hide=function(){},E.prototype.getGridLineClassName=function(){return"idvc2_roofline_total_line"};var N,z=function(){var e=[],t=0,i=0,o=!0;let n=!0;function s(){a(e,!0,!0),e=[]}function a(e,t,i){e.forEach((function(e){e.hasClass("no_loop_position")&&(i?e.remClass("flashed"):e.addClass("flashed")),t?e.remAttr("opacity"):e.setAttr("opacity","0"),n&&(m.companions.refreshView4Mozilla(),n=!1)}))}return function(n){var l=n.map((function(e){for(var t=e;t&&t.el&&t.el.isHidden();){var i=t.loopData;if(!i||!v.getParent(i))break;t=v.getParent(i).rooflinePoint}return t})).filter((function(e,t,i){return e&&i.indexOf(e)==t})).map((function(e){return e.el})),c=e.length>0;c&&s(),l.length?(t=0,i=0,o=!0,e=l,c||r.default.animate((function(n){return!(i>=10)&&(n-t>=100&&(i++,t=n,a(e,o=!o)),i<10)}),s)):i=10}}();function B(e,t,i){t=t||(e=>e),e.push(m.currentPoint&&!m.currentPoint.loopData.filtered?t(m.currentPoint.loopData):i),m.selectedPoints.forEach((function(i){i&&i.loopData&&!i.loopData.filtered&&e.push(t(i.loopData))}))}function V(t,i){if(t&&t.values&&t.values.length){var o=t.values[t.values.length-1].representation.line;o&&o.setAttr(e.tooltipAttr,`<b>${function(e){return e&&e.name?e.name:"Program Total"}(i)}</b><br>`+G(i.x,i.y))}}function G(e,t){var i,o=v.getRooflineData();return m&&m.tr&&o&&(i=o.nameY+c.pref+c.formatVal(t)+c.post+o.measureY+"<br>"+o.nameX+c.pref+c.formatVal(e)+c.post+o.measureX),i}function F(e,t,i){const o="-1";N||(N=setTimeout((function(){N=void 0;var e=[];B(e),e.shift(),u.send("pointsSelectionChanged",e),B(e=[],(function(e){return e.resIndex?o:e.id||o}),o),u.send("loopsSelectionChanged",{points:e,quiet:i})}),50))}return p.Ay.addConsumer(n("selectedLoops"),{process:function(e){if(m){var t=e.shift();if(m.onSelectionChanged.unsubscribe(null,F),m.clearSelectedPoints(),m.currentPoint=void 0,e.length){s(e.shift(),"some",n(t),(function(e){m.currentPoint=e}));var i=[],o=!1;e.forEach((function(e){void 0!==e?(o&&(i=[],o=!1),s(e,"forEach",n(t),(function(e){m.addSelectedPoint(e),i.push(e)}))):o=!0})),F(0,0,!0),m.onSelectionChanged.subscribe(null,F),z(i)}}function n(e){var t="id";return"rvas"===e?t="rva":"locations"===e&&(t=function(e,t){return e.locat+e.name===t}),t}function s(e,t,i,o){e&&t&&i&&o&&m.points[t]((function(t){return n=t.loopData,!!("string"==typeof i?n[i]===e:"function"==typeof i&&i(n,e))&&(o(t),!0);var n}))}}}),e.addDefTooltipProcessor({accept:function(){return!0},getText:function(e,t,i){return G(t,i)}}),{createRoofline:function(i,s,r){return v.setPointConstructors([_.A.SquarePoint,_.A.TrianglePoint,_.A.DiamondPoint]),(m=_.A.create(i,"0",r)).getElementById=o,m.centralPart.body.id="mainRoofline",m.companions={rooflineData:v,viewParent:s,loopsRepresentation:y,roofsRepresentation:w,stateManagerModule:t,uiUtils:e,contextMenu:l,events:u,mn:n,stackView:b(v,t,l),zooming:d(m,v,e),onChange:a.A.create(),add:function(e,t){this[e]=t,this.onChange.raise()},get:function(e){return this[e]}},m.onResize.subscribe(void 0,u.send.bind(u,"rooflineResized")),m.centralPart.ontooltiptext=e.getTooltipText,m.centralPart.ontooltipattrs=function(e,t,i,o){return{autoHideDelay:t.length>100?1e4:5e3}},y.setRoofline(m),w.setRoofline(m),h.setRoofline(m),m.onSelectionChanged.subscribe(null,F),m.onCurrentPointChanged.subscribe(null,u.send.bind(u,"currentPointChanged")),m.horzAxis.onformat=function(e,t,i){return" "+c.formatVal(e,t,i)+" "},m.vertAxis.onformat=c.formatVal,m},setScale:function(e){C=e,y.setScale(C),w.setScale(C),h.setScale(C)},setConfiguration:function(e){e&&(y.setConfiguration(e.loops),w.setConfiguration(e.roofs),h.setConfiguration(e))}}},M="data-tooltip",E="data-noValue",L="data-noValueCaption";function R(){return.1}function D(){return 1.1}function k(e){if(e)return e.getAttribute(M)}let O;const N={init:function(e,t){function i(){return e===document.body?window.innerWidth:window.innerWidth-20}var o,n=[],s=r.default.addTooltip(e,k);function a(e,t,i){if(!e||!t||!i)return;const o=r.default.createElement("?","idvc2_roofline_explanation_symbol alert","",i,"div",(function(i){i.setAttribute(M,t),r.default.setFont(i,window.getComputedStyle(e,null))}));return function(e,t,i){const o=r.default.getElementPos(e),n=r.default.getElementPos(i);t.style.left=o.x+o.width+2-n.x+"px",t.style.top=o.y-2-n.y+i.scrollTop+"px"}(e,o,i),o}function l(e,t){e&&e.rooflineExplanation&&t&&t.removeChild(e.rooflineExplanation)}const c=t("roofline_settings"),d=t("roofline_menu_button");function p(e,t){if(e){var i=e.rooflineIndex;if(i>=0){var o=e.children[i];o&&o.classList.remove("selected")}if(t>=0){var n=e.children[t];n&&(n.classList.add("selected"),n.offsetTop<e.scrollTop?n.scrollIntoView(!0):n.offsetTop+n.offsetHeight>e.offsetHeight+e.scrollTop&&n.scrollIntoView(!1),window.scrollY&&window.scrollTo(0,0))}e.rooflineIndex=t}}d.onclick=function(){const e=document.activeElement;e&&e.rooflineExplanation&&e.blur(),c.classList.toggle("visible"),d.classList.toggle("idvc2_roofline_pressed")};var u=function(){var e,t="data-value";function i(){e.style.display="none",e.rooflineElement&&(delete e.rooflineElement.rooflinePopup,delete e.rooflineElement)}function o(t){e&&e.rooflineElement&&e.rooflineElement!==t.target&&i()}return document.addEventListener("click",o,!1),{setPopup:function(o,n,s,a){o&&(s=s||function(){},a=a||function(e){return e},e?e.rooflineElement&&e.rooflineElement!==o&&delete e.rooflineElement.rooflinePopup:((e=r.default.createElement("","roofline_popup","",document.body,"ul")).addEventListener("mousedown",(function(t){e.idvcClicked=!0})),e.addEventListener("click",(function(o){if(e.idvcClicked=!1,o.target&&"li"===o.target.nodeName.toLowerCase()){var n=o.target.getAttribute(t);e.rooflinePopupCallback&&e.rooflinePopupCallback(n),i()}}))),e.rooflinePopupCallback=s,e.innerHTML=n.map((function(e){return"<li "+t+'="'+e+'">'+a(e)+"</li>"})).join(""),n.length?(o.rooflinePopup=e,e.rooflineElement=o,e.style.display="block",function(e,t){var i=r.default.getElementPos(e),o=r.default.getElementPos(t);t.style.left=i.x+"px";var n=i.y+i.height+1;n+o.height<window.innerHeight+window.scrollY?t.style.top=n+"px":t.style.top=i.y-o.height-1+"px",t.style.minWidth=i.width+"px"}(o,e),p(e,0)):i())},clearPopup:function(){document.removeEventListener("click",o,!1)}}}(),h=u.setPopup;function m(e){e.addEventListener("keydown",(function(t){var i=e.rooflinePopup;if(i)switch(t.keyCode){case 13:!function(e){if(e){var t=e.rooflineIndex;if(t>=0){var i=e.children[t];i&&i.click()}}}(i),t.preventDefault();break;case 27:h(e,[]),t.preventDefault();break;case 38:!function(e){if(e){var t=e.rooflineIndex;t>0&&p(e,--t)}}(i),t.preventDefault();break;case 40:!function(e){if(e){var t=e.rooflineIndex;t<e.children.length-1&&p(e,++t)}}(i),t.preventDefault()}}),!1),e.addEventListener("blur",(function(t){var i=e.rooflinePopup;i&&i.idvcClicked||h(e,[])}),!1)}var f=["AliceBlue","AntiqueWhite","Aqua","Aquamarine","Azure","Beige","Bisque","Black","BlanchedAlmond","Blue","BlueViolet","Brown","BurlyWood","CadetBlue","Chartreuse","Chocolate","Coral","CornflowerBlue","Cornsilk","Crimson","Cyan","DarkBlue","DarkCyan","DarkGoldenRod","DarkGray","DarkGrey","DarkGreen","DarkKhaki","DarkMagenta","DarkOliveGreen","Darkorange","DarkOrchid","DarkRed","DarkSalmon","DarkSeaGreen","DarkSlateBlue","DarkSlateGray","DarkSlateGrey","DarkTurquoise","DarkViolet","DeepPink","DeepSkyBlue","DimGray","DimGrey","DodgerBlue","FireBrick","FloralWhite","ForestGreen","Fuchsia","Gainsboro","GhostWhite","Gold","GoldenRod","Gray","Grey","Green","GreenYellow","HoneyDew","HotPink","IndianRed","Indigo","Ivory","Khaki","Lavender","LavenderBlush","LawnGreen","LemonChiffon","LightBlue","LightCoral","LightCyan","LightGoldenRodYellow","LightGray","LightGrey","LightGreen","LightPink","LightSalmon","LightSeaGreen","LightSkyBlue","LightSlateGray","LightSlateGrey","LightSteelBlue","LightYellow","Lime","LimeGreen","Linen","Magenta","Maroon","MediumAquaMarine","MediumBlue","MediumOrchid","MediumPurple","MediumSeaGreen","MediumSlateBlue","MediumSpringGreen","MediumTurquoise","MediumVioletRed","MidnightBlue","MintCream","MistyRose","Moccasin","NavajoWhite","Navy","OldLace","Olive","OliveDrab","Orange","OrangeRed","Orchid","PaleGoldenRod","PaleGreen","PaleTurquoise","PaleVioletRed","PapayaWhip","PeachPuff","Peru","Pink","Plum","PowderBlue","Purple","Red","RosyBrown","RoyalBlue","SaddleBrown","Salmon","SandyBrown","SeaGreen","SeaShell","Sienna","Silver","SkyBlue","SlateBlue","SlateGray","SlateGrey","Snow","SpringGreen","SteelBlue","Tan","Teal","Thistle","Tomato","Turquoise","Violet","Wheat","White","WhiteSmoke","Yellow","YellowGreen"];return e===document.body&&(window.onscroll=function(){document.body.classList.contains("idvc2_roofline_data_loading")||document.body.classList.contains("idvc2_roofline_no_data")||window.scrollTo(0,0)}),O={getTooltipText:function(e,t,i){var s;return!n.some((function(o){if(o)return!!o.accept(e,t,i)&&(s=o.getText(e,t,i),!0)}))&&o.accept(e,t,i)?o.getText(e,t,i):s},addTooltipProcessor:function(e){return n&&n.push(e),e},addDefTooltipProcessor:function(e){return o=e,e},hideStdTooltip:function(){s.hide()},tooltipAttr:M,noValueAttr:E,noValueCaptionAttr:L,addExplanation:a,remExplanation:l,markWrong:function(e,t,i){if(e&&(e.classList.add("wrong_input"),!e.rooflineExplanation)){var o=a(e,t,i);e.rooflineExplanation=o}},markNormal:function(e,t){e&&(e.classList.remove("wrong_input"),e.rooflineExplanation&&(l(e,t),delete e.rooflineExplanation))},setPopup:h,addPopupNavigation:m,addColorPicker:function(e,t){e&&(t=t||function(){return!0},e.addEventListener("input",(function(i){var o=i.target.value,n=f.filter((function(e){return-1!==e.toLowerCase().indexOf(o.toLowerCase())}));h(e,t(o,n)?n:[],(function(t){e.value=t,e.oninput({target:e}),e.focus()}),(function(e){return'<div class="loop_sample loop_fixed_sample" style="background-color:'+e+'"></div>'+e}))}),!1),m(e))},toast:function(e){var o,n=t("mainRoofline");if(n){const e=.5,t=.2;let s=n.getBoundingClientRect();const a=r.default.em2px(1,n);o={top:s.top+e*a+"px",right:i()-s.right+t*a+"px",maxWidth:.7*s.width+"px"}}else o={top:"3em",right:"0.5em"};r.default.toast(e,void 0,o)},filterNumberInput:function(e){var t,i,o,n,s=e.key||String.fromCharCode(e.charCode);if(e.charCode){var r=(t=e.target.value,i=e.target.selectionStart,o=e.target.selectionEnd,n=s,t.substr(0,i)+n+t.substr(o));return!isNaN(r)&&+r>=0}return!1},flashElement:function(e,t,i){e=e||function(){},t=t||function(){},setTimeout((function(){e(),setTimeout((function(){t()}),i)}),50)},addExpansion:function(e,i){i=i||function(){return!0};let o;o=e.isVert?{start:"offsetTop",size:"offsetHeight",clientSize:"clientHeight",scrollSize:"scrollHeight"}:{start:"offsetLeft",size:"offsetWidth",clientSize:"clientWidth",scrollSize:"scrollWidth"};let n,s=[],a=0,l=[];function c(){l.forEach((function(e){e.remove(),h.insertBefore(e,m)})),l=[]}let d=!1;function p(){n=document.createElement("div"),n.className=e.expansionClassName,h.appendChild(n)}function u(){var e,t=h[o.clientSize]-m[o.clientSize]-f,i=-1;if(s.some((function(e,n){return e>t&&(i=n,a=h[o.scrollSize]-t,!0)})),i!==s.length-l.length)if(c(),r.default.removeAllChildren(n),i>=0)for(var d,p=i,u=h.children.length-2;p<u;p++){var v=h.children[i];((e=v)&&e.classList.contains("br")||!n.children.length)&&(d=document.createElement("div"),n.appendChild(d)),h.removeChild(v),d.appendChild(v),l.push(v)}else a=0}var h=t(e.bodyId);h.refreshSize=function(e){if(i()){(e&&e.recalcSizes||!s.length||!s[s.length-1])&&(c(),s=[],[].forEach.call(h.children,(function(e){e!==m&&e!==n&&s.push(e[o.start]+e[o.size])})));var t=h[o.scrollSize]+a>h[o.clientSize];t&&(h.classList.add("idvc2_roofline_expandable"),n||p(),u()),t&&l.length||(h.classList.remove("idvc2_roofline_expandable"),d&&m.click())}else c()};const m=t(e.expandBtnId);m.onclick=function(){d=!d,d?(n||(p(),u()),n.style.display="block",m.classList.add("idvc2_roofline_expanded")):(n.style.display="none",m.classList.remove("idvc2_roofline_expanded"))};const f=r.default.em2px(.5,m);return{refreshSize:function(){h.refreshSize({recalcSizes:!0})}}},getMaxRight:i,getChartAreaPadding:R,getDefZoomStep:D,createLineArrowMarker:function(e,t,i,o,n){var s=i.centralPart.graphicsRoot.getDefs("line_arrows");const r=9*(o=o||1),a=1*o,l=Math.ceil(r/2);void 0===n&&(n=r),s.createMarker(e).setMarkerWidth(r).setMarkerHeight(r).setRefX(n).setRefY(l).setOrient("auto").createPath().moveToAbs(a,a).lineToAbs(a,r-a).lineToAbs(r-a,l).lineToAbs(a,a).setD().setClass(t)},lineBreak:"<br/>",setVisible:function(e,t){e&&e.classList.toggle("invisible",!t)},createInput:function(e,t,i){if(e&&t){var o=document.createElement("input");o.type=t.groupName?"radio":"checkbox",t.groupName&&(o.name=t.groupName),o.value=t.value,o.rooflineCaption=t.caption,o.className=t.inputClassName,o.onchange=t.onChange,i&&(o.setAttribute(E,i.value),o.setAttribute(L,i.caption));var n=document.createElement("label");n.className=t.labelClassName,t.style&&(n.style.cssText=t.style),t.disabled&&(o.disabled=!0,n.style.display="none"),n.appendChild(o),n.appendChild(document.createTextNode(t.caption)),t.expl&&r.default.createElement("?","idvc2_roofline_explanation_symbol hierarchy_item_caption no_close_popup",void 0,n,"label").setAttribute(M,t.expl),e.appendChild(n)}},isSimpleView:function(){return e.classList.contains("idvc2_roofline_simple_view")},isRoofsEditDisabled:function(){return e.classList.contains("idvc2_roofline_disable_roofs_editing")},destroy:function(){u.clearPopup(),s=void 0}},O},get:function(){return O},getChartAreaPadding:R};function z(e){return r.default.getParentByClass(e,"idvc2_roofline_zoom_toolbar")}function B(e){const{rooflineActiveSelect:t}=window;if(!t)return;if(e&&e.target&&e.target.classList.contains("no_close_popup"))return;if(e&&p.Ay.isRequestClick(e.target))return;delete window.rooflineActiveSelect;const i=z(t);i&&(i.style.zIndex="");const o=t.firstElementChild;o&&(o.style.left&&(o.style.left="",o.style.right=""),o.style.minWidth&&(o.style.minWidth="")),t.classList.remove("idvc2_roofline_pressed"),window.removeEventListener("click",B,!1)}function V(e,t){e&&t&&(e.idvcBtnSpan||(e.idvcBtnSpan=r.default.createElement("","idvcjs_span",void 0,e,"div")),e.idvcBtnSpan.style.top||(e.idvcBtnSpan.style.top=t.offsetTop-1+"px"))}function G(e){window.rooflineActiveSelect&&B(),window.rooflineActiveSelect=e;const t=z(e);t&&(t.style.zIndex="6000"),window.addEventListener("click",B,!1)}function F(e){return e&&e.classList&&e.classList.contains("disabled")}function U(e,t){if(!t||!t.offsetParent||!e)return;const i=r.default.getElementPos(t),o=r.default.getElementPos(e),n=N.get().getMaxRight();i.x+i.width>n&&(t.style.left=n-o.x-i.width-1+"px"),i.x+i.width<o.x+o.width&&(t.style.left=o.width-i.width-1+"px")}function H(e,t){t&&t.offsetParent&&e&&t.offsetWidth<e.offsetWidth&&(t.style.minWidth=e.offsetWidth+1+"px")}const j={create:function(e,t){let i=N.get().addExpansion(e,t);return{refreshSize:function(){i.refreshSize()}}},connect:function(e,t){const i=r.default.getDomElement(e);i&&t&&(i.onclick=function(i){F(e)||t(i)})},defSelectBtnProc:function(e){const t=e.currentTarget;if(!(e&&e.target&&e.target.classList.contains("no_close_popup"))&&t)if(t.classList.toggle("idvc2_roofline_pressed"),e.stopPropagation(),e.preventDefault(),t.classList.contains("idvc2_roofline_pressed")){G(t);var i=t.firstElementChild;if(r.default.getElementPos(i).x<0){var o=r.default.getElementPos(t);i.style.left="-"+o.x+"px",i.style.right="auto"}V(t,i)}else B()},popupProc:function(e){const t=e.currentTarget;if(!t||t.classList.contains("disabled")||t.classList.contains("idvc2_roofline_pressed"))return;t.classList.add("idvc2_roofline_pressed"),e.stopPropagation(),e.preventDefault(),G(t);const i=t.firstElementChild;H(t,i),U(t,i),V(t,i)},setPressed:function(e,t){e&&e.classList&&(t?e.classList.add("idvc2_roofline_pressed"):e.classList.remove("idvc2_roofline_pressed"))},setEnabled:function(e,t){e&&e.classList&&(t?e.classList.remove("disabled"):e.classList.add("disabled"))},isDisabled:F,updatePopupPos:U,updatePopupWidth:H},Y=function(e,t,i){var o=t("roofline_data_loading_message");return o.onmousedown=function(e){e.target&&e.target.classList&&(e.target.classList.contains("close_btn")?(o.innerHTML=s.A.getMessage("roofline_loading"),setTimeout(p.Ay.receiveData.bind(p.Ay,i("refreshRooflineView"),"1000"),100),p.Ay.clearLastError()):e.target.classList.contains("copy_btn")&&p.Ay.sendNotification(i("errorcopy:"+p.Ay.getLastErrorMessage().replace(/\n/g," - "))))},{getMessage:function(e,t,i){if(e){var o;if(void 0===t&&(t="Data Loading Error: "),i=i||"<br>",e.message){var n=t+w.A.escapeHTML(e.message);e.stack&&(n+=w.A.escapeHTML(e.stack).split("\n").map((function(e){return e?i+'<span class="stack_item">'+e+"</span>":e})).join("")),n+='<span class="message_btn close_btn button idvc2_roofline_icon"></span>',o=n+='<span class="message_btn copy_btn button idvc2_roofline_icon"></span>'}return o}},showMessage:function(t){o&&t&&(e.classList.remove("idvc2_roofline_no_data"),e.classList.add("idvc2_roofline_data_loading"),o.innerHTML=t)},handleException:function(e){!function(e,t,o,n,s){var r;r=s&&s.message?(s.name?s.name+": ":"")+s.message+(s.stack?"\n"+s.stack:""):["Message: ","URL: ","Line: 0","Column: 0"].join(" - "),p.Ay.sendNotification(i("error:"+r))}(0,0,0,0,e)}}};var W=i(86480);const X=function(e){var t=[],i="defContextMenu",o=!1,n={shownMenu:void 0,createMenu:function(){var e=r.default.createElement("","idvc2_context_menu","",document.body,"div");return e.style.display="none",e},createMenuItem:function(e){var t;return"-"!==e.caption?(t=r.default.createElement(e.caption,"idvc2_context_menu_item","",void 0,"div"),e.disabled&&t.classList.add("disabled"),t.onclick=this._processClick.bind(this,e.command)):t=r.default.createElement("","idvc2_context_menu_separator","",void 0,"div"),t},showMenu:function(e,t,i){this.shownMenu&&(this.shownMenu.style.display="none"),this.shownMenu=e,e.style.display="block",this._setMenuPos(e,t,i),document.addEventListener("click",n._documentClick,!1)},defMenuProcessing:function(e){e.stopPropagation(),e.preventDefault()},_processClick:function(e,t){t.target&&t.target.classList.contains("disabled")?(t.stopPropagation(),t.preventDefault()):setTimeout(e,0)},_documentClick:function(e){0===e.button&&n._hideMenu()},_hideMenu:function(){this.shownMenu&&(this.shownMenu.style.display="none",this.shownMenu=void 0,document.removeEventListener("click",this._documentClick,!1))},_setMenuPos:function(e,t,i){t<0?t=0:t+e.offsetWidth>window.innerWidth+window.scrollX&&(t=window.innerWidth+window.scrollX-e.offsetWidth),i<0&&(i=0),i+e.offsetHeight>window.innerHeight+window.scrollY&&(i=window.innerHeight+window.scrollY-e.offsetHeight),e.style.left=t+"px",e.style.top=i+"px"}},s={createMenu:function(){var t=document.createElement("menu");return t.setAttribute("id",i),t.setAttribute("type","context"),t.style.display="none",e("roofline_content").setAttribute("contextmenu",i),document.body.appendChild(t),t},createMenuItem:function(e){var t;return"-"!==e.caption?((t=document.createElement("menuitem")).setAttribute("label",e.caption),t.onclick=e.command,e.disabled&&t.setAttribute("disabled","")):t=document.createElement("hr"),t},showMenu:function(e,t,i){}};function a(){o||l.clear(),o=!1}"moz"!==r.default.Consts.engine&&(s=n),W.A.isAvailable()&&(s=void 0),document.addEventListener("contextmenu",a,!1);var l={show:function(e,n,a){if(e=e||[],t.forEach((function(t){t.process(e)})),e.forEach((function(e,t){"-"!==e.caption&&(e.id=t+1)})),!W.A.show(e,n,a)){o=!0;var l=r.default.getElementById(i);l||(l=s.createMenu()),r.default.removeAllChildren(l),e.forEach((function(e){l.appendChild(s.createMenuItem(e))})),s.showMenu(l,n,a)}},addProcessor:function(e){t.push(e)},clear:function(){var e=r.default.getElementById(i);e&&r.default.removeAllChildren(e)},defProcessing:function(e){s&&s.defMenuProcessing&&s.defMenuProcessing(e)},destroy:function(){document.removeEventListener("contextmenu",a,!1)}};return l};function q(e,t,i){function o(e,t,o){return i(e,t,o)||e}i=i||function(){},Array.isArray(t)?t.forEach((function(t){e&&(e=o(e[t],t,e))})):o(e[t],t,e)}function Z(){}function Q(e,t){var i;return q(t,e,(function(e,t,o){return e||(e=new Z,o[t]=e),i=e,e})),i}function K(){this.eventSet={}}Z.prototype.send=function(e,t){return this.signal&&(e.args.push(t),this.signal.raise.apply(this.signal,e.args)),!!this.signal},Z.prototype.recv=function(e,t){this.signal||(this.signal=a.A.create()),this.signal.subscribe(t,e)},Z.prototype.remove=function(e,t){this.signal&&this.signal.unsubscribe(t,e)},K.prototype.send=function(e){var t={args:[].slice.call(arguments,1)};return function(e,t,i){var o=!1;return q(t,e,(function(t){t&&(o=t.send(i,e))})),o}(e,this.eventSet,t)},K.prototype.recv=function(e,t,i){var o=Q(e,this.eventSet);o&&o.recv(t,i)},K.prototype.remove=function(e,t,i){var o=Q(e,this.eventSet);o&&o.remove(t,i)},K.prototype.clear=function(){this.eventSet={}};var $=new K;window.idvcGlobalCommunicationTube=$;var J={};window.idvcLocalCommunicationTubes=J;const ee={send:function(){return $.send.apply($,arguments)},recv:function(e,t,i){$.recv(e,t,i)},remove:function(e,t,i){$.remove(e,t,i)},get:function(e){var t=J[e];return t||(t=new K,J[e]=t),t},nm:function(){return[...arguments]},clear:function(){$.clear.apply($)}},te=function(e,t){e.addProcessor({process:function(e){if(!e||!Array.isArray(e))return;let i=e.findIndex((e=>"guidance"===e.type));e.length&&i<0&&e.push({caption:"-"});var o=t();i>0?e.splice(i+1,0,o):e.push(o)}})},ie=(e,t,i,o)=>!!(e&&t&&i&&o)&&(e.loops||(e.loops=[]),e.memoryLevelPref&&e.loops.forEach((function(t){t&&!t.memoryLevelPref&&(t.memoryLevelPref=e.memoryLevelPref)})),t.setExtraData("shadowLoops",e.loops),t.updateFitView(e.minX,Number.MAX_VALUE,e.maxX,-Number.MAX_VALUE),t.updateWholeView(e.minX,e.minY,e.maxX,e.maxY),o.reApplySetting("viewMode"),i.send("rooflineExtraDataUpdated"),!0),oe={getId:function(){return"roofsCrossingLine"},create:function(){var e,t,i,o,n,r,a=1,l="stroke:black;",d=l+"stroke-width:2;",p="rulerToRoof";function u(){return!!t.getExtraData("shadowLoops")}var h=function(){var o,s,r,p,h,m,f,v,g,_,y,b=5*a;function w(e,t,i){e&&(void 0===t||void 0===i?T(e):e.setX(t).setY(i).front())}function x(t,i,o,n){if(t)if(void 0!==i&&void 0!==o&&n){g||(g=e.centralPart.canvas.getTextHeight({className:"idvc2_roofline_roof_crossing_label"})),void 0!==_&&o-_<g?o=_+g:_=o,t.value.setText(n.value),t.gain.setText(n.gain);var s=i-2*b;t.el.setX(s).setY(o).front(),s-t.el.getBoundingRect().width<=0?t.el.setX(s+4*b).setStyle("text-anchor:start; dominant-baseline: middle;"):t.el.setStyle("text-anchor:end; dominant-baseline: middle;")}else I(t)}function A(e,t,i){p&&(void 0===i?P():p.setX1(e).setX2(e).setY1(t).setY2(i).front())}function T(e){w(e,-100,-100)}function I(e){e&&e.el.setX(-100).setY(-100)}function P(){A(-100,0,0)}var M={create:function(){function i(){var i=e.getForegroundLayer().createText().setClass("idvc2_roofline_roof_crossing_label").setX(-100).setY(0).setFilter("TextBackground").setStyle("text-anchor:end; dominant-baseline: middle;"),o=i.addSpan().setClass("idvc2_roofline_roof_crossing_label_value");i.addSpan(" "+t.getProp("measureY")+" ").setClass("idvc2_roofline_roof_crossing_label_measure"),i.addSpan("(").setClass("idvc2_roofline_roof_crossing_label_gain_x");var n=i.addSpan().setClass("idvc2_roofline_roof_crossing_label_gain");return i.addSpan("x)").setClass("idvc2_roofline_roof_crossing_label_gain_x"),{el:i,value:o,gain:n}}o=e.centralPart.graphicsRoot.createDefs().createLine("crossingTemplate").setX1(-4).setY1(-4).setX2(4).setY2(4),p=e.getForegroundLayer().addLine(-100,0,-100,0,"idvc2_roofline_roof_crossing_line"),s=e.getForegroundLayer().createUse().setRef(o.localRef("crossingTemplate")).setClass("idvc2_roofline_roof_crossing"),r=e.getForegroundLayer().createUse().setRef(o.localRef("crossingTemplate")).setClass("idvc2_roofline_roof_crossing"),h=i(),m=i()},isValid:function(){return!!o},setPos:function(t,i,n,a,l,d){function u(e,t){if(void 0!==t)return{value:c.formatVal(t),gain:c.simpleFormat(Math.pow(10,t)/Math.pow(10,e),1)}}void 0===l&&(l=800),n===a&&(a=void 0),this.hide(),v=setTimeout(function(){var l=e.tr;if(l){var c,v,g=l.L2PX(t),y=l.L2PY(i);n&&(c=l.L2PY(n)),a&&(v=l.L2PY(a)),_=void 0,A(g,y,c||v),w(s,g,c),w(r,g,v),d&&(o&&o.setStyle(d),p&&p.setStyle(d)),x(h,g,c,u(i,n)),x(m,g,v,u(i,a)),f=setTimeout(function(){this.hide(),f=void 0}.bind(this),9e3)}}.bind(this),l)},hide:function(){f&&clearTimeout(f),v&&clearTimeout(v),u()&&(o&&o.setStyle(d),p&&p.setStyle(l)),T(s),T(r),I(h),I(m),P()},clear:function(){o=s=r=h=m=p=void 0},setOn:function(e){y&&(e?E(y):this.hide())},initEvents:function(){n.recv("rooflineCleared",M.clear,M),n.recv("rooflineResized",M.hide,M),n.recv("zoomFrameMoved",(function(e){y&&(e?M.hide():E(y))})),n.recv("loopEntered",(function(e){y=e,E(e)})),n.recv("loopLeaved",(function(){y=void 0,M.hide()})),n.recv("zoomFrameChanged",(function(){y&&E(y,0)}))}};function E(e,o){if(e&&!1!==i.getState().rulerToRoof){var n=t.getLoopPosition(e),s=t.getMemoryLevelPrefix(e),r=function(e,t,i,o,n){function s(e,t){return e+t}function r(e,t){var i=0,o=Number.MAX_VALUE;e.forEach((function(e){e>i&&(i=e),e>=t&&e<o&&(o=e)}));var n={};return i>0&&(n.max=i),o<Number.MAX_VALUE&&(n.nearest=o),n}function a(e,t,i,o){var n=e[i],s=t[i];return void 0!==n&&void 0!==s?o(n,s):void 0!==n?n:s}if(e){var l=0,c=0,d=0,p=[],h=[],m=[];e.forEach((function(e){e.hidden||(e.isMem?(e.val>l&&(l=e.val),u()?function(e){return e&&e.name?S.A.getRoofMemoryLevel(e.name):""}(e)===C.A.getLoopMemoryLevel(t)&&p.push(s(i,e.val)):p.push(s(i,e.val))):S.A.isScalarRoof(e)?(e.val>c&&(c=e.val),h.push(e.val)):(e.val>d&&(d=e.val),m.push(e.val)))}));var f=n?m:m.concat(h),v=n?d:Math.max(c,d);f=f.filter((function(e){return e-l<i&&e>=o}));var g,_=r(p=p.filter((function(e){return e<v&&e>=o})),o),y=r(f,o),b={};void 0!==(g=u()?function(e,t,i){var o=e.max,n=t.max;if(void 0!==o&&void 0!==n){var s=Math.max(o,n);return s>i?i:s}return void 0!==i?i:void 0!==o?o:n}(_,y,_.max):a(_,y,"max",Math.max))&&(b.max=g);var w=a(_,y,"nearest",Math.min);return void 0!==w&&(b.nearest=w),b}}(t.getRoofs(),s,n.x,n.y,e.vec);M.isValid()||M.create(),M.setPos(n.x,n.y,r.max,r.nearest,o,void 0)}}return M}();return{setRoofline:function(s){t=(e=s).companions.rooflineData,i=e.companions.stateManagerModule.get(),o=e.companions.contextMenu,n=e.companions.events,h.initEvents()},setScale:function(e){a=e},setOn:h.setOn,getGuidanceInfo:function(){var e;return r||(e=i.getState(),r={settingName:p,imageUrl:"icons/guidances-preview-3-170x110.png",imageOrder:3,defaultVal:!0,caption:"roofline_toolbar_guidance_ruler",expl:"roofline_toolbar_guidance_ruler_expl"},e&&void 0!==e[p]?r.value=e[p]:r.value=r.defaultVal,i.addProcessor(p,{apply:function(e){var t=!0;e&&void 0!==e[p]&&(t=e[p]),r.value=t,h.setOn(r.value)},saveState:function(e){e[p]=r.value,h.setOn(r.value)}}),te(o,(function(){return{caption:!1===r.value?s.A.getMessage("roofline_menu_ruler_enable"):s.A.getMessage("roofline_menu_ruler_disable"),command:function(){r.value=!r.value,i.save(p)},type:"guidance"}}))),r}}}};var ne=i(76494),se=i(9007);const re={getId:function(){return"integratedDumbbellLine"},create:function(){var e,t,i,o,n,a,l,d,u,h,m,f;function v(e){return S.A.getIntegratedRooflineColor(C.A.getLoopMemoryLevel(f.getMemoryLevelPrefix(e)))}function g(e){return S.A.getIntegratedRooflineColor(S.A.getRoofMemoryLevel(e))||S.A.CalcRoofsColor}function _(e){if(e&&!e.resIndex)return e.id}function y(e){if(e){var t=g(e)+" !important;";return{line:"stroke:"+t,text:"fill:"+t}}}const b="selfMem",w="shadowLoops";function x(i,o){function n(e){var t=[];if(e){var i=C.A.getLoopMemoryLevelCaption(f.getMemoryLevelPrefix(e));t.push(i);var o=f.getRooflineData4Loop(e).attrs[b];o&&void 0!==e[b]&&t.push(c.simpleFormat(e[b],3,!0)+" "+o.measure)}return t}if(i){var s=f.isFiltered(),r=l(i,f.getLoops()),a=l(i,f.getExtraData(w)||[],(function(e){e&&o&&(e.loopData.state=o)}));t=ne.A.create(e,r,a)}function l(e,t,i){i=i||function(){};var o=[];return f.forEachLoopsSimple(t,(function(t){if(!(s&&t.filtered||f.getLoopKey(t)!==e)){var r={loopData:t,labels:n(t),color:v(t)};i(r),r.position=f.getLoopPosition(r.loopData),o.push(r)}})),o}}function A(i){t&&(L(),i&&t.remove(e),t=void 0)}function T(t){function i(e){return e&&(l===e.caption||e.roofData&&e.roofData.isMem)}t?e.companions.roofsRepresentation.representations.forEach((function(e){i(e)&&e.setStyle(y(e.caption))})):e.companions.roofsRepresentation.representations.forEach((function(e){i(e)&&e.clearStyle(y(e.caption))}))}function I(e,t,i){var o=f.isFiltered();f.forEachLoopsSimple(f.getLoops(),(function(n,s,r){o&&n.filtered||n.rooflinePoint&&(f.getLoopKey(n)===e?t(n.rooflinePoint):i(n.rooflinePoint))}))}function P(){var t;i&&(A(!0),I(i,(t=e.companions.loopsRepresentation).updateLoopVisualisation.bind(t),(function(e){}))),i=void 0,o=void 0,T(),l=void 0}function M(){return!(!f||!f.getExtraData(w))}function E(n){if(M())if(function(e){var t=e&&!e.isHidden()&&e.loopData&&!e.loopData.resIndex;return t&&f.isFiltered()&&(t=!e.loopData.filtered),t}(n)){let a=n.loopData,l=f.getLoopKey(a);l!==i?(P(),s=l,r=a.state,i=s,s&&(x(s,r),T(s),function(e){e&&I(e,(function(e){e&&e.loopData&&e.setFillColor(v(e.loopData))}),(function(e){}))}(s)),o=_(a),D()):function(){if(t){var i=e.companions.zooming;if(t.isFittedToView)L(i),i.undoZoom();else{var o=t.getFitFrame(e.tr),n=i.getMinMax();if(o.minX<o.maxX){n.minX=o.minX,n.maxX=o.maxX;const e=N.getChartAreaPadding();n.maxX+e*(n.maxX-n.minX)<o.maxLabelX&&(n.maxX=(o.maxLabelX+n.minX*e)/(1+e))}n.minY=o.minY,o.maxY>n.maxY&&(n.maxY=o.maxY),i.setZoom(n),t.isFittedToView=!0,i.zoomChanged.subscribe(void 0,L),i.undoListChanged.subscribe(void 0,L)}}}()}else P();var s,r}function L(i){t&&t.isFittedToView&&(delete t.isFittedToView,(i=i||e.companions.zooming).zoomChanged.unsubscribe(void 0,L),i.undoListChanged.unsubscribe(void 0,L))}function R(e,t,i,o,n,l){let c,d;e=e||[],t&&(d=r.default.format(s.A.getMessage("roofline_bottleneck_roof_error"),t),e.length||(a.threadCount&&a.threadCount!==f.getThreadCount()?c=r.default.format(s.A.getMessage("roofline_bottleneck_different_core_count_error"),a.threadCount):i?o?c=r.default.format(s.A.getMessage("roofline_bottleneck_roof_is_hidden_error"),t):n||(c=s.A.getMessage(l?"roofline_bottleneck_total_point_error":"roofline_bottleneck_point_error")):c=s.A.getMessage("roofline_bottleneck_roof_not_fount_error")));let p=e.concat(c||[]);return p.length&&(d&&p.unshift(d),u.toast(p.join(u.lineBreak+u.lineBreak))),p}function D(){if(!a)return;let i;if(e&&e.currentPoint&&a.loop&&_(e.currentPoint.loopData)==n){let t=e.currentPoint,o=a.loop;o.roof.name&&(i=e.companions.roofsRepresentation.removeSingleThreadedCaption(o.roof.name),t.loopData.boundedBy=i,o.utilization&&(t.loopData.boundedByUtil=o.utilization.name+": "+o.utilization.val+o.utilization.measure),h.send("loopBottleneckChanged",t))}t&&o===n&&(i&&(a.loop.color=g(i),function(t){let i=!1;return e.companions.roofsRepresentation.representations.forEach((function(e){e&&t===e.caption&&e.roofData&&!e.roofData.isMem&&(e.setStyle(y(e.caption)),i=!0)})),i}(i)&&(l=i)),t.createBottleneck(e,a,f.getRoofs(),R))}const k="memoryMetricsSection",O="memoryMetrics";function z(t,i){if(e){var o=e.companions.get("sidePanel"),n=e.companions.get(k);if(o&&(!n||t)){let t="Memory Metrics";if(i&&i.explanation&&(t=`<span>${t}</span><span class="idvc2_roofline_explanation_symbol" data-tooltip="${i.explanation}">?</span>`),n)o.setSectionCaption(O,t);else{(n=o.addSection(t,O)).content&&(n.content.id="memoryMetricsSection");var s=se.A.create(n.content);e.companions.add(k,s),n=s}}return n}}function B(e){var t=e.target;t&&t.roofLinePoint?E(t.roofLinePoint):P()}function V(t){if(32===t.keyCode||13===t.keyCode){var i=e.currentPoint;i&&E(i)}else 27===t.keyCode&&P()}function G(){M()&&T(i)}return{setRoofline:function(t){e&&(e.centralPart.body.removeEventListener("dblclick",B),e.companions.viewParent.removeEventListener("keydown",V),f=void 0,d=void 0,u=void 0,h=void 0,m=void 0),(e=t)&&(e.centralPart.body.addEventListener("dblclick",B),e.companions.viewParent.addEventListener("keydown",V),f=e.companions.rooflineData,d=e.companions.stateManagerModule.get(),u=e.companions.uiUtils,(h=e.companions.events).recv("rooflineCleared",(function(){M()&&A(!1),i=void 0,ne.A.clear()})),h.recv("currentPointChanged",(function(e){if(P(),M()){let r;if(a=void 0,e&&(r=_(e.loopData),n=r,r)){var t=f.getThreadCount(),i=Number(!!d.getState().useSTRoofsStrategy),o=f.getPackageCount();p.Ay.sendNotification(m("getLoopAdditionalInfo:"+JSON.stringify({id:r,threadCount:t,useSTRoofsStrategy:i,packageCount:o})))}if(!r){var s=z();s&&s.clear()}}})),h.recv("zoomFrameChanged",G),h.recv("rooflineResized",G),h.recv("loopChangingState",(function(){A(!0)})),h.recv("loopChangedState",(function(t){var o,n=e.currentPoint;n&&(o=n.loopData)&&!n.isHidden()&&f.getLoopKey(o)===i&&(x(i,o.state),D(),t.forEach((function(e){e.rooflinePoint&&e.rooflinePoint.setFillColor(v(e))})))})),m=e.companions.mn,p.Ay.addConsumer(m("rooflineAdditionalDataLoopData"),{process:function(e){ie(e,f,h,d)}}),p.Ay.addConsumer(m("loopAdditionalInfo"),{process:function(e){if(e){if(Array.isArray(e)){if(!e.length)return;e=e[0]}e.id!==n&&e.id||((a=e.bottleneck).threadCount=e.threadCount,D(),function(e){var t=z(!0,e);if(t){if(!e)return void t.clear();t.setData(e.metrics)}}(e.memoryMetrics))}}}))},unload:function(){this.setRoofline(void 0)}}}},ae={getId:function(){return"integratedDumbbellLines"},create:function(){var e,t,i,o,n,a;const l="shadowLoops";let c={},d=[];function u(i){if(!Array.isArray(i))return;let o;function s(e){if(!e)return;function t(e,t){return void 0!==e&&void 0!==t&&Math.abs(e-t)<1e-5}const i=t(e.x,o.x)&&t(e.y,o.y),n=t(e.x1,o.x)&&t(e.y1,o.y);return i||n}const r=n.isFiltered();d=[],i.forEach((i=>{const{id:p,bottleneck:u}=i,h=c[p];if(!h)return;let g=u.loop;o=g;const _=function(t){if(!t)return;function i(e,t,i){i=i||(e=>!0);const o=[];return n.forEachLoopsSimple(t,(t=>{r&&t.filtered||!i(t)||n.getLoopKey(t)===e&&o.push({loopData:t,color:S.A.getIntegratedRooflineColor(C.A.getLoopMemoryLevel(n.getMemoryLevelPrefix(t))),position:n.getLoopPosition(t)})})),o}const o=i(t,n.getLoops()),a=i(t,n.getExtraData(l)||[],s);return ne.A.create(e,o,a)}(n.getLoopKey(h));_&&(a=i.threadCount,g.roof.name&&(h.boundedBy=e.companions.roofsRepresentation.removeSingleThreadedCaption(g.roof.name),t.send("loopBottleneckChanged",h.rooflinePoint),u.loop.color=f(h.boundedBy)),_.createBottleneck(e,u,n.getRoofs(),m)&&(d.push(h.boundedBy),v(h.boundedBy)))})),c={}}function h(){d.forEach(v)}function m(e,t,i,o,l,c){let d,p;if(e=e||[],t){if(p=r.default.format(s.A.getMessage("roofline_bottleneck_roof_error"),t),i&&!o&&(l||c))return[];e.length||(a&&a!==n.getThreadCount()?d=r.default.format(s.A.getMessage("roofline_bottleneck_different_core_count_error"),a):i?o?d=r.default.format(s.A.getMessage("roofline_bottleneck_roof_is_hidden_error"),t):l||(d=s.A.getMessage(c?"roofline_bottleneck_total_point_error":"roofline_bottleneck_point_error")):d=s.A.getMessage("roofline_bottleneck_roof_not_fount_error"))}let u=e.concat(d||[]);return u.length&&p&&u.unshift(p),u}function f(e){return S.A.getIntegratedRooflineColor(S.A.getRoofMemoryLevel(e))||S.A.CalcRoofsColor}function v(t){e.companions.roofsRepresentation.representations.forEach((function(e){e.roofData&&t===e.caption&&e.setStyle(function(e){if(e){var t=f(e)+" !important;";return{line:"stroke:"+t,text:"fill:"+t}}}(e.caption))}))}return{setRoofline:function(s){e&&(n=void 0,t=void 0,i=void 0,o=void 0),(e=s)&&(n=e.companions.rooflineData,t=e.companions.events,i=e.companions.stateManagerModule.get(),e.companions.uiUtils,t.recv("zoomFrameChanged",h),t.recv("rooflineResized",h),o=e.companions.mn,p.Ay.addConsumer(o("rooflineAdditionalDataLoopData"),{process:function(e){ie(e,n,t,i)&&function(){if(!n||!n.getExtraData(l))return;const e=[];if(n.forEachLoopsSimple(n.getLoops(),(t=>{if(t){const i=function(e){if(e&&!e.resIndex)return e.id}(t);i&&(e.push(i),c[i]=t)}})),!e.length)return;const t=n.getThreadCount(),s=Number(!!i.getState().useSTRoofsStrategy),r=n.getPackageCount();p.Ay.sendNotification(o("getLoopAdditionalInfo:"+JSON.stringify({id:e.join(","),threadCount:t,useSTRoofsStrategy:s,packageCount:r})))}()}}),p.Ay.addConsumer(o("loopAdditionalInfo"),{process:function(i){const o=c;u(i),e.companions.roofsRepresentation.representations.forEach((function(e){e&&e.roofData&&!function(e){return e.roofData.selected||d.indexOf(e.caption)>=0}(e)?e.roofData.removed=!0:e&&e.roofData&&delete e.roofData.removed})),t.send("rooflineDataUpdated",{isOldData:!0,isNewRoofs:!0}),c=o,u(i)}}))},setOn:function(){},getGuidanceInfo:function(){},unload:function(){this.setRoofline(void 0)}}}},le={getId:function(){return"zones"},create:function(){var e,t,i=1;const o="data-zone-tooltip",n="useZoneColoring";var r,a,l,c,d=function(){var n="scalar",r="vector",l="none",d=l;function p(e,t,i,o,n,s){this.text=e,this.textDescription=t,this.textRect=void 0,this.points=void 0,this.fillColor=i,this.opacity=o,this.textLineElem=void 0,this.textLineContent=void 0,this.poly=void 0,this.calcPoints=n,this.calcRect=s}function u(t){if(!t||2!==t.length)return;const n=t[1][0]-t[0][0];if(n<=Number.EPSILON)return!1;if(n>10*i){if(this.textLineElem)this.textLineElem.show();else{const t=function(t,i){const n="http://www.w3.org/1999/xhtml",s=e.getBackgroundLayer().createForeignObject();let r;if(s){s.setClass("zone_text_root").activate();const e=document.createElementNS(n,"div");if(e.className="zone_text_container",r=document.createElementNS(n,"span"),r.className="zone_text_caption",r.innerText=t,e.appendChild(r),i){const t=document.createElementNS(n,"span");t.className="zone_text_explanation",t.innerText="?",t.setAttribute(o,i),e.appendChild(t)}s.appendChild(e)}return{elem:s,textSpan:r}}(this.text,this.textDescription);this.textLineElem=t.elem,this.textLineContent=t.textSpan}if(!this.textLineElem)return;const s=4*i,r=t[0][0]+s,a=t[1][1]-s;!function(e,t,o,n){if(!e)return;const s=12*i;e.setX(t).setY(o-20-s).setWidth(n).setHeight(20)}(this.textLineElem,r,a,n-2*s)}else this.textLineElem&&this.textLineElem.hide();return!0}function h(t){this.poly||(this.poly=e.getBackgroundLayer().createPolygon().setAttr("fill",this.fillColor).setStyle("opacity:"+this.opacity)),this.poly.setPoints(t).back()}p.prototype.calculate=function(e){this.calcPoints&&this.calcRect&&(this.points=this.calcPoints(e),this.textRect=this.calcRect(this.points))},p.prototype.setText=function(e){this.text=e,this.textLineContent&&(this.textLineContent.innerText=e)},p.prototype.draw=function(){function t(t){if(t)return t.map((function(t){if(t&&2===t.length)return[e.tr.L2PX(t[0]),e.tr.L2PY(t[1])]})).filter((function(e){return!!e}))}this.points&&!(this.points.length<3)&&e&&e.tr&&u.call(this,t(this.textRect))?h.call(this,t(this.points)):this.clear(!0)},p.prototype.clear=function(e){e&&(this.poly&&this.poly.remove(),this.textLineElem&&this.textLineElem.remove()),this.textLineElem=void 0,this.textLineContent=void 0,this.poly=void 0};var m=[];function f(){if(!1===a.getState().useZoneColoring)return!1;var e=!1,i=t.getRooflineData();if(i&&(e=void 0!==i.minIntens&&void 0!==i.maxIntens&&void 0!==i.minPerf&&void 0!==i.maxPerf),!e)return!1;var o=t.getRoofs();return o.some((e=>e.isMem))&&o.some((e=>!e.isMem))}const v=N.getChartAreaPadding();function g(){var t,i,o,n,s=e.companions.zooming.getMinMax();if(s){let e=s.minX,r=s.maxX,a=s.minY,l=s.maxY,c=r-e,d=l-a;t=e-v*c,i=r+v*c,o=a-v*d,n=l+v*d}return{minIntens:t,maxIntens:i,minPerf:o,maxPerf:n}}function _(e){return e&&e.getMax(S.A.getTopSelectedRoof(t.getRoofs(),!1))}function y(e){return e&&e.getMin(S.A.getBottomComputeRoof(t.getRoofs(),!0))}function b(e){return e&&e.getMin(S.A.getTopSelectedRoof(t.getRoofs(),!1,!0))}function w(e){return e&&e.getMax(S.A.getBottomComputeRoof(t.getRoofs(),!1))}function x(e){return e&&e.getMax(S.A.getTopSelectedRoof(t.getRoofs(),!1,!0))}function C(e){var i=e&&e.getLeftBottom(),o=function(e){if(e){var t=g(),i=t.minPerf,o=t.minIntens;return e.forEach((function(e){if(e&&!e.hidden&&e.isMem){var t=e.val+o;t>i&&(i=t)}})),i}}(t.getRoofs());if(i&&o){var n=g(),s=[i.x,i.y],a=[n.minIntens,n.minPerf],l=[n.minIntens,o];if(d===r){var c=y(e);if(!c)return;s=[c.x,c.y]}return[[a[0],a[1]],[a[0],l[1]],[s[0],s[1]],[s[0],a[1]]]}}function A(e){var i=e&&e.getLeftBottom(),o=function(e){return e&&e.getMin(S.A.getTopSelectedRoof(t.getRoofs(),!1))}(e),s=_(e);if(d===r)i=y(e),o=b(e),s=x(e);else if(d===n){var a=w(e);a&&(s=a,o=a)}else o=b(e),s=x(e);if(i&&o&&s){var l=g().minPerf;return[[i.x,l],[i.x,i.y],[o.x,o.y],[s.x,s.y],[s.x,l]]}}function T(e){var i,o=_(e);if(d===n?i=S.A.getBottomComputeRoof(t.getRoofs(),!1):o=x(e),o){var s=o.y;i&&(s=i.val);var r=[o.x,s];if(d===n){var a=w(e);if(o=_(e),a&&o){var l=o.y;a&&(l=a.y),r=[a.x,l]}}var c=g(),p=c.minPerf;return[[r[0],p],r,[c.maxIntens,s],[c.maxIntens,p]]}}function I(e){if(e&&!(e.length<4))return[[e[0][0],e[2][1]],[e[2][0],e[0][1]]]}function P(e){if(e&&!(e.length<5))return[[e[1][0],e[1][1]],[e[4][0],e[4][1]]]}function M(e){if(e&&!(e.length<4))return[[e[1][0],e[1][1]],[e[3][0],e[3][1]]]}function E(e){m.forEach((function(t){t&&t.clear(e)}))}function L(e){(e||f())&&m.forEach((function(e){e&&e.draw()}))}function R(){m&&3==m.length&&(d===r?(m[0].setText(s.A.getMessage("roofline_zone_vector_memory_bound")),m[2].setText(s.A.getMessage("roofline_zone_compute_bound"))):d===n?(m[0].setText(s.A.getMessage("roofline_zone_memory_bound")),m[2].setText(s.A.getMessage("roofline_zone_scalar_compute_bound"))):(m[0].setText(s.A.getMessage("roofline_zone_memory_bound")),m[2].setText(s.A.getMessage("roofline_zone_compute_bound"))))}function D(){L(!1)}var k={refresh:function(){f()?(function(){const e=new S.A.RoofsCrossingManager(t.getRoofs());m.length||(m=[new p(s.A.getMessage("roofline_zone_memory_bound"),s.A.getMessage("roofline_zone_memory_description"),"rgb(240, 50, 50)",.06,C,I),new p(s.A.getMessage("roofline_zone_mixed_bound"),s.A.getMessage("roofline_zone_mixed_description"),"rgb(200, 40, 40)",.1,A,P),new p(s.A.getMessage("roofline_zone_compute_bound"),s.A.getMessage("roofline_zone_compute_description"),"rgb(160, 30, 30)",.14,T,M)]),m.forEach((function(t){t&&t.calculate(e)}))}(),R(),L(!0)):E(!0)},clear:E,initEvents:function(){c.recv("rooflineCleared",k.clear,k),c.recv("rooflineResized",D,k),c.recv("roofsCreated",k.refresh,k),c.recv("roofsUpdated",k.refresh,k),c.recv("roofVisibilityChanged",k.refresh,k),c.recv("roofSelectionChanged",k.refresh,k),c.recv("changedPerspective",O),c.recv("zoomFrameChanged",k.refresh,k),c.recv("zoomFrameMoved",(function(e){e||k.refresh()}))}};function O(e){d="1"==e?r:"2"==e?n:l,R(),k.refresh()}return k}();function p(e){return e&&e.hasAttribute(o)}function u(e){if(p(e))return e.getAttribute(o)}function h(e){d.refresh()}return{setRoofline:function(i){t=(e=i).companions.rooflineData,a=e.companions.stateManagerModule.get(),l=e.companions.contextMenu,e.companions.uiUtils.addTooltipProcessor({accept:p,getText:u}),c=e.companions.events,d.initEvents()},setScale:function(e){i=e},setOn:h,getGuidanceInfo:function(){var e;return r||(e=a.getState(),r={settingName:n,imageUrl:"icons/guidances-preview-0-170x110.png",imageOrder:0,defaultVal:!0,caption:"roofline_toolbar_guidance_zones",expl:"roofline_toolbar_guidance_zones_expl"},e&&void 0!==e[n]?r.value=e[n]:r.value=r.defaultVal,te(l,(function(){return{caption:!1===r.value?s.A.getMessage("roofline_menu_show_zones_enable"):s.A.getMessage("roofline_menu_show_zones_disable"),command:function(){r.value=!r.value,a.save(n)},type:"guidance"}})),a.addProcessor(n,{apply:function(e){var t=!0;e&&void 0!==e[n]&&(t=e[n]),r.value=t,h(r.value)},saveState:function(e){e[n]=r.value,h(r.value)}})),r}}}},ce={getId:function(){return"loopsMatchingLine"},create:function(){var e,t,i,o,n=1,a="black";const l="loops_matching_arrow",d="idvc2_roofline_loops_matching_label";function p(t,i,o,n,s){if(!(t.length<2)){var r=t[0].x,a=t[0].y,l=t[1].x,c=t[1].y;this.line=e.getForegroundLayer().addLine(r,a,l,c,s.line),this.line.setStyle("marker-end:"+this.line.localUrl(i.arrow)),this.text=e.getForegroundLayer().createText(o).setClass(s.caption).setStyle("text-anchor: middle;").activate(),u(this.text,r,a,l,c),this.text.el.tooltip=n}}function u(t,i,o,s,r){if(t){i>s&&([i,s]=[s,i],[o,r]=[r,o]);var l,c=Math.atan2(r-o,s-i),d=4*n,p=(i+s)/2+d*Math.sin(c),u=(o+r)/2-d*Math.cos(c),f=t.getBoundingRect().width,v=Math.sqrt(Math.pow(s-i,2)+Math.pow(r-o,2));f>v&&(h||(e.centralPart.graphicsRoot.createDefs("TextEllipsisTemplateDefs").createLinearGradient("TextEllipsisTemplate").setY1("0").setY2("0").setX1("0").setX2("1").addStop("0%",a,"0").addStop("20%",a,"1").addStop("85%",a,"1").addStop("100%",a,"0"),h=!0),l=function(t){t<.1&&(t=.1);var i="TextEllipsis_"+Math.floor(10*t);if(!m.has(i)){var o=