#!/bin/sh
# shellcheck shell=sh
# shellcheck source=/dev/null
# shellcheck disable=SC2312

# Copyright © 2023 Intel Corporation
# SPDX-License-Identifier: MIT

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.


# ############################################################################

# This etc/compiler/vars.sh script is intended to be _sourced_ directly
# by the top-level setvars.sh script. This vars.sh script is not a stand-alone
# script. A component-specific vars.sh script is only required if the top-level
# global environment variables defined by setvars.sh are insufficient for the
# component that is providing this vars.sh script. For example, if a special
# ${CMPLR_OPT_ROOT} variable needs to be defined or some other
# component-unique env vars are needed. It is possible that a component needs to
# augment the top-level global env vars because some of the component's files
# are in unusual locations that are not referenced by the global environment
# variables defined by setvars.sh.

# NOTE: See the setvars.sh script for a list of the top-level environment
# variables that it is providing. Also, if a comoponent vars.sh script must
# augment an existing environment variable it should use the prepend_path() and
# prepend_manpath() functions that are provided by setvars.sh. If it is not
# sourced by setvars.sh this test should generate an error message and may
# generate unkown function

# ############################################################################

prep_icd_for_eval() {
  echo "$1" | sed 's/:/\n/g' | awk 'NF' | sed -e "s/^/'/g" -e "s/$/' \\\/g" -e '$s/\\$//'
}

if [ -z "${SETVARS_CALL:-}" ] ; then
  >&2 echo " "
  >&2 echo ":: ERROR: This script must be sourced by setvars.sh."
  >&2 echo "   Try 'source <install-dir>/setvars.sh --help' for help."
  >&2 echo " "
  return 255
fi

if [ -z "${ONEAPI_ROOT:-}" ] ; then
  >&2 echo " "
  >&2 echo ":: ERROR: This script requires that the ONEAPI_ROOT env variable is set."
  >&2 echo "   Try 'source <install-dir>\setvars.sh --help' for help."
  >&2 echo " "
  return 254
fi


# ############################################################################
CMPLR_ROOT="${ONEAPI_ROOT}"; export CMPLR_ROOT
CMPLR_OPT_ROOT="${ONEAPI_ROOT}/opt/compiler"
USE_INTEL_LLVM="$(expr "${SETVARS_ARGS:-}" : '^.*\(--include-intel-llvm\)')" || true ;

# Compiler additional required PATH
if [ "${USE_INTEL_LLVM}" = "--include-intel-llvm" ]; then
  PATH=$(prepend_path "${ONEAPI_ROOT}/bin/compiler" "${PATH:-}") ; export PATH
fi

LD_LIBRARY_PATH=$(prepend_path "${CMPLR_OPT_ROOT}/lib" "${LD_LIBRARY_PATH:-}") ; export LD_LIBRARY_PATH
NLSPATH=$(prepend_path "${ONEAPI_ROOT}/lib/compiler/locale/%l_%t/%N" "${NLSPATH:-}") ; export NLSPATH

# Backup GPU runtime path to variable $gpu_icd_tmp_path and unset OCL_ICD_FILENAMES if GPU runtime is set before this vars.
if [ -n "${OCL_ICD_FILENAMES:-}" ]; then
  gpu_icd_tmp_path=
  eval set -- "$(prep_icd_for_eval "${OCL_ICD_FILENAMES}")"
  for icd_tmp_path do
      case "${icd_tmp_path}" in
        *"libigdrcl.so"*)
          gpu_icd_tmp_path="${icd_tmp_path:-}"
          ;;
      esac
  done
  unset OCL_ICD_FILENAMES
fi

if [ -z "${OCL_ICD_FILENAMES}" ]; then
  OCL_ICD_FILENAMES="${ONEAPI_ROOT}/lib/libintelocl.so"
else
  OCL_ICD_FILENAMES="${OCL_ICD_FILENAMES}:${ONEAPI_ROOT}/lib/libintelocl.so"
fi
# The order in OCL_ICD_FILENAMES should be: 1) CPU runtime; 2) GPU runtime.
if [ -n "${gpu_icd_tmp_path:-}" ]; then
  OCL_ICD_FILENAMES="${OCL_ICD_FILENAMES}:${gpu_icd_tmp_path}"
fi
export OCL_ICD_FILENAMES

