/*******************************************************************************
* Copyright (C) 2005 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
 *
 * fftwf_plan_many_dft - FFTW3 wrapper to Intel(R) oneAPI Math Kernel Library (Intel(R) oneMKL).
 *
 ******************************************************************************
 */

#include "fftw3_mkl.h"
#ifdef DFT_ENABLE_OFFLOAD
#include "oneapi/mkl/export.hpp"
#include "fftw3_omp_offload_common.h"

DLL_EXPORT fftwf_plan
fftwf_plan_many_dft_omp_offload(int rank, const int *n, int howmany, fftwf_complex *in,
                                const int *inembed, int istride, int idist,
                                fftwf_complex *out, const int *onembed, int ostride,
                                int odist, int sign, unsigned flags, void *interopObj)
#else
fftwf_plan
fftwf_plan_many_dft(int rank, const int *n, int howmany, fftwf_complex *in,
                   const int *inembed, int istride, int idist,
                   fftwf_complex *out, const int *onembed, int ostride,
                   int odist, int sign, unsigned flags)
#endif
{
    fftwf_iodim64 dims64[MKL_MAXRANK];
    fftwf_iodim64 howmany64;
    int i;

    if (rank > MKL_MAXRANK)
        return NULL;

    if (n == NULL)
        return NULL;

    for (i = 0; i < rank; ++i)
    {
        dims64[i].n = n[i];
    }
    if (rank > 0)
    {
        dims64[rank - 1].is = istride;
        dims64[rank - 1].os = ostride;
    }
    if (!inembed)
        inembed = n;
    if (!onembed)
        onembed = n;
    for (i = rank - 1; i > 0; --i)
    {
        dims64[i - 1].is = dims64[i].is * inembed[i];
        dims64[i - 1].os = dims64[i].os * onembed[i];
    }

    howmany64.n = howmany;
    howmany64.is = idist;
    howmany64.os = odist;

#ifdef DFT_ENABLE_OFFLOAD
    if(mkl_dfti_is_ilp64 == 0)
      return fftwf_plan_guru64_dft_omp_offload_impl_lp64(rank, dims64, 1, &howmany64,
                                                   in, out, sign, flags, interopObj);
    else
      return fftwf_plan_guru64_dft_omp_offload_impl_ilp64(rank, dims64, 1, &howmany64,
                                                   in, out, sign, flags, interopObj);
#else
    return fftwf_plan_guru64_dft(rank, dims64, 1, &howmany64, in, out, sign,
                                flags);
#endif
}
