/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#pragma OPENCL EXTENSION cl_khr_fp16 : enable

// Add2H 0Gr:0h/0Gr:0h/0Gw:0h 53760000 0 1
__kernel void Add2H(__global half *pA, __global half *pB, __global half *pC)
{
    const int id = get_global_id(0);

    half a = pA[id];
    half b = pB[id];
    half c = a;
    half d = b;
    half e = a;
    half f = b;
    half g = a;
    half h = b;
    half i = a;
    half j = b;
    half k = a;
    half l = b;
    half m = a;
    half n = b;
    half o = a;
    half p = b;
    half q = a;
    half r = b;
    half s = a;
    half t = b;
    half u = a;
    half v = b;
    half w = a;

    for (int count = 0; count < 640; count++)
    {
        b = b + a;
        c = c + a;
        d = d + a;
        e = e + a;
        f = f + a;
        g = g + a;
        b = b + a;
        c = c + a;
        d = d + a;
        e = e + a;
        f = f + a;
        g = g + a;
        b = b + a;
        c = c + a;
        d = d + a;
        e = e + a;
        f = f + a;
        g = g + a;
    }
    pC[id] = b + c + d + e + f + g;
}
