/*******************************************************************************
 * Copyright 2018 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *
 *******************************************************************************/

#ifndef PISIMPLEARITHMC_TL_H__
#define PISIMPLEARITHMC_TL_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_tl.h"
#include "owni_tl.h"

#ifdef USE_OMP
  #include <omp.h>
#endif

#ifdef USE_OMP
  /* minimal number of addition operations for threading */
  #define IPP64_MIN_ADD_2D 128 * 128
#elif defined(USE_TBB)
  /* minimal number of addition operations for threading */
  #define IPP64_MIN_ADD_2D 128 * 128
#else
  /* threading is not applied */
  #define IPP64_MIN_ADD_2D IPP_MAX_32S
#endif

/* ////////////////////////////////// SAC_8u ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmeticsC_C1_8u_LT_Str {
    Ipp8u *pSrc; // const
    IppSizeL srcStep;
    Ipp8u value;
    Ipp8u *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmeticsC_C1_8u_LT_Str;

static void simpleArithmeticsC_C1_ThreadingStructureEncode_8u(Ipp8u *pSrc, IppSizeL srcStep, Ipp8u value, Ipp8u *pDst, IppSizeL dstStep,
                                                              IppiSizeL roiSize, int scaleFactor, IppiPointL splitImage, IppiSizeL tileSize,
                                                              IppiSizeL tailSize, ippiSimpleArithmeticsC_C1_8u_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

typedef struct _ippiSimpleArithmeticsC_CX_8u_LT_Str {
    Ipp8u *pSrc; // const
    IppSizeL srcStep;
    Ipp8u *value; // const [X]
    Ipp8u *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmeticsC_CX_8u_LT_Str;

static void simpleArithmeticsC_CX_ThreadingStructureEncode_8u(Ipp8u *pSrc, IppSizeL srcStep, Ipp8u *value, Ipp8u *pDst, IppSizeL dstStep,
                                                              IppiSizeL roiSize, int scaleFactor, IppiPointL splitImage, IppiSizeL tileSize,
                                                              IppiSizeL tailSize, ippiSimpleArithmeticsC_CX_8u_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

/* ////////////////////////////////// SAC_16u ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmeticsC_C1_16u_LT_Str {
    Ipp16u *pSrc; // const
    IppSizeL srcStep;
    Ipp16u value;
    Ipp16u *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmeticsC_C1_16u_LT_Str;

static void simpleArithmeticsC_C1_ThreadingStructureEncode_16u(Ipp16u *pSrc, IppSizeL srcStep, Ipp16u value, Ipp16u *pDst, IppSizeL dstStep,
                                                               IppiSizeL roiSize, int scaleFactor, IppiPointL splitImage, IppiSizeL tileSize,
                                                               IppiSizeL tailSize, ippiSimpleArithmeticsC_C1_16u_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

typedef struct _ippiSimpleArithmeticsC_CX_16u_LT_Str {
    Ipp16u *pSrc; // const
    IppSizeL srcStep;
    Ipp16u *value; // const [X]
    Ipp16u *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmeticsC_CX_16u_LT_Str;

static void simpleArithmeticsC_CX_ThreadingStructureEncode_16u(Ipp16u *pSrc, IppSizeL srcStep, Ipp16u *value, Ipp16u *pDst, IppSizeL dstStep,
                                                               IppiSizeL roiSize, int scaleFactor, IppiPointL splitImage, IppiSizeL tileSize,
                                                               IppiSizeL tailSize, ippiSimpleArithmeticsC_CX_16u_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

/* ////////////////////////////////// SAC_16s ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmeticsC_C1_16s_LT_Str {
    Ipp16s *pSrc; // const
    IppSizeL srcStep;
    Ipp16s value;
    Ipp16s *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmeticsC_C1_16s_LT_Str;

static void simpleArithmeticsC_C1_ThreadingStructureEncode_16s(Ipp16s *pSrc, IppSizeL srcStep, Ipp16s value, Ipp16s *pDst, IppSizeL dstStep,
                                                               IppiSizeL roiSize, int scaleFactor, IppiPointL splitImage, IppiSizeL tileSize,
                                                               IppiSizeL tailSize, ippiSimpleArithmeticsC_C1_16s_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

typedef struct _ippiSimpleArithmeticsC_CX_16s_LT_Str {
    Ipp16s *pSrc; // const
    IppSizeL srcStep;
    Ipp16s *value; // const [X]
    Ipp16s *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmeticsC_CX_16s_LT_Str;

static void simpleArithmeticsC_CX_ThreadingStructureEncode_16s(Ipp16s *pSrc, IppSizeL srcStep, Ipp16s *value, Ipp16s *pDst, IppSizeL dstStep,
                                                               IppiSizeL roiSize, int scaleFactor, IppiPointL splitImage, IppiSizeL tileSize,
                                                               IppiSizeL tailSize, ippiSimpleArithmeticsC_CX_16s_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

/* ////////////////////////////////// SAC_32f ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmeticsC_C1_32f_LT_Str {
    Ipp32f *pSrc; // const
    IppSizeL srcStep;
    Ipp32f value;
    Ipp32f *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
    Ipp32s nCh;
} ippiSimpleArithmeticsC_C1_32f_LT_Str;

static void simpleArithmeticsC_C1_ThreadingStructureEncode_32f(Ipp32f *pSrc, IppSizeL srcStep, Ipp32f value, Ipp32f *pDst, IppSizeL dstStep,
                                                               IppiSizeL roiSize, IppiPointL splitImage, IppiSizeL tileSize, IppiSizeL tailSize,
                                                               Ipp32s nCh, ippiSimpleArithmeticsC_C1_32f_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
    ts->nCh = nCh;
}

typedef struct _ippiSimpleArithmeticsC_CX_32f_LT_Str {
    Ipp32f *pSrc; // const
    IppSizeL srcStep;
    Ipp32f *value; // const [X]
    Ipp32f *pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    IppiPointL splitImage;
    IppiSizeL tileSize;
    IppiSizeL tailSize;
    Ipp32s nCh;
} ippiSimpleArithmeticsC_CX_32f_LT_Str;

static void simpleArithmeticsC_CX_ThreadingStructureEncode_32f(Ipp32f *pSrc, IppSizeL srcStep, Ipp32f *value, Ipp32f *pDst, IppSizeL dstStep,
                                                               IppiSizeL roiSize, IppiPointL splitImage, IppiSizeL tileSize, IppiSizeL tailSize,
                                                               Ipp32s nCh, ippiSimpleArithmeticsC_CX_32f_LT_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->value = value;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
    ts->nCh = nCh;
}
#endif // PISIMPLEARITHMC_TL_H__
