/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.juife.InformationDialog;
import org.jsampler.CC;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.Res;
import org.linuxsampler.lscp.ServerInfo;

public class SamplerInfoDlg
extends InformationDialog {
    private final JLabel lLinuxSamplerLogo = new JLabel(Res.iconLinuxSamplerLogo);
    private final JLabel lDescription = new JLabel();
    private final JLabel lVersion = new JLabel(ClassicI18n.i18n.getLabel("SamplerInfoDlg.lVersion"));
    private final JLabel lProtocolVersion = new JLabel(ClassicI18n.i18n.getLabel("SamplerInfoDlg.lProtocolVersion"));
    private final JLabel lDbSupport = new JLabel(ClassicI18n.i18n.getLabel("SamplerInfoDlg.lDbSupport"));
    private final JTextField tfVersion = new JTextField();
    private final JTextField tfProtocolVersion = new JTextField();
    private final JTextField tfDbSupport = new JTextField();

    public SamplerInfoDlg(Frame frame) {
        super(frame, ClassicI18n.i18n.getLabel("SamplerInfoDlg.title"));
        this.showCloseButton(false);
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        ServerInfo serverInfo = CC.getSamplerModel().getServerInfo();
        if (serverInfo == null) {
            jPanel.add(new JLabel(ClassicI18n.i18n.getLabel("SamplerInfoDlg.unavailable")));
            this.setMainPane(jPanel);
            return;
        }
        this.lDescription.setText(serverInfo.getDescription());
        this.tfVersion.setText(serverInfo.getVersion());
        this.tfProtocolVersion.setText(serverInfo.getProtocolVersion());
        if (serverInfo.hasInstrumentsDbSupport()) {
            this.tfDbSupport.setText(ClassicI18n.i18n.getButtonLabel("yes"));
        } else {
            this.tfDbSupport.setText(ClassicI18n.i18n.getButtonLabel("no"));
        }
        this.tfVersion.setEditable(false);
        this.tfVersion.setOpaque(false);
        this.tfVersion.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfProtocolVersion.setEditable(false);
        this.tfProtocolVersion.setOpaque(false);
        this.tfProtocolVersion.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfDbSupport.setEditable(false);
        this.tfDbSupport.setOpaque(false);
        this.tfDbSupport.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.lVersion, gridBagConstraints);
        jPanel2.add(this.lVersion);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lProtocolVersion, gridBagConstraints);
        jPanel2.add(this.lProtocolVersion);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lDbSupport, gridBagConstraints);
        jPanel2.add(this.lDbSupport);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfVersion, gridBagConstraints);
        jPanel2.add(this.tfVersion);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.tfProtocolVersion, gridBagConstraints);
        jPanel2.add(this.tfProtocolVersion);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.tfDbSupport, gridBagConstraints);
        jPanel2.add(this.tfDbSupport);
        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(this.lLinuxSamplerLogo);
        jPanel3.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel3.add(jPanel2);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        this.lDescription.setAlignmentX(0.0f);
        jPanel.add(this.lDescription);
        jPanel.add(Box.createRigidArea(new Dimension(0, 12)));
        jPanel.add(jPanel3);
        this.setMainPane(jPanel);
    }
}

