/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

export var relativeOptions = [{
  text: 'Seconds ago',
  value: 's'
}, {
  text: 'Minutes ago',
  value: 'm'
}, {
  text: 'Hours ago',
  value: 'h'
}, {
  text: 'Days ago',
  value: 'd'
}, {
  text: 'Weeks ago',
  value: 'w'
}, {
  text: 'Months ago',
  value: 'M'
}, {
  text: 'Years ago',
  value: 'y'
}, {
  text: 'Seconds from now',
  value: 's+'
}, {
  text: 'Minutes from now',
  value: 'm+'
}, {
  text: 'Hours from now',
  value: 'h+'
}, {
  text: 'Days from now',
  value: 'd+'
}, {
  text: 'Weeks from now',
  value: 'w+'
}, {
  text: 'Months from now',
  value: 'M+'
}, {
  text: 'Years from now',
  value: 'y+'
}];
var timeUnitIds = relativeOptions.map(function (_ref) {
  var value = _ref.value;
  return value;
}).filter(function (value) {
  return !value.includes('+');
});
export var relativeUnitsFromLargestToSmallest = timeUnitIds.reverse();